<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"> 
	<xsl:strip-space elements="*"/>
	<xsl:output method="xml" indent="no"/>
	<xsl:variable name="TotalEnumObjCount" select="count(//HIIEnumObj)"/>
	<xsl:variable name="TotalStringObjCount" select="count(//HIIStringObj)"/>
	<xsl:variable name="TotalIntegerObjCount" select="count(//HIIIntegerObj)"/>
	<xsl:variable name="TotalOrderedObjCount" select="count(//HIIOrderedListObj)"/>
	<xsl:variable name="FormEnumCount" select="count(//HIIEnumObj[(hdr/bSuppressed = 'false')])"/>
	<xsl:variable name="FormStringCount" select="count(//HIIStringObj[(hdr/bSuppressed = 'false')])"/>
	<xsl:variable name="FormIntegerCount" select="count(//HIIIntegerObj[(hdr/bSuppressed = 'false')])"/>
	<xsl:variable name="FormOrderedListCount" select="count(//HIIOrderedListObj[(hdr/bSuppressed = 'false')])"/>
	<xsl:variable name="setBIOS" select="/OMA/setBIOS"/>
	<xsl:variable name="ShutDownFlag" select="/OMA/HIIFQDDObj/hdr/bRebootNeeded"/>
	<xsl:variable name="PasswdProtected" select="/OMA/HIIFQDDObj/bPasswdProtected"/>
	<xsl:variable name="isSetPwd" select="/OMA/isSetPwd"/>
	<xsl:variable name="MaxDisplayIndex">
		<xsl:for-each select="/OMA/*[name() = 'HIIEnumObj' or name() = 'HIIStringObj' or name() = 'HIIIntegerObj']">
			<xsl:sort select="hdr/displayIndex" data-type="number" order="descending"/>
			<xsl:if test="position() = 1">
				<xsl:value-of select="hdr/displayIndex"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="bReadOnlyAllFlag" select="count(current()//HIIEnumObj/hdr/bReadOnly[.='true']) + count(current()//HIIStringObj/hdr/bReadOnly[.='true']) + count(current()//HIIIntegerObj/hdr/bReadOnly[.='true']) + count(current()//HIIOrderedListObj/hdr/bReadOnly[.='true'])"/>
	<xsl:variable name="totalObjCount" select="$TotalEnumObjCount + $TotalStringObjCount + $TotalIntegerObjCount + $TotalOrderedObjCount"/>
	<xsl:variable name="TotalFormObjCount" select="$FormEnumCount + $FormStringCount + $FormIntegerCount + $FormOrderedListCount"/>
	<xsl:template match="OMA">
		<xsl:choose>
			<xsl:when test="SMStatus and SMStatus != '0'"><xsl:call-template name="failure"/></xsl:when>
			<xsl:otherwise><xsl:call-template name="success"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="failure">
		<DataArea exportdata="false">
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strBIOSSetup"/></xsl:attribute>
			<xsl:attribute name="HIIBIOS">true</xsl:attribute>
			<xsl:attribute name="backpagetarget">./DataArea?plugin=com.dell.hip.webplugins.biossetupWebPlugin&amp;help=hiiBiosSetup</xsl:attribute>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strBIOSSetup"/></xsl:attribute>
			</PageTitle>
		
			<AlertMessage>
				<xsl:choose>
				<xsl:when test="SMStatus='4225'">
					<xsl:attribute name="display"><xsl:value-of select="$strPreSchedJobError"/></xsl:attribute>
					<xsl:attribute name="status">4</xsl:attribute>
				</xsl:when>
				<xsl:when test="SMStatus='4226'">
					<xsl:attribute name="display"><xsl:value-of select="$strPasswdError"/></xsl:attribute>
					<xsl:attribute name="status">4</xsl:attribute>
				</xsl:when>
				<xsl:when test="SMStatus='4227'">
					<xsl:attribute name="display"><xsl:value-of select="$strAttrSettError"/></xsl:attribute>
					<xsl:attribute name="status">4</xsl:attribute>
				</xsl:when>
				<xsl:when test="SMStatus='4228'">
					<xsl:attribute name="display"><xsl:value-of select="$strAttrSettError"/></xsl:attribute>
					<xsl:attribute name="status">4</xsl:attribute>
				</xsl:when>
				<xsl:when test="SMStatus='4229'">
					<xsl:attribute name="display"><xsl:value-of select="$strAttrReadOnlyError"/></xsl:attribute>
					<xsl:attribute name="status">4</xsl:attribute>
				</xsl:when>
				<xsl:when test="SMStatus='4233'">
					<xsl:attribute name="display"><xsl:value-of select="$strDepsError"/></xsl:attribute>
					<xsl:attribute name="status">4</xsl:attribute>
				</xsl:when>
				<xsl:when test="SMStatus='4234'">
					<xsl:attribute name="display"><xsl:value-of select="$strSystemBusyError"/></xsl:attribute>
					<xsl:attribute name="status">4</xsl:attribute>
				</xsl:when>			
				<xsl:when test="SMStatus='4236'">
					<xsl:attribute name="display"><xsl:value-of select="$strPasswdSetError"/></xsl:attribute>
					<xsl:attribute name="status">4</xsl:attribute>
				</xsl:when>		
				<xsl:otherwise>
					<xsl:attribute name="display"><xsl:value-of select="$strGenericError"/></xsl:attribute>
					<xsl:attribute name="status">4</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			</AlertMessage>	
		</DataArea>
	</xsl:template>

	<xsl:template name="success">
		<xsl:variable name="formOns" select="HIIFormObj/@ons"/>
		<DataArea  onLoad="true" exportdata="false">

		<!-- Check to see if the Back button needs to be hidden -->
			<xsl:choose>
				<xsl:when test="needBckButton='false'">
					<xsl:attribute name="HIIBIOS">true</xsl:attribute>
					<xsl:attribute name="validate">false</xsl:attribute>
					<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.hip.webplugins.setbiosobjWebPlugin&amp;button=false&amp;help=<xsl:value-of select="/OMA/HIIFormObj/hdr/Name"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="$PasswdProtected='true' and $isSetPwd = 'false' ">
					<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strBIOSSetup"/></xsl:attribute>
					<xsl:attribute name="HIIBIOS">true</xsl:attribute>
					<xsl:attribute name="validate">false</xsl:attribute>
					<xsl:attribute name="backpagetarget">./DataArea?plugin=com.dell.hip.webplugins.biossetupWebPlugin&amp;help=hiiBiosSetup</xsl:attribute>
				</xsl:when>
				<xsl:when test="$bReadOnlyAllFlag = $totalObjCount or $TotalFormObjCount='0'">
					<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strBIOSSetup"/></xsl:attribute>
					<xsl:attribute name="HIIBIOS">true</xsl:attribute>
					<xsl:attribute name="validate">false</xsl:attribute>
					<xsl:attribute name="backpagetarget">./DataArea?plugin=com.dell.hip.webplugins.biossetupWebPlugin&amp;help=hiiBiosSetup</xsl:attribute>
				</xsl:when>
				<xsl:when test="/OMA/HIIFormObj/hdr/Name ='BiosBootSettings' and /OMA/IsTrueAdmin !='true'">
					<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strBIOSSetup"/></xsl:attribute>
					<xsl:attribute name="HIIBIOS">true</xsl:attribute>
					<xsl:attribute name="validate">false</xsl:attribute>
					<xsl:attribute name="backpagetarget">./DataArea?plugin=com.dell.hip.webplugins.biossetupWebPlugin&amp;help=hiiBiosSetup</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strBIOSSetup"/></xsl:attribute>
					<xsl:attribute name="HIIBIOS">true</xsl:attribute>
					<xsl:attribute name="validate">true</xsl:attribute>
					<xsl:attribute name="backpagetarget">./DataArea?plugin=com.dell.hip.webplugins.biossetupWebPlugin&amp;help=hiiBiosSetup</xsl:attribute>
					
					<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.hip.webplugins.setbiosobjWebPlugin&amp;ons=<xsl:value-of select="$formOns"/>&amp;help=<xsl:value-of select="/OMA/HIIFormObj/hdr/Name"/>&amp;enumCount=<xsl:value-of select="$TotalEnumObjCount"/>&amp;stringCount=<xsl:value-of select="$TotalStringObjCount"/>&amp;integerCount=<xsl:value-of select="$TotalIntegerObjCount"/>&amp;orderedObjCount=<xsl:value-of select="$TotalOrderedObjCount"/>&amp;MaxDisplayIndex=<xsl:value-of select="$MaxDisplayIndex"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			
			<script language="javascript" > 
					
				
				var biosObjArray= new Array();
				var biosOrderedObjArray= new Array();
				var enumName;
				var numDependencies;
				var	objName;
				var objDisplayName;
				var valuename;
				var breadonly;
				var progReadOnlyLocal;
				
				function biosObject (objectType,objectName,displayName,htmlName,currentValue,breadonly,minLimit,maxLimit,isPassword,progReadOnlyLocal) {
				
					this.objectType			= objectType;
					this.objectName			= objectName;
					this.displayName		= displayName;
					this.htmlName			= htmlName;
					this.currentValue		= currentValue;
					this.breadonly			= breadonly;
					this.minLimit			= minLimit;
					this.maxLimit			= maxLimit;
					this.isPassword			= isPassword;
					this.progReadOnlyLocal	= progReadOnlyLocal;
					this.dependencies		= new Array();
					this.values				= new Array();
				}
				function biosOrderedListObject (objectType,objectName,displayName,htmlName,readonly,allowEnableEntry,numOrdListEntries,isTrueAdmin) {
					this.objectType		  = objectType;
					this.objectName		  = objectName;
					this.displayName	  = displayName;
					this.htmlName		  = htmlName;
					this.readonly		  = readonly;          //indicates if the orderedobject entries should be readonly or not
					this.allowEnableEntry = allowEnableEntry;  //indicates if the orderedobject should have checkbox entries or not
					this.numOrdListEntries= numOrdListEntries; //Number of entries ordered object has
					this.isTrueAdmin	  = isTrueAdmin; 		//if false then elevated admin so entries to be made readonly
					this.orderedEntriesList	= new Array();     // Array for list of entries for an orderedlist object
					
				}
				function orderedEntriesListObject (objectName,displayName,htmlName,readonly,enableCheckbox,biosMappingId,pendingValid,currentEnabled,pendingEnabled) {
					
					this.objectName		  = objectName;
					this.displayName	  = displayName;
					this.htmlName		  = htmlName;
					this.readonly		  = readonly;       // decides if the particular entry is readonly
					this.enableCheckbox   = enableCheckbox; // checkbox element
					this.biosMappingId    = biosMappingId;  // biosmappingid representing each entry
					this.pendingValid	  = pendingValid;   // pendingValid, currentEnabled, pendingEnabled decides if checkbox is enabled/disabled(if pendingvalid is true then state=pendingEnabled else currentEnabled)
					this.currentEnabled	  = currentEnabled; // 1-enabled 0-disabled
					this.pendingEnabled	  = pendingEnabled; // 1-enabled 0-disabled
				}
				
				function dependencyObject(dependencyName,dependencyValue,dependencyType) {
					this.dependencyName	=	dependencyName;
					this.dependencyValue=	dependencyValue;
					this.dependencyType	=	dependencyType;
				}
				
				function valueObject(valueName, valueState) {
					this.valueName		= valueName;					
					this.valueState		= valueState;
					this.dependencies	= new Array();
				}
				
				function createBiosObject(index,objType,objName,displayName,htmlName,valueName,breadonly,minLimit,maxLimit,isPassword,progReadOnlyLocal)
				{					
					biosObjArray[index]	= new biosObject(objType,objName,displayName,htmlName,valueName,breadonly,minLimit,maxLimit,isPassword,progReadOnlyLocal);					
				}
				
				function createValueObject(index,valueName, valueState)
				{					
					var valueCount = biosObjArray[index].values.length;	
					biosObjArray[index].values[valueCount] = new valueObject(valueName,valueState);					
					return biosObjArray[index].values[valueCount];
				}
				
				function createDependency(index,dependName,dependValue,dependType)
				{	
					var dependCount = biosObjArray[index].dependencies.length;	
					biosObjArray[index].dependencies[dependCount] = new dependencyObject(dependName,dependValue,dependType);					
				}

				function createValueDependency(valueObject,dependName,dependValue,dependType)
				{
					var dependCount = valueObject.dependencies.length;	
					valueObject.dependencies[dependCount] = new dependencyObject(dependName,dependValue,dependType);										
				}
				
					function createBiosOrderedListObject(index,objectType,objectName,displayName,htmlName,readonly,allowEnableEntry,numOrdListEntries,isTrueAdmin)
				{					
					biosOrderedObjArray[index]	= new biosOrderedListObject(objectType,objectName,displayName,htmlName,readonly,allowEnableEntry,numOrdListEntries,isTrueAdmin);					
				}
				
					function createOrderedEntriesObject(index,objectName,displayName,htmlName,readonly,enableCheckbox,biosMappingId,pendingValid,currentEnabled,pendingEnabled)
				{					
					var orderedCount = biosOrderedObjArray[index].orderedEntriesList.length;	
					biosOrderedObjArray[index].orderedEntriesList[orderedCount] = new orderedEntriesListObject(objectName,displayName,htmlName,readonly,enableCheckbox,biosMappingId,pendingValid,currentEnabled,pendingEnabled);				
					return biosOrderedObjArray[index].orderedEntriesList[orderedCount];
				}
				
				function computeDependencies()
				{
				   for (var i = 0; i &lt; biosObjArray.length; ++i )
					{
						verifyDependency(i,false);
					}					
				}
				
				
				
				function verifyDependency(index,userAction)
				{
					var biosObj 	= biosObjArray[index];
					var dependencies= biosObj.dependencies;			

					if(biosObj.breadonly=="true" &amp;&amp; userAction==false)
					{
						if ( biosObj.objectType == "Enum")
							disableradioElement(index,true);
						else
							disableEditBox(index,true);
							
					   return;
					}
					if ( dependencies.length == 0 )
						return;
					if(biosObj.progReadOnlyLocal == "false"){	//consider the dependencies only when progReadOnlyLocal is false
						// For all dependencies
						var dependIndex = 0;
						var disabled = false;
						var dependencyNotFoundCounter = 0;
						for ( dependIndex = 0; dependIndex &lt; dependencies.length; ++dependIndex )
						{
							var dependentObj  = dependencies[dependIndex];
							
							var dependentName = dependentObj.dependencyName;
							var dependentVal  = dependentObj.dependencyValue;
							var dependentType = dependentObj.dependencyType;
							
							var enumValueObj  = getBiosObj(dependentName);
							if (enumValueObj == null){
								dependencyNotFoundCounter = dependencyNotFoundCounter + 1;
									continue;
							}
							var enumValue 	  = enumValueObj.currentValue;
							if (enumValue == null){							
								dependencyNotFoundCounter = dependencyNotFoundCounter + 1;
								continue;
							}

							if ( ( (dependentVal == enumValue) &amp;&amp; (dependentType == 'ReadOnlyIf') ) 
							  || ( (dependentVal != enumValue) &amp;&amp; (dependentType == 'ReadOnlyIfNot') ) )
							{					
								disabled = true;
								if ( biosObj.objectType == "Enum" )
									disableradioElement(index,true);
								else
									disableEditBox(index,true);
								break;
							}									
						}
						if(disabled == false &amp;&amp; dependencyNotFoundCounter &lt; dependencies.length)
						{
							if ( biosObj.objectType == "Enum" )
								disableradioElement(index,false);
							else
								disableEditBox(index,false);
						}
					}
					
					for (var valIndex = 0; valIndex &lt; biosObj.values.length; ++valIndex )
					{				
						 var valObject = biosObj.values[valIndex];
						 var valDeps   = valObject.dependencies;
						
						if(valDeps.length == 0)
							continue;					 
						
						for(var valDependIndex = 0; valDependIndex &lt; valDeps.length; ++valDependIndex )
						{
							var valdependentObj  = valDeps[valDependIndex];	
							
							var valdependentName = valdependentObj.dependencyName;
							var enumValueObj	 = getBiosObj(valdependentName);
																					
							if (enumValueObj == null)
								continue;
								
							var enumValue 	     = enumValueObj.currentValue;
							var valdependentVal  = valdependentObj.dependencyValue;							
							var valdependentType = valdependentObj.dependencyType;
							
							if ( ( (valdependentVal == enumValue) &amp;&amp; (valdependentType == 'ForceIf') ) 
						      || ( (valdependentVal != enumValue) &amp;&amp; (valdependentType == 'ForceIfNot') ) )							
							{																
								setRadioElementState(biosObj.htmlName, valObject.valueState);
								break;
							}			
							
						}
					}
				}
				
			function disableEditBox(index,state)		
			{
				var passwdobj = biosObjArray[index].isPassword;
				if(passwdobj == 'true')
				{
					var editBoxes = document.getElementsByName("pwd_"+biosObjArray[index].htmlName);		
					var editBox   = null;

					if ( editBoxes.length > 0 )
						editBox = editBoxes[0];					
				
				
					var cnfrmPwdEditBoxes = document.getElementsByName("pwd_"+biosObjArray[index].htmlName+"_con");
					var cnfrmPwdEditBox   = null;
					
					if ( cnfrmPwdEditBoxes.length > 0 )
						cnfrmPwdEditBox = cnfrmPwdEditBoxes[0];
					if (state == true)
					{
						if(editBox!=null)
						{
							editBox.setAttribute('READONLY','READONLY'); 
							editBox.style.backgroundColor="#D3D3D3";
						}						
						if (cnfrmPwdEditBox!=null)	
						{
							cnfrmPwdEditBox.setAttribute('READONLY','READONLY'); 
							cnfrmPwdEditBox.style.backgroundColor="#D3D3D3";
						}
					}
					else					
					{						
						if(editBox!=null)
						{
							editBox.removeAttribute("READONLY",0);
							editBox.style.backgroundColor="#FFFFFF";
						}						
						if (cnfrmPwdEditBox!=null)	
						{
							cnfrmPwdEditBox.removeAttribute("READONLY",0);
							cnfrmPwdEditBox.style.backgroundColor="#FFFFFF";
						}
					}
				}
				else
				{
					var editBoxes = document.getElementsByName(biosObjArray[index].htmlName);		
					var editBox   = null;

					if ( editBoxes.length > 0 )
						editBox = editBoxes[0];					
					if(editBox!=null &amp;&amp; state==true)
						editBox.disabled=state;				
					else if(editBox!=null &amp;&amp; state==false)
						editBox.removeAttribute("disabled",0);
				}
				
			}
			function setRadioElementState(htmlName,stateNumber)		
			{	
				var radioElements = document.getElementsByName(htmlName);
				
				for(var k=0; k &lt; radioElements.length; k++)
				{	
					if((radioElements[k] != null) &amp;&amp; (radioElements[k].value == stateNumber))
					{	
						radioElements[k].checked = true;	
						break;
					}
				}
			}
			
			function disableradioElement(index,state)		
			{	
				var radioElements = document.getElementsByName(biosObjArray[index].htmlName);
				
				for(var k=0; k &lt; radioElements.length; k++)
				{		
					if(radioElements[k] != null)
					{	
						radioElements[k].disabled = state;
						
					}
				}
			}
			
			function getBiosObj(dependencyName)
			{  
				for( var k=0; k &lt; biosObjArray.length; ++k)
				{						
					if(biosObjArray[k].objectName == dependencyName)
					{
						return biosObjArray[k];
					}
				
				}
				return null;
			}
			
			function togglestate(userselectedname,userselectedvalue)
			{				
				modifyenumObjarray(userselectedname,userselectedvalue);
				for( var i=0;i &lt; biosObjArray.length;i++)
				{	
					verifyDependency(i,true);							
				}						
			}
			
			function editText(editboxName)
			{
				document.getElementById(editboxName+"_objSelect").value="true";
			}
			
			function modifyenumObjarray(userselectedname,userselectedvalue)
			{
				for( var i=0;i &lt; biosObjArray.length;i++)
				{
					if(biosObjArray[i].objectName ==userselectedname)
					{
						//modify with userselected value
						biosObjArray[i].currentValue = userselectedvalue;
						//if user has selected the attribute set a variable as true to be passed to plugin
						document.getElementById(biosObjArray[i].htmlName+"_objSelect").value="true";
						return;
					}
				}					
			}
			function validateStringIntegerObj()
			{
				var ret=true;
				for (var i = 0; i &lt; biosObjArray.length; ++i )
				{	
					if(biosObjArray[i].objectType!="Enum")
					ret= verifyStringIntegerBoundries(i);
				    if(!ret)
						break;
				}		
				
				return  ret;
			
			}
			function verifyStringIntegerBoundries(index)
			{
				var biosObj 	= biosObjArray[index];
				/*Fix for BITS141497 - Confirm password verification failing. Passwords have different naming Conventions than the other string parameters on the page. Replacing elementId where ever we were using biosObj.htmlName to fix the issue*/
				var elementId= biosObj.htmlName
				if(biosObj.isPassword=="true")
					elementId="pwd_"+biosObj.htmlName;
				var  stringIntegerValue;
				var alertMsg;
			
				if(document.getElementById(elementId)!=null &amp;&amp;document.getElementById(elementId).value!=null )
				{
					if ( biosObj.objectType == "String" )
					{
						stringIntegerValue=document.getElementById(elementId).value.length;
			 			alertMsg='<xsl:value-of select="$strStringRange"/>';
					}
					else
					{
						stringIntegerValue=parseInt(document.getElementById(elementId).value);
						alertMsg='<xsl:value-of select="$strIntegerRange"/>';
					}
					
					if(biosObj.currentValue!="isNullValue")	
					{
						if(	(biosObj.breadonly=='false') &amp;&amp; (!((stringIntegerValue &gt; biosObj.minLimit-1) &amp;&amp; (stringIntegerValue &lt; biosObj.maxLimit+1))))
						{	
							alert(biosObj.displayName+": "+alertMsg + biosObj.minLimit + '<xsl:value-of select="$strAnd"/>' + biosObj.maxLimit);
							document.getElementById(elementId).value = "";
							document.getElementById(elementId).focus();
							return false;
						}
					}
					if(biosObj.isPassword=="true")
					{
						var cfmPasswdval = document.getElementById(elementId+"_con").value;
						var passwdval    = document.getElementById(elementId).value;	
						if (passwdval != cfmPasswdval)
						{
							alert(biosObj.displayName+": "+'<xsl:value-of select="$strPasswordError"/>');
							document.getElementById(elementId+"_con").focus();
							return false;
						}
					}							
				}							
				return true;
								
							
			}
			function initializationRoutine()
				{
					var makeallreadonly ;
					var isTrueAdmin = '<xsl:value-of select="/OMA/IsTrueAdmin"/>';
					var passwdprotected = '<xsl:value-of select="$PasswdProtected"/>';
					var isSetPwd= '<xsl:value-of select="$isSetPwd"/>';
					var orderedParentOns;
					
					if ((passwdprotected == 'true') &amp;&amp; (isSetPwd == 'false'))
					{
						makeallreadonly = 'true';
					}
					var index=0;var numOfAttribs=0;var enumState;var enumValueState;var valuename;var minLimit;var maxLimit;
					
					<xsl:for-each select="//HIIEnumObj">
						<xsl:sort select="hdr/displayIndex" data-type="number" order="ascending"/>
							<xsl:variable name="enumName">EnumObj_name<xsl:value-of select="hdr/displayIndex"/></xsl:variable>
								enumName='<xsl:value-of select="$enumName"/>';
								<xsl:variable name="parentons"><xsl:value-of select="@ons"/></xsl:variable>
									<xsl:variable name="enumState">
									<xsl:choose>
											<xsl:when test="bPendingValid='true'">
												<xsl:value-of select="pendingState"/>
											</xsl:when>
											<xsl:otherwise>
											  <xsl:value-of select="currentState"/>
											</xsl:otherwise>
									</xsl:choose>
									</xsl:variable>
								objName='<xsl:value-of select="hdr/Name"/>';
								objDisplayName="<xsl:value-of select="hdr/DisplayName"/>";
								breadonly='<xsl:value-of select="hdr/bReadOnly"/>';								
								progReadOnlyLocal='<xsl:value-of select="hdr/progModifierBitMap/ProgReadOnlyLocal"/>';					
								
								<xsl:for-each select="//HIIEnumValueObj[substring-before(@ons,'/HIIEnumValueObj') = $parentons][stateNumber = $enumState]">
											valuename='<xsl:value-of select="Name"/>';
								 </xsl:for-each>
								 createBiosObject(index,"Enum",objName,objDisplayName,enumName,valuename,breadonly,null,null,null,progReadOnlyLocal);
								<xsl:for-each select="//HIIEnumValueObj[substring-before(@ons,'/HIIEnumValueObj') = $parentons]">
									var valName = '<xsl:value-of select="Name"/>';
									var stateNum = '<xsl:value-of select="stateNumber"/>';
									var valObj   = createValueObject (index, valName, stateNum);
									<xsl:if test="numDependencies &gt; 0">
										<xsl:for-each select="dependenciesarray/dependencies">	
											var dependname = '<xsl:value-of select="Name"/>';
											var dependvalue = '<xsl:value-of select="Value"/>';
											var dependtype = '<xsl:value-of select="Type"/>';
											createValueDependency(valObj,dependname,dependvalue,dependtype);
										</xsl:for-each>	
									</xsl:if>				
									
								</xsl:for-each>
								
								<xsl:if test="numDependencies &gt; 0">
									<xsl:for-each select="dependenciesarray/dependencies">	
										var dependname = '<xsl:value-of select="Name"/>';
										var dependvalue = '<xsl:value-of select="Value"/>';
										var dependtype = '<xsl:value-of select="Type"/>';
										createDependency(index,dependname,dependvalue,dependtype);
									</xsl:for-each>	
								</xsl:if>				
							index=index+1;
					 </xsl:for-each>					 
					 <xsl:for-each select="//HIIStringObj">
					 <xsl:variable name="stringName">StringObj_name<xsl:value-of select="hdr/displayIndex"/></xsl:variable>
						var stringname = '<xsl:value-of select="$stringName"/>';
						var passwdobj = '<xsl:value-of select="bPasswdObj"/>';
						objName='<xsl:value-of select="hdr/Name"/>';
						objDisplayName="<xsl:value-of select="hdr/DisplayName"/>";
						breadonly='<xsl:value-of select="hdr/bReadOnly"/>';
						progReadOnlyLocal='<xsl:value-of select="hdr/progModifierBitMap/ProgReadOnlyLocal"/>';
						minLimit='<xsl:value-of select="minLength"/>';
						maxLimit='<xsl:value-of select="maxLength"/>';
						<xsl:variable name="stringValue">
							<xsl:choose>
								<xsl:when test="not(Pending/@isnull)">
									<xsl:value-of select="Pending"/>
								</xsl:when>
								<xsl:when test="not(Current/@isnull)">
									<xsl:value-of select="Current"/>
								</xsl:when>
								<xsl:otherwise>isNullValue</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>	 
						valuename='<xsl:value-of select="$stringValue"/>';				
						createBiosObject(index,"String",objName,objDisplayName,stringname,valuename,breadonly,parseInt(minLimit),parseInt(maxLimit),passwdobj,progReadOnlyLocal);
												
						<xsl:if test="numDependencies &gt; 0">
							<xsl:for-each select="dependenciesarray/dependencies">
								var dependname = '<xsl:value-of select="Name"/>';
								var dependvalue = '<xsl:value-of select="Value"/>';
								var dependtype = '<xsl:value-of select="Type"/>';
								createDependency(index,dependname,dependvalue,dependtype);
							</xsl:for-each>
						</xsl:if>
						index=index+1;
					 </xsl:for-each> 
					 
					 <xsl:for-each select="//HIIIntegerObj">
						<xsl:variable name="integerName">IntegerObj_name<xsl:value-of select="hdr/displayIndex"/></xsl:variable>
						var integername = '<xsl:value-of select="$integerName"/>';
						<xsl:variable name="integerValue">
							<xsl:choose>
								<xsl:when test="bPendingValid='true'">
									<xsl:value-of select="pendingValue"/>
								</xsl:when>
								<xsl:otherwise>
										<xsl:value-of select="currentValue"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>	 
						objName='<xsl:value-of select="hdr/Name"/>';
						objDisplayName="<xsl:value-of select="hdr/DisplayName"/>";
						breadonly='<xsl:value-of select="hdr/bReadOnly"/>';
						progReadOnlyLocal='<xsl:value-of select="hdr/progModifierBitMap/ProgReadOnlyLocal"/>';
						minLimit='<xsl:value-of select="minValue"/>';
						maxLimit='<xsl:value-of select="maxValue"/>';
						valuename='<xsl:value-of select="$integerValue"/>';		
						createBiosObject(index,"Integer",objName,objDisplayName,integername,valuename,breadonly,parseInt(minLimit),parseInt(maxLimit),null,progReadOnlyLocal);
						
						<xsl:if test="numDependencies &gt; 0">
							<xsl:for-each select="dependenciesarray/dependencies">
								var dependname = '<xsl:value-of select="Name"/>';
								var dependvalue = '<xsl:value-of select="Value"/>';
								var dependtype = '<xsl:value-of select="Type"/>';
								createDependency(index,dependname,dependvalue,dependtype);
							</xsl:for-each>
						</xsl:if>
						index=index+1;
					 </xsl:for-each>
					
					if(makeallreadonly == 'true' )
					{	
						for (var i=0;i &lt; biosObjArray.length ;i++)
						{
							if ( biosObjArray[i].objectType == "Enum")
								disableradioElement(i,true);
							else
								disableEditBox(i,true);				
							
						}
					}	
					else
						computeDependencies(); // is to be called for enum/string/integer objects
					
					// Compute for orderedlist object create object for orderedlist and object for each entry in orderedlist
					index=0;
				
					<xsl:for-each select="//HIIOrderedListObj">
					<xsl:sort select="hdr/displayIndex" data-type="number" order="ascending"/>
					
						//Get the following attributes from xml and create orderedlist object with these attributes
						
						allowEnableEntry='<xsl:value-of select="bAllowEnDisEntries"/>';
						objName='<xsl:value-of select="hdr/Name"/>';
						objDisplayName="<xsl:value-of select="hdr/DisplayName"/>";
						breadonly='<xsl:value-of select="hdr/bReadOnly"/>';
						var numOfOrderedEntries='<xsl:value-of select="numOrdListEntries"/>';
						var readonlyentries="false",readonlyobject="false";
						
						//Obtain the ons and DisplayIndex for the orderedlist object 
						<xsl:variable name="orderedParentOns"><xsl:value-of select="@ons"/></xsl:variable>
						<xsl:variable name="orderedDisplayIndex"><xsl:value-of select="hdr/displayIndex"/></xsl:variable>
						
						// orderedName is html element name for orderedList object
						<xsl:variable name="orderedName">orderedObj_name<xsl:value-of select="hdr/displayIndex"/></xsl:variable>
						var orderedName = '<xsl:value-of select="$orderedName"/>';
						
						//makeallreadonly is true incase it is password protected and breadonly indicates if object is readonly
						if(breadonly=="true" || makeallreadonly=="true" )
							  readonlyobject="true";
							  
						createBiosOrderedListObject(index,"Ordered",objName,objDisplayName,orderedName,readonlyobject,allowEnableEntry,numOfOrderedEntries,isTrueAdmin);
						
						//Get the bPendingValid value for orderedlist object. Sort the ordered entries  based on Pending/Current Index.
						<xsl:variable name="orderedObjPendingValid" select="//HIIOrderedListEntryObj[substring-before(@ons,'/HIIOrderedListEntryObj') = $orderedParentOns]/bPendingValid"/>
						
						<xsl:choose>
								<xsl:when test="$orderedObjPendingValid = 'true'">
									<xsl:for-each select="//HIIOrderedListEntryObj[substring-before(@ons,'/HIIOrderedListEntryObj') = $orderedParentOns]">
									<xsl:sort select="pendingIndex" data-type="number" order="ascending"/>
									// Sorted based on Pending Index
									objName='<xsl:value-of select="hdr/Name"/>';
									objDisplayName="<xsl:value-of select="hdr/DisplayName"/>";
									breadonly='<xsl:value-of select="hdr/bReadOnly"/>';
									biosMappingId='<xsl:value-of select="hdr/biosMappingID"/>';
									var pendingValid='<xsl:value-of select="bPendingValid"/>';
									//Construct html element name for each orderedlist entry suffix with displayindex to identify that the entry belongs to which orderedlist object							
									<xsl:variable name="orderedObjorder">orderedentryObj_order_<xsl:value-of select="position()"/>_<xsl:value-of select="$orderedDisplayIndex"/></xsl:variable>
									
									//Construct html element name for checkbox element of each orderedlist entry suffix with displayindex to identify that the entry belongs to which orderedlist object							
									<xsl:variable name="orderedObjCheckBox">orderedObj_CheckBox_<xsl:value-of select="position()"/>_<xsl:value-of select="$orderedDisplayIndex"/></xsl:variable>
									
									var orderedObjorder = '<xsl:value-of select="$orderedObjorder"/>';
									var checkBoxName = '<xsl:value-of select="$orderedObjCheckBox"/>';
									var pendingValid='<xsl:value-of select="bPendingValid"/>';
									var pendingEnabled='<xsl:value-of select="bPendingEnabled"/>';
									var currentEnabled='<xsl:value-of select="bCurrentEnabled"/>';
									
									//makeallreadonly is true incase it is password protected breadonly indicates if object is readonly
									if(breadonly=="true" || makeallreadonly=="true" )
										readonlyentries="true";
						
									createOrderedEntriesObject(index,objName,objDisplayName,orderedObjorder,readonlyentries,checkBoxName,biosMappingId,pendingValid,currentEnabled,pendingEnabled);
									</xsl:for-each>
								</xsl:when>
								<xsl:otherwise>
									<xsl:for-each select="//HIIOrderedListEntryObj[substring-before(@ons,'/HIIOrderedListEntryObj') = $orderedParentOns]">
										<xsl:sort select="currentIndex" data-type="number" order="ascending"/>
											// Sorted based on Current Index
										objName='<xsl:value-of select="hdr/Name"/>';
										objDisplayName="<xsl:value-of select="hdr/DisplayName"/>";
										breadonly='<xsl:value-of select="hdr/bReadOnly"/>';
										biosMappingId='<xsl:value-of select="hdr/biosMappingID"/>';
										//Construct html element name for each orderedlist entry suffix with displayindex to identify that the entry belongs to which orderedlist object																				
										<xsl:variable name="orderedObjorder">orderedentryObj_order_<xsl:value-of select="position()"/>_<xsl:value-of select="$orderedDisplayIndex"/></xsl:variable>
										
										//Construct html element name for checkbox element of each orderedlist entry suffix with displayindex to identify that the entry belongs to which orderedlist object							
										<xsl:variable name="orderedObjCheckBox">orderedObj_CheckBox_<xsl:value-of select="position()"/>_<xsl:value-of select="$orderedDisplayIndex"/></xsl:variable>
										
										var orderedObjorder = '<xsl:value-of select="$orderedObjorder"/>';
										var checkBoxName = '<xsl:value-of select="$orderedObjCheckBox"/>';
										var pendingValid='<xsl:value-of select="bPendingValid"/>';
										var pendingEnabled='<xsl:value-of select="bPendingEnabled"/>';
										var currentEnabled='<xsl:value-of select="bCurrentEnabled"/>';
										
										//makeallreadonly is true incase it is password protected  breadonly indicates if object is readonly
										if(breadonly=="true" || makeallreadonly=="true" )
										readonlyentries="true";
										
										createOrderedEntriesObject(index,objName,objDisplayName,orderedObjorder,readonlyentries,checkBoxName,biosMappingId,pendingValid,currentEnabled,pendingEnabled);
									</xsl:for-each>
								</xsl:otherwise>
							</xsl:choose>
					
						index=index+1;
					</xsl:for-each>//end orderedlist 
					
					updateOrderedListObjectState();
				
				}//end init
																
		
				 function updateOrderedListObjectState()
				{
			
					for (var i = 0; i &lt; biosOrderedObjArray.length; ++i )
					{
						var biosOrderedObj 		= biosOrderedObjArray[i];
						var numOfOrderedEntries = biosOrderedObj.numOrdListEntries;
						var orderedEntriesList= biosOrderedObjArray[i].orderedEntriesList;	
						
						// If Checkbox exist for the entry
						if(biosOrderedObj.allowEnableEntry=="true")
							{
								for (var j = 0; j &lt; numOfOrderedEntries; ++j )
								{	
									var orderedEntriesListObject 	= orderedEntriesList[j];
																
									if(orderedEntriesListObject.pendingValid=="true")
									{ 
										if(orderedEntriesListObject.pendingEnabled=="true")
										{
											 //set checkbox based on pending enabled
											 document.getElementById(orderedEntriesListObject.enableCheckbox).checked = true;
										}
										else
										{
											//unset check box
											document.getElementById(orderedEntriesListObject.enableCheckbox).checked = false;
										}
									}
									else
									{
										if(orderedEntriesListObject.currentEnabled=="true")
										{
											//set checkbox
											document.getElementById(orderedEntriesListObject.enableCheckbox).checked = true;
										}
										else
										{
											//unset check box
											document.getElementById(orderedEntriesListObject.enableCheckbox).checked = false;
										}
									
									}
									
									if(orderedEntriesListObject.readonly=="true" ||  biosOrderedObjArray[i].readonly=="true")
										document.getElementById(orderedEntriesListObject.enableCheckbox).disabled=true;
									
									if((biosOrderedObjArray[i].objectName=='BootSeq' || biosOrderedObjArray[i].objectName=='HddSeq') &amp;&amp;  biosOrderedObjArray[i].isTrueAdmin!="true")
										document.getElementById(orderedEntriesListObject.enableCheckbox).disabled=true;
									
									
									
									
								
								}
								
								
							}
					}
					
					
				
				}
				
				function validateOrderedObj() 
				{
					
					for (var i = 0; i &lt; biosOrderedObjArray.length; ++i )
					{	
						//Call the function below to validate each entry of a orderedlist object
						validateOrderedEntry(i);
					}		
				}
				
				function validateOrderedEntry(index)
				{	
					var checkboxEntries;
					var orderedEntriesList= biosOrderedObjArray[index].orderedEntriesList;	
					
					for (var entriesIndex = 0; entriesIndex &lt; orderedEntriesList.length; ++entriesIndex )
					{
						var  orderedEntriesObj  = orderedEntriesList[entriesIndex];
						var ordselval=document.getElementById(orderedEntriesList[entriesIndex].htmlName).innerHTML;
						
						//if order is changed for this entry and the orderselval=2 then construct string as 2_1 
						//mappingId_2_1 or enableEntries_2_1
						ordselval=ordselval+"_"+(index+1);
								
						if(document.getElementById(orderedEntriesList[entriesIndex].enableCheckbox)==null)
								checkboxEntries="1";
						else
						{
							if(document.getElementById(orderedEntriesList[entriesIndex].enableCheckbox).checked)
							checkboxEntries="1";
							else
							checkboxEntries="0";
						}
						
						// Create Hidden Elements and store the biosMappingId and checkbox state in the sorted order
						var field = document.createElement("input");
						field.setAttribute("type","hidden");
						field.setAttribute("id","mappingId_"+ordselval);
						field.setAttribute("value",orderedEntriesList[entriesIndex].biosMappingId);
						field.setAttribute("name","mappingId_"+ordselval);
						document.getElementById("dataarea").appendChild(field);

						var field = document.createElement("input");
						field.setAttribute("type","hidden");
						field.setAttribute("id","enableEntries_"+ordselval);
						field.setAttribute("value",checkboxEntries);
						field.setAttribute("name","enableEntries_"+ordselval);
						document.getElementById("dataarea").appendChild(field);
							
					}
					
				
				}
		
				function validate() 
				{				
				
					<!--For orderedlist Config-->
					validateOrderedObj();
					
					if(!validateStringIntegerObj())
						return false;
				
					
					return true;
				}
				function restart()
				{
					if (confirm("<xsl:value-of select="$strAreYouDone"/>"))
					{
						
						document.getElementById("dataarea").action=top.gnv.appendVID('./SubmitForm?plugin=com.dell.hip.webplugins.shtdwnWebPlugin&amp;os=8&amp;action1=1');
						document.getElementById("dataarea").submit();
					}
				
				}
			
				function submitBiosTokens()
				{
					if (!validate())
					{
						return;

					}

											
									
					document.dataarea.action = top.gnv.appendVID("./SubmitForm?plugin=com.dell.hip.webplugins.setbiosobjWebPlugin&amp;ons=<xsl:value-of select="$formOns"/>&amp;help=<xsl:value-of select="/OMA/HIIFormObj/hdr/Name"/>&amp;enumCount=<xsl:value-of select="$TotalEnumObjCount"/>&amp;stringCount=<xsl:value-of select="$TotalStringObjCount"/>&amp;integerCount=<xsl:value-of select="$TotalIntegerObjCount"/>&amp;orderedObjCount=<xsl:value-of select="$TotalOrderedObjCount"/>&amp;MaxDisplayIndex=<xsl:value-of select="$MaxDisplayIndex"/>");
					document.dataarea.submit();			
                  		
				}
			
			</script>
			<PageTitle>
				<xsl:attribute name="display"> <xsl:value-of select="/OMA/HIIFormObj/hdr/DisplayName"/></xsl:attribute>
				<xsl:attribute name="value"> <xsl:value-of select="/OMA/HIIFormObj/hdr/DisplayName"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.biosobjinfoWebPlugin&amp;rciboot=true&amp;ons=<xsl:value-of select="HIIFormObj/@ons"/>&amp;help=<xsl:value-of select="/OMA/HIIFormObj/hdr/Name"/></xsl:attribute>
				</Data>
			</CustomButton>
			<!--
			Checking whether there are any properties to display or not			
			-->
			<xsl:if test="$TotalFormObjCount='0'">
				<PromptText>
					<xsl:value-of select="$strNoProperties"/>
				</PromptText>
			</xsl:if>
						
			<xsl:if test="$PasswdProtected = 'true'  and $isSetPwd = 'false'">
				<AlertMessage>
					<xsl:attribute name="display"><xsl:value-of select="$strPasswordwarn"/></xsl:attribute>
					<xsl:attribute name="status">3</xsl:attribute>
				</AlertMessage>
			</xsl:if>
	
			<xsl:if test="SMStatus and SMStatus = '0'">
				 <xsl:choose>
					<xsl:when test="$setBIOS = 'true'">
						<AlertMessage>
							<xsl:attribute name="display"><xsl:value-of select="$strConfigSuccess"/></xsl:attribute>
							<xsl:attribute name="status">2</xsl:attribute>
						</AlertMessage>
					</xsl:when>
					<xsl:when test="$setBIOS = 'false'">
						<AlertMessage>
							<xsl:attribute name="display"><xsl:value-of select="$strConfigInfo"/></xsl:attribute>
							<xsl:attribute name="status"></xsl:attribute>
						</AlertMessage>
					</xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
		    </xsl:if>

			<xsl:if test="$ShutDownFlag = 'true'">
				<CustomButton>
					<Data name="shtdwn">
						<xsl:attribute name="display"><xsl:value-of select="$strRebootSystem"/></xsl:attribute>
						<xsl:attribute name="href">javascript:restart()</xsl:attribute>
						<xsl:attribute name="formSubmit">true</xsl:attribute>
					</Data>
				</CustomButton>
			</xsl:if>

			<xsl:apply-templates select="HIIEnumObj | HIIStringObj | HIIIntegerObj">
				<xsl:sort select="hdr/displayIndex" data-type="number" order="ascending"/>
			</xsl:apply-templates>
			
			<xsl:for-each select="HIIOrderedListObj">
				<xsl:sort select="hdr/displayIndex" data-type="number" order="ascending"/>
				<xsl:variable name="parentons"><xsl:value-of select="@ons"/></xsl:variable>
				<xsl:variable name="numentries"><xsl:value-of select="numOrdListEntries"/></xsl:variable>
				<xsl:variable name="enableDisableFlag"><xsl:value-of select="bAllowEnDisEntries"/></xsl:variable>
				<xsl:variable name="isReadOnly"><xsl:value-of select="hdr/bReadOnly"/></xsl:variable>
				
				<xsl:if test="hdr/bSuppressed != 'true'">
					<HiddenTable>
						<Data>
							<xsl:attribute name="name">orderedObj_name<xsl:value-of select="position()"/></xsl:attribute>
							
							<xsl:attribute name="returnvalue">orderedObj_name<xsl:value-of select="position()"/></xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="name">orderedObj_ons<xsl:value-of select="position()"/></xsl:attribute>
							
							<xsl:attribute name="returnvalue"><xsl:value-of select="@ons"/></xsl:attribute>
						</Data>
							<Data>
						<xsl:attribute name="name">numentries<xsl:value-of select="position()"/></xsl:attribute>
							
							<xsl:attribute name="returnvalue"><xsl:value-of select="$numentries"/></xsl:attribute>
							</Data>
						
					</HiddenTable>

					<ListTableData name="ipltable">
						<xsl:attribute name="display"><xsl:value-of select="hdr/DisplayName"/></xsl:attribute>
						<SubHeader>
							<xsl:attribute name="display"><xsl:value-of select="hdr/DisplayName"/></xsl:attribute>
						</SubHeader>
						<xsl:variable name="orderedName">orderedObj_name<xsl:value-of select="position()"/></xsl:variable>
						<Header>
							<Data align="center">
								<xsl:attribute name="display"> <xsl:value-of select="$strOrder"/></xsl:attribute>
								<xsl:attribute name="value"> <xsl:value-of select="$strOrder"/> </xsl:attribute>
							</Data>

							<xsl:if test="$enableDisableFlag = 'true'">
								<Data align="center">
									<xsl:attribute name="display"> <xsl:value-of select="$strEnabled"/></xsl:attribute>			
									<xsl:attribute name="value">  <xsl:value-of select="$strEnabled"/></xsl:attribute>
								</Data>
							</xsl:if>

							<Data  align="left">
								<xsl:attribute name="display"> <xsl:value-of select="$strDevice"/></xsl:attribute>			
								<xsl:attribute name="value">  <xsl:value-of select="$strDevice"/> </xsl:attribute>
							</Data>
							<xsl:if test="$isReadOnly = 'false'">	
								<Data  align="center">
									<xsl:attribute name="display"> <xsl:value-of select="$strToggleButtons"/></xsl:attribute>			
									<xsl:attribute name="value">  <xsl:value-of select="$strToggleButtons"/> </xsl:attribute>
								</Data>
							</xsl:if>
						</Header>

						<xsl:choose>
							<xsl:when test="numDependencies &gt; 0">
								<xsl:variable name="strIntAttributeDeps"><xsl:call-template name="GetAttributeDeps"/></xsl:variable>
								<xsl:variable name="enumstatedisabled">
									<xsl:choose>
										<xsl:when test="contains($strIntAttributeDeps, '2,')">2</xsl:when>		
										<xsl:otherwise></xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:variable name="enumstatechecked">
									<xsl:choose>
										<xsl:when test="contains($strIntAttributeDeps, '2,')">3</xsl:when>		
										<xsl:otherwise>1</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="contains($strIntAttributeDeps, '3,')">
									</xsl:when>
									<xsl:otherwise>
										<xsl:call-template name="GetOrderedListEntryObjDisplay">
											<xsl:with-param name="parentons"><xsl:value-of select="$parentons"/></xsl:with-param>
											<xsl:with-param name="enableDisableFlag"><xsl:value-of select="$enableDisableFlag"/></xsl:with-param>
											<xsl:with-param name="enumstatedisabled"><xsl:value-of select="$enumstatedisabled"/></xsl:with-param>
											<xsl:with-param name="enumstatechecked"><xsl:value-of select="$enumstatechecked"/></xsl:with-param>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="GetOrderedListEntryObjDisplay">
									<xsl:with-param name="parentons"><xsl:value-of select="$parentons"/></xsl:with-param>
									<xsl:with-param name="enableDisableFlag"><xsl:value-of select="$enableDisableFlag"/></xsl:with-param>
									<xsl:with-param name="enumstatedisabled"></xsl:with-param>
									<xsl:with-param name="enumstatechecked">1</xsl:with-param>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>	
					</ListTableData>
				</xsl:if>	
			</xsl:for-each>		
	
		</DataArea>
	</xsl:template>

	<xsl:template match="HIIEnumObj">
		<xsl:if test="hdr/bSuppressed != 'true'">
			<HiddenTable>
				<Data>
					<xsl:attribute name="name">ObjType<xsl:value-of select="hdr/displayIndex"/></xsl:attribute>
					<xsl:attribute name="returnvalue">EnumObj</xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="name">EnumObj_ons<xsl:value-of select="hdr/displayIndex"/></xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="@ons"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="name">obj_Name<xsl:value-of select="hdr/displayIndex"/></xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="hdr/Name"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="name">EnumObj_name<xsl:value-of select="hdr/displayIndex"/>_objSelect</xsl:attribute>
					<xsl:attribute name="returnvalue">false</xsl:attribute>
				</Data>
			</HiddenTable>

			<ListData type="custom">		
				<Header>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="hdr/DisplayName"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="hdr/DisplayName"/></xsl:attribute>
					</Data>
				</Header>
       			<PromptText instructions="true"><xsl:value-of select="hdr/Description"/></PromptText>
			<xsl:if test="hdr/Name ='PasswordStatus'">
				<PromptText>
				<xsl:value-of select="$strSysPasswdMesg"/>
				</PromptText>
			</xsl:if>

				<xsl:variable name="parentons"><xsl:value-of select="@ons"/></xsl:variable>
				<xsl:variable name="enumName">EnumObj_name<xsl:value-of select="hdr/displayIndex"/></xsl:variable>
	
				<xsl:choose>
					<xsl:when test="numDependencies &gt; 0">
						<xsl:variable name="strIntAttributeDeps"><xsl:call-template name="GetAttributeDeps"/></xsl:variable>
						<xsl:variable name="enumstatedisabled">
							<xsl:choose>
								<xsl:when test="contains($strIntAttributeDeps, '2,')">2</xsl:when>		
								<xsl:otherwise></xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:variable name="enumstatechecked">
							<xsl:choose>
								<xsl:when test="contains($strIntAttributeDeps, '2,')">3</xsl:when>		
								<xsl:otherwise>1</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="contains($strIntAttributeDeps, '3,')">
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="GetEnumValueObjDisplay">
									<xsl:with-param name="parentons"><xsl:value-of select="$parentons"/></xsl:with-param>
									<xsl:with-param name="enumname"><xsl:value-of select="$enumName"/></xsl:with-param>
									<xsl:with-param name="enumstatedisabled"><xsl:value-of select="$enumstatedisabled"/></xsl:with-param>
									<xsl:with-param name="enumstatechecked"><xsl:value-of select="$enumstatechecked"/></xsl:with-param>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="GetEnumValueObjDisplay">
							<xsl:with-param name="parentons"><xsl:value-of select="$parentons"/></xsl:with-param>
							<xsl:with-param name="enumname"><xsl:value-of select="$enumName"/></xsl:with-param>
							<xsl:with-param name="enumstatedisabled"></xsl:with-param>
							<xsl:with-param name="enumstatechecked">1</xsl:with-param>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>	
			</ListData>
		</xsl:if>	
	</xsl:template>
	
	<xsl:template match="HIIStringObj">
		<xsl:if test="hdr/bSuppressed != 'true'">				
			<xsl:variable name="postingObjName">StringObj_name<xsl:value-of select="hdr/displayIndex"/></xsl:variable>
			<HiddenTable>
				<Data>
					<xsl:attribute name="name">ObjType<xsl:value-of select="hdr/displayIndex"/></xsl:attribute>
					<xsl:attribute name="returnvalue">StringObj</xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="name">StringObj_ons<xsl:value-of select="hdr/displayIndex"/></xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="@ons"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="name">StringObj_min<xsl:value-of select="hdr/displayIndex"/></xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="minLength"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="name">StringObj_max<xsl:value-of select="hdr/displayIndex"/></xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="maxLength"/></xsl:attribute>
				</Data>
				 <Data>
				         <xsl:attribute name="name">StringObj_bPasswdObj<xsl:value-of select="hdr/displayIndex"/></xsl:attribute>
				         <xsl:attribute name="returnvalue"><xsl:value-of select="bPasswdObj"/></xsl:attribute>
				 </Data>
				 <Data>
					<xsl:attribute name="name">obj_Name<xsl:value-of select="hdr/displayIndex"/></xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="hdr/Name"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="name">StringObj_name<xsl:value-of select="hdr/displayIndex"/>_objSelect</xsl:attribute>
					<xsl:attribute name="returnvalue">false</xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="name">pwd_StringObj_name<xsl:value-of select="hdr/displayIndex"/>_objSelect</xsl:attribute>
					<xsl:attribute name="returnvalue">false</xsl:attribute>
				</Data>
			</HiddenTable>
	
			<xsl:call-template name="CheckStringOrIntegerDeps">
				<xsl:with-param name="postingObjName"><xsl:value-of select="$postingObjName"/></xsl:with-param>
				<xsl:with-param name="calledBy">StringObj</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="HIIIntegerObj">
		<xsl:if test="hdr/bSuppressed != 'true'">
			<xsl:variable name="postingObjName">IntegerObj_name<xsl:value-of select="hdr/displayIndex"/></xsl:variable>
			<HiddenTable>
				<Data>
					<xsl:attribute name="name">ObjType<xsl:value-of select="hdr/displayIndex"/></xsl:attribute>
					<xsl:attribute name="returnvalue">IntegerObj</xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="name">IntegerObj_ons<xsl:value-of select="hdr/displayIndex"/></xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="@ons"/></xsl:attribute>
				</Data>
				
				<Data>
					<xsl:attribute name="name">IntegerObj_min<xsl:value-of select="hdr/displayIndex"/></xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="minValue"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="name">IntegerObj_max<xsl:value-of select="hdr/displayIndex"/></xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="maxValue"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="name">IntegerObj_val<xsl:value-of select="hdr/displayIndex"/></xsl:attribute>
					<xsl:choose>
					<xsl:when test="bPendingValid = 'true'">
							<xsl:attribute name="returnvalue"><xsl:value-of select="pendingValue"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
							<xsl:attribute name="returnvalue"><xsl:value-of select="currentValue"/></xsl:attribute>
					</xsl:otherwise>
					</xsl:choose>
				</Data>
				<Data>
					<xsl:attribute name="name">obj_Name<xsl:value-of select="hdr/displayIndex"/></xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="hdr/Name"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="name">IntegerObj_name<xsl:value-of select="hdr/displayIndex"/>_objSelect</xsl:attribute>
					<xsl:attribute name="returnvalue">false</xsl:attribute>
				</Data>
			</HiddenTable>

			<xsl:call-template name="CheckStringOrIntegerDeps">
				<xsl:with-param name="postingObjName"><xsl:value-of select="$postingObjName"/></xsl:with-param>
				<xsl:with-param name="calledBy">IntegerObj</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="GetEnumValueObjDisplay">
		<xsl:param name="parentons"/>
		<xsl:param name="enumname"/>
		<xsl:param name="enumstatedisabled"/>
		<xsl:param name="enumstatechecked"/>
		
		<xsl:variable name="parentName"><xsl:value-of select="hdr/Name"/></xsl:variable>
		<xsl:variable name="pendingvalid"><xsl:value-of select="bPendingValid"/></xsl:variable>
		<xsl:variable name="currentstate"><xsl:value-of select="currentState"/></xsl:variable>
	<xsl:variable name="pendingstate"><xsl:value-of select="pendingState"/></xsl:variable>
	
		
		<xsl:for-each select="//HIIEnumValueObj">
			<xsl:sort select="stateNumber" data-type="number" order="ascending"/>
			<xsl:variable name="enumons"><xsl:value-of select="substring-before(@ons,'/HIIEnumValueObj')"/></xsl:variable>

			<xsl:if test="$parentons = $enumons">
				<xsl:choose>
					<xsl:when test="numDependencies &gt; 0">
						<xsl:variable name="enumValueObjDeps">
							<xsl:for-each select="dependenciesarray/dependencies">
								<xsl:variable name="dependencyType"><xsl:value-of select="Type"/></xsl:variable>
								<xsl:variable name="dependencyName"><xsl:value-of select="Name"/></xsl:variable>
								<xsl:variable name="dependencyValue"><xsl:value-of select="Value"/></xsl:variable>
							
								<xsl:variable name="bpendingvalid" select="//HIIEnumObj[hdr/Name = $dependencyName]/bPendingValid"/>
								<xsl:variable name="depNameCurState" select="//HIIEnumObj[hdr/Name = $dependencyName]/currentState"/>
								<xsl:variable name="depNamePendingState" select="//HIIEnumObj[hdr/Name = $dependencyName]/pendingState"/>
								<xsl:variable name="dependParentOns" select="//HIIEnumObj[hdr/Name = $dependencyName]/@ons"/>
								<xsl:variable name="depValueStateNum" select="//HIIEnumValueObj[Name = $dependencyValue][substring-before(@ons,'/HIIEnumValueObj') = $dependParentOns]/stateNumber"/>
								
								<xsl:variable name="enumstate">
									<xsl:choose>
										<xsl:when test="$bpendingvalid = 'true'"><xsl:value-of select="$depNamePendingState"/></xsl:when>
										<xsl:otherwise><xsl:value-of select="$depNameCurState"/></xsl:otherwise>
									</xsl:choose>
								</xsl:variable>		
								
								<xsl:choose>
								    <xsl:when test="normalize-space($depValueStateNum)!='' and normalize-space($enumstate)!='' and (($dependencyType = 'SuppressIf' and $enumstate = normalize-space($depValueStateNum)) or ($dependencyType = 'SuppressIfNot' and $enumstate != normalize-space($depValueStateNum)))">3,</xsl:when>
									<xsl:when test="normalize-space($depValueStateNum)!='' and normalize-space($enumstate)!='' and (($dependencyType = 'ForceIf' and $enumstate = normalize-space($depValueStateNum)) or ($dependencyType = 'ForceIfNot' and $enumstate != normalize-space($depValueStateNum)))">1,</xsl:when>
									<xsl:otherwise>0,</xsl:otherwise>
								</xsl:choose>
								
							</xsl:for-each>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="contains($enumValueObjDeps, '3,')">
							</xsl:when>
							<xsl:otherwise>
								<Data type="radio" Control_left="true">
									<xsl:attribute name="name"><xsl:value-of select="$enumname"/></xsl:attribute>
									<xsl:attribute name="id"><xsl:value-of select="$enumname"/></xsl:attribute>
									<xsl:attribute name="returnvalue"><xsl:value-of select="stateNumber"/></xsl:attribute>
									<xsl:attribute name="display"><xsl:value-of select="DisplayName"/></xsl:attribute>
									<xsl:attribute name="event">onClick</xsl:attribute>
									<xsl:attribute name="handler">javascript:togglestate('<xsl:value-of select="$parentName"/>','<xsl:value-of select="Name"/>');</xsl:attribute>
									
									<xsl:attribute name="state"><xsl:value-of select="$enumstatedisabled"/></xsl:attribute>

									<xsl:choose>
										<xsl:when test="contains($enumValueObjDeps, '1,')">
											<xsl:choose>
												<xsl:when test="$enumstatedisabled = '2'">
													<xsl:attribute name="state">3</xsl:attribute>
												</xsl:when>		
												<xsl:otherwise>	
													<xsl:attribute name="state">1</xsl:attribute>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:when>		
										<xsl:otherwise>	
											<xsl:choose>
												<xsl:when test="$pendingvalid = 'true'">
													<xsl:if test="$pendingstate = stateNumber">
														<xsl:attribute name="state"><xsl:value-of select="$enumstatechecked"/></xsl:attribute>
													</xsl:if>
												</xsl:when>		
												<xsl:otherwise>	
													<xsl:if test="$currentstate = stateNumber">
														<xsl:attribute name="state"><xsl:value-of select="$enumstatechecked"/></xsl:attribute>
													</xsl:if>
												</xsl:otherwise>		
											</xsl:choose>		
										</xsl:otherwise>		
									</xsl:choose>		
								</Data>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<Data type="radio" Control_left="true">
							<xsl:attribute name="name"><xsl:value-of select="$enumname"/></xsl:attribute>
							<xsl:attribute name="id"><xsl:value-of select="$enumname"/></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="stateNumber"/></xsl:attribute>
							<xsl:attribute name="display"><xsl:value-of select="DisplayName"/></xsl:attribute>
							<xsl:attribute name="event">onClick</xsl:attribute>
							<xsl:attribute name="handler">javascript:togglestate('<xsl:value-of select="$parentName"/>','<xsl:value-of select="Name"/>');</xsl:attribute>
							
							<xsl:attribute name="state"><xsl:value-of select="$enumstatedisabled"/></xsl:attribute>
							
							<xsl:choose>
								<xsl:when test="$pendingvalid = 'true'">
									<xsl:if test="$pendingstate = stateNumber">
										<xsl:attribute name="state"><xsl:value-of select="$enumstatechecked"/></xsl:attribute>
									</xsl:if>
								</xsl:when>		
								<xsl:otherwise>	
									<xsl:if test="$currentstate = stateNumber">
										<xsl:attribute name="state"><xsl:value-of select="$enumstatechecked"/></xsl:attribute>
									</xsl:if>
								</xsl:otherwise>		
							</xsl:choose>		
						</Data>
					</xsl:otherwise>
				</xsl:choose>	
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="GetAttributeDeps">
		<xsl:for-each select="dependenciesarray/dependencies">
			<xsl:variable name="dependencyType"><xsl:value-of select="Type"/></xsl:variable>
			<xsl:variable name="dependencyName"><xsl:value-of select="Name"/></xsl:variable>
			<xsl:variable name="dependencyValue"><xsl:value-of select="Value"/></xsl:variable>
			<xsl:variable name="pendingvalid" select="//HIIEnumObj[hdr/Name = $dependencyName]/bPendingValid"/>
			<xsl:variable name="depNameCurState" select="//HIIEnumObj[hdr/Name = $dependencyName]/currentState"/>
			<xsl:variable name="depNamePendingState" select="//HIIEnumObj[hdr/Name = $dependencyName]/pendingState"/>
			<xsl:variable name="dependParentOns" select="//HIIEnumObj[hdr/Name = $dependencyName]/@ons"/>
			<xsl:variable name="depValueStateNum" select="//HIIEnumValueObj[Name = $dependencyValue][substring-before(@ons,'/HIIEnumValueObj') = $dependParentOns]/stateNumber"/>
		
								<xsl:variable name="enumstate">
									<xsl:choose>
										<xsl:when test="$pendingvalid = 'true'"><xsl:value-of select="$depNamePendingState"/></xsl:when>
										<xsl:otherwise><xsl:value-of select="$depNameCurState"/></xsl:otherwise>
									</xsl:choose>
								</xsl:variable>		
								
								<xsl:choose>
									<xsl:when test="normalize-space($depValueStateNum)!='' and normalize-space($enumstate)!='' and (($dependencyType = 'SuppressIf' and $enumstate = normalize-space($depValueStateNum)) or ($dependencyType = 'SuppressIfNot' and $enumstate != normalize-space($depValueStateNum)))">3,</xsl:when>
									<xsl:when test="normalize-space($depValueStateNum)!='' and normalize-space($enumstate)!='' and (($dependencyType = 'ForceIf' and $enumstate = normalize-space($depValueStateNum)) or ($dependencyType = 'ForceIfNot' and $enumstate != normalize-space($depValueStateNum)) )">1,</xsl:when>
									<xsl:otherwise>0,</xsl:otherwise>
								</xsl:choose>
								
		</xsl:for-each>	
	</xsl:template>
	
	<xsl:template name="CheckStringOrIntegerDeps">
		<xsl:param name="postingObjName"/>
		<xsl:param name="calledBy"/>
		
		<xsl:choose>
			<xsl:when test="numDependencies &gt; 0">
				<xsl:variable name="strIntAttributeDeps"><xsl:call-template name="GetAttributeDeps"/></xsl:variable>
				<xsl:variable name="disableStrState">
					<xsl:choose>
						<xsl:when test="contains($strIntAttributeDeps, '2,')">2</xsl:when>		
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="contains($strIntAttributeDeps, '3,')">
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="GetStringIntegerObjDisplay">
							<xsl:with-param name="postingObjName"><xsl:value-of select="$postingObjName"/></xsl:with-param>
							<xsl:with-param name="calledBy"><xsl:value-of select="$calledBy"/></xsl:with-param>
							<xsl:with-param name="disableStrState"><xsl:value-of select="$disableStrState"/></xsl:with-param>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="GetStringIntegerObjDisplay">
					<xsl:with-param name="postingObjName"><xsl:value-of select="$postingObjName"/></xsl:with-param>
							<xsl:with-param name="calledBy"><xsl:value-of select="$calledBy"/></xsl:with-param>
					<xsl:with-param name="disableStrState"></xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>	
	</xsl:template>
	
	<xsl:template name="GetStringIntegerObjDisplay">
		<xsl:param name="postingObjName"/>
		<xsl:param name="calledBy"/>
		<xsl:param name="disableState"/>

		<ListData type="custom">
			<Header>
				<Data>
					<xsl:attribute name="display"> <xsl:value-of select="hdr/DisplayName"/></xsl:attribute>
					<xsl:attribute name="value"> <xsl:value-of select="hdr/DisplayName"/></xsl:attribute>
				</Data>
			</Header>
			<PromptText instructions="true"><xsl:value-of select="hdr/Description"/></PromptText>
			
			<xsl:choose>
				<xsl:when test="$calledBy = 'StringObj' and bPasswdObj = 'true'">
					<xsl:variable name="postingObjPwdName"><xsl:text>pwd_</xsl:text><xsl:value-of select="$postingObjName"/></xsl:variable>
					<Data>
						<xsl:attribute name="name"><xsl:value-of select="$postingObjPwdName"/></xsl:attribute>
						<xsl:attribute name="id"><xsl:value-of select="$postingObjPwdName"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="hdr/DisplayName"/></xsl:attribute>
						<xsl:attribute name="maxlength"><xsl:value-of select="maxLength"/></xsl:attribute>
						<xsl:attribute name="state"></xsl:attribute>
						<xsl:attribute name="value"></xsl:attribute>
						<xsl:attribute name="type">password</xsl:attribute>
						<xsl:attribute name="event">onchange</xsl:attribute>
						<xsl:attribute name="handler">javascript:editText('<xsl:value-of select="$postingObjPwdName"/>')</xsl:attribute>
						
						<xsl:attribute name="maxlength"><xsl:value-of select="maxLength"/></xsl:attribute>
						<xsl:choose>
							<xsl:when test="Pending/@isnull and Pending/@isnull =  'true'">
								<xsl:attribute name="value"><xsl:value-of select="Current"/></xsl:attribute>
							</xsl:when>		
							<xsl:otherwise>	
								<xsl:attribute name="value"><xsl:value-of select="Pending"/></xsl:attribute>
							</xsl:otherwise>		
						</xsl:choose>
					</Data>
				
					<xsl:variable name="postingObjPwdNameCon"><xsl:text>pwd_</xsl:text><xsl:value-of select="$postingObjName"/><xsl:text>_con</xsl:text></xsl:variable>
					<Data>
						<xsl:attribute name="name"><xsl:value-of select="$postingObjPwdNameCon"/></xsl:attribute>
						<xsl:attribute name="id"><xsl:value-of select="$postingObjPwdNameCon"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strConfirm"/><xsl:text> </xsl:text><xsl:value-of select="hdr/DisplayName"/></xsl:attribute>
						<xsl:attribute name="type">password</xsl:attribute>
						<xsl:attribute name="maxlength"><xsl:value-of select="maxLength"/></xsl:attribute>
						<xsl:attribute name="state"></xsl:attribute>
						<xsl:attribute name="value"></xsl:attribute>
						<xsl:attribute name="event">onchange</xsl:attribute>
						<xsl:attribute name="handler">javascript:editText('<xsl:value-of select="$postingObjPwdNameCon"/>')</xsl:attribute>

						<xsl:attribute name="maxlength"><xsl:value-of select="maxLength"/></xsl:attribute>
						<xsl:choose>
							<xsl:when test="Pending/@isnull and Pending/@isnull =  'true'">
								<xsl:attribute name="value"><xsl:value-of select="Current"/></xsl:attribute>
							</xsl:when>		
							<xsl:otherwise>	
								<xsl:attribute name="value"><xsl:value-of select="Pending"/></xsl:attribute>
							</xsl:otherwise>		
						</xsl:choose>

					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data>
						<xsl:attribute name="name"><xsl:value-of select="$postingObjName"/></xsl:attribute>
						<xsl:attribute name="id"><xsl:value-of select="$postingObjName"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="hdr/DisplayName"/></xsl:attribute>
						<xsl:attribute name="maxlength"><xsl:value-of select="maxLength"/></xsl:attribute>
						<xsl:attribute name="state"><xsl:value-of select="$disableState"/></xsl:attribute>
						<xsl:attribute name="type">editbox</xsl:attribute>
						<xsl:attribute name="event">onchange</xsl:attribute>
						<xsl:attribute name="handler">javascript:editText('<xsl:value-of select="$postingObjName"/>')</xsl:attribute>
						<xsl:if test="hdr/bReadOnly = 'true' and not(numDependencies &gt; 0)">
							<xsl:attribute name="type"></xsl:attribute>
						</xsl:if>
						<xsl:choose>
							<xsl:when test="$calledBy = 'StringObj'">
								<xsl:attribute name="maxlength"><xsl:value-of select="maxLength"/></xsl:attribute>
								<xsl:choose>
									<xsl:when test="Pending/@isnull and Pending/@isnull =  'true'">
										<xsl:attribute name="value"><xsl:value-of select="Current"/></xsl:attribute>
									</xsl:when>		
									<xsl:otherwise>	
										<xsl:attribute name="value"><xsl:value-of select="Pending"/></xsl:attribute>
									</xsl:otherwise>		
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="bPendingValid =  'true'">
										<xsl:attribute name="value"><xsl:value-of select="pendingValue"/></xsl:attribute>
									</xsl:when>		
									<xsl:otherwise>	
										<xsl:attribute name="value"><xsl:value-of select="currentValue"/></xsl:attribute>
									</xsl:otherwise>		
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
				
					</Data>
				</xsl:otherwise>
			</xsl:choose>
		</ListData>
	</xsl:template>
	
	<xsl:template name="GetOrderedListEntryObjDisplay">
		<xsl:param name="parentons"/>
		<xsl:param name="enableDisableFlag"/>
		<xsl:param name="enumstatedisabled"/>
		<xsl:param name="enumstatechecked"/>
		<xsl:variable name="hddq"><xsl:value-of select="hdr/Name"/></xsl:variable>
	    <xsl:variable name="orderedDisplayIndex"><xsl:value-of select="hdr/displayIndex"/></xsl:variable>
		<xsl:variable name="pendingValid" select="../HIIOrderedListEntryObj[substring-before(@ons,'/HIIOrderedListEntryObj') = $parentons]/bPendingValid"/>
		<xsl:choose>
			<xsl:when test="$pendingValid = 'true'">
				<xsl:for-each select="../HIIOrderedListEntryObj[substring-before(@ons,'/HIIOrderedListEntryObj') = $parentons]">
					<xsl:sort select="pendingIndex" data-type="number" order="ascending"/>
					<Row>
						<Data name="counter" align="center">
							<xsl:attribute name="id">orderedentryObj_order_<xsl:value-of select="position()"/>_<xsl:value-of select="$orderedDisplayIndex"/></xsl:attribute>
							<xsl:attribute name="name">orderedentryObj_order_<xsl:value-of select="position()"/>_<xsl:value-of select="$orderedDisplayIndex"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="position()"/></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="position()"/></xsl:attribute>
						</Data>
					
						<xsl:attribute name="state"><xsl:value-of select="$enumstatedisabled"/></xsl:attribute>
						<xsl:if test="$enableDisableFlag = 'true'">
							<Data name="actionsel" type="checkbox" align="center">
								<xsl:attribute name="id">orderedObj_CheckBox_<xsl:value-of select="position()"/>_<xsl:value-of select="$orderedDisplayIndex"/></xsl:attribute>
								<xsl:choose>
									<xsl:when test="bCurrentEnabled = 'true'">
										<xsl:attribute name="state"><xsl:value-of select="$enumstatechecked"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="state"><xsl:value-of select="$enumstatechecked"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
							</Data>
						</xsl:if>	

						<Data name="description"  align="left">
							<xsl:attribute name="value"><xsl:value-of select="hdr/DisplayName"/></xsl:attribute>
						</Data>

						<Data name="indexvalue" type="hidden">
							<xsl:attribute name="returnvalue"><xsl:value-of select="pendingIndex"/></xsl:attribute>
						</Data>
						
							
					</Row>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select="../HIIOrderedListEntryObj[substring-before(@ons,'/HIIOrderedListEntryObj') = $parentons]">
					<xsl:sort select="currentIndex" data-type="number" order="ascending"/>
					<Row>
						<Data name="counter" align="center">
							<xsl:attribute name="id">orderedentryObj_order_<xsl:value-of select="position()"/>_<xsl:value-of select="$orderedDisplayIndex"/></xsl:attribute>
							<xsl:attribute name="name">orderedentryObj_order_<xsl:value-of select="position()"/>_<xsl:value-of select="$orderedDisplayIndex"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="position()"/></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="position()"/></xsl:attribute>
						</Data>

						<xsl:attribute name="state"><xsl:value-of select="$enumstatedisabled"/></xsl:attribute>
						<xsl:if test="$enableDisableFlag = 'true'">
						<Data  type="checkbox" align="center">
							<xsl:attribute name="id">orderedObj_CheckBox_<xsl:value-of select="position()"/>_<xsl:value-of select="$orderedDisplayIndex"/></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="position()"/></xsl:attribute>
								<xsl:choose>
									<xsl:when test="bPendingEnabled = 'true'">
										<xsl:attribute name="state"><xsl:value-of select="$enumstatechecked"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="state"><xsl:value-of select="$enumstatechecked"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
						</Data>
						</xsl:if>	
						<Data name="description" align="left">
							<xsl:attribute name="value"><xsl:value-of select="hdr/DisplayName"/></xsl:attribute>
						</Data>

						<Data name="indexvalue" type="hidden">
							<xsl:attribute name="returnvalue"><xsl:value-of select="currentIndex"/></xsl:attribute>
						</Data>
						
					</Row>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="objstatus">
		<xsl:param name="name"/>
	</xsl:template>
	



	
</xsl:stylesheet>