<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:include href="../en/globals.xsl"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>	
	
	<xsl:template match="OMA">	
		
	<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
		<DataArea validate="false" onLoad="true">
			<!--xsl:if test="$usrights='7'"-->
			<xsl:if test="$usrights='7' ">
					<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.hip.webplugins.SetBmcSolWebPlugin</xsl:attribute>
			</xsl:if>

			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strSerialOverLAN"/></xsl:attribute>
			</PageTitle>

	
			<xsl:if test="EMPObj/defaultRestoreStatus = '0'">
				<xsl:if test="EMPObj/defaultRestoreSupport = '1'">
				<xsl:choose>
					<xsl:when test = "/OMA/@cli = 'true'">
						<PromptText><xsl:value-of select ="$gstrResetToDefaultCli"/></PromptText>
					</xsl:when>
					<xsl:otherwise>
							<PromptText><xsl:value-of select="$gstrResetToDefault"/></PromptText>
					</xsl:otherwise>
				</xsl:choose>	
				</xsl:if>
			</xsl:if>

			<CustomButton>
				<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.BMCSOLWebPlugin&amp;help=RemoteAccessSol</xsl:attribute>
				</Data>
			</CustomButton>
				<CustomButton>				
					<Data name="advanced"><xsl:attribute name="display"><xsl:value-of select="$strAdvancedSettings"/></xsl:attribute>
						<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.BMCSOLAdvWebPlugin&amp;help=RemoteAccessSolAd</xsl:attribute>
					</Data>
				</CustomButton>

	<ListData  type="custom"  name="tabSOLConfiguration">
    <xsl:attribute name="display"><xsl:value-of select="$strSerialOverLAN"/></xsl:attribute>
		<Header>
      <Data>
				<xsl:attribute name="display"><xsl:value-of select="$strSerialOverLAN"/></xsl:attribute>
      <xsl:attribute name="value"><xsl:value-of select="$strSerialOverLAN"/></xsl:attribute>
        </Data>
		</Header>



    <Data name="EnableSOL" type="checkbox" editable="true" align="left" width="250">
				<xsl:attribute name="display"><xsl:value-of select="$strEnableSOL"/></xsl:attribute>
							<xsl:if test="EMPSOLConfigObj/SOLEnable='1'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>



    <Data name="BitRateVolatile" type="select" editable="true" width="200">
				<xsl:attribute name="display"><xsl:value-of select="$strBitRateVolatile"/></xsl:attribute>	
			
				<xsl:variable name="selectedBitrate" select="EMPSOLConfigObj/SOLBitRateVolatile"/>
				<xsl:variable name="bitrateCapNode" select="EMPSOLConfigObj/bitRateCapabilities"/>
				<xsl:if test="$bitrateCapNode/bitrate_9600 = 'true'">
					<Choice returnvalue="6" value="{$str9600bps}">
						<xsl:if test="$selectedBitrate = 6"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
					</Choice>
				</xsl:if>
				<xsl:if test="$bitrateCapNode/bitrate_19200 = 'true'">
					<Choice returnvalue="7" value="{$str19200bps}">
						<xsl:if test="$selectedBitrate = 7"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
					</Choice>
				</xsl:if>
				<xsl:if test="$bitrateCapNode/bitrate_38400 = 'true'">
					<Choice returnvalue="8" value="{$str38400bps}">
						<xsl:if test="$selectedBitrate = 8"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
					</Choice>
				</xsl:if>
				<xsl:if test="$bitrateCapNode/bitrate_57600 = 'true'">
					<Choice returnvalue="9" value="{$str57600bps}">
						<xsl:if test="$selectedBitrate = 9"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
					</Choice>
				</xsl:if>
				<xsl:if test="$bitrateCapNode/bitrate_115200 = 'true'">
					<Choice returnvalue="10" value="{$str115200kbps}">
						<xsl:if test="$selectedBitrate = 10"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
					</Choice>
				</xsl:if>
			</Data>


			
			<Data name="MaxUserPriv" type="select" editable="true" width="200">
				<xsl:attribute name="display"><xsl:value-of select="$strMaximumUserPrivilege"/></xsl:attribute>		
			
				<Choice returnvalue="4">
					<xsl:attribute name="value"><xsl:value-of select="$strAdministrator"/></xsl:attribute>
					<xsl:if test="EMPSOLConfigObj/SOLAuthenPrivilegeLevel='4'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="3">
					<xsl:attribute name="value"><xsl:value-of select="$strOperator"/></xsl:attribute>
					<xsl:if test="EMPSOLConfigObj/SOLAuthenPrivilegeLevel='3'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>

				<Choice returnvalue="2">
					<xsl:attribute name="value"><xsl:value-of select="$strUser"/></xsl:attribute>
					<xsl:if test="EMPSOLConfigObj/SOLAuthenPrivilegeLevel='2'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</Data>
	

	</ListData>	

		<script language="javascript">
			var usrights = '<xsl:value-of select="/OMA/OMAUserRights"/>';

				function initializationRoutine()
				{

				EnableSettingsAccordingtoUserRights()				

				}
			
				function EnableSOLSettings()
				{
				<!--
						document.getElementById("BitRateNonvolatile").disabled =(!(document.getElementById("EnableSOL").checked));
--> 
						document.getElementById("BitRateVolatile").disabled =(!(document.getElementById("EnableSOL").checked)); 
						document.getElementById("MaxUserPriv").disabled =(!(document.getElementById("EnableSOL").checked)); 
				}
				
						
				
			function EnableSettingsAccordingtoUserRights()
				{		
					if (usrights != 7 )
					{
						document.getElementById("EnableSOL").disabled=true;
						<!--
						document.getElementById("BitRateNonvolatile").disabled =true; 
						-->
						document.getElementById("BitRateVolatile").disabled =true; 
						document.getElementById("MaxUserPriv").disabled =true; 
					}
				}

		</script>
		</DataArea>
	</xsl:template>	
</xsl:stylesheet>