<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:include href="../en/globals.xsl"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>	
	
	<xsl:template match="OMA">
	  	

	<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
		<DataArea onLoad="true">

				<!--xsl:if test="$usrights='7'"-->
				<xsl:if test="$usrights='7' ">
					<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.hip.webplugins.SetBmcSerialWebPlugin</xsl:attribute>
				</xsl:if>

			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strSerialPortConf"/></xsl:attribute>
			</PageTitle>
			

			<xsl:if test="EMPObj/defaultRestoreStatus = '0'">
				<xsl:if test="EMPObj/defaultRestoreSupport = '1'">
				<xsl:choose>
					<xsl:when test = "/OMA/@cli = 'true'">
						<PromptText><xsl:value-of select ="$gstrResetToDefaultCli"/></PromptText>
					</xsl:when>
					<xsl:otherwise>
							<PromptText><xsl:value-of select="$gstrResetToDefault"/></PromptText>
					</xsl:otherwise>
				</xsl:choose>	
				</xsl:if>
			</xsl:if>
			<CustomButton>
				<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.BMCSerialWebPlugin&amp;help=RemoteAccessSer</xsl:attribute>
				</Data>
			</CustomButton>
				<CustomButton>	
					<Data name=""><xsl:attribute name="display"><xsl:value-of select="$strAdvancedSettings"/></xsl:attribute>
						<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.BMCSerialAdvWebPlugin&amp;help=RemoteAccessSerAd</xsl:attribute>
					</Data>
				</CustomButton>


	<ListData  type="custom"  name="tabSerialConfiguration">
    <xsl:attribute name="display"><xsl:value-of select="$strSerialPortConf"/></xsl:attribute>
		<Header>
      <Data>
			<xsl:attribute name="display"><xsl:value-of select="$strSerialPortConf"/></xsl:attribute>
      <xsl:attribute name="value"><xsl:value-of select="$strSerialPortConf"/></xsl:attribute>
      </Data>
		</Header>

    <Data name="ConnectionMode" type="select" editable="true">
				<xsl:attribute name="display"><xsl:value-of select="$strConnectionModeSetting"/></xsl:attribute>
			
			<xsl:if test="EMPSerialConfigObj/connectionModeSupport/DirBasic='true'">
				<Choice returnvalue="0">
					<xsl:attribute name="value"><xsl:value-of select="$strDirectconnectbasic"/></xsl:attribute>
				<xsl:if test="(EMPSerialConfigObj/connectionModeEnables/Basic='true') and (EMPSerialConfigObj/connectionMode='1') and (EMPSerialConfigObj/connectionModeEnables/Terminal='false')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</xsl:if>
			<xsl:if test="EMPSerialConfigObj/connectionModeSupport/DirTerm='true'">
				<Choice returnvalue="1">
					<xsl:attribute name="value"><xsl:value-of select="$strDirectconectTerminal"/></xsl:attribute>
			<xsl:if test="(EMPSerialConfigObj/connectionModeEnables/Basic='false') and (EMPSerialConfigObj/connectionMode='1') and (EMPSerialConfigObj/connectionModeEnables/Terminal='true')">
								<xsl:attribute name="default">true</xsl:attribute>
						</xsl:if>
				</Choice>
			</xsl:if>
			<xsl:if test="EMPSerialConfigObj/connectionModeSupport/DirBasicTerm='true'">
				<Choice returnvalue="2">
					<xsl:attribute name="value"><xsl:value-of select="$strDirectconnectbasicterm"/></xsl:attribute>
			<xsl:if test="(EMPSerialConfigObj/connectionModeEnables/Basic='true') and (EMPSerialConfigObj/connectionMode='1') and (EMPSerialConfigObj/connectionModeEnables/Terminal='true')">
								<xsl:attribute name="default">true</xsl:attribute>
						</xsl:if>
				</Choice>
			</xsl:if>

			<xsl:if test="EMPSerialConfigObj/connectionModeSupport/ModemBasic='true'">
				<Choice returnvalue="3">
					<xsl:attribute name="value"><xsl:value-of select="$strModemconnectbasic"/></xsl:attribute>
				<xsl:if test="(EMPSerialConfigObj/connectionModeEnables/Basic='true') and (EMPSerialConfigObj/connectionMode='0') and (EMPSerialConfigObj/connectionModeEnables/Terminal='false')">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</xsl:if>
			<xsl:if test="EMPSerialConfigObj/connectionModeSupport/ModemTerm='true'">
				<Choice returnvalue="4">
					<xsl:attribute name="value"><xsl:value-of select="$strModemconectTerminal"/></xsl:attribute>
			<xsl:if test="(EMPSerialConfigObj/connectionModeEnables/Basic='false') and (EMPSerialConfigObj/connectionMode='0') and (EMPSerialConfigObj/connectionModeEnables/Terminal='true')">
								<xsl:attribute name="default">true</xsl:attribute>
						</xsl:if>
				</Choice>
			</xsl:if>
			<xsl:if test="EMPSerialConfigObj/connectionModeSupport/ModemBasicTerm='true'">
				<Choice returnvalue="5">
					<xsl:attribute name="value"><xsl:value-of select="$strModemconnectbasicterm"/></xsl:attribute>
			<xsl:if test="(EMPSerialConfigObj/connectionModeEnables/Basic='true') and (EMPSerialConfigObj/connectionMode='0') and (EMPSerialConfigObj/connectionModeEnables/Terminal='true')">
								<xsl:attribute name="default">true</xsl:attribute>
						</xsl:if>
				</Choice>
			</xsl:if>

			</Data>

    <Data name="BitRate" type="select" editable="true">
				<xsl:attribute name="display"><xsl:value-of select="$strBitRate"/></xsl:attribute>
			
				<xsl:variable name="selectedBitrate" select="EMPSerialConfigObj/commSettingsBitRate"/>
				<xsl:variable name="bitrateCapNode" select="EMPSerialConfigObj/bitRateCapabilities"/>
				<xsl:if test="$bitrateCapNode/bitrate_9600 = 'true'">
					<Choice returnvalue="6" value="{$str9600bps}">
						<xsl:if test="$selectedBitrate = 6"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
					</Choice>
				</xsl:if>
				<xsl:if test="$bitrateCapNode/bitrate_19200 = 'true'">
					<Choice returnvalue="7" value="{$str19200bps}">
						<xsl:if test="$selectedBitrate = 7"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
					</Choice>
				</xsl:if>
				<xsl:if test="$bitrateCapNode/bitrate_38400 = 'true'">
					<Choice returnvalue="8" value="{$str38400bps}">
						<xsl:if test="$selectedBitrate = 8"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
					</Choice>
				</xsl:if>
				<xsl:if test="$bitrateCapNode/bitrate_57600 = 'true'">
					<Choice returnvalue="9" value="{$str57600bps}">
						<xsl:if test="$selectedBitrate = 9"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
					</Choice>
				</xsl:if>
				<xsl:if test="$bitrateCapNode/bitrate_115200 = 'true'">
					<Choice returnvalue="10" value="{$str115200kbps}">
						<xsl:if test="$selectedBitrate = 10"><xsl:attribute name="default">true</xsl:attribute></xsl:if>
					</Choice>
				</xsl:if>
			</Data>

    <Data name="FlowControl" type="select" editable="true">
				<xsl:attribute name="display"><xsl:value-of select="$strFlowControl"/></xsl:attribute>

				<Choice returnvalue="0">
					<xsl:attribute name="value"><xsl:value-of select="$strNone"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/commSettingsFlowControl=0">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="1">
					<xsl:attribute name="value"><xsl:value-of select="$strRTSCTS"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/commSettingsFlowControl=1">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</Data>
	
		


			<Data name="MaxAuth" type="select" editable="true" width="200">
				<xsl:attribute name="display"><xsl:value-of select="$strMaximumUserPrivileges"/></xsl:attribute>
			
		
				<Choice returnvalue="4">
					<xsl:attribute name="value"><xsl:value-of select="$strAdministrator"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/channelAccessLevel=4">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="3">
					<xsl:attribute name="value"><xsl:value-of select="$strOperator"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/channelAccessLevel=3">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>

				<Choice returnvalue="2">
					<xsl:attribute name="value"><xsl:value-of select="$strUser"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/channelAccessLevel=2">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</Data>
		

	</ListData>	

	<!--TableData  columnspacing="true" name="tabUserConfiguration"><xsl:attribute name="display"><xsl:value-of select="$strUserAuthenticationType"/></xsl:attribute>
		<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strUserAuthenticationType"/></xsl:attribute>
		</SubHeader>
		<Header>
			<Data name="" editable="" type="">
				<xsl:attribute name="display"><xsl:value-of select="$strAuthTypes"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strAuthTypes"/></xsl:attribute>
			</Data>
			<Data name="" editable="" type="">
				<xsl:attribute name="display"><xsl:value-of select="$strAdministrator"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strAdministrator"/></xsl:attribute>
			</Data>
			<Data name="" editable="" type="">
				<xsl:attribute name="display"><xsl:value-of select="$strOperator"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strOperator"/></xsl:attribute>
			</Data>
			<Data name="" editable="" type="">
				<xsl:attribute name="display"><xsl:value-of select="$strUser"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strUser"/></xsl:attribute>
			</Data>
		</Header>
			<Row>
			<Data type="ustring" editable="false" width="250">
				<xsl:attribute name="value"><xsl:value-of select="$strStraightPassword"/></xsl:attribute>
			</Data>
			<Data name="AdmAuthText" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPSerialConfigObj/authenTypeEnableAdmin/Text='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
			<Data name="OpAuthText" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPSerialConfigObj/authenTypeEnableOperator/Text='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
			<Data name="UserAuthText" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPSerialConfigObj/authenTypeEnableUser/Text='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
		</Row>
			<Row>
			<Data type="ustring" editable="false" width="250">
				<xsl:attribute name="value"><xsl:value-of select="$strMD2"/></xsl:attribute>
			</Data>
			<Data name="AdmAuthMD2" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPSerialConfigObj/authenTypeEnableAdmin/MD2='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
			<Data name="OpAuthMD2" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPSerialConfigObj/authenTypeEnableOperator/MD2='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
			<Data name="UserAuthMD2" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPSerialConfigObj/authenTypeEnableUser/MD2='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
		</Row>
		<Row>
			<Data type="ustring" editable="false" width="250">
				<xsl:attribute name="value"><xsl:value-of select="$strMD5"/></xsl:attribute>
			</Data>
			<Data name="AdmAuthMD5" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPSerialConfigObj/authenTypeEnableAdmin/MD5='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
			<Data name="OpAuthMD5" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPSerialConfigObj/authenTypeEnableOperator/MD5='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>

			<Data name="UserAuthMD5" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPSerialConfigObj/authenTypeEnableUser/MD5='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>

		</Row>
	</TableData-->


	
				<script language="javascript">
			var usrights = '<xsl:value-of select="/OMA/OMAUserRights"/>';

				function initializationRoutine()
				{

				EnableSettingsAccordingtoUserRights();
					
				}			

				
				function EnableSettingsAccordingtoUserRights()
				{		
					if (usrights != 7 )
					{
						document.getElementById("ConnectionMode").disabled  =true;
						document.getElementById("BitRate").disabled  =true;
						document.getElementById("MaxAuth").disabled  =true;
						document.getElementById("FlowControl").disabled  =true;
						 
					}
				}
				</script>


		</DataArea>
	</xsl:template>

</xsl:stylesheet>