<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" />
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<xsl:choose>
			<xsl:when test="SMStatus != '0'">
				<DataArea>
					<PageTitle>
						<xsl:attribute name="display"><!--XLATESTART-->Erreur ! <!--XLATESTOP--><xsl:call-template name="smstatus"><xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</PageTitle>
				</DataArea>
			</xsl:when>
			<xsl:otherwise>
				<DataArea>
					<PageTitle>
						<xsl:attribute name="display"><!--XLATESTART-->Informations sur le ch&#226;ssis<!--XLATESTOP--></xsl:attribute>
					</PageTitle>
					<ListData>
						<Data>
							<xsl:attribute name="display"><!--XLATESTART-->Index<!--XLATESTOP--></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Chassis/@index"/></xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="display"><!--XLATESTART-->Nom du ch&#226;ssis<!--XLATESTOP--></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Chassis/@display"/></xsl:attribute>
						</Data>
						<xsl:apply-templates select="ChassisInfo"/>
					</ListData>
				</DataArea>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="ChassisInfo">
		<xsl:if test="SystemInfo/SystemName">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->Nom d'h&#244;te<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="SystemInfo/SystemName"/></xsl:attribute>
			</Data>			
		</xsl:if>
		<xsl:if test="FirmwareList">
			<xsl:for-each select="FirmwareList/Firmware">
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="FWText"/><!--XLATESTART--> Version<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="FWVersion"/></xsl:attribute>
				</Data>
			</xsl:for-each>			
		</xsl:if>
		<xsl:if test="ChassisProps1/ChassModel">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->Mod&#232;le de ch&#226;ssis<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="ChassisProps1/ChassModel"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="ChassisProps1/ChassLockPresent">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->Verrou du ch&#226;ssis<!--XLATESTOP--></xsl:attribute>
				<xsl:choose>
					<xsl:when test="ChassisProps1/ChassLockPresent = 'true'">
						<xsl:attribute name="value"><!--XLATESTART-->Pr&#233;sent<!--XLATESTOP--></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><!--XLATESTART-->Absent<!--XLATESTOP--></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
		</xsl:if>
		<xsl:if test="ChassisProps2/ServiceTag">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->&#201;tiquette de service<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="ChassisProps2/ServiceTag"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="ChassisProps2/AssetTag">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->Num&#233;ro d'inventaire<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="ChassisProps2/AssetTag"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="ChassisProps2/FaultLEDControl != '0'">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->Clignotement LED d'erreur pour le niveau de gravit&#233;.<!--XLATESTOP--></xsl:attribute>
				<xsl:choose>
					<xsl:when test="ChassisProps2/FaultLEDControl = '8'">
						<xsl:attribute name="value"><!--XLATESTART-->Avertissement<!--XLATESTOP--></xsl:attribute>
					</xsl:when>
					<xsl:when test="ChassisProps2/FaultLEDControl = '16'">
						<xsl:attribute name="value"><!--XLATESTART-->Critique<!--XLATESTOP--></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><!--XLATESTART-->Non d&#233;fini<!--XLATESTOP--></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
		</xsl:if>
		<xsl:if test="BaseBoardList/@count > '0'">
			<xsl:call-template name="BaseBoard"/>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="BaseBoard">
		<xsl:for-each select="/OMA/BaseBoardList/BaseBoard">
			<xsl:if test="FeatureFlags/HostingBoard='true'">
				<Data name="BladeServiceTag" type="ustring">
					<xsl:attribute name="display"><!--XLATESTART-->&#201;tiquette de service Blade<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
				</Data>
				<Data name="BladeServiceTag" type="ustring">
					<xsl:attribute name="display"><!--XLATESTART-->Num&#233;ro d'inventaire Blade<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="AssetTag"/></xsl:attribute>
				</Data>
				<Data name="BladeLocation" type="ustring">
					<xsl:attribute name="display"><!--XLATESTART-->Emplacement de Blade<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="BoardLocation"/></xsl:attribute>
				</Data>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:param name="mssg"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><!--XLATESTART-->&#201;chec de la commande<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '0'"><!--XLATESTART-->Commande r&#233;ussie<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '1'"><!--XLATESTART-->Commande non impl&#233;ment&#233;e<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '2'"><!--XLATESTART-->Mauvaise commande<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '3'"><!--XLATESTART-->Expiration du d&#233;lai de la commande<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '4'"><!--XLATESTART-->Commande annul&#233;e<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '5'"><!--XLATESTART-->Commande interrompue<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '6'"><!--XLATESTART-->Commande en attente<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '7'"><!--XLATESTART-->Pas de p&#233;riph&#233;rique de ce type<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '8'"><!--XLATESTART-->P&#233;riph&#233;rique occup&#233;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '9'"><!--XLATESTART-->Mauvais p&#233;riph&#233;rique<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '10'"><!--XLATESTART-->Fausse interruption<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '11'"><!--XLATESTART-->Ressource verrouill&#233;e<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '12'"><!--XLATESTART-->L'index n'est pas valide.<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '13'"><!--XLATESTART-->Erreur SMB<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '14'"><!--XLATESTART-->Les donn&#233;es requises ne sont pas disponibles<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '15'"><!--XLATESTART-->Les donn&#233;es requises sont plus nombreuses que les donn&#233;es disponibles<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '16'"><!--XLATESTART-->Les donn&#233;es requises sont moins nombreuses que les donn&#233;es disponibles<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '17'"><!--XLATESTART-->Le p&#233;riph&#233;rique n'est pas encore pr&#234;t &#224; accepter les commandes. Ressayer plus tard<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '18'"><!--XLATESTART-->Le p&#233;riph&#233;rique ne dispose pas de donn&#233;es.<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '19'"><!--XLATESTART-->Le p&#233;riph&#233;rique est &#224; cours de m&#233;moire.<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '20'"><!--XLATESTART-->Le p&#233;riph&#233;rique existe d&#233;j&#224;.<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '256'"><!--XLATESTART-->L'objet est introuvable.<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '257'"><!--XLATESTART-->L'objet est malform&#233;, corrompu ou mauvais.<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '258'"><!--XLATESTART-->L'objet existe d&#233;j&#224;.<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '260'"><!--XLATESTART-->Le fichier INI est introuvable.<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '261'"><!--XLATESTART-->L'INI est malform&#233;, corrompu ou mauvais.<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '262'"><!--XLATESTART-->La section INI n'existe pas.<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '263'"><!--XLATESTART-->La cl&#233; INI n'existe pas.<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '264'"><!--XLATESTART-->La valeur INI est malform&#233;e, corrompue ou mauvaise.<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '270'"><!--XLATESTART-->Privil&#232;ges d'acc&#232;s insuffisants<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '271'"><!--XLATESTART-->Le nom ou la valeur du param&#232;tre n'est pas valide : <!--XLATESTOP--><xsl:value-of select="$mssg"/></xsl:when>
			<xsl:when test="$status = '272'"><!--XLATESTART-->&#192; cours de m&#233;moire<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '280'"><!--XLATESTART-->Le fichier XML est introuvable.<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '281'"><!--XLATESTART-->Le XML est malform&#233;, corrompu ou mauvais.<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '282'"><!--XLATESTART-->Le n&#339;ud XML n'existe pas.<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '283'"><!--XLATESTART-->La valeur XML est malform&#233;e, corrompue ou mauvaise.<!--XLATESTOP--></xsl:when>
		<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>