<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="OMA">
    <DataArea>
      <xsl:choose>
        <xsl:when test="SMStatus = 7">
            <xsl:text>No SNMP traps available for this system.</xsl:text>
        </xsl:when>
        <xsl:otherwise>
			    <PageTitle>
				    <xsl:attribute name="display"><!--XLATESTART-->Current SNMP Trap Configuration<!--XLATESTOP--></xsl:attribute>
			    </PageTitle>
			    <SummaryData>
				    <Section>
					    <xsl:attribute name="display"><!--XLATESTART-->System<!--XLATESTOP--></xsl:attribute>
					    <ListData>
						    <xsl:attribute name="display"><!--XLATESTART-->Settings<!--XLATESTOP--></xsl:attribute>
						    <xsl:call-template name="DisplaySeverity">
							    <xsl:with-param name="severity"><xsl:value-of select="Events/System/snmptrap/@severity"/></xsl:with-param>
						    </xsl:call-template>
					    </ListData>
				    </Section>
				    <xsl:for-each select="Events/ObjType">
					    <Section>
						    <xsl:choose>
							    <xsl:when test="/OMA/Events/ObjList">
								    <xsl:attribute name="display"><xsl:call-template name="getObjTypeName"><xsl:with-param name="objtype"><xsl:value-of select="@type"/></xsl:with-param></xsl:call-template> Group</xsl:attribute>
							    </xsl:when>
							    <xsl:otherwise>
								    <xsl:attribute name="display"><xsl:call-template name="getObjTypeName"><xsl:with-param name="objtype"><xsl:value-of select="@type"/></xsl:with-param></xsl:call-template></xsl:attribute>
							    </xsl:otherwise>
						    </xsl:choose>
						    <ListData>
							    <xsl:attribute name="display"><!--XLATESTART-->Settings<!--XLATESTOP--></xsl:attribute>
							    <xsl:variable name="severityfactor"><xsl:call-template name="computeSeverityFactor">
								    <xsl:with-param name="systemSeverity"><xsl:value-of select="/OMA/Events/System/snmptrap/@severity"/></xsl:with-param>
								    <xsl:with-param name="childSeverity"><xsl:value-of select="snmptrap/@severity"/></xsl:with-param>
							    </xsl:call-template></xsl:variable>
							    <xsl:choose>
								    <xsl:when test=" $severityfactor = 1 ">
									    <xsl:call-template name="DisplaySeverity">
										    <xsl:with-param name="severity"><xsl:value-of select="snmptrap/@severity"/></xsl:with-param>
									    </xsl:call-template>
								    </xsl:when>
								    <xsl:otherwise>
									    <xsl:call-template name="DisplaySeverity">
										    <xsl:with-param name="severity"><xsl:value-of select="/OMA/Events/System/snmptrap/@severity"/></xsl:with-param>
									    </xsl:call-template>
								    </xsl:otherwise>
							    </xsl:choose>
						    </ListData>
					    </Section>
				    </xsl:for-each>
				    <xsl:apply-templates select="Events/ObjList"/>
			    </SummaryData>
        </xsl:otherwise>
      </xsl:choose>          
		</DataArea>
  </xsl:template>	
	<xsl:template match="ObjList">
	     <xsl:if test="@type!= 31">
			<Section>
			<xsl:attribute name="display">Individual Objects</xsl:attribute>
			<xsl:for-each select="Object">
				<ListData>
					<xsl:attribute name="display"><xsl:value-of select="Name"/><!--XLATESTART--> Settings<!--XLATESTOP-->	</xsl:attribute>
					<Data>
						<xsl:attribute name="display"><!--XLATESTART-->Index<!--XLATESTOP--></xsl:attribute>
						<xsl:attribute name="value">
						     <xsl:value-of select="@index"/>
						</xsl:attribute>
					</Data>
					
					<xsl:call-template name="DisplaySeverity">
						<xsl:with-param name="severity"><xsl:value-of select="snmptrap/@severity"/></xsl:with-param>
					</xsl:call-template>
				</ListData>
			</xsl:for-each>
		</Section>
		</xsl:if>
	</xsl:template>	
	<xsl:template name="computeSeverityFactor">
		<xsl:param name="systemSeverity"/>
		<xsl:param name="childSeverity"/>
		<xsl:variable name="sysnum"><xsl:call-template name="mapSeverityToNumber">
				<xsl:with-param name="severity"><xsl:value-of select="$systemSeverity"/></xsl:with-param>
		</xsl:call-template></xsl:variable>
		<xsl:variable name="childnum"><xsl:call-template name="mapSeverityToNumber">
				<xsl:with-param name="severity"><xsl:value-of select="$childSeverity"/></xsl:with-param>
		</xsl:call-template></xsl:variable>
		<xsl:choose>
			<xsl:when test=" $sysnum &gt; $childnum">0</xsl:when>
			<xsl:otherwise>1</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="mapSeverityToNumber">
		<xsl:param name="severity"/>
		<xsl:choose>
			<xsl:when test=" $severity = 'informational' ">1</xsl:when>
			<xsl:when test=" $severity = 'warning' ">2</xsl:when>
			<xsl:when test=" $severity = 'critical' ">3</xsl:when>
			<xsl:when test=" $severity = 'none' ">4</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DisplaySeverity">
		<xsl:param name="severity"/>
		<xsl:choose>
			<xsl:when test=" $severity = 'informational' ">
			<xsl:choose>
				<xsl:when test="@type =40">
				<Data>
					<xsl:attribute name="display"><!--XLATESTART-->Enable<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><!--XLATESTART-->Informational<!--XLATESTOP--></xsl:attribute>
				</Data>
				</xsl:when>
				<xsl:otherwise>
				<Data>
					<xsl:attribute name="display"><!--XLATESTART-->Enable<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><!--XLATESTART-->Informational, Warning and Critical<!--XLATESTOP--></xsl:attribute>
				</Data>
				</xsl:otherwise>
			</xsl:choose>
				<Data>
					<xsl:attribute name="display"><!--XLATESTART-->Disable<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><!--XLATESTART-->None<!--XLATESTOP--></xsl:attribute>
				</Data>
			</xsl:when>
			<xsl:when test=" $severity = 'warning' ">
				<Data>
					<xsl:attribute name="display"><!--XLATESTART-->Enable<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><!--XLATESTART-->Warning and Critical<!--XLATESTOP--></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><!--XLATESTART-->Disable<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><!--XLATESTART-->Informational<!--XLATESTOP--></xsl:attribute>
				</Data>
			</xsl:when>
			<xsl:when test=" $severity = 'critical' ">
				<Data>
					<xsl:attribute name="display"><!--XLATESTART-->Enable<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><!--XLATESTART-->Critical<!--XLATESTOP--></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><!--XLATESTART-->Disable<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><!--XLATESTART-->Informational and Warning<!--XLATESTOP--></xsl:attribute>
				</Data>
			</xsl:when>
			<xsl:when test=" $severity = 'none' ">
				<Data>
					<xsl:attribute name="display"><!--XLATESTART-->Enable<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><!--XLATESTART-->None<!--XLATESTOP--></xsl:attribute>
				</Data>
				<xsl:choose>
				<xsl:when test="@type =40">
				<Data>
					<xsl:attribute name="display"><!--XLATESTART-->Disable<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><!--XLATESTART-->Informational<!--XLATESTOP--></xsl:attribute>
				</Data>
				</xsl:when>
				<xsl:otherwise>
				<Data>
					<xsl:attribute name="display"><!--XLATESTART-->Disable<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><!--XLATESTART-->Informational, Warning and Critical<!--XLATESTOP--></xsl:attribute>
				</Data>
				</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<Data>
					<xsl:attribute name="display"><!--XLATESTART-->Enable<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><!--XLATESTART-->Unknown<!--XLATESTOP--></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><!--XLATESTART-->Disable<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><!--XLATESTART-->Unknown<!--XLATESTOP--></xsl:attribute>
				</Data>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="getObjTypeName">
		<xsl:param name="objtype"/>
		<xsl:choose>
			<xsl:when test="$objtype =  2 "><!--XLATESTART-->Redundancy<!--XLATESTOP--></xsl:when>
			<xsl:when test="$objtype =  21 "><!--XLATESTART-->Power Supplies<!--XLATESTOP--></xsl:when>
			<xsl:when test="$objtype =  22 "><!--XLATESTART-->Temperatures<!--XLATESTOP--></xsl:when>
			<xsl:when test="$objtype =  23 "><!--XLATESTART-->Fans<!--XLATESTOP--></xsl:when>
			<xsl:when test="$objtype =  24 "><!--XLATESTART-->Voltages<!--XLATESTOP--></xsl:when>
			<xsl:when test="$objtype =  25 "><!--XLATESTART-->System Power<!--XLATESTOP--></xsl:when>
			<xsl:when test="$objtype =  28 "><!--XLATESTART-->Intrusion<!--XLATESTOP--></xsl:when>
			<xsl:when test="$objtype =  31 "><!--XLATESTART-->Logs<!--XLATESTOP--></xsl:when>
			<xsl:when test="$objtype =  35 "><!--XLATESTART-->Fan Enclosure<!--XLATESTOP--></xsl:when>
			<xsl:when test="$objtype =  37 "><!--XLATESTART-->AC Cord<!--XLATESTOP--></xsl:when>
			<xsl:when test="$objtype =  225 "><!--XLATESTART-->Memory<!--XLATESTOP--></xsl:when>
			<xsl:when test="$objtype =  27 "><!--XLATESTART-->Battery<!--XLATESTOP--></xsl:when>
			<xsl:when test="$objtype =  40 "><!--XLATESTART-->System Peak Power<!--XLATESTOP--></xsl:when>
			<xsl:when test="$objtype =  52 "><!--XLATESTART-->Removable Flash Media<!--XLATESTOP--></xsl:when>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>