<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="OMA">
          <xsl:choose>  			
			 <xsl:when test="/OMA/elevatedAdmin = 'true' ">
			 <DataArea>
			    <TableData columnspacing="true" name="ElevatedAdmin">	          		                 
					<SubHeader value="ErrorElevatedAdmin">
				                  <xsl:attribute name="display">Error! User has insufficient privileges to run command.</xsl:attribute>
				       </SubHeader>
					   </TableData>
		      </DataArea>
			  </xsl:when>
              <xsl:otherwise>
				<DataArea>
			    <TableData columnspacing="true" name="BIOSBootSeq">	          		                 
					<SubHeader value="BIOSBoot">
				                   <xsl:attribute name="display">BIOS Boot Sequence</xsl:attribute>
				       </SubHeader>
				       
					<Header>
						<Data >
							<xsl:attribute name="display">Device Name</xsl:attribute>
							<xsl:attribute name="value">Device Name</xsl:attribute>
						</Data>
						<Data >
							<xsl:attribute name="display">Alias Name</xsl:attribute>
							<xsl:attribute name="value">Alias Name</xsl:attribute>
						</Data>
						<Data >
							<xsl:attribute name="display">State</xsl:attribute>
							<xsl:attribute name="value">State</xsl:attribute>
						</Data>

					</Header>					
						<xsl:apply-templates select="BIOSBootSpecObj/IPLPriorityListarray"/>
				</TableData>

				<TableData columnspacing="true" name="BIOShddSeq">	          		                  
					<SubHeader value="BIOSBoot">
				                   <xsl:attribute name="display">BIOS Hard Disk Sequence</xsl:attribute>
				       </SubHeader>
				       
					<Header>
						<Data >
							<xsl:attribute name="display">Device Name</xsl:attribute>
							<xsl:attribute name="value">Device Name</xsl:attribute>
						</Data>
						<Data >
							<xsl:attribute name="display">Alias Name</xsl:attribute>
							<xsl:attribute name="value">Alias Name</xsl:attribute>
						</Data>
					</Header>					
						<xsl:apply-templates select="BIOSBootSpecObj/BCVPriorityListarray"/>
				</TableData>
			</DataArea>
			</xsl:otherwise>
			</xsl:choose>
		</xsl:template>
		<xsl:template match="BIOSBootSpecObj/BCVPriorityListarray">
			<xsl:apply-templates select="BCVPriorityList"/>
		</xsl:template>

		<xsl:template match="BIOSBootSpecObj/IPLPriorityListarray">
			<xsl:apply-templates select="IPLPriorityList"/>
		</xsl:template>

		<xsl:template match="IPLPriorityList">
				<xsl:variable name="currval"><xsl:value-of select="."/></xsl:variable>
				<xsl:variable name="curindex"><xsl:value-of select="@index"/></xsl:variable>
				<xsl:if test="$currval != '255' " >
					<Row>
						<Data>
							<xsl:attribute name="display">Device Name</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="/OMA/BootDeviceObj[index=$currval and objType=0]/Description"/></xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="display">Alias Name</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="/OMA/AliasNames/IPLDeviceAlias[@index=$currval]"/></xsl:attribute>
						</Data>
						
						<Data>
							<xsl:attribute name="display">State</xsl:attribute>
							<xsl:if test="/OMA/BIOSBootSpecObj/IPLSkipListarray/IPLSkipList[@index=$curindex] ='1'">
							<xsl:attribute name="value">Enabled</xsl:attribute>
							</xsl:if>
							<xsl:if test="/OMA/BIOSBootSpecObj/IPLSkipListarray/IPLSkipList[@index=$curindex] ='0'">
							<xsl:attribute name="value">Disabled</xsl:attribute>
							</xsl:if>
						</Data>  
					</Row>
				</xsl:if>
		</xsl:template>

		<xsl:template match="BCVPriorityList">
				<xsl:variable name="currval"><xsl:value-of select="."/></xsl:variable>
				<xsl:if test="$currval != '255' " >
					<Row>
						<Data>
							<xsl:attribute name="display">Device Name</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="/OMA/BootDeviceObj[index=$currval and objType=1]/Description"/></xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="display">Alias Name</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="/OMA/AliasNames/BCVDeviceAlias[@index=$currval]"/></xsl:attribute>
						</Data>						
					</Row>
				</xsl:if>
		</xsl:template>
</xsl:stylesheet>
