<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:strip-space elements="*"/>
	<xsl:output method="xml" indent="no"/>
	<xsl:template match="/OMA">
		<xsl:choose>
    <xsl:when test="(SMStatus = '0' ) and (HIIFormObj/hdr/FQDD ='BIOS.Setup.1-1') and (@cli='true')">
        <xsl:call-template name="HIICLI"/>
    </xsl:when>      
	<xsl:otherwise>
		<xsl:call-template name="failure"/>
	</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="failure">
		<DataArea>
			<PageTitle>
				<xsl:choose>
					<xsl:when test="SMStatus = '256'">
						<xsl:attribute name="display">Error! Command unsuccessful.</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="display">Error! Command unsuccessful.</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</PageTitle>
		</DataArea>
	</xsl:template>

<xsl:template name="HIICLI">
<DataArea>
	<PageTitle>
		<xsl:attribute name="display">System BIOS Settings</xsl:attribute>
	</PageTitle>			
	<ListData type="custom">			
		<xsl:for-each select="HIIFormObj">	
			<xsl:sort select="hdr/displayIndex" order="ascending" data-type="number"/>
			<xsl:if test="hdr/bSuppressed='false' and hdr/Name!='SysBiosSettingsForm'">
				<Data emptyline="true"/>        
				<Data emptyvalue="true">          	
					<xsl:attribute name="display"><xsl:value-of select="hdr/DisplayName"/></xsl:attribute>
				</Data>
				<Data emptyvalue="true">
				   <xsl:attribute name="display">------------------------------------------</xsl:attribute>
				</Data>
					<xsl:variable name="formons"><xsl:value-of select="@ons"/></xsl:variable>		
				<xsl:apply-templates select="../HIIEnumObj | ../HIIStringObj | ../HIIIntegerObj | ../HIIOrderedListObj">
					<xsl:sort select="hdr/displayIndex" data-type="number" order="ascending"/>
					<xsl:with-param name="formons" select="$formons"/>
				</xsl:apply-templates>		
			</xsl:if>      	
		</xsl:for-each>  
	</ListData>
</DataArea>
</xsl:template>

<xsl:template match="HIIEnumObj">
	<xsl:param name="formons"/>
	
	<xsl:if test="hdr/bSuppressed='false'">
		<xsl:variable name="subons"><xsl:value-of select="substring-before(@ons,'/HIIEnumObj')"/></xsl:variable>
			<xsl:if test ="$formons = $subons">
				<xsl:variable name="attrState">
				<xsl:choose>
					<xsl:when test="bPendingValid ='true'">
						<xsl:value-of select="pendingState"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="currentState"/>
					</xsl:otherwise>
				</xsl:choose>	
				</xsl:variable>
				<xsl:choose>
					<xsl:when test ="numDependencies &gt; '0'">
						<xsl:variable name="strDepcheck"><xsl:call-template name="depsAttributeCheck"/></xsl:variable>
						<xsl:if test ="$strDepcheck &gt; '0'">
							<xsl:call-template name="EnumObjattrDeps">									
								<xsl:with-param name="attrState"><xsl:value-of select="$attrState"/></xsl:with-param>								
							</xsl:call-template>			
						</xsl:if>
					</xsl:when>
					<xsl:otherwise>					
						<xsl:call-template name="EnumObjattrDeps">				
							<xsl:with-param name="attrState"><xsl:value-of select="$attrState"/></xsl:with-param>				
						</xsl:call-template>							
					</xsl:otherwise>
				</xsl:choose>
		</xsl:if>
	</xsl:if>
</xsl:template>
	
<xsl:template match="HIIStringObj">
	<xsl:param name="formons"/>
	
	<xsl:if test="hdr/bSuppressed='false'">
		<xsl:variable name="subons"><xsl:value-of select="substring-before(@ons,'/HIIStringObj')"/></xsl:variable>
		<xsl:if test="$formons = $subons">
			<xsl:variable name="Strvalue">
			<xsl:choose>
				<xsl:when test="Pending/@isnull and Pending/@isnull =  'true'">
					<xsl:value-of select="Current"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="Pending"/>
				</xsl:otherwise>
			</xsl:choose>	
			</xsl:variable>
			<xsl:choose>				
				<xsl:when test = "numDependencies &gt; '0'">			    
				<xsl:variable name="strDepcheck"><xsl:call-template name="depsAttributeCheck"/></xsl:variable>				
				<xsl:if test="$strDepcheck &gt; '0'">
					<xsl:call-template name="str_pending_current">					
						<xsl:with-param name="Strvalue"><xsl:value-of select="$Strvalue"/></xsl:with-param>
					</xsl:call-template>
				</xsl:if>							
				</xsl:when>
				<xsl:otherwise>				
					<xsl:call-template name="str_pending_current">					
						<xsl:with-param name="Strvalue"><xsl:value-of select="$Strvalue"/></xsl:with-param>
					</xsl:call-template>						
				</xsl:otherwise>
				</xsl:choose>								
		</xsl:if>
	</xsl:if>
</xsl:template>
	
<xsl:template match="HIIIntegerObj">
	<xsl:param name="formons"/>		
	
	<xsl:if test="hdr/bSuppressed='false'">
		<xsl:variable name="subons"><xsl:value-of select="substring-before(@ons,'/HIIIntegerObj')"/></xsl:variable>
		<xsl:if test="$formons = $subons">
			<xsl:choose>						
	            <xsl:when test = "numDependencies &gt; '0'">
				 <xsl:variable name="strDepcheck"><xsl:call-template name="depsAttributeCheck"/></xsl:variable>
					<xsl:if test="$strDepcheck &gt; '0'">
						<xsl:call-template name="int_pending_current"/>
					</xsl:if>	
				</xsl:when>					
				<xsl:otherwise>														
					<xsl:call-template name="int_pending_current"/>				
				</xsl:otherwise>										
			</xsl:choose>
		</xsl:if>
	</xsl:if>		
</xsl:template>

<xsl:template match="HIIOrderedListObj">
<xsl:param name="formons"/>		
	<xsl:if test="hdr/bSuppressed='false'">
		<xsl:variable name="subons"><xsl:value-of select="substring-before(@ons,'/HIIOrderedListObj')"/></xsl:variable>
		<xsl:if test="$formons = $subons">
			<xsl:choose>
			<xsl:when test = "numDependencies &gt; '0'">
			<xsl:variable name="strDepcheck"><xsl:call-template name="depsAttributeCheck"/></xsl:variable>				
				<xsl:if test="$strDepcheck &gt; '0'">
					<xsl:call-template name="OrdListEntObj">
						<xsl:with-param name="strAllowEnDisEntries"><xsl:value-of select="bAllowEnDisEntries"/></xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>										
				<xsl:call-template name="OrdListEntObj">
						<xsl:with-param name="strAllowEnDisEntries"><xsl:value-of select="bAllowEnDisEntries"/></xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:if>	
</xsl:template>

<xsl:template name="depsAttributeCheck">
	<xsl:for-each select ="dependenciesarray/dependencies">				
		<xsl:variable name="depName"><xsl:value-of select="Name"/> </xsl:variable>
		<xsl:variable name="depvalue"><xsl:value-of select="Value"/> </xsl:variable>
		<xsl:variable name="curState" select="//HIIEnumObj[hdr/Name = $depName]/currentState"/>
		<xsl:variable name="stateNum" select="//HIIEnumValueObj[Name = $depvalue]/stateNumber"/>					
		<xsl:choose>
			<xsl:when test ="(Type ='SuppressIf' and $curState != $stateNum) or (Type ='SuppressIfNot' and $curState = $stateNum) or Type ='ReadOnlyIf' or Type ='ReadOnlyIfNot'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>					
		</xsl:choose>				
	</xsl:for-each>
</xsl:template>
				
<xsl:template name="EnumObjattrDeps">	
	<xsl:param name="attrState"/>
		<xsl:variable name="parentons"><xsl:value-of select="@ons"/></xsl:variable>			
			<Data>			
				<xsl:attribute name="display"><xsl:value-of select="hdr/Name"/></xsl:attribute>
				<xsl:for-each select="//HIIEnumValueObj[substring-before(@ons,'/HIIEnumValueObj') = $parentons]">
					<xsl:variable name="valstateNum"><xsl:value-of select="stateNumber"/></xsl:variable>
					<xsl:if test=" ($attrState = $valstateNum)">
						<xsl:attribute name="value"><xsl:value-of select="Name"/> </xsl:attribute>
					</xsl:if>
				</xsl:for-each>
			</Data>			
</xsl:template>
<xsl:template name="OrdListEntObj">	
	<xsl:param name="strAllowEnDisEntries"/>
	<xsl:variable name="parentons"><xsl:value-of select="@ons"/></xsl:variable>	
	<Data emptyline="true"/>
	<Data emptyvalue="true">
		<xsl:attribute name="display"><xsl:value-of select="hdr/Name"/></xsl:attribute>
	</Data>   
	
	<xsl:for-each select="//HIIOrderedListEntryObj[bPendingValid='true']">	
	<xsl:sort select="pendingIndex" data-type="number" order="ascending"/>
	<xsl:if test="hdr/bSuppressed='false'">
	<xsl:variable name="childons"><xsl:value-of select="substring-before(@ons,'/HIIOrderedListEntryObj')"/></xsl:variable>
	<xsl:if test="$parentons = $childons">		
		<Data>			
			<xsl:if test="$strAllowEnDisEntries='true'">
			<xsl:choose>
			<xsl:when test="bPendingEnabled='true'">
				<xsl:attribute name="value"><xsl:value-of select="pendingIndex+1"/>. Enabled: <xsl:value-of select="hdr/Name"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="value"><xsl:value-of select="pendingIndex+1"/>. Disabled: <xsl:value-of select="hdr/Name"/></xsl:attribute>
			</xsl:otherwise>
			</xsl:choose>	
			</xsl:if>
			<xsl:if test="$strAllowEnDisEntries='false'">			
				<xsl:attribute name="value"><xsl:value-of select="pendingIndex+1"/>. <xsl:value-of select="hdr/Name"/></xsl:attribute>
			</xsl:if>
		</Data>	
	</xsl:if>
	</xsl:if>
	</xsl:for-each>
	
	<xsl:for-each select="//HIIOrderedListEntryObj[bPendingValid='false']">	
	<xsl:sort select="currentIndex" data-type="number" order="ascending"/>
	<xsl:if test="hdr/bSuppressed='false'">
	<xsl:variable name="childons"><xsl:value-of select="substring-before(@ons,'/HIIOrderedListEntryObj')"/></xsl:variable>
	<xsl:if test="$parentons = $childons">		
		<Data>						
		<xsl:if test="$strAllowEnDisEntries='true'">
			<xsl:choose>
			<xsl:when test="bCurrentEnabled='true'">
				<xsl:attribute name="value"><xsl:value-of select="currentIndex+1"/>. Enabled: <xsl:value-of select="hdr/Name"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="value"><xsl:value-of select="currentIndex+1"/>. Disabled: <xsl:value-of select="hdr/Name"/></xsl:attribute>
			</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$strAllowEnDisEntries='false'">			
			<xsl:attribute name="value"><xsl:value-of select="currentIndex+1"/>. <xsl:value-of select="hdr/Name"/></xsl:attribute>			
		</xsl:if>
		</Data>	
	</xsl:if>
	</xsl:if>
	</xsl:for-each>
	
</xsl:template>

<xsl:template name="str_pending_current">
<xsl:param name="Strvalue"/>
<Data>
	<xsl:attribute name="display"><xsl:value-of select="hdr/Name"/></xsl:attribute>
	<xsl:attribute name="value"><xsl:value-of select="$Strvalue"/></xsl:attribute>
</Data>
</xsl:template>

<xsl:template name="int_pending_current">
	<Data>
	<xsl:attribute name="display"><xsl:value-of select="hdr/Name"/></xsl:attribute>
	<xsl:choose>
	<xsl:when test="bPendingValid ='true'">
		<xsl:attribute name="value"><xsl:value-of select="pendingValue"/></xsl:attribute>
	</xsl:when>
	<xsl:otherwise>
		<xsl:attribute name="value"><xsl:value-of select="currentValue"/></xsl:attribute>
	</xsl:otherwise>
	</xsl:choose>
	</Data>	
</xsl:template>

	
	<xsl:template match="*"/>
</xsl:stylesheet>
