#! /bin/sh

. ./autoconf_cim_component.conf

OPENWSMAN_CONF_FILE="/etc/openwsman/openwsman.conf"
OPENWSMAN_CONF_FILE_RPM="/etc/openwsman/openwsman.conf.rpmsave"
SFCB_REG_FILE="/etc/sfcb/sfcb.cfg"
SFCB_REG_FILE_RPM="/etc/sfcb/sfcb.cfg.rpmsave"
server_tag=0
cim_tag=0
has_come_in_server=0
has_come_in_cim=0
server_tag_str="[server]"
cim_tag_str="[cim]"
basic_authenticator=0
temp_file_location=/tmp/temp.conf
temp_file_location2=/tmp/temp2.conf
has_found_frontend_tag=0


while getopts hp: OPTION
do
    case ${OPTION} in
        h)echo " "
          echo "Usage: sh autoconf_cim_component.sh [OPTIONS]"
          echo "-p <port>       Sets openwsman port."
          echo "-h              Shows this help."
          echo " "
          exit ;;
        p)dcim_wsman_port=${OPTARG};;
    esac
done



echo  "Program will try to find the installed Arch else default to system's Arch."
file `find /opt/dell/srvadmin/lib* -name "libcmpiTunnelProvider*"` | grep "64-bit" > /dev/null 2>&1	
if [ $? -eq 0 ]; then
	ARCH="x86_64"
else
	file `find /opt/dell/srvadmin/lib* -name "libcmpiTunnelProvider*"` | grep "32-bit" > /dev/null 2>&1
	if [ $? -eq 0 ]; then
		ARCH="i686"
		
	else
		ARCH=`uname -m`		
	fi
fi    	

echo "Architecture = $ARCH"

if [ $ARCH = "x86_64" ]; then
	LIB=lib64
else
	LIB=lib
fi

if [ -f /etc/vmware-release ]; then
	echo "ESX does not need configuration...."
	exit 0
fi


rpm -qa | grep openwsman-server > /dev/null 2>&1
if [ $? -ne 0 ]; then
rpm -qa | grep openwsman > /dev/null 2>&1
if [ $? -ne 0 ]; then
	echo "openwsman rpm is not installed..!!"
	exit 1
fi
fi


if [ ! -f $OPENWSMAN_CONF_FILE ]; then
	echo "Could not find $OPENWSMAN_CONF_FILE..!!"
	exit 1
fi

rpm -qa | grep sblim-sfcb > /dev/null 2>&1
if [ $? -ne 0 ]; then
        echo "sblim-sfcb is not installed...!!"
        exit 1
fi

if [ ! -f $SFCB_REG_FILE ]; then
        echo "Could not find $SFCB_REG_FILE..!!"
        exit 1
fi


rm -f $temp_file_location > /dev/null 2>&1

echo "Configuring wsman..........."
while read path
do
	#echo $path
	if test "$path" = $server_tag_str
	then
		cim_tag=0
		server_tag=1
		if [ $has_come_in_server -eq 1 ]; then
			echo "$OPENWSMAN_CONF_FILE is corrupt - cannot have [server] tag more than once..!!"
			exit 1
		fi
		has_come_in_server=1
	elif test "$path" = $cim_tag_str 
	then
		server_tag=0
		cim_tag=1
		if [ $has_come_in_cim -eq 1 ]; then
                        echo "$OPENWSMAN_CONF_FILE is corrupt - cannot have [cim] tag more than once..!!"
			exit 1
                fi
                has_come_in_cim=1

	fi
	
	if [ $server_tag -eq 1 ]; then
		if [[ "$path" =~ "ssl_port" ]] ; then 	
			echo "ssl_port = $dcim_wsman_port" >> $temp_file_location 
		elif [[ "$path" =~ "digest_password_file" ]] && [[ "$dcim_wsman_pam_enable" =~ "yes" ]]; then
			tempPath=`echo ${path:0:1}`
			if test "$tempPath" = "#" 
			then
                        	echo "$path" >> $temp_file_location
			else
				echo "#$path" >> $temp_file_location
			fi
		elif [[ "$path" =~ "digest_password_file" ]] && [[ "$dcim_wsman_pam_enable" =~ "no" ]]; then
			tempPath=`echo ${path:0:1}`
                        if test "$tempPath" = "#" 
			then
				tempPath1=`echo ${path###*#}`
				if test $tempPath1 = $path
				then
                                	tempPath=`echo ${path:1}`
                                	echo "$tempPath" >> $temp_file_location 
				else
					echo "$tempPath1" >> $temp_file_location 
				fi
                        else
                                echo "$path" >> $temp_file_location 
                        fi
                elif [[ "$path" =~ "basic_password_file" ]] && [[ "$dcim_wsman_pam_enable" =~ "yes" ]]; then
			tempPath=`echo ${path:0:1}`
			if test "$tempPath" = "#" 
			then
				echo "$path" >> $temp_file_location 
			else
                        	echo "#$path" >> $temp_file_location 
			fi
		elif [[ "$path" =~ "basic_password_file" ]] && [[ "$dcim_wsman_pam_enable" =~ "no" ]]; then
			tempPath=`echo ${path:0:1}`
			if test "$tempPath" = "#" 
			then
				tempPath1=`echo ${path###*#}`
				if test $tempPath1 = $path
				then
					tempPath=`echo ${path:1}`
					echo "$tempPath" >> $temp_file_location 
				else
					echo "$tempPath1" >> $temp_file_location 
				fi
			else
				echo "$path" >> $temp_file_location 
			fi
                elif [[ "$path" =~ "basic_authenticator_arg" ]]; then
			if [[ "$dcim_wsman_pam_enable" =~ "yes" ]]; then
	                        echo "basic_authenticator_arg = openwsman" >> $temp_file_location 
			else
				echo "#basic_authenticator_arg = openwsman" >> $temp_file_location 
			fi
		elif [[ "$path" =~ "basic_authenticator" ]]; then
                        if [ $basic_authenticator -eq 0 ]; then
				if [[ "$dcim_wsman_pam_enable" =~ "yes" ]]; then
                                	echo "basic_authenticator = libwsman_pam_auth.so" >> $temp_file_location 
				else
					echo "#basic_authenticator = libwsman_pam_auth.so" >> $temp_file_location 
				fi
				basic_authenticator=1
                        elif [[ "$path" =~ "basic_authenticator_arg" ]] ; then
				if [[ "$dcim_wsman_pam_enable" =~ "yes" ]]; then
                                	echo "basic_authenticator_arg = openwsman" >> $temp_file_location
				else
					echo "#basic_authenticator_arg = openwsman" >> $temp_file_location 
				fi
                        fi

		else
			echo $path >> $temp_file_location 
                fi

	elif [ $cim_tag -eq 1 ]; then
		first_str=`echo $path | awk '{print $1}'` > /dev/null 2>&1
		if test "$first_str" = "#" 
		then
			if [[ "$path" =~ "host" ]] && [[ "$path" =~ "=" ]]; then
				echo "host = $dcim_cimom_ip" >> $temp_file_location 
			elif [[ "$path" =~ "port" ]] && [[ "$path" =~ "=" ]] && [[ "$path" =~ "5988" ]]; then
				echo "port = $dcim_cimom_port" >> $temp_file_location 	
			elif [[ "$path" =~ "cim_client_frontend" ]] && [[ "$path" =~ "=" ]] ; then 
				echo "cim_client_frontend = $dcim_client_frontend" >> $temp_file_location
				has_found_frontend_tag=1
		    elif [[ "$path" =~ "vendor_namespaces" ]] && [[ "$path" =~ "=" ]] ; then
			    echo $path |grep "DCIM=http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2" > /dev/null 2>&1
					  if [ $? -ne 0 ]; then
						   echo "${path},${dcim_namespace} " >> $temp_file_location
					   else
						 echo $path >> $temp_file_location
					  fi               
			else
				echo $path >> $temp_file_location 
			fi
		else
			if [[ "$path" =~ "host" ]] ; then
                        	echo "host = $dcim_cimom_ip" >> $temp_file_location 
			elif [[ "$path" =~ "port" ]] ; then
				echo "port = $dcim_cimom_port" >> $temp_file_location 
			elif [[ "$path" =~ "cim_client_frontend" ]] ; then
				echo "cim_client_frontend = $dcim_client_frontend" >> $temp_file_location
				has_found_frontend_tag=1
			elif [[ "$path" =~ "vendor_namespaces" ]] ; then
                echo $path |grep "DCIM=http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2" > /dev/null 2>&1
					  if [ $? -ne 0 ]; then
						   echo "${path},${dcim_namespace} " >> $temp_file_location
					   else
						 echo $path >> $temp_file_location
					  fi  
			else
				echo $path >> $temp_file_location 
			fi
		fi
	else
		echo $path >> $temp_file_location 
	fi


done < $OPENWSMAN_CONF_FILE

if [ $has_found_frontend_tag -eq 0 ] ; then

	while read path2
	do
		if test "$path2" = "$cim_tag_str" 
		then
			echo $path2 >> $temp_file_location2	
			echo "cim_client_frontend = $dcim_client_frontend" >> $temp_file_location2
		else
			echo $path2 >> $temp_file_location2
		fi
	done < $temp_file_location	

	
fi

cp $OPENWSMAN_CONF_FILE $OPENWSMAN_CONF_FILE_RPM > /dev/null 2>&1
echo "Saving $OPENWSMAN_CONF_FILE as $OPENWSMAN_CONF_FILE_RPM ..."

if [ $has_found_frontend_tag -eq 0 ] ; then

	cp -f $temp_file_location2 $OPENWSMAN_CONF_FILE > /dev/null 2>&1
	if [ $? -ne 0 ]; then
		echo "Cound not update $OPENWSMAN_CONF_FILE..!!"
		exit 1
	fi
else
	
	cp -f $temp_file_location $OPENWSMAN_CONF_FILE > /dev/null 2>&1
	if [ $? -ne 0 ]; then
		echo "Cound not update $OPENWSMAN_CONF_FILE..!!"
		exit 1
	fi
fi

echo "CREATING LINK"
# Now make ssl link's if not already there
 path="/usr/$LIB"	


wsman_rpm=`rpm -qa | grep openwsman-server` > /dev/null 2>&1
if [ $? -ne 0 ]; then
	wsman_rpm=`rpm -qa | grep openwsman` > /dev/null 2>&1
fi

ssl_requires=`rpm -q --requires $wsman_rpm | grep ssl | cut -f 1 -d "("` 


#echo "SSL_REQ="$ssl_requires

if [ -f /usr/$LIB/$ssl_requires ]; then
	
	ssl_lib_path=/usr/$LIB/$ssl_requires > /dev/null > /dev/null 2>&1	
#	echo $ssl_lib_path	
elif [ -f /$LIB/$ssl_requires ]; then
	ssl_lib_path=/$LIB/$ssl_requires > /dev/null > /dev/null 2>&1
#	echo $ssl_lib_path	
	path=/$LIB
	
fi

if [ -f $ssl_lib_path ]; then
	echo "Creating ssl symbolic link...."
#	echo "SSLPATH="$ssl_lib_path
#	echo "PATH="$path	
	ln -sf $ssl_lib_path $path/libssl.so
else
	echo "required $ssl_requires for openwsman is missing!!! Please install the same from openssl"
fi

#changing runlevels for wsman server if it is not already done at service installation time.
chkconfig --level 2345 openwsmand on > /dev/null 2>&1

# update sfcb reg file
rm -f $temp_file_location > /dev/null 2>&1
rm -f $temp_file_location2 > /dev/null 2>&1

echo "Configuring sfcb...."

while read path
do
	if [[ "$path" =~ "enableHttp:" ]] && [[ "$dcim_cimom_interface_http" =~ "yes" ]]; then
		echo "enableHttp:	true" >> $temp_file_location 
	elif [[ "$path" =~ "enableHttp:" ]]; then
		echo "enableHttp:       false" >> $temp_file_location
	else
		echo $path >> $temp_file_location
	fi

done < $SFCB_REG_FILE
 
chkconfig --level 2345 sfcb on > /dev/null 2>&1
# in RHEL6.4 versions sfcb service name is sblim-sfcb
chkconfig --level 2345 sblim-sfcb on > /dev/null 2>&1

cp $SFCB_REG_FILE $SFCB_REG_FILE_RPM > /dev/null 2>&1
echo "Saving $SFCB_REG_FILE as $SFCB_REG_FILE_RPM ..."
cp -f $temp_file_location $SFCB_REG_FILE > /dev/null 2>&1
if [ $? -ne 0 ]; then
        echo "Cound not update $SFCB_REG_FILE..!!"
        exit 1
fi

rm -f $temp_file_location > /dev/null 2>&1


#Update the pam authentication for RHEL	

echo "Updating pam app (/etc/pam.d/openwsman) for openwsman...."

if [ -f /etc/pam.d/openwsman ]; then
echo "#%PAM-1.0" > /etc/pam.d/openwsman
echo "auth       required     pam_unix.so    nullok" >> /etc/pam.d/openwsman
echo "auth       required     pam_nologin.so" >> /etc/pam.d/openwsman
echo "account    required     pam_unix.so" >> /etc/pam.d/openwsman
echo "password   required     pam_pwcheck.so  nullok" >> /etc/pam.d/openwsman
echo "password   required     pam_unix.so    nullok use_first_pass use_authtok" >> /etc/pam.d/openwsman
echo "session    required     pam_unix.so    none" >> /etc/pam.d/openwsman

fi

#End

