#! /bin/bash

OM_VERSION=8.0.1

### COMMON  functions ###
usage() 
{
    echo "usage: $0 [-h] [-i] [-u] [-p <path to iTP folder>]"
}

# logging
msg()
{
	#echo -e "`date`:\t$1"
	echo -e "`date`:\t$1" >> $TUNNEL_LOG
	
	if [ "$2" == 1 ]
	then
		echo $1
		echo "cannot proceed... exiting installation.See $TUNNEL_LOG for messages"
		exit 1 # stop the script
	fi
}

#find the current OS
getOS()
{
#RHEL	3
#SLES	6
#ESX4	8	
#ESX3	7

    # Else check if operating system is ESX.
    if [ -f /etc/vmware-release ]; then
        VER4=`vmware -v | cut -d ' ' -f3 | cut -d '.' -f 1`
        VER3=`vmware -v | cut -d ' ' -f4 | cut -d '.' -f 1`
        # Check if operating system is ESX 3.5.
        if [ "${VER3}" = "3" ]; then
			export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/var/pegasus/lib
			export PATH=$PATH:/var/pegasus/bin
			return 7;
        # Check if operating system is ESX4.
        elif [ "${VER4}" = "4" ]; then
			return 8;
        fi
	# Check if operating system is RHEL 3,4,5 or 6
    elif [ -f /etc/redhat-release ]; then
		return 3;
    # Else check if operating system is SLES8,10 or 11.
    elif [ -f /etc/SuSE-release ]; then
        return 6;
        
    fi

	return 0
}



#does cimmof exist?
isCimmofAvailable()
{
which cimmof > /dev/null 2>&1

	if [ $? -eq 0 ]
	then
		msg "cimmof is installed"
	else
		msg "error:cimmof is not installed" 1
	fi
}
	



#get library path
getLibpath()
{
	LIB_PATHS=`grep providerDirs /etc/sfcb/sfcb.cfg | cut -d : -f 2`
	
	for p in $LIB_PATHS
	do
		if [ -d $p ]; then
			echo $p
			return 0
		fi
	done
	
	if [ ! -d $p ]; then
		mkdir $p
	fi
	echo $p
	return 0
}


#install sfcb
install_sfcb()
{
	OUR_CIM_DIR=0

	status_sfcb
        if [ $? -eq 0 ]; then
                start_flag=1
		stop_sfcb
        else
                start_flag=0
        fi

	
	
#create a symbolic link to libomacim32/64.so from the /usr/lib/cmpi directory

	SFCB_LIB_PATH=`getLibpath`
	if [ $ARCH = "x86_64" ]; then
		ln -sf $INSTALLPATH/lib64/libcmpiTunnelProvider.so $SFCB_LIB_PATH/libcmpiTunnelProvider.so 
	else
		ln -sf $INSTALLPATH/lib/libcmpiTunnelProvider.so $SFCB_LIB_PATH/libcmpiTunnelProvider.so 
	fi

#run sfcbstage command
    # Q - ensure that dcim_server terminates in mof - think abt this
	msg "running sfcbstage command..."
	if [ $OS -ne 8 ]; then
		sfcbstage -r $INSTALLPATH/etc/schema/tunnel.reg
	else
		#For ESX
		cat $INSTALLPATH/etc/schema/tunnel.reg > /tmp/tunnel-providerRegister
		sfcbstage -r /tmp/tunnel-providerRegister
		cp /tmp/tunnel-providerRegister /var/lib/sfcb/registration/.
	fi
		

        sfcbstage -n root/dcim/sysman $INSTALLPATH/etc/schema/tp.mof 
        if [ $? -ne 1 ]; then
		msg "sfcbstage failed for tp.mof: Error"
	fi
	sfcbstage -n root/interop/ $INSTALLPATH/etc/schema/int.mof
	if [ $? -ne 1 ]; then
		msg "sfcbstage failed for int.mof: Error"
	fi
	
	
#rebuild
	msg "rebuilding sfcb..."
	if [ $OS -ne 8 ]; then
		for Schema_Dir in /usr/share/sfcb/CIM /usr/local/share/sfcb/CIM none
        	do
			if test -x $Schema_Dir
		        then
				if [ -f $Schema_Dir/CIM_Schema.mof ]; then
					msg "CIM_Schema.mof is installed..Creating Backup"
					copy_dell_schema $Schema_Dir $INSTALLPATH/CIM.Dell.Bk
					
				else
					msg "CIM_Schema.mof not installed..!!"
					copy_dell_schema $Schema_Dir $INSTALLPATH/CIM.Dell.Bk
				fi
        			break;
        		fi
        	done
		if test $Schema_Dir = none
		then
			Schema_Dir=/usr/share/sfcb/CIM
			msg "could not locate schema directory..!!"
			if [ ! -d "/usr/share/sfcb/CIM" ]; then
				OUR_CIM_DIR=1
				mkdir "/usr/share/sfcb/CIM"
			fi
			copy_dell_schema "/usr/share/sfcb/CIM" $INSTALLPATH/CIM.Dell.Bk
			
		fi
		sfcbrepos -f
		if [ $? -ne 1 ]; then
			msg "sfcbrepos failed: Error"
		fi
		
		
		if [ $OUR_CIM_DIR -ne 1 ]; then
			rm -rf $Schema_Dir/* > /dev/null 2>&1
			cp -rf $INSTALLPATH/CIM.Dell.Bk/* $Schema_Dir/. > /dev/null 2>&1
		else
			rm -rf $Schema_Dir > /dev/null 2>&1
		fi
			rm -rf $INSTALLPATH/CIM.Dell.Bk > /dev/null 2>&1
		
		 
	else
		# for ESX 4.0
		sfcbrepos -f -c /var/lib/sfcb/schema
		if [ $? -ne 1 ]; then
			msg "sfcbrepos failed: Error"
		fi
	fi
			
	
	msg "tunnel is registered"

	if [ $start_flag -eq 1 ]; then	
		#start sfcb.
		start_sfcb	
	fi
}

sfcb_reg_unreg_failed()
{
	sfcbunstage -n root/dcim/sysman `ls $INSTALLPATH/etc/schema/ | grep tp.mof`
        sfcbunstage -n root/interop `ls $INSTALLPATH/etc/schema/ | grep int.mof`

	if [ $OS -ne 8 ]; then
		sfcbunstage -r tunnel.reg
                
	else
		sfcbunstage -r tunnel-providerRegister
		rm -f /var/lib/sfcb/registration/tunnel-providerRegister
	fi
		
	exit 1
}

copy_dell_schema()
{
	
	if [ -d $1 ]; then
		if [ -d $2 ]; then
			rm -rf $2 > /dev/null 2>&1
		fi
		mkdir $2 > /dev/null 2>&1
		cp -rf $1/* $2/. > /dev/null 2>&1
		rm -rf $1/* > /dev/null 2>&1
		cp $INSTALLPATH/etc/schema/cimv217Experimental-MOFs.zip $1/. > /dev/null 2>&1
		cd $1 > /dev/null 2>&1
		unzip cimv217Experimental-MOFs.zip > /dev/null 2>&1
		rm -f cimv217Experimental-MOFs.zip > /dev/null 2>&1
		cp cimv217.mof CIM_Schema.mof > /dev/null 2>&1
		cd $INSTALLPATH/ > /dev/null 2>&1
		return 0
	else
		return 1	
	fi
}

uninstall_sfcb()
{
	OUR_CIM_DIR=0
	status_sfcb
	
	if [ $? -eq 0 ]; then
		start_flag=1
	else
		start_flag=0
	fi
	
	stop_sfcb

	SFCB_LIB_PATH=`getLibpath`
	rm -f $SFCB_LIB_PATH/libcmpiTunnelProvider.so

	sfcbunstage -n root/dcim/sysman `ls $INSTALLPATH/etc/schema/ | grep tp.mof`
	sfcbunstage -n root/interop `ls $INSTALLPATH/etc/schema/ | grep int.mof`
	if [ $OS -ne 8 ]; then
		if [ ! -d "/usr/share/sfcb/CIM" ]; then
                     	OUR_CIM_DIR=1   
			mkdir /usr/share/sfcb/CIM
			
                fi
		copy_dell_schema "/usr/share/sfcb/CIM" $INSTALLPATH/CIM.Dell.Bk
		sfcbunstage -r tunnel.reg
		sfcbrepos -f
		if [ $OUR_CIM_DIR -ne 0 ]; then
			rm -rf /usr/share/sfcb/CIM
		else
			cp -rf $INSTALLPATH/CIM.Dell.Bk/* /usr/share/sfcb/CIM/. > /dev/null 2>&1
		fi
		rm -rf INSTALLPATH/CIM.Dell.Bk
		
	else
		sfcbunstage -r tunnel-providerRegister
		rm -f /var/lib/sfcb/registration/tunnel-providerRegister
		sfcbrepos -f -c /var/lib/sfcb/schema/
	fi
	
	
	if [ $start_flag -eq 1 ]; then
		start_sfcb
	fi

}

status_sfcb()
{
	#if running return 0, otherwise 1
	if [ $OS = 8 ]; then
		`/etc/init.d/sfcbd-watchdog status | grep -i running` > /dev/null 2>&1
	else
		if [ -f /etc/init.d/sfcb ] ; then
			`/etc/init.d/sfcb status | grep -i running` > /dev/null 2>&1
			if [ $? -eq 1 ]; then		
				`ps -C sfcbd` > /dev/null 2>&1
			fi
		fi
	fi
	
	if [ $? -ne 1 ]; then
		return 0
	else
		return 1
	fi
}
start_sfcb()
{
	for INITSCRIPT in /etc/init.d/sfcb /usr/local/etc/init.d/sfcb /etc/init.d/sfcbd-watchdog none
        do
          if test -x $INITSCRIPT
          then
              break;
          fi
        done

	msg "Starting sfcb.."
	if test $INITSCRIPT = none
        then
            sfcbd -d > /dev/null 2>&1
        else
            $INITSCRIPT start > /dev/null 2>&1
        fi

}


stop_sfcb()
{
                #running..
                for INITSCRIPT in /etc/init.d/sfcb /usr/local/etc/init.d/sfcb /etc/init.d/sfcbd-watchdog none
        	do
          		if test -x $INITSCRIPT
          		then
              			break;
          		fi
        	done
		
		msg "Stoping sfcb.."		
		if test $INITSCRIPT = none
        	then
			kill -9 `pidof sfcbd` > /dev/null 2>&1
        	else
            		$INITSCRIPT stop > /dev/null 2>&1
			kill -9 `pidof sfcbd` > /dev/null 2>&1
        	fi

 

}


### End of functions ###

### START OF MAIN CODE ###



file `find /opt/dell/srvadmin/lib* -name "libcmpiTunnelProvider*"` | grep "64-bit" > /dev/null 2>&1	
if [ $? -eq 0 ]; then
	ARCH="x86_64"
else
	file `find /opt/dell/srvadmin/lib* -name "libcmpiTunnelProvider*"` | grep "32-bit" > /dev/null 2>&1
	if [ $? -eq 0 ]; then
		ARCH="i686"
	else
		ARCH=`uname -m`
	fi
fi    	





install=0
uninstall=0

#check for arguments
	if [ -z "$1" ]
	then
		help=1;
	fi

while [ -n "$1" ]
do
  case $1 in
      -h) help=1; 
	  shift;
	  break;;
      -i) install=1
	  shift;;
      -p) pathname="$2"; 
	  shift 2;;
      -u) uninstall=1
	  shift;;
      -v) CUR_OM_VER=$2;
	  shift 2;;
      --) shift;
	  break;;
      **) break;;
  esac
done

if [ "$help" = "1" ]
then
    usage
    echo -e "\t-h display help message"
    echo -e "\t-p add a pathname where ssa directory is located"
    echo -e "\t-i install SSA"
    echo -e "\t-u uninstall SSA"
    echo
    echo Use this command to install or uninstall SSA.
    echo Installation will compile the mofs, register the providers.
	echo "$TUNNEL_LOG file will be created in the directory where this script resides"
    exit 0
fi


#get absolute path to pathname
	CUR_PATH=`pwd` 
	cd ../
	cd "$pathname"
	INSTALLPATH=`pwd` 
	
	cd "$CUR_PATH"
	
TUNNEL_LOG_PATH=$INSTALLPATH/var/log
TUNNEL_LOG=$INSTALLPATH/var/log/itp_log.txt
msg "INSTALLPATH=$INSTALLPATH"
#create a log file
#	msg "logging starts..."
	mkdir -p $TUNNEL_LOG_PATH
	echo "logging starts..." > $TUNNEL_LOG

	
#get current OS and arch. type
	getOS
	OS=$?
	msg "system info:OS=$OS"	
	


#run appropriate functions for each OS/arch. type
	if [ $install -eq 1 ]; then
		#Installing SFCB
		msg "Starting Provider and Mof Registration ..."
		install_sfcb

	
	elif [ $uninstall -eq 1 ]; then
		if [ "$CUR_OM_VER" = "$OM_VERSION" ]; then
			msg "Removing Provider and Mof Registration ..."
			uninstall_sfcb
		else
			#upgrade scenario
			msg "Upgrade happening from $CUR_OM_VER to $OM_VERSION"
			exit 0;
		fi		
	
	fi

	if [ $install -eq 1 ]; then
		echo "Installation complete." >> $TUNNEL_LOG
	elif [ $uninstall -eq 1 ]; then
		echo "Uninstallation complete." >> $TUNNEL_LOG
		rm -f $TUNNEL_LOG
	fi
	
	exit 0

