<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="html" />
	<xsl:template match="/OMA">
		<HTML>
		<HEAD>
		<link rel="stylesheet" type="text/css" href="/oma/docs/oma.css" />
		<xsl:if test="@skin != ''">
			<link rel="stylesheet" type="text/css">
				<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if>scheme.css</xsl:attribute>
			</link>
			<xsl:if test="@language != ''">
				<link rel="stylesheet" type="text/css">
					<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/scheme.css</xsl:attribute>
				</link>
				<xsl:if test="@country != ''">
					<link rel="stylesheet" type="text/css">
						<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/<xsl:value-of select="@country"/>/scheme.css</xsl:attribute>
					</link>
				</xsl:if>
			</xsl:if>
		</xsl:if>
		<TITLE></TITLE>
		</HEAD>
		<BODY class="logo">
		<table border="0" cellpadding="0" cellspacing="0" width="165">
		<tr>
			<xsl:apply-templates select="OEM" />
		</tr>
		</table>
		</BODY>
		</HTML>
	</xsl:template>
	<xsl:template match="OEM">
		<td align="left" valign="middle">
			<img style="height: 57px; width: 57px">
				<xsl:attribute name="src">/oem/<xsl:value-of select="@name"/>/images/logo.gif</xsl:attribute>
			</img>
		</td>
	</xsl:template>
	<xsl:template match="*"/>
</xsl:stylesheet>
