<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" >
  <xsl:output method="html" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" indent="yes"/>
  <xsl:template match="/OMA">
		<HTML>
			<head>
				<title><xsl:value-of select="OEM/OEMTitleCompanyName" />&#160;<xsl:value-of select="OEM/OEMTitleCoreProductName" />&#160;<xsl:value-of select="OEM/ProdName" /></title>
			</head>
			<script language="javascript">

						<xsl:choose>
						<xsl:when test="VID">
							<xsl:choose>
								<xsl:when test="Shutdown">
									<xsl:choose>
									<xsl:when test="REMOTE='TRUE'">
                  top.location.href = './LogoutServlet?page=Logout&amp;closebrowser=1&amp;CurrentProgram=<xsl:value-of select="CurrentProgram"/>&amp;remote=true&amp;vid=<xsl:value-of select="VID"/>';
									</xsl:when>
									<xsl:when test="REMOTE='FALSE'">
                  top.location.href = './LogoutServlet?page=Logout&amp;closebrowser=1&amp;CurrentProgram=<xsl:value-of select="CurrentProgram"/>&amp;remote=false&amp;vid=<xsl:value-of select="VID"/>';
									</xsl:when>
									<xsl:otherwise>
				top.location.href = './LogoutServlet?page=Logout&amp;closebrowser=1&amp;CurrentProgram=<xsl:value-of select="CurrentProgram"/>&amp;vid=<xsl:value-of select="VID"/>';									
									</xsl:otherwise>
									</xsl:choose>
                </xsl:when>
								<xsl:when test="Reboot">
								<xsl:choose>
								<xsl:when test="REMOTE='TRUE'">
                  top.location.href = './LogoutServlet?page=Logout&amp;closebrowser=1&amp;reboot=true&amp;CurrentProgram=<xsl:value-of select="CurrentProgram"/>&amp;remote=true&amp;vid=<xsl:value-of select="VID"/>';
									</xsl:when>
									<xsl:when test="REMOTE='FALSE'">
                  top.location.href = './LogoutServlet?page=Logout&amp;closebrowser=1&amp;reboot=true&amp;CurrentProgram=<xsl:value-of select="CurrentProgram"/>&amp;remote=false&amp;vid=<xsl:value-of select="VID"/>';
									</xsl:when>
									<xsl:otherwise>
				top.location.href = './LogoutServlet?page=Logout&amp;closebrowser=1&amp;reboot=true&amp;CurrentProgram=<xsl:value-of select="CurrentProgram"/>&amp;vid=<xsl:value-of select="VID"/>';
									</xsl:otherwise>
									</xsl:choose>								
                  
                </xsl:when>
								<xsl:when test="Login">
                  top.location.href = './LogoutServlet?page=Logout&amp;autorestartmode=1&amp;closeBrowserOnly=1&amp;CurrentProgram=<xsl:value-of select="CurrentProgram"/>&amp;vid=<xsl:value-of select="VID"/>';
                </xsl:when>
								<xsl:when test="WebServerStop">
                  top.location.href = './LogoutServlet?command=stop&amp;vid=<xsl:value-of select="VID"/>';
                </xsl:when>
								<xsl:otherwise>
                  top.location.href = './LogoutServlet?page=Logout&amp;autorestartmode=1&amp;CurrentProgram=<xsl:value-of select="CurrentProgram"/>&amp;vid=<xsl:value-of select="VID"/>';
                </xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="Shutdown">
                  top.location.href = './LogoutServlet?page=Logout&amp;closebrowser=1&amp;CurrentProgram=<xsl:value-of select="CurrentProgram"/>';
                </xsl:when>
								<xsl:when test="Reboot">
                  top.location.href = './LogoutServlet?page=Logout&amp;closebrowser=1&amp;reboot=true&amp;CurrentProgram=<xsl:value-of select="CurrentProgram"/>';
                </xsl:when>
								<xsl:when test="Login">
                  top.location.href = './LogoutServlet?page=Logout&amp;autorestartmode=1&amp;closeBrowserOnly=1&amp;CurrentProgram=<xsl:value-of select="CurrentProgram"/>';
                </xsl:when>
								<xsl:when test="WebServerStop">
                  top.location.href = './LogoutServlet?command=stop';
                </xsl:when>
								<xsl:otherwise>
                  top.location.href = './LogoutServlet?page=Logout&amp;autorestartmode=1&amp;CurrentProgram=<xsl:value-of select="CurrentProgram"/>';
                </xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
						</xsl:choose>

      </script>
		</HTML>
	</xsl:template>
</xsl:stylesheet>
