<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:variable name="brand">
			<xsl:choose>
			<xsl:when test="/OMA/Brand='0'">dell</xsl:when>			
			<xsl:otherwise>debrand</xsl:otherwise>
			</xsl:choose>
	</xsl:variable>
	<xsl:template match="/OMA">
		<HTML>
			<head>
			<title>
			<xsl:choose>
				<!-- OEM -->
				<xsl:when test="OEM/OEMTitleCompanyName = ''">
					<xsl:choose>
						<xsl:when test="OEM/ProdName = ''">
							<xsl:value-of select="OEM/OEMTitleCoreProductName" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="ProdName"><xsl:with-param name="prodname"><xsl:value-of select="OEM/ProdName" /></xsl:with-param></xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<!-- none-OEM -->
				<xsl:otherwise>
					<xsl:value-of select="OEM/OEMTitleCompanyName" /><xsl:text> </xsl:text><xsl:value-of select="OEM/OEMTitleCoreProductName" /><xsl:text> </xsl:text><xsl:call-template name="ProdName"><xsl:with-param name="prodname"><xsl:value-of select="OEM/ProdName" /></xsl:with-param></xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
			</title>
			<script src="/oma/js/variables.js" type="text/javascript"></script>
			<script src="/oma/js/prototype.js" type="text/javascript"></script>
			<script src="/oma/js/favicon.js" type="text/javascript"></script>
			<script language="javascript">		
			changeFavicon('/oma/images/<xsl:value-of select="$brand"/>/favicon.ico'); 
			</script>
			</head>
			<xsl:choose>
			
				<xsl:when test="load != ''">
					<xsl:choose>
						<xsl:when test="load = 'embedded'">
							<frameset cols="200,*" frameborder="no" framespacing="0" border="0" id="contentframeset">
								<xsl:call-template name="body" />
							</frameset>
						</xsl:when>
						<xsl:when test="load = 'default'">
							<frameset cols="200,*" frameborder="no" framespacing="0" border="0" id="contentframeset">
								<xsl:call-template name="body" />
							</frameset>
						</xsl:when>
						<xsl:otherwise>
							<meta http-equiv="Refresh">
								<xsl:attribute name="content">0;url=<xsl:value-of select="load" />?vid=<xsl:value-of select="VID" /></xsl:attribute>
							</meta>
							<body />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<script src="/oma/js/variables.js" type="text/javascript"></script>
					<script language="javascript" src="/oma/js/index.js" />
					 <script type="text/javascript">
					 var brandName = '<xsl:value-of select="$brand"/>';					 
					 </script>
					<frameset rows="76,*,0,0" border="0">
						<frameset cols="128,*" border="0">
							<frame src="/oma/logo.html" name="logo" scrolling="no" border="0" frameborder="no" framespacing="0" noresize="noresize" marginheight="0" marginwidth="0"/>
							<frame name="gnv" scrolling="no" border="0" frameborder="no" framespacing="0" noresize="noresize" marginheight="0" marginwidth="0">
								<xsl:attribute name="src">
								<xsl:choose>
								<xsl:when test="Preference = 'true'">./SecureGlobalNavBarServlet?preference=true&amp;vid=<xsl:value-of select="/OMA/VID" /></xsl:when>
								<xsl:otherwise>./SecureGlobalNavBarServlet?vid=<xsl:value-of select="/OMA/VID" /></xsl:otherwise>
								</xsl:choose>
								</xsl:attribute>
							</frame>
						</frameset>
						<frame name="body" scrolling="no" marginheight="0" marginwidth="0" frameborder="no" framespacing="0" noresize="noresize">
							<xsl:attribute name="src">/oma/loading.html</xsl:attribute>
						</frame>
					</frameset>
				</xsl:otherwise>
			</xsl:choose>
			<noframes />
		</HTML>
	</xsl:template>
	
	<xsl:template name="ProdName">
		<xsl:param name="prodname"/>
		<xsl:choose>
			<xsl:when test="$prodname = 'Preferences'"><xsl:value-of select="$strPreferences"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$prodname"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="body">
		<!--Need an id so the javascript can get to this element for the pulltab and we need to give it an initial width - REH-->
		<!--Also need an id on the title frame so we can get the system name for the title of the page-->
        <frameset frameborder="no" framespacing="0" rows="80,*">
			<frame name="systemInfo" scrolling="no" frameborder="no" framespacing="0" marginheight="0" marginwidth="0" noresize="noresize" id="title">
				<xsl:attribute name="src">./SysInfo?session=true&amp;vid=<xsl:value-of select="/OMA/VID" /></xsl:attribute>
			</frame>
			<frame name="ct" id="ct" scrolling="auto" frameborder="no" framespacing="0" marginheight="0" marginwidth="0" noresize="noresize">
				<xsl:attribute name="src">./ComponentTree?vid=<xsl:value-of select="/OMA/VID" /></xsl:attribute>
			</frame>	
        </frameset>
        <frameset frameborder="no" framespacing="0" rows="37,23,*,0">
            <frame name="snb" id="snb" scrolling="no" frameborder="no" framespacing="0" marginheight="0" marginwidth="0" noresize="noresize">
				<xsl:attribute name="src">/oma/loading.html</xsl:attribute>
			</frame>					
            <frame name="lsnb" id="lsnb" scrolling="no" frameborder="no" framespacing="0" marginheight="0" marginwidth="0" noresize="noresize">
				<xsl:attribute name="src">/oma/loading.html</xsl:attribute>
			</frame>					
            <frame src="/oma/loading.html" name="da" id="da" scrolling="auto" frameborder="no" framespacing="0" marginheight="0" marginwidth="0" noresize="noresize"/>
        </frameset>   
	</xsl:template>
</xsl:stylesheet>
