<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" />

<xsl:template match="Server">
	<html>
	<head>
	<title></title>
	<link rel="stylesheet" type="text/css" href="/oma/docs/oma.css" />
	<xsl:if test="@skin != ''">
		<link rel="stylesheet" type="text/css">
			<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if>scheme.css</xsl:attribute>
		</link>
		<xsl:if test="@language != ''">
			<link rel="stylesheet" type="text/css">
				<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/scheme.css</xsl:attribute>
			</link>
			<xsl:if test="@country != ''">
				<link rel="stylesheet" type="text/css">
					<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/<xsl:value-of select="@country"/>/scheme.css</xsl:attribute>
				</link>
			</xsl:if>
		</xsl:if>
	</xsl:if>
	</head>
	<body class="server-name">
		<table height="100%" width="100%">
			<tr>
				<td align="left" valign="middle">
					<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td style="width: 14; height: 25">
							<img style="width: 14; height: 25">
								<xsl:attribute name="src">/oma/<xsl:if test="@skin != ''">skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if></xsl:if>images/snlbutton.gif</xsl:attribute>
							</img>
						</td>
						<td class="server-name-button" align="center" valign="middle" nowrap="true"	>
							<a class="server-name"><xsl:value-of select="@name" /></a>
						</td>
						<td style="width: 14; height: 25">
							<img style="width: 14; height: 25">
								<xsl:attribute name="src">/oma/<xsl:if test="@skin != ''">skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if></xsl:if>images/snrbutton.gif</xsl:attribute>
							</img>
						</td>
					</tr>
					</table>
				</td>
			</tr>
		</table>
	</body>
	</html>
</xsl:template>
</xsl:stylesheet>
