<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"/>
<xsl:variable name="brand">
			<xsl:choose>
			<xsl:when test="/OMA/Brand='0'">dell</xsl:when>			
			<xsl:otherwise>debrand</xsl:otherwise>
			</xsl:choose>
	</xsl:variable>
	<xsl:template match="/OMA">

<html > 
<head> 
<title><xsl:value-of select="$strAbout"/></title>
<script LANGUAGE="javascript">
		function noResize()
		{
			parent.resizeTo(375, 300);
		}
		function doResize()
		{
			var width;
			if (window.innerWidth == null) {
				width = document.body.clientWidth;
			}
			else {
				width = window.innerWidth;
			}
			document.getElementById("line").width = width - 50;
		}
	</script>
<meta http-equiv="content-type" content="text/html; charset=iso-8859-1" /> 
<meta http-equiv="Content-Script-Type" content="text/javascript" /> 
<meta http-equiv="content-Style-Type" content="text/css" /> 
<link href="/oma/css/popup.css" rel="stylesheet" type="text/css" /> 
<script src="/oma/js/prototype.js" type="text/javascript"></script> 
<script src="/oma/js/Clarity.js" type="text/javascript"></script>
<script src="/oma/js/gnavbar.js" type="text/javascript"></script>	
	</head>
    <body onload="javascript:popUp.initialize();">


      <body onload="javascript:popUp.initialize();">
        <div class="popup_container">
     <div class="popup_masthead_outer"> 

		<div class="popup_masthead_left"></div> 
		<div class="popup_masthead_middle"> 
		
		
		
		
		<div class="popup_logo_brand">
		<xsl:attribute name="style">background: url('/oma/images/<xsl:value-of select="$brand"/>/logo.png') no-repeat left center;</xsl:attribute>
		</div>
		<div class="popup_masthead_divider"></div>
		<img class="popup_masthead_title" alt="OpenManage Help" >			  
		   <xsl:attribute name="src">/oma/images/<xsl:value-of select="$brand"/>/omsa_title.png</xsl:attribute>		  
		</img>
	
		<div class="popup_masthead_links"> 
	<a href="javascript:closePopUpWindow ();"><xsl:attribute name="title"><xsl:value-of select="$strClose"/></xsl:attribute><xsl:value-of select="$strClose"/></a> 
		</div> 
		<div class="popup_masthead_right"></div> 
		</div> 
	</div> 
          <div class="popup_content">
 
            <div class="popup_content_top_right">
              <div class="popup_content_top_left">
               <div class="popup_content_top">
                </div>
              </div>
           </div>
 </div>
            <div class="popup_content_right">
              <div class="popup_content_left">
 

                <div class="popup_content_middle">
                  <div class="popup_page_title">
                    <span id="helpTitle"><xsl:value-of select="$strAbout"/></span>

                    <div class="popup_line">
                    </div>
                  </div>
                 
                    <div class="popup_subheader">
                      <span id="subTitle"><xsl:value-of select="$strGeneralInformation"/></span>
                      <div class="popup_subheaderline">
                      
                      </div>



                      


                    </div>
<xsl:apply-templates select="About"/>
 <div class="popup_subheader">
                <span id="subTitle"><xsl:value-of select="$strDetails"/></span>
                <div class="popup_subheaderline">
                </div>
              </div>
<xsl:apply-templates select="About/Component"/>

<table border="0" width="100%">
					<tr>
						<td width="2"/>
						<td>
							<iframe height="200" width="100%" src="/oma/copyright.html" />
						</td>
					</tr>
				</table>

                 
              

              </div>

            </div>

          </div>

        </div>

      </body>


	

    </body>
  </html>

</xsl:template>

<xsl:template match="About">
  <div class="popup_container">

    <div class="popup_content">

      <div class="popup_content_middle">
    <div class="popup_inner_content">
        <div class="popup_infolist">
          <table>
            <tr>
              <td class="item">
<span class="bold"> 

             
              <xsl:choose>
 		
			<xsl:when test="ProductName">
                  <xsl:value-of select="ProductName"/>
                  
                </xsl:when>
               


                <xsl:when test="ProductID = 'osia'">
                  <xsl:choose>
                    <xsl:when test="(../OEMTitleCompanyName)!=''">
                      <xsl:value-of select="../OEMTitleCompanyName" />&#160;<xsl:value-of select="../OEMTitleCoreProductName" />
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="../OEMTitleCoreProductName" />
                    </xsl:otherwise>
                  </xsl:choose>
                 
                </xsl:when>
                <xsl:when test="ProductID = 'pref'">
                  <xsl:value-of select="ProductName"/>&#160;<xsl:value-of select="$strPreferences"/>
                 
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="$strProductNameInformation"/>
                 
                </xsl:otherwise>
              </xsl:choose>
</span>

</td>
             
     

                  <td class="desc25">
 <xsl:choose>
    <xsl:when test="ProductVersion">
      

                    <xsl:value-of select="$strVersion"/>
                    <xsl:value-of select="ProductVersion"/>

		</xsl:when>    
			<xsl:otherwise>
        <xsl:value-of select="$strInformationNotAvailable"/></xsl:otherwise>
		</xsl:choose>
                  </td>
         
      
           
		
		<xsl:if test="VendorName">
			
				<tr>
					<td><xsl:value-of select="$strPoweredBy"/><xsl:value-of select="VendorName"></xsl:value-of><br/></td>
					<td><xsl:if test="VendorImage"><img><xsl:attribute name="src"><xsl:value-of select="VendorImage"/></xsl:attribute></img><br/></xsl:if></td>
				</tr>
			
		</xsl:if>


             

            </tr>

 		<tr>
                      <td colspan="2" class="normal">
                      <xsl:call-template name="LegalCopyright">
			<xsl:with-param name="copyright"><xsl:value-of select="LegalCopyright"/></xsl:with-param>
			</xsl:call-template>

                      </td>
                    </tr>
          </table>
        </div>

    

</div>
      </div>
    </div>
  </div>
		</xsl:template>
<xsl:template match="About/Component">
	<div class="popup_container">

    <div class="popup_content">

      <div class="popup_content_middle">

 <div class="popup_infolist">
          <table>
            <tr>
              <td class="item"  ><span>
             <xsl:choose>
 
			<xsl:when test="ID = 'osia'">

				<xsl:choose>
			
					<xsl:when test="(../OEMTitleCompanyName)!=''">
						<xsl:value-of select="../OEMTitleCompanyName" />&#160;<xsl:value-of select="../OEMTitleCoreProductName" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="../OEMTitleCoreProductName" />
					</xsl:otherwise>
				</xsl:choose>
				
				</xsl:when>

				<xsl:when test="Name">
					<xsl:value-of select="Name"/>
				

				
				</xsl:when>


		</xsl:choose>




		</span>
              </td>
             
         
		
		<td class="desc">
					<xsl:choose>
						<xsl:when test="Version">
								<xsl:value-of select="$strVersion"/>
						<xsl:value-of select="Version"/>
							
							<xsl:if test="ID = 'OMACORE' or ID = 'omacore' ">
								<xsl:variable name="buildNum"><xsl:value-of select="BuildNumber"/></xsl:variable>
								<xsl:if test="$buildNum != ''"> (<xsl:value-of select="$buildNum"/>)</xsl:if>
							</xsl:if>
						
					</xsl:when>

				<xsl:when  test="../OEMTitleVersion">
					<xsl:value-of select="$strVersion"/>
					<xsl:value-of select="../OEMTitleVersion"/>
					
				</xsl:when>

				</xsl:choose>

</td>
</tr>
          </table>

 
</div>
</div>
</div>
</div>

	</xsl:template>


	<xsl:template name="LegalCopyright">
		<xsl:param name="copyright"/>

		<xsl:choose>
			<xsl:when test="substring-after($copyright , 'VER_LEGALCOPYRIGHT_YEARS') =' All rights reserved.'">
  				<xsl:variable name="laststr"><xsl:value-of select="$strAllRightsReserved"/></xsl:variable>
				<xsl:value-of select="concat(substring-before($copyright , 'All') , $laststr)"/>
            </xsl:when>
			<xsl:otherwise><xsl:value-of select="$copyright"/></xsl:otherwise>
		</xsl:choose>


	</xsl:template>


	


	<xsl:template match="*"/>
</xsl:stylesheet>
