<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" indent="no"/>
	<xsl:strip-space elements="*"/>	
	<!-- Variable Begin : customDelimiter -->
	<!-- Global variable used by all the templates. Its stores the custom delimiter character value. -->
	<xsl:variable name="customDelimiter"><xsl:call-template name="mapCustomDelimiterStrToChar"><xsl:with-param name="customDelimiterStr"><xsl:value-of select="/OMA/@fmt"/></xsl:with-param></xsl:call-template></xsl:variable>
	<xsl:variable name="altDelimiter"><xsl:call-template name="getAltDelimiterFromCustom"><xsl:with-param name="customDelimiter"><xsl:value-of select="$customDelimiter"/></xsl:with-param></xsl:call-template></xsl:variable>
	<!-- Variable End : customDelimiter -->
	<!-- Variable Begin : requestType -->
	<!-- Global variable used by all the templates. Its stores the request type [cli or web]-->
	<xsl:variable name="requestType"><xsl:value-of select="/OMA/@type"/></xsl:variable>
	<!-- Variable End : requestType-->
	<!-- Template Begin: OMA -->
	<xsl:template match="/OMA">
		<xsl:apply-templates select="DataArea"/>
	</xsl:template>
	<!-- Template End: OMA -->
	<!-- Template Begin: DataArea -->
	<xsl:template match="DataArea">
		<!-- List of supported data containers for custom delimiter option -->
		<xsl:apply-templates select="PageTitle"/>
		<xsl:apply-templates select="HealthData"/>
		<xsl:apply-templates select="ComboData"/>
		<xsl:apply-templates select="ListData"/>
		<xsl:apply-templates select="TableData"/>
		<xsl:apply-templates select="SummaryData"/>
		<xsl:apply-templates select="CustomTable"/>
		<xsl:apply-templates select="PromptText"/>
	</xsl:template>	
	<!-- Template End: DataArea -->
	<!-- Template Begin: PageTitle -->
	<xsl:template match="PageTitle">
		<xsl:value-of select="@display"/>
		<!-- DFCT108103 : For export from Web display the status, for CLI it is done in subheader -->
		<xsl:if test="$requestType!='cli' and @status!=''">
			<xsl:text> : </xsl:text>
			<xsl:call-template name="mapStatusToStr">
				<xsl:with-param name="status"><xsl:value-of select="@status"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		<xsl:call-template name="putNewLineChar"/>
	</xsl:template>
	<!-- Template End: PageTitle -->
	<!-- Template Begin: HealthData -->
	<xsl:template match="HealthData">
		<xsl:call-template name="putNewLineChar"/>
		<xsl:value-of select="$strSeverity"/><xsl:value-of select="$customDelimiter"/><xsl:value-of select="$strComponent"/>
		<xsl:for-each select="Data">
			<xsl:call-template name="putNewLineChar"/>
			<xsl:call-template name="mapStatusToStr"><xsl:with-param name="status"><xsl:value-of select="@status"/></xsl:with-param></xsl:call-template><xsl:value-of select="$customDelimiter"/><xsl:value-of select="@display"/>
		</xsl:for-each>
		<xsl:call-template name="putNewLineChar"/>
	</xsl:template>
	<!-- Template End: HealthData -->
	<!-- Template Begin: ComboData -->
	<xsl:template match="ComboData">
		<xsl:apply-templates select="ListData"/>
		<xsl:if test="TableData">
			<xsl:apply-templates select="TableData"/>
		</xsl:if>
	</xsl:template>
	<!-- Template End: ComboData -->
	<!-- Template Begin: CustomTable-->
	<xsl:template match="CustomTable">
		<xsl:call-template name="putNewLineChar"/>
		<xsl:for-each select="CustomRow">
			<xsl:call-template name="putNewLineChar"/>
			<xsl:call-template name="mapStatusToStr">
				<xsl:with-param name="status"><xsl:value-of select="@status"/></xsl:with-param>
			</xsl:call-template>
			<xsl:for-each select="ColumnItem">
				<xsl:text> </xsl:text><xsl:value-of select="@header"/>
				<xsl:call-template name="putNewLineChar"/>
				<xsl:for-each select="Row">
					<xsl:for-each select="Data">
						<xsl:if test="position() = 1">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>
					<xsl:if test="position() != last()">
						<xsl:value-of select="$customDelimiter"/>
					</xsl:if>
				</xsl:for-each>
				<xsl:call-template name="putNewLineChar"/>
				<xsl:for-each select="Row">
					<xsl:for-each select="Data">
						<xsl:choose>
							<xsl:when test="ValueList">
								<xsl:for-each select="ValueList/value">
									<xsl:value-of select="."/>
									<xsl:if test="position() != last()"><xsl:text> </xsl:text></xsl:if>
								</xsl:for-each>
							</xsl:when>
							<xsl:otherwise>
								<xsl:if test="position() = 2">
									<xsl:value-of select="."/>
								</xsl:if>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
					<xsl:if test="position() != last()">
						<xsl:value-of select="$customDelimiter"/>
					</xsl:if>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:call-template name="putNewLineChar"/>
		</xsl:for-each>
	</xsl:template>
	<!-- Template End: CustomTable-->

	<xsl:template match="PromptText">
		<xsl:if test=". !=''">
			<xsl:choose>
				<xsl:when test="@ignoreoncli = 'true'"></xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="putNewLineChar"/>
					<xsl:value-of select="."/>
					<xsl:call-template name="putNewLineChar"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	
	<xsl:template match="SubHeader">
		<xsl:call-template name="putNewLineChar"/>
		<!-- DFCT 108103 : Changed format to display as <Header> : <status>
						   similar to the one in dassv.xsl. -->
		<xsl:value-of select="@display"/>
		<xsl:if test="@status">
			<!-- DFCT 108103 : Add colon before status string -->
			<xsl:text> : </xsl:text>
			<xsl:call-template name="mapStatusToStr">
				<xsl:with-param name="status"><xsl:value-of select="@status"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		<xsl:call-template name="putNewLineChar"/>
	</xsl:template>

	<!-- Template Begin: ListData-->
	<xsl:template match="ListData">
		<xsl:apply-templates select="SubHeader"/>
		<xsl:call-template name="putNewLineChar"/>
		<xsl:choose>
			<xsl:when test="@restoreformat='true'">
				<xsl:for-each select="Data">
					<xsl:value-of select="@display"/>
					<xsl:value-of select="$customDelimiter"/>
					<xsl:value-of select="@value"/>
					<xsl:call-template name="putNewLineChar"/>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select="Data">
					<xsl:choose>
						<!-- if request is from cli, turn on ignoreoncli attribute -->
						<xsl:when test="$requestType = 'cli' ">
							<xsl:choose>
								<xsl:when test="@ignoreoncli = 'true'"></xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@type">
											<xsl:if test=" @type != 'hidden' ">
												<xsl:value-of select="@display"/>
												<xsl:if test="position() != last()"><xsl:value-of select="$customDelimiter"/></xsl:if>
											</xsl:if>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="@display"/>
											<xsl:if test="position() != last()"><xsl:value-of select="$customDelimiter"/></xsl:if>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<!-- if request is from web, turn on ignoreonweb attribute -->
						<xsl:when test="$requestType = 'web' ">
							<xsl:choose>
								<xsl:when test="@ignoreonweb = 'true'"></xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@type">
											<xsl:if test=" @type != 'hidden' ">
												<xsl:value-of select="@display"/>
												<xsl:if test="position() != last()"><xsl:value-of select="$customDelimiter"/></xsl:if>
											</xsl:if>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="@display"/>
											<xsl:if test="position() != last()"><xsl:value-of select="$customDelimiter"/></xsl:if>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<!-- if request is from unknown, process as is -->
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="@type">
									<xsl:if test=" @type != 'hidden' ">
										<xsl:value-of select="@display"/>
										<xsl:if test="position() != last()"><xsl:value-of select="$customDelimiter"/></xsl:if>
									</xsl:if>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="@display"/>
									<xsl:if test="position() != last()"><xsl:value-of select="$customDelimiter"/></xsl:if>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
				<xsl:call-template name="putNewLineChar"/>
				<xsl:for-each select="Data">
					<xsl:call-template name="printListDataItem"/>
				</xsl:for-each>
				<xsl:call-template name="putNewLineChar"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Template End: ListData-->
	<!-- Template Begin: TableData-->
	<xsl:template match="TableData">
		<xsl:apply-templates select="SubHeader"/>
		<xsl:call-template name="putNewLineChar"/>
		<xsl:choose>
			<!-- no header -->
			<xsl:when test="count(Header) = 0">
				<!-- just print the rows -->
				<xsl:for-each select="Row">
					<xsl:call-template name="printTableDataRow"/>
					<xsl:call-template name="putNewLineChar"/>
				</xsl:for-each>
				<xsl:call-template name="putNewLineChar"/>
			</xsl:when>
			<!-- one header -->
			<xsl:when test="count(Header) = 1">
				<xsl:call-template name="printTableDataHeader"/>
				<xsl:call-template name="putNewLineChar"/>
				<xsl:for-each select="Row">
					<xsl:call-template name="printTableDataRow"/>
					<xsl:call-template name="putNewLineChar"/>
				</xsl:for-each>
				<xsl:call-template name="putNewLineChar"/>
			</xsl:when>
			<!-- multiple headers -->
			<xsl:otherwise>
				<xsl:call-template name="printTableDataMultiHeader"/>
				<xsl:call-template name="putNewLineChar"/>
				<xsl:for-each select="Row">
					<xsl:call-template name="printTableDataRow"/>
					<xsl:call-template name="putNewLineChar"/>
				</xsl:for-each>
				<xsl:call-template name="putNewLineChar"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Template End: TableData-->
	<!-- Template Begin: SummaryData-->
	<xsl:template match="SummaryData">
		<xsl:apply-templates />
	</xsl:template>
	<!-- Template End: SummaryData-->
	<!-- Template Begin: Section-->
	<xsl:template match="Section">
		<xsl:apply-templates />
	</xsl:template>
	<!-- Template End: Section-->
	<!-- Template Begin: printTableDataHeader-->
	<xsl:template name="printTableDataHeader">
		<xsl:for-each select="Header/Data">
			<xsl:choose>
				<xsl:when test="$requestType = 'cli' ">
					<xsl:choose>
						<xsl:when test="@ignoreoncli = 'true'"><!-- Ignore this data item --></xsl:when>
						<xsl:otherwise><xsl:call-template name="printHeaderData"/></xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="$requestType = 'web' ">
					<xsl:choose>
						<xsl:when test="@ignoreonweb = 'true'"><!-- Ignore this data item --></xsl:when>
						<xsl:otherwise><xsl:call-template name="printHeaderData"/></xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise><xsl:call-template name="printHeaderData"/></xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<!-- Template End: printTableDataHeader-->
	<!-- Template Begin: printTableDataMultiHeader-->
	<xsl:template name="printTableDataMultiHeader">
		<xsl:variable name="headerIndex"><xsl:value-of select="count(Header)"/></xsl:variable>
		<xsl:choose>
			<xsl:when test="$headerIndex = 2">
				<xsl:for-each select="Header[2]/Data">
					<xsl:choose>
						<xsl:when test="$requestType = 'cli' ">
							<xsl:choose>
								<xsl:when test="@ignoreoncli = 'true'"><!-- Ignore this data item --></xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="printHeaderData">
										<xsl:with-param name="multi">true</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:when test="$requestType = 'web' ">
							<xsl:choose>
								<xsl:when test="@ignoreonweb = 'true'"><!-- Ignore this data item --></xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="printHeaderData">
										<xsl:with-param name="multi">true</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="printHeaderData">
								<xsl:with-param name="multi">true</xsl:with-param>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<!-- We do not support more than 2 headers. -->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Template End: printTableDataMultiHeader-->
	<!-- Template Begin: printTableDataRow-->
	<xsl:template name="printTableDataRow">
		<xsl:for-each select="Data">
			<xsl:choose>
				<xsl:when test="$requestType = 'cli' ">
					<xsl:choose>
						<xsl:when test="@ignoreoncli = 'true'"><!-- Ignore this data item --></xsl:when>
						<xsl:otherwise><xsl:call-template name="printRowData"/></xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="$requestType = 'web' ">
					<xsl:choose>
						<xsl:when test="@ignoreonweb = 'true'"><!-- Ignore this data item --></xsl:when>
						<xsl:otherwise><xsl:call-template name="printRowData"/></xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise><xsl:call-template name="printRowData"/></xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<!-- Template End: printTableDataRow-->
	<!-- Template Begin: printTableDataRow-->
	<xsl:template name="printRowData">
		<xsl:choose>
			<xsl:when test="@type">
				<xsl:choose>
					<xsl:when test="@type='password'">
						<xsl:call-template name="printPassWord"><xsl:with-param name="size"><xsl:value-of select="@size"/></xsl:with-param></xsl:call-template>
					</xsl:when>
					<xsl:when test="@type='textarea'">
						<xsl:value-of select="@value"/>
					</xsl:when>
					<xsl:when test="@type='editbox'">
						<xsl:value-of select="@value"/>
					</xsl:when>
					<xsl:when test="@type='checkbox'">
						<xsl:if test="@value != ''">
							<xsl:value-of select="@value"/><xsl:text> </xsl:text>
						</xsl:if>
						<xsl:call-template name="printState"><xsl:with-param name="state"><xsl:value-of select="@state"/></xsl:with-param></xsl:call-template>
					</xsl:when>
					<xsl:when test="@type='radio'">
						<xsl:if test="@value != ''">
							<xsl:value-of select="@value"/><xsl:text> </xsl:text>
						</xsl:if>
						<xsl:call-template name="printState"><xsl:with-param name="state"><xsl:value-of select="@state"/></xsl:with-param></xsl:call-template>
					</xsl:when>
					<xsl:when test="@type='ipaddrbox'">
						<xsl:value-of select="@value1"/><xsl:text>.</xsl:text><xsl:value-of select="@value2"/><xsl:text>.</xsl:text><xsl:value-of select="@value3"/><xsl:text>.</xsl:text><xsl:value-of select="@value4"/>
					</xsl:when>
					<xsl:when test="@type='select'">
						<xsl:for-each select="Choice">
							<xsl:if test="@default = 'true'"><xsl:value-of select="@value"/></xsl:if>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="@type='spincontrol'">
						<xsl:value-of select="@value"/>
					</xsl:when>
					<xsl:when test="@type='date'">
						<xsl:value-of select="@value"/>
					</xsl:when>
					<xsl:when test="@type='icon' ">
						<xsl:value-of select="@alt"/>
					</xsl:when>
					<xsl:when test="@type='status'">
						<xsl:call-template name="mapStatusToStr"><xsl:with-param name="status"><xsl:value-of select="@value"/></xsl:with-param></xsl:call-template>
					</xsl:when>
					<xsl:when test="@type='status-text'">
						<xsl:call-template name="mapStatusToStr"><xsl:with-param name="status"><xsl:value-of select="@value"/></xsl:with-param></xsl:call-template>
					</xsl:when>
					<xsl:otherwise><xsl:value-of select="@value"/></xsl:otherwise>
				</xsl:choose>				
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="ValueList">
						<xsl:for-each select="ValueList/value">
							<xsl:value-of select="."/>
							<xsl:if test="position() != last()">
								<xsl:value-of select="$altDelimiter"/>
							</xsl:if>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise><xsl:value-of select="@value"/></xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="position() != last()"><xsl:value-of select="$customDelimiter"/></xsl:if>
	</xsl:template>
	<!-- Template End: printRowData-->
	<!-- Template Begin: printHeaderData-->
	<xsl:template name="printHeaderData">
		<xsl:param name="multi"/>
		<xsl:choose>
			<xsl:when test="@display != '' ">
				<xsl:value-of select="@display"/>
				<xsl:if test="$multi = 'true'">
					<xsl:if test="@append != ''">
						<xsl:text> </xsl:text><xsl:value-of select="@append"/>
					</xsl:if>
				</xsl:if>
				<xsl:if test="position() != last() "><xsl:value-of select="$customDelimiter"/></xsl:if>
			</xsl:when>
			<xsl:when test="@value != '' ">
				<xsl:value-of select="@value"/>
				<xsl:if test="$multi = 'true'">
					<xsl:if test="@append != ''">
						<xsl:text> </xsl:text><xsl:value-of select="@append"/>
					</xsl:if>
				</xsl:if>
				<xsl:if test="position() != last() "><xsl:value-of select="$customDelimiter"/></xsl:if>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!-- Template End: printHeaderData-->
	<!-- Template Begin: printListDataItem -->
	<xsl:template name="printListDataItem">
		<xsl:choose>
			<!-- if request is from cli, turn on ignoreoncli attribute -->
			<xsl:when test="$requestType = 'cli' ">
				<xsl:choose>
					<xsl:when test="@ignoreoncli = 'true'"></xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="processListDataItem"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!-- if request is from web, turn on ignoreonweb attribute -->
			<xsl:when test="$requestType = 'web' ">
				<xsl:choose>
					<xsl:when test="@ignoreonweb = 'true'"></xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="processListDataItem"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!-- if request is from unknown, process as is -->
			<xsl:otherwise>
				<xsl:call-template name="processListDataItem"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Template End: printListDataItem -->
	<!-- Template Begin: processListDataItem-->
	<xsl:template name="processListDataItem">
		<xsl:choose>
			<xsl:when test="@type">
				<xsl:if test=" @type != 'hidden' ">
					<xsl:choose>
						<xsl:when test="@type='password'">
							<xsl:call-template name="printPassWord"><xsl:with-param name="size"><xsl:value-of select="@size"/></xsl:with-param></xsl:call-template>
						</xsl:when>
						<xsl:when test="@type='textarea'">
							<xsl:value-of select="@value"/>
						</xsl:when>
						<xsl:when test="@type='editbox'">
							<xsl:value-of select="@value"/>
						</xsl:when>
						<xsl:when test="@type='checkbox'">
							<xsl:if test="@value != ''">
								<xsl:value-of select="@value"/><xsl:text> </xsl:text>
							</xsl:if>
							<xsl:call-template name="printState"><xsl:with-param name="state"><xsl:value-of select="@state"/></xsl:with-param></xsl:call-template>
						</xsl:when>
						<xsl:when test="@type='radio'">
							<xsl:if test="@value != ''">
								<xsl:value-of select="@value"/><xsl:text> </xsl:text>
							</xsl:if>
							<xsl:call-template name="printState"><xsl:with-param name="state"><xsl:value-of select="@state"/></xsl:with-param></xsl:call-template>
						</xsl:when>
						<xsl:when test="@type='ipaddrbox'">
							<xsl:value-of select="@value1"/><xsl:text>.</xsl:text><xsl:value-of select="@value2"/><xsl:text>.</xsl:text><xsl:value-of select="@value3"/><xsl:text>.</xsl:text><xsl:value-of select="@value4"/>
						</xsl:when>
						<xsl:when test="@type='select'">
							<xsl:for-each select="Choice">
								<xsl:if test="@default = 'true'"><xsl:value-of select="@value"/></xsl:if>
							</xsl:for-each>
						</xsl:when>
						<xsl:when test="@type='spincontrol'">
							<xsl:value-of select="@value"/>
						</xsl:when>
						<xsl:when test="@type='date'">
							<xsl:value-of select="@value"/>
						</xsl:when>
						<xsl:when test="@type='icon' ">
							<xsl:value-of select="@alt"/>
						</xsl:when>
						<xsl:when test="@type='status'">
							<xsl:call-template name="mapStatusToStr"><xsl:with-param name="status"><xsl:value-of select="@value"/></xsl:with-param></xsl:call-template>
						</xsl:when>
						<xsl:when test="@type='status-text'">
							<xsl:call-template name="mapStatusToStr"><xsl:with-param name="status"><xsl:value-of select="@value"/></xsl:with-param></xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="ValueList">
									<xsl:for-each select="ValueList/value"><xsl:value-of select="."/><xsl:if test="position() != last()"><xsl:text> </xsl:text></xsl:if></xsl:for-each>
								</xsl:when>
								<xsl:otherwise><xsl:value-of select="@value"/></xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:if test="position() != last()"><xsl:value-of select="$customDelimiter"/></xsl:if>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="@value"/>
				<xsl:if test="position() != last()"><xsl:value-of select="$customDelimiter"/></xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Template End: processListDataItem-->
	<!-- Template Begin: printState-->
	<xsl:template name="printState">
		<xsl:param name="state"/>
		<xsl:choose>
			<xsl:when test="$state=1"><xsl:value-of select="$strSelected"/></xsl:when>
			<xsl:when test="$state=3"><xsl:value-of select="$strSelected"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$strNotSelected"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Template End: printState-->
	<!-- Template Begin: printPassWord-->
	<xsl:template name="printPassWord">
		<xsl:param name="size"/>
		<xsl:text>+</xsl:text>
		<xsl:if test="$size &gt; '0'">
			<xsl:call-template name="PassWord">
				<xsl:with-param name="size"><xsl:value-of select="($size) - 1"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<!-- Template End: printPassWord-->
	<!-- Template Begin: mapCustomDelimiterStrToChar -->
	<!--  Given custom delimiter string returns the corresponding character -->
	<xsl:template name="mapCustomDelimiterStrToChar">
		<xsl:param name="customDelimiterStr"/>
		<xsl:choose>
			<xsl:when test="$customDelimiterStr = 'ampersand' ">&amp;</xsl:when>
			<xsl:when test="$customDelimiterStr = 'exclamation' ">!</xsl:when>
			<xsl:when test="$customDelimiterStr = 'at' ">@</xsl:when>
			<xsl:when test="$customDelimiterStr = 'hash' ">#</xsl:when>
			<xsl:when test="$customDelimiterStr = 'dollar' ">$</xsl:when>
			<xsl:when test="$customDelimiterStr = 'percent' ">%</xsl:when>
			<xsl:when test="$customDelimiterStr = 'caret' ">^</xsl:when>
			<xsl:when test="$customDelimiterStr = 'asterisk' ">*</xsl:when>
			<xsl:when test="$customDelimiterStr = 'tilda' ">~</xsl:when>
			<xsl:when test="$customDelimiterStr = 'question' ">?</xsl:when>
			<xsl:when test="$customDelimiterStr = 'colon' ">:</xsl:when>
			<xsl:when test="$customDelimiterStr = 'comma' ">,</xsl:when>
			<xsl:when test="$customDelimiterStr = 'pipe' ">|</xsl:when>
			<xsl:otherwise>;</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Template End: mapCustomDelimiterStrToChar -->
	<!-- Template Begin: putNewLineChar-->
	<xsl:template name="putNewLineChar">
		<xsl:text>
</xsl:text>
	</xsl:template>
	<!-- Template End: putNewLineChar-->
	<!-- Template Begin: mapStatusToStr -->
	<xsl:template name="mapStatusToStr">
		<xsl:param name="status" />
		<xsl:choose>
			<xsl:when test="$status='0'"><xsl:value-of select="$strUnknown"/></xsl:when>
			<xsl:when test="$status='1'"><xsl:value-of select="$strUnknown"/></xsl:when>
			<xsl:when test="$status='2'"><xsl:value-of select="$strOk"/></xsl:when>
			<xsl:when test="$status='3'"><xsl:value-of select="$strNonCritical"/></xsl:when>
			<xsl:when test="$status='4'"><xsl:value-of select="$strCritical"/></xsl:when>
			<xsl:when test="$status='5'"><xsl:value-of select="$strNonRecoverable"/></xsl:when>
			<xsl:when test="$status='6'"><xsl:value-of select="$strAborted"/></xsl:when>
			<xsl:when test="$status='7'"><xsl:value-of select="$strProgress"/></xsl:when>
			<xsl:when test="$status='8'"><xsl:value-of select="$strSuspended"/></xsl:when>
			<xsl:when test="$status='9'"><xsl:value-of select="$strResume"/></xsl:when>
			<xsl:when test="$status='10'"><xsl:value-of select="$strPending"/></xsl:when>			
		</xsl:choose>
	</xsl:template>
	<!-- Template End: mapStatusToStr -->

	<xsl:template name="getAltDelimiterFromCustom">
		<xsl:param name="customDelimiter"/>
		<xsl:choose>
			<xsl:when test="$customDelimiter = ',' ">; </xsl:when>
			<xsl:otherwise>, </xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="PassWord">
		<xsl:param name="size"/>
		<xsl:text>*</xsl:text>
		<xsl:if test="$size &gt; '0'">
			<xsl:call-template name="PassWord">
				<xsl:with-param name="size"><xsl:value-of select="($size) - 1"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<!-- Template Begin: *  -->
	<!-- Filters data not supported by DataArea specification. -->
	<xsl:template match="*"/>
	<!-- Template End: *  -->
</xsl:stylesheet>
