<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

	<xsl:template xmlns:fo="http://www.w3.org/1999/XSL/Format" match="LogEntry">
		<Row>
			<Data align="center" type="status" name="severity">
				<xsl:attribute name="sevlevel">
					<xsl:call-template name="status2lev">
						<xsl:with-param name="Status">
							<xsl:value-of select="Type"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:call-template name="status2omsa">
						<xsl:with-param name="Status">
							<xsl:value-of select="Type"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
			</Data>
			<Data name="DateTime" width="175">
				<xsl:attribute name="display">
					<xsl:value-of select="TimeStamp"/>
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="DateTime"/>
				</xsl:attribute>
			</Data>
			<Data name="User">
				<xsl:attribute name="display">
					<xsl:value-of select="UserInfo"/>
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="UserInfo"/>
				</xsl:attribute>
			</Data>
			<Data name="DescriptionNoPre">
				<xsl:attribute name="display">
					<xsl:apply-templates select="Description">
						<xsl:with-param name="idd">
							<xsl:value-of select="ID"/>
						</xsl:with-param>
					</xsl:apply-templates>
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:apply-templates select="Description">
						<xsl:with-param name="idd">
							<xsl:value-of select="ID"/>
						</xsl:with-param>
						<xsl:with-param name="descrip">
							<xsl:value-of select="Description"/>
						</xsl:with-param>
					</xsl:apply-templates>
				</xsl:attribute>
			</Data>
		</Row>
	</xsl:template>

	<xsl:template xmlns:fo="http://www.w3.org/1999/XSL/Format" match="Description">
		<xsl:param name="idd"/>
		<xsl:param name="descrip"/>
    <xsl:choose>
      <xsl:when test="$idd='5060' and SMStatus != '0'">
        <xsl:value-of select="$strAutoRecoveryAction"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="descriptionString">
          <xsl:with-param name="id">
            <xsl:value-of select="$idd"/>
          </xsl:with-param>
          <xsl:with-param name="descrip">
            <xsl:value-of select="$descrip"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:choose>
			<xsl:when test="SMStatus != '0'">
				<xsl:if test="SMStatus">
					<xsl:choose>
						<xsl:when test="$idd = '0'"/>
						<xsl:when test="$idd = '1'"/>
						<xsl:when test="$idd = '5116'"/> <!-- ESM log clear failed. No need to add failed-->
						<xsl:otherwise> 
							<xsl:value-of select="$strXsltextFailedxsltext"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<!--The following message Id's will not have 'successfully' appended at the end. -->
					<xsl:when test="$idd = '0'"/>
					<xsl:when test="$idd = '1'"/>
					<xsl:when test="$idd = '5062'"/>
					<xsl:when test="$idd = '5070'"/>
					<xsl:when test="$idd = '5071'"/>
					<xsl:when test="$idd = '5072'"/>
					<xsl:when test="$idd = '5080'"/>
					<xsl:when test="$idd = '5081'"/>
					<xsl:when test="$idd = '5089'"/>
					<xsl:when test="$idd = '5115'"/>
					<xsl:when test="$idd = '5116'"/>
					<xsl:when test="$idd = '5150'"/>
					<xsl:when test="$idd = '5151'"/>
					<xsl:when test="$idd = '5152'"/>
					<xsl:when test="$idd = '5153'"/>
					<xsl:when test="$idd = '5155'"/>
					<xsl:when test="$idd = '5156'"/>
					<xsl:when test="$idd = '5157'"/>
					<xsl:when test="$idd = '5158'"/>
					<xsl:when test="$idd = '5159'"/>
					<xsl:when test="$idd = '5165'"/>
					<xsl:when test="$idd = '5166'"/>
					<xsl:when test="$idd = '5167'"/>
					<xsl:when test="$idd = '5168'"/>
					<xsl:when test="$idd = '5169'"/>
					<xsl:when test="$idd = '5170'"/>
					<xsl:when test="$idd = '5171'"/>
					<xsl:when test="$idd = '5172'"/>
					<xsl:when test="$idd = '5173'"/>
					<xsl:when test="$idd = '5174'"/>
					<xsl:when test="$idd = '5175'"/>
					<xsl:when test="$idd = '5176'"/>
					<xsl:when test="$idd = '5177'"/>
					<xsl:when test="$idd = '5178'"/>					
					<xsl:when test="$idd = '5180'"/>
					<xsl:when test="$idd = '5181'"/>
					<xsl:when test="$idd = '5182'"/>
					<xsl:when test="$idd = '5183'"/>
					<xsl:when test="$idd = '5184'"/>					
					<xsl:when test="$idd = '5185'"/>
					<xsl:when test="$idd = '5186'"/>
					<xsl:when test="$idd = '5187'"/>
					<xsl:when test="$idd = '5188'"/>
					<xsl:when test="$idd = '5189'"/>
					<xsl:when test="$idd = '5190'"/>
					<xsl:when test="$idd = '5199'"/>					
					<xsl:when test="$idd = '5200'"/>
					<xsl:when test="$idd = '5201'"/>
					<xsl:when test="$idd = '5202'"/>
					<xsl:when test="$idd = '5203'"/>
					<xsl:when test="$idd = '5204'"/>
					<xsl:when test="$idd = '5205'"/>
					<xsl:when test="$idd = '5206'"/>
					<xsl:when test="$idd = '5207'"/>
					<xsl:when test="$idd = '5208'"/>
					<xsl:when test="$idd = '5209'"/>
					<xsl:when test="$idd = '5210'"/>
					<xsl:when test="$idd = '5211'"/>
					<xsl:when test="$idd = '5212'"/>
					<xsl:when test="$idd = '5213'"/>
					<xsl:when test="$idd = '5215'"/>
					<xsl:when test="$idd = '5215'"/>
					<xsl:when test="$idd = '5216'"/>
					<xsl:when test="$idd = '5218'"/>
					<xsl:when test="$idd = '5219'"/>
					<xsl:when test="$idd = '5220'"/>
					<xsl:when test="$idd = '5301'"/>
					<xsl:when test="$idd = '5302'"/>
					<xsl:when test="$idd = '5438'"/>
					<xsl:when test="$idd = '5501'"/>
					<xsl:when test="$idd = '5502'"/>
					<xsl:when test="$idd = '5503'"/>
					<xsl:when test="$idd = '5504'"/>
					<xsl:when test="$idd = '5505'"/>
					<xsl:when test="$idd = '5506'"/>
					<xsl:when test="$idd = '5507'"/>
					<xsl:when test="$idd = '5508'"/>
					<xsl:when test="$idd = '5509'"/>
					<xsl:when test="$idd = '5510'"/>
					<xsl:when test="$idd = '5511'"/>
					<xsl:when test="$idd = '5512'"/>
					<xsl:when test="$idd = '5513'"/>
					<xsl:when test="$idd = '5514'"/>
					<xsl:when test="$idd = '5515'"/>
					<xsl:when test="$idd = '5516'"/>
					<xsl:when test="$idd = '5517'"/>
					<xsl:when test="$idd = '5518'"/>
					<xsl:when test="$idd = '5519'"/>
					<xsl:when test="$idd = '5520'"/>
					<xsl:when test="$idd = '5521'"/>
					<xsl:when test="$idd = '5522'"/>
					<xsl:when test="$idd = '5523'"/>
					<xsl:when test="$idd = '5524'"/>
					<xsl:when test="$idd = '5525'"/>
					<xsl:when test="$idd = '5526'"/>
					<xsl:when test="$idd = '5527'"/>
					<xsl:when test="$idd = '5528'"/>
					<xsl:when test="$idd = '5529'"/>
					<xsl:when test="$idd = '5530'"/>
					<xsl:when test="$idd = '5531'"/>
					<xsl:when test="$idd = '5532'"/>
					<xsl:when test="$idd = '5533'"/>
					<xsl:when test="$idd = '5534'"/>
					<xsl:when test="$idd = '5535'"/>
					<xsl:when test="$idd = '5536'"/>
					<xsl:when test="$idd = '5537'"/>
					<xsl:when test="$idd = '5538'"/>
					<xsl:when test="$idd = '5539'"/>
					<xsl:when test="$idd = '5540'"/>
					<xsl:when test="$idd = '5541'"/>
					<xsl:when test="$idd = '5542'"/>
					<xsl:when test="$idd = '5543'"/>
					<xsl:when test="$idd = '5544'"/>
					<xsl:when test="$idd = '5545'"/>
					<xsl:when test="$idd = '5546'"/>
					<xsl:when test="$idd = '5547'"/>
					<xsl:when test="$idd = '5548'"/>
					<xsl:when test="$idd = '5549'"/>
					<xsl:when test="$idd = '5555'"/>
					<xsl:when test="$idd = '5568'"/>
          <xsl:when test="$idd = '5589'"/>
          <xsl:when test="$idd = '5590'"/>
          <xsl:when test="$idd = '5591'"/>
					<xsl:when test="$idd = '5602'"/>
					<xsl:when test="$idd = '5603'"/>
					<xsl:when test="$idd = '5604'"/>
					<xsl:when test="$idd = '5605'"/>
					<xsl:when test="$idd = '5710'"/>
					<xsl:when test="$idd = '5719'"/>
					<xsl:when test="$idd = '5728'"/>
					<xsl:when test="$idd = '5737'"/>
					<xsl:when test="$idd = '5739'"/>
					<xsl:when test="$idd = '5741'"/>
					<xsl:when test="$idd = '5744'"/>
					<xsl:when test="$idd = '5745'"/>					
					<xsl:when test="$idd = '5901'"/>
					<xsl:when test="$idd = '5902'"/>
					<xsl:when test="$idd = '5903'"/>
					<xsl:when test="$idd = '5910'"/>
          <xsl:when test="$idd = '5911'"/>
					<xsl:when test="$idd = '5912'"/>
          <xsl:when test="$idd = '5913'"/>
          <xsl:when test="$idd = '5914'"/>
          <xsl:when test="$idd = '5915'"/>
					<xsl:when test="$idd = '5916'"/>
					<xsl:when test="$idd = '5952'"/>
          <xsl:when test="$idd = '6001'"/>
					<xsl:when test="$idd = '6002'"/>
					<xsl:when test="$idd = '6003'"/>
					<xsl:when test="$idd = '6004'"/>
					<xsl:when test="$idd = '6005'"/>
					<xsl:when test="$idd = '6006'"/>
					<xsl:when test="$idd = '6007'"/>
					<xsl:when test="$idd = '6008'"/>
					<xsl:when test="$idd = '6101'"/>
					<xsl:when test="$idd = '6200'"/>
					<xsl:when test="$idd = '6201'"/>
					<xsl:when test="$idd = '6202'"/>
					<xsl:when test="$idd = '6203'"/>
					<xsl:when test="$idd = '6204'"/>
					<xsl:when test="$idd = '6205'"/>
					<xsl:when test="$idd = '6051' and securityViolation='true'"/>
					<xsl:when test="$idd = '8001'"/>
					<xsl:otherwise> 
						<!-- Append 'succesfully' at the end of message.-->
						<xsl:value-of select="$strXsltextSuccessfullyxsltext"/>
						<xsl:if test="$displayparams = 1">
							<xsl:value-of select="$strXsltextParametersXsltext"/>
							<xsl:apply-templates select="Parameter" />
						</xsl:if>		
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template xmlns:fo="http://www.w3.org/1999/XSL/Format" name="descriptionString">
		<xsl:param name="id"></xsl:param>
		<xsl:param name="descrip"/>
		<xsl:choose>
			<!-- ******************** RESERVED (0-999) ******************** -->
			<xsl:when test="$id = '0'"><xsl:value-of select="$strCommandLogCleared"/></xsl:when>
			<xsl:when test="$id = '1'"><xsl:value-of select="$strCommandLogBackup"/></xsl:when>

			<!-- ******************** HIPDA (5000-5299) ******************** -->
			<xsl:when test="$id = '5001'"><xsl:value-of select="$strHardwareESMLogCleared"/></xsl:when>
			<xsl:when test="$id = '5002'"><xsl:value-of select="$strAlertLogCleared"/></xsl:when>
			<xsl:when test="$id = '5003'"><xsl:value-of select="$strProbeThresholdModified"/></xsl:when>
			<xsl:when test="$id = '5004'"><xsl:value-of select="$strLRAResponseModified"/></xsl:when>
			<xsl:when test="$id = '5010'"><xsl:value-of select="$strAssetInfoObject"/></xsl:when>
			<xsl:when test="$id = '5011'"><xsl:value-of select="$strAssetInfoAcquisition"/></xsl:when>
			<xsl:when test="$id = '5012'"><xsl:value-of select="$strAssetInfoVendorexpensed"/></xsl:when>
			<xsl:when test="$id = '5013'"><xsl:value-of select="$strAssetInfoCost"/></xsl:when>
			<xsl:when test="$id = '5014'"><xsl:value-of select="$strAssetInfoUser"/></xsl:when>
			<xsl:when test="$id = '5015'"><xsl:value-of select="$strAssetInfoExtended"/></xsl:when>
			<xsl:when test="$id = '5016'"><xsl:value-of select="$strAssetInfoOwnership"/></xsl:when>
			<xsl:when test="$id = '5017'"><xsl:value-of select="$strAssetInfoCorporate"/></xsl:when>
			<xsl:when test="$id = '5018'"><xsl:value-of select="$strAssetInfoHazard"/></xsl:when>
			<xsl:when test="$id = '5019'"><xsl:value-of select="$strAssetInfoDeployment"/></xsl:when>
			<xsl:when test="$id = '5020'"><xsl:value-of select="$strAssetInfoTraining"/></xsl:when>
			<xsl:when test="$id = '5021'"><xsl:value-of select="$strAssetInfoOutsourcing"/></xsl:when>
			<xsl:when test="$id = '5022'"><xsl:value-of select="$strAssetInfoInsurance"/></xsl:when>
			<xsl:when test="$id = '5023'"><xsl:value-of select="$strAssetInfoDepreciation"/></xsl:when>
			<xsl:when test="$id = '5024'"><xsl:value-of select="$strAssetInfoBox"/></xsl:when>
			<xsl:when test="$id = '5025'"><xsl:value-of select="$strAssetInfoOS"/></xsl:when>
			<xsl:when test="$id = '5026'"><xsl:value-of select="$strAssetInfoCost1"/></xsl:when>
			<xsl:when test="$id = '5027'"><xsl:value-of select="$strAssetInfoWarranty"/></xsl:when>
			<xsl:when test="$id = '5028'"><xsl:value-of select="$strAssetInfoSchedule"/></xsl:when>
			<xsl:when test="$id = '5029'"><xsl:value-of select="$strAssetInfoOptions"/></xsl:when>
			<xsl:when test="$id = '5030'"><xsl:value-of select="$strAssetInfoMaintenance"/></xsl:when>
			<xsl:when test="$id = '5031'"><xsl:value-of select="$strAssetInfoRepairs"/></xsl:when>
			<xsl:when test="$id = '5032'"><xsl:value-of select="$strAssetInfoTrouble"/></xsl:when>
			<xsl:when test="$id = '5033'"><xsl:value-of select="$strAssetInfoRegister"/></xsl:when>
			<xsl:when test="$id = '5034'"><xsl:value-of select="$strAssetInfoService"/></xsl:when>
			<xsl:when test="$id = '5035'"><xsl:value-of select="$strAssetInfoLease"/></xsl:when>
			<xsl:when test="$id = '5036'"><xsl:value-of select="$strAssetInfoSupport"/></xsl:when>
			<xsl:when test="$id = '5050'"><xsl:value-of select="$strBIOSUpdatePackage"/></xsl:when>  
			<xsl:when test="$id = '5060'"><xsl:value-of select="$strXsltextAutoRecoveryAction"/>
				<xsl:variable name="child"><xsl:value-of select="count(Parameter[@newval='true'])"/></xsl:variable>
				<xsl:choose>
					<xsl:when test="$child='0'"><xsl:value-of select="$strNoAction"/></xsl:when>
					<xsl:otherwise>
					<xsl:variable name="mode"><xsl:value-of select="Parameter[@newval='true']/@name"/></xsl:variable>
					<xsl:choose>
						<xsl:when test="$mode='PwrCycle'"><xsl:value-of select="$strPowerCycle"/></xsl:when>
						<xsl:when test="$mode='PwrOff'"><xsl:value-of select="$strPowerOff"/></xsl:when>
						<xsl:when test="$mode='Reboot'"><xsl:value-of select="$strReboot"/></xsl:when>
					</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$id = '5061'"><xsl:value-of select="$strAutoRecoveryTimer"/><xsl:value-of select="Parameter[1]/@newval"/><xsl:value-of select="$strSeconds"/></xsl:when>
			<xsl:when test="$id = '5062'"><xsl:value-of select="$strSystemShutdownInitiated"/></xsl:when>
			<xsl:when test="$id = '5070'">
				<xsl:value-of select="$strAlertActionsModified"/>
				<xsl:call-template name="objectType">
					<xsl:with-param name="type">
						<xsl:if test="Parameter[@name='ObjType']">
							<xsl:value-of select="Parameter[@name='ObjType']/@value"/>
						</xsl:if>
						<xsl:if test="Parameter[@name='lrcLraType']">
							<xsl:value-of select="Parameter[@name='lrcLraType']/@val"/>
						</xsl:if>
					</xsl:with-param>
				</xsl:call-template>				
			</xsl:when>				
			<xsl:when test="$id = '5071'">
				<xsl:value-of select="$strAlertActionsExecutable"/>
				<xsl:call-template name="objectType">
						<xsl:with-param name="type">
							<xsl:if test="Parameter[@name='ObjType']">
								<xsl:value-of select="Parameter[@name='ObjType']/@value"/>
							</xsl:if>
							<xsl:if test="Parameter[@name='lrcLraType']">
								<xsl:value-of select="Parameter[@name='lrcLraType']/@val"/>
							</xsl:if>
						</xsl:with-param>
					</xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = '5072'"><xsl:value-of select="$strThermalProtectShutdown"/>
				<xsl:choose>
					<xsl:when test="Parameter[1]/@newval = '0'"><xsl:value-of select="$strDisabled"/></xsl:when>
					<xsl:when test="Parameter[1]/@newval = '1'"><xsl:value-of select="$strWarning"/></xsl:when>
					<xsl:when test="Parameter[1]/@newval = '2'"><xsl:value-of select="$strFailure"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$id = '5080'">
        <xsl:variable name="objType"><xsl:value-of select="Parameter[@name='ObjType']/@value"/></xsl:variable>
        <xsl:choose>
        <xsl:when test="$objType='25'">
        <xsl:value-of select="$strXsltextWarning"/>
        </xsl:when>
        <xsl:otherwise>
        <xsl:value-of select="$strXsltextMaximumWarning"/>
        </xsl:otherwise>
        </xsl:choose>
            <xsl:value-of select="$strXsltextProbeForPart1"/>
            <xsl:call-template name="objectType">
              <xsl:with-param name="type"><xsl:value-of select="$objType"/></xsl:with-param>
            </xsl:call-template>
            <xsl:value-of select="$strXsltextProbeForPart3"/>
            <xsl:value-of select="Parameter[@name='ProbeLocation']/@value"/>
            <xsl:if test="SMStatus = 0">
              <xsl:value-of select="$strchangedfrom"/>
              <xsl:call-template name="formatValue">
                <xsl:with-param name="value" select="Parameter[@name='UNCThreshold']/@oldval"/>
                <xsl:with-param name="type" select="$objType"/>
              </xsl:call-template>
              <xsl:value-of select="$strto"/>
              <xsl:call-template name="formatValue">
                <xsl:with-param name="value" select="Parameter[@name='UNCThreshold']/@newval"/>
                <xsl:with-param name="type" select="$objType"/>
              </xsl:call-template>
            </xsl:if>
			</xsl:when>
			<xsl:when test="$id = '5081'">
        <xsl:variable name="objType"><xsl:value-of select="Parameter[@name='ObjType']/@value"/></xsl:variable>
        <xsl:value-of select="$strXsltextMinimumWarning"/>
				<xsl:value-of select="$strXsltextProbeFor1Part1"/>
				<xsl:call-template name="objectType">
					<xsl:with-param name="type"><xsl:value-of select="$objType"/></xsl:with-param>
				</xsl:call-template>
				<xsl:value-of select="$strXsltextProbeFor1Part3"/>
 				<xsl:value-of select="Parameter[@name='ProbeLocation']/@value"/>
        <xsl:if test="SMStatus = 0">
          <xsl:value-of select="$strchangedfrom"/>
          <xsl:call-template name="formatValue">
            <xsl:with-param name="value" select="Parameter[@name='LNCThreshold']/@oldval"/>
            <xsl:with-param name="type" select="$objType"/>
          </xsl:call-template>
          <xsl:value-of select="$strto"/>
          <xsl:call-template name="formatValue">
            <xsl:with-param name="value" select="Parameter[@name='LNCThreshold']/@newval"/>
            <xsl:with-param name="type" select="$objType"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:when>
			<xsl:when test="$id = '5085'"><xsl:value-of select="$strSecurityGroupUser"/></xsl:when>
			<xsl:when test="$id = '5086'"><xsl:value-of select="$strSecurityGroupUser1"/></xsl:when>
			<xsl:when test="$id = '5087'"><xsl:value-of select="$strSecurityGroupUser2"/></xsl:when>
			<xsl:when test="$id = '5088'"><xsl:value-of select="$strSecurityGroupRoot"/></xsl:when>
			<xsl:when test="$id = '5089'"><xsl:value-of select="$strSecurityGroupRoot1"/></xsl:when>
			<xsl:when test="$id = '5090'"><xsl:value-of select="$strSystemChassisName"/></xsl:when>
			<xsl:when test="$id = '5091'"><xsl:value-of select="$strXsltextChassisFanControl"/>
				<xsl:choose>
					<xsl:when test="Parameter[1]/@newval = '1'"><xsl:value-of select="$strQuietMode"/></xsl:when>
					<xsl:when test="Parameter[1]/@newval = '2'"><xsl:value-of select="$strFullSpeedMode"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$id = '5092'"><xsl:value-of select="$strChassisLEDControl"/></xsl:when>
			<xsl:when test="$id = '5093'"><xsl:value-of select="$strChassisLEDState"/></xsl:when>
			<xsl:when test="$id = '5094'"><xsl:value-of select="$strChassisPowerButton"/></xsl:when>
			<xsl:when test="$id = '5095'"><xsl:value-of select="$strXsltextChassisIdentifyxsltext"/>
				<xsl:choose>
					<xsl:when test="Parameter[1]/@value = '1'"><xsl:value-of select="$strTurnedOn"/></xsl:when>
					<xsl:when test="Parameter[1]/@value = '0'"><xsl:value-of select="$strTurnedOff"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$id = '5096'"><xsl:value-of select="$strChassisAssetTag"/>'<xsl:value-of select="Parameter[1]/@newval"/>'</xsl:when>
			<xsl:when test="$id = '5097'"><xsl:value-of select="$strChassisIdentifyTimeout"/></xsl:when>
			<xsl:when test="$id = '5098'"><xsl:value-of select="$strHarddriveFaultLED"/></xsl:when>
			<xsl:when test="$id = '5099'"><xsl:value-of select="$strChassisDiagnosticInterrupt"/></xsl:when>
			<xsl:when test="$id = '5100'"><xsl:value-of select="$strSystemInfoLocation"/></xsl:when>
			<xsl:when test="$id = '5101'"><xsl:value-of select="$strSystemInfoPrimary"/></xsl:when>
			<xsl:when test="$id = '5102'"><xsl:value-of select="$strSystemInfoPrimary1"/></xsl:when>
			<xsl:when test="$id = '5105'"><xsl:value-of select="$strMemoryErrorCount"/></xsl:when>
			<xsl:when test="$id = '5106'"><xsl:value-of select="$strMemoryRedundancyConfiguration"/></xsl:when>
			<xsl:when test="$id = '5110'"><xsl:value-of select="$strACSwitchMode"/></xsl:when>
			<xsl:when test="$id = '5111'"><xsl:value-of select="$strACSwitchRedundancy"/></xsl:when>
			<xsl:when test="$id = '5115'"><xsl:value-of select="$strESMLogCleared"/></xsl:when>
			<xsl:when test="$id = '5116'"><xsl:value-of select="$strESMLogClearFailed"/></xsl:when>
			<xsl:when test="$id = '5120'"><xsl:value-of select="$strAlertLogCleared1"/></xsl:when>
			<xsl:when test="$id = '5125'"><xsl:value-of select="$strBIOSSetupState"/></xsl:when>
			<xsl:when test="$id = '5135'"><xsl:value-of select="$strServerModuleAssetTag"/>'<xsl:value-of select="Parameter[1]/@newval"/>'</xsl:when>
			<!-- ********************  HIPDA EMP  ************************ -->
			<xsl:when test="$id = '5150'"><xsl:value-of select="$strBMCUserNameModified"/>
				<xsl:value-of select="Parameter[@name='userID']/@value"/>
			</xsl:when>
			<xsl:when test="$id = '5151'"><xsl:value-of select="$strBMCUserPasswordModified"/>
				<xsl:value-of select="Parameter[@name='userID']/@value"/>
			</xsl:when>
			<xsl:when test="$id = '5152'"><xsl:value-of select="$strBMCUserStateModified"/>
				<xsl:value-of select="Parameter[@name='userID']/@value"/>
			</xsl:when>
			<xsl:when test="$id = '5153'"><xsl:value-of select="$strBMCUserAccessModified"/>
				<xsl:value-of select="Parameter[@name='userID']/@value"/>
			</xsl:when>
			<xsl:when test="$id = '5155'"><xsl:value-of select="$strBMCSerialChannelAccess"/></xsl:when>
			<xsl:when test="$id = '5156'"><xsl:value-of select="$strBMCSerialAuthenticationModified"/></xsl:when>
			<xsl:when test="$id = '5157'"><xsl:value-of select="$strBMCSerialConnectionMode"/></xsl:when>
			<xsl:when test="$id = '5158'"><xsl:value-of select="$strBMCSerialComminicationSettings"/></xsl:when>
			<xsl:when test="$id = '5159'"><xsl:value-of select="$strBMCSerialTerminalConfiguration"/></xsl:when>
			<xsl:when test="$id = '5165'"><xsl:value-of select="$strBMCLANChannelEnable"/></xsl:when>
			<xsl:when test="$id = '5166'"><xsl:value-of select="$strBMCLANChannelAccess"/></xsl:when>
			<xsl:when test="$id = '5167'"><xsl:value-of select="$strBMCLANAuthenticationInfo"/></xsl:when>
			<xsl:when test="$id = '5168'"><xsl:value-of select="$strBMCLANIPAddressSource"/></xsl:when>
			<xsl:when test="$id = '5169'"><xsl:value-of select="$strBMCLANIPAddress"/></xsl:when>
			<xsl:when test="$id = '5170'"><xsl:value-of select="$strBMCLANSubnetMask"/></xsl:when>
			<xsl:when test="$id = '5171'"><xsl:value-of select="$strBMCLANIPv4Header"/></xsl:when>
			<xsl:when test="$id = '5172'"><xsl:value-of select="$strBMCLANDefaultGateway"/></xsl:when>
			<xsl:when test="$id = '5173'"><xsl:value-of select="$strBMCLANCommunityString"/></xsl:when>
			<xsl:when test="$id = '5174'"><xsl:value-of select="$strBMCLANVLANID"/></xsl:when>
			<xsl:when test="$id = '5175'"><xsl:value-of select="$strBMCLANVLANPriority"/></xsl:when>
			<xsl:when test="$id = '5176'"><xsl:value-of select="$strBMCLANDestinationType"/></xsl:when>
			<xsl:when test="$id = '5177'"><xsl:value-of select="$strBMCLANDestinationAddress"/></xsl:when>
			<xsl:when test="$id = '5178'"><xsl:value-of select="$strBMCLANChannelPEF"/></xsl:when>			
			<xsl:when test="$id = '5180'"><xsl:value-of select="$strBMCPEFControlModified"/></xsl:when>
			<xsl:when test="$id = '5181'"><xsl:value-of select="$strBMCPEFActionGlobal"/></xsl:when>
			<xsl:when test="$id = '5182'"><xsl:value-of select="$strBMCPEFGUIDModified"/></xsl:when>
			<xsl:when test="$id = '5183'"><xsl:value-of select="$strBMCPEFEventFilter"/></xsl:when>
			<xsl:when test="$id = '5184'"><xsl:value-of select="$strBMCPEFAlertPolicy"/></xsl:when>			
			<xsl:when test="$id = '5185'"><xsl:value-of select="$strBMCSOLEnableModified"/></xsl:when>
			<xsl:when test="$id = '5186'"><xsl:value-of select="$strBMCSOLAuthenticationModified"/></xsl:when>
			<xsl:when test="$id = '5187'"><xsl:value-of select="$strBMCSOLCharModified"/></xsl:when>
			<xsl:when test="$id = '5188'"><xsl:value-of select="$strBMCSOLRetryValue"/></xsl:when>
			<xsl:when test="$id = '5189'"><xsl:value-of select="$strBMCSOLBitrateNonvolatile"/></xsl:when>
			<xsl:when test="$id = '5190'"><xsl:value-of select="$strBMCSOLBitrateVolatile"/></xsl:when>
			<xsl:when test="$id = '5199'"><xsl:value-of select="$strBMCRestoreToDefault"/></xsl:when>
			<!-- ********************  HIPDA SNMP Traps ****************** -->
			<xsl:when test="$id = '5200'"><xsl:value-of select="$strSNMPTrapsFor"/></xsl:when>
			<xsl:when test="$id = '5201'"><xsl:value-of select="$strSNMPTrapsFor1"/></xsl:when>
			<xsl:when test="$id = '5202'"><xsl:value-of select="$strSNMPTrapsFor2"/></xsl:when>
			<xsl:when test="$id = '5203'"><xsl:value-of select="$strSNMPTrapsFor3"/></xsl:when>
			<xsl:when test="$id = '5204'"><xsl:value-of select="$strSNMPTrapsFor4"/></xsl:when>
			<xsl:when test="$id = '5205'"><xsl:value-of select="$strSNMPTrapsFor5"/></xsl:when>
			<xsl:when test="$id = '5206'"><xsl:value-of select="$strSNMPTrapsFor6"/></xsl:when>
			<xsl:when test="$id = '5207'"><xsl:value-of select="$strSNMPTrapsFor7"/></xsl:when>
			<xsl:when test="$id = '5208'"><xsl:value-of select="$strSNMPTrapsFor8"/></xsl:when>
			<xsl:when test="$id = '5209'"><xsl:value-of select="$strSNMPTrapsFor9"/></xsl:when>
			<xsl:when test="$id = '5210'"><xsl:value-of select="$strSNMPTrapsFor10"/></xsl:when>
			<xsl:when test="$id = '5211'"><xsl:value-of select="$strSNMPTrapsFor11"/></xsl:when>
			<xsl:when test="$id = '5212'"><xsl:value-of select="$strSNMPTrapsFor12"/><xsl:value-of select="Name"/></xsl:when>
			<xsl:when test="$id = '5213'"><xsl:value-of select="$strSNMPTrapsFor13"/></xsl:when>
			<xsl:when test="$id = '5214'"><xsl:value-of select="$strSecurityGroupSNMPset"/></xsl:when>
			<xsl:when test="$id = '5215'"><xsl:value-of select="$strSecurityGroupSNMPset1"/></xsl:when>
			<xsl:when test="$id = '5216'"><xsl:value-of select="$strSNMPTrapsFor16"/></xsl:when>
			
			<xsl:when test="$id = '5218'"><xsl:value-of select="$strmessageenhancedsuccess"/></xsl:when>
			<xsl:when test="$id = '5219'"><xsl:value-of select="$strmessageformatfailed"/></xsl:when>
			<xsl:when test="$id = '5220'"><xsl:value-of select="$strmessagelegacysuccess"/></xsl:when>
			<!-- ******************** CSDA (5300-5399) ******************** -->
			<xsl:when test="$id = '5301'">
				<xsl:choose>
<xsl:when test="SMStatus != '0'"><xsl:value-of select="$strUserLoginAttempt"/><xsl:value-of select="Parameter[@name='ipaddr']/@value"/></xsl:when>
<xsl:otherwise>
<xsl:choose>
<xsl:when test="Parameter[@name='dwsipaddr']">
<xsl:value-of select="$strUserLoggedIn"/><xsl:value-of select="Parameter[@name='priviliges']/@value"/><xsl:value-of select="$strfrom"/><xsl:value-of select="Parameter[@name='ipaddr']/@value"/><xsl:value-of select="$strVia"/><xsl:value-of select="Parameter[@name='dwsipaddr']/@value"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="$strUserLoggedIn"/><xsl:value-of select="Parameter[@name='priviliges']/@value"/><xsl:value-of select="$strfrom"/><xsl:value-of select="Parameter[@name='ipaddr']/@value"/>
</xsl:otherwise>
</xsl:choose>
</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$id = '5302'"><xsl:value-of select="$strUserLoggedOut"/></xsl:when>

			<!-- ******************** ACCESS CONFIGURATION (5310 - 5315) ******************** -->
			<xsl:when test="$id = '5311'"><xsl:value-of select="$strUserAccessRights"/></xsl:when>
			<xsl:when test="$id = '5312'"><xsl:value-of select="$strUserAccessRights1"/></xsl:when>
			<xsl:when test="$id = '5313'"><xsl:value-of select="$strUserAccessRights2"/></xsl:when>

			<!-- ******************** DRSDA (5400-5499) ******************** -->
			<xsl:when test="$id = '5401'"><xsl:value-of select="$strRemoteAccessCard"/></xsl:when>
			<xsl:when test="$id = '5402'"><xsl:value-of select="$strRemoteAccessCard1"/></xsl:when>
			<xsl:when test="$id = '5403'"><xsl:value-of select="$strRemoteAccessCard2"/></xsl:when>
			<xsl:when test="$id = '5404'"><xsl:value-of select="$strRemoteAccessCard3"/></xsl:when>
			<xsl:when test="$id = '5405'"><xsl:value-of select="$strRemoteAccessCard4"/></xsl:when>
			<xsl:when test="$id = '5406'"><xsl:value-of select="$strRemoteAccessCard5"/></xsl:when>
			<xsl:when test="$id = '5407'"><xsl:value-of select="$strRemoteAccessCard6"/></xsl:when>
			<xsl:when test="$id = '5408'"><xsl:value-of select="$strRemoteAccessCard7"/></xsl:when>
			<xsl:when test="$id = '5409'"><xsl:value-of select="$strRemoteAccessCard8"/></xsl:when>
			<xsl:when test="$id = '5410'"><xsl:value-of select="$strRemoteAccessCard9"/></xsl:when>
			<xsl:when test="$id = '5411'"><xsl:value-of select="$strRemoteAccessCard10"/></xsl:when>
			<xsl:when test="$id = '5412'"><xsl:value-of select="$strRemoteAccessCard11"/></xsl:when>
			<xsl:when test="$id = '5413'"><xsl:value-of select="$strRemoteAccessCard12"/></xsl:when>
			<xsl:when test="$id = '5414'"><xsl:value-of select="$strRemoteAccessCard13"/></xsl:when>
			<xsl:when test="$id = '5415'"><xsl:value-of select="$strRemoteAccessCard14"/></xsl:when>
			<xsl:when test="$id = '5416'"><xsl:value-of select="$strRemoteAccessCard15"/></xsl:when>
			<xsl:when test="$id = '5417'"><xsl:value-of select="$strRemoteAccessCard16"/></xsl:when>
			<xsl:when test="$id = '5418'"><xsl:value-of select="$strRemoteAccessCard17"/></xsl:when>
			<xsl:when test="$id = '5419'"><xsl:value-of select="$strRemoteAccessCard18"/></xsl:when>
			<xsl:when test="$id = '5420'"><xsl:value-of select="$strRemoteAccessCard19"/></xsl:when>
			<xsl:when test="$id = '5421'"><xsl:value-of select="$strRemoteAccessCard20"/></xsl:when>
			<xsl:when test="$id = '5422'"><xsl:value-of select="$strRemoteAccessCard21"/></xsl:when>
			<xsl:when test="$id = '5423'"><xsl:value-of select="$strRemoteAccessCard22"/></xsl:when>
			<xsl:when test="$id = '5424'"><xsl:value-of select="$strRemoteAccessCard23"/></xsl:when>
			<xsl:when test="$id = '5425'"><xsl:value-of select="$strRemoteAccessCard24"/></xsl:when>
			<xsl:when test="$id = '5426'"><xsl:value-of select="$strRemoteAccessCard25"/></xsl:when>
			<xsl:when test="$id = '5427'"><xsl:value-of select="$strRemoteAccessCard26"/></xsl:when>
			<xsl:when test="$id = '5428'"><xsl:value-of select="$strRemoteAccessCard27"/></xsl:when>
			<xsl:when test="$id = '5429'"><xsl:value-of select="$strRemoteAccessCard28"/></xsl:when>
			<xsl:when test="$id = '5430'"><xsl:value-of select="$strRemoteAccessCard29"/></xsl:when>
			<xsl:when test="$id = '5431'"><xsl:value-of select="$strRemoteAccessCard30"/></xsl:when>
			<xsl:when test="$id = '5432'"><xsl:value-of select="$strRemoteAccessCard31"/></xsl:when>
			<xsl:when test="$id = '5433'"><xsl:value-of select="$strRemoteAccessCard32"/></xsl:when>
			<xsl:when test="$id = '5434'"><xsl:value-of select="$strRemoteAccessCard33"/></xsl:when>
			<xsl:when test="$id = '5435'"><xsl:value-of select="$strRemoteAccessCard34"/></xsl:when>
			<xsl:when test="$id = '5436'"><xsl:value-of select="$strRemoteAccessCard35"/></xsl:when>
			<xsl:when test="$id = '5437'"><xsl:value-of select="$strRemoteAccessCard36"/></xsl:when>
			<xsl:when test="$id = '5438'"><xsl:value-of select="$strUserLoginAttempt1"/><xsl:value-of select="Parameter[@name='IPADDR']/@value"/><xsl:value-of select="$strFailedAUTHMETHOD"/><xsl:value-of select="Parameter[@name='AUTHMETHOD']/@value"/>;<xsl:value-of select="$strREASON"/><xsl:value-of select="Parameter[@name='REASON']/@value"/></xsl:when>

			<!-- ******************** AMDA (5500-5599) ******************** -->
		  <xsl:when test="$id = '5555'"><xsl:value-of select="$strVirtualDiskRenamed"/></xsl:when>

			<!-- ******************** LUDA (5600-5699) ******************** -->
			<xsl:when test="$id = '5601'"><xsl:value-of select="$strTheAdministratorDeleted"/><xsl:value-of select="Parameter/@value"/></xsl:when>
			<xsl:when test="$id = '5602'"><xsl:value-of select="$strTheAdministratorLoaded"/><xsl:value-of select="Parameter[@name='pkgname']/@value"/>.  <xsl:value-of select="$strPreviousVersion"/><xsl:value-of select="Parameter[@name='locver']/@value"/>.  <xsl:value-of select="$strUpdateVersion"/><xsl:value-of select="Parameter[@name='pkgver']/@value"/><xsl:value-of select="$strTheUpdateWill"/></xsl:when>
			<xsl:when test="$id = '5603'"><xsl:value-of select="$strTheAdministratorPerformed"/><xsl:value-of select="Parameter[@name='pkgname']/@value"/>.  <xsl:value-of select="$strPreviousVersion1"/><xsl:value-of select="Parameter[@name='locver']/@value"/>.  <xsl:value-of select="$strUpdatesVersion"/><xsl:value-of select="Parameter[@name='pkgver']/@value"/></xsl:when>
			<xsl:when test="$id = '5604'"><xsl:value-of select="$strTheAdministratorPerformed1"/><xsl:value-of select="Parameter[@name='pkgname']/@value"/>.  <xsl:value-of select="$strPreviousESMVersion"/><xsl:value-of select="Parameter[@name='locver']/@value"/><xsl:value-of select="$strUpdateESMVersion"/><xsl:value-of select="Parameter[@name='pkgver']/@value"/></xsl:when>
			<xsl:when test="$id = '5605'"><xsl:value-of select="$strTheAdministratorFailed"/><xsl:value-of select="Parameter[@name='pkgname']/@value"/>.  <xsl:value-of select="$strUpdateFailedLocal"/><xsl:value-of select="Parameter[@name='locver']/@value"/>.<xsl:value-of select="$strUpdateVersion1"/><xsl:value-of select="Parameter[@name='pkgver']/@value"/></xsl:when>

			<!-- ******************** OLDDA (5700-5799) ******************** -->
			<xsl:when test="$id = '5702'"><xsl:value-of select="$strDiagnosticsSummaryPage"/></xsl:when>
			<xsl:when test="$id = '5703'"><xsl:value-of select="$strDiagnosticsApplicationLevel"/></xsl:when>
			<xsl:when test="$id = '5704'"><xsl:value-of select="$strDiagnosticsApplicationLevel1"/></xsl:when>
			<xsl:when test="$id = '5705'"><xsl:value-of select="$strDiagnosticsAdvancedSettings"/></xsl:when>
			<xsl:when test="$id = '5706'"><xsl:value-of select="$strDiagnosticsGetAdvanced"/></xsl:when>
			<xsl:when test="$id = '5707'"><xsl:value-of select="$strDiagnosticsResultHistory"/></xsl:when>
			<xsl:when test="$id = '5708'"><xsl:value-of select="$strDiagnosticsGetDifference"/></xsl:when>
			<xsl:when test="$id = '5709'"><xsl:value-of select="$strDiagnosticsDifferenceView"/></xsl:when>
			<xsl:when test="$id = '5710'"><xsl:value-of select="$strDiagnosticsConfigurationDifference"/></xsl:when>
			<xsl:when test="$id = '5712'"><xsl:value-of select="$strDiagnosticsSessionLog"/></xsl:when>
			<xsl:when test="$id = '5713'"><xsl:value-of select="$strDiagnosticsOverallProgress"/></xsl:when>
			<xsl:when test="$id = '5714'"><xsl:value-of select="$strDiagnosticsProgressRequested"/></xsl:when>
			<xsl:when test="$id = '5715'"><xsl:value-of select="$strDiagnosticsSetOverall"/></xsl:when>
			<xsl:when test="$id = '5716'"><xsl:value-of select="$strDiagnosticsGetOverall"/></xsl:when>
			<xsl:when test="$id = '5717'"><xsl:value-of select="$strDiagnosticsAborted"/></xsl:when>
			<xsl:when test="$id = '5718'"><xsl:value-of select="$strDiagnosticsCompleted"/></xsl:when>
			<xsl:when test="$id = '5719'"><xsl:value-of select="$strDiagnosticsSelectedTo"/></xsl:when>
			<xsl:when test="$id = '5720'"><xsl:value-of select="$strNoDiagnosticTest"/></xsl:when>
			<xsl:when test="$id = '5721'"><xsl:value-of select="$strDiagnosticsAdvancedSettings1"/></xsl:when>
			<xsl:when test="$id = '5722'"><xsl:value-of select="$strDiagnosticsViewBy"/></xsl:when>
			<xsl:when test="$id = '5723'"><xsl:value-of select="$strDiagnosticsViewBy1"/></xsl:when>
			<xsl:when test="$id = '5724'"><xsl:value-of select="$strDiagnosticsSelectionPage"/></xsl:when>
			<xsl:when test="$id = '5725'"><xsl:value-of select="$strDiagnosticsSelectionPage1"/></xsl:when>
			<xsl:when test="$id = '5726'"><xsl:value-of select="$strDiagnosticsSchedulerPage"/></xsl:when>
			<xsl:when test="$id = '5727'"><xsl:value-of select="$strDiagnosticsScheduledTask"/></xsl:when>
			<xsl:when test="$id = '5728'"><xsl:value-of select="$strNoDiagnosticsTask"/></xsl:when>
			<xsl:when test="$id = '5729'"><xsl:value-of select="$strDiagnosticsTaskScheduled"/></xsl:when>
			<xsl:when test="$id = '5730'"><xsl:value-of select="$strDiagnosticsResultHistory1"/></xsl:when>
			<xsl:when test="$id = '5731'"><xsl:value-of select="$strDiagnosticsWelcomePage"/></xsl:when>
			<xsl:when test="$id = '5732'"><xsl:value-of select="$strDiagnosticsAboutInfo"/></xsl:when>
			<xsl:when test="$id = '5733'"><xsl:value-of select="$strOSScheduledRun"/></xsl:when>
			<xsl:when test="$id = '5734'"><xsl:value-of select="$strOSScheduledRun1"/></xsl:when>
			<xsl:when test="$id = '5735'"><xsl:value-of select="$strCommandLineDiagnostic"/></xsl:when>
			<xsl:when test="$id = '5736'"><xsl:value-of select="$strCommandLineDiagnostic1"/></xsl:when>
			<xsl:when test="$id = '5737'"><xsl:value-of select="$strOSScheduledDiagnostic"/></xsl:when>
			<xsl:when test="$id = '5738'"><xsl:value-of select="$strDiagnosticsConfigurationDifference1"/></xsl:when>
			<xsl:when test="$id = '5739'"><xsl:value-of select="$strDiagnosticsDeviceReenumeration"/></xsl:when>
			<xsl:when test="$id = '5740'"><xsl:value-of select="$strDiagnosticsScheduledTasks"/></xsl:when>
			<xsl:when test="$id = '5741'"><xsl:value-of select="$strDiagnosticsCompletedTest"/></xsl:when>
			<xsl:when test="$id = '5742'"><xsl:value-of select="$strDiagnosticsTestSuspended"/></xsl:when>								
			<xsl:when test="$id = '5743'"><xsl:value-of select="$strDiagnosticsAllRunning"/></xsl:when>
			<xsl:when test="$id = '5744'"><xsl:value-of select="$strDiagnosticsSchedulerComponent"/></xsl:when>
			<xsl:when test="$id = '5745'"><xsl:value-of select="$strDiagnosticsEnumerationFailed"/></xsl:when>

			<!-- ******************** OMASERVER (5900-5999) ******************** -->
			<xsl:when test="$id = '5901'"><xsl:value-of select="Parameter[@name='Name']/@value"/><xsl:value-of select="$strStarted"/></xsl:when>
			<xsl:when test="$id = '5902'"><xsl:value-of select="Parameter[@name='Name']/@value"/><xsl:value-of select="$strShutdown"/></xsl:when>
			<xsl:when test="$id = '5903'"><xsl:value-of select="$strUserPreferencesModified"/></xsl:when>
			<xsl:when test="$id = '5910'"><xsl:value-of select="$strServerPreferencesModified"/></xsl:when>
			<xsl:when test="$id = '5951'"><xsl:value-of select="$strCmdLogSizeModified"/><xsl:text> </xsl:text><xsl:value-of select="Parameter/@oldval"/><xsl:value-of select="$strCmdLogMB"/><xsl:text> </xsl:text><xsl:value-of select="$strTo"/><xsl:text> </xsl:text><xsl:value-of select="Parameter/@newval"/><xsl:value-of select="$strCmdLogMB"/></xsl:when>
			<xsl:when test="$id = '5952'"><xsl:value-of select="$strCmdLogSizeFailed"/></xsl:when>

      <xsl:when test="$id = '5911'">
        <xsl:value-of select="$strFileFormatError"/>
        <xsl:value-of select="Parameter[@name='line']/@value"/>
        <xsl:value-of select="$strDefaultPermissions"/>
      </xsl:when>
      <xsl:when test="$id = '5912'">
        <xsl:value-of select="$strFileMissing"/>
        <xsl:value-of select="$strDefaultPermissions"/>
      </xsl:when>
      <xsl:when test="$id = '5913'">
        <xsl:value-of select="$strFileBadPerms"/>
        <xsl:value-of select="$strDefaultPermissions"/>
      </xsl:when>
      <xsl:when test="$id = '5914'">
        <xsl:value-of select="$strFileEmpty"/>
        <xsl:value-of select="$strDefaultPermissions"/>
      </xsl:when>
      <xsl:when test="$id = '5915'">
        <xsl:value-of select="$strFileMemoryError"/>
        <xsl:value-of select="$strDefaultPermissions"/>
      </xsl:when>
      <xsl:when test="$id = '5916'">
        <xsl:value-of select="$strDuplicateEntry"/>
        <xsl:value-of select="Parameter[@name='line']/@value"/>
        <xsl:value-of select="$strDefaultPermissions"/>
      </xsl:when>

      <!-- ******************** OMASERVER (6000-6010) ******************** -->
			<xsl:when test="$id = '6001'"><xsl:value-of select="$strX509Certificate"/><xsl:value-of select="Parameter[@name='certificate']/@value"/><xsl:value-of select="$strDeleted"/></xsl:when>
			<xsl:when test="$id = '6002'"><xsl:value-of select="$strX509Certificate1"/><xsl:value-of select="Parameter[@name='certificate']/@value"/><xsl:value-of select="$strDeleteFailed"/></xsl:when>
			<xsl:when test="$id = '6003'"><xsl:value-of select="$strX509Certificate2"/><xsl:value-of select="Parameter[@name='certificate']/@value"/><xsl:value-of select="$strGenerated"/></xsl:when>
			<xsl:when test="$id = '6004'"><xsl:value-of select="$strX509Certificate3"/><xsl:value-of select="Parameter[@name='certificate']/@value"/><xsl:value-of select="$strGenerateFailed"/></xsl:when>
			<xsl:when test="$id = '6005'"><xsl:value-of select="$strX509Certificate4"/><xsl:value-of select="Parameter[@name='certificate']/@value"/><xsl:value-of select="$strGeneratedAndMade"/></xsl:when>
			<xsl:when test="$id = '6006'"><xsl:value-of select="$strX509Certificate5"/><xsl:value-of select="Parameter[@name='certificate']/@value"/><xsl:value-of select="$strGeneratedButMake"/></xsl:when>
			<xsl:when test="$id = '6007'"><xsl:value-of select="$strX509Certificate6"/><xsl:value-of select="Parameter[@name='certificate']/@value"/><xsl:value-of select="$strImported"/></xsl:when>
			<xsl:when test="$id = '6008'"><xsl:value-of select="$strX509Certificate7"/><xsl:value-of select="Parameter[@name='certificate']/@value"/><xsl:value-of select="$strImportFailed"/></xsl:when>

			<!-- ******************** CMSDK (6100-6199) ******************** -->
			<xsl:when test="$id = '6101'"><xsl:value-of select="$strBundleUpdateSuccess"/></xsl:when>
			<xsl:when test="$id = '6102'"><xsl:value-of select="$strBundleUpdateFailed"/></xsl:when>
			
			
			<!-- ********************SessionMgmt (6051) ******************** -->
			<xsl:when test="$id = '6051'">
				<xsl:choose>
						<xsl:when test="securityViolation='true'">
							<xsl:value-of select="$strSecurityBreach"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$strSessionForUser"/><xsl:value-of select="Parameter[@name='sessionmgmt']/@value"/><xsl:value-of select="$strSessionInvalidateSuccess"/>
					   </xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			
			<!-- ******************** Power Monitoring (6061-6070) ******************** -->
			<xsl:when test="$id = '6061'"><xsl:value-of select="$strEnergyConsumptionResetSuccess"/></xsl:when>
		<xsl:when test="$id = '6062'"><xsl:value-of select="$strSystemPeakResetSuccess"/></xsl:when>
		<xsl:when test="$id = '6063'"><xsl:value-of select="$strPowerCapSuccess"/></xsl:when>
		<xsl:when test="$id = '6209'"><xsl:value-of select="$strPowerCapEnableSuccess"/></xsl:when>
		<xsl:when test="$id = '6220'"><xsl:value-of select="$strPowerProfileSuccess"/></xsl:when>
		<xsl:when test="$id = '6221'"><xsl:value-of select="$strPowerProfileSuccess"/></xsl:when>
	        <xsl:when test="$id = '6222'"><xsl:value-of select="$strPowerProfileSuccess"/></xsl:when>
		<xsl:when test="$id = '6223'"><xsl:value-of select="$strPowerProfileSuccess"/></xsl:when>

      <!-- ******************** 9G features (6200-6299) ******************** -->
			<xsl:when test="$id = '6200'"><xsl:value-of select="$strRACNICTeamingModified"/></xsl:when>
			<xsl:when test="$id = '6201'"><xsl:value-of select="$strRACEncryptModified"/></xsl:when>
			<xsl:when test="$id = '6202'"><xsl:value-of select="$strRACUserModified"/>
			<xsl:value-of select="Parameter[@name='userID']/@val"/>
			</xsl:when>
			<xsl:when test="$id = '6203'"><xsl:value-of select="$strRACUserPrivModified"/>
			<xsl:value-of select="Parameter[@name='userID']/@val"/>
			</xsl:when>
			<xsl:when test="$id = '6204'"><xsl:value-of select="$strRACSOLModified"/></xsl:when>
			<xsl:when test="$id = '6205'"><xsl:value-of select="$strRACNICEnableModified"/></xsl:when>
			<xsl:when test="$id = '6206'"><xsl:value-of select="$strLCDMessageChanged"/></xsl:when>
			
			<xsl:when test="$id = '6207'"><xsl:value-of select="$strLCDKVMState"/></xsl:when>
			<xsl:when test="$id = '6208'"><xsl:value-of select="$strLCDAccessState"/></xsl:when>
			<xsl:when test="$id = '6210'"><xsl:value-of select="$strBIOSSetupState"/></xsl:when>
			<xsl:when test="$id = '6211'"><xsl:value-of select="$strRemoteAddit"/></xsl:when>
			<xsl:when test="$id = '6212'"><xsl:value-of select="$strRemoteAddit"/></xsl:when>
			<xsl:when test="$id = '6213'"><xsl:value-of select="$strLANIPv6AddrSource"/></xsl:when>
			<xsl:when test="$id = '6214'"><xsl:value-of select="$strLANIPv6Addr"/></xsl:when>
			<xsl:when test="$id = '6215'"><xsl:value-of select="$strLANIPv6PrefexLen"/></xsl:when>
			<xsl:when test="$id = '6216'"><xsl:value-of select="$strLANIPv6Gateway"/></xsl:when>
			<xsl:when test="$id = '6217'"><xsl:value-of select="$strLANIPv6PrefDNS"/></xsl:when>
			<xsl:when test="$id = '6218'"><xsl:value-of select="$strLANIPv6AltDNS"/></xsl:when>

			<!-- ******************** OMSMDA (using AMDA) ******************** -->
			<!-- IP info is not available from omconfig...$descrip will be 'N/A' for these cases and should not be displayed in the command log -->
			<xsl:when test="$descrip!='N/A'">
				<xsl:choose>
					<xsl:when test="$id = '5501'"><xsl:value-of select="$strSMCommand5501"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5502'"><xsl:value-of select="$strSMCommand5502"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5503'"><xsl:value-of select="$strSMCommand5503"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5504'"><xsl:value-of select="$strSMCommand5504"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5505'"><xsl:value-of select="$strSMCommand5505"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5506'"><xsl:value-of select="$strSMCommand5506"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5507'"><xsl:value-of select="$strSMCommand5507"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5508'"><xsl:value-of select="$strSMCommand5508"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5509'"><xsl:value-of select="$strSMCommand5509"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5510'"><xsl:value-of select="$strSMCommand5510"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5511'"><xsl:value-of select="$strSMCommand5511"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5512'"><xsl:value-of select="$strSMCommand5512"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5513'"><xsl:value-of select="$strSMCommand5513"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5514'"><xsl:value-of select="$strSMCommand5514"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5515'"><xsl:value-of select="$strSMCommand5515"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5516'"><xsl:value-of select="$strSMCommand5516"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5517'"><xsl:value-of select="$strSMCommand5517"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5518'"><xsl:value-of select="$strSMCommand5518"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5519'"><xsl:value-of select="$strSMCommand5519"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5520'"><xsl:value-of select="$strSMCommand5520"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5521'"><xsl:value-of select="$strSMCommand5521"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5522'"><xsl:value-of select="$strSMCommand5522"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5523'"><xsl:value-of select="$strSMCommand5523"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5524'"><xsl:value-of select="$strSMCommand5524"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5525'"><xsl:value-of select="$strSMCommand5525"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5526'"><xsl:value-of select="$strSMCommand5526"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5527'"><xsl:value-of select="$strSMCommand5527"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5528'"><xsl:value-of select="$strSMCommand5528"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5529'"><xsl:value-of select="$strSMCommand5529"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5530'"><xsl:value-of select="$strSMCommand5530"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5531'"><xsl:value-of select="$strSMCommand5531"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5532'"><xsl:value-of select="$strSMCommand5532"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5533'"><xsl:value-of select="$strSMCommand5533"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5534'"><xsl:value-of select="$strSMCommand5534"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5535'"><xsl:value-of select="$strSMCommand5535"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5536'"><xsl:value-of select="$strSMCommand5536"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5537'"><xsl:value-of select="$strSMCommand5537"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5538'"><xsl:value-of select="$strSMCommand5538"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5539'"><xsl:value-of select="$strSMCommand5539"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5540'"><xsl:value-of select="$strSMCommand5540"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5541'"><xsl:value-of select="$strSMCommand5541"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5542'"><xsl:value-of select="$strSMCommand5542"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5543'"><xsl:value-of select="$strSMCommand5543"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5544'"><xsl:value-of select="$strSMCommand5544"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5545'"><xsl:value-of select="$strSMCommand5545"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5546'"><xsl:value-of select="$strSMCommand5546"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5547'"><xsl:value-of select="$strSMCommand5547"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5548'"><xsl:value-of select="$strSMCommand5548"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5549'"><xsl:value-of select="$strSMCommand5549"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5550'"><xsl:value-of select="$strSMCommand5550"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5551'"><xsl:value-of select="$strSMCommand5551"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5552'"><xsl:value-of select="$strSMCommand5552"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5553'"><xsl:value-of select="$strSMCommand5553"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5554'"><xsl:value-of select="$strSMCommand5554"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5555'"><xsl:value-of select="$strSMCommand5555"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5556'"><xsl:value-of select="$strSMCommand5556"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5557'"><xsl:value-of select="$strSMCommand5557"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5558'"><xsl:value-of select="$strSMCommand5558"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<!--New commands added for SAS support-->
					<xsl:when test="$id = '5559'"><xsl:value-of select="$strSMCommand5559"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5560'"><xsl:value-of select="$strSMCommand5560"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5561'"><xsl:value-of select="$strSMCommand5561"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5562'"><xsl:value-of select="$strSMCommand5562"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5563'"><xsl:value-of select="$strSMCommand5563"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5564'"><xsl:value-of select="$strSMCommand5564"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5565'"><xsl:value-of select="$strSMCommand5565"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5566'"><xsl:value-of select="$strSMCommand5566"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5567'"><xsl:value-of select="$strSMCommand5567"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5568'"><xsl:value-of select="$strSMCommand5568"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5569'"><xsl:value-of select="$strSMCommand5569"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5570'"><xsl:value-of select="$strSMCommand5570"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5571'"><xsl:value-of select="$strSMCommand5571"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5572'"><xsl:value-of select="$strSMCommand5572"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5573'"><xsl:value-of select="$strSMCommand5573"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5574'"><xsl:value-of select="$strSMCommand5574"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5575'"><xsl:value-of select="$strSMCommand5575"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5576'"><xsl:value-of select="$strSMCommand5576"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5577'"><xsl:value-of select="$strSMCommand5577"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5578'"><xsl:value-of select="$strSMCommand5578"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5579'"><xsl:value-of select="$strSMCommand5579"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5580'"><xsl:value-of select="$strSMCommand5580"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5581'"><xsl:value-of select="$strSMCommand5581"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5582'"><xsl:value-of select="$strSMCommand5582"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5583'"><xsl:value-of select="$strSMCommand5583"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
					<xsl:when test="$id = '5584'"><xsl:value-of select="$strSMCommand5584"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
          <xsl:when test="$id = '5589'"><xsl:value-of select="$strSMCommand5589"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
          <xsl:when test="$id = '5590'"><xsl:value-of select="$strSMCommand5590"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>
          <xsl:when test="$id = '5591'"><xsl:value-of select="$strSMCommand5591"/><xsl:value-of select="$strIP"/><xsl:value-of select="$descrip"/></xsl:when>


				</xsl:choose>
			</xsl:when>
			<xsl:when test="$descrip='N/A'">
				<xsl:choose>
					<xsl:when test="$id = '5501'"><xsl:value-of select="$strSMCommand5501"/></xsl:when>
					<xsl:when test="$id = '5502'"><xsl:value-of select="$strSMCommand5502"/></xsl:when>
					<xsl:when test="$id = '5503'"><xsl:value-of select="$strSMCommand5503"/></xsl:when>
					<xsl:when test="$id = '5504'"><xsl:value-of select="$strSMCommand5504"/></xsl:when>
					<xsl:when test="$id = '5505'"><xsl:value-of select="$strSMCommand5505"/></xsl:when>
					<xsl:when test="$id = '5506'"><xsl:value-of select="$strSMCommand5506"/></xsl:when>
					<xsl:when test="$id = '5507'"><xsl:value-of select="$strSMCommand5507"/></xsl:when>
					<xsl:when test="$id = '5508'"><xsl:value-of select="$strSMCommand5508"/></xsl:when>
					<xsl:when test="$id = '5509'"><xsl:value-of select="$strSMCommand5509"/></xsl:when>
					<xsl:when test="$id = '5510'"><xsl:value-of select="$strSMCommand5510"/></xsl:when>
					<xsl:when test="$id = '5511'"><xsl:value-of select="$strSMCommand5511"/></xsl:when>
					<xsl:when test="$id = '5512'"><xsl:value-of select="$strSMCommand5512"/></xsl:when>
					<xsl:when test="$id = '5513'"><xsl:value-of select="$strSMCommand5513"/></xsl:when>
					<xsl:when test="$id = '5514'"><xsl:value-of select="$strSMCommand5514"/></xsl:when>
					<xsl:when test="$id = '5515'"><xsl:value-of select="$strSMCommand5515"/></xsl:when>
					<xsl:when test="$id = '5516'"><xsl:value-of select="$strSMCommand5516"/></xsl:when>
					<xsl:when test="$id = '5517'"><xsl:value-of select="$strSMCommand5517"/></xsl:when>
					<xsl:when test="$id = '5518'"><xsl:value-of select="$strSMCommand5518"/></xsl:when>
					<xsl:when test="$id = '5519'"><xsl:value-of select="$strSMCommand5519"/></xsl:when>
					<xsl:when test="$id = '5520'"><xsl:value-of select="$strSMCommand5520"/></xsl:when>
					<xsl:when test="$id = '5521'"><xsl:value-of select="$strSMCommand5521"/></xsl:when>
					<xsl:when test="$id = '5522'"><xsl:value-of select="$strSMCommand5522"/></xsl:when>
					<xsl:when test="$id = '5523'"><xsl:value-of select="$strSMCommand5523"/></xsl:when>
					<xsl:when test="$id = '5524'"><xsl:value-of select="$strSMCommand5524"/></xsl:when>
					<xsl:when test="$id = '5525'"><xsl:value-of select="$strSMCommand5525"/></xsl:when>
					<xsl:when test="$id = '5526'"><xsl:value-of select="$strSMCommand5526"/></xsl:when>
					<xsl:when test="$id = '5527'"><xsl:value-of select="$strSMCommand5527"/></xsl:when>
					<xsl:when test="$id = '5528'"><xsl:value-of select="$strSMCommand5528"/></xsl:when>
					<xsl:when test="$id = '5529'"><xsl:value-of select="$strSMCommand5529"/></xsl:when>
					<xsl:when test="$id = '5530'"><xsl:value-of select="$strSMCommand5530"/></xsl:when>
					<xsl:when test="$id = '5531'"><xsl:value-of select="$strSMCommand5531"/></xsl:when>
					<xsl:when test="$id = '5532'"><xsl:value-of select="$strSMCommand5532"/></xsl:when>
					<xsl:when test="$id = '5533'"><xsl:value-of select="$strSMCommand5533"/></xsl:when>
					<xsl:when test="$id = '5534'"><xsl:value-of select="$strSMCommand5534"/></xsl:when>
					<xsl:when test="$id = '5535'"><xsl:value-of select="$strSMCommand5535"/></xsl:when>
					<xsl:when test="$id = '5536'"><xsl:value-of select="$strSMCommand5536"/></xsl:when>
					<xsl:when test="$id = '5537'"><xsl:value-of select="$strSMCommand5537"/></xsl:when>
					<xsl:when test="$id = '5538'"><xsl:value-of select="$strSMCommand5538"/></xsl:when>
					<xsl:when test="$id = '5539'"><xsl:value-of select="$strSMCommand5539"/></xsl:when>
					<xsl:when test="$id = '5540'"><xsl:value-of select="$strSMCommand5540"/></xsl:when>
					<xsl:when test="$id = '5541'"><xsl:value-of select="$strSMCommand5541"/></xsl:when>
					<xsl:when test="$id = '5542'"><xsl:value-of select="$strSMCommand5542"/></xsl:when>
					<xsl:when test="$id = '5543'"><xsl:value-of select="$strSMCommand5543"/></xsl:when>
					<xsl:when test="$id = '5544'"><xsl:value-of select="$strSMCommand5544"/></xsl:when>
					<xsl:when test="$id = '5545'"><xsl:value-of select="$strSMCommand5545"/></xsl:when>
					<xsl:when test="$id = '5546'"><xsl:value-of select="$strSMCommand5546"/></xsl:when>
					<xsl:when test="$id = '5547'"><xsl:value-of select="$strSMCommand5547"/></xsl:when>
					<xsl:when test="$id = '5548'"><xsl:value-of select="$strSMCommand5548"/></xsl:when>
					<xsl:when test="$id = '5549'"><xsl:value-of select="$strSMCommand5549"/></xsl:when>
					<xsl:when test="$id = '5550'"><xsl:value-of select="$strSMCommand5550"/></xsl:when>
					<xsl:when test="$id = '5551'"><xsl:value-of select="$strSMCommand5551"/></xsl:when>
					<xsl:when test="$id = '5552'"><xsl:value-of select="$strSMCommand5552"/></xsl:when>
					<xsl:when test="$id = '5553'"><xsl:value-of select="$strSMCommand5553"/></xsl:when>
					<xsl:when test="$id = '5554'"><xsl:value-of select="$strSMCommand5554"/></xsl:when>
					<xsl:when test="$id = '5555'"><xsl:value-of select="$strSMCommand5555"/></xsl:when>
					<xsl:when test="$id = '5556'"><xsl:value-of select="$strSMCommand5556"/></xsl:when>
					<xsl:when test="$id = '5557'"><xsl:value-of select="$strSMCommand5557"/></xsl:when>
					<xsl:when test="$id = '5558'"><xsl:value-of select="$strSMCommand5558"/></xsl:when>
					<!--New commands added for SAS support-->
					<xsl:when test="$id = '5559'"><xsl:value-of select="$strSMCommand5559"/></xsl:when>
					<xsl:when test="$id = '5560'"><xsl:value-of select="$strSMCommand5560"/></xsl:when>
					<xsl:when test="$id = '5561'"><xsl:value-of select="$strSMCommand5561"/></xsl:when>
					<xsl:when test="$id = '5562'"><xsl:value-of select="$strSMCommand5562"/></xsl:when>
					<xsl:when test="$id = '5563'"><xsl:value-of select="$strSMCommand5563"/></xsl:when>
					<xsl:when test="$id = '5564'"><xsl:value-of select="$strSMCommand5564"/></xsl:when>
					<xsl:when test="$id = '5565'"><xsl:value-of select="$strSMCommand5565"/></xsl:when>
					<xsl:when test="$id = '5566'"><xsl:value-of select="$strSMCommand5566"/></xsl:when>
					<xsl:when test="$id = '5567'"><xsl:value-of select="$strSMCommand5567"/></xsl:when>
					<xsl:when test="$id = '5568'"><xsl:value-of select="$strSMCommand5568"/></xsl:when>
					<xsl:when test="$id = '5569'"><xsl:value-of select="$strSMCommand5569"/></xsl:when>
					<xsl:when test="$id = '5570'"><xsl:value-of select="$strSMCommand5570"/></xsl:when>
					<xsl:when test="$id = '5571'"><xsl:value-of select="$strSMCommand5571"/></xsl:when>
					<xsl:when test="$id = '5572'"><xsl:value-of select="$strSMCommand5572"/></xsl:when>
					<xsl:when test="$id = '5573'"><xsl:value-of select="$strSMCommand5573"/></xsl:when>
					<xsl:when test="$id = '5574'"><xsl:value-of select="$strSMCommand5574"/></xsl:when>
					<xsl:when test="$id = '5575'"><xsl:value-of select="$strSMCommand5575"/></xsl:when>
					<xsl:when test="$id = '5576'"><xsl:value-of select="$strSMCommand5576"/></xsl:when>
					<xsl:when test="$id = '5577'"><xsl:value-of select="$strSMCommand5577"/></xsl:when>
					<xsl:when test="$id = '5578'"><xsl:value-of select="$strSMCommand5578"/></xsl:when>
					<xsl:when test="$id = '5579'"><xsl:value-of select="$strSMCommand5579"/></xsl:when>
					<xsl:when test="$id = '5580'"><xsl:value-of select="$strSMCommand5580"/></xsl:when>
					<xsl:when test="$id = '5581'"><xsl:value-of select="$strSMCommand5581"/></xsl:when>
					<xsl:when test="$id = '5582'"><xsl:value-of select="$strSMCommand5582"/></xsl:when>
					<xsl:when test="$id = '5583'"><xsl:value-of select="$strSMCommand5583"/></xsl:when>
					<xsl:when test="$id = '5584'"><xsl:value-of select="$strSMCommand5584"/></xsl:when>
          <xsl:when test="$id = '5589'"><xsl:value-of select="$strSMCommand5589"/></xsl:when>
          <xsl:when test="$id = '5590'"><xsl:value-of select="$strSMCommand5590"/></xsl:when>
          <xsl:when test="$id = '5591'"><xsl:value-of select="$strSMCommand5591"/></xsl:when>

				</xsl:choose>
			</xsl:when>
			<!-- ******************** UNKNOWN ******************** -->
			<xsl:otherwise><xsl:value-of select="$strUnknownEntryID"/><xsl:value-of select="$id"/>) </xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template xmlns:fo="http://www.w3.org/1999/XSL/Format" name="status2omsa">
		<xsl:param name="Status"></xsl:param>
		<xsl:choose>
			<xsl:when test="$Status=0">2</xsl:when>
			<xsl:when test="$Status=1">5</xsl:when>
			<xsl:when test="$Status=2">3</xsl:when>
			<xsl:when test="$Status=4">2</xsl:when>
			<xsl:when test="$Status=8">2</xsl:when>
			<xsl:when test="$Status=16">5</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template xmlns:fo="http://www.w3.org/1999/XSL/Format" name="status2lev">
		<xsl:param name="Status"></xsl:param>
		<xsl:choose>
			<xsl:when test="$Status=0">1</xsl:when>
			<xsl:when test="$Status=1">3</xsl:when>
			<xsl:when test="$Status=2">2</xsl:when>
			<xsl:when test="$Status=4">1</xsl:when>
			<xsl:when test="$Status=8">0</xsl:when>
			<xsl:when test="$Status=10">0</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template xmlns:fo="http://www.w3.org/1999/XSL/Format" match="Parameter">
		<xsl:choose>
			<xsl:when test="@newval"><xsl:text> </xsl:text><xsl:value-of select="@name"/>(<xsl:value-of select="@newval"/>)</xsl:when>
			<xsl:when test="@value"><xsl:text> </xsl:text><xsl:value-of select="@name"/>(<xsl:value-of select="@value"/>)</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template xmlns:fo="http://www.w3.org/1999/XSL/Format" name="objectType">
		<xsl:param name="type"></xsl:param>
		<xsl:choose>
			<xsl:when test="$type='308'"><xsl:value-of select="$strPowerSupplyWarning"/></xsl:when>
			<xsl:when test="$type='307'"><xsl:value-of select="$strProcessorFailure"/></xsl:when>
			<xsl:when test="$type='306'"><xsl:value-of select="$strProcessorWarning"/></xsl:when>
			<xsl:when test="$type='305'"><xsl:value-of select="$strHardwareLogFailure"/></xsl:when>
			<xsl:when test="$type='304'"><xsl:value-of select="$strHardwareLogWarning"/></xsl:when>
			<xsl:when test="$type='190'"><xsl:value-of select="$strMemoryFailure"/></xsl:when>
			<xsl:when test="$type='189'"><xsl:value-of select="$strMemoryPrefailure"/></xsl:when>
			<xsl:when test="$type='188'"><xsl:value-of select="$strPowerSystemRedundancy1"/></xsl:when>
			<xsl:when test="$type='187'"><xsl:value-of select="$strPowerSystemRedundancy"/></xsl:when>
			<xsl:when test="$type='186'"><xsl:value-of select="$strChassisIntrusionDetection"/></xsl:when>
			<xsl:when test="$type='185'"><xsl:value-of select="$strCurrentProbeDetects"/></xsl:when>
			<xsl:when test="$type='184'"><xsl:value-of select="$strCurrentProbeWarning"/></xsl:when>
			<xsl:when test="$type='183'"><xsl:value-of select="$strVoltageProbeDetects"/></xsl:when>
			<xsl:when test="$type='182'"><xsl:value-of select="$strVoltageProbeWarning"/></xsl:when>
			<xsl:when test="$type='181'"><xsl:value-of select="$strFanProbeDetects"/></xsl:when>
			<xsl:when test="$type='180'"><xsl:value-of select="$strFanProbeWarning"/></xsl:when>
			<xsl:when test="$type='179'"><xsl:value-of select="$strTemperatureProbeDetects"/></xsl:when>
			<xsl:when test="$type='178'"><xsl:value-of select="$strTemperatureProbeWarning"/></xsl:when>
			<xsl:when test="$type='189'"><xsl:value-of select="$strMemoryPrefailure"/></xsl:when>
			<xsl:when test="$type='188'"><xsl:value-of select="$strPowerSystemRedundancy1"/></xsl:when>
			<xsl:when test="$type='187'"><xsl:value-of select="$strPowerSystemRedundancy"/></xsl:when>
			<xsl:when test="$type='186'"><xsl:value-of select="$strChassisIntrusionDetection"/></xsl:when>
			<xsl:when test="$type='185'"><xsl:value-of select="$strCurrentProbeDetects"/></xsl:when>
			<xsl:when test="$type='184'"><xsl:value-of select="$strCurrentProbeWarning"/></xsl:when>
			<xsl:when test="$type='183'"><xsl:value-of select="$strVoltageProbeDetects"/></xsl:when>
			<xsl:when test="$type='182'"><xsl:value-of select="$strVoltageProbeWarning"/></xsl:when>
			<xsl:when test="$type='181'"><xsl:value-of select="$strFanProbeDetects"/></xsl:when>
			<xsl:when test="$type='180'"><xsl:value-of select="$strFanProbeWarning"/></xsl:when>
			<xsl:when test="$type='179'"><xsl:value-of select="$strTemperatureProbeDetects"/></xsl:when>
			<xsl:when test="$type='178'"><xsl:value-of select="$strTemperatureProbeWarning"/></xsl:when>
			<xsl:when test="$type='177'"><xsl:value-of select="$strPowerSupplyCritical"/></xsl:when>
			<xsl:when test="$type='175'"><xsl:value-of select="$strWatchdogASR"/></xsl:when>
			<xsl:when test="$type='25'"><xsl:value-of select="$strSystemPower"/></xsl:when>
			<xsl:when test="$type='24'"><xsl:value-of select="$strVoltage"/></xsl:when>
			<xsl:when test="$type='23'"><xsl:value-of select="$strFan"/></xsl:when>		
			<xsl:when test="$type='22'"><xsl:value-of select="$strTemperature"/></xsl:when>
			<xsl:when test="$type='21'"><xsl:value-of select="$strPowersupply"/></xsl:when>
			<xsl:when test="$type='309'"><xsl:value-of select="$strBatteryProbeWarning"/></xsl:when>
			<xsl:when test="$type='310'"><xsl:value-of select="$strBatteryProbeDetects"/></xsl:when>
			<xsl:when test="$type='311'"><xsl:value-of select="$strSystemPeakPower"/></xsl:when>
		</xsl:choose>
	</xsl:template>
  
  <xsl:template name="formatValue">
	  <xsl:param name="value"/>
    <xsl:param name="type"/>
    <xsl:variable name="formatval">
      <xsl:choose>
        <!-- Fan and Power Consumption threshold -->
        <xsl:when test="$type = 23 or $type = 25">
          <xsl:choose>
            <xsl:when test="$value = '-2147483648'"><xsl:value-of select="$strDefaultValue"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$value"/></xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <!-- Temperature threshold -->
        <xsl:when test="$type = 22">
          <xsl:choose>
            <xsl:when test="$value = '-2147483648'"><xsl:value-of select="$strDefaultValue"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="format-number($value div 10,'##0.0')"/></xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <!-- Voltage threshold -->
        <xsl:when test="$type = 24">
          <xsl:choose>
            <xsl:when test="$value = '-2147483648'"><xsl:value-of select="$strDefaultValue"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="format-number($value div 1000,'##0.000')"/></xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <!-- others -->
        <xsl:otherwise><xsl:value-of select="$value"/></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
		<xsl:variable name="univdecsep">
			<xsl:choose>
				<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = '.'">.</xsl:when>
				<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = ','">,</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="localdecsep"><xsl:value-of select="$strDecimalFractionSeperator"/></xsl:variable>
		<xsl:value-of select="translate($formatval,$univdecsep,$localdecsep)"/>
  </xsl:template>

</xsl:stylesheet>

