<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
 <xsl:variable name="brand">
			<xsl:choose>
			<xsl:when test="/OMA/Brand='0'">dell</xsl:when>
			<xsl:when test="/OMA/Brand='1'">debrand</xsl:when>
			<xsl:otherwise>rebrand</xsl:otherwise>
			</xsl:choose>
	</xsl:variable>
	<xsl:template match="/OMA">
		<DataArea  onLoad="true" validate="true" exportdata="false">
			<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.oma.webplugins.SetSvrPrefWebPlugin</xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strApply"/></xsl:attribute>
			<xsl:if test="(ServiceFlag='true') and (ServiceFlag/@osinability='false')">
				<script language="javascript">
					function restart()
					{
						if (confirm("<xsl:value-of select="$strAreYouDone"/>")){
							document.getElementById("dataarea").action=top.gnv.appendVID('./SubmitForm?plugin=com.dell.oma.webplugins.RstServiceWebPlugin');
							document.getElementById("dataarea").submit();
						}
						else{
							document.getElementById("dataarea").action=top.gnv.appendVID('./DataArea?plugin=com.dell.oma.webplugins.SvrPrefWebPlugin&amp;help=Serverpreferences');
							document.getElementById("dataarea").submit();
						}

					}

				</script>
			</xsl:if>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strServerPreferences"/></xsl:attribute>
			</PageTitle>
			<xsl:choose>
				<xsl:when test="(ServiceFlag='true') and (ServiceFlag/@osinability='true')">
					<PromptText status="3"><xsl:value-of select="$strYouNeedTo"/></PromptText>
				</xsl:when>
				<xsl:otherwise>
					<PromptText><xsl:value-of select="$strSpecifyTheFollowing"/></PromptText>
				</xsl:otherwise>
			</xsl:choose>
			
			<CustomButton>			
				<xsl:if test="(ServiceFlag='true') and (ServiceFlag/@osinability='false')">
					<Data name="shtdwn">
						<xsl:attribute name="display"><xsl:value-of select="$strRestartWebServer"/></xsl:attribute>
						<xsl:attribute name="href">javascript:restart()</xsl:attribute>
						<xsl:attribute name="formSubmit">true</xsl:attribute>
					</Data>			
				</xsl:if>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.oma.webplugins.SvrPrefWebPlugin&amp;help=Serverpreferences</xsl:attribute>
				</Data>
			</CustomButton>					
			<TableData>
				<Header>
					<Data width="35%">
						<xsl:attribute name="display"><xsl:value-of select="$strAttribute"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strAttribute1"/></xsl:attribute>
					</Data>
					<Data width="25%">
						<xsl:attribute name="display"><xsl:value-of select="$strValue"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strValue1"/></xsl:attribute>
					</Data>
					<Data width="10%">
						<xsl:attribute name="value"><xsl:text> </xsl:text></xsl:attribute>
						<xsl:attribute name="display"><xsl:text> </xsl:text></xsl:attribute>
					</Data>
					<Data width="30%">
						<xsl:attribute name="value"><xsl:text> </xsl:text></xsl:attribute>
						<xsl:attribute name="display"><xsl:text> </xsl:text></xsl:attribute>
					</Data>
				</Header>
				<Row>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strSessionTimeoutMinutes"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strSessionTimeoutMinutes1"/></xsl:attribute>
					</Data>
					<xsl:element name="Data">
						<xsl:attribute name="event">onClick</xsl:attribute>
						<xsl:attribute name="handler">javascript:trapEnableDisable(0)</xsl:attribute>
						<xsl:attribute name="name">sessionvalue</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strDisable"/></xsl:attribute>
						<xsl:attribute name="returnvalue">disable</xsl:attribute>
						<xsl:attribute name="state"><xsl:if test="Server/SesTimeout='-1'">1</xsl:if></xsl:attribute>
						<xsl:attribute name="type">radio</xsl:attribute>
					</xsl:element>
					<xsl:element name="Data">
						<xsl:attribute name="event">onClick</xsl:attribute>
						<xsl:attribute name="handler">javascript:trapEnableDisable(1)</xsl:attribute>						
						<xsl:attribute name="name">sessionvalue</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strEnable"/></xsl:attribute>
						<xsl:attribute name="returnvalue">enable</xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strSessionTimeoutMinutes2"/></xsl:attribute>
						<xsl:attribute name="type">radio</xsl:attribute>
						<xsl:attribute name="state"><xsl:if test="Server/SesTimeout!='-1'">1</xsl:if></xsl:attribute>
						<xsl:attribute name="splcase">true</xsl:attribute>
					</xsl:element>
					<xsl:element name="Data">
						<xsl:attribute name="noborderright">true</xsl:attribute>
						<xsl:attribute name="name">timer1</xsl:attribute>
						<xsl:attribute name="type">spincontrol</xsl:attribute>
						<xsl:attribute name="size">10</xsl:attribute>
						<xsl:attribute name="state">3</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:choose>
								<xsl:when test="Server/SesTimeout='-1'"><xsl:value-of select="Server/SesTimeout/@default"/></xsl:when>
								<xsl:otherwise><xsl:value-of select="Server/SesTimeout"/></xsl:otherwise>
							</xsl:choose>							
						</xsl:attribute>
						<xsl:attribute name="uparrscript"><xsl:call-template name="script11"/></xsl:attribute>
						<xsl:attribute name="downarrscript"><xsl:call-template name="script12"/></xsl:attribute>
					</xsl:element>
					<Data  display=" "  type="hidden" state="" align="left">
						<xsl:attribute name="name">timer</xsl:attribute>
						<xsl:attribute name="returnvalue">
							<xsl:choose>
								<xsl:when test="Server/SesTimeout='-1'"><xsl:value-of select="Server/SesTimeout/@default"/></xsl:when>
								<xsl:otherwise><xsl:value-of select="Server/SesTimeout"/></xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
					</Data>
				</Row>
				<Row>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strHTTPSPort"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strHTTPSPort1"/></xsl:attribute>
					</Data>
					<Data type="radio" returnvalue="usedefault" name="httpsportnumradio" event="onclick" handler="javascript:setHttpsPortToDefault()">
						<xsl:attribute name="value"><xsl:value-of select="$strUseDefault"/></xsl:attribute>
						<xsl:if test="Server/HTTPSPort = '1311'">
							<xsl:attribute name="state">1</xsl:attribute>
						</xsl:if>
					</Data>
					<Data type="radio" returnvalue="uservalue" name="httpsportnumradio" event="onclick" handler="javascript:setHttpsPortToUsrValue()"><xsl:attribute name="value"><xsl:value-of select="$strUse"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strUse1"/></xsl:attribute>
						<xsl:if test="Server/HTTPSPort != '1311'">
							<xsl:attribute name="state">1</xsl:attribute>
						</xsl:if>
					</Data>
					<Data name="httpsport" editable="true" type="editbox" align="left" size="10" maxlength="5"><xsl:attribute name="display"><xsl:value-of select="$str4"/></xsl:attribute>
						<xsl:attribute name="event">onChange</xsl:attribute>
						<xsl:attribute name="handler">javascript:chgFlag()</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="Server/HTTPSPort"/></xsl:attribute>
					</Data>
				</Row>
				<Row>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strIPAddressTo"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strIPAddressTo1"/></xsl:attribute>
					</Data>
					<xsl:element name="Data">
						<xsl:attribute name="event">onClick</xsl:attribute>
						<xsl:attribute name="handler">javascript:setAll()</xsl:attribute>						
						<xsl:attribute name="name">ipaddr</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strAll"/></xsl:attribute>
						<xsl:attribute name="returnvalue">default</xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strIPAddressTo2"/></xsl:attribute>
						<xsl:attribute name="type">radio</xsl:attribute>
						<xsl:attribute name="state">
							<xsl:choose><xsl:when test="Server/IPAddrBound/@default='true'">1</xsl:when></xsl:choose>
						</xsl:attribute>
						<xsl:attribute name="splcase">true</xsl:attribute>
					</xsl:element>
					<xsl:element name="Data">
						<xsl:attribute name="event">onClick</xsl:attribute>
						<xsl:attribute name="handler">javascript:setSpecific()</xsl:attribute>
						<xsl:attribute name="name">ipaddr</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strSpecific"/></xsl:attribute>
						<xsl:attribute name="returnvalue">specific</xsl:attribute>
						<xsl:attribute name="type">radio</xsl:attribute>
						<xsl:attribute name="state">
							<xsl:choose><xsl:when test="Server/IPAddrBound/@default='false'">1</xsl:when></xsl:choose>
						</xsl:attribute>
						<xsl:attribute name="splcase">true</xsl:attribute>
					</xsl:element>
					<Data name="IPAddress" editable="true"  type="select" event="onchange" handler="javascript:setIP()"><xsl:attribute name="display"><xsl:value-of select="$str5"/></xsl:attribute>
						<xsl:variable name="defval" select="Server/IPAddrBound/@defaultvalue"/>	
						<xsl:variable name="selectval" select="Server/IPAddrBound/@selectedvalue"/>
						<xsl:for-each select="Server/IPAddrBound/IPAddrList/IPAddr">
							<xsl:sort select="@index" order="ascending"/>
							<Choice>
								<xsl:attribute name="returnvalue"><xsl:value-of select="."/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
								<xsl:attribute name="default">
									<xsl:if test=".=$selectval">true</xsl:if>
								</xsl:attribute>
							</Choice>
						</xsl:for-each>
					</Data>
				</Row>
				
				<Row>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strMailTo"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strMailTo"/></xsl:attribute>
					</Data>
					<Data name="mailto" editable="true" type="editbox" align="left" size="20"><xsl:attribute name="display"><xsl:value-of select="$str6"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="Server/Emailto"/></xsl:attribute>
					</Data>
					<Data><xsl:attribute name="value"><xsl:value-of select="$str7"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str8"/></xsl:attribute></Data>
					<Data><xsl:attribute name="value"><xsl:value-of select="$str9"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str10"/></xsl:attribute></Data>
				</Row>
				<Row>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strSMTPServerName"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strSMTPServerName1"/></xsl:attribute>
					</Data>
					<Data name="smtp" editable="true" type="editbox" align="left" size="20"><xsl:attribute name="display"><xsl:value-of select="$str6"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="Server/SMTP"/></xsl:attribute>
					</Data>
					<Data><xsl:attribute name="value"><xsl:value-of select="$str7"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str8"/></xsl:attribute></Data>
					<Data><xsl:attribute name="value"><xsl:value-of select="$str9"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str10"/></xsl:attribute></Data>
				</Row>
			
				<Row>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strDNSSuffixFor"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strDNSSuffixFor1"/></xsl:attribute>
					</Data>
					<Data name="dns" editable="true" type="editbox" align="left" size="20"><xsl:attribute name="display"><xsl:value-of select="$str11"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="Server/DNSSuffix"/></xsl:attribute>
					</Data>
					<Data><xsl:attribute name="value"><xsl:value-of select="$str12"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str13"/></xsl:attribute></Data>
					<Data><xsl:attribute name="value"><xsl:value-of select="$str14"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str15"/></xsl:attribute></Data>
				</Row>
					
				<xsl:if test="/OMA/SHOWWEBSERVER='TRUE' and not(/OMA/SHOWINSTRUMENTATION='TRUE') ">
				
				<Row>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strCommandLogSize"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strCommandLogSize"/></xsl:attribute>
					</Data>
					<Data type="spincontrol" size="5">
						<xsl:attribute name="name">cmdlog1</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="CmdLog/CurMaxLogSizeMB"/></xsl:attribute>
						<xsl:attribute name="state">3</xsl:attribute>
						<xsl:attribute name="uparrscript">
							<xsl:call-template name="scriptcmd11">
								<xsl:with-param name="max"><xsl:value-of select="CmdLog/MaxLogSizeMB"/></xsl:with-param>
								<xsl:with-param name="incr"><xsl:value-of select="CmdLog/CurMaxLogSizeMB/@increment"/></xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
						<xsl:attribute name="downarrscript">
							<xsl:call-template name="scriptcmd12">
								<xsl:with-param name="min"><xsl:value-of select="CmdLog/MinLogSizeMB"/></xsl:with-param>
								<xsl:with-param name="incr"><xsl:value-of select="CmdLog/CurMaxLogSizeMB/@increment"/></xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
					</Data>
					<Data><xsl:attribute name="value"><xsl:value-of select="$str16"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str17"/></xsl:attribute></Data>
					<Data><xsl:attribute name="value"><xsl:value-of select="$str18"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str19"/></xsl:attribute></Data>
					<Data  display=" "  type="hidden" state="" align="left">
						<xsl:attribute name="name">cmdlog</xsl:attribute>
						<xsl:attribute name="returnvalue"><xsl:value-of select="CmdLog/CurMaxLogSizeMB"/></xsl:attribute>
					</Data>
				</Row>
				
				</xsl:if>
				
				<Row>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strSupportLink"/></xsl:attribute>	
						<xsl:attribute name="value"><xsl:value-of select="$strSupportLink1"/></xsl:attribute>						
					</Data>
					<Data name="support" editable="true" type="editbox" align="left" size="20"><xsl:attribute name="display"><xsl:value-of select="$str20"/></xsl:attribute>
						<xsl:attribute name="value">
							<xsl:choose>
							<xsl:when test="OEM/WWWSupport = './SecureSupportPageServlet'"><xsl:text></xsl:text></xsl:when>
							<xsl:otherwise><xsl:value-of select="OEM/WWWSupport"/></xsl:otherwise>						
							</xsl:choose>		
						</xsl:attribute>						
					</Data>
					<Data><xsl:attribute name="value"><xsl:value-of select="$str21"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str22"/></xsl:attribute></Data>
					<Data><xsl:attribute name="noborderright">true</xsl:attribute><xsl:attribute name="value"><xsl:value-of select="$str21"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str22"/></xsl:attribute></Data>

					<Data  display=" "  type="hidden" state="" align="left">
						<xsl:attribute name="name">logoutBtn</xsl:attribute>
						<xsl:attribute name="returnvalue">true</xsl:attribute>
					</Data>
					<Data  display=" "  type="hidden" state="" align="left">
						<xsl:attribute name="name">restart</xsl:attribute>
						<xsl:attribute name="returnvalue">false</xsl:attribute>
					</Data>
					<Data  display=" "  type="hidden" state="" align="left">
						<xsl:attribute name="name">isJREChanged</xsl:attribute>
						<xsl:attribute name="returnvalue">false</xsl:attribute>
					</Data>
					<Data  display=" "  type="hidden" state="" align="left">
						<xsl:attribute name="name">clbrowser</xsl:attribute>
						<xsl:attribute name="returnvalue">false</xsl:attribute>
					</Data>
					<Data  display=" "  type="hidden" state="" align="left">
						<xsl:attribute name="name">supportflag</xsl:attribute>
						<xsl:attribute name="returnvalue">false</xsl:attribute>
					</Data>
					<Data  display=" "  type="hidden" state="" align="left">
						<xsl:attribute name="name">supportLink</xsl:attribute>
						<xsl:attribute name="returnvalue">
							<xsl:choose>
							<xsl:when test="OEM/WWWSupport = './SecureSupportPageServlet'"><xsl:text></xsl:text></xsl:when>
							<xsl:otherwise><xsl:value-of select="OEM/WWWSupport"/></xsl:otherwise>						
							</xsl:choose>		
						</xsl:attribute>
					</Data>
				</Row>
				<Row>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strCustomDelimiter"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strCustomDelimiter"/></xsl:attribute>
					</Data>
					<Data name="newcustomdelimiter" type="select"><xsl:attribute name="display"><xsl:value-of select="$str5"/></xsl:attribute>
						<Choice>
							<xsl:attribute name="returnvalue">exclamation</xsl:attribute>
							<xsl:attribute name="value">[ ! ]</xsl:attribute>
							<xsl:if test="/OMA/CDelimiter/CustomDelimiter = 'exclamation' ">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
						<Choice>
							<xsl:attribute name="returnvalue">semicolon</xsl:attribute>
							<xsl:attribute name="value">[ ; ]</xsl:attribute>
							<xsl:if test="/OMA/CDelimiter/CustomDelimiter = 'semicolon' ">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
						<Choice>
							<xsl:attribute name="returnvalue">at</xsl:attribute>
							<xsl:attribute name="value">[  @ ]</xsl:attribute>
							<xsl:if test="/OMA/CDelimiter/CustomDelimiter = 'at' ">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
						<Choice>
							<xsl:attribute name="returnvalue">hash</xsl:attribute>
							<xsl:attribute name="value">[ # ]</xsl:attribute>
							<xsl:if test="/OMA/CDelimiter/CustomDelimiter = 'hash' ">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
						<Choice>
							<xsl:attribute name="returnvalue">dollar</xsl:attribute>
							<xsl:attribute name="value">[ $ ]</xsl:attribute>
							<xsl:if test="/OMA/CDelimiter/CustomDelimiter = 'dollar' ">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>						
						<Choice>
							<xsl:attribute name="returnvalue">caret</xsl:attribute>
							<xsl:attribute name="value">[ ^ ]</xsl:attribute>
							<xsl:if test="/OMA/CDelimiter/CustomDelimiter = 'caret' ">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
						<Choice>
							<xsl:attribute name="returnvalue">asterisk</xsl:attribute>
							<xsl:attribute name="value">[ * ]</xsl:attribute>
							<xsl:if test="/OMA/CDelimiter/CustomDelimiter = 'asterisk' ">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
						<Choice>
							<xsl:attribute name="returnvalue">tilda</xsl:attribute>
							<xsl:attribute name="value">[ ~ ]</xsl:attribute>
							<xsl:if test="/OMA/CDelimiter/CustomDelimiter = 'tilda' ">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
						<Choice>
							<xsl:attribute name="returnvalue">question</xsl:attribute>
							<xsl:attribute name="value">[ ? ]</xsl:attribute>
							<xsl:if test="/OMA/CDelimiter/CustomDelimiter = 'question' ">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
						<Choice>
							<xsl:attribute name="returnvalue">comma</xsl:attribute>
							<xsl:attribute name="value">[ , ]</xsl:attribute>
							<xsl:if test="/OMA/CDelimiter/CustomDelimiter = 'comma' ">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
						<Choice>
							<xsl:attribute name="returnvalue">pipe</xsl:attribute>
							<xsl:attribute name="value">[ | ]</xsl:attribute>
							<xsl:if test="/OMA/CDelimiter/CustomDelimiter = 'pipe' ">
								<xsl:attribute name="default">true</xsl:attribute>
							</xsl:if>
						</Choice>
					</Data>
					<Data type="hidden" name="oldcustomdelimiter">
						<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/CDelimiter/CustomDelimiter"/></xsl:attribute>
					</Data>
					<Data display=" " value=" "/>
					<Data display=" " value=" "/>
				</Row>





				<Row>
					<Data>
						<xsl:attribute name="value"><xsl:value-of select="$strEncryption"/></xsl:attribute>
					</Data>

s					<Data name="setencryption" editable="true" type="select" event="onChange" handler="javascript:setEncryptionValue()">

							<Choice>
								<xsl:attribute name="returnvalue">auto</xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strAutoNegotiate"/></xsl:attribute>
								<xsl:choose>
								<xsl:when test="Server/setencryption/@value='auto'">
									<xsl:attribute name="default">true</xsl:attribute>
								</xsl:when>
								</xsl:choose>
							</Choice>

							<Choice>
								<xsl:attribute name="returnvalue">128</xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strEncryptionlevel"/></xsl:attribute>
								<xsl:choose>
								<xsl:when test="Server/setencryption/@value='128'">
									<xsl:attribute name="default">true</xsl:attribute>
								</xsl:when>
								</xsl:choose>
							</Choice>
					</Data>
					<Data>	</Data>
					<Data>	</Data>
				</Row>


				<Row>
					<Data>
						<xsl:attribute name="value"><xsl:value-of select="$strSignAlgorithm"/></xsl:attribute>
					</Data>

					<Data name="setSignAlgo" editable="false" type="select" event="onChange" handler="javascript:setSignAlgorithmValue()">
					
					<xsl:variable name="currentAlgo"><xsl:value-of select="Server/setSignAlgo/keysignalgorithm"/></xsl:variable>
					<xsl:for-each select="Server/supportSignAlgo/supportedkeysignalgorithm">
					<xsl:variable name="supportAlgo"><xsl:value-of select="."/></xsl:variable>
					
						<Choice>
									<xsl:attribute name="returnvalue"><xsl:value-of select="$supportAlgo"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="$supportAlgo"/></xsl:attribute>
									<xsl:if test="$currentAlgo = $supportAlgo">
										<xsl:attribute name="default">true</xsl:attribute>
									</xsl:if>
						</Choice>
					</xsl:for-each>
					</Data>
					
										
					<Data  name="warnMessage" >	
						<xsl:attribute name="value"><xsl:value-of select="$str"/></xsl:attribute>
					</Data>

					<Data />



				</Row>	
				<!--JRE Independece changes. Initially it was commented out in 7.2 and then taken up again in 7.4. Currently enabling this feature-->
				<Row>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strJREEnv"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strJREEnv1"/></xsl:attribute>
					</Data>
					<xsl:element name="Data">
						<xsl:attribute name="event">onClick</xsl:attribute>
						<xsl:attribute name="handler">javascript:setBundledJRE()</xsl:attribute>						
						<xsl:attribute name="name">jre</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strBundledJRE"/></xsl:attribute>
						<xsl:attribute name="returnvalue">bundled</xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strBundledJRE"/></xsl:attribute>
						<xsl:attribute name="type">radio</xsl:attribute>
						<xsl:attribute name="state">							
							<xsl:if test="(java[1]/bundled='true') and (java[1]/selected='true')">1</xsl:if>
						</xsl:attribute>
						<xsl:attribute name="splcase">true</xsl:attribute>
					</xsl:element>
					<xsl:choose>
					<xsl:when test="count(java) &gt; number('1')">
					<xsl:element name="Data">
						<xsl:attribute name="event">onClick</xsl:attribute>
						<xsl:attribute name="handler">javascript:setSpecificJRE()</xsl:attribute>
						<xsl:attribute name="name">jre</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strSystemJRE"/></xsl:attribute>
						<xsl:attribute name="returnvalue">specific</xsl:attribute>
						<xsl:attribute name="type">radio</xsl:attribute>
						<xsl:attribute name="state">
							<xsl:choose>
							<xsl:when test="count(java) = number('1')">2</xsl:when>
							<xsl:otherwise>
								<xsl:if test="not((java[1]/bundled='true') and (java[1]/selected='true'))">1</xsl:if>
							</xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>						
						<xsl:attribute name="splcase">true</xsl:attribute>
					</xsl:element>				
					
					<Data name="JREList" editable="true"  type="select" event="onchange" handler="javascript:setJRE()"><xsl:attribute name="display"><xsl:value-of select="$strJREEnv1"/></xsl:attribute>						
						<xsl:for-each select="java">					
							<xsl:if test="not(bundled ='true')">
							<Choice>
								<xsl:attribute name="returnvalue"><xsl:value-of select="./version"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="concat(version,': ',path)"/></xsl:attribute>
								<xsl:attribute name="default">
									<xsl:if test="./selected='true'">true</xsl:if>
								</xsl:attribute>
							</Choice>
							</xsl:if>
						</xsl:for-each>
					</Data>
					</xsl:when>
					<xsl:otherwise>						
						<Data><xsl:attribute name="value"><xsl:value-of select="$strNoJRE"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$strNoJRE"/></xsl:attribute></Data>
						<Data><xsl:attribute name="value"><xsl:value-of select="$str9"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str10"/></xsl:attribute></Data>
					</xsl:otherwise>
					</xsl:choose>
				</Row>
					

			</TableData>
			
			<script language="javascript">
			
				var lastobj;
				var curobj;
				var lastobj1;
				var curobj1;
				var lastobjcmd;
				var curobjcmd;
				var lastobjcmd1;
				var curobjcmd1;
				var session1;
				var timer1;
				var httpsport1;
				var ipaddr1;
				var ipaddbox;
				var smtpval;
				var dnsval;
				var supportval;
				var mailtoval;
				var minval = 1024;
				var maxval = 65535;
				var flag = false;
				var alertflag = false;
				var _enabled = false;
				var defaultport = 1311;				
				var httpsport = <xsl:value-of select="Server/HTTPSPort"/>;
				var ipaddrsettoall = <xsl:value-of select="Server/IPAddrBound/@default"/>;
				//Changed for debranding: in case of debrand OEMTitleCompanyName should be empty and so to handle multiple spaces changed below three lines 
				var portchangemsg = "<xsl:value-of select="$strChangingTheHTTPSPart1"/>" + '<xsl:value-of select="normalize-space(OEM/OEMTitleCompanyName)"/><xsl:if test="normalize-space(OEM/OEMTitleCompanyName) != ''"><xsl:text> </xsl:text></xsl:if><xsl:value-of select="normalize-space(OEM/OEMTitleCoreProductName)"/><xsl:if test="normalize-space(OEM/OEMTitleCoreProductName) != ''"><xsl:text> </xsl:text></xsl:if>'+ "Server Administrator<xsl:value-of select="$strChangingTheHTTPSPart3"/>" + "<xsl:value-of select="$str23"/>";
				var ipaddrbindchmsg = "<xsl:value-of select="$strChangingTheIPPart1"/>" + '<xsl:value-of select="normalize-space(OEM/OEMTitleCompanyName)"/><xsl:if test="normalize-space(OEM/OEMTitleCompanyName) != ''"><xsl:text> </xsl:text></xsl:if><xsl:value-of select="normalize-space(OEM/OEMTitleCoreProductName)"/><xsl:if test="normalize-space(OEM/OEMTitleCoreProductName) != ''"><xsl:text> </xsl:text></xsl:if>'+ "Server Administrator<xsl:value-of select="$strChangingTheIPPart3"/>" +"<xsl:value-of select="$str24"/>";				
				var ipaddrbindoptmsg = "<xsl:value-of select="$strChangingTheIP1Part1"/>" + '<xsl:value-of select="normalize-space(OEM/OEMTitleCompanyName)"/><xsl:if test="normalize-space(OEM/OEMTitleCompanyName) != ''"><xsl:text> </xsl:text></xsl:if><xsl:value-of select="normalize-space(OEM/OEMTitleCoreProductName)"/><xsl:if test="normalize-space(OEM/OEMTitleCoreProductName) != ''"><xsl:text> </xsl:text></xsl:if>'+ "Server Administrator<xsl:value-of select="$strChangingTheIP1Part3"/>" +"<xsl:value-of select="$str25"/>";
				var defval;
				var currentjre;
				var changedjre;
				var encryptChange = false;
				var signAlgoChange = false;
				var showSignAlgoDropDown = "<xsl:value-of select="Server/showSignAlgo"/>";
				var origsupportval="<xsl:value-of select="OEM/WWWSupport"/>";				 
				var brandName = '<xsl:value-of select="$brand"/>';					 
					
				function initializationRoutine()
				{
					defval = document.getElementById("IPAddress").value;
					var jrevar=document.getElementsByName("jre");
					<!--JRE Independece changes. Initially it was commented out in 7.2 and then taken up again in 7.4. Currently enabling this feature.-->
					if(jrevar[0].checked == true)
					{
						currentjre="bundled";
					}
					else{
						currentjre=document.getElementById("JREList").value;
					}
					changedjre=currentjre;					
					sessionvalueVar = document.getElementsByName("sessionvalue");
					if(sessionvalueVar[1].checked == true)
					{
						session1 = "enable";
					}
					else
					{
						session1 = "disable";
					}
					timer1 = document.getElementById("timer").value;
					httpsport1 = document.getElementById("httpsport").value;

					ipaddrVar = document.getElementsByName("ipaddr");
					if(ipaddrVar[0].checked == true)
					{
						ipaddr1 = "default";
					}
					else
					{
						ipaddr1 = "specific";
					}

					ipaddbox = document.getElementById("dataarea").IPAddress.value;
					if (ipaddbox == "<xsl:value-of select="Server/IPAddrBound/@defaultvalue"/>")
					{				
						document.getElementById("IPAddress").disabled = true;
					}
					<!--JRE Independece changes. Initially it was commented out in 7.2 and then taken up again in 7.4. Currently enabling this feature.-->
					if(currentjre == 'bundled'){
						if(document.getElementById("JREList")!=null)
						{
							document.getElementById("JREList").disabled = true;
						}					
						}	
					
					
					smtpval = document.getElementById("smtp").value;
					dnsval = document.getElementById("dns").value;
					supportval = document.getElementById("support").value;
					mailtoval = document.getElementById("mailto").value;
					
					var _tempTimeout = <xsl:value-of select="Server/SesTimeout"/>;					
					if( _tempTimeout == '-1')
					{
						trapEnableDisable(0);
					}
					else
					{
						trapEnableDisable(1);
					}
					
					if(httpsport == defaultport)
					{
						document.getElementById("httpsport").disabled = true;
					}
					
					if(ipaddrsettoall)
					{
						ipaddr1 = "default";
						document.getElementById("IPAddress").disabled = true;
					}
					else
					{
						ipaddr1 = "specific";
					}
					
					if(showSignAlgoDropDown == "true")
					{
						document.getElementById("setSignAlgo").disabled = false;
					}
					else
					{
						document.getElementById("setSignAlgo").disabled = true;
					}
					<!--Disbaling support link field when system is debranded or branded as part of Defect- BITS086423-->
					if(brandName == "dell" || brandName == "debrand")
					{
						document.getElementById("support").disabled = true;
					}
					else
					{
						document.getElementById("support").disabled = false;
					}
					displayAlertText();
				}

			
				function setHttpsPortToUsrValue()
				{
					if( confirm(portchangemsg) )
					{
						document.getElementById("httpsport").disabled = false;
					}
					else
					{
						document.getElementById("dataarea").httpsportnumradio[0].checked = true;
						document.getElementById("httpsport").value = defaultport;
						document.getElementById("httpsport").disabled = true;
					}
				}
				
				function setHttpsPortToDefault()
				{
					document.getElementById("httpsport").value = defaultport;
					document.getElementById("httpsport").disabled = true;
				}
								
				function setAll()
				{
					document.getElementById("IPAddress").disabled = true;
					chgFlag();					
				}
				
				function setBundledJRE()
				{
					document.getElementById("JREList").disabled = true;					
					changedjre = "bundled";
					chgFlag();					
				}

				function setSpecific()
				{	
					// [rs] DFCT93860 Web Server throws an Exception when no IP address is found.	
					chk_ip = document.getElementById("dataarea").IPAddress.value;
					
					// Check if there is no IP address found.
					if (chk_ip=="")
					{
					// Disable the Scrollbar and the Radio button, so that no action is performed.
					
					document.getElementById("IPAddress").disabled = true;		
					document.getElementById("dataarea").ipaddr[0].checked = true;	
					}
					else
					// alert user
					if( confirm(ipaddrbindchmsg) )
					{
						document.getElementById("IPAddress").disabled = false;
						defval = document.getElementById("IPAddress").value;
						document.getElementById("IPAddress").value=defval;

						chgFlag();
					}
					else
					{
						document.getElementById("dataarea").ipaddr[0].checked = true;
					}
				}
				
				function setSpecificJRE()
				{	
					document.getElementById("JREList").disabled = false;
					changedjre = document.getElementById("JREList").value;					
					chgFlag();
					
				}
				
				function setIP()
				{
					if( confirm(ipaddrbindoptmsg) )
					{ 
						defval = document.getElementById("IPAddress").value;
						chgFlag();
					}
					else{
						document.getElementById("IPAddress").value=defval;
						return;
					}
				}
				
				function setJRE()
				{
						changedjre = document.getElementById("JREList").value;
						chgFlag();
				}

				function trapEnableDisable(_caller)
				{
					if(_caller == 0)
					{
						// disable
						_enabled	 = false;
						document.getElementById("timer1").disabled = true;
					}
					else if(_caller == 1)
					{
						// enable
						_enabled	 = true;
						document.getElementById("timer1").disabled = false;
					}
					
					chgFlag();
				}

				function chgFlag(){
					flag = true;
					return;
				}
				
				function isAlphaNumericport(text, varname)
				{
					var validValue = "ABCDEF0123456789";
					var ok = "yes";
					var temp;
					
					//Eliminate the spaces at the end
					while(''+text.charAt(text.length-1)==' '){
						text = text.substring(0,text.length-1);
					}
					
					for (var i=0; i&lt;text.length; i++){
						temp = "" + text.substring(i, i+1);
						if (validValue.indexOf(temp) == "-1"){
							if(temp != " "){
								ok = "no";
							}
						}
					}
					if (ok == "no"){
						alert(<xsl:value-of select="$strInvalidValueFor"/>);
						return false;
					}
					return true;
				}
				
				
				function isAlphaNumericsp(text, varname)
				{
					var validValue = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_'*$,.!%():[]=/?+~@";
					var ok = "yes";
					var temp;
					
					//Eliminate the spaces at the end
					while(''+text.charAt(text.length-1)==' '){
						text = text.substring(0,text.length-1);
					}
					
					for (var i=0; i&lt;text.length; i++){
						temp = "" + text.substring(i, i+1);
						if (validValue.indexOf(temp) == "-1"){
							if(temp != " "){
								ok = "no";
							}
						}
					}
					if (ok == "no"){
						alert(<xsl:value-of select="$strInvalidValueFor1"/>);
						return false;
					}
					return true;
				}

				function setEncryptionValue()
				{
					encryptChange = !encryptChange;
				}

				function setSignAlgorithmValue()
				{
					signAlgoChange = !signAlgoChange;
					displayAlertText();
				}
				
				function displayAlertText()
				{

					var algo = document.getElementById("setSignAlgo").value;
					var warnmsg = "";
					if( algo == "MD5" || algo == "md5" )
					{
						warnmsg = "<xsl:value-of select="$strMD5Warning"/>";
					}
					else if( algo == "SHA256" || algo == "sha256" || algo == "SHA512" || algo == "sha512" )
					{
						warnmsg = "<xsl:value-of select="$strSHA256Warning"/>";
					}
					
					if(warnmsg != "" )
					{
						document.getElementById("warnMessage").innerHTML = "[<xsl:value-of select="$strWarning"/>  " + warnmsg + "]";
						document.getElementById("warnMessage").className = "data-area-error";
					}
					else
						document.getElementById("warnMessage").innerHTML ="<xsl:value-of select="$str"/>";
				
				}

				function validate()
				{
				   var portVal = document.getElementById("httpsport").value;
				
					if (portVal.indexOf(' ')!= -1)
					{
						alert ("<xsl:value-of select="$strBlankSpaceFound"/>");
						document.getElementById("httpsport").value = httpsport1;
						document.getElementById("httpsport").focus();
					}
					
					document.getElementById("httpsport").disabled = false;
					var tempUNC = document.getElementById("httpsport").value;
				
					if (document.getElementById("httpsport").value == ""){
						alert("<xsl:value-of select="$strHTTPSPortShould"/>");
						document.getElementById("httpsport").value = httpsport1;
						document.getElementById("httpsport").focus();
					}
					else

						if(tempUNC.indexOf(".") != "-1")
							{
								alert(<xsl:value-of select="$strErrorWholeNumber1"/>);
								document.getElementById("httpsport").value = httpsport1;
								return false;
							}
						

						else						

						{
						if(isNaN(document.getElementById("httpsport").value) == true){
							alert("<xsl:value-of select="$strInvalidValueFor2"/>");
							document.getElementById("httpsport").value = httpsport1;
							document.getElementById("httpsport").focus();
						}
						else if(!((tonum(document.getElementById("httpsport").value) &gt;= minval)&amp;&amp;(tonum(document.getElementById("httpsport").value) &lt;= maxval))){
							alert(<xsl:value-of select="$strHTTPSPortValue"/>);
							document.getElementById("httpsport").value = httpsport1;
							document.getElementById("httpsport").focus();
						}
						else if ((document.getElementById("dns").value =="") &amp;&amp;(document.getElementById("smtp").value !="")) {
							 alert("<xsl:value-of select="$strDNSSuffixMust"/>");
							 document.getElementById("dns").focus();
						}
						else if ((document.getElementById("smtp").value == "") &amp;&amp; (document.getElementById("dns").value !="")) {
								alert("<xsl:value-of select="$strSMTPServerName2"/>");
								document.getElementById("smtp").focus();
						}
						else if( ! isAlphaNumericsp(document.getElementById("smtp").value, "<xsl:value-of select="$strSMTPServer"/>")){
							document.getElementById("smtp").value = smtpval;
							document.getElementById("smtp").focus();
						}
						else if( ! isAlphaNumericsp(document.getElementById("dns").value, "<xsl:value-of select="$strDNSSuffixFor2"/>")){
							document.getElementById("dns").value = dnsval;
							document.getElementById("dns").focus();
						}
						else if( ! isAlphaNumericsp(document.getElementById("support").value, "<xsl:value-of select="$strSupportLink2"/>")){							
							document.getElementById("support").value = supportval;
							document.getElementById("support").focus();
						}
						else if(document.getElementById("support").value == '' &amp;&amp; brandName == "dell"){							
							alert("<xsl:value-of select="$strEnterTheValue"/>");
							document.getElementById("support").value = supportval;
							document.getElementById("support").focus();							
						}					
						else if(!isAlphaNumericsp(document.getElementById("mailto").value, "<xsl:value-of select="$strMailTo"/>")){
							document.getElementById("mailto").value =mailtoval;
							document.getElementById("mailto").focus();
						}else if(document.getElementById("mailto").value != '' &amp;&amp; ((document.getElementById("mailto").value.indexOf('@')=="-1") || (document.getElementById("mailto").value.indexOf('.')=="-1"))){
							alert("<xsl:value-of select="$strEnterAProper"/>");
							document.getElementById("mailto").value = mailtoval;
							document.getElementById("mailto").focus();
						}else if(document.getElementById("mailto").value != '' &amp;&amp; ((document.getElementById("mailto").value.indexOf(',') != "-1") || (document.getElementById("mailto").value.indexOf(';') != "-1"))){
							alert("<xsl:value-of select="$strMailToDoes"/>");
							document.getElementById("mailto").value = mailtoval;
							document.getElementById("mailto").focus();														
						}
						else{
							var sessionval1;
							var ipaddrval1;
 							sessionvalueVar = document.getElementsByName("sessionvalue");
							if(sessionvalueVar[1].checked == true)
							{
								sessionval1 = "enable";
							}
							else
							{
								sessionval1 = "disable";
							}
							var timerval1= document.getElementById("timer").value;
							var httpsportval1= document.getElementById("httpsport").value;
							ipaddrVar = document.getElementsByName("ipaddr");
							if(ipaddrVar[0].checked == true)
							{
								ipaddrval1 = "default";
							}
							else
							{
								ipaddrval1 = "specific";
							}
							var supportval1 = document.getElementById("support").value;
							document.getElementById("supportLink").value=supportval1;
							if(origsupportval == "./SecureSupportPageServlet" &amp;&amp; supportval1=='')
							{
								supportval=origsupportval;
								supportval1=origsupportval;
								document.getElementById("supportLink").value=origsupportval;								
							}else if(brandName != "dell"  &amp;&amp; supportval1=='')
							{								
								supportval1="./SecureSupportPageServlet";
								document.getElementById("supportLink").value="./SecureSupportPageServlet";								
							}
							var ipaddboxval= document.getElementById("IPAddress").value;
							if((session1 != sessionval1) &amp;&amp; (flag == true)){
								document.getElementById("restart").value = "true";
								alertflag = true;
							}
							else if((timer1 != timerval1) &amp;&amp; (flag == true)){
								document.getElementById("restart").value = "true";
								alertflag = true;
							}
							else if((httpsport1 != httpsportval1) &amp;&amp; (flag == true)){
								document.getElementById("restart").value = "true";
								document.getElementById("clbrowser").value = "true";
								document.getElementById("logoutBtn").value = "false";
								alertflag = true;
							}
							else if((ipaddr1 != ipaddrval1) &amp;&amp; (flag == true)){
								document.getElementById("restart").value = "true";
								document.getElementById("clbrowser").value = "true";
								document.getElementById("logoutBtn").value = "false";
								alertflag = true;
							}
							else if((ipaddbox != ipaddboxval) &amp;&amp; (flag == true)){
								document.getElementById("restart").value = "true";
								document.getElementById("clbrowser").value = "true";
								document.getElementById("logoutBtn").value = "false";
								alertflag = true;
							}else if (supportval != supportval1){
								document.getElementById("restart").value = "true";
								document.getElementById("clbrowser").value = "true";
								document.getElementById("logoutBtn").value = "false";
								document.getElementById("supportflag").value = "true";
								alertflag = true;
							}
							<!--JRE Independece changes. Initially it was commented out in 7.2 and then taken up again in 7.4. Currently enabling this feature.-->
							else if((currentjre != changedjre) &amp;&amp; (flag == true)){
								document.getElementById("restart").value = "true";
								document.getElementById("clbrowser").value = "true";
								document.getElementById("logoutBtn").value = "false";
								document.getElementById("isJREChanged").value = "true";									
								alertflag = true;
							}
							else if( encryptChange == true ){
								document.getElementById("restart").value = "true";
								alertflag = true;
							}else if( signAlgoChange == true ){
								document.getElementById("restart").value = "true";
								alertflag = true;
							}		
														
							if(alertflag == true){
								<xsl:choose>
									<xsl:when test="/OMA/ServiceFlag/@osinability='true'">
										alert("<xsl:value-of select="$strYouNeedTo1"/>");
									</xsl:when>
									<xsl:otherwise>alert("<xsl:value-of select="$strYouNeedTo2"/>");</xsl:otherwise>
								</xsl:choose>							
							}							
							return true;
						}
						return false;
					}
					return false;
				}
				function tonum(obj){
					 return parseInt(obj);
   				 }
				function getvalue1(){
					lastobj = tonum(document.dataarea.timer1.value);
					return lastobj;
				}
				function getvalue11(){
					lastobj1 = tonum(document.dataarea.timer.value);
					return lastobj1;
				}
				function getvaluecmd(){
					lastobjcmd = tonum(document.dataarea.cmdlog1.value);
					return lastobjcmd;
				}
				function getvaluecmd1(){
					lastobjcmd1 = tonum(document.dataarea.cmdlog.value);
					return lastobjcmd1;
				}
				
				function incr1(x , y){
					if( _enabled == true)
					{
						curobj=getvalue1();
						curobj1=getvalue11();
						curobj = curobj + x;
						if ( y &gt;= curobj ){
							document.dataarea.timer1.value = curobj;
						}
						else{
							document.dataarea.timer1.value = y;	
						}
						curobj1 = curobj1 + x;
						if ( y &gt;= curobj1 ){
							document.dataarea.timer.value = curobj1;
						}
						else{
							document.dataarea.timer.value = y;	
						}
						chgFlag();

					}
				}

				function incrcmd(x , y){
					curobjcmd=getvaluecmd();
					curobjcmd1=getvaluecmd1();
					curobjcmd = curobjcmd + x;
					if ( y &gt;= curobjcmd ){
						document.dataarea.cmdlog1.value = curobjcmd;
					}
					else{
						document.dataarea.cmdlog1.value = y;	
					}
					curobjcmd1 = curobjcmd1 + x;
					if ( y &gt;= curobjcmd1 ){
						document.dataarea.cmdlog.value = curobjcmd1;
					}
					else{
						document.dataarea.cmdlog.value = y;	
					}
					return ;	
				}
				
				function decr1(a , b)	{
					if( _enabled == true)
					{
						curobj=getvalue1();
						curobj1=getvalue11();
	
						curobj = curobj - a;
						if ( b &lt;= curobj ){
							document.dataarea.timer1.value = curobj;
						}
						else{
							document.dataarea.timer1.value = b;
						}	
						
						curobj1 = curobj1 - a;
						if ( b &lt;= curobj1 ){
							document.dataarea.timer.value = curobj1;
						}
						else{
							document.dataarea.timer.value = b;
						}
						chgFlag();
					}
				}

				function decrcmd(a , b)	{
					curobjcmd=getvaluecmd();
					curobjcmd1=getvaluecmd1();
					
					curobjcmd = curobjcmd - a;
					if ( b &lt;= curobjcmd ){
						document.dataarea.cmdlog1.value = curobjcmd;
					}
					else{
						document.dataarea.cmdlog1.value = b;
					}	
					
					curobjcmd1 = curobjcmd1 - a;
					if ( b &lt;= curobjcmd1 ){
						document.dataarea.cmdlog.value = curobjcmd1;
					}
					else{
						document.dataarea.cmdlog.value = b;
					}
					return ;
				}
				
			</script>
		</DataArea>
	</xsl:template>
	
	<xsl:template name="script11">javascript:incr1(3,30)</xsl:template>
	<xsl:template name="script12">javascript:decr1(3,3)</xsl:template>
	
	<xsl:template name="scriptcmd11">
		<xsl:param name="max"/>
		<xsl:param name="incr"/>
		javascript:incrcmd(<xsl:value-of select="$incr"/>,<xsl:value-of select="$max"/>)
	</xsl:template>
	<xsl:template name="scriptcmd12">
		<xsl:param name="min"/>
		<xsl:param name="incr"/>
		javascript:decrcmd(<xsl:value-of select="$incr"/>,<xsl:value-of select="$min"/>)
	</xsl:template>
	<xsl:template match="*"/>	
</xsl:stylesheet>
