<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/OMA">
		<DataArea validate="true" onLoad="true" exportdata="false">
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strApply"/></xsl:attribute>
			<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.oma.webplugins.SetAccessconfgWebPlugin</xsl:attribute>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strNodeConfiguration"/></xsl:attribute>
			</PageTitle>

			<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.oma.webplugins.AccessconfgWebPlugin&amp;help=access</xsl:attribute>
				</Data>
			</CustomButton>					
			<ListData name="userAccess" type="custom">
			<xsl:attribute name="display"><xsl:value-of select="$strUserAccess"/></xsl:attribute>
				<Header>
					<Data name="">
						<xsl:attribute name="display"><xsl:value-of select="$strUserAccess"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strUserAccess1"/></xsl:attribute>
					</Data>
				</Header>
					<Data>
						<xsl:attribute name="name">accesspwrusrmask</xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strPowerUserAccess"/></xsl:attribute>
						<xsl:attribute name="event">onClick</xsl:attribute>
						<xsl:attribute name="handler">javascript:unCheck('pwrusr')</xsl:attribute>					
						<xsl:attribute name="type">checkbox</xsl:attribute>
						<xsl:attribute name="returnvalue">pwrusr</xsl:attribute>
						<xsl:attribute name="state">
							<xsl:if test="Access='3'">1</xsl:if>
							<xsl:if test="Access='2'">1</xsl:if>
						</xsl:attribute>
					</Data>
					
					<Data>
						<xsl:attribute name="name">accessusrmask</xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strUserAccessGranted"/></xsl:attribute>
						<xsl:attribute name="event">onClick</xsl:attribute>
						<xsl:attribute name="handler">javascript:unCheck('usr')</xsl:attribute>					
						<xsl:attribute name="type">checkbox</xsl:attribute>
						<xsl:attribute name="returnvalue">usr</xsl:attribute>
						<xsl:attribute name="state">
							<xsl:if test="Access='3'">1</xsl:if>
						</xsl:attribute>
					</Data>
					<Data>
					<xsl:attribute name="name">usermsk_modified</xsl:attribute>
					<xsl:attribute name="type">hidden</xsl:attribute>
					<xsl:attribute name="returnvalue">false</xsl:attribute>
					</Data>
			</ListData>
			<xsl:choose>
				<xsl:when test="CmdLog/DisableConfig='1'"></xsl:when>
				<xsl:otherwise>
			<TableData name="cmdLog">
			<xsl:attribute name="display"><xsl:value-of select="$strCommandLog"/></xsl:attribute>
				<Header>
					<Data name="">
						<xsl:attribute name="display"><xsl:value-of select="$strCommandLog"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strCommandLog"/></xsl:attribute>
					</Data>
					<Data  display=" "  type="hidden" state="" align="left">
						<xsl:attribute name="name">cmdlogH1</xsl:attribute>
					</Data>
					<Data  display=" "  type="hidden" state="" align="left">
						<xsl:attribute name="name">cmdlogH2</xsl:attribute>
					</Data>
					<Data  display=" "  type="hidden" state="" align="left">
						<xsl:attribute name="name">cmdlogH3</xsl:attribute>
					</Data>
					<Data></Data>
				</Header>
				
				<Row>
								
								<Data>
									<xsl:attribute name="display"><xsl:value-of select="$strCommandLogSize"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="$strCommandLogSize"/></xsl:attribute>
								</Data>
								
								<Data type="spincontrol" size="5">
									<xsl:attribute name="noborderright">true</xsl:attribute>
									<xsl:attribute name="name">cmdlog1</xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="CmdLog/CurMaxLogSizeMB"/></xsl:attribute>
									<xsl:attribute name="state">3</xsl:attribute>
									<xsl:attribute name="uparrscript">
										<xsl:call-template name="scriptcmd11">
											<xsl:with-param name="max"><xsl:value-of select="CmdLog/MaxLogSizeMB"/></xsl:with-param>
											<xsl:with-param name="incr"><xsl:value-of select="CmdLog/CurMaxLogSizeMB/@increment"/></xsl:with-param>
										</xsl:call-template>
									</xsl:attribute>
									<xsl:attribute name="downarrscript">
										<xsl:call-template name="scriptcmd12">
											<xsl:with-param name="min"><xsl:value-of select="CmdLog/MinLogSizeMB"/></xsl:with-param>
											<xsl:with-param name="incr"><xsl:value-of select="CmdLog/CurMaxLogSizeMB/@increment"/></xsl:with-param>
										</xsl:call-template>
									</xsl:attribute>
								</Data>
								
								<Data  display=" "  type="hidden" state="" align="left">
									<xsl:attribute name="name">cmdlog</xsl:attribute>
									<xsl:attribute name="returnvalue"><xsl:value-of select="CmdLog/CurMaxLogSizeMB"/></xsl:attribute>
								</Data>
								<Data>
								<xsl:attribute name="name">cmdlog_modified</xsl:attribute>
								<xsl:attribute name="type">hidden</xsl:attribute>
								<xsl:attribute name="returnvalue">false</xsl:attribute>
								</Data>
								
				</Row>
			</TableData>
			
			</xsl:otherwise>
			</xsl:choose>
			
				<xsl:if test="/OMA/OMA/MsgPrefFormat">				
			<ListData name="messageformat" type="custom">
			<xsl:attribute name="display"><xsl:value-of select="$strMsgFrmtSelection"/></xsl:attribute>
				<Header>
					<Data name="">
						<xsl:attribute name="display"><xsl:value-of select="$strMsgFrmtSelection"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strMsgFrmtSelection"/></xsl:attribute>
					</Data>
				</Header>
						<PromptText>
						    <xsl:value-of select="$strPromptMessage"/>
						</PromptText>
					<Data>
						<xsl:attribute name="name">Enhanced</xsl:attribute>
						<xsl:attribute name="id">Enhanced</xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strEnhancedMsgFormat"/></xsl:attribute>
						<xsl:attribute name="event">onClick</xsl:attribute>	
						<xsl:attribute name="handler">javascript:MsgFormat(this)</xsl:attribute>											
						<xsl:attribute name="type">radio</xsl:attribute>
						<xsl:attribute name="returnvalue">1</xsl:attribute>
						<xsl:attribute name="state">
							<xsl:if test="/OMA/OMA/MsgPrefFormat='1'">1</xsl:if>							
						</xsl:attribute>
					</Data>
					
					<Data>
						<xsl:attribute name="name">Legacy</xsl:attribute>
						<xsl:attribute name="id">Legacy</xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strLegacyMsgFormat"/></xsl:attribute>
						<xsl:attribute name="event">onClick</xsl:attribute>						
						<xsl:attribute name="type">radio</xsl:attribute>
						<xsl:attribute name="handler">javascript:MsgFormat(this)</xsl:attribute>					
						<xsl:attribute name="returnvalue">0</xsl:attribute>
						<xsl:attribute name="state">
							<xsl:if test="/OMA/OMA/MsgPrefFormat='0'">1</xsl:if>
						</xsl:attribute>
					</Data>	
                    <Data>
								<xsl:attribute name="name">msgformat_modified</xsl:attribute>
								<xsl:attribute name="type">hidden</xsl:attribute>
								<xsl:attribute name="returnvalue">false</xsl:attribute>
					</Data>					
				
			</ListData>
			</xsl:if>			

			<script language="javascript">
				var lastobjcmd;
				var curobjcmd;
				var lastobjcmd1;
				var curobjcmd1;
				var accessModified = false;
				var cmdModified = false;
				var msgmodified = false;
				var msgFormat = '<xsl:value-of select="/OMA/OMA/MsgPrefFormat"/>';
				
				function initializationRoutine()
				{	
					if(msgFormat=='1')
					     document.getElementById("Enhanced").checked = true;
					
					else if(msgFormat=='0')
					     document.getElementById("Legacy").checked = true;				
			
				}
				function MsgFormat(element)
				{
					if(element.value=='1')
					{
						document.getElementById("Enhanced").checked = true;					
						document.getElementById("Legacy").checked = false;
					}						
					if(element.value=='0')
					{
						document.getElementById("Legacy").checked = true;					
						document.getElementById("Enhanced").checked = false;					
					}
					if( false == msgmodified )
						msgmodified = true;
					
					
				}

				
				function unCheck (userName) {
					if (userName == 'pwrusr') {
						if(document.getElementById("dataarea").accesspwrusrmask.checked == false)
						{
							document.getElementById("dataarea").accessusrmask.checked = false;
						}
					}
					else if (userName == 'usr') {
						if(document.getElementById("dataarea").accessusrmask.checked == true)
						{
							document.getElementById("dataarea").accesspwrusrmask.checked = true;
						}
					}
					if( false == accessModified )
						accessModified = true;
				}
				
				


				function tonum(obj){
					 return parseInt(obj);
   				 }

				function getvaluecmd(){
					lastobjcmd = tonum(document.dataarea.cmdlog1.value);
					return lastobjcmd;
				}
				function getvaluecmd1(){
					lastobjcmd1 = tonum(document.dataarea.cmdlog.value);
					return lastobjcmd1;
				}
				
				
				function incrcmd(x , y){
					curobjcmd=getvaluecmd();
					curobjcmd1=getvaluecmd1();
					curobjcmd = curobjcmd + x;
					if ( y &gt;= curobjcmd ){
						document.dataarea.cmdlog1.value = curobjcmd;
					}
					else{
						document.dataarea.cmdlog1.value = y;	
					}
					curobjcmd1 = curobjcmd1 + x;
					if ( y &gt;= curobjcmd1 ){
						document.dataarea.cmdlog.value = curobjcmd1;
					}
					else{
						document.dataarea.cmdlog.value = y;	
					}
					if( false == cmdModified )
						cmdModified = true;
					return ;	
				}

				function decrcmd(a , b)	{
					curobjcmd=getvaluecmd();
					curobjcmd1=getvaluecmd1();
					
					curobjcmd = curobjcmd - a;
					if ( b &lt;= curobjcmd ){
						document.dataarea.cmdlog1.value = curobjcmd;
					}
					else{
						document.dataarea.cmdlog1.value = b;
					}	
					
					curobjcmd1 = curobjcmd1 - a;
					if ( b &lt;= curobjcmd1 ){
						document.dataarea.cmdlog.value = curobjcmd1;
					}
					else{
						document.dataarea.cmdlog.value = b;
					}
					if( false == cmdModified )
						cmdModified = true;

					return ;			
				}
				
				function validate()
				{
					document.getElementById("usermsk_modified").value = accessModified;
					if( document.getElementById("cmdlog_modified"))
					{
					document.getElementById("cmdlog_modified").value = cmdModified;
					}
					
					if(document.getElementById("msgformat_modified"))
					{
					document.getElementById("msgformat_modified").value = msgmodified;
					} 
					return true;
				}
				
			</script>
		</DataArea>
		</xsl:template>
		<xsl:template name="scriptcmd11">
			<xsl:param name="max"/>
			<xsl:param name="incr"/>
			javascript:incrcmd(<xsl:value-of select="$incr"/>,<xsl:value-of select="$max"/>)
		</xsl:template>
		<xsl:template name="scriptcmd12">
			<xsl:param name="min"/>
			<xsl:param name="incr"/>
			javascript:decrcmd(<xsl:value-of select="$incr"/>,<xsl:value-of select="$min"/>)
		</xsl:template>

	<xsl:template match="*"/>
</xsl:stylesheet>
