<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" indent="no"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA">
		<xsl:call-template name="CLIMSG">
			<xsl:with-param name="id"><xsl:value-of select="CLIMsgID"/></xsl:with-param>
			<xsl:with-param name="cliname"><xsl:value-of select="CLIName"/></xsl:with-param>
			<xsl:with-param name="clicmdname"><xsl:value-of select="CLICMDName"/></xsl:with-param>
			<xsl:with-param name="clisubcmdname"><xsl:value-of select="CLISubCmdName"/></xsl:with-param>
			<xsl:with-param name="filename"><xsl:value-of select="FileName"/></xsl:with-param>
			<xsl:with-param name="outputformat"><xsl:value-of select="OutputFormat"/></xsl:with-param>
			<xsl:with-param name="invalidoption"><xsl:value-of select="InvalidOption"/></xsl:with-param>
			<xsl:with-param name="invalidini"><xsl:value-of select="InvalidINI"/></xsl:with-param>
			<xsl:with-param name="invalidprog"><xsl:value-of select="InvalidProg"/></xsl:with-param>
			<xsl:with-param name="invalidcmd"><xsl:value-of select="InvalidCMD"/></xsl:with-param>
			<xsl:with-param name="invalidnvpair"><xsl:value-of select="InvalidNVPair"/></xsl:with-param>
			<xsl:with-param name="progname"><xsl:value-of select="ProgName"/></xsl:with-param>
			<xsl:with-param name="status"><xsl:value-of select="Status"/></xsl:with-param>
		</xsl:call-template>
	</xsl:template>	
	<xsl:template name="CLIMSG">
		<xsl:param name="id"/>
		<xsl:param name="cliname"/>
		<xsl:param name="clicmdname"/>
		<xsl:param name="clisubcmdname"/>
		<xsl:param name="filename"/>
		<xsl:param name="outputformat"/>
		<xsl:param name="invalidoption"/>
		<xsl:param name="invalidini"/>
		<xsl:param name="invalidprog"/>
		<xsl:param name="invalidcmd"/>
		<xsl:param name="invalidnvpair"/>
		<xsl:param name="progname"/>
		<xsl:param name="clipname"/>
		<xsl:param name="status"/>
		<xsl:choose>
			<xsl:when test="$id = '1'">
				<xsl:if test="$cliname != 'omdiag'">
				<!--XLATETHIS-->Usage: <xsl:value-of select="$cliname"/> &lt;command...&gt;  [name=value...] ... [option...]<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Valid command line options are:<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->-?               Print available commands.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->-outc &lt;file&gt;     Redirect output to file, delete old if exists.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->  OR<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->-outa &lt;file&gt;     Redirect output to file, append to old if exists.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->  OR<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Output may also be redirected using Operating System facilities (e.g. |more).<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				</xsl:if>
				<xsl:if test="$cliname = 'omdiag'">
				<!--XLATETHIS-->NOTE: The Online Diagnostic tool is not a part of the Dell OpenManage Server Administrator anymore. Install and run the stand-alone Dell PowerEdge Diagnostics tool, which is available on  the Dell PowerEdge Service and Diagnostic Utilities CD and also at support.dell.com.<!--XLATETHIS-->
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = '2'">
				<xsl:if test="$cliname != 'omdiag'">
				<!--XLATETHIS-->The available command(s) are:<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Command          Description<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				</xsl:if>
			</xsl:when> 
			<xsl:when test="$id = '3'">
				<!--XLATETHIS-->The available command(s) are:<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Command          Description<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '4'">
				<!--XLATETHIS-->Error! Redirect output path and filename not specified.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '5'">
				<!--XLATETHIS-->Error! Could not write to file: <xsl:value-of select="$filename"/><!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '6'">
				<!--XLATETHIS-->Error! Format for output results not specified.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '7'">
				<!--XLATETHIS-->Error! Invalid format for output results specified: <xsl:value-of select="$outputformat"/><!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '8'">
				<!--XLATETHIS-->Error! Invalid option specified: <xsl:value-of select="$invalidoption"/><!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '9'">
				<!--XLATETHIS-->Error! Options should be specified at the end.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '10'">
				<!--XLATETHIS-->Error! Invalid INI file: <xsl:value-of select="$invalidini"/><!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '11'">
				<!--XLATETHIS-->Error! No command(s) specified.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			
			<xsl:when test="$id = '12'">
				<!--XLATETHIS-->Error! Invalid command: <xsl:value-of select="$invalidprog"/><!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>

			<xsl:when test="$id = '13'">
<!--XLATETHIS-->Error! Invalid command: <xsl:value-of select="$invalidcmd"/><!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>			
			<xsl:when test="$id = '14'">
				<!--XLATETHIS-->Error! User has insufficient privileges to run command.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '15'">
				<!--XLATETHIS-->Error! Command: <xsl:value-of select="$progname"/> could not obtain user name.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '16'">
				<!--XLATETHIS-->Error! CLIP (<xsl:value-of select="$clipname"/>) load failed.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '17'">
				<!--XLATETHIS-->Error! CLIP (<xsl:value-of select="$clipname"/>) send request failed.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '18'">
				<!--XLATETHIS-->Error! CLIP send request failed, status: <xsl:value-of select="$status"/><!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '19'"><!--XLATETHIS-->Error! Invalid XML data type.<!--XLATETHIS--></xsl:when>
			<xsl:when test="$id = '20'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command"><xsl:value-of select="$cliname"/></xsl:with-param>
					<xsl:with-param name="length">16</xsl:with-param>
				</xsl:call-template>
				<xsl:value-of select="$clisubcmdname"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '21'">
				<!--XLATETHIS-->For further help, type the command followed by -?<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '22'">
				<xsl:if test="$clicmdname != 'omdiag'">
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="ProgDesc">
					<xsl:with-param name="cliname"><xsl:value-of select="$clicmdname"/></xsl:with-param>
				</xsl:call-template>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = '23'">
				<xsl:if test="$clicmdname != 'omupdate'">
					<xsl:call-template name="ProgDesc">
						<xsl:with-param name="cliname"><xsl:value-of select="$clicmdname"/></xsl:with-param>
					</xsl:call-template>
					<xsl:call-template name="NewLine"/>
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = '24'">
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->For further help, type the command followed by -?, or type:<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/><xsl:value-of select="$cliname"/> &lt;command&gt; [option...]
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Valid command line options are:<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>				
				<!--XLATETHIS-->-outc &lt;file&gt;     Redirect output to file, delete old if exists.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->  OR<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->-outa &lt;file&gt;     Redirect output to file, append to old if exists.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->  OR<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Output may also be redirected using Operating System facilities (e.g. |more).<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '25'">
				<xsl:if test="$cliname != 'omdiag'">
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Usage: <xsl:value-of select="$cliname"/> &lt;command...&gt; [name=value...] ... [option...]<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Valid command line options are:<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->-?               Print available command(s) or command help.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<xsl:choose>
                    	<xsl:when test="$cliname='omconfig'">
						<!--XLATETHIS-->-fmt &lt;lst|xml&gt;   Format for output results, default is lst.<!--XLATETHIS-->
						<xsl:call-template name="NewLine"/>
						<!--XLATETHIS-->                     Where: lst  List format.<!--XLATETHIS-->
						<xsl:call-template name="NewLine"/>
						<!--XLATETHIS-->                            xml  Raw XML format.<!--XLATETHIS-->
					</xsl:when>
					<xsl:otherwise>
						<!--XLATETHIS-->-fmt &lt;lst|tbl|ssv|cdv|xml&gt; Format for output results, default is lst.<!--XLATETHIS-->
						<xsl:call-template name="NewLine"/>
						<!--XLATETHIS-->                           Where: lst  List format.<!--XLATETHIS-->
						<xsl:call-template name="NewLine"/>
						<!--XLATETHIS-->                                  tbl  Table format.<!--XLATETHIS-->
						<xsl:call-template name="NewLine"/>
						<!--XLATETHIS-->                                  ssv  Semicolon separated format.<!--XLATETHIS-->
						<xsl:call-template name="NewLine"/>
						<!--XLATETHIS-->                                  cdv  Custom delimiter separated format.<!--XLATETHIS-->
						<xsl:call-template name="NewLine"/>
						<!--XLATETHIS-->                                  xml  Raw XML format.<!--XLATETHIS-->
					</xsl:otherwise>
                	</xsl:choose>
				<xsl:call-template name="NewLine"/>				<!--XLATETHIS-->-outc &lt;file&gt;     Redirect output to file, delete old if exists.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->  OR<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->-outa &lt;file&gt;     Redirect output to file, append to old if exists.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->  OR<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<!--XLATETHIS-->Output may also be redirected using Operating System facilities (e.g. |more).<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = '26'">
				<!--XLATETHIS-->Error! Use either -outa &lt;file&gt; OR -outc &lt;file&gt;.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '27'">
				<!--XLATETHIS-->Error! Format for output results not available.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '28'">
				<!--XLATETHIS-->Error! Invalid name=value pair: <xsl:value-of select="$invalidnvpair"/><!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '29'">
				<!--XLATETHIS-->Error! Unrecognized parameter: <xsl:value-of select="$invalidnvpair"/><!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '30'">
				<!--XLATETHIS-->Error! Parameters must be shorter than 256 characters.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '31'">
				<!--XLATETHIS-->Error! User name not specified.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '32'">
				<!--XLATETHIS-->Error! Domain name not specified.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '33'">
				<!--XLATETHIS-->Error! Password not specified.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '34'">
				<!--XLATETHIS-->Error! More than one user name specified.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '35'">
				<!--XLATETHIS-->Error! More than one domain name specified.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '36'">
				<!--XLATETHIS-->Error! More than one password specified.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '37'">
				<!--XLATETHIS-->Error! Duplicate name=value pair: <xsl:value-of select="$invalidnvpair"/><!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '38'"><!--XLATETHIS-->This omupdate command is no longer supported. Use the Dell Server Update Utility or the Dell Update Packages to carry out your system software updates. The Dell Server Update Utility and Dell Update Packages can be downloaded from http://support.dell.com.<!--XLATETHIS-->
         <xsl:call-template name="NewLine"/>
       </xsl:when>
      <xsl:when test="$id = '39'">
        <xsl:call-template name="NewLine"/>
      </xsl:when>
      <xsl:when test="$id = '40'">
        <!--XLATETHIS-->Error! Hardware or Feature Not Present.<!--XLATETHIS-->
        <xsl:call-template name="NewLine"/>
      </xsl:when>


      <xsl:when test="$id = '0'">
				<!--XLATETHIS-->Invalid message ID generated.<!--XLATETHIS-->
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="ProgDesc">
		<xsl:param name="cliname"/>
		<xsl:choose>
			<xsl:when test="$cliname = 'omconfig'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">omconfig</xsl:with-param>
					<xsl:with-param name="length">16</xsl:with-param>
				</xsl:call-template>
				<!--XLATETHIS-->Configures component properties.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$cliname = 'omhelp'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">omhelp</xsl:with-param>
					<xsl:with-param name="length">16</xsl:with-param>
				</xsl:call-template>
				<!--XLATETHIS-->Provides help information for commands.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$cliname = 'omreport'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">omreport</xsl:with-param>
					<xsl:with-param name="length">16</xsl:with-param>
				</xsl:call-template>
				<!--XLATETHIS-->Reports component properties.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$cliname = 'omupdate'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">omupdate</xsl:with-param>
					<xsl:with-param name="length">16</xsl:with-param>
				</xsl:call-template>
				<!--XLATETHIS-->Updates BIOS, Firmware and Drivers.<!--XLATETHIS-->
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="CLISubCommand">
		<xsl:param name="command"/>
		<xsl:param name="length"/>
		<xsl:value-of select="$command"/>
		<xsl:call-template name="Spaces">
			<xsl:with-param name="num"><xsl:value-of select="($length) - string-length($command)"/></xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="Spaces">
		<xsl:param name="num"/>
		<xsl:text> </xsl:text>
		<xsl:if test="$num &gt; '0'">
			<xsl:call-template name="Spaces">
				<xsl:with-param name="num">
					<xsl:value-of select="($num) - 1"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template name="NewLine">
		<xsl:text>  
</xsl:text>
	</xsl:template>
</xsl:stylesheet>
