<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml" indent="no"/>
	<xsl:strip-space elements="*"/>
	
	<xsl:template match="*">
	<xsl:choose>
		<xsl:when test="/OMA/SMStatus='0'"><xsl:call-template name="success"/></xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="failure">
				<xsl:with-param name="ErrorMsgID"><xsl:value-of select="SMStatus"/></xsl:with-param>
			</xsl:call-template>		
		</xsl:otherwise>
	</xsl:choose>
	</xsl:template>

	<xsl:template name="failure">
		<xsl:param name="ErrorMsgID" />
		<DataArea>			
			<xsl:choose>
				<xsl:when test="$ErrorMsgID='261'"><xsl:text>Error! Configuration file is missing.</xsl:text></xsl:when>
				<xsl:when test="$ErrorMsgID='263'"><xsl:text>Error! Configuration key is missing.</xsl:text></xsl:when>
				<xsl:when test="$ErrorMsgID='271'"><xsl:text>Error! Value incorrect.</xsl:text></xsl:when>
				<xsl:otherwise><xsl:text>Error occured!</xsl:text></xsl:otherwise>
			</xsl:choose>	
		</DataArea>	
	</xsl:template>

	
	<xsl:template name="success">
	<DataArea>			
			<ListData>
				<xsl:choose>
				<xsl:when test="/OMA/OMA/MsgPrefFormat='1'">
				<Data>
					<xsl:attribute name="display">Event Message Format</xsl:attribute>	
					<xsl:attribute name="value">Enhanced</xsl:attribute>			
				</Data>	
				</xsl:when>
				<xsl:when test="/OMA/OMA/MsgPrefFormat='0'">
				<Data>
					<xsl:attribute name="display">Event Message Format</xsl:attribute>		
					<xsl:attribute name="value">traditional</xsl:attribute>			
				</Data>	
				</xsl:when>				
				</xsl:choose>
				
			</ListData>
		</DataArea>
	</xsl:template>
</xsl:stylesheet>
