<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="/OMA">
		<DataArea>
			<PageTitle display="System Update Progress"/>
			<TableData>
				<Header>
					<Data value="Update ID" display="Update ID" name="UpdateID"/>
					<Data value="State" display="State" name="State"/>
					<Data value="Progress" display="Progress" name="Progress"/>
				</Header>
				<xsl:apply-templates  />
			</TableData>
		</DataArea>
	</xsl:template>
	<xsl:template match="BundleLog">
		<Row>
			<Data name="UpdateID">
				<xsl:choose>
					<xsl:when test="@update-id">
						<xsl:attribute name="value"><xsl:value-of select="@update-id" /></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="@update-id" /></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value">None</xsl:attribute>
						<xsl:attribute name="display">None</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data> 
			<Data name="State">
				<xsl:choose>
					<xsl:when test="Progress">
						<xsl:attribute name="value">in progress</xsl:attribute>
						<xsl:attribute name="display">in progress</xsl:attribute>
					</xsl:when>
					<xsl:when test="SMStatus/@result != '0'">
						<xsl:attribute name="value"><xsl:value-of select="SMStatus" /></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="SMStatus" /></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value">complete</xsl:attribute>
						<xsl:attribute name="display">complete</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data> 
			<xsl:if test="Progress">
				<Data name="Progress">
					<xsl:attribute name="value"><xsl:value-of select="Progress/@value" />%</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="Progress/@value" />%</xsl:attribute>
				</Data>
			</xsl:if>
		</Row>
	</xsl:template>
</xsl:stylesheet>
