<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" />
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<xsl:choose>
			<xsl:when test="SMStatus != '0'">
				<DataArea>
					<PageTitle>
						<xsl:attribute name="display"><!--XLATESTART-->&#38169;&#35823;&#65281; <!--XLATESTOP--><xsl:call-template name="smstatus"><xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</PageTitle>
				</DataArea>
			</xsl:when>
			<xsl:otherwise>
				<DataArea>
					<PageTitle>
						<xsl:attribute name="display"><!--XLATESTART-->&#26426;&#31665;&#20449;&#24687;<!--XLATESTOP--></xsl:attribute>
					</PageTitle>
					<ListData>
						<Data>
							<xsl:attribute name="display"><!--XLATESTART-->&#32034;&#24341;<!--XLATESTOP--></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Chassis/@index"/></xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="display"><!--XLATESTART-->&#26426;&#31665;&#21517;&#31216;<!--XLATESTOP--></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="Chassis/@display"/></xsl:attribute>
						</Data>
						<xsl:apply-templates select="ChassisInfo"/>
					</ListData>
				</DataArea>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="ChassisInfo">
		<xsl:if test="SystemInfo/SystemName">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->&#20027;&#26426;&#21517;<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="SystemInfo/SystemName"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="FirmwareList">
			<xsl:for-each select="FirmwareList/Firmware">
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="FWText"/><!--XLATESTART--> &#29256;&#26412;<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="FWVersion"/></xsl:attribute>
				</Data>
			</xsl:for-each>			
		</xsl:if>
		<xsl:if test="ChassisProps1/ChassModel">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->&#26426;&#31665;&#22411;&#21495;<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="ChassisProps1/ChassModel"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="ChassisProps1/ChassLockPresent">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->&#24213;&#24231;&#38145;<!--XLATESTOP--></xsl:attribute>
				<xsl:choose>
					<xsl:when test="ChassisProps1/ChassLockPresent = 'true'">
						<xsl:attribute name="value"><!--XLATESTART-->&#23384;&#22312;<!--XLATESTOP--></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><!--XLATESTART-->&#19981;&#23384;&#22312;<!--XLATESTOP--></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
		</xsl:if>
		<xsl:if test="ChassisProps2/ServiceTag">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->&#26381;&#21153;&#26631;&#31614;<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="ChassisProps2/ServiceTag"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="ChassisProps2/AssetTag">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->&#36164;&#20135;&#26631;&#31614;<!--XLATESTOP--></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="ChassisProps2/AssetTag"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="ChassisProps2/FaultLEDControl != '0'">
			<Data>
				<xsl:attribute name="display"><!--XLATESTART-->&#25925;&#38556; LED &#22312;&#20005;&#37325;&#24615;&#32423;&#21035;&#19978;&#38378;&#28865;<!--XLATESTOP--></xsl:attribute>
				<xsl:choose>
					<xsl:when test="ChassisProps2/FaultLEDControl = '8'">
						<xsl:attribute name="value"><!--XLATESTART-->&#35686;&#21578;<!--XLATESTOP--></xsl:attribute>
					</xsl:when>
					<xsl:when test="ChassisProps2/FaultLEDControl = '16'">
						<xsl:attribute name="value"><!--XLATESTART-->&#20005;&#37325;<!--XLATESTOP--></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><!--XLATESTART-->&#26410;&#23450;&#20041;<!--XLATESTOP--></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
		</xsl:if>
		<xsl:if test="BaseBoardList/@count > '0'">
			<xsl:call-template name="BaseBoard"/>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="BaseBoard">
		<xsl:for-each select="/OMA/BaseBoardList/BaseBoard">
			<xsl:if test="FeatureFlags/HostingBoard='true'">
				<Data name="BladeServiceTag" type="ustring">
					<xsl:attribute name="display"><!--XLATESTART-->Blade &#26381;&#21153;&#26631;&#31614;<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
				</Data>
				<Data name="BladeServiceTag" type="ustring">
					<xsl:attribute name="display"><!--XLATESTART-->Blade &#36164;&#20135;&#26631;&#31614;<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="AssetTag"/></xsl:attribute>
				</Data>
				<Data name="BladeLocation" type="ustring">
					<xsl:attribute name="display"><!--XLATESTART-->Blade &#20301;&#32622;<!--XLATESTOP--></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="BoardLocation"/></xsl:attribute>
				</Data>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:param name="mssg"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><!--XLATESTART-->&#21629;&#20196;&#26410;&#25104;&#21151;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '0'"><!--XLATESTART-->&#21629;&#20196;&#24050;&#25104;&#21151;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '1'"><!--XLATESTART-->&#21629;&#20196;&#26410;&#25191;&#34892;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '2'"><!--XLATESTART-->&#21629;&#20196;&#38169;&#35823;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '3'"><!--XLATESTART-->&#21629;&#20196;&#36229;&#26102;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '4'"><!--XLATESTART-->&#21629;&#20196;&#24050;&#21462;&#28040;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '5'"><!--XLATESTART-->&#21629;&#20196;&#24050;&#32456;&#27490;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '6'"><!--XLATESTART-->&#21629;&#20196;&#25346;&#36215;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '7'"><!--XLATESTART-->&#27809;&#26377;&#27492;&#31867;&#35774;&#22791;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '8'"><!--XLATESTART-->&#35774;&#22791;&#27491;&#24537;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '9'"><!--XLATESTART-->&#35774;&#22791;&#25925;&#38556;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '10'"><!--XLATESTART-->&#20551;&#20013;&#26029;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '11'"><!--XLATESTART-->&#36164;&#28304;&#38145;&#23450;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '12'"><!--XLATESTART-->&#32034;&#24341;&#26080;&#25928;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '13'"><!--XLATESTART-->SMB &#38169;&#35823;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '14'"><!--XLATESTART-->&#25152;&#35831;&#27714;&#30340;&#25968;&#25454;&#19981;&#21487;&#29992;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '15'"><!--XLATESTART-->&#25152;&#35831;&#27714;&#30340;&#25968;&#25454;&#22810;&#20110;&#21487;&#29992;&#25968;&#25454;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '16'"><!--XLATESTART-->&#25152;&#35831;&#27714;&#30340;&#25968;&#25454;&#23569;&#20110;&#21487;&#29992;&#25968;&#25454;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '17'"><!--XLATESTART-->&#35774;&#22791;&#23578;&#26410;&#20934;&#22791;&#22909;&#65292;&#26080;&#27861;&#25509;&#21463;&#21629;&#20196;&#12290; &#35831;&#31245;&#21518;&#37325;&#35797;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '18'"><!--XLATESTART-->&#35774;&#22791;&#19978;&#27809;&#26377;&#25968;&#25454;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '19'"><!--XLATESTART-->&#35774;&#22791;&#19978;&#20869;&#23384;&#19981;&#36275;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '20'"><!--XLATESTART-->&#35774;&#22791;&#24050;&#23384;&#22312;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '256'"><!--XLATESTART-->&#26410;&#25214;&#21040;&#23545;&#35937;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '257'"><!--XLATESTART-->&#23545;&#35937;&#21464;&#24418;&#12289;&#25439;&#22351;&#25110;&#26159;&#22351;&#30340;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '258'"><!--XLATESTART-->&#23545;&#35937;&#24050;&#23384;&#22312;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '260'"><!--XLATESTART-->&#26410;&#25214;&#21040; INI &#25991;&#20214;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '261'"><!--XLATESTART-->INI &#21464;&#24418;&#12289;&#25439;&#22351;&#25110;&#26159;&#22351;&#30340;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '262'"><!--XLATESTART-->INI &#37096;&#20998;&#19981;&#23384;&#22312;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '263'"><!--XLATESTART-->INI &#38190;&#19981;&#23384;&#22312;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '264'"><!--XLATESTART-->INI &#20540;&#21464;&#24418;&#12289;&#25439;&#22351;&#25110;&#26159;&#22351;&#30340;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '270'"><!--XLATESTART-->&#35775;&#38382;&#26435;&#38480;&#19981;&#36275;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '271'"><!--XLATESTART-->&#21442;&#25968;&#21517;&#31216;&#25110;&#20540;&#26080;&#25928;&#65306; <!--XLATESTOP--><xsl:value-of select="$mssg"/></xsl:when>
			<xsl:when test="$status = '272'"><!--XLATESTART-->&#20869;&#23384;&#19981;&#22815;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '280'"><!--XLATESTART-->&#26410;&#25214;&#21040; XML &#25991;&#20214;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '281'"><!--XLATESTART-->XML &#21464;&#24418;&#12289;&#25439;&#22351;&#25110;&#26159;&#22351;&#30340;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '282'"><!--XLATESTART-->XML &#33410;&#28857;&#19981;&#23384;&#22312;<!--XLATESTOP--></xsl:when>
			<xsl:when test="$status = '283'"><!--XLATESTART-->XML &#20540;&#21464;&#24418;&#12289;&#25439;&#22351;&#25110;&#26159;&#22351;&#30340;<!--XLATESTOP--></xsl:when>
		<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>