<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/DataArea">
		<xsl:copy>
			<xsl:apply-templates select="@* | script | Header | PageTitle | PromptText | CustomButton"/>
			<TableData columnspacing='true' nouniqueids='true' sortable="true">
				<Header>
					<Data align="center" name="Severity" width="80" link="true" href="./DataArea?plugin=com.dell.hip.webplugins.ESMLogWebPlugin&amp;sortkey=severity&amp;order=ascending"><xsl:attribute name="topsorted">true</xsl:attribute><xsl:attribute name="value"><xsl:value-of select="$strSeverity"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$strSeverity1"/></xsl:attribute></Data>
					<Data name="DateTime" width="120" link="true" href="./DataArea?plugin=com.dell.hip.webplugins.ESMLogWebPlugin"><xsl:attribute name="value"><xsl:value-of select="$strDateAmpTime"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$strDateAmpTime1"/></xsl:attribute></Data>
					<Data name="Description" link="true" href="./DataArea?plugin=com.dell.hip.webplugins.ESMLogWebPlugin&amp;sortkey=description&amp;order=ascending"><xsl:attribute name="value"><xsl:value-of select="$strDescription"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$strDescription1"/></xsl:attribute></Data>
				</Header>
				<xsl:apply-templates select="TableData/Row">
					<xsl:sort select="Data[1]/@value" data-type="number"  order="descending"/>
				</xsl:apply-templates>
			</TableData>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="/ | @* | node()">
		<xsl:copy>
			<xsl:apply-templates select="@* | node()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
