<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:variable name="ShowSNMPTrap">
		<xsl:choose>
			<xsl:when test="not(/OMA/SNMPCap/MgmtSftwPropsObj/snmpCapabilities/SNMPTrap) or 												 /OMA/SNMPCap/MgmtSftwPropsObj/snmpCapabilities/SNMPTrap='false' ">false</xsl:when>
			<xsl:otherwise>true</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:template match="OMA">
		<xsl:variable name="userrights">
			<xsl:value-of select="OMAUserRights"/>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="SMStatus = 0 and $ShowSNMPTrap='true'">
				<DataArea exportdata="false">
					<xsl:attribute name="onLoad">true</xsl:attribute>
					<xsl:choose>
						<xsl:when test="($userrights = '7') or ($userrights = '3')">
							<xsl:attribute name="validate">true</xsl:attribute>
							<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.hip.webplugins.SetSNMPTrapsWebPlugin</xsl:attribute>
							<PromptText>
								<xsl:value-of select="$strCheckTheEvents"/>
							</PromptText>
							<PageTitle>
								<xsl:attribute name="display"><xsl:value-of select="$strConfigureSNMPTraps"/></xsl:attribute>
							</PageTitle>
						</xsl:when>
						<xsl:otherwise>
							<PageTitle>
								<xsl:attribute name="display"><xsl:value-of select="$strCurrentSNMPTraps"/></xsl:attribute>
							</PageTitle>
						</xsl:otherwise>
					</xsl:choose>
					<script language="javascript">
						var objTypeCount   = '<xsl:value-of select="count(Events/ObjType)"/>';
						var systemSeverity = '<xsl:value-of select="Events/System/snmptrap/@severity"/>';
						var g_bInit = false;
						
						<xsl:choose>
							<xsl:when test="/OMA/CommandType/@type = 'system' ">
								var sPageType = "system";
							</xsl:when>
							<xsl:otherwise>
								var sPageType = "compgroup";
							</xsl:otherwise>
						</xsl:choose>
						<xsl:choose>
							<xsl:when test="/OMA/CommandType/@type = 'system' ">
								<xsl:choose>
									<xsl:when test="($userrights = '7') or ($userrights = '3')">
										function initializationRoutine()
										{
										     g_bInit = true;
											<xsl:for-each select="Events/ObjType">
												
												initializeObject( document.getElementById( 'objtypeparentindex<xsl:value-of select="position()"/>' ).value, 
																	   document.getElementById( 'objtypechildindex<xsl:value-of select="position()"/>' ).value, 
																	  systemSeverity,
																	  'forcedcomp' );
																	
												initializeObject( document.getElementById( 'objtypeparentindex<xsl:value-of select="position()"/>' ).value, 
																	   document.getElementById( 'objtypechildindex<xsl:value-of select="position()"/>' ).value, 
																	  '<xsl:value-of select="snmptrap/@severity"/>',
																	  'rootcomp' );
											</xsl:for-each>											
											initializeObject( 'systemcheckbox', 
																  'sysselection', 
																  systemSeverity, 
																  'systempcomp');

											forceSystemSeverityOnObjTypes( systemSeverity, 
																					       'initialization' );
										
											g_bInit = false;
										}
																				
										function processChildSelection( parentObj, childObj, severity)
										{
											if( parentObj == 'system' )
											{
												initializeObject( 'systemcheckbox', 
																	  'sysselection', 
																	  severity, 
																	  'systempcomp' );

												forceSystemSeverityOnObjTypes( severity, '' );
											}
											else
											{
												if( computeSeverityFactor( severity, document.getElementById('sysselection').value ) )
												{
													// This branch of the IF statement should never be reached. but keep it for safe side.
													initializeObject( parentObj, 
																		  childObj, 
																		  document.getElementById( childObj ).value,
																		  'rootcomp' );
												}
												else
												{
													initializeObject( parentObj, 
																		  childObj, 
																		  severity, 
																		  'rootcomp' );
												}
											}
										
										}
										
										function processParentSelection( parentObj, childObj )
										{
											if( parentObj == 'system' )
											{
												if( document.getElementById( 'systemcheckbox' ).checked == true )
												{
													initializeObject( 'systemcheckbox', 
																		   'sysselection', 
																		   'informational', 
																		   'systempcomp' );

													forceSystemSeverityOnObjTypes( 'informational', '' );
												}
												else
												{
													initializeObject( 'systemcheckbox', 
																		  'sysselection', 
																		  'none', 
																		  'systempcomp' );

													forceSystemSeverityOnObjTypes( 'none', '' );
												}
											}
											else
											{
												if( document.getElementById( parentObj ).checked == true )
												{
													if( computeSeverityFactor( 'informational', document.getElementById('sysselection').value ) )
													{
														// This branch of the IF statement should never be reached. but keep it for safe side.
														initializeObject( parentObj, 
																			  childObj, 
																			  'none', 
																			  'rootcomp' );
													}
													else
													{
														initializeObject( parentObj, 
																			  childObj, 
																			  'informational', 
																			  'rootcomp' );
													}
												}
												else
												{
													if( computeSeverityFactor( 'informational', document.getElementById('sysselection').value ) )
													{
														// This branch of the IF statement should never be reached. but keep it for safe side.
														initializeObject( parentObj, 
																			  childObj, 
																			  'informational', 
																			  'rootcomp' );
													}
													else
													{
														initializeObject( parentObj, 
																			   childObj, 
																			   'none', 
																			   'rootcomp' );
													}
												}
											}
										}
									</xsl:when>
									<xsl:otherwise>
										function initializationRoutine()
										{
											<xsl:for-each select="Events/ObjType">			
												initializeObject( document.getElementById( 'objtypeparentindex<xsl:value-of select="position()"/>' ).value, 
																	  document.getElementById( 'objtypechildindex<xsl:value-of select="position()"/>' ).value, 
																	  '<xsl:value-of select="snmptrap/@severity"/>',
																	  'rootcomp' );
											</xsl:for-each>			
											initializeObject(  'systemcheckbox', 
																   'sysselection', 
																   systemSeverity,
																   'rootcomp' );
																
											forceSystemSeverityOnObjTypes( systemSeverity, 
																					       'initialization' );
											disableAll();
										}
										
										function disableAll()
										{
											disableObject( 'systemcheckbox', 
																 'sysselection' );

											<xsl:for-each select="Events/ObjType">			
												disableObject( document.getElementById( 'objtypeparentindex<xsl:value-of select="position()"/>' ).value, 
																	 document.getElementById( 'objtypechildindex<xsl:value-of select="position()"/>' ).value );
											</xsl:for-each>
										}
										
										function disableObject( parentObj, childObj)
										{
											document.getElementById( parentObj ).disabled = true;
											
											var tempChildObjArray = document.getElementsByName( childObj );
											if( navigator.appName != "Microsoft Internet Explorer" )
											{
												document.getElementById( parentObj ).style.color = "#000000";
											}
											
											tempChildObjArray[0].disabled = true;
											tempChildObjArray[1].disabled = true;
											tempChildObjArray[2].disabled = true;
											tempChildObjArray[3].disabled = true;
											
											if( navigator.appName != "Microsoft Internet Explorer" )
											{
											  tempChildObjArray[0].style.color = "#000000";
											  tempChildObjArray[1].style.color = "#000000";
											  tempChildObjArray[2].style.color = "#000000";
											  tempChildObjArray[3].style.color = "#000000";
											}
										}
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test=" /OMA/CommandType/@type = 'objtype' ">
								<xsl:choose>
									<xsl:when test="($userrights = '7') or ($userrights = '3')">
										var objTypeSeverityVar = '<xsl:value-of select="Events/ObjType/snmptrap/@severity"/>';
										var sCompGroupCheckBoxName = 'compgroupcheckbox<xsl:value-of select="Events/ObjType/@type"/>';
										
										function initializationRoutine()
										{
											initializeObject( 'compgroupcheckbox<xsl:value-of select="Events/ObjType/@type"/>', 
																  'compgroupselection<xsl:value-of select="Events/ObjType/@type"/>', 
																  systemSeverity,
																  'forcedcomp' );
																
											initializeObject( 'compgroupcheckbox<xsl:value-of select="Events/ObjType/@type"/>', 
																  'compgroupselection<xsl:value-of select="Events/ObjType/@type"/>', 
																   objTypeSeverityVar,
																  'rootcomp' );
										
											<xsl:for-each select="Events/ObjList/Object">
												initializeObject( 'checkbox<xsl:value-of select="@oid"/>', 
																	  'selection<xsl:value-of select="@oid"/>', 
																	  objTypeSeverityVar,
																	  'forcedcomp' );

												initializeObject( 'checkbox<xsl:value-of select="@oid"/>', 
																	  'selection<xsl:value-of select="@oid"/>', 
																	  '<xsl:value-of select="snmptrap/@severity"/>',
																	  'rootcomp' );
											</xsl:for-each>

											forceObjTypeSeverityOnObjects( '<xsl:value-of select="Events/ObjType/snmptrap/@severity"/>', 
																					     'initialization' );
										}

										function processChildSelection( parentObj, childObj, severity)
										{
											var systemSetting    = '<xsl:value-of select="Events/System/snmptrap/@severity"/>';
											var parentCheckbox = 'compgroupcheckbox<xsl:value-of select="Events/ObjType/@type"/>' ;
											var parentSelection  = 'compgroupselection<xsl:value-of select="Events/ObjType/@type"/>' ;

											if( parentObj ==  parentCheckbox)
											{
												if( computeSeverityFactor( severity, systemSetting ) )
												{
													// This branch of the IF statement should never be reached. but keep it for safe side.
													initializeObject( parentCheckbox , 
																		   parentSelection, 
																		   document.getElementById( parentSelection ).value,
																		   'rootcomp' );
												}
												else
												{
													initializeObject( parentCheckbox, 
																		  parentSelection, 
																		  severity,
																		  'rootcomp' );

													forceObjTypeSeverityOnObjects( severity, '' );
												}
											}
											else
											{
												if( computeSeverityFactor( severity, document.getElementById( parentSelection ).value ) )
												{										
													// This branch of the IF statement should never be reached, but keep it for safe side.
													initializeObject( parentObj, 
																		  childObj, 
																		  document.getElementById( childObj ).value,
																		  'rootcomp' );
												}
												else
												{
													initializeObject( parentObj, 
																		  childObj, 
																		  severity,
																		  'rootcomp' );
												}
											}
										}
										
										function processParentSelection( parentObj, childObj )
										{
											var systemSetting    		= '<xsl:value-of select="Events/System/snmptrap/@severity"/>';
											var parentCheckbox 	= 'compgroupcheckbox<xsl:value-of select="Events/ObjType/@type"/>' ;
											var parentSelection  	= 'compgroupselection<xsl:value-of select="Events/ObjType/@type"/>' ;
										
											if( parentObj == parentCheckbox )
											{
												if( document.getElementById( parentCheckbox ).checked == true )
												{
													if( computeSeverityFactor( 'informational', systemSetting ) )
													{
														// This branch of the IF statement should never be reached. but keep it for safe side.
														initializeObject( parentCheckbox, 
																			  parentSelection, 
																			  'none',
																			  'rootcomp' );

														forceObjTypeSeverityOnObjects( 'none', '' );
													}
													else
													{
														initializeObject( parentCheckbox, 
																			  parentSelection, 
																			  'informational',
																			  'rootcomp' );
														
														forceObjTypeSeverityOnObjects( 'informational', '' );
													}
												}
												else
												{
													initializeObject( parentCheckbox, 
																		  parentSelection, 
																		  'none',
																		  'rootcomp' );

													forceObjTypeSeverityOnObjects( 'none', '' );
												}
											}
											else
											{
												if( document.getElementById( parentObj ).checked == true )
												{
													if( computeSeverityFactor( 'informational', document.getElementById( parentSelection ).value ) )
													{
														// This branch of the IF statement should never be reached. but keep it for safe side.
														initializeObject( parentObj, 
																			  childObj, 
																			  'none', 
																			  'rootcomp' );
													}
													else
													{
														initializeObject( parentObj, 
																			  childObj, 
																			  'informational',
																			  'rootcomp' );
													}
												}
												else
												{
													initializeObject( parentObj, 
																		  childObj, 
																		  'none',
																		  'rootcomp' );
												}
											}
										}
									</xsl:when>
									<xsl:otherwise>
										function initializationRoutine()
										{
											<xsl:for-each select="Events/ObjList/Object">
												initializeObject( 'checkbox<xsl:value-of select="@oid"/>',  
																	   'selection<xsl:value-of select="@oid"/>', 
																	   '<xsl:value-of select="snmptrap/@severity"/>',
																	   'rootcomp' );
											</xsl:for-each>
											
											initializeObject( 'compgroupcheckbox<xsl:value-of select="Events/ObjType/@type"/>', 
																  'compgroupselection<xsl:value-of select="Events/ObjType/@type"/>', 
																  '<xsl:value-of select="Events/ObjType/snmptrap/@severity"/>',
																  'rootcomp' );

											forceObjTypeSeverityOnObjects( '<xsl:value-of select="Events/ObjType/snmptrap/@severity"/>', 
																					     'initialization' );
											disableAll();
										}
										
										function disableAll()
										{
											disableObject( 'compgroupcheckbox<xsl:value-of select="Events/ObjType/@type"/>',
																 'compgroupselection<xsl:value-of select="Events/ObjType/@type"/>' );
											
											<xsl:for-each select="Events/ObjList/Object">		
												disableObject( 'checkbox<xsl:value-of select="@oid"/>', 
																	 'selection<xsl:value-of select="@oid"/>' );
											</xsl:for-each>
										}
										
										function disableObject( parentObj, childObj)
										{
											document.getElementById( parentObj ).disabled = true;
											if( navigator.appName != "Microsoft Internet Explorer" )
											{
												document.getElementById( parentObj ).style.color = "#000000";
											}
											
											var tempChildObjArray = document.getElementsByName( childObj );
											tempChildObjArray[0].disabled = true;
											tempChildObjArray[1].disabled = true;
											tempChildObjArray[2].disabled = true;
											tempChildObjArray[3].disabled = true;
											
											if( navigator.appName != "Microsoft Internet Explorer" )
											{
												tempChildObjArray[0].style.color = "#000000";
												tempChildObjArray[1].style.color = "#000000";
												tempChildObjArray[2].style.color = "#000000";
												tempChildObjArray[3].style.color = "#000000";
											}
										}
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
						</xsl:choose>
						
					
						function initializeObject( parentObj, childTree, severity, compType )
						{
							var checkboxObj = document.getElementById( parentObj );
							var selectionArray = document.getElementsByName( childTree );
							
							if( (checkboxObj != null)  &amp;&amp; (selectionArray != null) )
							{
								if( severity == 'informational' )
								{
									checkboxObj.disabled = false;
									checkboxObj.checked = true;
								
									selectionArray[0].disabled = false;
									selectionArray[1].disabled = false;
									selectionArray[2].disabled = false;
									selectionArray[3].disabled = false;
								
									selectionArray[0].checked = true;									
									document.getElementById( childTree ).value = 'informational'; 
								}
								else if( severity == 'warning' )
								{
									if( (compType == 'rootcomp') ||  (compType == 'systempcomp') )
									{
										checkboxObj.disabled = false;
										checkboxObj.checked = true;
										checkboxObj.disabled = true;
										if( navigator.appName != "Microsoft Internet Explorer" )
										{ 
											checkboxObj.style.color = "#000000"; 
										}
										
										selectionArray[1].disabled = false;
										selectionArray[1].checked = true;
									}
									else
									{
										checkboxObj.disabled = false;
										checkboxObj.checked = true;
										checkboxObj.disabled = true;
										if( navigator.appName != "Microsoft Internet Explorer" )
										{ 
											checkboxObj.style.color = "#000000"; 
										}
										
										selectionArray[0].disabled = true;
										
										selectionArray[1].disabled = false;
										selectionArray[1].checked = true;
										
										selectionArray[2].disabled = false;
										selectionArray[3].disabled = false;
									}
									
									document.getElementById( childTree ).value = 'warning';
								}
								else if( severity == 'critical' )
								{
									if( (compType == 'rootcomp') ||  (compType == 'systempcomp') )
									{
										checkboxObj.disabled = false;
										checkboxObj.checked = true;
										checkboxObj.disabled = true;
										if( navigator.appName != "Microsoft Internet Explorer" )
										{ 
											checkboxObj.style.color = "#000000"; 
										}
										
										selectionArray[2].disabled = false;
										selectionArray[2].checked = true;
									}
									else
									{
										checkboxObj.disabled = false;
										checkboxObj.checked = true;
										checkboxObj.disabled = true;
										if( navigator.appName != "Microsoft Internet Explorer" )
										{ 
											checkboxObj.style.color = "#000000";
										}
										
										selectionArray[0].disabled = true;
										selectionArray[1].disabled = true;
										
										selectionArray[2].disabled = false;
										selectionArray[2].checked = true;
										
										selectionArray[3].disabled = false;
									}
									
									document.getElementById( childTree ).value = 'critical';
								}
								else if( severity == 'none')
								{
									if( (compType == 'rootcomp') ||  (compType == 'systempcomp') )
									{
										if( compType == 'rootcomp' )
										{
											checkboxObj.disabled = false;
											checkboxObj.checked = false;
											
											if (sPageType == 'system') {
											    if (g_bInit == true) {
										         		if (systemSeverity == 'informational') {
											     		checkboxObj.disabled = false;
											  		}
											  		else {
											    			checkboxObj.disabled = true;
											  		}
											    }
											    else {
										         		if (document.getElementById( 'systemcheckbox' ).checked == true &amp;&amp;
											       		document.getElementById( 'systemcheckbox' ).disabled == false) {
											     		checkboxObj.disabled = false;
											  		}
											  		else {
											    			checkboxObj.disabled = true;
											  		}
											    }
											}
											else {
												if (parentObj == sCompGroupCheckBoxName) {
												     if (systemSeverity == 'informational') {
												  		checkboxObj.disabled = false;
												 	}
													else {													
												  		checkboxObj.disabled = true;
													}
												}
												else {														
											    		if (document.getElementById(sCompGroupCheckBoxName).checked == true &amp;&amp;
											       		document.getElementById(sCompGroupCheckBoxName).disabled == false) {
											    			checkboxObj.disabled = false;
											  		}
												  	else {
												    		checkboxObj.disabled = true;
												  	}
												}
											}
																					
											selectionArray[3].disabled = false;
											selectionArray[3].checked = true;
										}
										else
										{
											checkboxObj.disabled = false;
											checkboxObj.checked = false;
											selectionArray[3].disabled = false;
											selectionArray[3].checked = true;								
										}
									}
									else
									{
										checkboxObj.disabled = false;
										checkboxObj.checked = false;
										checkboxObj.disabled = true;
										
										selectionArray[0].disabled = true;
										selectionArray[1].disabled = true;
										selectionArray[2].disabled = true;
										
										selectionArray[3].disabled = false;
										selectionArray[3].checked = true;
									}
									
									document.getElementById( childTree ).value = 'none';
								}
								else
								{
									// invalid severity do nothing.
								}
							}
						}
						
						function forceObjTypeSeverityOnObjects( severity, state )
						{
							var objectcountvalue = document.getElementById( 'objectcount' ).value;

							for( var i=1; i &lt;= objectcountvalue; i++ )
							{
								var tempoid = document.getElementById( 'oidvalue' + i ).value;
								
								if( state == 'initialization' )
								{
									if( computeSeverityFactor( document.getElementById( 'selection' + tempoid ).value, severity ) )
									{
										initializeObject( 'checkbox' + tempoid, 
															   'selection' + tempoid, 
															   severity );
									}
								}
								else
								{
										initializeObject( 'checkbox' + tempoid, 
															   'selection' + tempoid, 
															   severity,
															   'forcedcomp' );
								}
							}
						}
						
						function forceSystemSeverityOnObjTypes( sysSeverity, state )
						{
							for( var  i=1; i &lt;= objTypeCount ; i++ )
							{
								var temp = document.getElementById( 'objtypechildindex' + i).value;

								if(state == 'initialization')
								{
									if( computeSeverityFactor( document.getElementById( temp).value, sysSeverity ) )
									{
										initializeObject(  document.getElementById( 'objtypeparentindex' + i).value, 
															   document.getElementById( 'objtypechildindex' + i).value, 
															   sysSeverity );
									}
								}
								else
								{
									initializeObject(  document.getElementById( 'objtypeparentindex' + i).value, 
														   document.getElementById( 'objtypechildindex' + i).value, 
														   sysSeverity,
														   'forcedcomp' );
								}
							}
						}
						
						function computeSeverityFactor( childSeverity, sysSeverity)
						{
							return ( mapServerityToInteger( sysSeverity )  &gt; mapServerityToInteger( childSeverity ) );
						}
						
						function mapServerityToInteger( severity )
						{
							if( severity == 'informational' )
							{
								return 1;
							}
							else if( severity == 'warning' )
							{
								return 2;
							}
							else if( severity == 'critical' )
							{
								return 3;
							}
							else if( severity == 'none' )
							{
								return 4;
							}
							else
							{
								// invalid severity do nothing
								return 0;
							}
						}
						
						function validate()
						{
							if(navigator.appName == "Netscape")
							{
								expandSelectionData();
							}						
							return true;
						}
					</script>
					<xsl:choose>
						<xsl:when test="/OMA/CommandType/@type = 'system' ">
							<CustomButton>
								<Data name="Refresh">
									<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.SNMPTrapsWebPlugin&amp;help=snmptraps&amp;app=hip</xsl:attribute>
									<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
								</Data>
							</CustomButton>
						</xsl:when>
						<xsl:when test="/OMA/CommandType/@type = 'objtype' ">
							<CustomButton>
								<Data>
									<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.SNMPTrapsByObjTypeWebPlugin&amp;objtype=<xsl:value-of select="/OMA/CommandType/@value"/>&amp;help=snmptraps&amp;app=hip</xsl:attribute>
									<xsl:attribute name="display"><xsl:value-of select="$strRefresh1"/></xsl:attribute>
								</Data>
							</CustomButton>
						</xsl:when>
					</xsl:choose>
					<xsl:apply-templates select="Events"/>
				</DataArea>
			</xsl:when>
			<!-- If objtype is not applicable for this system-->
			<xsl:when test="SMStatus = 7 or $ShowSNMPTrap='false' ">
				<DataArea exportdata="false">
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strSNMPTraps"/></xsl:attribute>
					</PageTitle>
					<PromptText>
					<xsl:choose>					
					    <xsl:when test="SMStatus =7">
						<xsl:value-of select="$strNoTrapsAvailable"/>
						</xsl:when>
						<xsl:when test="$ShowSNMPTrap='false'">
							<xsl:value-of select="$strNoTrapsAvailable1"/>
						</xsl:when>
						</xsl:choose>
					</PromptText>
					<CustomButton>
						<Data>
							<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.SNMPTrapsByObjTypeWebPlugin&amp;objtype=<xsl:value-of select="/OMA/CommandType/@value"/>&amp;help=snmptraps&amp;app=hip</xsl:attribute>
							<xsl:attribute name="display"><xsl:value-of select="$strRefresh1"/></xsl:attribute>
						</Data>
					</CustomButton>
				</DataArea>
			</xsl:when>
			<xsl:otherwise>
				<DataArea exportdata="false">
					<CustomMessage status="3">
						<xsl:value-of select="$strError"/>
					</CustomMessage>
				</DataArea>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="Events">
		<SelectionData>
			<SelectionTable>
				<Header>
					<Data>
						<xsl:attribute name="value"><xsl:value-of select="$strEnableSNMPTraps"/></xsl:attribute>
					</Data>
					<xsl:if test="/OMA/CommandType/@type = 'objtype'">
						<Data align="left">
							<xsl:attribute name="value">[<xsl:call-template name="getSeverity"><xsl:with-param name="severity"><xsl:value-of select="System/snmptrap/@severity"/></xsl:with-param></xsl:call-template>]<xsl:value-of select="$strTrapsEnabledFor"/></xsl:attribute>
						</Data>
					</xsl:if>
				</Header>
				<xsl:choose>
					<xsl:when test="/OMA/CommandType/@type = 'system' ">
						<Row tree="expand" name="systemtreecontrol">
							<SelectDataItem>
								<Data type="checkbox" width="20" name="systemcheckbox">
									<xsl:attribute name="event">onclick</xsl:attribute>
									<xsl:attribute name="handler">javascript:processParentSelection( 'system', '');</xsl:attribute>
								</Data>
							</SelectDataItem>
							<ColumnData>
								<Data>
									<xsl:attribute name="value"><xsl:value-of select="$strSystem"/></xsl:attribute>
								</Data>
							</ColumnData>
							<ChildrenRows>
								<Row>
									<SelectDataItem>
										<Data type="radio" returnvalue="sysinfo" name="sysselection" width="20">
											<xsl:attribute name="returnvalue">informational</xsl:attribute>
											<xsl:attribute name="event">onclick</xsl:attribute>
											<xsl:attribute name="handler">javascript:processChildSelection('system', '', 'informational');</xsl:attribute>
										</Data>
									</SelectDataItem>
									<ColumnData>
										<Data>
											<xsl:attribute name="value"><xsl:value-of select="$strInformationalWarningCritical"/></xsl:attribute>
										</Data>
									</ColumnData>
								</Row>
								<Row>
									<SelectDataItem>
										<Data type="radio" returnvalue="syswarn" name="sysselection" width="20">
											<xsl:attribute name="returnvalue">warning</xsl:attribute>
											<xsl:attribute name="event">onclick</xsl:attribute>
											<xsl:attribute name="handler">javascript:processChildSelection('system', '', 'warning');</xsl:attribute>
										</Data>
									</SelectDataItem>
									<ColumnData>
										<Data>
											<xsl:attribute name="value"><xsl:value-of select="$strWarningCritical"/></xsl:attribute>
										</Data>
									</ColumnData>
								</Row>
								<Row>
									<SelectDataItem>
										<Data type="radio" returnvalue="syscrit" name="sysselection" width="20">
											<xsl:attribute name="returnvalue">critical</xsl:attribute>
											<xsl:attribute name="event">onclick</xsl:attribute>
											<xsl:attribute name="handler">javascript:processChildSelection('system', '', 'critical');</xsl:attribute>
										</Data>
									</SelectDataItem>
									<ColumnData>
										<Data>
											<xsl:attribute name="value"><xsl:value-of select="$strCritical"/></xsl:attribute>
										</Data>
									</ColumnData>
								</Row>
								<Row>
									<SelectDataItem>
										<Data type="radio" returnvalue="sysnone" name="sysselection" width="20">
											<xsl:attribute name="returnvalue">none</xsl:attribute>
											<xsl:attribute name="event">onclick</xsl:attribute>
											<xsl:attribute name="handler">javascript:processChildSelection('system', '', 'none');</xsl:attribute>
										</Data>
									</SelectDataItem>
									<ColumnData>
										<Data>
											<xsl:attribute name="value"><xsl:value-of select="$strNone"/></xsl:attribute>
										</Data>
									</ColumnData>
								</Row>
								<xsl:for-each select="ObjType">
									<xsl:call-template name="objtype"/>
								</xsl:for-each>
							</ChildrenRows>
						</Row>
					</xsl:when>
					<xsl:when test="/OMA/CommandType/@type = 'objtype' ">
						<Row tree="expand">
							<xsl:attribute name="name">compgroup<xsl:value-of select="ObjType/@type"/>treecontrol</xsl:attribute>
							<SelectDataItem>
								<Data type="checkbox" width="20">
									<xsl:attribute name="name">compgroupcheckbox<xsl:value-of select="ObjType/@type"/></xsl:attribute>
									<xsl:attribute name="event">onclick</xsl:attribute>
									<xsl:attribute name="handler">javascript:processParentSelection( 'compgroupcheckbox<xsl:value-of select="ObjType/@type"/>',																										 'compgroupselection<xsl:value-of select="ObjType/@type"/>');</xsl:attribute>
								</Data>
							</SelectDataItem>
							<ColumnData>
								<Data>
									<xsl:attribute name="value"><xsl:call-template name="getObjTypeName"><xsl:with-param name="objtype"><xsl:value-of select="ObjType/@type"/></xsl:with-param></xsl:call-template></xsl:attribute>
								</Data>
							</ColumnData>
							<ChildrenRows>
								<Row>
									<SelectDataItem>
										<Data type="radio" width="20">
											<xsl:attribute name="returnvalue">informational</xsl:attribute>
											<xsl:attribute name="event">onclick</xsl:attribute>
											<xsl:attribute name="name">compgroupselection<xsl:value-of select="ObjType/@type"/></xsl:attribute>
											<xsl:attribute name="handler">javascript:processChildSelection( 'compgroupcheckbox<xsl:value-of select="ObjType/@type"/>',
																										    'compgroupselection<xsl:value-of select="ObjType/@type"/>', 
																										    'informational' );</xsl:attribute>
										</Data>
									</SelectDataItem>
									<ColumnData>
										<Data>
											<xsl:attribute name="value"><xsl:value-of select="$strInformationalWarningCritical1"/></xsl:attribute>
										</Data>
									</ColumnData>
								</Row>
								<Row>
									<SelectDataItem>
										<Data type="radio" width="20">
											<xsl:attribute name="returnvalue">warning</xsl:attribute>
											<xsl:attribute name="event">onclick</xsl:attribute>
											<xsl:attribute name="name">compgroupselection<xsl:value-of select="ObjType/@type"/></xsl:attribute>
											<xsl:attribute name="handler">javascript:processChildSelection( 'compgroupcheckbox<xsl:value-of select="ObjType/@type"/>',
																										    'compgroupselection<xsl:value-of select="ObjType/@type"/>', 
																										    'warning' );</xsl:attribute>
										</Data>
									</SelectDataItem>
									<ColumnData>
										<Data>
											<xsl:attribute name="value"><xsl:value-of select="$strWarningCritical1"/></xsl:attribute>
										</Data>
									</ColumnData>
								</Row>
								<Row>
									<SelectDataItem>
										<Data type="radio" width="20">
											<xsl:attribute name="returnvalue">critical</xsl:attribute>
											<xsl:attribute name="event">onclick</xsl:attribute>
											<xsl:attribute name="name">compgroupselection<xsl:value-of select="ObjType/@type"/></xsl:attribute>
											<xsl:attribute name="handler">javascript:processChildSelection( 'compgroupcheckbox<xsl:value-of select="ObjType/@type"/>',
																										    'compgroupselection<xsl:value-of select="ObjType/@type"/>', 
																										    'critical' );</xsl:attribute>
										</Data>
									</SelectDataItem>
									<ColumnData>
										<Data>
											<xsl:attribute name="value"><xsl:value-of select="$strCritical1"/></xsl:attribute>
										</Data>
									</ColumnData>
								</Row>
								<Row>
									<SelectDataItem>
										<Data type="radio" width="20">
											<xsl:attribute name="returnvalue">none</xsl:attribute>
											<xsl:attribute name="event">onclick</xsl:attribute>
											<xsl:attribute name="name">compgroupselection<xsl:value-of select="ObjType/@type"/></xsl:attribute>
											<xsl:attribute name="handler">javascript:processChildSelection( 'compgroupcheckbox<xsl:value-of select="ObjType/@type"/>',
																										    'compgroupselection<xsl:value-of select="ObjType/@type"/>', 
																										    'none');</xsl:attribute>
										</Data>
									</SelectDataItem>
									<ColumnData>
										<Data>
											<xsl:attribute name="value"><xsl:value-of select="$strNone1"/></xsl:attribute>
										</Data>
									</ColumnData>
								</Row>
								<xsl:for-each select="ObjList/Object">
									<xsl:call-template name="object"/>
								</xsl:for-each>
							</ChildrenRows>
						</Row>
					</xsl:when>
				</xsl:choose>
			</SelectionTable>
		</SelectionData>
		<xsl:choose>
			<xsl:when test="/OMA/CommandType/@type = 'system' ">
				<HiddenTable>
					<Data type="hidden">
						<xsl:attribute name="name">commandtype</xsl:attribute>
						<xsl:attribute name="returnvalue">bysystem</xsl:attribute>
					</Data>
					<Data type="hidden">
						<xsl:attribute name="name">objtypecount</xsl:attribute>
						<xsl:attribute name="returnvalue"><xsl:value-of select=" count(ObjType)"/></xsl:attribute>
					</Data>
					<Data type="hidden">
						<xsl:attribute name="name">oldsystemseverity</xsl:attribute>
						<xsl:attribute name="returnvalue"><xsl:value-of select="System/snmptrap/@severity"/></xsl:attribute>
					</Data>
					<xsl:for-each select="ObjType">
						<Data type="hidden">
							<xsl:attribute name="name">objtypechildindex<xsl:value-of select="position()"/>oldvalue</xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="snmptrap/@severity"/></xsl:attribute>
						</Data>
						<Data type="hidden">
							<xsl:attribute name="name">objtypeparentindex<xsl:value-of select="position()"/></xsl:attribute>
							<xsl:attribute name="returnvalue">parentobjtype<xsl:value-of select="@type"/></xsl:attribute>
						</Data>
						<Data type="hidden">
							<xsl:attribute name="name">objtypechildindex<xsl:value-of select="position()"/></xsl:attribute>
							<xsl:attribute name="returnvalue">objtype<xsl:value-of select="@type"/>selection</xsl:attribute>
						</Data>
						<Data type="hidden">
							<xsl:attribute name="name">objtypechildindex<xsl:value-of select="position()"/>type</xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="@type"/></xsl:attribute>
						</Data>
					</xsl:for-each>
				</HiddenTable>
			</xsl:when>
			<xsl:when test=" /OMA/CommandType/@type = 'objtype' ">
				<HiddenTable>
					<Data type="hidden">
						<xsl:attribute name="name">commandtype</xsl:attribute>
						<xsl:attribute name="returnvalue">byobjtype</xsl:attribute>
					</Data>
					<Data type="hidden">
						<xsl:attribute name="name">comgroupobjtype</xsl:attribute>
						<xsl:attribute name="returnvalue"><xsl:value-of select="ObjType/@type"/></xsl:attribute>
					</Data>
					<Data type="hidden">
						<xsl:attribute name="name">objectcount</xsl:attribute>
						<xsl:attribute name="returnvalue"><xsl:value-of select="count( ObjList/Object )"/></xsl:attribute>
					</Data>
					<Data type="hidden">
						<xsl:attribute name="name">compgroupoldvalue</xsl:attribute>
						<xsl:attribute name="returnvalue"><xsl:value-of select="ObjType/snmptrap/@severity"/></xsl:attribute>
					</Data>
					<xsl:for-each select="ObjList/Object">
						<Data type="hidden">
							<xsl:attribute name="name">oidvalue<xsl:value-of select="position()"/></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="@oid"/></xsl:attribute>
						</Data>
						<Data type="hidden">
							<xsl:attribute name="name"><xsl:value-of select="@oid"/>oldvalue</xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="snmptrap/@severity"/></xsl:attribute>
						</Data>
					</xsl:for-each>
				</HiddenTable>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="objtype">
		<Row tree="collapse">
			<xsl:attribute name="name">objtype<xsl:value-of select="@type"/>treecontrol</xsl:attribute>
			<SelectDataItem>
				<Data type="checkbox" width="20">
					<xsl:attribute name="name">parentobjtype<xsl:value-of select="@type"/></xsl:attribute>
					<xsl:attribute name="event">onclick</xsl:attribute>
					<xsl:attribute name="handler">javascript:processParentSelection( 'parentobjtype<xsl:value-of select="@type"/>', 'objtype<xsl:value-of select="@type"/>selection');</xsl:attribute>
				</Data>
			</SelectDataItem>
			<ColumnData>
				<Data>
					<xsl:attribute name="value"><xsl:call-template name="getObjTypeName"><xsl:with-param name="objtype"><xsl:value-of select="@type"/></xsl:with-param></xsl:call-template></xsl:attribute>
				</Data>
			</ColumnData>
			<ChildrenRows>
				<Row>
					<SelectDataItem>
						<Data type="radio" width="20">
							<xsl:attribute name="name">objtype<xsl:value-of select="@type"/>selection</xsl:attribute>
							<xsl:attribute name="event">onclick</xsl:attribute>
							<xsl:attribute name="handler">javascript:processChildSelection( 'parentobjtype<xsl:value-of select="@type"/>' , 'objtype<xsl:value-of select="@type"/>selection', 'informational');</xsl:attribute>
							<xsl:attribute name="returnvalue">informational</xsl:attribute>
						</Data>
					</SelectDataItem>
					<ColumnData>
						<Data>
							<xsl:choose>
								<xsl:when test="@type ='40'">
									<xsl:attribute name="value"><xsl:value-of select="$strInformational"/></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="value"><xsl:value-of select="$strInformationalWarningCritical2"/></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
						</Data>
					</ColumnData>
				</Row>
				<Row>
					<SelectDataItem>
						<Data type="radio" width="20">
							<xsl:attribute name="name">objtype<xsl:value-of select="@type"/>selection</xsl:attribute>
							<xsl:attribute name="event">onclick</xsl:attribute>
							<xsl:attribute name="handler">javascript:processChildSelection( 'parentobjtype<xsl:value-of select="@type"/>' , 'objtype<xsl:value-of select="@type"/>selection', 'warning');</xsl:attribute>
							<xsl:attribute name="returnvalue">warning</xsl:attribute>
						</Data>
					</SelectDataItem>
					<ColumnData>
						<Data>
							<xsl:attribute name="value"><xsl:value-of select="$strWarningCritical2"/></xsl:attribute>
						</Data>
					</ColumnData>
				</Row>
				<Row>
					<SelectDataItem>
						<Data type="radio" width="20">
							<xsl:attribute name="name">objtype<xsl:value-of select="@type"/>selection</xsl:attribute>
							<xsl:attribute name="event">onclick</xsl:attribute>
							<xsl:attribute name="handler">javascript:processChildSelection( 'parentobjtype<xsl:value-of select="@type"/>' , 'objtype<xsl:value-of select="@type"/>selection', 'critical');</xsl:attribute>
							<xsl:attribute name="returnvalue">critical</xsl:attribute>
						</Data>
					</SelectDataItem>
					<ColumnData>
						<Data>
							<xsl:attribute name="value"><xsl:value-of select="$strCritical2"/></xsl:attribute>
						</Data>
					</ColumnData>
				</Row>
				<Row>
					<SelectDataItem>
						<Data type="radio" width="20">
							<xsl:attribute name="name">objtype<xsl:value-of select="@type"/>selection</xsl:attribute>
							<xsl:attribute name="event">onclick</xsl:attribute>
							<xsl:attribute name="handler">javascript:processChildSelection( 'parentobjtype<xsl:value-of select="@type"/>' , 'objtype<xsl:value-of select="@type"/>selection', 'none');</xsl:attribute>
							<xsl:attribute name="returnvalue">none</xsl:attribute>
						</Data>
					</SelectDataItem>
					<ColumnData>
						<Data>
							<xsl:attribute name="value"><xsl:value-of select="$strNone2"/></xsl:attribute>
						</Data>
					</ColumnData>
				</Row>
			</ChildrenRows>
		</Row>
	</xsl:template>
	<xsl:template name="object">
		<Row tree="collapse">
			<xsl:attribute name="name"><xsl:value-of select="@oid"/>treecontrol</xsl:attribute>
			<SelectDataItem>
				<Data type="checkbox" width="20">
					<xsl:attribute name="name">checkbox<xsl:value-of select="@oid"/></xsl:attribute>
					<xsl:attribute name="event">onclick</xsl:attribute>
					<xsl:attribute name="handler">javascript:processParentSelection(  'checkbox<xsl:value-of select="@oid"/>', 'selection<xsl:value-of select="@oid"/>' );</xsl:attribute>
				</Data>
			</SelectDataItem>
			<ColumnData>
				<Data>
					<xsl:attribute name="value"><xsl:if test="Bank!=''"><xsl:value-of select="Bank"/>/</xsl:if><xsl:value-of select="Name"/></xsl:attribute>
				</Data>
			</ColumnData>
			<ChildrenRows>
				<Row>
					<SelectDataItem>
						<Data type="radio" width="20">
							<xsl:attribute name="name">selection<xsl:value-of select="@oid"/></xsl:attribute>
							<xsl:attribute name="event">onclick</xsl:attribute>
							<xsl:attribute name="handler">javascript:processChildSelection( 'checkbox<xsl:value-of select="@oid"/>', 'selection<xsl:value-of select="@oid"/>', 'informational' );</xsl:attribute>
							<xsl:attribute name="returnvalue">informational</xsl:attribute>
						</Data>
					</SelectDataItem>
					<ColumnData>
						<Data>
							<xsl:attribute name="value"><xsl:value-of select="$strInformationalWarningCritical3"/></xsl:attribute>
						</Data>
					</ColumnData>
				</Row>
				<Row>
					<SelectDataItem>
						<Data type="radio" width="20">
							<xsl:attribute name="name">selection<xsl:value-of select="@oid"/></xsl:attribute>
							<xsl:attribute name="event">onclick</xsl:attribute>
							<xsl:attribute name="handler">javascript:processChildSelection( 'checkbox<xsl:value-of select="@oid"/>', 'selection<xsl:value-of select="@oid"/>', 'warning' );</xsl:attribute>
							<xsl:attribute name="returnvalue">warning</xsl:attribute>
						</Data>
					</SelectDataItem>
					<ColumnData>
						<Data>
							<xsl:attribute name="value"><xsl:value-of select="$strWarningCritical3"/></xsl:attribute>
						</Data>
					</ColumnData>
				</Row>
				<Row>
					<SelectDataItem>
						<Data type="radio" width="20">
							<xsl:attribute name="name">selection<xsl:value-of select="@oid"/></xsl:attribute>
							<xsl:attribute name="event">onclick</xsl:attribute>
							<xsl:attribute name="handler">javascript:processChildSelection( 'checkbox<xsl:value-of select="@oid"/>', 'selection<xsl:value-of select="@oid"/>', 'critical' );</xsl:attribute>
							<xsl:attribute name="returnvalue">critical</xsl:attribute>
						</Data>
					</SelectDataItem>
					<ColumnData>
						<Data>
							<xsl:attribute name="value"><xsl:value-of select="$strCritical3"/></xsl:attribute>
						</Data>
					</ColumnData>
				</Row>
				<Row>
					<SelectDataItem>
						<Data type="radio" width="20">
							<xsl:attribute name="name">selection<xsl:value-of select="@oid"/></xsl:attribute>
							<xsl:attribute name="event">onclick</xsl:attribute>
							<xsl:attribute name="handler">javascript:processChildSelection( 'checkbox<xsl:value-of select="@oid"/>', 'selection<xsl:value-of select="@oid"/>', 'none' );</xsl:attribute>
							<xsl:attribute name="returnvalue">none</xsl:attribute>
						</Data>
					</SelectDataItem>
					<ColumnData>
						<Data>
							<xsl:attribute name="value"><xsl:value-of select="$strNone3"/></xsl:attribute>
						</Data>
					</ColumnData>
				</Row>
			</ChildrenRows>
		</Row>
	</xsl:template>
	<xsl:template name="getSeverity">
		<xsl:param name="severity"/>
		<xsl:choose>
			<xsl:when test="$severity = 'informational'">
				<xsl:value-of select="$strInformationalWarningCritical3"/>
			</xsl:when>
			<xsl:when test="$severity = 'warning'">
				<xsl:value-of select="$strWarningCritical3"/>
			</xsl:when>
			<xsl:when test="$severity = 'critical'">
				<xsl:value-of select="$strCritical3"/>
			</xsl:when>
			<xsl:when test="$severity = 'none'">
				<xsl:value-of select="$strNone3"/>
			</xsl:when>
			<xsl:otherwise>Unknown</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="getObjTypeName">
		<xsl:param name="objtype"/>
		<xsl:choose>
			<xsl:when test="$objtype =  2 ">
				<xsl:value-of select="$strRedundancy"/>
			</xsl:when>
			<xsl:when test="$objtype =  21 ">
				<xsl:value-of select="$strPowerSupplies"/>
			</xsl:when>
			<xsl:when test="$objtype =  22 ">
				<xsl:value-of select="$strTemperatures"/>
			</xsl:when>
			<xsl:when test="$objtype =  23 ">
				<xsl:value-of select="$strFans"/>
			</xsl:when>
			<xsl:when test="$objtype =  24 ">
				<xsl:value-of select="$strVoltages"/>
			</xsl:when>
			<xsl:when test="$objtype =  25 ">
				<xsl:value-of select="$strSystemPower"/>
			</xsl:when>
			<xsl:when test="$objtype =  28 ">
				<xsl:value-of select="$strIntrusion"/>
			</xsl:when>
			<xsl:when test="$objtype =  31 ">
				<xsl:value-of select="$strLogs"/>
			</xsl:when>
			<xsl:when test="$objtype =  35 ">
				<xsl:value-of select="$strFanEnclosure"/>
			</xsl:when>
			<xsl:when test="$objtype =  37 ">
				<xsl:value-of select="$strACCord"/>
			</xsl:when>
			<xsl:when test="$objtype =  225 ">
				<xsl:value-of select="$strMemory"/>
			</xsl:when>
			<xsl:when test="$objtype =  27 ">
				<xsl:value-of select="$strBatteries"/>
			</xsl:when>
			<xsl:when test="$objtype =  40 ">
				<xsl:value-of select="$strSystemPeakPower"/>
			</xsl:when>
			<xsl:when test="$objtype =  52 ">
				<xsl:value-of select="$strSDCard"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
