<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>
<xsl:output method="xml"/>
<xsl:template match="/OMA">
	<DataArea>
		<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strSlots"/></xsl:attribute>
		<xsl:attribute name="backpagetarget">./DataArea?plugin=com.dell.hip.webplugins.SlotsWebPlugin&amp;poid=2&amp;help=Slots</xsl:attribute>
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strSlotInformation"/><xsl:value-of select="Slot/ExtName" /></xsl:attribute>
		</PageTitle>
		<CustomButton>
			<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.SlotWebPlugin&amp;help=SlotDevice&amp;oid=<xsl:value-of select="Slot/@oid"/></xsl:attribute>
			</Data>
		</CustomButton>
		
<ListData type="custom">

			<xsl:choose>
				<xsl:when test="SMStatus[1] = '0' or SMStatus[2] = '0'">
					
					<xsl:choose>
					<xsl:when test="/OMA/Slot/SlotID !='0'">
					<xsl:apply-templates select="Slot"/>
					</xsl:when>
					<xsl:otherwise>
					<xsl:apply-templates select="SlotDevice"/>
					</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<Header>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strError1"/></xsl:attribute>
						</Data>
					</Header>
					
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strSlotInformationNot"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSlotInformationNot1"/></xsl:attribute>
						</Data>
					
				</xsl:otherwise>
			</xsl:choose>
		</ListData>

	</DataArea>
</xsl:template>

<xsl:template match="Slot">
	
		<Data name="ID"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strID"/></xsl:attribute>
			
		
			<xsl:attribute name="value"><xsl:value-of select="SlotID"/></xsl:attribute>
		</Data>
	
		<Data name="Type"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strType"/></xsl:attribute>
			
		
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="Type='1'"><xsl:value-of select="$strOther"/></xsl:when>
					<xsl:when test="Type='3'"><xsl:value-of select="$strISA"/></xsl:when>
					<xsl:when test="Type='4'"><xsl:value-of select="$strMCA"/></xsl:when>
					<xsl:when test="Type='5'"><xsl:value-of select="$strEISA"/></xsl:when>
					<xsl:when test="Type='6'"><xsl:value-of select="$strPCI"/></xsl:when>
					<xsl:when test="Type='7'"><xsl:value-of select="$strPCMCIA"/></xsl:when>
					<xsl:when test="Type='8'"><xsl:value-of select="$strVLVESA"/></xsl:when>
					<xsl:when test="Type='9'"><xsl:value-of select="$strProprietary"/></xsl:when>
					<xsl:when test="Type='10'"><xsl:value-of select="$strProcessorCard"/></xsl:when>
					<xsl:when test="Type='11'"><xsl:value-of select="$strProprietaryMemoryCard"/></xsl:when>
					<xsl:when test="Type='12'"><xsl:value-of select="$strIORiserCard"/></xsl:when>
					<xsl:when test="Type='13'"><xsl:value-of select="$strNuBus"/></xsl:when>
					<xsl:when test="Type='14'"><xsl:value-of select="$strPCI66Mhz"/></xsl:when>
					<xsl:when test="Type='15'"><xsl:value-of select="$strAGP"/></xsl:when>
					<xsl:when test="Type='16'"><xsl:value-of select="$strAGP2X"/></xsl:when>
					<xsl:when test="Type='17'"><xsl:value-of select="$strAGP4X"/></xsl:when>
					<xsl:when test="Type='18'"><xsl:value-of select="$strPCIX"/></xsl:when>
					<xsl:when test="Type='160'"><xsl:value-of select="$strPC98C20"/></xsl:when>
					<xsl:when test="Type='161'"><xsl:value-of select="$strPC98C24"/></xsl:when>
					<xsl:when test="Type='162'"><xsl:value-of select="$strPC98E"/></xsl:when>
					<xsl:when test="Type='163'"><xsl:value-of select="$strPC98LocalBus"/></xsl:when>
					<xsl:when test="Type='164'"><xsl:value-of select="$strPC98Card"/></xsl:when>
					<xsl:when test="Type='165'"><xsl:value-of select="$strPCIE"/></xsl:when>
					<xsl:when test="Type='166'"><xsl:value-of select="$strPCIEX1"/></xsl:when>
					<xsl:when test="Type='167'"><xsl:value-of select="$strPCIEX2"/></xsl:when>
					<xsl:when test="Type='168'"><xsl:value-of select="$strPCIEX4"/></xsl:when>
					<xsl:when test="Type='169'"><xsl:value-of select="$strPCIEX8"/></xsl:when>
					<xsl:when test="Type='170'"><xsl:value-of select="$strPCIEX16"/></xsl:when>
					<xsl:when test="Type='171'"><xsl:value-of select="$strPCIEGEN2"/></xsl:when>
					<xsl:when test="Type='172'"><xsl:value-of select="$strPCIEGEN2X1"/></xsl:when>
					<xsl:when test="Type='173'"><xsl:value-of select="$strPCIEGEN2X2"/></xsl:when>
					<xsl:when test="Type='174'"><xsl:value-of select="$strPCIEGEN2X4"/></xsl:when>
					<xsl:when test="Type='175'"><xsl:value-of select="$strPCIEGEN2X8"/></xsl:when>
					<xsl:when test="Type='176'"><xsl:value-of select="$strPCIEGEN2X16"/></xsl:when>					
					<xsl:when test="Type='177'"><xsl:value-of select="$strPCIEGEN3"/></xsl:when>
					<xsl:when test="Type='178'"><xsl:value-of select="$strPCIEGEN3X1"/></xsl:when>
					<xsl:when test="Type='179'"><xsl:value-of select="$strPCIEGEN3X2"/></xsl:when>
					<xsl:when test="Type='180'"><xsl:value-of select="$strPCIEGEN3X4"/></xsl:when>
					<xsl:when test="Type='181'"><xsl:value-of select="$strPCIEGEN3X8"/></xsl:when>
					<xsl:when test="Type='182'"><xsl:value-of select="$strPCIEGEN3X16"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strNoValue"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	
		<Data name="Length"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strSlotLength"/></xsl:attribute>
			
		
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="Length='1'"><xsl:value-of select="$strOther1"/></xsl:when>
					<xsl:when test="Length='3'"><xsl:value-of select="$strShort"/></xsl:when>
					<xsl:when test="Length='4'"><xsl:value-of select="$strLong"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strUnknown1"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	
	
		<Data name="Speed"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strSpeed"/></xsl:attribute>

			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="HotPlugSystemSlot/SlotSpeed='0'"><xsl:value-of select="$strNotObtainedRefer"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="HotPlugSystemSlot/SlotSpeed"/><xsl:text> </xsl:text><xsl:value-of select="HotPlugSystemSlot/SlotSpeed/@unit"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	
		<Data name="Category"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strCategory"/></xsl:attribute>
			
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="Category='1'"><xsl:value-of select="$strOther2"/></xsl:when>
					<xsl:when test="Category='3'"><xsl:value-of select="$strBusConnector"/></xsl:when>
					<xsl:when test="Category='4'"><xsl:value-of select="$strPCMCIA1"/></xsl:when>
					<xsl:when test="Category='5'"><xsl:value-of select="$strMotherboard"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strUnknown3"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	
		<Data name="IsHotPlugCapable"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strHotPlugCapable"/></xsl:attribute>
		
		
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="HotPlugSystemSlot/IsHotPlugCapable='true'"><xsl:value-of select="$strYes"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strNo"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	
		<Data name="VoltSupply"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strVoltageSupply"/></xsl:attribute>
			
			<xsl:attribute name="value">
				<xsl:if test="IsVolt33='true'"><xsl:value-of select="$str33Volts"/><xsl:if test="IsVolt5='true'">, </xsl:if></xsl:if>
				<xsl:if test="IsVolt5='true'"><xsl:value-of select="$str5Volts"/></xsl:if>
			</xsl:attribute>
		</Data>
	
		<Data name="IsShared"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strSharedSlot"/></xsl:attribute>
			
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="IsShared='true'"><xsl:value-of select="$strYes1"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strNo1"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	
		<Data name="IsCard16"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strPCCard16"/></xsl:attribute>
			
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="IsCard16='true'"><xsl:value-of select="$strSupported"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strNotSupported"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	
		<Data name="IsCardBus"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strCardBus"/></xsl:attribute>
			
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="IsCardBus='true'"><xsl:value-of select="$strSupported1"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strNotSupported1"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	
		<Data name="IsZoomVideo"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strZoomVideo"/></xsl:attribute>
			
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="IsZoomVideo='true'"><xsl:value-of select="$strSupported2"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strNotSupported2"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	
		<Data name="IsModemRingResume"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strModemRingResume"/></xsl:attribute>
			
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="IsModemRingResume='true'"><xsl:value-of select="$strSupported3"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strNotSupported3"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	
		<Data name="IsPMECapable"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strPowerManagementEnable"/></xsl:attribute>
			
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="IsPMECapable='true'"><xsl:value-of select="$strSupported4"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strNotSupported4"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	
</xsl:template>

<xsl:template match="SlotDevice">
	
		<Data name="DeviceManufacturer"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strAdapterManufacturer"/></xsl:attribute>
			
			<xsl:attribute name="value"><xsl:value-of select="Manufacturer"/></xsl:attribute>
		</Data>
	
		<Data name="DeviceDesc"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strAdapterDescription"/></xsl:attribute>
			
			<xsl:attribute name="value"><xsl:value-of select="DeviceDesc"/></xsl:attribute>
		</Data>
	
		<Data name="DeviceDataBusWidth"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strAdapterDataBus"/></xsl:attribute>
			
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="DataBusWidth = '0'"><xsl:value-of select="$strNotObtainedRefer"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="DataBusWidth"/> <xsl:value-of select="$strBits"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	
		<Data name="DeviceSpeed"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strAdapterSpeed"/></xsl:attribute>
			
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="Speed='0'"><xsl:value-of select="$strNotObtainedRefer"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="Speed"/><xsl:text> </xsl:text><xsl:value-of select="Speed/@unit"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	

	<!-- Below condition check is to report the size of storage card if present on AMEA. Type='1' indicates AMEA Card -->

	<xsl:if test="MaserDeviceInfo/Type='1' and MaserDeviceInfo/IsStoragePresent='1'">
	
		<Data name="Storage">
			<xsl:attribute name="display"><xsl:value-of select="$strInstalledSDSize"/></xsl:attribute>
			
			<xsl:attribute name="value"><xsl:value-of select="MaserDeviceInfo/Size"/><xsl:value-of select="$strMB"/></xsl:attribute>
		</Data>
	
	</xsl:if>

</xsl:template>

<xsl:template match="*"/>

</xsl:stylesheet>
