<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>
<xsl:output method="xml"/>
<xsl:template match="/OMA">
	<xsl:choose>
		<xsl:when test="SMStatus[0] = '0' or SMStatus[1] = '0'">
			<DataArea>
				<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strPorts"/></xsl:attribute>
				<xsl:attribute name="backpagetarget">./DataArea?plugin=com.dell.hip.webplugins.PortsWebPlugin&amp;poid=2</xsl:attribute>
				<PageTitle>
					<xsl:attribute name="display"><xsl:value-of select="$strPort"/> <xsl:value-of select="Port/@index" /><xsl:text> </xsl:text><xsl:value-of select="$strInformation"/></xsl:attribute>
				</PageTitle>
				<CustomButton>
					<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
						<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.PortWebPlugin&amp;oid=<xsl:value-of select="Port/@oid"/></xsl:attribute>
					</Data>
				</CustomButton>
				<ListData>
					<xsl:apply-templates select="Port"/>
					<xsl:apply-templates select="PortDevice"/>
				</ListData>			
			</DataArea>
		</xsl:when>
		<xsl:otherwise>
			<DataArea>
				<PageTitle>
					<xsl:attribute name="display"><xsl:value-of select="$strPortInformation"/></xsl:attribute>
				</PageTitle>
				<TableData>
					<Header>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strError1"/></xsl:attribute>
						</Data>
					</Header>
					<Row>
						<Data>
							<xsl:attribute name="value"><xsl:value-of select="$strPortInfoNot"/></xsl:attribute>
							<xsl:attribute name="display"><xsl:value-of select="$strPortInfoNot1"/></xsl:attribute>
						</Data>
					</Row>
				</TableData>
			</DataArea>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template match="Port">
	<Data name="ExtName"  editable="false" type="ustring">
		<xsl:attribute name="display"><xsl:value-of select="$strExternalName"/></xsl:attribute>
		<xsl:attribute name="value"><xsl:value-of select="ExtName"/></xsl:attribute>
	</Data>
	<xsl:choose>
		<xsl:when test="ExtName='PARALLEL'">
			<Data name="BaseIOAddr"  editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strBaseIOAddress"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="BaseIOAddr"/></xsl:attribute>
			</Data>
			<Data name="IrqLevel"  editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strIRQLevel"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="IrqLevel"/></xsl:attribute>
			</Data>
			<Data name="ConnectorType"  editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strConnectorType"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="ConnectorType='1'"><xsl:value-of select="$strOther"/></xsl:when>
						<xsl:when test="ConnectorType='3'"><xsl:value-of select="$strXTAT"/></xsl:when>
						<xsl:when test="ConnectorType='4'"><xsl:value-of select="$strPS2"/></xsl:when>
						<xsl:when test="ConnectorType='5'"><xsl:value-of select="$strIEEE1284"/></xsl:when>
						<xsl:when test="ConnectorType='6'"><xsl:value-of select="$strProprietary"/></xsl:when>
						<xsl:when test="ConnectorType='160'"><xsl:value-of select="$strPC98"/></xsl:when>
						<xsl:when test="ConnectorType='161'"><xsl:value-of select="$strPC98Hireso"/></xsl:when>
						<xsl:when test="ConnectorType='162'"><xsl:value-of select="$strPCH98"/></xsl:when>
						<xsl:when test="ConnectorType='163'"><xsl:value-of select="$strPC98Note"/></xsl:when>
						<xsl:when test="ConnectorType='164'"><xsl:value-of select="$strPC98Full"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strNoValue"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			<Data name="ConnectorPinout"  editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strConnectorPinout"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="ConnectorPinout='1'"><xsl:value-of select="$strOther1"/></xsl:when>
						<xsl:when test="ConnectorPinout='3'"><xsl:value-of select="$strDB25FemaleIEEE1284A"/></xsl:when>
						<xsl:when test="ConnectorPinout='4'"><xsl:value-of select="$strDB25MaleIEEE"/></xsl:when>
						<xsl:when test="ConnectorPinout='5'"><xsl:value-of select="$strCentronicsIEEE1284B"/></xsl:when>
						<xsl:when test="ConnectorPinout='6'"><xsl:value-of select="$strMiniCentronicsIEEE1284C"/></xsl:when>
						<xsl:when test="ConnectorPinout='7'"><xsl:value-of select="$strProprietary1"/></xsl:when>
						<xsl:when test="ConnectorPinout='160'"><xsl:value-of select="$strCentronics14"/></xsl:when>
						<xsl:when test="ConnectorPinout='161'"><xsl:value-of select="$strDB36Female"/></xsl:when>
						<xsl:when test="ConnectorPinout='162'"><xsl:value-of select="$strMiniCentronics20"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strNoValue1"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			<Data name="Capabilities"  editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strCapabilities"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:if test="Capabilities/XT_AT='true'"><xsl:value-of select="$strXTAT1"/><xsl:text> </xsl:text></xsl:if>
					<xsl:if test="Capabilities/PS2='true'"><xsl:value-of select="$strPS21"/><xsl:text> </xsl:text></xsl:if>
					<xsl:if test="Capabilities/ECP='true'"><xsl:value-of select="$strECP"/><xsl:text> </xsl:text></xsl:if>
					<xsl:if test="Capabilities/EPP='true'"><xsl:value-of select="$strEPP"/><xsl:text> </xsl:text></xsl:if>
					<xsl:if test="Capabilities/PC98='true'"><xsl:value-of select="$strPC981"/><xsl:text> </xsl:text></xsl:if>
					<xsl:if test="Capabilities/PC98_HIRESO='true'"><xsl:value-of select="$strPC98Hireso1"/><xsl:text> </xsl:text></xsl:if>
					<xsl:if test="Capabilities/PCH98='true'"><xsl:value-of select="$strPCH981"/><xsl:text> </xsl:text></xsl:if>
				</xsl:attribute>
			</Data>
			<Data name="DmaSupported"  editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strDMASupported"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="DmaSupported='true'"><xsl:value-of select="$strYes"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strNo"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			<Data name="SecuritySettings"  editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strSecuritySettings"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="SecuritySettings='1'"><xsl:value-of select="$strOther2"/></xsl:when>
						<xsl:when test="SecuritySettings='3'"><xsl:value-of select="$strNone"/></xsl:when>
						<xsl:when test="SecuritySettings='4'"><xsl:value-of select="$strExternalInterfaceLocked"/></xsl:when>
						<xsl:when test="SecuritySettings='5'"><xsl:value-of select="$strExternalInterfaceEnabled"/></xsl:when>
						<xsl:when test="SecuritySettings='6'"><xsl:value-of select="$strBootBypass"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strNoValue2"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</xsl:when>
		<xsl:when test="starts-with(ExtName,'SERIAL')">
			<Data name="BaseIOAddr"  editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strBaseIOAddress1"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="BaseIOAddr"/></xsl:attribute>
			</Data>
			<Data name="IrqLevel"  editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strIRQLevel1"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="IrqLevel"/></xsl:attribute>
			</Data>
			<Data name="ConnectorType"  editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strConnectorType1"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="ConnectorType='1'"><xsl:value-of select="$strOther3"/></xsl:when>
						<xsl:when test="ConnectorType='3'"><xsl:value-of select="$strDB9Male"/></xsl:when>
						<xsl:when test="ConnectorType='4'"><xsl:value-of select="$strDB9Female"/></xsl:when>
						<xsl:when test="ConnectorType='5'"><xsl:value-of select="$strDB25Male"/></xsl:when>
						<xsl:when test="ConnectorType='6'"><xsl:value-of select="$strDB25Female"/></xsl:when>
						<xsl:when test="ConnectorType='7'"><xsl:value-of select="$strRJ11"/></xsl:when>
						<xsl:when test="ConnectorType='8'"><xsl:value-of select="$strRJ45"/></xsl:when>
						<xsl:when test="ConnectorType='9'"><xsl:value-of select="$strProprietary2"/></xsl:when>
						<xsl:when test="ConnectorType='10'"><xsl:value-of select="$strCircularDIN8Male"/></xsl:when>
						<xsl:when test="ConnectorType='11'"><xsl:value-of select="$strCircularDIN8Female"/></xsl:when>
						<xsl:when test="ConnectorType='160'"><xsl:value-of select="$strMiniCentronicsType14"/></xsl:when>
						<xsl:when test="ConnectorType='161'"><xsl:value-of select="$strMiniCentronicsType26"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strNoValue3"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			<Data name="Capabilities"  editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strCapabilities1"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="ConnectorType='1'"><xsl:value-of select="$strOther4"/></xsl:when>
						<xsl:when test="ConnectorType='3'"><xsl:value-of select="$strXTATCompatible"/></xsl:when>
						<xsl:when test="ConnectorType='4'"><xsl:value-of select="$str16450Compatible"/></xsl:when>
						<xsl:when test="ConnectorType='5'"><xsl:value-of select="$str16550Compatible"/></xsl:when>
						<xsl:when test="ConnectorType='6'"><xsl:value-of select="$str16550ACompatible"/></xsl:when>
						<xsl:when test="ConnectorType='160'"><xsl:value-of select="$str8251Compatible"/></xsl:when>
						<xsl:when test="ConnectorType='161'"><xsl:value-of select="$str8251FIFOCompatible"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strNoValue4"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			<Data name="MaxSpeed"  editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strMaximumSpeed"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="MaxSpeed"/></xsl:attribute>
			</Data>
			<Data name="SecuritySettings"  editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strSecuritySettings1"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="SecuritySettings='1'"><xsl:value-of select="$strOther5"/></xsl:when>
						<xsl:when test="SecuritySettings='3'"><xsl:value-of select="$strNone1"/></xsl:when>
						<xsl:when test="SecuritySettings='4'"><xsl:value-of select="$strExternalInterfaceLocked1"/></xsl:when>
						<xsl:when test="SecuritySettings='5'"><xsl:value-of select="$strExternalInterfaceEnabled1"/></xsl:when>
						<xsl:when test="SecuritySettings='6'"><xsl:value-of select="$strBootBypass1"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strNoValue5"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</xsl:when>
		<xsl:otherwise>
			<Data name="ConnectorType"  editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strConnectorType2"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="ConnectorType='1'"><xsl:value-of select="$strOther6"/></xsl:when>
						<xsl:when test="ConnectorType='3'"><xsl:value-of select="$strMiniDIN"/></xsl:when>
						<xsl:when test="ConnectorType='4'"><xsl:value-of select="$strMicroDIN"/></xsl:when>
						<xsl:when test="ConnectorType='5'"><xsl:value-of select="$strPS22"/></xsl:when>
						<xsl:when test="ConnectorType='6'"><xsl:value-of select="$strInfrared"/></xsl:when>
						<xsl:when test="ConnectorType='7'"><xsl:value-of select="$strHPHIL"/></xsl:when>
						<xsl:when test="ConnectorType='8'"><xsl:value-of select="$strDB9"/></xsl:when>
						<xsl:when test="ConnectorType='9'"><xsl:value-of select="$strAccessBusUSB"/></xsl:when>
						<xsl:when test="ConnectorType='160'"><xsl:value-of select="$strPC982"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strNoValue6"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			<Data name="SecuritySettings"  editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strSecuritySettings2"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="SecuritySettings='1'"><xsl:value-of select="$strOther7"/></xsl:when>
						<xsl:when test="SecuritySettings='3'"><xsl:value-of select="$strNone2"/></xsl:when>
						<xsl:when test="SecuritySettings='4'"><xsl:value-of select="$strExternalInterfaceLocked2"/></xsl:when>
						<xsl:when test="SecuritySettings='5'"><xsl:value-of select="$strExternalInterfaceEnabled2"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strNoValue7"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			<Data name="SmbiosConnType"  editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strSMBIOSConnectorType"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="SmbiosConnType='1'"><xsl:value-of select="$strNone3"/></xsl:when>
						<xsl:when test="SmbiosConnType='1'"><xsl:value-of select="$strCentronics"/></xsl:when>
						<xsl:when test="SmbiosConnType='2'"><xsl:value-of select="$strMiniCentronics"/></xsl:when>
						<xsl:when test="SmbiosConnType='3'"><xsl:value-of select="$strProprietary3"/></xsl:when>
						<xsl:when test="SmbiosConnType='4'"><xsl:value-of select="$strDB25PinMale"/></xsl:when>
						<xsl:when test="SmbiosConnType='5'"><xsl:value-of select="$strDB25PinFemale"/></xsl:when>
						<xsl:when test="SmbiosConnType='6'"><xsl:value-of select="$strDB15PinMale"/></xsl:when>
						<xsl:when test="SmbiosConnType='7'"><xsl:value-of select="$strDB15PinFemale"/></xsl:when>
						<xsl:when test="SmbiosConnType='8'"><xsl:value-of select="$strDB9PinMale"/></xsl:when>
						<xsl:when test="SmbiosConnType='9'"><xsl:value-of select="$strDB9PinFemale"/></xsl:when>
						<xsl:when test="SmbiosConnType='10'"><xsl:value-of select="$strRJ111"/></xsl:when>
						<xsl:when test="SmbiosConnType='11'"><xsl:value-of select="$strRJ451"/></xsl:when>
						<xsl:when test="SmbiosConnType='12'"><xsl:value-of select="$str50PinMiniSCSI"/></xsl:when>
						<xsl:when test="SmbiosConnType='13'"><xsl:value-of select="$strMiniDIN1"/></xsl:when>
						<xsl:when test="SmbiosConnType='14'"><xsl:value-of select="$strMicroDIN1"/></xsl:when>
						<xsl:when test="SmbiosConnType='15'"><xsl:value-of select="$strPS23"/></xsl:when>
						<xsl:when test="SmbiosConnType='16'"><xsl:value-of select="$strInfrared1"/></xsl:when>
						<xsl:when test="SmbiosConnType='17'"><xsl:value-of select="$strHPHIL1"/></xsl:when>
						<xsl:when test="SmbiosConnType='18'"><xsl:value-of select="$strAccessBusUSB1"/></xsl:when>
						<xsl:when test="SmbiosConnType='19'"><xsl:value-of select="$strSSASCSI"/></xsl:when>
						<xsl:when test="SmbiosConnType='20'"><xsl:value-of select="$strCircularDIN8Male1"/></xsl:when>
						<xsl:when test="SmbiosConnType='21'"><xsl:value-of select="$strCircularDIN8Female1"/></xsl:when>
						<xsl:when test="SmbiosConnType='22'"><xsl:value-of select="$strOnBoardIDE"/></xsl:when>
						<xsl:when test="SmbiosConnType='23'"><xsl:value-of select="$strOnBoardFloppy"/></xsl:when>
						<xsl:when test="SmbiosConnType='24'"><xsl:value-of select="$str9PinDual"/></xsl:when>
						<xsl:when test="SmbiosConnType='25'"><xsl:value-of select="$str25PinDual"/></xsl:when>
						<xsl:when test="SmbiosConnType='26'"><xsl:value-of select="$str50PinDual"/></xsl:when>
						<xsl:when test="SmbiosConnType='27'"><xsl:value-of select="$str68PinDual"/></xsl:when>
						<xsl:when test="SmbiosConnType='28'"><xsl:value-of select="$strOnBoardSound"/></xsl:when>
						<xsl:when test="SmbiosConnType='29'"><xsl:value-of select="$strMiniCentronicsType141"/></xsl:when>
						<xsl:when test="SmbiosConnType='30'"><xsl:value-of select="$strMiniCentronicsType261"/></xsl:when>
						<xsl:when test="SmbiosConnType='31'"><xsl:value-of select="$strMinijackHeadphones"/></xsl:when>
						<xsl:when test="SmbiosConnType='32'"><xsl:value-of select="$strBNC"/></xsl:when>
						<xsl:when test="SmbiosConnType='33'"><xsl:value-of select="$str1394"/></xsl:when>
						<xsl:when test="SmbiosConnType='160'"><xsl:value-of select="$strPC983"/></xsl:when>
						<xsl:when test="SmbiosConnType='161'"><xsl:value-of select="$strPC98Hireso2"/></xsl:when>
						<xsl:when test="SmbiosConnType='162'"><xsl:value-of select="$strPCH982"/></xsl:when>
						<xsl:when test="SmbiosConnType='163'"><xsl:value-of select="$strPC98Note1"/></xsl:when>
						<xsl:when test="SmbiosConnType='164'"><xsl:value-of select="$strPC98Full1"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strOther8"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
			<Data name="IsOccupied"  editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strOccupied"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="IsOccupied='true'"><xsl:value-of select="$strYes1"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strNo1"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="PortDevice">
	<xsl:if test="TypeName">
		<Data name="TypeName"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strType"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="TypeName"/></xsl:attribute>
		</Data>
	</xsl:if>
	<xsl:if test="TypeName">
		<Data name="Layout"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strLayout"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="Layout"/></xsl:attribute>
		</Data>
	</xsl:if>
	<xsl:if test="PointingDevType">
		<Data name="PointingDevType"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strPointingDeviceType"/></xsl:attribute>
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="PointingDevType='1'"><xsl:value-of select="$strOther9"/></xsl:when>
					<xsl:when test="PointingDevType='3'"><xsl:value-of select="$strSerial"/></xsl:when>
					<xsl:when test="PointingDevType='4'"><xsl:value-of select="$strPS24"/></xsl:when>
					<xsl:when test="PointingDevType='5'"><xsl:value-of select="$strInfrared2"/></xsl:when>
					<xsl:when test="PointingDevType='6'"><xsl:value-of select="$strHPHIL2"/></xsl:when>
					<xsl:when test="PointingDevType='6'"><xsl:value-of select="$strBusMouse"/></xsl:when>
					<xsl:when test="PointingDevType='6'"><xsl:value-of select="$strADB"/></xsl:when>
					<xsl:when test="PointingDevType='160'"><xsl:value-of select="$strDB91"/></xsl:when>
					<xsl:when test="PointingDevType='161'"><xsl:value-of select="$strMicroDIN2"/></xsl:when>
					<xsl:when test="PointingDevType='162'"><xsl:value-of select="$strAccessBusUSB2"/></xsl:when>
					<xsl:when test="PointingDevType='163'"><xsl:value-of select="$strPC984"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$strNoValue8"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	</xsl:if>
	<xsl:if test="NumButtons">
		<Data name="NumButtons"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strNumberOfButtons"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="NumButtons"/></xsl:attribute>
		</Data>
	</xsl:if>
</xsl:template>

<xsl:template match="*"/>

</xsl:stylesheet>
