<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:strip-space elements="*"/>
	<xsl:output method="xml" indent="no"/>
	<xsl:variable name="PasswdProtected" select="/OMA/HIIFQDDObj/bPasswdProtected"/>
	<xsl:variable name="isSetPwd" select="/OMA/isSetPwd"/>
	<xsl:variable name="isSubmitPwd" select="/OMA/isSubmitPwd"/>
	<xsl:template match="/OMA">
		<xsl:choose>
      <xsl:when test="(SMStatus = '0' ) and (HIIFormObj/hdr/FQDD ='BIOS.Setup.1-1') and (@cli='true')">
        <xsl:call-template name="HIICLI"/>
      </xsl:when>
      <xsl:when test="(SMStatus = '0' ) and (HIIFormObj/hdr/FQDD ='BIOS.Setup.1-1') ">
        <xsl:call-template name="GUIHII"/>
      </xsl:when>
      <xsl:when test="(SMStatus = '0' ) and (BIOSSetupListCount &gt; 0) ">
        <xsl:call-template name="success"/>
      </xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="failure"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="failure">
		<DataArea>
			<PageTitle>
				<xsl:choose>
					<xsl:when test="SMStatus = '256'">
						<xsl:attribute name="display"><xsl:value-of select="$strErrorNo"/><xsl:call-template name="smstatus"><xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="display"><xsl:value-of select="$strError"/><xsl:call-template name="smstatus"><xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</PageTitle>
		</DataArea>
	</xsl:template>
<xsl:template name="GUIHII">
<DataArea>

<xsl:if test="$PasswdProtected = 'true'">
	<xsl:attribute name="submitform">true</xsl:attribute>
	<xsl:attribute name="submit">./DataArea?plugin=com.dell.hip.webplugins.biossetupWebPlugin&amp;help=hiiBiosSetup&amp;submitPwd=true</xsl:attribute>
</xsl:if>

<script language="javascript">


function submit_pwd()
{

	document.getElementById("dataarea").action=top.gnv.appendVID('./DataArea?plugin=com.dell.hip.webplugins.biossetupWebPlugin&amp;help=hiiBiosSetup&amp;submitPwd=true');
	document.getElementById("dataarea").submit();
}




</script>

	<PageTitle>
		<xsl:attribute name="display"><xsl:value-of select="$strSystemBIOS"/></xsl:attribute>
	</PageTitle>
	<CustomButton>
		<Data name="Refresh">
			<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
			<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.biossetupWebPlugin&amp;help=hiiBiosSetup</xsl:attribute>
		</Data>
	</CustomButton>
	
	

	<xsl:choose>
	<xsl:when test="$PasswdProtected = 'true' and $isSetPwd = 'true' and $isSubmitPwd = 'true'">

				<AlertMessage>
					<xsl:attribute name="display"><xsl:value-of select="$strPasswordSuccess"/></xsl:attribute>
					<xsl:attribute name="status">2</xsl:attribute>
				</AlertMessage>

	</xsl:when>
	<xsl:when test="$PasswdProtected = 'true' and $isSetPwd = 'false' and $isSubmitPwd = 'true'">

				<AlertMessage>
					<xsl:attribute name="display"><xsl:value-of select="$strPasswordFailure"/></xsl:attribute>
					<xsl:attribute name="status">4</xsl:attribute>
				</AlertMessage>
			

	</xsl:when>
	<xsl:when test="$PasswdProtected = 'true' and $isSetPwd = 'false'">

				<AlertMessage>
					<xsl:attribute name="display"><xsl:value-of select="$strPasswordwarn"/></xsl:attribute>
					<xsl:attribute name="status">3</xsl:attribute>
				</AlertMessage>
			

	</xsl:when>
	<xsl:otherwise></xsl:otherwise>
	
	</xsl:choose>
	<xsl:if test="$PasswdProtected = 'true' and $isSetPwd = 'false'">


		<ListData>
			<Data name="Password" type="password" splcase="true" editable="true" value="" maxlength="32">
				<xsl:attribute name="display"><xsl:value-of select="$strEnterPassword"/></xsl:attribute>			
				<xsl:attribute name="size">27</xsl:attribute>
				<ExtraItem type="button">
					<xsl:attribute name="href">javascript:submit_pwd()</xsl:attribute> 
					<xsl:attribute name="value"><xsl:value-of select="$strSubmit"/></xsl:attribute>
					<xsl:attribute name="tablebutton">true</xsl:attribute>
				</ExtraItem>							
		</Data>

	</ListData>

</xsl:if>
	
<!--
This codeprints the top level nodes, nodes whose attribute ParentName is null.
After printing a parent, there child are printed by calling the template printChild.
The parameters to printChild are the present node name, defaults spaces and present spaces.
-->
	
	<TableData columnspacing="true" >				
		<Header value="NewGeneral">
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strSystemBIOS"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strSystemBIOS"/></xsl:attribute>
			</Data>
		</Header>
			<xsl:for-each select="/OMA/HIIFormObj[ParentName/@isnull='true']">
			    <xsl:sort select="hdr/displayIndex" data-type="number" order="ascending"/>
				<xsl:if test="hdr/Name!='SysBiosSettingsForm'">
					<!-- TableData trims spaces, so using &#160; to get rid of it.  -->
					<xsl:variable name="DefSpaces" select="'&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;'" />
					<Row>		   		
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="hdr/DisplayName"/></xsl:attribute>							
							<xsl:attribute name="value"><xsl:value-of select="hdr/DisplayName"/></xsl:attribute>
							<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.biosobjinfoWebPlugin&amp;rciboot=true&amp;ons=<xsl:value-of select="@ons"/>&amp;help=<xsl:value-of select="hdr/Name"/></xsl:attribute>
							<xsl:attribute name="link">true</xsl:attribute>
							<xsl:attribute name="display"><xsl:value-of select="hdr/Description"/></xsl:attribute>
						</Data>		
					</Row>
					<xsl:call-template name="PrintChild">
						<xsl:with-param name="ParentNode" select="hdr/Name" />
						<xsl:with-param name="DefSpaces" select="$DefSpaces" />
						<xsl:with-param name="CurSpaces" select="$DefSpaces" />
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>	
	</TableData>
</DataArea>
</xsl:template>


<xsl:template name="PrintChild">
<xsl:param name="ParentNode"/>
<xsl:param name="DefSpaces"/>
<xsl:param name="CurSpaces"/>
	<xsl:for-each select="/OMA/HIIFormObj[ParentName=$ParentNode]">
		<xsl:sort select="hdr/displayIndex" data-type="number" order="ascending"/>
		<xsl:if test="hdr/Name!='SysBiosSettingsForm'">
			<Row>		   		
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="concat($CurSpaces,hdr/DisplayName)"/></xsl:attribute>							
					<xsl:attribute name="value"><xsl:value-of select="concat($CurSpaces,hdr/DisplayName)"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.biosobjinfoWebPlugin&amp;ons=<xsl:value-of select="@ons"/>&amp;help=<xsl:value-of select="hdr/Name"/></xsl:attribute>
					<xsl:attribute name="link">true</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="hdr/Description"/></xsl:attribute>
				</Data>		
			</Row>
			<xsl:call-template name="PrintChild">
				<xsl:with-param name="ParentNode" select="hdr/Name" />
				<xsl:with-param name="DefSpaces" select="$DefSpaces" />
				<xsl:with-param name="CurSpaces" select="concat($CurSpaces,$DefSpaces)" />
			</xsl:call-template>
		</xsl:if>
	</xsl:for-each>	
</xsl:template>



<!--
The template HIICLI prints the top level nodes, nodes whose attribute ParentName is null.
After printing a parent, there child are printed by calling the template printCLIChild.
The parameters to printCLIChild are the present node name, present tabs, and defaults tabs.
Present tabs are used to concat tabs before printing the name.
Default tabs are used to concat tabs to present tabs before calling printCLI recursively.
-->

<xsl:template name="HIICLI">
<DataArea>
	<PageTitle>
		<xsl:attribute name="display"><xsl:value-of select="$strBIOSSetup"/></xsl:attribute>
	</PageTitle>
	<ListData type="custom">	
		<xsl:for-each select="HIIFormObj[ParentName/@isnull = 'true']">	
			<xsl:sort select="hdr/displayIndex" order="ascending" data-type="number"/>
			<xsl:if test="hdr/bSuppressed='false' and hdr/Name!='SysBiosSettingsForm'">
				
				<Data emptyline="true"/>        
				<Data emptyvalue="true">          
				
					<xsl:attribute name="display"><xsl:value-of select="hdr/DisplayName"/></xsl:attribute>
				</Data>
				<Data emptyvalue="true">
				   <xsl:attribute name="display">------------------------------------------</xsl:attribute>
				</Data>
					<xsl:variable name="formons"><xsl:value-of select="@ons"/></xsl:variable>		
				<xsl:apply-templates select="../HIIEnumObj | ../HIIStringObj | ../HIIIntegerObj | ../HIIOrderedListObj">
					<xsl:sort select="hdr/displayIndex" data-type="number" order="ascending"/>
					<xsl:with-param name="formons" select="$formons"/>
				</xsl:apply-templates>
				<xsl:variable name="Tabs" select="'    '" />
				<xsl:call-template name="printCLIChild">
					<xsl:with-param name="ParentNode" select="hdr/Name" />
					<xsl:with-param name="TabLength" select="$Tabs" />
					<xsl:with-param name="Tabs" select="$Tabs" />
				</xsl:call-template>
			</xsl:if>      	
		</xsl:for-each>  
	</ListData>
</DataArea>
</xsl:template>

<xsl:template name="printCLIChild">
	<xsl:param name="ParentNode" />
	<xsl:param name="TabLength" />
	<xsl:param name="Tabs" />
	<xsl:for-each select="../HIIFormObj[ParentName=$ParentNode]">
		<xsl:sort select="hdr/displayIndex" order="ascending" data-type="number"/>
			<xsl:if test="hdr/bSuppressed='false' and hdr/Name!='SysBiosSettingsForm'">
				<Data emptyline="true"/>
				<Data emptyvalue="true">          	
					<xsl:attribute name="display"><xsl:value-of select="concat($TabLength,hdr/DisplayName)"/></xsl:attribute>
				</Data>
				<Data emptyvalue="true">
				   <xsl:attribute name="display"><xsl:value-of select="concat($TabLength,'------------------------------------------')"/></xsl:attribute>
				</Data>
					<xsl:variable name="formons"><xsl:value-of select="@ons"/></xsl:variable>	
				<xsl:variable name="tempNode" select="hdr/Name" />
				<xsl:variable name="FormEnumCount" select="count(..//HIIEnumObj[(hdr/bSuppressed = 'false') and (hdr/bReadOnly = 'false') and (substring-before(@ons,'/HIIEnumObj') = $formons)])"/>
				<xsl:variable name="FormStringCount" select="count(..//HIIStringObj[(hdr/bSuppressed = 'false') and (hdr/bReadOnly = 'false') and (substring-before(@ons, '/HIIStringObj') = $formons)])"/>
				<xsl:variable name="FormIntegerCount" select="count(..//HIIIntegerObj[(hdr/bSuppressed = 'false') and (hdr/bReadOnly = 'false') and (substring-before(@ons,'/HIIIntegerObj') = $formons)])"/>
				<xsl:variable name="FormOrderedListCount" select="count(..//HIIOrderedListObj[(hdr/bSuppressed = 'false') and (hdr/bReadOnly = 'false') and (substring-before(@ons,'/HIIOrderedListObj') = $formons)])"/>
				<xsl:variable name="FormChildCount" select="count(..//HIIFormObj[(ParentName=$tempNode)])"/>
				
				<xsl:choose>
				<xsl:when test = "$FormEnumCount > '0' or $FormStringCount > '0' or $FormIntegerCount > '0' or $FormOrderedListCount > '0' or $FormChildCount > '0'">					
				<xsl:apply-templates select="../HIIEnumObj | ../HIIStringObj | ../HIIIntegerObj | ../HIIOrderedListObj">
					<xsl:sort select="hdr/displayIndex" data-type="number" order="ascending"/>
					<xsl:with-param name="formons" select="$formons"/>
					<xsl:with-param name="TabLength" select="$TabLength"/>
				</xsl:apply-templates>
				</xsl:when>
				<xsl:otherwise>
					<Data emptyvalue="true">          	
					<xsl:attribute name="display"><xsl:value-of select="concat($TabLength,'No Properties')"/></xsl:attribute>
				</Data>
				</xsl:otherwise>
				</xsl:choose>
				
				<xsl:call-template name="printCLIChild">
					<xsl:with-param name="ParentNode" select="hdr/Name" />
					<xsl:with-param name="TabLength" select="concat($TabLength,$Tabs)" />
					<xsl:with-param name="Tabs" select="$Tabs" />
				</xsl:call-template>
			</xsl:if> 
	</xsl:for-each>
</xsl:template>


<xsl:template match="HIIEnumObj">
	<xsl:param name="formons"/>
	<xsl:param name="TabLength"/>
	<xsl:if test="hdr/bSuppressed='false'">
		<xsl:variable name="subons"><xsl:value-of select="substring-before(@ons,'/HIIEnumObj')"/></xsl:variable>
			<xsl:if test ="$formons = $subons">
				<xsl:variable name="attrState">
				<xsl:choose>
					<xsl:when test="bPendingValid ='true'">
						<xsl:value-of select="pendingState"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="currentState"/>
					</xsl:otherwise>
				</xsl:choose>	
				</xsl:variable>
				<xsl:choose>
					<xsl:when test ="numDependencies &gt; '0'">
						<xsl:variable name="strDepcheck"><xsl:call-template name="depsAttributeCheck"/></xsl:variable>
						<xsl:if test ="$strDepcheck &gt; '0'">
							<xsl:call-template name="EnumObjattrDeps">									
								<xsl:with-param name="attrState"><xsl:value-of select="$attrState"/></xsl:with-param>
								<xsl:with-param name="TabLength"><xsl:value-of select="$TabLength"/></xsl:with-param>
							</xsl:call-template>			
						</xsl:if>
					</xsl:when>
					<xsl:otherwise>					
						<xsl:call-template name="EnumObjattrDeps">				
							<xsl:with-param name="attrState"><xsl:value-of select="$attrState"/></xsl:with-param>	
							<xsl:with-param name="TabLength"><xsl:value-of select="$TabLength"/></xsl:with-param>
						</xsl:call-template>							
					</xsl:otherwise>
				</xsl:choose>
		</xsl:if>
	</xsl:if>
</xsl:template>
	
<xsl:template match="HIIStringObj">
	<xsl:param name="formons"/>
	<xsl:param name="TabLength"/>
	<xsl:if test="hdr/bSuppressed='false'">
		<xsl:variable name="subons"><xsl:value-of select="substring-before(@ons,'/HIIStringObj')"/></xsl:variable>
		<xsl:if test="$formons = $subons">
			<xsl:variable name="Strvalue">
			<xsl:choose>
				<xsl:when test="Pending/@isnull and Pending/@isnull =  'true'">
					<xsl:value-of select="Current"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="Pending"/>
				</xsl:otherwise>
			</xsl:choose>	
			</xsl:variable>
			<xsl:choose>				
				<xsl:when test = "numDependencies &gt; '0'">			    
				<xsl:variable name="strDepcheck"><xsl:call-template name="depsAttributeCheck"/></xsl:variable>				
				<xsl:if test="$strDepcheck &gt; '0'">
					<xsl:call-template name="str_pending_current">					
						<xsl:with-param name="Strvalue"><xsl:value-of select="$Strvalue"/></xsl:with-param>
						<xsl:with-param name="TabLength"><xsl:value-of select="$TabLength"/></xsl:with-param>
					</xsl:call-template>
				</xsl:if>							
				</xsl:when>
				<xsl:otherwise>				
					<xsl:call-template name="str_pending_current">					
						<xsl:with-param name="Strvalue"><xsl:value-of select="$Strvalue"/></xsl:with-param>
						<xsl:with-param name="TabLength"><xsl:value-of select="$TabLength"/></xsl:with-param>
					</xsl:call-template>						
				</xsl:otherwise>
				</xsl:choose>								
		</xsl:if>
	</xsl:if>
</xsl:template>
	
<xsl:template match="HIIIntegerObj">
	<xsl:param name="formons"/>		
	<xsl:param name="TabLength"/>
	<xsl:if test="hdr/bSuppressed='false'">
		<xsl:variable name="subons"><xsl:value-of select="substring-before(@ons,'/HIIIntegerObj')"/></xsl:variable>
		<xsl:if test="$formons = $subons">
			<xsl:choose>						
	            <xsl:when test = "numDependencies &gt; '0'">
				 <xsl:variable name="strDepcheck"><xsl:call-template name="depsAttributeCheck"/></xsl:variable>
					<xsl:if test="$strDepcheck &gt; '0'">
						<xsl:call-template name="int_pending_current">
							<xsl:with-param name="TabLength"><xsl:value-of select="$TabLength"/></xsl:with-param>
						</xsl:call-template>
					</xsl:if>	
				</xsl:when>					
				<xsl:otherwise>														
					<xsl:call-template name="int_pending_current">		
						<xsl:with-param name="TabLength"><xsl:value-of select="$TabLength"/></xsl:with-param>
					</xsl:call-template>					
				</xsl:otherwise>										
			</xsl:choose>
		</xsl:if>
	</xsl:if>		
</xsl:template>

<xsl:template match="HIIOrderedListObj">
<xsl:param name="formons"/>		
<xsl:param name="TabLength"/>
	<xsl:if test="hdr/bSuppressed='false'">
		<xsl:variable name="subons"><xsl:value-of select="substring-before(@ons,'/HIIOrderedListObj')"/></xsl:variable>
		<xsl:if test="$formons = $subons">
			<xsl:choose>
			<xsl:when test = "numDependencies &gt; '0'">
			<xsl:variable name="strDepcheck"><xsl:call-template name="depsAttributeCheck"/></xsl:variable>				
				<xsl:if test="$strDepcheck &gt; '0'">
					<xsl:call-template name="OrdListEntObj">
						<xsl:with-param name="strAllowEnDisEntries"><xsl:value-of select="bAllowEnDisEntries"/></xsl:with-param>
						<xsl:with-param name="TabLength"><xsl:value-of select="$TabLength"/></xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>										
				<xsl:call-template name="OrdListEntObj">
						<xsl:with-param name="strAllowEnDisEntries"><xsl:value-of select="bAllowEnDisEntries"/></xsl:with-param>
						<xsl:with-param name="TabLength"><xsl:value-of select="$TabLength"/></xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:if>	
</xsl:template>

<xsl:template name="depsAttributeCheck">
	<xsl:for-each select ="dependenciesarray/dependencies">				
		<xsl:variable name="depName"><xsl:value-of select="Name"/> </xsl:variable>
		<xsl:variable name="depvalue"><xsl:value-of select="Value"/> </xsl:variable>
		<xsl:variable name="curState" select="//HIIEnumObj[hdr/Name = $depName]/currentState"/>
		<xsl:variable name="stateNum" select="//HIIEnumValueObj[Name = $depvalue]/stateNumber"/>					
		<xsl:choose>
			<xsl:when test ="(Type ='SuppressIf' and $curState != $stateNum) or (Type ='SuppressIfNot' and $curState = $stateNum) or Type ='ReadOnlyIf' or Type ='ReadOnlyIfNot'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>					
		</xsl:choose>				
	</xsl:for-each>
</xsl:template>
				
<xsl:template name="EnumObjattrDeps">	
	<xsl:param name="attrState"/>
	<xsl:param name="TabLength"/>
		<xsl:variable name="parentons"><xsl:value-of select="@ons"/></xsl:variable>			
			<Data>			
				<xsl:attribute name="display"><xsl:value-of select="concat($TabLength,hdr/DisplayName)"/></xsl:attribute>
				<xsl:for-each select="//HIIEnumValueObj[substring-before(@ons,'/HIIEnumValueObj') = $parentons]">
					<xsl:variable name="valstateNum"><xsl:value-of select="stateNumber"/></xsl:variable>
					<xsl:if test=" ($attrState = $valstateNum)">
						<xsl:attribute name="value"><xsl:value-of select="DisplayName"/> </xsl:attribute>
					</xsl:if>
				</xsl:for-each>
			</Data>			
</xsl:template>

<xsl:template name="OrdListEntObj">	
	<xsl:param name="strAllowEnDisEntries"/>
	<xsl:param name="TabLength"/>
	<xsl:variable name="parentons"><xsl:value-of select="@ons"/></xsl:variable>	
	<Data emptyline="true"/>
	<Data emptyvalue="true">
		<xsl:attribute name="display"><xsl:value-of select="concat($TabLength,hdr/DisplayName)"/></xsl:attribute>
	</Data>    
	
	<xsl:for-each select="//HIIOrderedListEntryObj[bPendingValid='true']">	
	<xsl:sort select="pendingIndex" data-type="number" order="ascending"/>
	<xsl:if test="hdr/bSuppressed='false'">
	<xsl:variable name="childons"><xsl:value-of select="substring-before(@ons,'/HIIOrderedListEntryObj')"/></xsl:variable>
	<xsl:if test="$parentons = $childons">		
		<Data>			
			<xsl:if test="$strAllowEnDisEntries='true'">
			<xsl:choose>
			<xsl:when test="bPendingEnabled='true'">
				<xsl:attribute name="value"><xsl:value-of select="pendingIndex"/>. Enabled: <xsl:value-of select="hdr/DisplayName"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="value"><xsl:value-of select="pendingIndex"/>. Disabled: <xsl:value-of select="hdr/DisplayName"/></xsl:attribute>
			</xsl:otherwise>
			</xsl:choose>	
			</xsl:if>
			<xsl:if test="$strAllowEnDisEntries='false'">			
				<xsl:attribute name="value"><xsl:value-of select="pendingIndex"/>. <xsl:value-of select="hdr/DisplayName"/></xsl:attribute>
			</xsl:if>
		</Data>	
	</xsl:if>
	</xsl:if>
	</xsl:for-each>
	
	<xsl:for-each select="//HIIOrderedListEntryObj[bPendingValid='false']">	
	<xsl:sort select="currentIndex" data-type="number" order="ascending"/>
	<xsl:if test="hdr/bSuppressed='false'">
	<xsl:variable name="childons"><xsl:value-of select="substring-before(@ons,'/HIIOrderedListEntryObj')"/></xsl:variable>
	<xsl:if test="$parentons = $childons">		
		<Data>						
		<xsl:if test="$strAllowEnDisEntries='true'">
			<xsl:choose>
			<xsl:when test="bCurrentEnabled='true'">
				<xsl:attribute name="value"><xsl:value-of select="currentIndex"/>. Enabled: <xsl:value-of select="hdr/DisplayName"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="value"><xsl:value-of select="currentIndex"/>. Disabled: <xsl:value-of select="hdr/DisplayName"/></xsl:attribute>
			</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="$strAllowEnDisEntries='false'">			
			<xsl:attribute name="value"><xsl:value-of select="currentIndex"/>. <xsl:value-of select="hdr/DisplayName"/></xsl:attribute>			
		</xsl:if>
		</Data>	
	</xsl:if>
	</xsl:if>
	</xsl:for-each>	
</xsl:template>

<xsl:template name="str_pending_current">
<xsl:param name="Strvalue"/>
<xsl:param name="TabLength"/>
<Data>
	<xsl:attribute name="display"><xsl:value-of select="concat($TabLength,hdr/DisplayName)"/></xsl:attribute>
	<xsl:attribute name="value"><xsl:value-of select="$Strvalue"/></xsl:attribute>
</Data>
</xsl:template>

<xsl:template name="int_pending_current">
<xsl:param name="TabLength"/>
	<Data>
	<xsl:attribute name="display"><xsl:value-of select="concat($TabLength,hdr/DisplayName)"/></xsl:attribute>
	<xsl:choose>
	<xsl:when test="bPendingValid ='true'">
		<xsl:attribute name="value"><xsl:value-of select="pendingValue"/></xsl:attribute>
	</xsl:when>
	<xsl:otherwise>
		<xsl:attribute name="value"><xsl:value-of select="currentValue"/></xsl:attribute>
	</xsl:otherwise>
	</xsl:choose>
	</Data>	
</xsl:template>


	<xsl:template name="success">
		<DataArea>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strBIOSSetup"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.biossetupWebPlugin&amp;help=BiosSetup</xsl:attribute>
				</Data>
			</CustomButton>
			<ListData type="custom">
				<xsl:attribute name="display"><xsl:value-of select="$strGeneral"/></xsl:attribute>
				<Header value="General">
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strGeneral"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strGeneral"/></xsl:attribute>
					</Data>
				</Header>
			    <xsl:choose>
				    <xsl:when test="OMAUserRights='7'">
					    <PromptText><xsl:value-of select="$strClickEachBIOS"/></PromptText>
				    </xsl:when>
				    <xsl:otherwise/>
			    </xsl:choose>
				
				<xsl:choose>
				   <xsl:when test="/OMA/BootDeviceObj!=''">
						<Data>
							<!-- The Attribute name need not be translated -->
							<xsl:attribute name="display">Boot Sequence</xsl:attribute>
							<xsl:if test="(/OMA/OMAUserRights='7') and (/OMA/IsTrueAdmin='true')">
								<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.biosobjinfoWebPlugin&amp;rciboot=true&amp;help=BiosSetup</xsl:attribute>
								<xsl:attribute name="link">true</xsl:attribute>
							</xsl:if>
					     <xsl:for-each select="BootDeviceObj">											
						<xsl:if test="objType='0' and IsFirstIPLDevice='true'">
							<xsl:choose> 
								<xsl:when test="deviceType='1' or deviceType='2' or deviceType='3' or deviceType='10'">								
									<xsl:attribute name="value"><xsl:value-of select="Description"/></xsl:attribute>				
								</xsl:when>


								<xsl:otherwise> 
									<xsl:attribute name="value"><xsl:value-of select="$strDeviceList"/></xsl:attribute>				
								</xsl:otherwise>

							</xsl:choose> 
						</xsl:if>						
					    </xsl:for-each>						
					</Data>
				   </xsl:when>
				<xsl:otherwise>	
					<xsl:if test="count(@objtype='247' ) &gt; 0">
						<Data>
						<xsl:for-each select="BIOSSetupList/BIOSSetup">
						<xsl:choose>
							<xsl:when test="@objtype='247'">
								<xsl:attribute name="display"><xsl:value-of select="$strBootSequence"/></xsl:attribute>
								<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.biosobjinfoWebPlugin&amp;rciboot=false&amp;oid=<xsl:value-of select="@oid"/>&amp;help=BiosSetup</xsl:attribute>
								<xsl:if test="/OMA/OMAUserRights='7'">
									<xsl:attribute name="link">true</xsl:attribute>
								</xsl:if>
							</xsl:when>
						</xsl:choose>
						</xsl:for-each>
							<xsl:attribute name="value">

								<xsl:for-each select="/OMA/BIOSSetupList/BIOSSetup">
								<xsl:choose>
									<xsl:when test="@objtype='247'">
										<xsl:choose>
											<xsl:when test="State='0'"><xsl:value-of select="$strUnknown4"/></xsl:when>
											<xsl:when test="State='1'"><xsl:value-of select="$strFloppyDisketteFirst"/></xsl:when>
											<xsl:when test="State='2'"><xsl:value-of select="$strHardDiskOnly"/></xsl:when>
											<xsl:when test="State='3'"><xsl:value-of select="$strDeviceList"/></xsl:when>
											<xsl:when test="State='4'"><xsl:value-of select="$strCDROMFirstThen"/></xsl:when>
										</xsl:choose>
									</xsl:when>
								</xsl:choose>							
								</xsl:for-each>
								</xsl:attribute>
						</Data>
				</xsl:if> 
				</xsl:otherwise>
			 </xsl:choose>

				<xsl:for-each select="BIOSSetupList/BIOSSetup">
					<xsl:choose>
						<xsl:when test="@objtype='264'">
							<xsl:variable name="raidState">
								<xsl:for-each select="/OMA/BIOSSetupList/BIOSSetup">
									<xsl:if test="@objtype='263'"><xsl:value-of select="State"/></xsl:if>
								</xsl:for-each>
							</xsl:variable>
							<xsl:choose>
								<xsl:when test="ObjName='RAID Channel A'">
										<Data>
											<xsl:attribute name="display"><xsl:value-of select="ObjName"/></xsl:attribute>
											<xsl:attribute name="value"><xsl:call-template name="state">
									<xsl:with-param name="type"><xsl:value-of select="@objtype"/></xsl:with-param><xsl:with-param name="state"><xsl:value-of select="State"/></xsl:with-param>									<xsl:with-param name="objname"><xsl:value-of select="ObjName"/></xsl:with-param>
											</xsl:call-template></xsl:attribute>
										</Data>
								</xsl:when>
								<xsl:when test="ObjName='RAID Channel B'">
									<xsl:choose>
										<xsl:when test="($raidState='3') and (Capabilities/Rdonly='false')">
												<Data>
													<xsl:attribute name="display"><xsl:value-of select="ObjName"/></xsl:attribute>
													<xsl:choose>
														<xsl:when test="/OMA/OMAUserRights='7'">
			<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.biosobjinfoWebPlugin&amp;oid=<xsl:value-of select="@oid"/>&amp;help=BiosSetup</xsl:attribute>
															<xsl:attribute name="link">true</xsl:attribute>
														</xsl:when>
														<xsl:otherwise/>
													</xsl:choose>
													<xsl:attribute name="value"><xsl:call-template name="state">
														<xsl:with-param name="type"><xsl:value-of select="@objtype"/></xsl:with-param>
														<xsl:with-param name="state"><xsl:value-of select="State"/></xsl:with-param>
														<xsl:with-param name="objname"><xsl:value-of select="ObjName"/></xsl:with-param>
														</xsl:call-template></xsl:attribute>
												</Data>
										</xsl:when>
										<xsl:otherwise>
												<Data>
													<xsl:attribute name="display"><xsl:value-of select="ObjName"/></xsl:attribute>
													<xsl:attribute name="value"><xsl:call-template name="state">
													<xsl:with-param name="type"><xsl:value-of select="@objtype"/></xsl:with-param>
													<xsl:with-param name="state"><xsl:value-of select="State"/></xsl:with-param>
													<xsl:with-param name="objname"><xsl:value-of select="ObjName"/></xsl:with-param></xsl:call-template></xsl:attribute>
												</Data>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
							</xsl:choose>
						</xsl:when>


						<xsl:when test="@objtype='451'">
								<Data name="">
									<xsl:attribute name="display"><xsl:value-of select="ObjName"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:call-template name="state"><xsl:with-param name="type"><xsl:value-of select="@objtype"/></xsl:with-param><xsl:with-param 		name="state"><xsl:value-of select="State"/></xsl:with-param><xsl:with-param name="objname"><xsl:value-of select="ObjName"/></xsl:with-param></xsl:call-template></xsl:attribute>
								</Data>						
						</xsl:when>

						
						<xsl:when test="@objtype='45057'">
								<Data name="">
									<xsl:attribute name="display"><xsl:value-of select="ObjName"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:call-template name="state"><xsl:with-param name="type"><xsl:value-of select="@objtype"/></xsl:with-param><xsl:with-param name="state"><xsl:value-of select="State"/></xsl:with-param><xsl:with-param name="objname"><xsl:value-of select="ObjName"/></xsl:with-param></xsl:call-template></xsl:attribute>
								</Data>						
						</xsl:when>						
						<xsl:otherwise>
						   <xsl:if test=" (@objtype != '247') and (@objtype != '251') and (@objtype != '267') and (@objtype !='271') and (@objtype != '374') and (@objtype != '378') and (@objtype != '379') and (@objtype != '464')">
								<Data name="">
									<xsl:attribute name="display"><xsl:value-of select="ObjName"/></xsl:attribute>
									<xsl:choose>
										<xsl:when test="/OMA/OMAUserRights='7'">
											<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.biosobjinfoWebPlugin&amp;oid=<xsl:value-of select="@oid"/>&amp;objtype=<xsl:value-of select="@objtype"/>&amp;help=BiosSetup</xsl:attribute>
											<xsl:attribute name="link">true</xsl:attribute>
										</xsl:when>
										<xsl:otherwise/>
									</xsl:choose>
									<xsl:attribute name="value"><xsl:call-template name="state"><xsl:with-param name="type"><xsl:value-of select="@objtype"/></xsl:with-param><xsl:with-param 		name="state"><xsl:value-of select="State"/></xsl:with-param><xsl:with-param name="objname"><xsl:value-of select="ObjName"/></xsl:with-param></xsl:call-template></xsl:attribute>
								</Data>
						  </xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>			
				<xsl:apply-templates select="BIOSSetupTCMExt"/>
			</ListData>
			<ListData columnspacing="true" name="SerialComm" type="custom">	
				<xsl:attribute name="display"><xsl:value-of select="$strSerialCommunications"/></xsl:attribute>
				<Header value="General">
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strSerialCommunications"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strSerialCommunications"/></xsl:attribute>
					</Data>
				</Header>
			    <xsl:choose>
				    <xsl:when test="OMAUserRights='7'">
					    <PromptText><xsl:value-of select="$strClickEachBIOS"/></PromptText>
				    </xsl:when>
				    <xsl:otherwise/>
			    </xsl:choose>
				
			    <xsl:for-each select="BIOSSetupList/BIOSSetup">
				    <xsl:if test="(@objtype='251') or (@objtype='267') or (@objtype='271') or (@objtype='374') or (@objtype='378') or (@objtype='379') or  (@objtype='464')">
						    <Data name="">
							    <xsl:attribute name="display"><xsl:value-of select="ObjName"/></xsl:attribute>
							    <xsl:choose>
								    <xsl:when test="/OMA/OMAUserRights='7'">
									    <xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.biosobjinfoWebPlugin&amp;oid=<xsl:value-of select="@oid"/>&amp;help=BiosSetup</xsl:attribute>
									    <xsl:attribute name="link">true</xsl:attribute>
								    </xsl:when>
								    <xsl:otherwise/>
							    </xsl:choose>
							    <xsl:attribute name="value"><xsl:call-template name="state"><xsl:with-param name="type"><xsl:value-of select="@objtype"/></xsl:with-param><xsl:with-param 		name="state"><xsl:value-of select="State"/></xsl:with-param><xsl:with-param name="objname"><xsl:value-of select="ObjName"/></xsl:with-param></xsl:call-template></xsl:attribute>
						    </Data>
				    </xsl:if>
				</xsl:for-each>
			</ListData>
		</DataArea>
	</xsl:template>

	<xsl:template match="BIOSSetupTCMExt">
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="/OMA/BIOSSetupTCMExt/ObjName"/></xsl:attribute>
				<xsl:attribute name="value">
					<xsl:call-template name="state">
						<xsl:with-param name="type"><xsl:value-of select="/OMA/BIOSSetupTCMExt/objtype"/></xsl:with-param>
						<xsl:with-param 	name="state"><xsl:value-of select="/OMA/BIOSSetupTCMExt/state"/></xsl:with-param>
						<xsl:with-param name="objname"><xsl:value-of select="/OMA/BIOSSetupTCMExt/ObjName"/></xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
			</Data>
	</xsl:template>

	<xsl:template name="state">
		<xsl:param name="type"/>
		<xsl:param name="state"/>
		<xsl:param name="objname"/>
		<xsl:choose>
			<xsl:when test="$type='241'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strAuto"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strWriteProtect"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='242'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown1"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisabled"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnabledwithPXE"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strEnabledWithoutPXE"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strEnabledWithISCSI"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='246'">
				<xsl:if test="$objname='Primary SCSI'">
					<xsl:choose>
						<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown2"/></xsl:when>
						<xsl:when test="$state='1'"><xsl:value-of select="$strOff2"/></xsl:when>
						<xsl:when test="$state='2'"><xsl:value-of select="$strOn"/></xsl:when>
					</xsl:choose>
				</xsl:if>
				<xsl:if test="$objname='Secondary SCSI'">
					<xsl:choose>
						<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown3"/></xsl:when>
						<xsl:when test="$state='1'"><xsl:value-of select="$strOff3"/></xsl:when>
						<xsl:when test="$state='2'"><xsl:value-of select="$strOn1"/></xsl:when>
					</xsl:choose>
				</xsl:if>
			</xsl:when>
			<xsl:when test="$type='249'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown5"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff4"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strLPT1Mode"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strLPT2Mode"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strLPT3Mode"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='250'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown6"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strATMode"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strPS2Mode"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strECPMode"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strEPPMode"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='251'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown7"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff5"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strAuto1"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strCOM1Mode"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strCOM2Mode"/></xsl:when>
					<xsl:when test="$state='5'"><xsl:value-of select="$strCOM3Mode"/></xsl:when>
					<xsl:when test="$state='6'"><xsl:value-of select="$strCOM4Mode"/></xsl:when>
					<xsl:when test="$state='7'"><xsl:value-of select="$strBMCSerialMode"/></xsl:when>
					<xsl:when test="$state='8'"><xsl:value-of select="$strBMCNicMode"/></xsl:when>
					<xsl:when test="$state='9'"><xsl:value-of select="$strBMCRacMode"/></xsl:when> 
					<xsl:when test="$state='10'"><xsl:value-of select="$strCOM1BMCMode"/></xsl:when> 					
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='252'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown8"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff6"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strOn2"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strLow"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strMedium"/></xsl:when>
					<xsl:when test="$state='5'"><xsl:value-of select="$strHigh"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='253'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown9"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisable"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnableWOLFor"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strEnableWOLFor1"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strEnableWOLFor2"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='244'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown10"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisabled1"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnabled1"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='260'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown11"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisabled2"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnabled2"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strEnabledWithBIOS"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='261'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisable"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnable"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='262'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisable"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnable"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='263'">
					<xsl:choose>
							<xsl:when test="$state='1'"><xsl:value-of select="$strOff1"/></xsl:when>
							<xsl:when test="$state='2'"><xsl:value-of select="$strSCSI"/></xsl:when>
							<xsl:when test="$state='3'"><xsl:value-of select="$strRAID"/></xsl:when>
					</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='264'">
				<xsl:choose>
						<xsl:when test="$state='1'"><xsl:value-of select="$strSCSI"/></xsl:when>
						<xsl:when test="$state='2'"><xsl:value-of select="$strRAID"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='245'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff7"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strAuto"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<!--For Dual NIC -->
			<xsl:when test="$type='265'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='41'"><xsl:value-of select="$strDisabledOS"/></xsl:when>
					<xsl:when test="$state='22'"><xsl:value-of select="$strOnBothDualNicPXE"/></xsl:when>
					<xsl:when test="$state='26'"><xsl:value-of select="$strOnDualNic2PXE"/></xsl:when>
					<xsl:when test="$state='38'"><xsl:value-of select="$strOnDualNic1PXE"/></xsl:when>
					<xsl:when test="$state='82'"><xsl:value-of select="$strOnDualNiciSCSIPXE"/></xsl:when>
					<xsl:when test="$state='98'"><xsl:value-of select="$strOnDualNic1iSCSI"/></xsl:when>
					<xsl:when test="$state='138'"><xsl:value-of select="$strOnDualNic2iSCSI"/></xsl:when>
					<xsl:when test="$state='134'"><xsl:value-of select="$strOnDualNicPXEiSCSI"/></xsl:when>
					<xsl:when test="$state='194'"><xsl:value-of select="$strOnBothDualiSCSI"/></xsl:when>
					<xsl:when test="$state='42'"><xsl:value-of select="$strOnDualNicNone"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<!--For Console Redirection -->
			<xsl:when test="$type='267'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff7"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strSerialPort1"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strSerialPort2"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strBMCNicMode"/></xsl:when>
					<xsl:when test="$state='5'"><xsl:value-of select="$strmmb"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<!--For AC Power Recovery Mode -->
			<xsl:when test="$type='368'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff7"/></xsl:when>
					<xsl:when test="$state='2'">
					 <xsl:choose>
					  <xsl:when test="RecoveryTime">
						<xsl:if test="RecoveryTime/State='1'"><xsl:value-of select="$strLast"/></xsl:if>
						<xsl:if test="RecoveryTime/State='2'"><xsl:value-of select="$strLastwithRandomDelay"/></xsl:if>
						<xsl:if test="RecoveryTime/State='3'"><xsl:value-of select="$strLastwithTimeDelay"/></xsl:if>
					   </xsl:when>
					   <xsl:otherwise>
						<xsl:value-of select="$strLast"/>
					   </xsl:otherwise>
					 </xsl:choose>
					</xsl:when>
					<xsl:when test="$state='3'">
					 <xsl:choose>
					  <xsl:when test="RecoveryTime">
						<xsl:if test="RecoveryTime/State='1'"><xsl:value-of select="$strOn"/></xsl:if>
						<xsl:if test="RecoveryTime/State='2'"><xsl:value-of select="$strOnwithRandomDelay"/></xsl:if>
						<xsl:if test="RecoveryTime/State='3'"><xsl:value-of select="$strOnwithTimeDelay"/></xsl:if>
					   </xsl:when>
					   <xsl:otherwise>
						<xsl:value-of select="$strOn"/>
					   </xsl:otherwise>
					 </xsl:choose>
					</xsl:when>
				</xsl:choose>
			</xsl:when>

			<!-- Embedded SATA 2 Controller  -->
			<xsl:when test="$type='369'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff7"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strSATAcombined"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strSATAata"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strSATAahci"/></xsl:when>
					<xsl:when test="$state='5'"><xsl:value-of select="$strSATAraid"/></xsl:when>
					<xsl:when test="$state='6'"><xsl:value-of select="$strSATAqdma"/></xsl:when>
				</xsl:choose>
			</xsl:when>

			<!-- Embedded SATA 2 Port  -->
			<xsl:when test="$type='370'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff7"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strAuto"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			
			<!-- IDE Primary Drive  -->
			<xsl:when test="$type='371'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff7"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strAuto"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			
			<!--For DBS -->
			<xsl:when test="$type='372'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisabled"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnabled"/></xsl:when>
				</xsl:choose>
			</xsl:when>

			<!--For Console Redirection FailSafe BAUD Rate -->
			<xsl:when test="$type='271'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strFBRnone"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strFBR115200"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strFBR57600"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strFBR19200"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strFBR9600"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			
			<!--For Console Redirection After Boot(CRAB) -->
			<xsl:when test="$type='374'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strEnabled"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strDisabled"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			
		    <!--For Serial Communication -->
			<xsl:when test="$type='378'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strOnWithoutCR"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strOnWithCRCOM1"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strOnWithCRCOM2"/></xsl:when>
					<xsl:when test="$state='5'"><xsl:value-of select="$strOnWithCR"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			
		    <!--For External Serial Connector -->
			<xsl:when test="$type='379'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strNotConnected"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strCOM1Mode"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strCOM2Mode"/></xsl:when>
				        <xsl:when test="$state='9'"><xsl:value-of select="$strRemoteAccessDevice"/></xsl:when>
					<xsl:when test="$state='14'"><xsl:value-of select="$strSerialDevice1"/></xsl:when> 
					<xsl:when test="$state='15'"><xsl:value-of select="$strSerialDevice2"/></xsl:when> 
			        </xsl:choose>
			</xsl:when>

		    <!--For User Accessible USB Ports -->
			<xsl:when test="$type='375'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strAllOff"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strBackOn"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strAllOn"/></xsl:when>
				</xsl:choose>
			</xsl:when>

		    <!--For CPU Virtualization Technology -->
			<xsl:when test="$type='380'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisabled"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnabled"/></xsl:when>
				</xsl:choose>
			</xsl:when>

		    <!--For CPU HyperThreading -->
			<xsl:when test="$type='381'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strEnabled"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strDisabled"/></xsl:when>
				</xsl:choose>
			</xsl:when>

			<xsl:when test="$type='451'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisabled"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnabled"/></xsl:when>
				</xsl:choose>
			</xsl:when>


		   <!--For TPM -->	
			<xsl:when test="$type='45057'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strOff1"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOnWithPreBoot"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strOnWithOutPreBoot"/></xsl:when>
				</xsl:choose>
			</xsl:when>
		
		<!--TCM Support-->
			<xsl:when test="$type='45064'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strOff1"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOn1"/></xsl:when>
				</xsl:choose>
			</xsl:when>
		   <!--For Internal USB -->	
			<xsl:when test="$type='454'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisabled"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnabled"/></xsl:when>
				</xsl:choose>
			</xsl:when>		
			<!-- HyperVisor -->
			<xsl:when test="$type='455'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisabled"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnabled"/></xsl:when>
				</xsl:choose>
			</xsl:when>						
		   	<!--For Optical Drive Controller -->	
			<xsl:when test="$type='456'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strEnabled"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strDisabled"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<!--For CPU XD Support -->
			<xsl:when test="$type='382'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisabled"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnabled"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<!--For Multi Core Processor -->
			<xsl:when test="$type='457'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strAll"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strOne"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strTwo"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strFour"/></xsl:when>
					<xsl:when test="$state='5'"><xsl:value-of select="$strSix"/></xsl:when>
					<xsl:when test="$state='6'"><xsl:value-of select="$strEight"/></xsl:when>
					<xsl:when test="$state='7'"><xsl:value-of select="$strTen"/></xsl:when>
					<xsl:when test="$state='8'"><xsl:value-of select="$strTwelve"/></xsl:when>
					<xsl:when test="$state='9'"><xsl:value-of select="$strFourteen"/></xsl:when>
	                <xsl:when test="$state='10'"><xsl:value-of select="$strSixteen"/></xsl:when> 			
				</xsl:choose>
			</xsl:when>

			<!--For Embedded Video Controller -->
			<xsl:when test="$type='460'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strEnabled"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strDisabled"/></xsl:when>
				</xsl:choose>
			</xsl:when>

			<!--For Boot Mode -->
			<xsl:when test="$type='462'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strBios"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strUEFI"/></xsl:when>
				</xsl:choose>
			</xsl:when>

			<!--For CPU C  States -->
			<xsl:when test="$type='461'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strEnabled"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strDisabled"/></xsl:when>
				</xsl:choose>
			</xsl:when>

		      <!--Optical Drive Controller -->				
		     	<!--For NUMA  or CPU Turbo Mode -->	
			<xsl:when test="$type='453' or  $type='458' ">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisabled"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnabled"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='464'">
				<xsl:choose>					
					<xsl:when test="$state='1'"><xsl:value-of select="$strSerialPortDefAddr"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strSerialPortAltAddr"/></xsl:when>
					<xsl:when test="$state='3'"><xsl:value-of select="$strCOM1"/></xsl:when>
					<xsl:when test="$state='4'"><xsl:value-of select="$strCOM2"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<!--CPU HT Assist -->
			<xsl:when test="$type='465'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strEnabled"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strDisabled"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='466'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strEnabled"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strDisabled"/></xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$type='550'">
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff7"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strAuto"/></xsl:when>
				</xsl:choose>
			</xsl:when>
		      <xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$state='0'"><xsl:value-of select="$strUnknown12"/></xsl:when>
					<xsl:when test="$state='1'"><xsl:value-of select="$strOff7"/></xsl:when>
					<xsl:when test="$state='2'"><xsl:value-of select="$strOn3"/></xsl:when>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:param name="mssg"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><xsl:value-of select="$strCommandUnsuccessful"/></xsl:when>
			<xsl:when test="$status = '1'"><xsl:value-of select="$strCommandNotImplemented"/></xsl:when>
			<xsl:when test="$status = '2'"><xsl:value-of select="$strBadCommand"/></xsl:when>
			<xsl:when test="$status = '3'"><xsl:value-of select="$strCommandTimeout"/></xsl:when>
			<xsl:when test="$status = '4'"><xsl:value-of select="$strCommandCancelled"/></xsl:when>
			<xsl:when test="$status = '5'"><xsl:value-of select="$strCommandAborted"/></xsl:when>
			<xsl:when test="$status = '6'"><xsl:value-of select="$strCommandPending"/></xsl:when>
			<xsl:when test="$status = '7'"><xsl:value-of select="$strNoSuchDevice"/></xsl:when>
			<xsl:when test="$status = '8'"><xsl:value-of select="$strDeviceBusy"/></xsl:when>
			<xsl:when test="$status = '9'"><xsl:value-of select="$strBadDevice"/></xsl:when>
			<xsl:when test="$status = '10'"><xsl:value-of select="$strSpuriousInterrupt"/></xsl:when>
			<xsl:when test="$status = '11'"><xsl:value-of select="$strResourceLocked"/></xsl:when>
			<xsl:when test="$status = '12'"><xsl:value-of select="$strInvalidIndex"/></xsl:when>
			<xsl:when test="$status = '13'"><xsl:value-of select="$strSMBError"/></xsl:when>
			<xsl:when test="$status = '14'"><xsl:value-of select="$strDataRequestedIs"/></xsl:when>
			<xsl:when test="$status = '15'"><xsl:value-of select="$strDataRequestedIs1"/></xsl:when>
			<xsl:when test="$status = '16'"><xsl:value-of select="$strDataRequestedIs2"/></xsl:when>
			<xsl:when test="$status = '17'"><xsl:value-of select="$strDeviceNotYet"/></xsl:when>
			<xsl:when test="$status = '18'"><xsl:value-of select="$strDeviceDoesNot"/></xsl:when>
			<xsl:when test="$status = '19'"><xsl:value-of select="$strDeviceOutOf"/></xsl:when>
			<xsl:when test="$status = '20'"><xsl:value-of select="$strDeviceAlreadyExists"/></xsl:when>
			<xsl:when test="$status = '256'"><xsl:value-of select="$strBIOSSetupFound"/></xsl:when>
			<xsl:when test="$status = '257'"><xsl:value-of select="$strBIOSSetupMalformed"/></xsl:when>
			<xsl:when test="$status = '258'"><xsl:value-of select="$strBIOSSetupAlready"/></xsl:when>
			<xsl:when test="$status = '260'"><xsl:value-of select="$strINIFileNot"/></xsl:when>
			<xsl:when test="$status = '261'"><xsl:value-of select="$strINIMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '262'"><xsl:value-of select="$strINISectionDoes"/></xsl:when>
			<xsl:when test="$status = '263'"><xsl:value-of select="$strINIKeyDoes"/></xsl:when>
			<xsl:when test="$status = '264'"><xsl:value-of select="$strINIValueMalformed"/></xsl:when>
			<xsl:when test="$status = '270'"><xsl:value-of select="$strInsufficientAccessRights"/></xsl:when>
			<xsl:when test="$status = '271'"><xsl:value-of select="$strInvalidParameterName"/><xsl:value-of select="$mssg"/></xsl:when>
			<xsl:when test="$status = '272'"><xsl:value-of select="$strOutOfMemory"/></xsl:when>
			<xsl:when test="$status = '280'"><xsl:value-of select="$strXMLFileNot"/></xsl:when>
			<xsl:when test="$status = '281'"><xsl:value-of select="$strXMLMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '282'"><xsl:value-of select="$strXMLNodeDoes"/></xsl:when>
			<xsl:when test="$status = '283'"><xsl:value-of select="$strXMLValueMalformed"/></xsl:when>
			<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="*"/>
</xsl:stylesheet>
