<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<!-- including globals for CLI. GUI automatically loads globals.xsl -->
<xsl:include href="../en/globals.xsl"/>

<xsl:strip-space elements="*"/>
  
<xsl:template match="/OMA">
    <xsl:choose>
      <!-- Power Profiles not available -->
      <xsl:when test="count(/OMA/PowerProfilesObject) &lt; '1' and SMStatus = '0'">
        <DataArea>
          <CustomButton>
            <Data>
              <xsl:attribute name="display"><xsl:value-of select="$gstrRefresh"/></xsl:attribute>
              <xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.PowerProfilesWebPlugin&amp;help=powerprofiles</xsl:attribute>
            </Data>
          </CustomButton>
          <PromptText><xsl:value-of select="$strPowerProfilesNAMessage"/></PromptText>
        </DataArea>
        </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <!-- Power Profiles available, but error condition -->
          <xsl:when test="SMStatus != '0'">
            <DataArea>
              <PageTitle><xsl:attribute name="display"><xsl:value-of select="$strPwrProfiles"/></xsl:attribute></PageTitle>
              <TableData>
                <Header>
                  <Data>
                    <xsl:attribute name="display"><xsl:value-of select="$gstrError"/></xsl:attribute>
                    <xsl:attribute name="value"><xsl:value-of select="$gstrError"/></xsl:attribute>
                  </Data>
                </Header>
                <Row>
                  <Data>
                    <xsl:attribute name="display"><xsl:value-of select="$gstr"/></xsl:attribute>
                    <xsl:attribute name="value">
                      <xsl:call-template name="smstatus">
                        <xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
                      </xsl:call-template>
                    </xsl:attribute>
                  </Data>
                </Row>
              </TableData>
              </DataArea>
          </xsl:when>
          <!-- Power Profiles available and success condition -->
          <xsl:otherwise>
            <DataArea onLoad="true">
              <xsl:if test="(/OMA/OMAUserRights = '7')">
                <xsl:attribute name="validate">true</xsl:attribute>
                <xsl:attribute name="submit">./SubmitForm?plugin=com.dell.hip.webplugins.SetPowerProfilesWebPlugin</xsl:attribute>
              </xsl:if>
              <PageTitle><xsl:attribute name="display"><xsl:value-of select="$strPwrProfiles"/></xsl:attribute></PageTitle>
              <CustomButton>
         		    <xsl:if test="/OMA/OMAUserRights = '7'">
                  <xsl:if test="PowerProfilesObject/PendingProfile/MaxPerf = 'true' or 
                                PowerProfilesObject/PendingProfile/DellDBPM = 'true' or 
                                PowerProfilesObject/PendingProfile/OSDBPM = 'true' or 
                                PowerProfilesObject/PendingProfile/Custom = 'true' ">
			            <Data name="shtdwn">
				            <xsl:attribute name="display"><xsl:value-of select="$gstrRebootSystem"/></xsl:attribute>
				            <xsl:attribute name="href">javascript:restart()</xsl:attribute>
				            <xsl:attribute name="formSubmit">true</xsl:attribute>
			            </Data>
                  </xsl:if>
		            </xsl:if>
                <Data>
                  <xsl:attribute name="display"><xsl:value-of select="$gstrRefresh"/></xsl:attribute>
                  <xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.PowerProfilesWebPlugin&amp;help=powerprofiles</xsl:attribute>
                </Data>
              </CustomButton>
	      <xsl:apply-templates select="PowerProfilesObject"/>      

              <script language="javascript">
                function initializationRoutine()
                {
                  <xsl:if test="(/OMA/OMAUserRights != '7')">
                    disableAllOptions();
                  </xsl:if>
                  
                  var option = -1;
                  <xsl:choose>
                    <xsl:when test="PowerProfilesObject/curProfile/MaxPerf = 'true'">
                      option = 1;
                    </xsl:when>
                    <xsl:when test="PowerProfilesObject/curProfile/DellDBPM = 'true'">
                      option = 2;
                    </xsl:when>
                    <xsl:when test="PowerProfilesObject/curProfile/OSDBPM = 'true'">
                      option = 3;
                    </xsl:when>
                    <xsl:when test="PowerProfilesObject/curProfile/Custom = 'true'">
                      option = 0;
                    </xsl:when>                    
                  </xsl:choose>
                
                  handleOptions(option);
                }

                function handleOptions(option)
                {
                  if(option == 0) // custom
                  {
                    <xsl:if test="(/OMA/OMAUserRights = '7')">
                      enableCustomOptions();
                    </xsl:if>
                  }
                  else
                  {
			disableCustomOptions();
                  }
                }

                function disableAllOptions()
                {   
		 try {
		  document.getElementById("profile_maxperf").disabled = true;
		} catch (e) {}

		 try {
                  document.getElementById("profile_delldbpm").disabled = true;
		} catch (e) {}
		
		try {
                  document.getElementById("profile_osdbpm").disabled = true;
		} catch (e) {}

		try {
		  document.getElementById("profile_custom").disabled = true;
		} catch (e) {}
			
             <xsl:if test="PowerProfilesObject/profilesSupported/Custom = 'true'">   
		   disableCustomOptions();		  
		</xsl:if>
                }
                
                function disableCustomOptions()
                {

			try{               
                 document.getElementById("pk_cpu").disabled = true;
			}catch(e){}
			try{
                  document.getElementById("pk_mem").disabled = true;
			}catch(e){}
			try{
                  document.getElementById("pk_fan").disabled = true;
			}catch(e){}
	
                }

                function enableCustomOptions()
                {
			try{
                 document.getElementById("pk_cpu").disabled = false;
			}catch(e){}
			try{
                  document.getElementById("pk_mem").disabled = false;
			}catch(e){}
			try{
                  document.getElementById("pk_fan").disabled = false;
			}catch(e){}
                }
                           
                function restart()
                {
                  if (confirm("<xsl:value-of select="$strAreYouDone"/>")) {
					          document.getElementById("dataarea").action=top.gnv.appendVID('./SubmitForm?plugin=com.dell.hip.webplugins.shtdwnWebPlugin&amp;os=8&amp;action1=1');
					          document.getElementById("dataarea").submit();
				          }
			          }
                
                function validate()
                {
                  if (confirm("<xsl:value-of select="$strAreYouDone"/>")) {
                    return true;
			 }
                }
              </script>
	      <HiddenTable>
			<Data name="DatypeTag" type="hidden">
				<xsl:choose>
					<xsl:when test="/OMA/ShutDownDA = 'dceda' ">							
							<xsl:attribute name="returnvalue">dceda</xsl:attribute>			
					 </xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="returnvalue">hipda</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>			
	  </HiddenTable>
            </DataArea>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  

<xsl:template match="PowerProfilesObject">
  <xsl:choose>
    <xsl:when test="/OMA/@cli = 'true'"><xsl:call-template name="cli"/></xsl:when>
    <xsl:otherwise><xsl:call-template name="web"/></xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="web">
 <xsl:if test="(/OMA/OMAUserRights = '7')">
<xsl:choose>
  <xsl:when test="profilesSupported/Custom = 'true'">
  <PromptText><xsl:value-of select="$strPwrProfilesMsg"/><xsl:value-of select="$strPwrProfilesMsgWithCustom"/></PromptText>
</xsl:when>
<xsl:otherwise>
  <PromptText><xsl:value-of select="$strPwrProfilesMsg"/></PromptText>
</xsl:otherwise>
</xsl:choose>
</xsl:if>
  <TableData name="profiles">
    <xsl:attribute name="display"><xsl:value-of select="$strPwrProfiles"/></xsl:attribute>
    <SubHeader>
      <xsl:attribute name="display"><xsl:value-of select="$strPwrProfiles"/></xsl:attribute>
    </SubHeader>    
    <Header>
      <Data name="h1">
        <xsl:attribute name="value"><xsl:value-of select="$strSelectPwrProfile"/></xsl:attribute>
      </Data>
    </Header>
    <xsl:if test="profilesSupported/MaxPerf = 'true'">
      <Row>
        <Data name="profiletype" id="profile_maxperf"  returnvalue="1" type="radio" >
            <xsl:attribute name="value"><xsl:value-of select="$strProfileMaxPerformance"/></xsl:attribute>
            <xsl:if test="curProfile/MaxPerf = 'true'">
              <xsl:attribute name="state">1</xsl:attribute>
            </xsl:if>
            <xsl:attribute name="event">onClick</xsl:attribute>
            <xsl:attribute name="handler">javascript:handleOptions(1)</xsl:attribute>
        </Data>
      </Row>
    </xsl:if>
    <xsl:if test="profilesSupported/DellDBPM = 'true'">
      <Row>
        <Data name="profiletype" id="profile_delldbpm" returnvalue="4" type="radio" >
          <xsl:attribute name="value"><xsl:value-of select="$strProfileATP"/></xsl:attribute>
          <xsl:if test="curProfile/DellDBPM = 'true'">
            <xsl:attribute name="state">1</xsl:attribute>
          </xsl:if>
          <xsl:attribute name="event">onClick</xsl:attribute>
          <xsl:attribute name="handler">javascript:handleOptions(2)</xsl:attribute>
        </Data>
      </Row>
    </xsl:if>
    <xsl:if test="profilesSupported/OSDBPM = 'true'">
      <Row>
        <Data name="profiletype" id="profile_osdbpm" returnvalue="2" type="radio" >
          <xsl:attribute name="value"><xsl:value-of select="$strProfileOSControl"/></xsl:attribute>
          <xsl:if test="curProfile/OSDBPM = 'true'">
            <xsl:attribute name="state">1</xsl:attribute>
          </xsl:if>
          <xsl:attribute name="event">onClick</xsl:attribute>
          <xsl:attribute name="handler">javascript:handleOptions(3)</xsl:attribute>
        </Data>
      </Row>
    </xsl:if>
    <xsl:if test="profilesSupported/Custom = 'true'">
      <Row>
        <Data name="profiletype"  id="profile_custom" returnvalue="8" type="radio" >
          <xsl:attribute name="value"><xsl:value-of select="$strProfileCustom"/></xsl:attribute>
          <xsl:if test="curProfile/Custom = 'true'">
            <xsl:attribute name="state">1</xsl:attribute>
          </xsl:if>
          <xsl:attribute name="event">onClick</xsl:attribute>
          <xsl:attribute name="handler">javascript:handleOptions(0)</xsl:attribute>
        </Data>
      </Row>
    </xsl:if>
  </TableData>
   <xsl:if test="profilesSupported/Custom = 'true'">
  <xsl:call-template name="CustomOptions"/>
  </xsl:if>
</xsl:template>
  
<xsl:template name="CustomOptions">
<xsl:if test="PowerKnobPstateObject !='null' or PowerKnobMemoryObject!='null' or PowerKnobFanObject!='null'">
  <TableData name="custprofiles" >
    <xsl:attribute name="display"><xsl:value-of select="$strPwrCustomOptions"/></xsl:attribute>
    <SubHeader>
      <xsl:attribute name="display"><xsl:value-of select="$strPwrCustomOptions"/></xsl:attribute>
    </SubHeader>
    <Header>
      <Data name="h1">
        <xsl:attribute name="value"><xsl:value-of select="$gstrAttribute"/></xsl:attribute>
      </Data>
      <Data name="h2">
        <xsl:attribute name="value"><xsl:value-of select="$gstrValue"/></xsl:attribute>
      </Data>      
    </Header> 
	<xsl:if test="PowerKnobPstateObject"> 
          <Row>
            <Data name="pk_name" align="left" width="40%">
              <xsl:attribute name="value"><xsl:value-of select="$strProfileCPUPowerMgmt"/></xsl:attribute>
            </Data>
	    <Data name="pk_cpu" id="pk_cpu" type="select" >
             <xsl:if test="PowerKnobPstateObject/capabilities/min = 'true'">
		  <Choice>
			  <xsl:attribute name="returnvalue">2</xsl:attribute>
			  <xsl:attribute name="value"><xsl:value-of select="$strMinimumPower"/></xsl:attribute>
                
		        <xsl:if test="PowerKnobPstateObject/currentState/min = 'true'">
                        <xsl:attribute name="default">true</xsl:attribute>                    
                        </xsl:if>
		 </Choice>
              </xsl:if>
              <xsl:if test="PowerKnobPstateObject/capabilities/max = 'true'">
		  <Choice>
			  <xsl:attribute name="returnvalue">1</xsl:attribute>
			  <xsl:attribute name="value"><xsl:value-of select="$strMaximumPerformance"/></xsl:attribute>
			 
			 <xsl:if test="PowerKnobPstateObject/currentState/max = 'true'">
			<xsl:attribute name="default">true</xsl:attribute>
			</xsl:if>
		 </Choice>
                </xsl:if>
              <xsl:if test="PowerKnobPstateObject/capabilities/System = 'true'">
		  <Choice>
			  <xsl:attribute name="returnvalue">8</xsl:attribute>
			  <xsl:attribute name="value"><xsl:value-of select="$strProfileSystemDBPM"/></xsl:attribute>
        
			<xsl:if test="PowerKnobPstateObject/currentState/System = 'true'">
			<xsl:attribute name="default">true</xsl:attribute>
			</xsl:if>                  
		</Choice>
              </xsl:if>
              <xsl:if test="PowerKnobPstateObject/capabilities/OS = 'true'">
		  <Choice>
			  <xsl:attribute name="returnvalue">4</xsl:attribute>
			  <xsl:attribute name="value"><xsl:value-of select="$strProfileOSDBPM"/></xsl:attribute>
			
			  <xsl:if test="PowerKnobPstateObject/currentState/OS = 'true'">
			  <xsl:attribute name="default">true</xsl:attribute>
			  </xsl:if>                  
		 </Choice>
                </xsl:if>
	  </Data>
          </Row>
	   </xsl:if>
        
        <!-- Power Knob - Memory Power Management -->
        <xsl:if test="PowerKnobMemoryObject">
          <Row>
            <Data name="pk_name" align="left">
              <xsl:attribute name="value"><xsl:value-of select="$strProfileMemoryPowerMgmt"/></xsl:attribute>
            </Data>
            <Data name="pk_mem" id="pk_mem" type="select">
              <xsl:if test="PowerKnobMemoryObject/capabilities/freq_min = 'true'">
		  <Choice>
			  <xsl:attribute name="returnvalue">16</xsl:attribute>
			  <xsl:attribute name="value"><xsl:value-of select="$strMinimumPower"/></xsl:attribute>
			
			<xsl:if test="PowerKnobMemoryObject/currentState/freq_min = 'true'">
			<xsl:attribute name="default">true</xsl:attribute>                    
			</xsl:if>
		 </Choice>
               </xsl:if>              
		  <xsl:if test="PowerKnobMemoryObject/capabilities/freq_800 = 'true'">
	 	  <Choice>
			  <xsl:attribute name="returnvalue">8</xsl:attribute>
			  <xsl:attribute name="value"><xsl:value-of select="$str800MHz"/></xsl:attribute>
			
			  <xsl:if test="PowerKnobMemoryObject/currentState/freq_800 = 'true'">
			  <xsl:attribute name="default">true</xsl:attribute>                    
			 </xsl:if>
		 </Choice>
                </xsl:if>
		  <xsl:if test="PowerKnobMemoryObject/capabilities/freq_1067= 'true'">
	 	  <Choice>
			  <xsl:attribute name="returnvalue">4</xsl:attribute>
			  <xsl:attribute name="value"><xsl:value-of select="$str1067MHz"/></xsl:attribute>
			
			  <xsl:if test="PowerKnobMemoryObject/currentState/freq_1067 = 'true'">
			  <xsl:attribute name="default">true</xsl:attribute>                    
			 </xsl:if>
		 </Choice>
                </xsl:if>
		  <xsl:if test="PowerKnobMemoryObject/capabilities/freq_1333= 'true'">
	 	  <Choice>
			  <xsl:attribute name="returnvalue">2</xsl:attribute>
			  <xsl:attribute name="value"><xsl:value-of select="$str1333MHz"/></xsl:attribute>
			
			  <xsl:if test="PowerKnobMemoryObject/currentState/freq_1333 = 'true'">
			  <xsl:attribute name="default">true</xsl:attribute>                    
			 </xsl:if>
		 </Choice>
                </xsl:if>
		 <xsl:if test="PowerKnobMemoryObject/capabilities/freq_max = 'true'">
	 	  <Choice>
			  <xsl:attribute name="returnvalue">1</xsl:attribute>
			  <xsl:attribute name="value"><xsl:value-of select="$strMaximumPerformance"/></xsl:attribute>
			
			  <xsl:if test="PowerKnobMemoryObject/currentState/freq_max = 'true'">
			  <xsl:attribute name="default">true</xsl:attribute>                    
			 </xsl:if>
		 </Choice>
                </xsl:if>
            </Data>
          </Row>
        </xsl:if>
        <!-- Power Knob - Fan Mode -->
         <xsl:if test="PowerKnobFanObject">
          <Row>
            <Data name="pk_name" align="left">
              <xsl:attribute name="value"><xsl:value-of select="$strProfileFanPowerMgmt"/></xsl:attribute>
            </Data>
            <Data name="pk_fan" id="pk_fan" type="select">
              <xsl:if test="PowerKnobFanObject/capabilities/power = 'true'">
		  <Choice>
			  <xsl:attribute name="returnvalue">2</xsl:attribute>
			  <xsl:attribute name="value"><xsl:value-of select="$strMinimumPower"/></xsl:attribute>
			
			<xsl:if test="PowerKnobFanObject/currentState/power = 'true'">
			<xsl:attribute name="default">true</xsl:attribute>                    
			</xsl:if>
		 </Choice>
              </xsl:if>
              <xsl:if test="PowerKnobFanObject/capabilities/performance = 'true'">
                <Choice>
			 <xsl:attribute name="returnvalue">1</xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strMaximumPerformance"/></xsl:attribute>
			<xsl:if test="PowerKnobFanObject/currentState/performance = 'true'">
			<xsl:attribute name="default">true</xsl:attribute>                    
			</xsl:if>
		 </Choice>
              </xsl:if>
            </Data>
          </Row>
	  </xsl:if>
  </TableData>
</xsl:if>
</xsl:template>  

<xsl:template name="cli">
  <ListData>
    <xsl:if test="profilesSupported/MaxPerf = 'true'">
      <Data name="profiletype" >
        <xsl:attribute name="display"><xsl:value-of select="$strProfileMaxPerformance"/></xsl:attribute>
        <xsl:attribute name="value">
          <xsl:choose>
            <xsl:when test="curProfile/MaxPerf = 'true'"><xsl:value-of select="$strSelected"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$strNotSelected"/></xsl:otherwise>
          </xsl:choose>
        </xsl:attribute>
      </Data>
    </xsl:if>
    <xsl:if test="profilesSupported/DellDBPM = 'true'">
        <Data name="profiletype" >
          <xsl:attribute name="display"><xsl:value-of select="$strProfileATP"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="curProfile/DellDBPM = 'true'"><xsl:value-of select="$strSelected"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="$strNotSelected"/></xsl:otherwise>
            </xsl:choose>
           </xsl:attribute>
        </Data>
    </xsl:if>
    <xsl:if test="profilesSupported/OSDBPM = 'true'">
      <Data name="profiletype">
        <xsl:attribute name="display"><xsl:value-of select="$strProfileOSControl"/></xsl:attribute>
        <xsl:attribute name="value">
          <xsl:choose>
            <xsl:when test="curProfile/OSDBPM = 'true'"><xsl:value-of select="$strSelected"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$strNotSelected"/></xsl:otherwise>
          </xsl:choose>
        </xsl:attribute>
      </Data>
    </xsl:if>
    <xsl:if test="profilesSupported/Custom = 'true'">
      <Data name="profiletype">
        <xsl:attribute name="display"><xsl:value-of select="$strProfileCustom"/></xsl:attribute>
        <xsl:attribute name="value">
          <xsl:choose>
            <xsl:when test="curProfile/Custom = 'true'"><xsl:value-of select="$strSelected"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$strNotSelected"/></xsl:otherwise>
          </xsl:choose>
        </xsl:attribute>          
      </Data>
    </xsl:if>
    </ListData>
 
       <!-- display custom options only if custom profile is set -->
    <xsl:if test="profilesSupported/Custom = 'true' and curProfile/Custom = 'true'">
      <xsl:text> 
      </xsl:text>
    <xsl:if test="PowerKnobPstateObject !='null' or PowerKnobMemoryObject!='null' or PowerKnobFanObject!='null'">
    <ListData>    
        <xsl:attribute name="display"><xsl:value-of select="$strPwrCustomOptions"/></xsl:attribute>
           <xsl:if test="PowerKnobPstateObject">   
          <!-- Power Knob - CPU Power Management -->
            <Data name="pk_cpu" align="center">
              <xsl:attribute name="display"><xsl:value-of select="$strProfileCPUPowerMgmt"/></xsl:attribute>
              <xsl:attribute name="value">
                <xsl:choose>
                  <xsl:when test="PowerKnobPstateObject/currentState/min = 'true'"><xsl:value-of select="$strMinimumPower"/></xsl:when>
                  <xsl:when test="PowerKnobPstateObject/currentState/max = 'true'"><xsl:value-of select="$strMaximumPerformance"/></xsl:when>
                  <xsl:when test="PowerKnobPstateObject/currentState/System = 'true'"><xsl:value-of select="$strProfileSystemDBPM"/></xsl:when>
                  <xsl:when test="PowerKnobPstateObject/currentState/OS = 'true'"><xsl:value-of select="$strProfileOSDBPM"/></xsl:when>
                  <xsl:otherwise><xsl:value-of select="$strNotSelected"/></xsl:otherwise>
                </xsl:choose>
              </xsl:attribute>
            </Data>
	    </xsl:if>
         
          <!-- Power Knob - Memory Power Management -->
	      <xsl:if test="PowerKnobMemoryObject">
            <Data name="pk_mem" align="center">
              <xsl:attribute name="display"><xsl:value-of select="$strProfileMemoryPowerMgmt"/></xsl:attribute>
              <xsl:attribute name="value">
              <xsl:choose>
                 <xsl:when test="PowerKnobMemoryObject/currentState/freq_min = 'true'"><xsl:value-of select="$strMinimumPower"/></xsl:when>
		 <xsl:when test="PowerKnobMemoryObject/currentState/freq_800 = 'true'"><xsl:value-of select="$str800MHz"/></xsl:when>
		 <xsl:when test="PowerKnobMemoryObject/currentState/freq_1067 = 'true'"><xsl:value-of select="$str1067MHz"/></xsl:when>
		 <xsl:when test="PowerKnobMemoryObject/currentState/freq_1333 = 'true'"><xsl:value-of select="$str1333MHz"/></xsl:when>
                 <xsl:when test="PowerKnobMemoryObject/currentState/freq_max = 'true'"><xsl:value-of select="$strMaximumPerformance"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="$strNotSelected"/></xsl:otherwise>
              </xsl:choose>
            </xsl:attribute>
          </Data>
         </xsl:if>
          <!-- Power Knob - Fan Mode -->
         <xsl:if test="PowerKnobFanObject">
            <Data name="pk_fan" align="center">
              <xsl:attribute name="display"><xsl:value-of select="$strProfileFanPowerMgmt"/></xsl:attribute>
              <xsl:attribute name="value">
                <xsl:choose>
                  <xsl:when test="PowerKnobFanObject/currentState/power = 'true'"><xsl:value-of select="$strMinimumPower"/></xsl:when>
                  <xsl:when test="PowerKnobFanObject/currentState/performance = 'true'"><xsl:value-of select="$strMaximumPerformance"/></xsl:when>
                  <xsl:otherwise><xsl:value-of select="$strNotSelected"/></xsl:otherwise>
                </xsl:choose>
              </xsl:attribute>
            </Data>
	    </xsl:if>
       </ListData>
  </xsl:if> 
  </xsl:if>
 
</xsl:template>

<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><xsl:value-of select="$gstrCommandUnsuccessful"/></xsl:when>
			<xsl:when test="$status = '23'"><xsl:value-of select="$strbiospasswderror"/></xsl:when>
			<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
</xsl:template>	
</xsl:stylesheet>
