<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	
	
	        <xsl:variable name="isIPv6Enable">
		    <xsl:choose>
		      <xsl:when test="/OMA/EMPV6LANConfigObj/ipv6State ='1'">true</xsl:when>
		      <xsl:otherwise>false</xsl:otherwise>
		    </xsl:choose>
  		</xsl:variable>
		<xsl:variable name="warningenable">
		    <xsl:choose>
		      <xsl:when test="/OMA/EMPLANAltDestListObj/enableWarning ='true'">true</xsl:when>
		      <xsl:otherwise>false</xsl:otherwise>
		    </xsl:choose>
  		</xsl:variable>
		<xsl:variable name="fqdnenable">
		    <xsl:choose>
		      <xsl:when test="/OMA/EMPLANAltDestListObj/fqdnEnable ='true'">true</xsl:when>
		      <xsl:otherwise>false</xsl:otherwise>
		    </xsl:choose>
  		</xsl:variable>
  	<xsl:template match="/OMA">
		<DataArea validate="true" onLoad="true" exportdata="false" ipbox="true">
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strPlatformEventAlertDestinations"/></xsl:attribute>
<xsl:attribute name="backpagetarget">./DataArea?plugin=com.dell.hip.webplugins.ListPEFDestWebPlugin&amp;help=LPEFDest</xsl:attribute>
			<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.hip.webplugins.SetPEFDestWebPlugin&amp;oid=<xsl:value-of select="@oid"/>&amp;&amp;destinationid=<xsl:value-of select="/OMA/DestId"/></xsl:attribute>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strSetPlatformEventAlertDestination"/><xsl:value-of select="$str1Space"/><xsl:value-of select="/OMA/DestId"/></xsl:attribute>
			</PageTitle>
			<Header>Header</Header>
			<xsl:if test="$warningenable = 'true'">
			    <AlertMessage>
				<xsl:attribute name="display"><xsl:value-of select="$strFQDNConfigureGUIWarnMsg"/></xsl:attribute>
				<xsl:attribute name="status">3</xsl:attribute>
			    </AlertMessage>
			</xsl:if>
			<PromptText><xsl:value-of select="$strSelectValues"/></PromptText>
			<script language="javascript" src="/oma/js/IPSup.js"/>
			<script language="javascript">
			   var usrights = '<xsl:value-of select="/OMA/OMAUserRights"/>'
			
			        
				function initializationRoutine()
				{
					//document.getElementById("ShutdownMode").checked = true;
					//document.getElementById("GenerateAlert").checked = true;
					EnableSettingsAccordingtoUserRights();
				}
				
				function EnableSettingsAccordingtoUserRights()
				{
					if ((usrights != 7 ) &amp;&amp; (usrights!=3))
					{
						document.getElementById("DestIPAddress1").disabled  =true;
					}
				}
				function Error_Codes(number)
					{
					 var error="";
					  switch(number)
					  {
					    case ERROR_NOTPERMITTED : error="<xsl:value-of select="$gstrerrnotpermitted"/>"; break; 
					    case ERROR_INVALID_ADDRESS : error="<xsl:value-of select="$gstrerrinvalid"/>";break;
					    default : error="<xsl:value-of select="$gstrerrdefault"/>";break;
					  }//end switch
					  return error;
					}//end function
	 				

		function validate()
		{
		  var destId = "<xsl:value-of select ="DestId"/>";		  
		  var fqdnenable='<xsl:value-of select ="$fqdnenable"/>';
		  var warningenable="<xsl:value-of select ="$warningenable"/>";
		 
                  //Validate only if Enable Destination is checked. See DF84204 
		  //[MK] Reverted the fix of DF84204 in order to bring in consistency with iDRAC
                  //if ( document.getElementById("EnableDestination").checked == true )
                  //{
			var InvalidIP = false;
			var errorMsg = "";
			var InvalidIPv6=false;
			
			var DestIPAddress1=trim(document.getElementById("DestIPAddress1").value);
			if((fqdnenable == 'true') &amp;&amp; (warningenable=='false'))
			{
		
			if ((Valid_IPV4(DestIPAddress1,0,223) != true) &amp;&amp; (Valid_IPv6(DestIPAddress1,LEVEL_GENERAL) !=true)&amp;&amp; (!isValidFQDNName(DestIPAddress1)))
			{
					errorMsg="<xsl:value-of select="$strInvalidPEFFQDNDest"/>";
					alert(errorMsg);
					return false;
			}
			else
			{
					return true;
			}
			}
			else
			{
			if (destId &lt; 5)
			  {
				if (Valid_IPV4(DestIPAddress1,0,223) != true) 
				{					
					errorMsg="<xsl:value-of select="$strInvalidStaticIP"/>";
					alert(errorMsg);					   
				        return false;
				}			
			  }
			else
			  {
				var errorcode=Valid_IPv6(DestIPAddress1,LEVEL_GENERAL);
				if(errorcode!=true)
					{	
							errorMsg=Error_Codes(errorcode);
							alert(errorMsg);
							return false;
					 }
			}
			}			
		//} 
		return true;
	}
				
				function trimIPAddress(ipboxname , length)
				{
					for (i =1 ; i &lt;= length ; i++) {
						var ipbox = ipboxname + i;
						try
						{
							var ipboxval = document.getElementById(ipbox).value;
							document.getElementById(ipbox).value = trim(ipboxval);
						}
						catch(e){};
					}
				}
				
				function ltrim ( s ) 
				{ 
					return s.replace( /^\s*/, "" ) 
				} 
		
				function rtrim ( s ) 
				{ 
					return s.replace( /\s*$/, "" ); 
				} 
		
				//Combine the rtrim() and ltrim() functions to make the trim() function, which just wraps both calls together: 
		
				function trim ( s ) 
				{ 
					return rtrim(ltrim(s)); 
				}

				function setDefault()
				{
					//document.getElementById("ShutdownMode").checked = true;
					//document.all.ShutdownMode[ 0 ].checked=true;
					//document.getElementById("GenerateAlert").checked = true;
				}
				function Compare_Strings(str1, str2)
				{
				    ret_val = true;
				    if(str1.length != str2.length)
				    return false;

				    for (var i = 0; i &lt;= str1.length; i++)
				    {
				        curChar1 = str1.charCodeAt(i);
				        curChar2 = str2.charCodeAt(i);
				        if ( curChar1 == curChar2)
				        {
				            continue;
				        }
					  else
				        {
				            ret_val = false;
				            break;
				        }
				    }

				    return ret_val;
				}	

				function Valid_Number(value, exact, min, max)
				{
				    var nASCII_0 = 48;
				    var nASCII_9 = 57;

				    if (exact != -1 &amp;&amp; value != exact)
				    	  return false;  
				    else if (exact != -1 &amp;&amp; value == exact)
					  return true;

				    if (value == null || value == "") 
				        return false;
				    var str = new String(value);
				    for (var i = 0; i &lt; str.length; i++)
				    {
				        if (str.charCodeAt(i) &lt; nASCII_0 || str.charCodeAt(i) &gt; nASCII_9)
			            return false;
				    }

				    if (Math.floor(str) &lt; Math.floor(min) || Math.floor(str) &gt; Math.floor(max)) 
				       return false;
				    else 
				        return true;
				}

				function Valid_IPV4(str,min,max)
				{
				    var nASCII_0 = 48;
				    var nASCII_9 = 57;
				    var nASCII_dot = 46;
				    var curNumber = "";
				    var iCount = 0;
				    var jCount = 0;
				    var limitedMask = 255;
				    if(str.length == 0 || str == "")
				        return false;

				    if (Compare_Strings(str, '0.0.0.0'))
				        return false;

				    if (Compare_Strings(str, '255.255.255.255'))
				       return false;

				    for (var i = 0; i &lt; str.length; i++)
				    {
				        curChar = str.charCodeAt(i);
				        curNum = str.charAt(i);
				        if (curChar == nASCII_dot)
				        {
            
				            iCount++;
				            jCount = 0;

				            if (iCount == 1)
						{
						    if (curNumber &lt; 1 || curNumber == 127)
						        return false;
				                ret_code = Valid_Number(curNumber,-1,min,max);
						}
				            else
					           ret_code = Valid_Number(curNumber,-1,min,limitedMask);

					       if (ret_code != 1)
					           return false;

					       curNumber = "";
					       continue;
					   }
					   else if (curChar &gt;= nASCII_0 &amp;&amp; curChar &lt;= nASCII_9 &amp;&amp; jCount &lt;= 3)
				        {
				            jCount++;
				            curNumber += curNum;
				        }
				        else
				        {
				            return false;
				        }
    				    }

				    ret_code = Valid_Number(curNumber,-1,min,limitedMask);
				    if (ret_code != 1)
				        return false;

				    if (iCount != 3)
				        return false;

				    return true;
				}
				 function isValidFQDNName(fqdnName)
					{					
						return fqdnName.match (/([a-z0-9\-]+\.)+[a-z0-9\-]{2,8}/ig);
					}
		</script>

			<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.PEFDestWebPlugin&amp;type=<xsl:value-of select="/OMA/Type"/>&amp;destinationid=<xsl:value-of select="/OMA/DestId"/>&amp;help=SetPEFD</xsl:attribute>
				</Data>
			</CustomButton>
			<ListData type="custom" columnspacing="true">				
				<xsl:if test="/OMA/@cli = 'true'">
					<Header>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strAttribute"/>	</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strAttribute"/>	</xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strValue"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strValue"/></xsl:attribute>
						</Data>
					</Header>
				</xsl:if>
					
				<xsl:apply-templates select="EMPLANAltDestListObj"/>
			</ListData>
		</DataArea>
	</xsl:template>
	
	<xsl:template match="EMPLANAltDestListObj">
				<xsl:apply-templates select="LANAlertDestListarray/LANAlertDestList"/>
	</xsl:template>
	
	<xsl:template match="LANAlertDestList[destSelector=/OMA/DestId]">
	
				<xsl:apply-templates select="/OMA/EMPPEFAltPlcyEntryListObj/altPlcyEntryListarray/altPlcyEntryList[policyEntryNumber = /OMA/DestId]"/>
		
			<xsl:call-template name="ShowIPAddrBox">
				<xsl:with-param name="Address">
					<xsl:value-of select="AlertingIPAddr"/>
				</xsl:with-param>
				<xsl:with-param name="IPCtrlName">DestIPAddress1</xsl:with-param>
				<xsl:with-param name="DisplayStr"><xsl:value-of select="$strDestinationIPAddress"/></xsl:with-param>
			</xsl:call-template>
		
	</xsl:template>
	
	<xsl:template match="altPlcyEntryList">
		<Data name="EnableDestination" type="checkbox" editable="true" align="left">	
				<xsl:attribute name="display"><xsl:value-of select="$strEnableDestination"/></xsl:attribute>	
			
				<xsl:if test="entryEnable='1'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
	</xsl:template>
	
	<xsl:template name="ShowIPAddrBox">
		<xsl:param name="Address"/>
		<xsl:param name="IPCtrlName"/>
		<xsl:param name="DisplayStr"/>
    <Data type="editbox" editable="true" size="12">
			<xsl:attribute name="display"><xsl:value-of select="$DisplayStr"/></xsl:attribute>
	
			<xsl:attribute name="name"><xsl:value-of select="$IPCtrlName"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$Address"/></xsl:attribute>
		</Data>
	</xsl:template>
	
</xsl:stylesheet>
