<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <!-- including globals for CLI. GUI automatically loads globals.xsl -->
  <xsl:include href="../en/globals.xsl"/>
  <xsl:strip-space elements="*"/>
  <xsl:output method="xml" indent="no"/>
  <xsl:template match="/OMA">
<xsl:choose>
	<xsl:when test="NICList/SMStatus != '0'">
		<DataArea printable="false">
			<TableData>
				<Header>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strError1"/></xsl:attribute>
					</Data>
				</Header>
				<Row>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strNICObjectNot"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strNICObjectNot1"/></xsl:attribute>
					</Data>
				</Row>
			</TableData>
		</DataArea>
	</xsl:when>
	<xsl:otherwise>
		<DataArea backpagetarget="./DataArea?plugin=com.dell.hip.webplugins.NICListWebPlugin&amp;help=NIC&amp;">
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strNetworkCards"/></xsl:attribute>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strNetworkCardInformation"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
				<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				<xsl:choose>
				<xsl:when test="NICList/DevNicObj/@ons">
					<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.NICCardWebPlugin&amp;help=NICInfo&amp;ons=<xsl:value-of select="NICList/DevNicObj/@ons"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.NICCardWebPlugin&amp;help=NICInfo&amp;ons=<xsl:value-of select="NICList/VirNicObj/@ons"/></xsl:attribute>
				</xsl:otherwise>
				</xsl:choose>
				</Data>
			</CustomButton>
			<xsl:apply-templates select="NICList/VirNicObj"/>
			<xsl:apply-templates select="NICList/DevNicObj"/>			
			<xsl:apply-templates select="IPAddressList/IPUnicastAddrListObj"/>
		      <xsl:apply-templates select="NICAdapterStats/NetAdptStatsObj"/>
			
		</DataArea>
	</xsl:otherwise>
</xsl:choose>
</xsl:template>
  
<xsl:template match="NICList/DevNicObj">
  <xsl:call-template name="PhyInterface"/>
  <xsl:call-template name="Interface"/>
</xsl:template>

<xsl:template match="NICList/VirNicObj">
  <xsl:call-template name="VirtualInterface"/>
  <xsl:call-template name="Interface"/>
</xsl:template>


<xsl:template name="PhyInterface">
	<ListData name="phyniclist" type="custom">
	<xsl:attribute name="display"><xsl:value-of select="$strPhysicalInterface"/></xsl:attribute>
	<Header>
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strPhysicalInterface"/><xsl:value-of select="$strColon"/><xsl:value-of select="OSAdapterDescription"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strPhysicalInterface"/><xsl:value-of select="$strColon"/><xsl:value-of select="OSAdapterDescription"/></xsl:attribute>		
		</Data>
	  </Header>
	<xsl:if test="OSAdapterDescription!='' ">
		  <Data>
			  <xsl:attribute name="display"><xsl:value-of select="$strDescription"/></xsl:attribute>
			  <xsl:attribute name="value"><xsl:value-of select="OSAdapterDescription"/></xsl:attribute>
			</Data>
	  </xsl:if>
		<xsl:if test="OSAdapterVendor!='' ">
			  <Data>
				  <xsl:attribute name="display"><xsl:value-of select="$strVendor"/></xsl:attribute>
				  <xsl:attribute name="value"><xsl:value-of select="OSAdapterVendor"/></xsl:attribute>
			  </Data>
		</xsl:if>
		<xsl:if test="SlotName!='' ">
		    <Data>
			    <xsl:attribute name="display"><xsl:value-of select="$strSlotName"/></xsl:attribute>
			    <xsl:attribute name="value"><xsl:value-of select="SlotName"/></xsl:attribute>
		    </Data>
		</xsl:if>
    <xsl:if test="CurrentMACAddr!='' ">
			  <Data>
				  <xsl:attribute name="display"><xsl:value-of select="$strCurrentMACAddress"/></xsl:attribute>
				  <xsl:attribute name="value"><xsl:value-of select="CurrentMACAddr"/></xsl:attribute>
			  </Data>
		</xsl:if>
		<xsl:if test="duplex!='' ">
		    <Data>
			    <xsl:attribute name="display"><xsl:value-of select="$strDuplex"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="duplex = 1"><xsl:value-of  select="$strHalf"/></xsl:when>
              <xsl:when test="duplex = 2"><xsl:value-of  select="$strFull"/></xsl:when>
              <xsl:otherwise><xsl:value-of  select="$strUnknown"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
		</xsl:if>    
		<xsl:if test="baseAddress!='' ">
		    <Data>
			    <xsl:attribute name="display"><xsl:value-of select="$strBaseIOAddr"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="baseAddress!=0 ">
			<xsl:text>0x</xsl:text>
                <xsl:call-template name="DecimaltoHex">
                  <xsl:with-param name="decimalNumber"><xsl:value-of select="baseAddress"/></xsl:with-param>
                </xsl:call-template>
              </xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
		</xsl:if>
		<xsl:if test="baseMemAddr!='' ">
		    <Data>
			    <xsl:attribute name="display"><xsl:value-of select="$strBaseMemAddr"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="baseMemAddr!=0 ">
			<xsl:text>0x</xsl:text>
			<xsl:call-template name="DecimaltoHex">
                  <xsl:with-param name="decimalNumber"><xsl:value-of select="baseMemAddr"/></xsl:with-param>
                </xsl:call-template>                
                </xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
		</xsl:if>
		<xsl:if test="irq!='' ">
		    <Data>
			    <xsl:attribute name="display"><xsl:value-of select="$strIRQ"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="irq!=0 "><xsl:value-of select="irq"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
		</xsl:if>    
		<xsl:if test="dma!='' ">
		    <Data>
			    <xsl:attribute name="display"><xsl:value-of select="$strDMA"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="dma!=0 "><xsl:value-of select="dma"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
		</xsl:if>
		<xsl:if test="linkStatus!='' ">
		    <Data>
			    <xsl:attribute name="display"><xsl:value-of select="$strLinkStatus"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="linkStatus = 1"><xsl:value-of  select="$strUp"/></xsl:when>
              <xsl:when test="linkStatus = 2"><xsl:value-of  select="$strDown"/></xsl:when>
              <xsl:otherwise><xsl:value-of  select="$strUnknown"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
		</xsl:if>    
		
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strConnectionStatus"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="nicStatus='1'">
						<xsl:attribute name="value"><xsl:value-of select="$strConnected"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='2'">
						<xsl:attribute name="value"><xsl:value-of select="$strDisconnected"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='3'">
						<xsl:attribute name="value"><xsl:value-of select="$strDriverNotInstalled"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='4'">
						<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='10'">
						<xsl:attribute name="value"><xsl:value-of select="$strInitializing"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='11'">
						<xsl:attribute name="value"><xsl:value-of select="$strResetting"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='12'">
						<xsl:attribute name="value"><xsl:value-of select="$strClosing"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='13'">
						<xsl:attribute name="value"><xsl:value-of select="$strAdapterNotReady"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><xsl:value-of select="$strNoValue6"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
<xsl:choose>
	<xsl:when test="nicCapabilities/@value !='0'">
			    <Data>
				    <xsl:attribute name="display"><xsl:value-of select="$strTOECapable"/></xsl:attribute>
				    <xsl:choose>
					    <xsl:when test="nicCapabilities/TOE='true'">
					        <xsl:attribute name="value"><xsl:value-of select="$gstrYes"/></xsl:attribute>
					    </xsl:when>
					    <xsl:otherwise>
						    <xsl:attribute name="value"><xsl:value-of select="$gstrNo"/></xsl:attribute>
					    </xsl:otherwise>
				    </xsl:choose>
			    </Data>
				
				  <Data>
				    <xsl:attribute name="display"><xsl:value-of select="$strTOEEnabled"/></xsl:attribute>
						<xsl:choose>
							<xsl:when test="isTOEEnable='true' ">
								<xsl:attribute name="value"><xsl:value-of select="$gstrYes"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="value"><xsl:value-of select="$gstrNo"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
			    </Data>
				
				<Data>
				    <xsl:attribute name="display"><xsl:value-of select="$strFCOECapable"/></xsl:attribute>
						<xsl:choose>
							<xsl:when test="nicCapabilities/FCoEOffload='true'">
								<xsl:attribute name="value"><xsl:value-of select="$gstrYes"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="value"><xsl:value-of select="$gstrNo"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
			    </Data>
				
				<Data>
				    <xsl:attribute name="display"><xsl:value-of select="$strISOECapable"/></xsl:attribute>
						<xsl:choose>
							<xsl:when test="nicCapabilities/iSCSIOffload='true'">
								<xsl:attribute name="value"><xsl:value-of select="$gstrYes"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="value"><xsl:value-of select="$gstrNo"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
			    </Data>
		
	</xsl:when>
		
	<xsl:otherwise>
		<xsl:if test="nicTOECapability!='0'">
			  <Data>
				  <xsl:attribute name="display"><xsl:value-of select="$strTOECapable"/></xsl:attribute>
				    <xsl:choose>
					    <xsl:when test="nicTOECapability='1'">
						    <xsl:attribute name="value"><xsl:value-of select="$strTOECapability0"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="nicTOECapability='2'">
						    <xsl:attribute name="value"><xsl:value-of select="$gstrYes"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="nicTOECapability='4'">
						    <xsl:attribute name="value"><xsl:value-of select="$gstrNo"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="nicTOECapability='8'">
						    <xsl:attribute name="value"><xsl:value-of select="$strTOECapability3"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="nicTOECapability='16'">
						    <xsl:attribute name="value"><xsl:value-of select="$strTOECapability4"/></xsl:attribute>
					    </xsl:when>
					    <xsl:otherwise>
						    <xsl:attribute name="value"><xsl:value-of select="$strNoValue"/></xsl:attribute>
					    </xsl:otherwise>
				    </xsl:choose>
			    </Data>
			    <Data>
				    <xsl:attribute name="display"><xsl:value-of select="$strTOEEnabled"/></xsl:attribute>
						<xsl:choose>
							<xsl:when test="isTOEEnable='true' ">
								<xsl:attribute name="value"><xsl:value-of select="$gstrYes"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="value"><xsl:value-of select="$gstrNo"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
			    </Data>
		</xsl:if>

	</xsl:otherwise>
</xsl:choose>
	<xsl:if test="showNPAREP='true'">			
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strNPAREPEnabled"/></xsl:attribute>
			<xsl:choose>
				<xsl:when test="isNPAREPEnable='true' ">
					<xsl:attribute name="value"><xsl:value-of select="$gstrYes"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="value"><xsl:value-of select="$gstrNo"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</Data>				
	</xsl:if>	
		<xsl:if test="DriverName!='' ">
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strDriverName"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="DriverName"/></xsl:attribute>
				</Data>
		</xsl:if>    
		<xsl:if test="ImagePath!='' ">
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strDriverImagePath"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="ImagePath"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="DriverVersion!='' ">
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strDriverVersion"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="DriverVersion!='0'"><xsl:value-of select="DriverVersion"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="FirmwareVersion!='' ">
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strFWVersion"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="FirmwareVersion!='0'"><xsl:value-of select="FirmwareVersion"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
				</Data>
		</xsl:if>   
		<xsl:if test="TeamName !=''">
				<Data>
			          <xsl:attribute name="display"><xsl:value-of select="$strTeamName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="TeamName"/></xsl:attribute>
				</Data>
		</xsl:if>
	 	</ListData>	 	
</xsl:template>  


<xsl:template name="VirtualInterface">
	<ListData name="virniclist" type="custom">
	<xsl:attribute name="display"><xsl:value-of select="$strTeamInterface"/></xsl:attribute>
	<Header>
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strTeamInterface"/><xsl:value-of select="$strColon"/><xsl:value-of select="OSAdapterDescription"/></xsl:attribute>		
			<xsl:attribute name="value"><xsl:value-of select="$strTeamInterface"/><xsl:value-of select="$strColon"/><xsl:value-of select="OSAdapterDescription"/></xsl:attribute>		
		</Data>
	</Header>
	<xsl:if test="OSAdapterDescription!='' ">
		  <Data>
			  <xsl:attribute name="display"><xsl:value-of select="$strDescription"/></xsl:attribute>
			  <xsl:attribute name="value"><xsl:value-of select="OSAdapterDescription"/></xsl:attribute>
		</Data>
	</xsl:if>
		<xsl:if test="OSAdapterVendor!='' ">
			  <Data>
				  <xsl:attribute name="display"><xsl:value-of select="$strVendor"/></xsl:attribute>
				  <xsl:attribute name="value"><xsl:value-of select="OSAdapterVendor"/></xsl:attribute>
			  </Data>
		</xsl:if>
		<xsl:if test="SlotName!='' ">
		    <Data>
			    <xsl:attribute name="display"><xsl:value-of select="$strSlotName"/></xsl:attribute>
			    <xsl:attribute name="value"><xsl:value-of select="SlotName"/></xsl:attribute>
		    </Data>
		</xsl:if>
    <xsl:if test="CurrentMACAddr!='' ">
			  <Data>
				  <xsl:attribute name="display"><xsl:value-of select="$strCurrentMACAddress"/></xsl:attribute>
				  <xsl:attribute name="value"><xsl:value-of select="CurrentMACAddr"/></xsl:attribute>
			  </Data>
		</xsl:if>
		<xsl:if test="duplex!='' ">
		    <Data>
			    <xsl:attribute name="display"><xsl:value-of select="$strDuplex"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="duplex = 1"><xsl:value-of  select="$strHalf"/></xsl:when>
              <xsl:when test="duplex = 2"><xsl:value-of  select="$strFull"/></xsl:when>
              <xsl:otherwise><xsl:value-of  select="$strUnknown"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
		</xsl:if>    
		<xsl:if test="baseAddress!='' ">
		    <Data>
			    <xsl:attribute name="display"><xsl:value-of select="$strBaseIOAddr"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="baseAddress!=0 ">
			<xsl:text>0x</xsl:text>
                <xsl:call-template name="DecimaltoHex">
                  <xsl:with-param name="decimalNumber"><xsl:value-of select="baseAddress"/></xsl:with-param>
                </xsl:call-template>
              </xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
		</xsl:if>
		<xsl:if test="baseMemAddr!='' ">
		    <Data>
			    <xsl:attribute name="display"><xsl:value-of select="$strBaseMemAddr"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="baseMemAddr!=0 ">
			<xsl:text>0x</xsl:text>
			<xsl:call-template name="DecimaltoHex">
                  <xsl:with-param name="decimalNumber"><xsl:value-of select="baseMemAddr"/></xsl:with-param>
                </xsl:call-template>                
                </xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
		</xsl:if>
		<xsl:if test="irq!='' ">
		    <Data>
			    <xsl:attribute name="display"><xsl:value-of select="$strIRQ"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="irq!=0 "><xsl:value-of select="irq"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
		</xsl:if>    
		<xsl:if test="dma!='' ">
		    <Data>
			    <xsl:attribute name="display"><xsl:value-of select="$strDMA"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="dma!=0 "><xsl:value-of select="dma"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
		</xsl:if>
		<xsl:if test="linkStatus!='' ">
		    <Data>
			    <xsl:attribute name="display"><xsl:value-of select="$strLinkStatus"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="linkStatus = 1"><xsl:value-of  select="$strUp"/></xsl:when>
              <xsl:when test="linkStatus = 2"><xsl:value-of  select="$strDown"/></xsl:when>
              <xsl:otherwise><xsl:value-of  select="$strUnknown"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
		</xsl:if>    
		
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strConnectionStatus"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="nicStatus='1'">
						<xsl:attribute name="value"><xsl:value-of select="$strConnected"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='2'">
						<xsl:attribute name="value"><xsl:value-of select="$strDisconnected"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='3'">
						<xsl:attribute name="value"><xsl:value-of select="$strDriverNotInstalled"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='4'">
						<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='10'">
						<xsl:attribute name="value"><xsl:value-of select="$strInitializing"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='11'">
						<xsl:attribute name="value"><xsl:value-of select="$strResetting"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='12'">
						<xsl:attribute name="value"><xsl:value-of select="$strClosing"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='13'">
						<xsl:attribute name="value"><xsl:value-of select="$strAdapterNotReady"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><xsl:value-of select="$strNoValue6"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>

		<xsl:if test="nicTOECapability!='0'">
			  <Data>
				  <xsl:attribute name="display"><xsl:value-of select="$strTOECapable"/></xsl:attribute>
				    <xsl:choose>
					    <xsl:when test="nicTOECapability='1'">
						    <xsl:attribute name="value"><xsl:value-of select="$strTOECapability0"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="nicTOECapability='2'">
						    <xsl:attribute name="value"><xsl:value-of select="$strTOECapability1"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="nicTOECapability='4'">
						    <xsl:attribute name="value"><xsl:value-of select="$strTOECapability2"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="nicTOECapability='8'">
						    <xsl:attribute name="value"><xsl:value-of select="$strTOECapability3"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="nicTOECapability='16'">
						    <xsl:attribute name="value"><xsl:value-of select="$strTOECapability4"/></xsl:attribute>
					    </xsl:when>
					    <xsl:otherwise>
						    <xsl:attribute name="value"><xsl:value-of select="$strNoValue"/></xsl:attribute>
					    </xsl:otherwise>
				    </xsl:choose>
			    </Data>
			    <Data>
				    <xsl:attribute name="display"><xsl:value-of select="$strTOEEnabled"/></xsl:attribute>
				    <xsl:choose>
					    <xsl:when test="isTOEEnable='true' ">
						    <xsl:attribute name="value"><xsl:value-of select="$gstrYes"/></xsl:attribute>
					    </xsl:when>
					    <xsl:otherwise>
						    <xsl:attribute name="value"><xsl:value-of select="$gstrNo"/></xsl:attribute>
					    </xsl:otherwise>
				    </xsl:choose>
			    </Data>
		</xsl:if>
		<xsl:if test="DriverName!='' ">
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strDriverName"/></xsl:attribute>
					 <xsl:attribute name="value"><xsl:value-of select="DriverName"/></xsl:attribute>
				</Data>
		</xsl:if>    
		<xsl:if test="ImagePath!='' ">
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strDriverImagePath"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="ImagePath"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="DriverVersion!='' ">
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strDriverVersion"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="DriverVersion!='0'"><xsl:value-of select="DriverVersion"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="FirmwareVersion!='' ">
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strFWVersion"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="FirmwareVersion!='0'"><xsl:value-of select="FirmwareVersion"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
				</Data>
		</xsl:if> 
		<xsl:if test="TeamName !=''">
				<Data>
			          <xsl:attribute name="display"><xsl:value-of select="$strTeamName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="TeamName"/></xsl:attribute>
				</Data>
			</xsl:if>
		<xsl:if test="teamType!='0'">
			  <Data>
				  <xsl:attribute name="display"><xsl:value-of select="$strTeamType"/></xsl:attribute>
				    <xsl:choose>
					    <xsl:when test="teamType='1'">
						    <xsl:attribute name="value"><xsl:value-of select="$strUnknown"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="teamType='10'">
						    <xsl:attribute name="value"><xsl:value-of select="$strSmartLoadBalancingandFailover"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="teamType='11'">
						    <xsl:attribute name="value"><xsl:value-of select="$strFECGECGenericTrunking"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="teamType='12'">
						    <xsl:attribute name="value"><xsl:value-of select="$str8023adLinkAggregationandLACP"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="teamType='13'">
						    <xsl:attribute name="value"><xsl:value-of select="$strSmartLoadBalancing"/></xsl:attribute>
					    </xsl:when>
					   <xsl:when test="teamType='20'">
						    <xsl:attribute name="value"><xsl:value-of select="$strAdapterFaultTolerance"/></xsl:attribute>
					    </xsl:when>
 					    <xsl:when test="teamType='21' or teamType='36' ">
						    <xsl:attribute name="value"><xsl:value-of select="$strAdaptiveLoadBalancing"/></xsl:attribute>
					    </xsl:when>
 					   <xsl:when test="teamType='22'">
						    <xsl:attribute name="value"><xsl:value-of select="$strStaticLinkAggregation"/></xsl:attribute>
					    </xsl:when>
 					   <xsl:when test="teamType='23'">
						    <xsl:attribute name="value"><xsl:value-of select="$strDynamicLinkAggregation"/></xsl:attribute>
					    </xsl:when>
 					   <xsl:when test="teamType='24'">
						    <xsl:attribute name="value"><xsl:value-of select="$strSwitchFaultTolerance"/></xsl:attribute>
					    </xsl:when> 					 
					  <xsl:when test="teamType='30'">
						   <xsl:attribute name="value"><xsl:value-of select="$strLoadbalancing"/></xsl:attribute>
					    </xsl:when>
					  <xsl:when test="teamType='31'">
						   <xsl:attribute name="value"><xsl:value-of select="$strFaulttolerance"/></xsl:attribute>
					    </xsl:when>
					  <xsl:when test="teamType='32'">
						   <xsl:attribute name="value"><xsl:value-of select="$strLoadbalancingxor"/></xsl:attribute>
					    </xsl:when>
					 <xsl:when test="teamType='33'">
						   <xsl:attribute name="value"><xsl:value-of select="$strFaultTolerancebroadcast"/></xsl:attribute>
					    </xsl:when>
					 <xsl:when test="teamType='34'">
						   <xsl:attribute name="value"><xsl:value-of select="$strIEEE8023adDynamiclinkaggregation"/></xsl:attribute>
					    </xsl:when>
					 <xsl:when test="teamType='35'">
						   <xsl:attribute name="value"><xsl:value-of select="$strTransmitloadbalancing"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='40'">
						   <xsl:attribute name="value"><xsl:value-of select="$strFailover"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='41'">
						   <xsl:attribute name="value"><xsl:value-of select="$strFailback"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='42'">
						   <xsl:attribute name="value"><xsl:value-of select="$str802.3ad"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='50'">
						   <xsl:attribute name="value"><xsl:value-of select="$strFailsafe"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='51'">
						   <xsl:attribute name="value"><xsl:value-of select="$str802.3adStatic"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='52'">
						   <xsl:attribute name="value"><xsl:value-of select="$str802.3adDynamic"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='53'">
						   <xsl:attribute name="value"><xsl:value-of select="$strSwitchIndependentLoadBalancing"/></xsl:attribute>
					    </xsl:when>		
					 <xsl:when test="teamType='60'">
						   <xsl:attribute name="value"><xsl:value-of select="$strStaticTeamingPrimary"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='61'">
						   <xsl:attribute name="value"><xsl:value-of select="$strSwitchIndependentPrimary"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='62'">
						   <xsl:attribute name="value"><xsl:value-of select="$strLACPPrimary"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='63'">
						   <xsl:attribute name="value"><xsl:value-of select="$strStaticTeamingPrimaryHyperv"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='64'">
						   <xsl:attribute name="value"><xsl:value-of select="$strSwitchIndependentPrimaryHyperv"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='65'">
						   <xsl:attribute name="value"><xsl:value-of select="$strLACPPrimaryHyperv"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='66'">
						   <xsl:attribute name="value"><xsl:value-of select="$strStaticTeamingSecondary"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='67'">
						   <xsl:attribute name="value"><xsl:value-of select="$strSwitchIndependentSecondary"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='68'">
						   <xsl:attribute name="value"><xsl:value-of select="$strLACPSecondary"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='69'">
						   <xsl:attribute name="value"><xsl:value-of select="$strStaticTeamingSecondaryHyperv"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='70'">
						   <xsl:attribute name="value"><xsl:value-of select="$strSwitchIndependentSecondaryHyperv"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='71'">
						   <xsl:attribute name="value"><xsl:value-of select="$strLACPSecondaryHyperv"/></xsl:attribute>
					    </xsl:when>
					 <xsl:when test="teamType='72'">
					 	<xsl:attribute name="value"><xsl:value-of select="$strStaticTeamingPrimaryDynamic"/></xsl:attribute>
					 </xsl:when>							
					 <xsl:when test="teamType='73'">
					    	<xsl:attribute name="value"><xsl:value-of select="$strLACPPrimaryDynamic"/></xsl:attribute>
					 </xsl:when>							
					 <xsl:when test="teamType='74'">
					    	<xsl:attribute name="value"><xsl:value-of select="$strSwitchIndependentPrimaryDynamic"/></xsl:attribute>
					 </xsl:when>							
					 <xsl:when test="teamType='75'">
					    	<xsl:attribute name="value"><xsl:value-of select="$strStaticTeamingSecondaryDynamic"/></xsl:attribute>
					 </xsl:when>							
					 <xsl:when test="teamType='76'">
					    	<xsl:attribute name="value"><xsl:value-of select="$strLACPSecondaryDynamic"/></xsl:attribute>
					 </xsl:when>							
					 <xsl:when test="teamType='77'">
					    	<xsl:attribute name="value"><xsl:value-of select="$strSwitchIndependentSecondaryDynamic"/></xsl:attribute>
					 </xsl:when>
					    <xsl:otherwise>
						    <xsl:attribute name="value"><xsl:value-of select="$strNoValue"/></xsl:attribute>
					    </xsl:otherwise>
				    </xsl:choose>
			    </Data>

</xsl:if>
<xsl:if test="/OMA/TeamMemberList/TeamMemberListObj">
	<Data>
	  <xsl:attribute name="display"><xsl:value-of select="$strInterfaceMembers"/></xsl:attribute>
	  	<xsl:apply-templates select="/OMA/TeamMemberList"/>
	</Data>
</xsl:if>

	 	</ListData>	 	
</xsl:template>  

<xsl:template name="Interface">
	<ListData name="interfacelist" type="custom">
	  <xsl:attribute name="display"><xsl:value-of select="$strInterface"/></xsl:attribute>
	  <Header>
		  <Data>
			<xsl:attribute name="display"><xsl:value-of select="$strInterface"/><xsl:value-of select="$strColon"/><xsl:value-of select="IfDescription"/></xsl:attribute>		
			<xsl:attribute name="value"><xsl:value-of select="$strInterface"/><xsl:value-of select="$strColon"/><xsl:value-of select="IfDescription"/></xsl:attribute>		
		</Data>
     </Header>
		<xsl:if test="IfDescription!='' ">
				<Data>
					 <xsl:attribute name="display"><xsl:value-of select="$strDescription"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="IfDescription"/></xsl:attribute>
				</Data>
		</xsl:if>
			

		<xsl:if test="ifType!='' ">
				<Data>
					 <xsl:attribute name="display"><xsl:value-of select="$strType"/></xsl:attribute>
					<xsl:attribute name="value">
            <xsl:call-template name="IdentifyAdapterType">
              <xsl:with-param name="type"><xsl:value-of select="ifType"/></xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
				</Data>
		</xsl:if>    
		<xsl:if test="ifOperStatus!='' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strOperStatus"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:call-template name="OperationalStatus">
              <xsl:with-param name="status"><xsl:value-of select="ifOperStatus"/></xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
				</Data>
		</xsl:if>    
		<xsl:if test="ifAdminStatus!='' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strAdminStatus"/></xsl:attribute>
          <xsl:attribute name="value">
            <xsl:call-template name="AdminStatus">
              <xsl:with-param name="status"><xsl:value-of select="ifAdminStatus"/></xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="mtu!='' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strMTU"/></xsl:attribute>
					<xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="mtu!=0 "><xsl:value-of select="mtu"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="speed!='' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strSpeed"/></xsl:attribute>
					<xsl:attribute name="value">
            <xsl:call-template name="formatSpeedValue">
              <xsl:with-param name="value"><xsl:value-of select="speed"/></xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
				</Data>
		</xsl:if>    
		<xsl:if test="DHCPServer!='' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strDHCPServer"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="DHCPServer"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="DHCPv6Server!='' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strDHCPServer"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="DHCPv6Server"/></xsl:attribute>
				</Data>
		</xsl:if>    
		<xsl:if test="DefaultGateway!='' ">
	  		<Data>
		  		<xsl:attribute name="display"><xsl:value-of select="$strDefaultGateway"/></xsl:attribute>
				  <xsl:attribute name="value"><xsl:value-of select="DefaultGateway"/></xsl:attribute>
			  </Data>
		</xsl:if>
		<xsl:if test="DefaultIPv6Gateway!='' ">
	  		<Data>
		  		<xsl:attribute name="display"><xsl:value-of select="$strDefaultGateway"/></xsl:attribute>
				  <xsl:attribute name="value"><xsl:value-of select="DefaultIPv6Gateway"/></xsl:attribute>
			  </Data>
		</xsl:if>    
  </ListData>
</xsl:template>

<xsl:template match="TeamMemberList">			

<xsl:if test="/OMA/TeamMemberList/TeamMemberListObj/numTeamMembers > '0' ">
		<ValueList>
		 <xsl:for-each select="TeamMemberListObj/teamMemberListarray/teamMemberList">					
  			<value><xsl:value-of select="IfDescription"/></value>			  						
	      </xsl:for-each>		
</ValueList>

</xsl:if>
</xsl:template>




<xsl:template match="NICAdapterStats/NetAdptStatsObj">
  <xsl:variable name="STATS_NA" select="18446744073709551615"/>
  <xsl:call-template name="PhysicalReceiveStats"/>
  <xsl:call-template name="PhysicalTransmitStats"/>
  <xsl:call-template name="InterfaceReceiveStats"/>
  <xsl:call-template name="InterfaceTransmitStats"/>
</xsl:template>
  
<xsl:template name="PhysicalReceiveStats">
<xsl:if test="rxGoodFrames!='18446744073709551615' or rxBadFrames!='18446744073709551615' or rxAlignmentErrors!='18446744073709551615' or rxFCSErrors!='18446744073709551615' or rxInternalMACRxErrors!='18446744073709551615' or rxFrameTooLongs!='18446744073709551615' ">
  <ListData name="phyrcvstats" type="custom">
	<xsl:choose>
		<xsl:when test="/OMA/NICList/VirNicObj">
	  <xsl:attribute name="display"><xsl:value-of select="$strTeamInterfaceReceiveStats"/></xsl:attribute>
	  <Header>
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strTeamInterfaceReceiveStats"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strTeamInterfaceReceiveStats"/></xsl:attribute>
		</Data>
	  </Header>
	</xsl:when>
<xsl:otherwise>
 <xsl:attribute name="display"><xsl:value-of select="$strPhyIfReceiveStats"/></xsl:attribute>
	  <Header>
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strPhyIfReceiveStats"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strPhyIfReceiveStats"/></xsl:attribute>
		</Data>
	  </Header>
</xsl:otherwise>
</xsl:choose>
	 
		<xsl:if test="rxGoodFrames!='18446744073709551615' ">
				<Data>
		      <xsl:attribute name="display"><xsl:value-of select="$strGoodFrames"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="rxGoodFrames"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="rxBadFrames!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strBadFrames"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="rxBadFrames"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="rxAlignmentErrors!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strAlignmentErrors"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="rxAlignmentErrors"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="rxFCSErrors!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strFCSErrors"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="rxFCSErrors"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="rxInternalMACRxErrors!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strInternalMACRxErrors"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="rxInternalMACRxErrors"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="rxFrameTooLongs!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strFramesTooLong"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="rxFrameTooLongs"/></xsl:attribute>
				</Data>
		</xsl:if>
	 </ListData>
</xsl:if>
  </xsl:template>

<xsl:template name="PhysicalTransmitStats">
<xsl:if test="txGoodFrames!='18446744073709551615' or txBadFrames!='18446744073709551615' or txSingleCollisionFrames!='18446744073709551615' or txMultipleCollisionFrames!='18446744073709551615' or txDeferredTransmits!='18446744073709551615' or txCollisions!='18446744073709551615' or txLateCollisions!='18446744073709551615' or txExcessiveCollisions!='18446744073709551615' or txCarrierSenseErrors!= '18446744073709551615' or txInternalMACTxErrors!='18446744073709551615' ">
  <ListData name="phytxstats" type="custom">
<xsl:choose>
		<xsl:when test="/OMA/NICList/VirNicObj">
	  <xsl:attribute name="display"><xsl:value-of select="$strTeamInterfaceTransmitStats"/></xsl:attribute>
	  <Header>
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strTeamInterfaceTransmitStats"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strTeamInterfaceTransmitStats"/></xsl:attribute>
		</Data>
	  </Header>
	</xsl:when>
<xsl:otherwise>
	  <xsl:attribute name="display"><xsl:value-of select="$strPhyIfTransmitStats"/></xsl:attribute>
	  <Header>
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strPhyIfTransmitStats"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strPhyIfTransmitStats"/></xsl:attribute>
		</Data>
	  </Header>
	 
</xsl:otherwise>
</xsl:choose>

		<xsl:if test="txGoodFrames!='18446744073709551615' ">
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strGoodFrames"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="txGoodFrames"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="txBadFrames!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strBadFrames"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="txBadFrames"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="txSingleCollisionFrames!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strSingleCollisionFrames"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="txSingleCollisionFrames"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="txMultipleCollisionFrames!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strMultipleCollisionFrames"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="txMultipleCollisionFrames"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="txDeferredTransmits!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strDeferredTransmits"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="txDeferredTransmits"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="txCollisions!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strCollisions"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="txCollisions"/></xsl:attribute>
				</Data>
		</xsl:if>    
		<xsl:if test="txLateCollisions!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strLateCollisions"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="txLateCollisions"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="txExcessiveCollisions!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strExcessiveCollisions"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="txExcessiveCollisions"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="txCarrierSenseErrors!= '18446744073709551615'">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strCarrierSenseErrors"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="txCarrierSenseErrors"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="txInternalMACTxErrors!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strInternalMACTxErrors"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="txInternalMACTxErrors"/></xsl:attribute>
				</Data>
		</xsl:if>    
	 </ListData>
</xsl:if>
  </xsl:template>

<xsl:template name="InterfaceReceiveStats">
<xsl:if test="rxBytes!='18446744073709551615' or rxTotalPackets!='18446744073709551615' or rxUnicastPackets!='18446744073709551615' or rxMulticastPackets!='18446744073709551615' or rxBroadcastPackets!='18446744073709551615' or rxDiscardedPackets!='18446744073709551615' or rxErrorPackets!='18446744073709551615' or rxUnknownProtocols!='18446744073709551615'">
  <ListData name="ifrcvstats" type="custom">
	  <xsl:attribute name="display"><xsl:value-of select="$strIfReceiveStats"/></xsl:attribute>
	  <Header>
		 		<Data >
				<xsl:attribute name="display"><xsl:value-of select="$strIfReceiveStats"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strIfReceiveStats"/></xsl:attribute>
				</Data>
     </Header>
		<xsl:if test="rxBytes!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strBytes"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="rxBytes"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="rxTotalPackets!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strTotalPackets"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="rxTotalPackets"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="rxUnicastPackets!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strUnicastPackets"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="rxUnicastPackets"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="rxMulticastPackets!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strMulticastPackets"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="rxMulticastPackets"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="rxBroadcastPackets!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strBroadcastPackets"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="rxBroadcastPackets"/></xsl:attribute>
				</Data>
		</xsl:if>    
		<xsl:if test="rxDiscardedPackets!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strDiscardedPackets"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="rxDiscardedPackets"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="rxErrorPackets!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strErrorPackets"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="rxErrorPackets"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="rxUnknownProtocols!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strUnknownProtocols"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="rxUnknownProtocols"/></xsl:attribute>
				</Data>
		</xsl:if>
	 </ListData>
</xsl:if>
  </xsl:template>
  
<xsl:template name="InterfaceTransmitStats">
<xsl:if test="txBytes!='18446744073709551615' or txTotalPackets!='18446744073709551615' or txUnicastPackets!='18446744073709551615' or txDiscardedPackets!='18446744073709551615' or txErrorPackets!='18446744073709551615' or txQueueLength!='18446744073709551615' ">
  <ListData name="iftxstats" type="custom">
	  <xsl:attribute name="display"><xsl:value-of select="$strIfTransmitStats"/></xsl:attribute>
	  <Header>
		 		<Data width ="60%">
					<xsl:attribute name="display"><xsl:value-of select="$strIfTransmitStats"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strIfTransmitStats"/></xsl:attribute>
				</Data>
     </Header>
		<xsl:if test="txBytes!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strBytes"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="txBytes"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="txTotalPackets!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strTotalPackets"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="txTotalPackets"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="txUnicastPackets!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strUnicastPackets"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="txUnicastPackets"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="txDiscardedPackets!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strDiscardedPackets"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="txDiscardedPackets"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="txErrorPackets!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strErrorPackets"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="txErrorPackets"/></xsl:attribute>
				</Data>
		</xsl:if>
		<xsl:if test="txQueueLength!='18446744073709551615' ">
				<Data>
          <xsl:attribute name="display"><xsl:value-of select="$strQueueLength"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="txQueueLength"/></xsl:attribute>
				</Data>
		</xsl:if>
	 </ListData>
</xsl:if>
  </xsl:template>
  
<xsl:template match="IPAddressList/IPUnicastAddrListObj ">
  <xsl:apply-templates select="addrListarray"/>
</xsl:template>
<xsl:template match="addrListarray">
<xsl:if test="/OMA/IPAddressList/IPUnicastAddrListObj/numIPv4Addrs>0">
 <ListData name="ipv4addr" type="custom">
    <xsl:attribute name="display"><xsl:value-of select="$strIPV4"/></xsl:attribute>
			<Header>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strIPV4"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strIPV4"/></xsl:attribute>
				</Data>
			</Header>
			
		 <xsl:for-each select="addrList">
			<xsl:if test="ipv4Addr/IPAddress!=''">
				  <Data>
				  <xsl:attribute name="display"><xsl:value-of select="$strIPAddress"/></xsl:attribute>
			      <xsl:attribute name="value"><xsl:value-of select="ipv4Addr/IPAddress"/></xsl:attribute>
				  </Data>
			    <xsl:if test="ipv4Addr/SubNetMask!=''">
				    <Data>
				    <xsl:attribute name="display"><xsl:value-of select="$strSubnetMask"/></xsl:attribute>
					    <xsl:attribute name="value"><xsl:value-of select="ipv4Addr/SubNetMask"/></xsl:attribute>
				    </Data>
			    </xsl:if>
			</xsl:if>
      </xsl:for-each>
		</ListData>
		</xsl:if>

		<xsl:if test="/OMA/IPAddressList/IPUnicastAddrListObj/numIPv6Addrs > 0">
      <TableData name="ipv6addr">
        <xsl:attribute name="display"><xsl:value-of select="$strIPV6"/></xsl:attribute>
			<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strIPV6"/>	</xsl:attribute>

			</SubHeader>
			<Header>
				<Data width="40%">
					<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strName"/></xsl:attribute>
				</Data>
				<Data width ="40%">
					<xsl:attribute name="display"><xsl:value-of select="$strIPAddress"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strIPAddress"/></xsl:attribute>
				</Data>
				<Data width ="20%">
					<xsl:attribute name="display"><xsl:value-of select="$strPrefix"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strPrefix"/></xsl:attribute>
				</Data>
			</Header>

			<xsl:for-each select="addrList/ipv6Addr/scope[not(.=following::addrList/ipv6Addr/scope)]">
				<xsl:choose>
					<xsl:when test=".='2'">
					<Row>
						<Data>	
							<xsl:attribute name="value"><xsl:value-of select="$strLinkLocal"/>	</xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="value"><xsl:value-of select="../IPv6Address"/> </xsl:attribute>
						</Data>
						<Data>            
							<xsl:attribute name="value">	
								<xsl:choose>
									<xsl:when test="../prefixLen='255'"><xsl:value-of select="$gstrNotAvailable"/></xsl:when>
									<xsl:otherwise><xsl:value-of select="../prefixLen"/></xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
						</Data>
					</Row>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each >
		

		<xsl:for-each select="addrList/ipv6Addr/IPv6Address[not(.='')]">
		<xsl:sort select ="../scope!='2'" order="descending" />
		<xsl:choose>
			<xsl:when test="position() &lt; 3 and ../scope !='2'">
				<Row>
					<Data>	
						<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="position()=1">
								<xsl:value-of select="$strIPv6Address1"/> 

							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$strIPv6Address2"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>

				<Data>
					<xsl:attribute name="value"> 
						<xsl:choose>
							<xsl:when test=".=''"> 
								<xsl:value-of select="$strNoValue"/> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="."/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>
				<Data>            
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="../prefixLen='255'"><xsl:value-of select="$gstrNotAvailable"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="../prefixLen"/></xsl:otherwise>
						</xsl:choose>
						</xsl:attribute>
					</Data>
				</Row>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each >
		</TableData>

		</xsl:if>
</xsl:template>
  <xsl:template name="IdentifyAdapterType">
    <xsl:param name="type"/>
    <xsl:choose>
      <xsl:when test="$type = 1"><xsl:value-of select="$strOther"/></xsl:when>
      <xsl:when test="$type = 6"><xsl:value-of select="$strEthernet"/></xsl:when>
      <xsl:when test="$type = 9"><xsl:value-of select="$strTokenRing"/></xsl:when> 
      <xsl:when test="$type = 23"><xsl:value-of select="$strPPP"/></xsl:when> 
      <xsl:when test="$type = 24"><xsl:value-of select="$strSWLoop"/></xsl:when> 
      <xsl:when test="$type = 37"><xsl:value-of select="$strATM"/></xsl:when> 
      <xsl:when test="$type = 71"><xsl:value-of select="$strIEEE802Wireless"/></xsl:when>
      <xsl:when test="$type = 131"><xsl:value-of select="$strTunnelType"/></xsl:when> 
      <xsl:when test="$type = 144"><xsl:value-of select="$strIEEE1394"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="OperationalStatus">
    <xsl:param name="status"/>
    <xsl:choose>
      <xsl:when test="$status = 1"><xsl:value-of select="$strUp"/></xsl:when>
      <xsl:when test="$status = 2"><xsl:value-of select="$strDown"/></xsl:when>
      <xsl:when test="$status = 3"><xsl:value-of select="$strTestMode"/></xsl:when> 
      <xsl:when test="$status = 4"><xsl:value-of select="$strUnknown"/></xsl:when> 
      <xsl:when test="$status = 5"><xsl:value-of select="$strDormant"/></xsl:when> 
      <xsl:when test="$status = 6"><xsl:value-of select="$strNotPresent"/></xsl:when> 
      <xsl:when test="$status = 7"><xsl:value-of select="$strLowerLayerDown"/></xsl:when>      
      <xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="AdminStatus">
    <xsl:param name="status"/>
    <xsl:choose>
      <xsl:when test="$status = 1"><xsl:value-of select="$strUp"/></xsl:when>
      <xsl:when test="$status = 2"><xsl:value-of select="$strDown"/></xsl:when>
      <xsl:when test="$status = 3"><xsl:value-of select="$strTestMode"/></xsl:when> 
      <xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

<xsl:template name="formatSpeedValue">
    <xsl:param name="value"/>
    <xsl:choose>
      <xsl:when test="$value = '0'"><xsl:value-of select="$gstrNotAvailable"/></xsl:when>
      <xsl:otherwise>
        <xsl:variable name="formatval"><xsl:value-of select="format-number($value div 1000000,'##0.0')"/></xsl:variable>
					<xsl:variable name="univdecsep">
						<xsl:choose>
							<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = '.'">.</xsl:when>
							<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = ','">,</xsl:when>
						</xsl:choose>
					</xsl:variable>
					<xsl:variable name="localdecsep"><xsl:value-of select="$gstrDecimalFractionSeperator"/></xsl:variable>
					<xsl:value-of select="translate($formatval, $univdecsep,$localdecsep)"/><xsl:value-of select="$strMbps"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
<!-- convert decimal to Hex -->
<xsl:variable name="hexDigits" select="'0123456789ABCDEF'" />
 <xsl:template name="DecimaltoHex">
  <xsl:param name="decimalNumber" />
     <xsl:if test="$decimalNumber >= 16">
       <xsl:call-template name="DecimaltoHex">
         <xsl:with-param name="decimalNumber" select="floor($decimalNumber div 16)" />
       </xsl:call-template>
     </xsl:if>
     <xsl:value-of select="substring($hexDigits, ($decimalNumber mod 16) + 1, 1)" />
 </xsl:template>

<xsl:template match="*"/>
</xsl:stylesheet>
