<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:strip-space elements="*"/>
	<xsl:output method="xml" indent="no"/>
	<xsl:template match="OMA">
	<DataArea>
	 	<PageTitle>
      <xsl:attribute name="display"><xsl:value-of select="$strInformationTitle_Part1"/>
        <xsl:choose>
          <xsl:when test="/OMA/ModularChassis/ChassisList/Chassis/@display='Main System Chassis'"><xsl:value-of select="$strInformationTitle_Part2"/>
          </xsl:when>
          <xsl:otherwise><xsl:value-of select="/OMA/ModularChassis/ChassisList/Chassis/ChassisInfo/ChassisProps1/ChassName"/>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text> </xsl:text>
        <xsl:value-of select="$strInformationTitle_Part3"/>
      </xsl:attribute>
    </PageTitle>
    <Header>Header</Header>
    <CustomButton>
      <Data name="Refresh">
        <xsl:attribute name="display">
          <xsl:value-of select="$strRefresh"/>
        </xsl:attribute>
        <xsl:variable name="ModChassisOid" select="/OMA/ModularChassis/ChassisList/Chassis/@oid"/>
        <xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.ModChassisWebplugin&amp;oid=<xsl:value-of select="$ModChassisOid"/>&amp;help=ModChassis&amp;app=hip</xsl:attribute>
       </Data>
    </CustomButton>
  
      <TableData name="ld1" display="{$strChassisInfo}">
        <xsl:call-template name="ChassisInfo"/>
      </TableData>
    

    <xsl:if test="/OMA/CMCProps/CMCObj">
    <TableData name="ld2" display="{$strCMCInfo}">
      <xsl:call-template name="CMCInfo"/>
    </TableData>
    </xsl:if>
      <script language="javascript">
      function loadOOB(url)
      {
        //alert(url);
        window.open(url);
      }
    </script>

  </DataArea>
</xsl:template>


  <xsl:template name="ChassisInfo">
    <SubHeader>
      <xsl:attribute name="display">
        <xsl:value-of select="$strChassisInfo"/>
      </xsl:attribute>
    </SubHeader>
    <Header>
      <Data name="SystemModelH" width="50%">
        <xsl:attribute name="display">
          <xsl:value-of select="$strAttribute"/>
        </xsl:attribute>
        <xsl:attribute name="value">
          <xsl:value-of select="$strAttribute1"/>
        </xsl:attribute>
      </Data>
      <Data>
        <xsl:attribute name="display">
          <xsl:value-of select="$strValue"/>
        </xsl:attribute>
        <xsl:attribute name="value">
          <xsl:value-of select="$strValue1"/>
        </xsl:attribute>
      </Data>
    </Header>
    
    <xsl:if test="/OMA/ModularChassis/ChassisList/Chassis/ChassisInfo/ChassisProps1">
      <xsl:call-template name="ShowValues">
        <xsl:with-param name="string1"><xsl:value-of select="$strChassisModel"/></xsl:with-param>
        <xsl:with-param name="string2">
        <xsl:choose>
	  	<xsl:when test="/OMA/CMCProps">
			<xsl:choose>
				<xsl:when test="/OMA/CMCProps/CMCObj/ChassisModelName!=''">
					<xsl:value-of select="/OMA/CMCProps/CMCObj/ChassisModelName"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="/OMA/CMCProps/CMCObj/type ='9'"><xsl:value-of select="$strChassisModelNoble"/></xsl:when>
						<xsl:when test="/OMA/CMCProps/CMCObj/type ='10'"><xsl:value-of select="$strChassisModelAvenger"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$strChassisModelInfo10g"/></xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
	  	</xsl:when>
	  	<xsl:otherwise><xsl:value-of select="$strChassisModelInfo"/></xsl:otherwise>
	  </xsl:choose>
        </xsl:with-param>
      </xsl:call-template>

      <xsl:call-template name="ShowValues">
        <xsl:with-param name="string1">
          <xsl:value-of select="$strChassisLock"/>
        </xsl:with-param>
        <xsl:with-param name="string2">
          <xsl:choose>
          <xsl:when test="/OMA/ModularChassis/ChassisList/Chassis/ChassisInfo/ChassisProps1/ChassLockPresent = 'false' ">
	  <xsl:value-of select="$strAbsent"/>
	  </xsl:when>
	   <xsl:when test="/OMA/ModularChassis/ChassisList/Chassis/ChassisInfo/ChassisProps1/ChassLockPresent = 'true' ">
	  <xsl:value-of select="$strPresent"/>
	  </xsl:when>
	  <xsl:otherwise>
	  <xsl:value-of select="$strNoValue"/>
	  </xsl:otherwise>
	  </xsl:choose> 
        </xsl:with-param>
      </xsl:call-template>
    </xsl:if>

   
    <xsl:if test="/OMA/ModularChassis/ChassisList/Chassis/ChassisInfo/ChassisProps2">
      <xsl:call-template name="ShowValues">
        <xsl:with-param name="string1">
          <xsl:value-of select="$strChassisServiceTag"/>
        </xsl:with-param>
        <xsl:with-param name="string2">
          <xsl:call-template name="DispChasSrvcTag"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:if >
  
  <xsl:if test="/OMA/ModularChassis/ChassisList/Chassis/ChassisInfo/ChassisProps2">
      <xsl:call-template name="ShowValues">
        <xsl:with-param name="string1">
          <xsl:value-of select="$strExpressServiceCode"/>
        </xsl:with-param>
        <xsl:with-param name="string2">
          <xsl:call-template name="DispExpSrvcCode"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:if >
  </xsl:template>

  <xsl:template name="CMCInfo">
    <SubHeader>
      <xsl:attribute name="display"><xsl:value-of select="$strCMCInfo"/></xsl:attribute>
    </SubHeader>
    <Header>
      <Data name="SystemModelH" width="50%">
        <xsl:attribute name="display">
          <xsl:value-of select="$strAttribute"/>
        </xsl:attribute>
        <xsl:attribute name="value">
          <xsl:value-of select="$strAttribute1"/>
        </xsl:attribute>
      </Data>
      <Data>
        <xsl:attribute name="display">
          <xsl:value-of select="$strValue"/>
        </xsl:attribute>
        <xsl:attribute name="value">
          <xsl:value-of select="$strValue1"/>
        </xsl:attribute>
      </Data>
    </Header>
    <xsl:if test="/OMA/CMCProps">
      <xsl:call-template name="ShowValues">
        <xsl:with-param name="string1">
          <xsl:value-of select="$strCMCProName"/>
        </xsl:with-param>
        <xsl:with-param name="string2">
          <xsl:value-of select="$strCMCProInfo"/>
        </xsl:with-param>
      </xsl:call-template>


      <xsl:call-template name="ShowValues">
        <xsl:with-param name="string1">
          <xsl:value-of select="$strCMCDescription"/>
        </xsl:with-param>
        <xsl:with-param name="string2">
          <xsl:value-of select="$strCMCDesc"/>
        </xsl:with-param>
      </xsl:call-template>


      <xsl:call-template name="ShowValues">
        <xsl:with-param name="string1">
          <xsl:value-of select="$strCMCVersion"/>
        </xsl:with-param>
        <xsl:with-param name="string2">
          <xsl:value-of select="/OMA/CMCProps/CMCObj/Version"/>
        </xsl:with-param>
      </xsl:call-template>


      <xsl:call-template name="ShowValues">
        <xsl:with-param name="string1">
          <xsl:value-of select="$strCMCIpAddress"/>
        </xsl:with-param>
        <xsl:with-param name="string2">
          <xsl:value-of select="/OMA/CMCProps/CMCObj/IPAddress"/>
        </xsl:with-param>
      </xsl:call-template>

      <xsl:call-template name="ShowValues">
        <xsl:with-param name="string1">
          <xsl:value-of select="$strCMCIpAddressSource"/>
        </xsl:with-param>
        <xsl:with-param name="string2">
          <xsl:if test="/OMA/CMCProps/CMCObj/ipSource='1'"><xsl:value-of select="$strStatic"/></xsl:if>
	  <xsl:if test="/OMA/CMCProps/CMCObj/ipSource='2'"><xsl:value-of select="$strDynamic"/></xsl:if>
	  <xsl:if test="/OMA/CMCProps/CMCObj/ipSource='3'"><xsl:value-of select="$strSoftware"/></xsl:if>
        </xsl:with-param>
     </xsl:call-template>

     <xsl:call-template name="ShowValues">
       <xsl:with-param name="string1">
         <xsl:value-of select="$strCMCIpAddressType"/>
       </xsl:with-param>
       <xsl:with-param name="string2">
         <xsl:if test="/OMA/CMCProps/CMCObj/ipAddrType= 0"><xsl:value-of select="$strIpV4"/></xsl:if>
         <xsl:if test="/OMA/CMCProps/CMCObj/ipAddrType= 1"><xsl:value-of select="$strIpV6"/></xsl:if>
       </xsl:with-param>
     </xsl:call-template>

     <Row>
       <Data name="LaunchPoint" ignoreoncli="true">
         <xsl:attribute name="display">
           <xsl:value-of select="$strCMCLaunchPoint"/>
         </xsl:attribute>
         <xsl:attribute name="value">
           <xsl:value-of select="$strCMCLaunchPoint"/>
         </xsl:attribute>
       </Data>
       <xsl:choose>
         <xsl:when test="/OMA/CMCProps/CMCObj/uiStatus='0'">
           <Data link="false" ignoreoncli="true">
              <xsl:attribute name="value">
               <xsl:value-of select="$strCMCLaunchPoint1"/>
             </xsl:attribute>
             <xsl:attribute name="href">javascript:loadOOB('<xsl:value-of select="/OMA/CMCProps/CMCObj/Url"/>')</xsl:attribute>
           </Data>
         </xsl:when>
         <xsl:when test="/OMA/CMCProps/CMCObj/Url/@isnull='true'">
           <Data ignoreoncli="true">
              <xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
           </Data>
         </xsl:when>
        <xsl:otherwise>
           <Data link="true" ignoreoncli="true">
             <xsl:attribute name="value">
               <xsl:value-of select="$strCMCLaunchPoint1"/>
             </xsl:attribute>
             <xsl:attribute name="href">javascript:loadOOB('<xsl:value-of select="/OMA/CMCProps/CMCObj/Url"/>')</xsl:attribute>
           </Data>
         </xsl:otherwise>
       </xsl:choose>
     </Row>
   </xsl:if>
</xsl:template>
  <xsl:template name="ShowValues">
    <xsl:param name="string1"/>
    <xsl:param name="string2"/>
    <Row>
      <Data>
        <xsl:attribute name="display"></xsl:attribute>
        <xsl:attribute name="value">
          <xsl:value-of select="$string1"/>
        </xsl:attribute>
      </Data>
      <Data>
        <xsl:attribute name="display"></xsl:attribute>
        <xsl:attribute name="value">
          <xsl:value-of select="$string2"/>
        </xsl:attribute>
      </Data>
    </Row>
  </xsl:template>

  <xsl:template name="DispChasSrvcTag">
				<xsl:if test="/OMA/ModularChassis/ChassisList/Chassis/ChassisInfo/BaseBoardList/@count > 0">
					<xsl:for-each select="/OMA/ModularChassis/ChassisList/Chassis/ChassisInfo/BaseBoardList/BaseBoard">
						<xsl:if test="BaseBoardType = 13">	
							<xsl:value-of select="ServiceTag"/>
						</xsl:if>
					</xsl:for-each>
				</xsl:if>
  </xsl:template>
  
  <xsl:template name="DispExpSrvcCode">
				<xsl:if test="/OMA/ModularChassis/ChassisList/Chassis/ChassisInfo/BaseBoardList/@count > 0">
					<xsl:for-each select="/OMA/ModularChassis/ChassisList/Chassis/ChassisInfo/BaseBoardList/BaseBoard">
						<xsl:if test="BaseBoardType = 13">	
							<xsl:value-of select="ExpressServiceCode"/>
						</xsl:if>
					</xsl:for-each>
				</xsl:if>
  </xsl:template>

</xsl:stylesheet>
