<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>
<xsl:template match="/OMA">
	<xsl:choose>
		<xsl:when test="SMStatus='0'"><xsl:call-template name="success"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="failure"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="failure">
	<DataArea>
		<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strMemory"/></xsl:attribute>	
		<xsl:attribute name="backpagetarget">./DataArea?plugin=com.dell.hip.webplugins.MemoryArrayWebPlugin&amp;poid=2&amp;help=Memory</xsl:attribute>
		<PageTitle>
			<xsl:choose>
			<xsl:when test="MemoryConfig/Capabilities/MOMOptimizer ='true' or MemoryConfig/Capabilities/MOMSpareBank ='true' or MemoryConfig/Capabilities/MOMMirroring ='true' or MemoryConfig/Capabilities/MOMAdvECC ='true'">
				<xsl:attribute name="display"><xsl:value-of select="$strMemOpMode"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="display"><xsl:value-of select="$strMemoryRedundancy"/></xsl:attribute>
			</xsl:otherwise>
			</xsl:choose>
		</PageTitle>
		<TableData>
			<Header>
				<Data name="">
					<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strError"/></xsl:attribute>
				</Data>
			</Header>
			<Row>
				<Data name="" ><xsl:attribute name="display"><xsl:value-of select="$str"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:call-template name="smstatus">
							<xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
						</xsl:call-template>
					</xsl:attribute>
				</Data>
			</Row>
		</TableData>
	</DataArea>
</xsl:template>

<xsl:template name="success">
	<DataArea>
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strMemory"/></xsl:attribute>	
			<xsl:attribute name="backpagetarget">./DataArea?plugin=com.dell.hip.webplugins.MemoryArrayWebPlugin&amp;poid=2&amp;help=Memory</xsl:attribute>
	
			<xsl:if test="MemoryConfig and ((MemoryConfig/Capabilities/MOMOptimizer!='false')or (MemoryConfig/Capabilities/MOMSpareBank!='false') or (MemoryConfig/Capabilities/MOMMirroring!='false') or (MemoryConfig/Capabilities/MOMAdvECC!='false') or (MemoryConfig/Capabilities/SpareBank!='false') or (MemoryConfig/Capabilities/Mirroring!='false') or (MemoryConfig/Capabilities/Raid5!='false') or (MemoryConfig/Capabilities/DDDC!='false'))">
				<xsl:attribute name="validate">true</xsl:attribute>
				<xsl:attribute name="onLoad">true</xsl:attribute>
				<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.hip.webplugins.SetMemConfigWebPlugin&amp;oid=<xsl:value-of select="MemoryConfig/@oid"/>&amp;poid=2</xsl:attribute>
				<script language="javascript">
					
					var memconfig;
					var memopmode;
					function validate()
					{
						var memconfig1;
							if(document.getElementById("dataarea").redconfg != null)
						{
							var j = document.getElementById("dataarea").redconfg.length;
							for (i = 0; i &lt; j; i++)
							{
								var curConfig = document.getElementById("dataarea").redconfg[i].checked;
								if(curConfig != null &amp;&amp; curConfig == true)
								{
									memconfig1 = document.getElementById("dataarea").redconfg[i].value;
								}
						}	}
						
						var memopmode1;
						if(document.getElementById("dataarea").momconfig != null)
						{
							var l = document.getElementById("dataarea").momconfig.length;
							for (i = 0; i &lt; l; i++){
								var curConfig;
								curConfig = document.getElementById("dataarea").momconfig[i].checked;
								if(curConfig != null &amp;&amp; curConfig == true)
								{
									memopmode1= document.getElementById("dataarea").momconfig[i].value;
								}
						 }
						}

						if (memconfig1 &lt; 10 &amp;&amp; memconfig1 == memconfig) 
						{
							var confgval;
							switch ( memconfig1 )
							{
							    case "2": confgval = "<xsl:value-of select="$strDisabled"/>";
									    break;
							    case "1": confgval = "<xsl:value-of select="$strSpareBank"/>";
									    break;
								  case "3": confgval = "<xsl:value-of select="$strMirroring"/>";
									    break;
								  case "4": confgval = "<xsl:value-of select="$strRaid5"/>";
									    break;
								  case "9": confgval = "<xsl:value-of select="$strDDDC"/>";
									    break;		
                                 				
							}
							alert(<xsl:value-of select="$strConfgvalIsAlready"/>);
							return false;
						}
						else if (memopmode1 &gt; 4 &amp;&amp; memopmode1 == memopmode) 
						{
							
							var confgval;
							switch ( memopmode1)
							{
							    case "5": confgval = "<xsl:value-of select="$strOptimizor"/>";
									    break;
	                              			    case "6": confgval = "<xsl:value-of select="$strSpareBank"/>";
									    break;
							   case "7": confgval = "<xsl:value-of select="$strMirroring"/>";
									    break;
							   case "8": confgval = "<xsl:value-of select="$strAdvECC"/>";
									    break;
							}
							alert(<xsl:value-of select="$strConfgvalIsAlready"/>);
							return false;
						}
						else 
						{
							alert("<xsl:value-of select="$strYouNeedTo"/>");
							return true;
						}
					}

					function initializationRoutine()
					{
						if(document.getElementById("dataarea").redconfg != null)
						{
							var j = document.getElementById("dataarea").redconfg.length;
							for (i = 0; i &lt; j; i++){
								var curConfig = document.getElementById("dataarea").redconfg[i].checked;
								if(curConfig != null &amp;&amp; curConfig == true)
								{
									memconfig = document.getElementById("dataarea").redconfg[i].value;
								}
							}
						}
						if(document.getElementById("dataarea").momconfig != null)
						{
							var l = document.getElementById("dataarea").momconfig.length;

							for (i = 0; i &lt; l; i++){

								var curConfig = document.getElementById("dataarea").momconfig[i].checked;
								if(curConfig != null &amp;&amp; curConfig == true)
								{
									memopmode= document.getElementById("dataarea").momconfig[i].value;
								}
							}
						}
					}

				</script>
			</xsl:if>
		

		<xsl:if test="OMAUserRights='7'">
			<xsl:if test="MemoryConfig and (ShutDownFlag='true')">
			<HiddenTable>
				<Data name="DatypeTag" type="hidden">
					<xsl:choose>
						<xsl:when test="/OMA/ShutDownDA = 'dceda' ">							
								<xsl:attribute name="returnvalue">dceda</xsl:attribute>			
						 </xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="returnvalue">hipda</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</Data>			
			</HiddenTable>
				<script language="javascript">
					function restart()
					{
						if (confirm("<xsl:value-of select="$strAreYouDone"/>")){
							document.getElementById("dataarea").action=top.gnv.appendVID('./SubmitForm?plugin=com.dell.hip.webplugins.shtdwnWebPlugin&amp;os=8&amp;action1=1');
							document.getElementById("dataarea").submit();
						}
						
					}
				</script>
			</xsl:if>
		</xsl:if>
		<PageTitle>
			<xsl:choose>
				<xsl:when test="MemoryConfig/Capabilities/MOMOptimizer ='true'or MemoryConfig/Capabilities/MOMSpareBank ='true' or MemoryConfig/Capabilities/MOMMirroring ='true' or MemoryConfig/Capabilities/MOMAdvECC ='true'">				
				<xsl:attribute name="display"><xsl:value-of select="$strMemOpMode"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise><xsl:attribute name="display"><xsl:value-of select="$strMemoryRedundancy"/></xsl:attribute>
			</xsl:otherwise>
			</xsl:choose>
		</PageTitle>

		<CustomButton>
			<xsl:if test="OMAUserRights='7'">
				<xsl:if test="MemoryConfig and (ShutDownFlag='true')">
					<Data name="shtdwn">
						<xsl:attribute name="display"><xsl:value-of select="$strRebootSystem"/></xsl:attribute>
						<xsl:attribute name="href">javascript:restart()</xsl:attribute>
						<xsl:attribute name="formSubmit">true</xsl:attribute>
					</Data>
				</xsl:if>
			</xsl:if>
			<Data name="Refresh">
				<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.MemoryConfigWebPlugin&amp;poid=2&amp;help=Memory</xsl:attribute>
			</Data>
		</CustomButton>
		<xsl:if test="MemoryConfig">
			<ListData type="custom">
			<Header>
				<xsl:choose>
				<xsl:when test="MemoryConfig/Capabilities/MOMOptimizer ='true'or MemoryConfig/Capabilities/MOMSpareBank ='true' or MemoryConfig/Capabilities/MOMMirroring ='true' or MemoryConfig/Capabilities/MOMAdvECC ='true'">
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strMemOpModeConfig"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strMemOpModeConfig"/></xsl:attribute>
				</Data>
				</xsl:when>
				<xsl:otherwise>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strRedundancyConfiguration"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strRedundancyConfiguration"/></xsl:attribute>
				</Data>
				</xsl:otherwise>
				</xsl:choose>
			</Header>
			
				
				<xsl:apply-templates select="MemoryConfig"/>
			</ListData>
		</xsl:if>
		
	</DataArea>
</xsl:template>

<xsl:template match="MemoryConfig">
<xsl:choose>
	<xsl:when test="Capabilities/MOMOptimizer ='true' or Capabilities/MOMSpareBank ='true' or Capabilities/MOMMirroring ='true' or Capabilities/MOMAdvECC ='true'">
	<xsl:call-template name="MOMConfig"/>
	</xsl:when>
	<xsl:otherwise><xsl:call-template name="RedudancyConfig"/></xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template name="RedudancyConfig">
					
					
							<Data>
								<xsl:attribute name="name">redconfg</xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strDisabled"/></xsl:attribute>
								<xsl:attribute name="type">radio</xsl:attribute>
								<xsl:attribute name="returnvalue">2</xsl:attribute>
								<xsl:attribute name="state"><xsl:if test="State='0'">1</xsl:if></xsl:attribute>
							</Data>
						
							
							<xsl:for-each select="Capabilities/*">
					
							<xsl:if test=".='true'">
							
								<Data type="radio">
									<xsl:attribute name="name">redconfg</xsl:attribute>
									<xsl:attribute name="display">
										<xsl:choose>
											<xsl:when test="name()='SpareBank'"><xsl:value-of select="$strSpareBank"/></xsl:when>
											<xsl:when test="name()='Mirroring'"><xsl:value-of select="$strMirroring"/></xsl:when>
											<xsl:when test="name()='Raid5'"><xsl:value-of select="$strRaid5"/></xsl:when>	
											<xsl:when test="name()='DDDC'"><xsl:value-of select="$strDDDC"/></xsl:when>	
											<xsl:otherwise><xsl:value-of select="name()"/></xsl:otherwise>
										</xsl:choose>
									</xsl:attribute>
									<xsl:attribute name="returnvalue">
										<xsl:if test="name()='SpareBank'">1</xsl:if>
										<xsl:if test="name()='Mirroring'">3</xsl:if>
										<xsl:if test="name()='Raid5'">4</xsl:if>
										<xsl:if test="name()='DDDC'">9</xsl:if>
									</xsl:attribute>
									<xsl:attribute name="state">
										<xsl:if test="name()='SpareBank'"><xsl:if test="/OMA/MemoryConfig/State='1'">1</xsl:if></xsl:if>
										<xsl:if test="name()='Mirroring'"><xsl:if test="/OMA/MemoryConfig/State='2'">1</xsl:if></xsl:if>
										<xsl:if test="name()='Raid5'"><xsl:if test="/OMA/MemoryConfig/State='3'">1</xsl:if></xsl:if>
										<xsl:if test="name()='DDDC'"><xsl:if test="/OMA/MemoryConfig/State='8'">1</xsl:if></xsl:if>
									</xsl:attribute>
								</Data>
							</xsl:if>
						</xsl:for-each>
			
</xsl:template>

<xsl:template name="MOMConfig">
												
						<xsl:for-each select="Capabilities/*">
							<xsl:if test=".='true'">
							
								<Data type="radio">
									<xsl:attribute name="name">momconfig</xsl:attribute>
									<xsl:attribute name="display">
										<xsl:choose>
											<xsl:when test="name()='MOMSpareBank'"><xsl:value-of select="$strSpareBank"/></xsl:when>
											<xsl:when test="name()='MOMMirroring'"><xsl:value-of select="$strMirroring"/></xsl:when>
											<xsl:when test="name()='MOMOptimizer'"><xsl:value-of select="$strOptimizor"/></xsl:when>
											<xsl:when test="name()='MOMAdvECC'"><xsl:value-of select="$strAdvECC"/></xsl:when>
											<xsl:otherwise><xsl:value-of select="name()"/></xsl:otherwise>
										</xsl:choose>
									</xsl:attribute>
									<xsl:attribute name="returnvalue">
										<xsl:if test="name()='MOMOptimizer'">5</xsl:if>
										<xsl:if test="name()='MOMSpareBank'">6</xsl:if>
										<xsl:if test="name()='MOMMirroring'">7</xsl:if>
										<xsl:if test="name()='MOMAdvECC'">8</xsl:if>

									</xsl:attribute>
									<xsl:attribute name="state">
										<xsl:if test="name()='MOMOptimizer'"><xsl:if test="/OMA/MemoryConfig/State='4'">1</xsl:if></xsl:if>
										<xsl:if test="name()='MOMSpareBank'"><xsl:if test="/OMA/MemoryConfig/State='5'">1</xsl:if></xsl:if>
										<xsl:if test="name()='MOMMirroring'"><xsl:if test="/OMA/MemoryConfig/State='6'">1</xsl:if></xsl:if>
										<xsl:if test="name()='MOMAdvECC'"><xsl:if test="/OMA/MemoryConfig/State='7'">1</xsl:if></xsl:if>
									</xsl:attribute>
								</Data>
							
							</xsl:if>

						</xsl:for-each>
			
</xsl:template>


<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><xsl:value-of select="$strCommandUnsuccessful"/></xsl:when>
			<xsl:when test="$status = '1'"><xsl:value-of select="$strCommandNotImplemented"/></xsl:when>
			<xsl:when test="$status = '2'"><xsl:value-of select="$strBadCommand"/></xsl:when>
			<xsl:when test="$status = '3'"><xsl:value-of select="$strCommandTimeout"/></xsl:when>
			<xsl:when test="$status = '4'"><xsl:value-of select="$strCommandCancelled"/></xsl:when>
			<xsl:when test="$status = '5'"><xsl:value-of select="$strCommandAborted"/></xsl:when>
			<xsl:when test="$status = '6'"><xsl:value-of select="$strCommandPending"/></xsl:when>
			<xsl:when test="$status = '7'"><xsl:value-of select="$strNoSuchDevice"/></xsl:when>
			<xsl:when test="$status = '8'"><xsl:value-of select="$strDeviceBusy"/></xsl:when>
			<xsl:when test="$status = '9'"><xsl:value-of select="$strBadDevice"/></xsl:when>
			<xsl:when test="$status = '10'"><xsl:value-of select="$strSpuriousInterrupt"/></xsl:when>
			<xsl:when test="$status = '11'"><xsl:value-of select="$strResourceLocked"/></xsl:when>
			<xsl:when test="$status = '12'"><xsl:value-of select="$strInvalidIndex"/></xsl:when>
			<xsl:when test="$status = '13'"><xsl:value-of select="$strSMBError"/></xsl:when>
			<xsl:when test="$status = '14'"><xsl:value-of select="$strDataRequestedIs"/></xsl:when>
			<xsl:when test="$status = '15'"><xsl:value-of select="$strDataRequestedIs1"/></xsl:when>
			<xsl:when test="$status = '16'"><xsl:value-of select="$strDataRequestedIs2"/></xsl:when>
			<xsl:when test="$status = '17'"><xsl:value-of select="$strDeviceNotYet"/></xsl:when>
			<xsl:when test="$status = '18'"><xsl:value-of select="$strDeviceDoesNot"/></xsl:when>
			<xsl:when test="$status = '19'"><xsl:value-of select="$strDeviceOutOf"/></xsl:when>
			<xsl:when test="$status = '20'"><xsl:value-of select="$strDeviceAlreadyExists"/></xsl:when>
			<xsl:when test="$status = '256'"><xsl:value-of select="$strMemoryObjectNot"/></xsl:when>
			<xsl:when test="$status = '257'"><xsl:value-of select="$strMemoryObjectMalformed"/></xsl:when>
			<xsl:when test="$status = '258'"><xsl:value-of select="$strMemoryObjectAlready"/></xsl:when>
			<xsl:when test="$status = '260'"><xsl:value-of select="$strINIFileNot"/></xsl:when>
			<xsl:when test="$status = '261'"><xsl:value-of select="$strINIMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '262'"><xsl:value-of select="$strINISectionDoes"/></xsl:when>
			<xsl:when test="$status = '263'"><xsl:value-of select="$strINIKeyDoes"/></xsl:when>
			<xsl:when test="$status = '264'"><xsl:value-of select="$strINIValueMalformed"/></xsl:when>
			<xsl:when test="$status = '270'"><xsl:value-of select="$strInsufficientAccessRights"/></xsl:when>
			<xsl:when test="$status = '271'"><xsl:value-of select="$strInvalidParameterName"/></xsl:when>
			<xsl:when test="$status = '272'"><xsl:value-of select="$strOutOfMemory"/></xsl:when>
			<xsl:when test="$status = '280'"><xsl:value-of select="$strXMLFileNot"/></xsl:when>
			<xsl:when test="$status = '281'"><xsl:value-of select="$strXMLMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '282'"><xsl:value-of select="$strXMLNodeDoes"/></xsl:when>
			<xsl:when test="$status = '283'"><xsl:value-of select="$strXMLValueMalformed"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$strSMStatus"/><xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
</xsl:template>

<xsl:template match="*"/>
</xsl:stylesheet>
