<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <xsl:template match="OMA">
		<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
		<DataArea validate="true" onLoad="true">
			<xsl:if test="$usrights='7'">
				<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.hip.webplugins.SetPEFConfigWebPlugin&amp;type=<xsl:value-of select="/OMA/Type"/>
				</xsl:attribute>
			</xsl:if>

			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strPlatformEvents"/></xsl:attribute>
			</PageTitle>
			<Header>Header</Header>
			<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.ListPEFWebPlugin&amp;type=<xsl:value-of select="/OMA/Type"/>&amp;help=ListPEF</xsl:attribute>
				</Data>
			</CustomButton>
			<CustomButton align="left">
				<Data name="Configure">
					<xsl:attribute name="display"><xsl:value-of select="$strConfigureDestinations"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.ListPEFDestWebPlugin&amp;type=<xsl:value-of select="/OMA/Type"/>&amp;help=LPEFDest</xsl:attribute>
				</Data>
			</CustomButton>	

			<script language="javascript">
			
				var usrights = '<xsl:value-of select="/OMA/OMAUserRights"/>'
			
				function EnableSettingsAccordingtoUserRights()
				{		
					if (usrights != 7 )
					{
						document.getElementById("alertsEnable").disabled = true;
					}
				}
			
				function initializationRoutine()
				{
					EnableSettingsAccordingtoUserRights();
					//document.getElementById("ShutdownMode").checked = true;
					//document.getElementById("GenerateAlert").checked = true;
				}
				
				function validate()
				{
					return true;
				}

			</script>

			<ListData type="custom"  name="tabPEFConfig">
				<xsl:attribute name="display"><xsl:value-of select="$strPEFConfig"/></xsl:attribute>
				<Header>
          <Data>
					<xsl:attribute name="display"><xsl:value-of select="$strPEFConfig"/></xsl:attribute>
            <xsl:attribute name="value"><xsl:value-of select="$strPEFConfig"/></xsl:attribute>
            </Data>
				</Header>
				<xsl:choose>
					<xsl:when test="/OMA/@cli = 'true'">
						<Header>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strAttribute"/>	</xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strAttribute"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strValue"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strValue"/></xsl:attribute>
							</Data>
						</Header>
					</xsl:when>
					<xsl:otherwise>
						<PromptText>
						      <xsl:if test="(/OMA/OMAUserRights = '7')">
								<xsl:value-of select="$strSelectValues"/><xsl:text> </xsl:text>
						    </xsl:if>
						    <xsl:value-of select="$strNoteEnable"/>
						</PromptText>
					</xsl:otherwise>
				</xsl:choose>

			   <xsl:apply-templates select="EMPLANConfigObj"/>
			</ListData>

			<TableData columnspacing="true" name="tabPEFList">
				<xsl:attribute name="display"><xsl:value-of select="$strPEFList"/></xsl:attribute>

				<xsl:if test="(/OMA/OMAUserRights = '7')">
					<PromptText><xsl:value-of select="$strClickTheEvent"/></PromptText>
				</xsl:if>
					<xsl:choose>
					<xsl:when test="/OMA/@cli = 'true'">
						<Header>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strEvent"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strEvent"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strHardReboot"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strHardReboot"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strHardPowerCycle"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strHardPowerCycle"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strHardPowerOff"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strHardPowerOff"/></xsl:attribute>
							</Data>
							<xsl:if test=" /OMA/EMPObj/type &lt; '10'" > 
								<xsl:if test=" count(/OMA/EMPPEFEvtFltrListObj/eventFilterListarray/eventFilterList[filterKey = '524547' or filterKey = '1048835']) &gt; 0" >
										<Data>
											<xsl:attribute name="display"><xsl:value-of select="$strPowerReduction"/></xsl:attribute>
											<xsl:attribute name="value"><xsl:value-of select="$strPowerReduction"/></xsl:attribute>
										</Data>
								</xsl:if>
							</xsl:if>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strGenerateAlert"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strGenerateAlert"/></xsl:attribute>
							</Data>
						
            </Header>
          </xsl:when>
          <xsl:otherwise>
            <SubHeader>
              <xsl:attribute name="display"><xsl:value-of select="$strPEFList"/></xsl:attribute>
            </SubHeader>
            <Header>
              <Data name="Event">
                <xsl:attribute name="display"></xsl:attribute>
              </Data>
              <Data name="Action" underlined="true" align="center">
				<xsl:choose>
					<xsl:when test=" count(/OMA/EMPPEFEvtFltrListObj/eventFilterListarray/eventFilterList[filterKey = '524547' or filterKey = '1048835']) &gt; 0" >
						<xsl:attribute name="colspan">5</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="colspan">4</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
                <xsl:attribute name="display"><xsl:value-of select="$strCurrentlyActiveActions"/></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="$strCurrentlyActiveActions"/></xsl:attribute>
              </Data>
            </Header>
            <Header>
              <Data name=" ">
                <xsl:attribute name="display"><xsl:value-of select="$strEvent"/></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="$strEvent"/></xsl:attribute>
              </Data>
              <Data name="" append="Action" align="center">
                <xsl:attribute name="display"><xsl:value-of select="$strHardReboot"/></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="$strHardReboot"/></xsl:attribute>
              </Data>
              <Data name="" append="Action" align="center">
                <xsl:attribute name="display"><xsl:value-of select="$strHardPowerCycle"/></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="$strHardPowerCycle"/></xsl:attribute>
              </Data>
              <Data name="" append="Action" align="center">
                <xsl:attribute name="display"><xsl:value-of select="$strHardPowerOff"/></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="$strHardPowerOff"/></xsl:attribute>
              </Data>
	      <xsl:if test=" /OMA/EMPObj/type &lt; '10'" > //IDRAC TYPE VALUE 10 MEANS 11G
              <xsl:if test=" count(/OMA/EMPPEFEvtFltrListObj/eventFilterListarray/eventFilterList[filterKey = '524547' or filterKey = '1048835']) &gt; 0" >
                <Data name="" append="Action" align="center">
                  <xsl:attribute name="display"><xsl:value-of select="$strPowerReduction"/></xsl:attribute>
                  <xsl:attribute name="value"><xsl:value-of select="$strPowerReduction"/></xsl:attribute>
                </Data>
              </xsl:if>
	      </xsl:if>
              <Data name="" append="Action" align="center">
                <xsl:attribute name="display"><xsl:value-of select="$strGenerateAlert"/></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="$strGenerateAlert"/></xsl:attribute>
              </Data>
						</Header>
						
					</xsl:otherwise>
				</xsl:choose>
				<xsl:apply-templates select="EMPPEFEvtFltrListObj/eventFilterListarray/eventFilterList"/>
			</TableData>

			</DataArea>
		
	</xsl:template>

	<xsl:template match="eventFilterList">
			<xsl:variable name="varPEFName">
				<xsl:call-template name="getPEFName">
					<xsl:with-param name="filterId"><xsl:value-of select="filterKey"/></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
      <xsl:if test="$varPEFName != $strPEFUnknown">
      <Row>
			<xsl:element name="Data">
				<xsl:attribute name="display"><xsl:value-of select="$varPEFName"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$varPEFName"/></xsl:attribute>
				<xsl:attribute name="type">ustring</xsl:attribute>
				<xsl:if test="/OMA/OMAUserRights = '7'">
					<xsl:attribute name="link">true</xsl:attribute>
				</xsl:if>
				<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.PEFWebPlugin&amp;oid=<xsl:value-of select="@oid"/>&amp;type=<xsl:value-of select="/OMA/Type"/>&amp;peftype=<xsl:value-of select="filterKey"/>&amp;help=SetPEF</xsl:attribute>
				<xsl:attribute name="editable">false</xsl:attribute>
				<xsl:attribute name="align">left</xsl:attribute>
			</xsl:element>
			<Data type="text" align="center">
				<xsl:attribute name="value">
					<xsl:call-template name="getaction">
						<xsl:with-param name="status"><xsl:value-of select="evtFltrActionReset"/></xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
				<xsl:attribute name="alt">
					<xsl:call-template name="getactiontxt">
						<xsl:with-param name="status"><xsl:value-of select="evtFltrActionReset"/></xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
			</Data>
			<Data type="text" align="center">
				<xsl:attribute name="value">
					<xsl:call-template name="getaction">
						<xsl:with-param name="status"><xsl:value-of select="evtFltrActionPwrCycl"/></xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
				<xsl:attribute name="alt">
					<xsl:call-template name="getactiontxt">
						<xsl:with-param name="status"><xsl:value-of select="evtFltrActionPwrCycl"/></xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
			</Data>
			<Data type="text" align="center">
				<xsl:attribute name="value">
					<xsl:call-template name="getaction">
						<xsl:with-param name="status"><xsl:value-of select="evtFltrActionPwrOff"/></xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
				<xsl:attribute name="alt">
					<xsl:call-template name="getactiontxt">
						<xsl:with-param name="status"><xsl:value-of select="evtFltrActionPwrOff"/></xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
			</Data>
	<xsl:if test=" /OMA/EMPObj/type &lt; '10'" > //IDRAC TYPE VALUE 10 MEANS 11G
      <xsl:if test=" count(/OMA/EMPPEFEvtFltrListObj/eventFilterListarray/eventFilterList[filterKey = '524547' or filterKey = '1048835']) &gt; 0" >
        <Data type="text" align="center">
          <xsl:attribute name="value">
            <xsl:call-template name="getaction">
	     <xsl:with-param name="OEM"><xsl:value-of select="/OMA/EMPPEFConfigObj/PEFActionGlobalControl/OEM"/></xsl:with-param>
              <xsl:with-param name="status"><xsl:value-of select="evtFltrActionOEM"/></xsl:with-param>
              <xsl:with-param name="FilterKEY"><xsl:value-of select="filterKey"/></xsl:with-param>
              <xsl:with-param name="PowerMonitoring">true</xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
          <xsl:attribute name="alt">
            <xsl:call-template name="getactiontxt">
	     <xsl:with-param name="OEM"><xsl:value-of select="/OMA/EMPPEFConfigObj/PEFActionGlobalControl/OEM"/></xsl:with-param>
              <xsl:with-param name="FilterKEY"><xsl:value-of select="filterKey"/></xsl:with-param>
              <xsl:with-param name="PowerMonitoring">true</xsl:with-param>
              <xsl:with-param name="status"><xsl:value-of select="evtFltrActionOEM"/></xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
        </Data>
      </xsl:if>
	</xsl:if>
      <Data type="text" align="center">
        <xsl:attribute name="value">
          <xsl:call-template name="getaction">
            <xsl:with-param name="status">
              <xsl:value-of select="evtFltrActionAlert"/>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:attribute>
        <xsl:attribute name="alt">
          <xsl:call-template name="getactiontxt">
            <xsl:with-param name="status">
              <xsl:value-of select="evtFltrActionAlert"/>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:attribute>
      </Data>
      </Row>
      </xsl:if>
			</xsl:template>

	<xsl:template match="EMPLANConfigObj">
    <Data name="alertsEnable" type="checkbox" editable="true" align="left" >
				<xsl:attribute name="display"><xsl:value-of select="$strAlertsEnable"/></xsl:attribute>
				<xsl:if test="PEFAlertingEnable='1'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
 </xsl:template>

	<xsl:template name="getPEFName">
		<xsl:param name="filterId"/>
		<xsl:choose>
			<xsl:when test="$filterId = '1048836'"><xsl:value-of select="$strFanProbeFailure"/></xsl:when>
			<xsl:when test="$filterId = '1048834'"><xsl:value-of select="$strVoltageProbeFailure"/></xsl:when>
			<xsl:when test="$filterId = '1049346'"><xsl:value-of select="$strDiscreteVoltageProbeFailure"/></xsl:when>
			<xsl:when test="$filterId = '524545'"> <xsl:value-of select="$strTemperatureProbeWarning"/></xsl:when>
			<xsl:when test="$filterId = '1048833'"><xsl:value-of select="$strTemperatureProbeFailure"/></xsl:when>
			<xsl:when test="$filterId = '1076997'"><xsl:value-of select="$strChassisIntrusionDetected"/></xsl:when>
			<xsl:when test="$filterId = '527359'"> <xsl:value-of select="$strRedundancyDegraded"/></xsl:when>
			<xsl:when test="$filterId = '1051647'"><xsl:value-of select="$strRedundancyLost"/></xsl:when>
			<xsl:when test="$filterId = '552711'"> <xsl:value-of select="$strProcessorWarning"/></xsl:when>
			<xsl:when test="$filterId = '1076999'"><xsl:value-of select="$strProcessorFailure"/></xsl:when>
			<xsl:when test="$filterId = '552712'"> <xsl:value-of select="$strPSVRMD2DWarning"/></xsl:when>
			<xsl:when test="$filterId = '1077000'"><xsl:value-of select="$strPSVRMD2DFailure"/></xsl:when>
			<xsl:when test="$filterId = '1077008'"><xsl:value-of select="$strHardwareLogFailure"/></xsl:when>
			<xsl:when test="$filterId = '1077027'"><xsl:value-of select="$strAutomaticSystemRecovery"/></xsl:when>
			<xsl:when test="$filterId = '552745'"> <xsl:value-of select="$strBatteryWarning"/></xsl:when>
			<xsl:when test="$filterId = '1077033'"><xsl:value-of select="$strBatteryFailure"/></xsl:when>
			<xsl:when test="$filterId = '1109767'"><xsl:value-of select="$strProcessorAbsent"/></xsl:when>
			<xsl:when test="$filterId = '1109768'"><xsl:value-of select="$strPowerSupplyAbsent"/></xsl:when>
			<xsl:when test="$filterId = '524547'"><xsl:value-of select="$strSystemPowerProbeWarning"/></xsl:when>
			<xsl:when test="$filterId = '1048835'"><xsl:value-of select="$strSystemPowerProbeFailure"/></xsl:when>
			<xsl:when test="$filterId = '1077269'"><xsl:value-of select="$strStorageDeviceFailure"/></xsl:when>
			<xsl:when test="$filterId = '159765'"><xsl:value-of select="$strStorageDeviceAbsent"/></xsl:when>
			<xsl:when test="$filterId = '552981'"><xsl:value-of select="$strStorageDeviceWarning"/></xsl:when>
			<xsl:when test="$filterId = '1077193'"><xsl:value-of select="$strInternalDualSDCardCritical"/></xsl:when>
			<xsl:when test="$filterId = '552905'"><xsl:value-of select="$strInternalDualSDCardWarning"/></xsl:when>
			<xsl:when test="$filterId = '1109961'"><xsl:value-of select="$strInternalDualSDCardAbsent"/></xsl:when>
			<xsl:when test="$filterId = '1051593'"><xsl:value-of select="$strInternalDualSDCardRedunLost"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$strPEFUnknown"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

  <xsl:template name="getaction">
    <xsl:param name="OEM" value="false"/>
    <xsl:param name="status"/>
    <xsl:param name="FilterKEY"/>
    <xsl:param name="PowerMonitoring"/>

    <xsl:choose>
    <xsl:when test="$OEM='false'"><xsl:value-of select="$strOff"/></xsl:when>
    <xsl:when test="$status='true'"><xsl:value-of select="$strOn"/></xsl:when>
    <xsl:when test="(not($FilterKEY='524547' or $FilterKEY='1048835')) and $PowerMonitoring='true'">/oma/images/not-applicable.gif</xsl:when>
    <xsl:otherwise><xsl:value-of select="$strOff"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

<xsl:template name="getactiontxt">
    <xsl:param name="OEM"  value="false"/>
    <xsl:param name="FilterKEY"/>
    <xsl:param name="PowerMonitoring"/>
		<xsl:param name="status"/>
    <xsl:choose>
    <xsl:when test="$OEM='false'"><xsl:value-of select="$strNotApplicable"/></xsl:when>
    <xsl:when test="$status='true' "><xsl:value-of select="$strSelected"/></xsl:when>
    <xsl:when test="(not($FilterKEY='524547' or $FilterKEY='1048835')) and $PowerMonitoring='true'"><xsl:value-of select="$strNotApplicable"/></xsl:when>
    <xsl:otherwise><xsl:value-of select="$strNotSelected"/></xsl:otherwise>
    </xsl:choose>
	</xsl:template>
</xsl:stylesheet>
