<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/OMA">
		<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
		<xsl:variable name="fqdnwarnflag"><xsl:value-of select="EMPLANAltDestListObj/enableWarning"/></xsl:variable>
		<DataArea validate="true" onLoad="true">
		<!--DataArea exportdata="false"-->

			<xsl:if test="$usrights='7'">
					<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.hip.webplugins.SetPEFDestConfigWebPlugin&amp;type=<xsl:value-of select="/OMA/Type"/>
					</xsl:attribute>
			</xsl:if>

			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strPlatformEvents"/></xsl:attribute>
			<xsl:attribute name="backpagetarget">./DataArea?plugin=com.dell.hip.webplugins.ListPEFWebPlugin&amp;help=ListPEF</xsl:attribute>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strPlatformEventAlertDestinations"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.ListPEFDestWebPlugin&amp;type=<xsl:value-of select="/OMA/Type"/>&amp;help=LPEFDest</xsl:attribute>
				</Data>
			</CustomButton>
			
			<script language="javascript">
			
				var usrights = '<xsl:value-of select="/OMA/OMAUserRights"/>'
			
				function EnableSettingsAccordingtoUserRights()
				{		
					if ((usrights != 7 ) )
					{
						document.getElementById("CommunityString").disabled = true;
					}


				}
			
				function initializationRoutine()
				{
					EnableSettingsAccordingtoUserRights();
					//document.getElementById("ShutdownMode").checked = true;
					//document.getElementById("GenerateAlert").checked = true;
				}
				
				function validate()
				{
					return true;
				}

			</script>
			
			<TableData columnspacing="true" name="tabDestinatinList"><xsl:attribute name="display"><xsl:value-of select="$strDestinationList"/></xsl:attribute>
				<SubHeader>
					<xsl:attribute name="display"><xsl:value-of select="$strDestinationList"/></xsl:attribute>
				</SubHeader>
				

<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
					<PromptText>
						<xsl:value-of select="$strClickDestination"/>
					</PromptText>
				</xsl:if>




				<xsl:choose>
					<xsl:when test="/OMA/@cli = 'true'">
						<Header>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strDestinationNumber"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strDestinationNumber"/></xsl:attribute>
							</Data>
							
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strState"/></xsl:attribute>
							</Data>
							
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strDestinationIPAddress"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strDestinationIPAddress"/></xsl:attribute>
							</Data>
							<!--Data>
								<xsl:attribute name="display"><xsl:value-of select="$strDestinationGateway"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strDestinationGateway"/></xsl:attribute>
							</Data-->
						</Header>
					</xsl:when>
					<xsl:otherwise>
						<Data name="Event">
							<xsl:attribute name="display"/>
						</Data>
						<Data name="Action" colspan="7" underlined="true" align="center">
							<xsl:attribute name="display"><xsl:value-of select="$strClickDestination"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strClickDestination"/></xsl:attribute>
						</Data>
						<Header>
							<Data name=" " width="30%">
								<xsl:attribute name="value"><xsl:value-of select="$str"/></xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strDestinationNumber"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strDestinationNumber"/></xsl:attribute>
							</Data>
							
							<Data name=" " width="15%">
								<xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strState"/></xsl:attribute>
							</Data>

							<Data name="" append="Action" align="left" width="55%">
								<xsl:attribute name="display"><xsl:value-of select="$strDestinationIPAddress"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strDestinationIPAddress"/></xsl:attribute>
							</Data>
						</Header>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:apply-templates select="EMPLANAltDestListObj"/>
			</TableData>
			
			<ListData type="custom" name="tabDestinatinConfig">
        <xsl:attribute name="display"><xsl:value-of select="$strDestinationConfig"/></xsl:attribute>
				<Header>
          <Data>
					<xsl:attribute name="display"><xsl:value-of select="$strDestinationConfig"/></xsl:attribute>
            <xsl:attribute name="value"><xsl:value-of select="$strDestinationConfig"/></xsl:attribute>
            </Data>
				</Header>
				<xsl:choose>
					<xsl:when test="/OMA/@cli = 'true'">

					
						<!--Header>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strDestinationConfig"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strDestinationConfig"/></xsl:attribute>
							</Data>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strCommunityString"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strCommunityString"/></xsl:attribute>
							</Data>
						</Header-->
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
							<PromptText>
								<xsl:value-of select="$strSelectValues"/> 
								<xsl:if test="$fqdnwarnflag = 'true'">
								<xsl:value-of select="$strFQDNReportGUIWarnMsg"/>
								</xsl:if>
							</PromptText>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			   <xsl:apply-templates select="EMPLANConfigObj"/>
			</ListData>
		<xsl:if test="/OMA/@cli = 'true'">
			<xsl:if test="$fqdnwarnflag = 'true'">								
				<PromptText><xsl:value-of select ="$strFQDNReportCLIWarnMsg"/></PromptText>
			</xsl:if>
		</xsl:if>
		</DataArea>
	</xsl:template>
	
	
	<xsl:template match="EMPLANAltDestListObj">
		<xsl:apply-templates select="LANAlertDestListarray/LANAlertDestList"/>
	</xsl:template>
	
	<xsl:template match="LANAlertDestListarray/LANAlertDestList">
		<xsl:variable name="varDestSelector"><xsl:value-of select="destSelector"/></xsl:variable>
		<Row>
			<xsl:element name="Data">
				<xsl:attribute name="display"><xsl:value-of select="destSelector"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strDestination"/><xsl:value-of select="destSelector"/></xsl:attribute>
				<xsl:attribute name="type">ustring</xsl:attribute>

				<xsl:if test="(/OMA/OMAUserRights = '7') ">
					<xsl:attribute name="link">true</xsl:attribute>
				</xsl:if>

				<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.PEFDestWebPlugin&amp;oid=<xsl:value-of select="@oid"/>&amp;type=<xsl:value-of select="/OMA/Type"/>&amp;destinationid=<xsl:value-of select="destSelector"/>&amp;help=SetPEFD</xsl:attribute>
				<xsl:attribute name="editable">false</xsl:attribute>
				<xsl:attribute name="align">left</xsl:attribute>
			</xsl:element>
			
			<Data align="left">
				<xsl:apply-templates select="/OMA/EMPPEFAltPlcyEntryListObj/altPlcyEntryListarray/altPlcyEntryList[policyEntryNumber = $varDestSelector]"/>
			</Data>
			
			<Data align="left">
				<xsl:attribute name="value"><xsl:value-of select="AlertingIPAddr"/></xsl:attribute>
			</Data>
		</Row>
	</xsl:template>
	
	<xsl:template match="EMPLANConfigObj">
					
				<Data name="CommunityString" type="editbox" editable="true">
					<xsl:attribute name="display"><xsl:value-of select="$strCommunityString"/>	</xsl:attribute>
					<xsl:attribute name="maxlength">18</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="CommunityString"/>	</xsl:attribute>
		     </Data>
	
	</xsl:template>

	<xsl:template match="altPlcyEntryList">
		<xsl:attribute name="value">
			<xsl:choose>
				<xsl:when test="entryEnable='0'">
					<xsl:value-of select="$strDisabled"/>
				</xsl:when>
				<xsl:when test="entryEnable='1'">
					<xsl:value-of select="$strEnabled"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$strUnknown"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
	</xsl:template>

</xsl:stylesheet>