<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/OMA">
		<DataArea>
			<PageTitle><xsl:attribute name="display"><xsl:value-of select="$strIntrusion"/></xsl:attribute>
				<xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
				<Data name="Refresh">
				<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.IntrusionWebPlugin&amp;poid=2</xsl:attribute>
				</Data>
			</CustomButton>
			<xsl:choose>
				<xsl:when test="IntrusionList/@count = '0'">
					<TableData>
						<Row>
							<Data>
								<xsl:attribute name="value"><xsl:value-of select="$strIntrusionInformationNot"/></xsl:attribute>
							</Data>
						</Row>
					</TableData>
				</xsl:when>
				<xsl:when test="SMStatus != '0' ">
					<TableData>
						<Row>
							<Data>
								<xsl:attribute name="value"><xsl:value-of select="$strIntrusionInformationNot1"/><xsl:value-of select="CmdHelp"/></xsl:attribute>
							</Data>
						</Row>
					</TableData>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="IntrusionList"/>
				</xsl:otherwise>
			</xsl:choose>		
		</DataArea>
	</xsl:template>
	<xsl:template match="IntrusionList">
		<TableData>
			<Header>
				<Data ignoreonweb="true" name="index" align="center">
					<xsl:attribute name="value"><xsl:value-of select="$strIndex"/></xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strIndex1"/></xsl:attribute>
				</Data> 
				<Data name="status" align="center">
					<xsl:attribute name="value"><xsl:value-of select="$strStatus"/></xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strStatus1"/></xsl:attribute>
				</Data> 
				<Data name="name">
					<xsl:attribute name="value"><xsl:value-of select="$strProbeName"/></xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strProbeName1"/></xsl:attribute>
				</Data> 
				<Data name="state">
					<xsl:attribute name="value"><xsl:value-of select="$strState"/></xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strState1"/></xsl:attribute>
				</Data> 
			</Header>
			<xsl:apply-templates select="Intrusion"/>
		</TableData>
	</xsl:template>
	<xsl:template match="Intrusion">
		<Row>
			<Data ignoreonweb="true" name="index" type="index" align="center">
				<xsl:attribute name="value"><xsl:value-of select="@index"/></xsl:attribute>
			</Data>
			<Data name="status" type="status" align="center">
				<xsl:attribute name="value"><xsl:value-of select="@status"/></xsl:attribute>
			</Data>
			<Data name="name">
				<xsl:attribute name="value">
					<xsl:value-of select="IntrusionLoc"/>
				</xsl:attribute>
			</Data>
			<Data name="State">
				<xsl:attribute name="value">
					<xsl:call-template name="status2txt">
						<xsl:with-param name="Status"><xsl:value-of select="IntrusionStatus"/></xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
			</Data>
		</Row>
	</xsl:template>
	
<xsl:template name="status2txt">
	<xsl:param name="Status"/>
	<xsl:choose>
		<xsl:when test="$Status=1"><xsl:value-of select="$strChassisIsOpen"/></xsl:when>
		<xsl:when test="$Status=2"><xsl:value-of select="$strChassisIsClosed"/></xsl:when>
		<xsl:when test="$Status=3"><xsl:value-of select="$strChassisIsPreviously"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
</xsl:stylesheet>
