<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="OMA" priority="1">
		<xsl:choose>
			<xsl:when test="SMStatus = 0">
				<DataArea>
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strFirmwareInformation"/></xsl:attribute>
					</PageTitle>
					<xsl:call-template name="FirmwareList"/>
				</DataArea>
			</xsl:when>
			<xsl:otherwise>
				<DataArea>
					<PageTitle>
						<xsl:attribute name="display">
							<xsl:call-template name="smstatus">
								<xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
					</PageTitle>
				</DataArea>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="FirmwareList" priority="2">
		<ListData type="custom">
<xsl:attribute name="display"><xsl:value-of select="$strVersionInformation"/></xsl:attribute>
		<Header>
		<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strVersionInformation"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strVersionInformation"/></xsl:attribute>
		</Data>
		</Header>		
			
			<xsl:for-each select="FirmwareList/Firmware">
				
			<Data>
                    	<xsl:attribute name="display">
                    		<xsl:call-template name="getFWType">
								<xsl:with-param name="type">
									<xsl:value-of select="FWType"/>
								</xsl:with-param>
							</xsl:call-template>
                    	</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="FWVersion" /></xsl:attribute>
                 </Data>  
				
			</xsl:for-each> 
</ListData>

		<CustomButton>
			<Data name="Refresh" href="./DataArea?plugin=com.dell.hip.webplugins.FWViewWebPlugin&amp;help=Firmware">
				<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
			</Data>
		</CustomButton>
	</xsl:template>
	<xsl:template match="*/OMAUserRights"/>
		<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><xsl:value-of select="$strErrorCommandUnsuccessful"/></xsl:when>
			<xsl:when test="$status = '0'"><xsl:value-of select="$strErrorCommandSuccessful"/></xsl:when>
			<xsl:when test="$status = '1'"><xsl:value-of select="$strErrorCommandNot"/></xsl:when>
			<xsl:when test="$status = '2'"><xsl:value-of select="$strErrorBadCommand"/></xsl:when>
			<xsl:when test="$status = '3'"><xsl:value-of select="$strErrorCommandTimeout"/></xsl:when>
			<xsl:when test="$status = '4'"><xsl:value-of select="$strErrorCommandCancelled"/></xsl:when>
			<xsl:when test="$status = '5'"><xsl:value-of select="$strErrorCommandAborted"/></xsl:when>
			<xsl:when test="$status = '6'"><xsl:value-of select="$strErrorCommandPending"/></xsl:when>
			<xsl:when test="$status = '7'"><xsl:value-of select="$strErrorNoSuch"/></xsl:when>
			<xsl:when test="$status = '8'"><xsl:value-of select="$strErrorDeviceBusy"/></xsl:when>
			<xsl:when test="$status = '9'"><xsl:value-of select="$strErrorBadDevice"/></xsl:when>
			<xsl:when test="$status = '10'"><xsl:value-of select="$strErrorSpuriousInterrupt"/></xsl:when>
			<xsl:when test="$status = '11'"><xsl:value-of select="$strErrorResourceLocked"/></xsl:when>
			<xsl:when test="$status = '12'"><xsl:value-of select="$strErrorInvalidIndex"/></xsl:when>
			<xsl:when test="$status = '13'"><xsl:value-of select="$strErrorSMBError"/></xsl:when>
			<xsl:when test="$status = '14'"><xsl:value-of select="$strErrorDataRequested"/></xsl:when>
			<xsl:when test="$status = '15'"><xsl:value-of select="$strErrorDataRequested1"/></xsl:when>
			<xsl:when test="$status = '16'"><xsl:value-of select="$strErrorDataRequested2"/></xsl:when>
			<xsl:when test="$status = '17'"><xsl:value-of select="$strErrorDeviceNot"/></xsl:when>
			<xsl:when test="$status = '18'"><xsl:value-of select="$strErrorDeviceDoes"/></xsl:when>
			<xsl:when test="$status = '19'"><xsl:value-of select="$strErrorDeviceOut"/></xsl:when>
			<xsl:when test="$status = '20'"><xsl:value-of select="$strErrorDeviceAlready"/></xsl:when>
			<xsl:when test="$status = '256'"><xsl:value-of select="$strErrorNoFirmware"/></xsl:when>
			<xsl:when test="$status = '257'"><xsl:value-of select="$strErrorFirmwareObject"/></xsl:when>
			<xsl:when test="$status = '258'"><xsl:value-of select="$strErrorFirmwareObject1"/></xsl:when>
			<xsl:when test="$status = '260'"><xsl:value-of select="$strErrorINIFile"/></xsl:when>
			<xsl:when test="$status = '261'"><xsl:value-of select="$strErrorINIMalformed"/></xsl:when>
			<xsl:when test="$status = '262'"><xsl:value-of select="$strErrorINISection"/></xsl:when>
			<xsl:when test="$status = '263'"><xsl:value-of select="$strErrorINIKey"/></xsl:when>
			<xsl:when test="$status = '264'"><xsl:value-of select="$strErrorINIValue"/></xsl:when>
			<xsl:when test="$status = '270'"><xsl:value-of select="$strErrorInsufficientAccess"/></xsl:when>
			<xsl:when test="$status = '271'"><xsl:value-of select="$strErrorInvalidParameter"/></xsl:when>
			<xsl:when test="$status = '272'"><xsl:value-of select="$strErrorOutOf"/></xsl:when>
			<xsl:when test="$status = '280'"><xsl:value-of select="$strErrorXMLFile"/></xsl:when>
			<xsl:when test="$status = '281'"><xsl:value-of select="$strErrorXMLMalformed"/></xsl:when>
			<xsl:when test="$status = '282'"><xsl:value-of select="$strErrorXMLNode"/></xsl:when>
			<xsl:when test="$status = '283'"><xsl:value-of select="$strErrorXMLValue"/></xsl:when>
			<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="getFWType">
		<xsl:param name="type"/>
		<xsl:choose>
			<xsl:when test="$type='2'"><xsl:value-of select="FWText"/></xsl:when>
			<xsl:when test="$type='3'"><xsl:value-of select="$strBIOSVersion"/></xsl:when>
			<xsl:when test="$type='4'"><xsl:value-of select="$strESMFirmwareVersion"/></xsl:when>
			<xsl:when test="$type='5'"><xsl:value-of select="$strPowerSupplyParalleling"/></xsl:when>
			<xsl:when test="$type='6'"><xsl:value-of select="$strBackplaneFirmwareVersion"/></xsl:when>
			<xsl:when test="$type='7'"><xsl:value-of select="$strKernelVersion"/></xsl:when>
			<xsl:when test="$type='8'"><xsl:value-of select="$strApplicationVersion"/></xsl:when>
			<xsl:when test="$type='9'"><xsl:value-of select="$strFrontPanelController"/></xsl:when>
			<xsl:when test="$type='10'"><xsl:value-of select="$strBaseboardManagementController"/></xsl:when>
			<xsl:when test="$type='11'"><xsl:value-of select="$strHotPlugPCI"/></xsl:when>
			<xsl:when test="$type='12'"><xsl:value-of select="$strSensorDataRecords"/></xsl:when>
			<xsl:when test="$type='13'"><xsl:value-of select="$strPeripheralBayBackplane"/></xsl:when>
			<xsl:when test="$type='14'"><xsl:value-of select="$strPowerEdge2450Secondary"/></xsl:when>
			<xsl:when test="$type='15'"><xsl:value-of select="$strSecondaryBackPlane"/></xsl:when>
			<xsl:when test="$type='16'"><xsl:value-of select="$strRemoteAccessController"/></xsl:when>			
   		     <xsl:when test="$type &gt;'16'"><xsl:value-of select="FWText"/></xsl:when>		            
				
			<xsl:otherwise><xsl:value-of select="$strUnknownFirmwareVersion"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
