<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:template match="OMA">
	<xsl:if test="(OMAUserRights = '7') or (OMAUserRights = '3')">
		<xsl:choose>
			<xsl:when test="(VoltageProbe/ProbeThresholds/LCThreshold != '-2147483648') and (VoltageProbe/ProbeThresholds/UCThreshold != '-2147483648') and (VoltageProbe/ProbeThresholds/LNCThreshold != '-2147483648') and (VoltageProbe/ProbeThresholds/UNCThreshold != '-2147483648') and (VoltageProbe/ProbeReading != '-2147483648')">
				<xsl:choose>
					<xsl:when test="SMStatus='0'"><xsl:apply-templates select="VoltageProbe"/></xsl:when>
					<xsl:otherwise><xsl:call-template name="failure"/></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise><xsl:call-template name="invalid"/></xsl:otherwise>
		</xsl:choose>
	</xsl:if>
</xsl:template>

<xsl:template name="failure">
	<DataArea exportdata="false">
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strVoltageProbes"/></xsl:attribute>
		</PageTitle>
		<TableData>
			<Row>
				<Data name="" ><xsl:attribute name="display"><xsl:value-of select="$str"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:call-template name="smstatus">
							<xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
						</xsl:call-template>
					</xsl:attribute>
				</Data>
			</Row>
		</TableData>
	</DataArea>
</xsl:template>

<xsl:template name="invalid">
	<DataArea exportdata="false">
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strVoltageProbes1"/></xsl:attribute>
		</PageTitle>
		<PromptText><xsl:value-of select="$strVoltageProbeThresholds"/></PromptText>
	</DataArea>
</xsl:template>

<xsl:template match="VoltageProbe">
	<DataArea  validate="true"  onLoad="true" exportdata="false"><xsl:attribute name="backpagedisplay"><xsl:value-of select="$strVoltageProbes2"/></xsl:attribute>
		<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.hip.webplugins.SetVoltageWebPlugin&amp;oid=<xsl:value-of select="@oid"/></xsl:attribute>
		<xsl:attribute name="backpagetarget">./DataArea?plugin=com.dell.hip.webplugins.ListVoltageWebPlugin&amp;poid=<xsl:value-of select="@poid"/>&amp;help=Voltages</xsl:attribute>
		<PageTitle>PageTitle</PageTitle>
		<Header>Header</Header>
		
	<PageTitle/>
		<CustomButton>
			<Data name="Refresh">
			<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.VoltageWebPlugin&amp;oid=<xsl:value-of select="@oid"/>&amp;poid=<xsl:value-of select="@poid"/>&amp;help=EditVoltageProbes</xsl:attribute>
			</Data>
		</CustomButton>
		<xsl:choose>
			<xsl:when test="(ProbeThresholds/LCThreshold != '-2147483648') and (ProbeThresholds/UCThreshold != '-2147483648') and (ProbeThresholds/LNCThreshold != '-2147483648') and (ProbeThresholds/UNCThreshold != '-2147483648') and (ProbeReading != '-2147483648')">
				<Guage digits="3">
			<SubHeader>
			<xsl:attribute name="display"><xsl:value-of select="ProbeLocation"/></xsl:attribute>
			<xsl:attribute name="status"><xsl:value-of select="@status"/></xsl:attribute>
		</SubHeader>
					<xsl:attribute name="units"><xsl:value-of select="$strVolt"/></xsl:attribute>
					<xsl:attribute name="showdecsep"><xsl:value-of select="$strDecimalFractionSeperatorPart2"/></xsl:attribute>
					<Reading>
						<xsl:call-template name="calVolt">
							<xsl:with-param name="volt"><xsl:value-of select="ProbeReading"/></xsl:with-param>
						</xsl:call-template>
					</Reading>
					<Probe>Volts</Probe>
					<MFThresh>
						<xsl:call-template name="calVolt">
							<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/LCThreshold"/></xsl:with-param>
						</xsl:call-template>
					</MFThresh>
					<MXFThresh>
						<xsl:call-template name="calVolt">
							<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/UCThreshold"/></xsl:with-param>
						</xsl:call-template>
					</MXFThresh>
					<MWThresh>
						<xsl:call-template name="calVolt">
							<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/LNCThreshold"/></xsl:with-param>
						</xsl:call-template>
					</MWThresh>
					<MXWThresh>
						<xsl:call-template name="calVolt">
							<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/UNCThreshold"/></xsl:with-param>
						</xsl:call-template>
					</MXWThresh>
					<ListData>
						<Data type="status-text"><xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="@status"/></xsl:attribute>
						</Data>
						<Data reading="true"><xsl:attribute name="display"><xsl:value-of select="$strReading"/></xsl:attribute>
							<xsl:attribute name="value">
								<xsl:call-template name="showcalVolt">
									<xsl:with-param name="volt"><xsl:value-of select="ProbeReading"/></xsl:with-param>
								</xsl:call-template><xsl:value-of select="$strVolt1"/>
							</xsl:attribute>
						</Data>
						<Data><xsl:attribute name="display"><xsl:value-of select="$strMinFailureThreshold"/></xsl:attribute>
							<xsl:attribute name="value">
								<xsl:call-template name="showcalVolt">
									<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/LCThreshold"/></xsl:with-param>
								</xsl:call-template><xsl:value-of select="$strVolt2"/>
							</xsl:attribute>
						</Data>
						<Data><xsl:attribute name="display"><xsl:value-of select="$strMaxFailureThreshold"/></xsl:attribute>
							<xsl:attribute name="value">
								<xsl:call-template name="showcalVolt">
									<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/UCThreshold"/></xsl:with-param>
								</xsl:call-template><xsl:value-of select="$strVolt3"/>
							</xsl:attribute>
						</Data>
						<xsl:choose>
							<xsl:when test="(Capabilities/ProbeUNCDefSetEnabled = 'true') or (Capabilities/ProbeLNCDefSetEnabled = 'true')">
							<Data type="radio"  state="1"><xsl:attribute name="display"><xsl:value-of select="$strThresholdSettings"/></xsl:attribute>
								<xsl:attribute name="name">threshsetting</xsl:attribute>
								<xsl:attribute name="returnvalue">default</xsl:attribute>
								<xsl:attribute name="handler">javascript:setToDef()</xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strSetToDefault"/></xsl:attribute>
							</Data>
							<Data type="radio">
								<xsl:attribute name="name">threshsetting</xsl:attribute>
								<xsl:attribute name="returnvalue">uservalues</xsl:attribute>
								<xsl:attribute name="handler">javascript:setToVal()</xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strSetToValues"/></xsl:attribute>
							</Data>
							</xsl:when>
							<xsl:otherwise>
							<Data type="radio"  state="1"><xsl:attribute name="display"><xsl:value-of select="$strThresholdSettings1"/></xsl:attribute>
								<xsl:attribute name="name">threshsetting</xsl:attribute>
								<xsl:attribute name="returnvalue">uservalues</xsl:attribute>
								<xsl:attribute name="handler">javascript:setToVal()</xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strSetToValues"/></xsl:attribute>
							</Data>
							</xsl:otherwise>
						</xsl:choose>
						<Data type="editbox"><xsl:attribute name="display"><xsl:value-of select="$strMinWarningThreshold"/></xsl:attribute>
							<xsl:attribute name="textboxname">LNCVal</xsl:attribute>
							<xsl:attribute name="textboxvalue">
								<xsl:call-template name="showcalVolt">
									<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/LNCThreshold"/></xsl:with-param>
								</xsl:call-template>
							</xsl:attribute>
							<xsl:attribute name="unit"><xsl:value-of select="$strVolt4"/></xsl:attribute>
						</Data>
						<Data type="editbox"><xsl:attribute name="display"><xsl:value-of select="$strMaxWarningThreshold"/></xsl:attribute>
							<xsl:attribute name="textboxname">UNCVal</xsl:attribute>
							<xsl:attribute name="textboxvalue">
								<xsl:call-template name="showcalVolt">
									<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/UNCThreshold"/></xsl:with-param>
								</xsl:call-template>
							</xsl:attribute>
							<xsl:attribute name="unit"><xsl:value-of select="$strVolt5"/></xsl:attribute>
						</Data>
					</ListData>
				</Guage>
			</xsl:when>
			<xsl:otherwise>
				<ListData>
					<Data name="plugin" type="hidden">
						<xsl:attribute name="returnvalue">com.dell.hip.webplugins.SetVoltageWebPlugin</xsl:attribute>
					</Data>
					<Data name="oid" type="hidden">
						<xsl:attribute name="returnvalue"><xsl:value-of select="@oid"/></xsl:attribute>
					</Data>
					<xsl:element name="Data">
						<xsl:attribute name="name">Status</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="@status"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strStatus1"/></xsl:attribute>
						<xsl:attribute name="type">status-text</xsl:attribute>
					</xsl:element>
					<xsl:element name="Data">
						<xsl:attribute name="value">
							<xsl:call-template name="showcalVolt">
								<xsl:with-param name="volt"><xsl:value-of select="ProbeReading"/></xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strReading1"/></xsl:attribute>
						<xsl:attribute name="type">ustring</xsl:attribute>
						<xsl:attribute name="unit"><xsl:value-of select="$strVolt6"/></xsl:attribute>
					</xsl:element>
					<xsl:element name="Data">
						<xsl:attribute name="value">
							<xsl:call-template name="showcalVolt">
								<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/LCThreshold"/></xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strMinimumFailureThreshhold"/></xsl:attribute>
						<xsl:attribute name="type">ustring</xsl:attribute>
						<xsl:attribute name="unit"> <xsl:value-of select="$strVolt7"/></xsl:attribute>
					</xsl:element>
					<xsl:element name="Data">
						<xsl:attribute name="value">
							<xsl:call-template name="showcalVolt">
								<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/UCThreshold"/></xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strMaximumFailureThreshold"/></xsl:attribute>
						<xsl:attribute name="type">ustring</xsl:attribute>
						<xsl:attribute name="unit"><xsl:value-of select="$strVolt8"/></xsl:attribute>
					</xsl:element>
					<Data type="radio"  state="1"><xsl:attribute name="display"><xsl:value-of select="$strThresholdSettings2"/></xsl:attribute>
						<xsl:attribute name="name">threshsetting</xsl:attribute>
						<xsl:attribute name="returnvalue">default</xsl:attribute>
						<xsl:attribute name="event">onClick</xsl:attribute>
						<xsl:attribute name="handler">javascript:setToDef()</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strSetToDefault"/></xsl:attribute>
					</Data>
					<Data type="radio">
						<xsl:attribute name="name">threshsetting</xsl:attribute>
						<xsl:attribute name="returnvalue">uservalues</xsl:attribute>
						<xsl:attribute name="event">onClick</xsl:attribute>
						<xsl:attribute name="handler">javascript:setToVal()</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strSetToValues"/></xsl:attribute>
					</Data>
					<Data type="editbox" size="6"><xsl:attribute name="display"><xsl:value-of select="$strMinWarningThreshold1"/></xsl:attribute>
						<xsl:attribute name="name">LNCVal</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:call-template name="showcalVolt">
								<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/LNCThreshold"/></xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
						<xsl:attribute name="unit"><xsl:value-of select="$strVolt9"/></xsl:attribute>
					</Data>
					<Data type="editbox" size="6"><xsl:attribute name="display"><xsl:value-of select="$strMaxWarningThreshold1"/></xsl:attribute>
						<xsl:attribute name="name">UNCVal</xsl:attribute>
						<xsl:attribute name="value">
							<xsl:call-template name="showcalVolt">
								<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/UNCThreshold"/></xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
						<xsl:attribute name="unit"><xsl:value-of select="$strVolt10"/></xsl:attribute>
					</Data>
				</ListData>
			</xsl:otherwise>
		</xsl:choose>

		<script language="javascript" src="/oma/js/Probe.js" />

		<script language="javascript">

			var setToDefault	= true;
			var setToValues	= false;
			var UC;
			var LC;
			var preUNC;
			var preLNC;
			var UCTxt;
			var LCTxt;
			var preUNCTxt;
			var preLNCTxt;
			var toggleunivDecsep = <xsl:value-of select="$strDecimalFractionSeperatorQuotesPart2"/>; //In German ,French and Spanish, change it to ",". In en, it should be ".".
			var togglelocalDecsep = <xsl:value-of select="$strDecimalSeperatorQuotesPart2"/>;//In German ,French and Spanish, change it to ".".In en, it should be ",".
			var univDecsep = "."; // don't translate.
			var unit =  <xsl:value-of select="$strVolt11"/>;
			var multiplier = 1000;
			var lengthval = 4;
			var msg1 = <xsl:value-of select="$strErrorNumberWith"/>;
			var msg2 = <xsl:value-of select="$strErrorTheValue1"/>;
			var msg3 = <xsl:value-of select="$strRange"/>;
			var msg4 = <xsl:value-of select="$strTo"/>;
			var msg5 = <xsl:value-of select="$strErrorTheValue2"/>;
			var msg6 = <xsl:value-of select="$strUnit"/>;
			var msg7 = <xsl:value-of select="$strErrorMinimumWarning"/>;
			
			<!-- These variable declarations were changed when we changed the structure of the error string to fix translation related issues -->
			//var msg2 = <xsl:value-of select="$strErrorTheValue"/>;
			//var msg3 = <xsl:value-of select="$strIsNotBetween"/>;
			//var msg4 = <xsl:value-of select="$strTo"/>;
			//var msg5 = <xsl:value-of select="$strForMinimumWarning"/>;
			//var msg6 = <xsl:value-of select="$strForMaximumWarning"/>;
			

			function initializationRoutine()
			{
				document.getElementById("UNCVal").value = '<xsl:call-template name="showcalVolt"><xsl:with-param name="volt"><xsl:value-of 	select="ProbeThresholds/UNCThreshold"/></xsl:with-param></xsl:call-template>';
				document.getElementById("LNCVal").value = '<xsl:call-template name="showcalVolt"><xsl:with-param name="volt"><xsl:value-of 	select="ProbeThresholds/LNCThreshold"/></xsl:with-param></xsl:call-template>';

				document.getElementById("UNCVal").disabled = true;
				document.getElementById("LNCVal").disabled = true;
				document.getElementById("threshsetting").checked = true;
				assignVal();
				<xsl:if test="(Capabilities/ProbeUNCDefSetEnabled != 'true') and (Capabilities/ProbeLNCDefSetEnabled != 'true')">
				 	setToVal();
				</xsl:if>
			}

			function assignVal(){
					var UCloc 			= parseFloat("<xsl:call-template name="calVolt"><xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/UCThreshold"/></xsl:with-param></xsl:call-template>");
					var LCloc 			= parseFloat("<xsl:call-template name="calVolt"><xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/LCThreshold"/></xsl:with-param></xsl:call-template>");
					var preUNCloc 		= parseFloat("<xsl:call-template name="calVolt"><xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/UNCThreshold"/></xsl:with-param></xsl:call-template>");
					var preLNCloc 		= parseFloat("<xsl:call-template name="calVolt"><xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/LNCThreshold"/></xsl:with-param></xsl:call-template>");

					var UCTxtloc		= '<xsl:call-template name="showcalVolt"><xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/UCThreshold"/></xsl:with-param></xsl:call-template>';
					var LCTxtloc		= '<xsl:call-template name="showcalVolt"><xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/LCThreshold"/></xsl:with-param></xsl:call-template>';

					var preUNCTxtloc		= '<xsl:call-template name="showcalVolt"><xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/UNCThreshold"/></xsl:with-param></xsl:call-template>';
					var preLNCTxtloc 		= '<xsl:call-template name="showcalVolt"><xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/LNCThreshold"/></xsl:with-param></xsl:call-template>';

					UC = UCloc;
					LC = LCloc;
					preUNC = preUNCloc;
					preLNC = preLNCloc;
					UCTxt = trim(UCTxtloc);
					LCTxt = trim(LCTxtloc);
					preUNCTxt = trim(preUNCTxtloc);
					preLNCTxt = trim(preLNCTxtloc);
			}
		</script>

	</DataArea>
</xsl:template>

<xsl:template name="showcalVolt">
	<xsl:param name="volt"/>
		<xsl:variable name="formatval"><xsl:value-of select="format-number($volt div 1000,'##0.000')"/></xsl:variable>
		<xsl:variable name="univdecsep">
			<xsl:choose>
				<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = '.'">.</xsl:when>
				<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = ','">,</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="localdecsep"><xsl:value-of select="$strDecimalFractionSeperatorPart2"/></xsl:variable>
		<xsl:value-of select="translate($formatval,$univdecsep,$localdecsep)"/>
</xsl:template>

<xsl:template name="calVolt">
	<xsl:param name="volt"/>
		<xsl:variable name="formatval"><xsl:value-of select="format-number($volt div 1000,'##0.000')"/></xsl:variable>
		<xsl:variable name="univdecsep">
			<xsl:choose>
				<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = '.'">.</xsl:when>
				<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = ','">,</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="localdecsep">.</xsl:variable>
		<xsl:value-of select="translate($formatval,$univdecsep,$localdecsep)"/>
</xsl:template>

<xsl:template name="smstatus">
	<xsl:param name="status"/>
	<xsl:choose>
		<xsl:when test="$status = '-1'"><xsl:value-of select="$strCommandUnsuccessful"/></xsl:when>
		<xsl:when test="$status = '1'"><xsl:value-of select="$strCommandNotImplemented"/></xsl:when>
		<xsl:when test="$status = '2'"><xsl:value-of select="$strBadCommand"/></xsl:when>
		<xsl:when test="$status = '3'"><xsl:value-of select="$strCommandTimeout"/></xsl:when>
		<xsl:when test="$status = '4'"><xsl:value-of select="$strCommandCancelled"/></xsl:when>
		<xsl:when test="$status = '5'"><xsl:value-of select="$strCommandAborted"/></xsl:when>
		<xsl:when test="$status = '6'"><xsl:value-of select="$strCommandPending"/></xsl:when>
		<xsl:when test="$status = '7'"><xsl:value-of select="$strNoSuchDevice"/></xsl:when>
		<xsl:when test="$status = '8'"><xsl:value-of select="$strDeviceBusy"/></xsl:when>
		<xsl:when test="$status = '9'"><xsl:value-of select="$strBadDevice"/></xsl:when>
		<xsl:when test="$status = '10'"><xsl:value-of select="$strSpuriousInterrupt"/></xsl:when>
		<xsl:when test="$status = '11'"><xsl:value-of select="$strResourceLocked"/></xsl:when>
		<xsl:when test="$status = '12'"><xsl:value-of select="$strInvalidIndex"/></xsl:when>
		<xsl:when test="$status = '13'"><xsl:value-of select="$strSMBError"/></xsl:when>
		<xsl:when test="$status = '14'"><xsl:value-of select="$strDataRequestedIs"/></xsl:when>
		<xsl:when test="$status = '15'"><xsl:value-of select="$strDataRequestedIs1"/></xsl:when>
		<xsl:when test="$status = '16'"><xsl:value-of select="$strDataRequestedIs2"/></xsl:when>
		<xsl:when test="$status = '17'"><xsl:value-of select="$strDeviceNotYet"/></xsl:when>
		<xsl:when test="$status = '18'"><xsl:value-of select="$strDeviceDoesNot"/></xsl:when>
		<xsl:when test="$status = '19'"><xsl:value-of select="$strDeviceOutOf"/></xsl:when>
		<xsl:when test="$status = '20'"><xsl:value-of select="$strDeviceAlreadyExists"/></xsl:when>
		<xsl:when test="$status = '256'"><xsl:value-of select="$strVoltageProbeNot"/></xsl:when>
		<xsl:when test="$status = '257'"><xsl:value-of select="$strObjectMalformedCorrupt"/></xsl:when>
		<xsl:when test="$status = '258'"><xsl:value-of select="$strObjectAlreadyExists"/></xsl:when>
		<xsl:when test="$status = '260'"><xsl:value-of select="$strINIFileNot"/></xsl:when>
		<xsl:when test="$status = '261'"><xsl:value-of select="$strINIMalformedCorrupt"/></xsl:when>
		<xsl:when test="$status = '262'"><xsl:value-of select="$strINISectionDoes"/></xsl:when>
		<xsl:when test="$status = '263'"><xsl:value-of select="$strINIKeyDoes"/></xsl:when>
		<xsl:when test="$status = '264'"><xsl:value-of select="$strINIValueMalformed"/></xsl:when>
		<xsl:when test="$status = '270'"><xsl:value-of select="$strInsufficientAccessRights"/></xsl:when>
		<xsl:when test="$status = '271'"><xsl:value-of select="$strInvalidParameterName"/></xsl:when>
		<xsl:when test="$status = '272'"><xsl:value-of select="$strOutOfMemory"/></xsl:when>
		<xsl:when test="$status = '280'"><xsl:value-of select="$strXMLFileNot"/></xsl:when>
		<xsl:when test="$status = '281'"><xsl:value-of select="$strXMLMalformedCorrupt"/></xsl:when>
		<xsl:when test="$status = '282'"><xsl:value-of select="$strXMLNodeDoes"/></xsl:when>
		<xsl:when test="$status = '283'"><xsl:value-of select="$strXMLValueMalformed"/></xsl:when>
		<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="*">
</xsl:template>
</xsl:stylesheet>
