<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:import href="Util.xsl"/>
  
<xsl:template match="OMA">
	<xsl:if test="(OMAUserRights = '7') or (OMAUserRights = '3')">
		<xsl:choose>
			<xsl:when test="SMStatus='0'"><xsl:apply-templates select="CurrentProbe"/></xsl:when>
			<xsl:otherwise><xsl:call-template name="failure"/></xsl:otherwise>
		</xsl:choose>
	</xsl:if>
</xsl:template>
<xsl:template name="failure">
	<DataArea exportdata="false">
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strPowerConsumptionProbe"/></xsl:attribute>
		</PageTitle>
		<TableData>
			<Row>
				<Data name="" ><xsl:attribute name="display"><xsl:value-of select="$gstr"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:call-template name="smstatus">
							<xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
						</xsl:call-template>
					</xsl:attribute>
				</Data>
			</Row>
		</TableData>
	</DataArea>
</xsl:template>

<xsl:template match="CurrentProbe">
	<DataArea  validate="true"  onLoad="true" exportdata="false">
    <xsl:attribute name="backpagedisplay"><xsl:value-of select="$strPowerConsumption"/></xsl:attribute>
		<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.hip.webplugins.SetPowerMonitoringProbeWebPlugin&amp;oid=<xsl:value-of select="@oid"/></xsl:attribute>
		<xsl:attribute name="backpagetarget">./DataArea?plugin=com.dell.hip.webplugins.ListPowerMonitoringWebPlugin&amp;poid=<xsl:value-of select="@poid"/>&amp;help=PowerMonitoring</xsl:attribute>
	<PageTitle/>
		<CustomButton>
			<Data name="Refresh">
			<xsl:attribute name="display"><xsl:value-of select="$gstrRefresh"/></xsl:attribute>
				<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.PowerMonitoringProbeWebPlugin&amp;oid=<xsl:value-of select="@oid"/>&amp;help=EditPowerMonProbes</xsl:attribute>
			</Data>
		</CustomButton>
		<xsl:choose>
			<xsl:when test="(ProbeThresholds/UCThreshold != '-2147483648') and (ProbeThresholds/UNCThreshold != '-2147483648') and (ProbeReading != '-2147483648')">
				<Guage digits="0">

		<SubHeader>
			<xsl:attribute name="display"><xsl:value-of select="ProbeLocation"/></xsl:attribute>
			<xsl:attribute name="status"><xsl:value-of select="@status"/></xsl:attribute>
		</SubHeader>

          <xsl:attribute name="hideminthresh">true</xsl:attribute>
          <xsl:attribute name="units"><xsl:value-of select="$gstrWattUnit"/></xsl:attribute>


          <Reading><xsl:value-of select="ProbeReading"/></Reading>
	    <Probe>PowerMon</Probe>
          <MFThresh>0</MFThresh>
          <MXFThresh><xsl:value-of select="ProbeThresholds/UCThreshold"/></MXFThresh>
          <MWThresh>0</MWThresh>
          <MXWThresh><xsl:value-of select="ProbeThresholds/UNCThreshold"/></MXWThresh>
          <TableData>
            <Row>
              <Data type="status-text">
                <xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="@status"/></xsl:attribute>
              </Data>
            </Row>
            <Row>
              <Data reading="true">
                <xsl:attribute name="display"><xsl:value-of select="$gstrReading"/></xsl:attribute>
                <xsl:attribute name="value">
                <xsl:call-template name="formatWattValue">
                  <xsl:with-param name="value"><xsl:value-of select="ProbeReading"/></xsl:with-param>
                  <xsl:with-param name="unit">all</xsl:with-param>
                </xsl:call-template>
                </xsl:attribute>
               </Data>
            </Row>
            <Row>
            <Data>
              <xsl:attribute name="display"><xsl:value-of select="$strFailureThreshold"/></xsl:attribute>
              <xsl:attribute name="value">
                <xsl:call-template name="formatWattValue">
                  <xsl:with-param name="value"><xsl:value-of select="ProbeThresholds/UCThreshold"/></xsl:with-param>
                  <xsl:with-param name="unit">all</xsl:with-param>
                </xsl:call-template>
              </xsl:attribute>
            </Data>
            </Row>
            <Row>
            <Data type="radio" state="1">
              <xsl:attribute name="display"><xsl:value-of select="$strThresholdSetting"/></xsl:attribute>
              <xsl:attribute name="name">threshsetting</xsl:attribute>
              <xsl:attribute name="returnvalue">default</xsl:attribute>
              <xsl:attribute name="handler">javascript:setToDef()</xsl:attribute>
              <xsl:attribute name="value"><xsl:value-of select="$strSetToDefault"/></xsl:attribute>
            </Data>
            </Row>
            <Row>
            <Data type="radio">
              <xsl:attribute name="name">threshsetting</xsl:attribute>
              <xsl:attribute name="returnvalue">uservalues</xsl:attribute>
              <xsl:attribute name="handler">javascript:setToVal()</xsl:attribute>
              <xsl:attribute name="value"><xsl:value-of select="$strSetToValue"/></xsl:attribute>
            </Data>
            </Row>
            <Row>
            <Data type="editbox" size="3" maxlength="4">
              <xsl:attribute name="display"><xsl:value-of select="$strWarningThreshold"/></xsl:attribute>
              <xsl:attribute name="textboxname">UNCVal</xsl:attribute>
              <xsl:attribute name="textboxvalue"><xsl:value-of select="ProbeThresholds/UNCThreshold"/></xsl:attribute>
              <xsl:attribute name="unit"><xsl:value-of select="$gstrWattUnit"/></xsl:attribute>
              <xsl:attribute name="event">onKeyUp</xsl:attribute>
              <xsl:attribute name="handler">javascript:validateThreshold(this);</xsl:attribute>
            </Data>
            <Data type="editbox" size="3" maxlength="4">
              <xsl:attribute name="display"/>
              <xsl:attribute name="textboxname">UNCVal1</xsl:attribute>
              <xsl:attribute name="textboxvalue">
                <xsl:call-template name="calculateFromWattToBTUhr">
                  <xsl:with-param name="value"><xsl:value-of select="ProbeThresholds/UNCThreshold"/></xsl:with-param>
                </xsl:call-template>
              </xsl:attribute>
              <xsl:attribute name="unit"><xsl:value-of select="$gstrBTUhrUnit"/></xsl:attribute>
              <xsl:attribute name="event">onKeyUp</xsl:attribute>
              <xsl:attribute name="handler">javascript:validateThreshold(this);</xsl:attribute>
            </Data>
            </Row>
          </TableData>
        </Guage>
			</xsl:when>
			<xsl:otherwise>
				<ListData>
					<xsl:element name="Data">
						<xsl:attribute name="type">status-text</xsl:attribute>
						<xsl:attribute name="name">Status</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="@status"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
					</xsl:element>
					<xsl:element name="Data">
						<xsl:attribute name="value"><xsl:value-of select="ProbeReading"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$gstrReading"/></xsl:attribute>
						<xsl:attribute name="type">ustring</xsl:attribute>
						<xsl:attribute name="unit"><xsl:value-of select="$gstrWattUnit"/></xsl:attribute>
					</xsl:element>
					<xsl:element name="Data">
						<xsl:attribute name="value"><xsl:value-of select="ProbeThresholds/UCThreshold"/></xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strFailureThreshold"/></xsl:attribute>
						<xsl:attribute name="type">ustring</xsl:attribute>
						<xsl:attribute name="unit"> <xsl:value-of select="$gstrWattUnit"/></xsl:attribute>
					</xsl:element>
					<Data type="radio"  state="1">
            <xsl:attribute name="display"><xsl:value-of select="$strThresholdSetting"/></xsl:attribute>
						<xsl:attribute name="name">threshsetting</xsl:attribute>
						<xsl:attribute name="returnvalue">default</xsl:attribute>
						<xsl:attribute name="event">onClick</xsl:attribute>
						<xsl:attribute name="handler">javascript:setToDef()</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strSetToDefault"/></xsl:attribute>
					</Data>
					<Data type="radio">
						<xsl:attribute name="name">threshsetting</xsl:attribute>
						<xsl:attribute name="returnvalue">uservalues</xsl:attribute>
						<xsl:attribute name="event">onClick</xsl:attribute>
						<xsl:attribute name="handler">javascript:setToVal()</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strSetToValue"/></xsl:attribute>
					</Data>
					<Data type="editbox" size="6">
            <xsl:attribute name="display"><xsl:value-of select="$strWarningThreshold"/></xsl:attribute>
						<xsl:attribute name="name">UNCVal</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="ProbeThresholds/UNCThreshold"/></xsl:attribute>
						<xsl:attribute name="unit"><xsl:value-of select="$gstrWattUnit"/></xsl:attribute>
					</Data>
				</ListData>
			</xsl:otherwise>
		</xsl:choose>

    <script language="javascript" src="/oma/js/UtilPM.js"/>
    <script language="javascript">
			isProbeUNCSetEnabled 		= <xsl:value-of select="Capabilities/ProbeUNCSetEnabled"/>;
			isProbeUNCDefSetEnabled = <xsl:value-of select="Capabilities/ProbeUNCDefSetEnabled"/>;

      setToDefault = true;
      setToValues	= false;
      
      // only if values modifiable, set it to true
      if(!isProbeUNCDefSetEnabled &amp;&amp; isProbeUNCSetEnabled )
      {
	      setToValues	= true;
      }

			function initializationRoutine()
			{      
				if( isProbeUNCSetEnabled )
				{
					document.getElementById("UNCVal").value = <xsl:value-of select="ProbeThresholds/UNCThreshold"/>;
					document.getElementById("UNCVal").disabled = false;
          document.getElementById("UNCVal1").disabled = false;
          
					if ( isProbeUNCDefSetEnabled &amp;&amp; setToDefault )
          {
            document.getElementById("UNCVal").disabled = true;
            document.getElementById("UNCVal1").disabled = true;
          }
        }

        if( isProbeUNCDefSetEnabled)
        {
          document.getElementById("threshsetting").checked = true;
        }
      }

      function setToVal()
      {
      setToValues = true;
      setToDefault = false;
      if( isProbeUNCSetEnabled )
      {
      document.getElementById("UNCVal").disabled = false;
      document.getElementById("UNCVal1").disabled = false;
      }
      }

      function setToDef()
      {
      setToDefault = true;
      setToValues = false;
      if( isProbeUNCSetEnabled )
      {
      document.getElementById("UNCVal").disabled = true;
      document.getElementById("UNCVal1").disabled = true;
      }
      }

      function validateThreshold(component)
      {        
        validateAndAllowNumbers(component);

        if( "UNCVal" == component.name )
        {
          var wattvalue = document.getElementById("UNCVal").value;
          document.getElementById("UNCVal1").value = convertFromWattToBTUhr(wattvalue);                  
        }

        if( "UNCVal1" == component.name )
        {
          var btuvalue = document.getElementById("UNCVal1").value;
          var wattvalue = document.getElementById("UNCVal").value = convertFromBTUhrToWatt(btuvalue);
        }
      }

      function validate()
      {
      <xsl:choose>
					<xsl:when test="ProbeThresholds/UCThreshold &gt; 0 ">
						var UC 	= parseInt("<xsl:value-of select="ProbeThresholds/UCThreshold"/>", 10);
						var preUNC = <xsl:value-of select="ProbeThresholds/UNCThreshold"/>;
					</xsl:when>
					<xsl:otherwise>
						var UC 	= 0;
						var preUNC = <xsl:value-of select="ProbeThresholds/UNCThreshold"/>;
					</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="ProbeThresholds/LCThreshold &gt; 0 ">
						var LC = parseInt("<xsl:value-of select="ProbeThresholds/LCThreshold"/>", 10);
						var preLNC = <xsl:value-of select="ProbeThresholds/LNCThreshold"/>;
					</xsl:when>
					<xsl:otherwise>
						var LC = 0;
						var preLNC = 1; //<xsl:value-of select="ProbeThresholds/LNCThreshold"/>;
					</xsl:otherwise>
				</xsl:choose>

				if(setToValues)
				{
					// user has changed the threshold settings.
					<xsl:if test="Capabilities/ProbeUNCSetEnabled = 'true' ">
						document.getElementById("UNCVal").disabled = false;
            document.getElementById("UNCVal1").disabled = false;
						var tempUNC = document.getElementById("UNCVal").value;

            // if input is not a number, throw error
						if(isNaN(tempUNC) == true)
						{
							alert(<xsl:value-of select="$strErrorNumberExpected"/>);
							document.getElementById("UNCVal").value = preUNC;
							return false;
						}

            // if input is not a whole number, throw error
						if(isNaN(parseInt(tempUNC, 10)) == true)
						{
							alert(<xsl:value-of select="$strErrorWholeNumber"/>);
							document.getElementById("UNCVal").value = preUNC;
							return false;
						}
						else
						{
							if(tempUNC.indexOf(".") != "-1")
							{
								alert(<xsl:value-of select="$strErrorWholeNumber"/>);
								document.getElementById("UNCVal").value = preUNC;
								return false;
							}
						}

						var UNC = parseInt(document.getElementById("UNCVal").value, 10);
					</xsl:if>

					if( isProbeUNCSetEnabled)
					{
						// only upper warning threshold is settable.
						if(UC &gt; 0)
						{
							if((UC &gt; UNC) &amp;&amp; (UNC &gt; LC))
							{
								return true;
							}
							else
							{
								UC--;
								alert(<xsl:value-of select="$strErrorTheValue"/>);
							}
						}
						else
						{
							// UC and LC are not available to do validation of UNC value.
							return true;
						}

						document.getElementById("UNCVal").value = preUNC;
            document.getElementById("UNCVal1").value = convertFromWattToBTUhr(preUNC);
					}
				}
				else
				{
					// do not validate the values if user has selected default threshold settings.
					return true;
				}

				<!--  returning false doesn't submit the form -->
				return false;
			}
		</script>
	</DataArea>
</xsl:template>
  
<xsl:template name="smstatus">
	<xsl:param name="status"/>
	<xsl:choose>
		<xsl:when test="$status = '-1'"><xsl:value-of select="$strCommandUnsuccessful"/></xsl:when>
		<xsl:when test="$status = '1'"><xsl:value-of select="$strCommandNotImplemented"/></xsl:when>
		<xsl:when test="$status = '2'"><xsl:value-of select="$strBadCommand"/></xsl:when>
		<xsl:when test="$status = '3'"><xsl:value-of select="$strCommandTimeout"/></xsl:when>
		<xsl:when test="$status = '4'"><xsl:value-of select="$strCommandCancelled"/></xsl:when>
		<xsl:when test="$status = '5'"><xsl:value-of select="$strCommandAborted"/></xsl:when>
		<xsl:when test="$status = '6'"><xsl:value-of select="$strCommandPending"/></xsl:when>
		<xsl:when test="$status = '7'"><xsl:value-of select="$strNoSuchDevice"/></xsl:when>
		<xsl:when test="$status = '8'"><xsl:value-of select="$strDeviceBusy"/></xsl:when>
		<xsl:when test="$status = '9'"><xsl:value-of select="$strBadDevice"/></xsl:when>
		<xsl:when test="$status = '10'"><xsl:value-of select="$strSpuriousInterrupt"/></xsl:when>
		<xsl:when test="$status = '11'"><xsl:value-of select="$strResourceLocked"/></xsl:when>
		<xsl:when test="$status = '12'"><xsl:value-of select="$strInvalidIndex"/></xsl:when>
		<xsl:when test="$status = '13'"><xsl:value-of select="$strSMBError"/></xsl:when>
		<xsl:when test="$status = '14'"><xsl:value-of select="$strDataRequestedIs"/></xsl:when>
		<xsl:when test="$status = '15'"><xsl:value-of select="$strDataRequestedIs1"/></xsl:when>
		<xsl:when test="$status = '16'"><xsl:value-of select="$strDataRequestedIs2"/></xsl:when>
		<xsl:when test="$status = '17'"><xsl:value-of select="$strDeviceNotYet"/></xsl:when>
		<xsl:when test="$status = '18'"><xsl:value-of select="$strDeviceDoesNot"/></xsl:when>
		<xsl:when test="$status = '19'"><xsl:value-of select="$strDeviceOutOf"/></xsl:when>
		<xsl:when test="$status = '20'"><xsl:value-of select="$strDeviceAlreadyExists"/></xsl:when>
		<xsl:when test="$status = '256'"><xsl:value-of select="$strPowerConsumptionProbeNot"/></xsl:when>
		<xsl:when test="$status = '257'"><xsl:value-of select="$strObjectMalformedCorrupt"/></xsl:when>
		<xsl:when test="$status = '258'"><xsl:value-of select="$strObjectAlreadyExists"/></xsl:when>
		<xsl:when test="$status = '260'"><xsl:value-of select="$strINIFileNot"/></xsl:when>
		<xsl:when test="$status = '261'"><xsl:value-of select="$strINIMalformedCorrupt"/></xsl:when>
		<xsl:when test="$status = '262'"><xsl:value-of select="$strINISectionDoes"/></xsl:when>
		<xsl:when test="$status = '263'"><xsl:value-of select="$strINIKeyDoes"/></xsl:when>
		<xsl:when test="$status = '264'"><xsl:value-of select="$strINIValueMalformed"/></xsl:when>
		<xsl:when test="$status = '270'"><xsl:value-of select="$strInsufficientAccessRights"/></xsl:when>
		<xsl:when test="$status = '271'"><xsl:value-of select="$strInvalidParameterName"/></xsl:when>
		<xsl:when test="$status = '272'"><xsl:value-of select="$strOutOfMemory"/></xsl:when>
		<xsl:when test="$status = '280'"><xsl:value-of select="$strXMLFileNot"/></xsl:when>
		<xsl:when test="$status = '281'"><xsl:value-of select="$strXMLMalformedCorrupt"/></xsl:when>
		<xsl:when test="$status = '282'"><xsl:value-of select="$strXMLNodeDoes"/></xsl:when>
		<xsl:when test="$status = '283'"><xsl:value-of select="$strXMLValueMalformed"/></xsl:when>
		<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="*">
</xsl:template>
</xsl:stylesheet>
