<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <!-- including globals for CLI. GUI automatically loads globals.xsl -->
  <xsl:include href="../en/globals.xsl"/>
  <xsl:strip-space elements="*"/>
  <xsl:output method="xml" indent="no"/>
  <xsl:template match="/OMA">
<xsl:choose>
	<xsl:when test="NICList/SMStatus != '0'">
		<DataArea printable="false">
			<TableData>
				<Header>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strError1"/></xsl:attribute>
					</Data>
				</Header>
				<Row>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strNICObjectNot"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strNICObjectNot1"/></xsl:attribute>
					</Data>
				</Row>
			</TableData>
		</DataArea>
	</xsl:when>
	<xsl:otherwise>
		<DataArea backpagetarget="./DataArea?plugin=com.dell.hip.webplugins.NICListWebPlugin&amp;help=NIC&amp;">
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strNetworkCards"/></xsl:attribute>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strNetworkCardInformation"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
				<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				<xsl:choose>
				<xsl:when test="NICList/DevNicObj/@ons">
					<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.NICCardWebPlugin&amp;help=NICInfo&amp;ons=<xsl:value-of select="NICList/DevNicObj/@ons"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.NICCardWebPlugin&amp;help=NICInfo&amp;ons=<xsl:value-of select="NICList/VirNicObj/@ons"/></xsl:attribute>
				</xsl:otherwise>
				</xsl:choose>
				</Data>
			</CustomButton>
			<xsl:apply-templates select="NICList/VirNicObj"/>
			<xsl:apply-templates select="NICList/DevNicObj"/>			
			<xsl:apply-templates select="IPAddressList/IPUnicastAddrListObj"/>
		      <xsl:apply-templates select="NICAdapterStats/NetAdptStatsObj"/>
			
		</DataArea>
	</xsl:otherwise>
</xsl:choose>
</xsl:template>
  
<xsl:template match="NICList/DevNicObj">
  <xsl:call-template name="PhyInterface"/>
  <xsl:call-template name="Interface"/>
</xsl:template>

<xsl:template match="NICList/VirNicObj">
  <xsl:call-template name="VirtualInterface"/>
  <xsl:call-template name="Interface"/>
</xsl:template>


<xsl:template name="PhyInterface">
	<TableData name="phyniclist">
	<xsl:attribute name="display"><xsl:value-of select="$strPhysicalInterface"/></xsl:attribute>
	<SubHeader>
			<xsl:attribute name="display"><xsl:value-of select="$strPhysicalInterface"/><xsl:value-of select="$strColon"/><xsl:value-of select="OSAdapterDescription"/></xsl:attribute>		
	</SubHeader>
	<Header>
		<Data width="40%">
			<xsl:attribute name="display"><xsl:value-of select="$gstrAttribute"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$gstrAttribute"/></xsl:attribute>
		</Data>
		<Data width ="60%">
			<xsl:attribute name="display"><xsl:value-of select="$gstrValue"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$gstrValue"/></xsl:attribute>
		</Data>
  </Header>
	<xsl:if test="OSAdapterDescription!='' ">
	  <Row>	
		  <Data>
			  <xsl:attribute name="value"><xsl:value-of select="$strDescription"/></xsl:attribute>
			</Data>
			<Data>
			  <xsl:attribute name="value"><xsl:value-of select="OSAdapterDescription"/></xsl:attribute>
			</Data>
    </Row>
  </xsl:if>
		<xsl:if test="OSAdapterVendor!='' ">
		  <Row>	
			  <Data>
				  <xsl:attribute name="value"><xsl:value-of select="$strVendor"/></xsl:attribute>
			  </Data>
			  <Data>
				  <xsl:attribute name="value"><xsl:value-of select="OSAdapterVendor"/></xsl:attribute>
			  </Data>
		  </Row>
		</xsl:if>
		<xsl:if test="SlotName!='' ">
	    <Row>	
		    <Data>
			    <xsl:attribute name="value"><xsl:value-of select="$strSlotName"/></xsl:attribute>
		    </Data>
		    <Data>
			    <xsl:attribute name="value"><xsl:value-of select="SlotName"/></xsl:attribute>
		    </Data>
	    </Row>
		</xsl:if>
    <xsl:if test="CurrentMACAddr!='' ">
		  <Row>	
			  <Data>
				  <xsl:attribute name="value"><xsl:value-of select="$strCurrentMACAddress"/></xsl:attribute>
			  </Data>
			  <Data>
				  <xsl:attribute name="value"><xsl:value-of select="CurrentMACAddr"/></xsl:attribute>
			  </Data>
		  </Row>
		</xsl:if>
		<xsl:if test="duplex!='' ">
	    <Row>	
		    <Data>
			    <xsl:attribute name="value"><xsl:value-of select="$strDuplex"/></xsl:attribute>
		    </Data>
		    <Data>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="duplex = 1"><xsl:value-of  select="$strHalf"/></xsl:when>
              <xsl:when test="duplex = 2"><xsl:value-of  select="$strFull"/></xsl:when>
              <xsl:otherwise><xsl:value-of  select="$strUnknown"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
	    </Row>
		</xsl:if>    
		<xsl:if test="baseAddress!='' ">
	    <Row>	
		    <Data>
			    <xsl:attribute name="value"><xsl:value-of select="$strBaseIOAddr"/></xsl:attribute>
		    </Data>
		    <Data>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="baseAddress!=0 ">
			<xsl:text>0x</xsl:text>
                <xsl:call-template name="DecimaltoHex">
                  <xsl:with-param name="decimalNumber"><xsl:value-of select="baseAddress"/></xsl:with-param>
                </xsl:call-template>
              </xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
	    </Row>
		</xsl:if>
		<xsl:if test="baseMemAddr!='' ">
	    <Row>	
		    <Data>
			    <xsl:attribute name="value"><xsl:value-of select="$strBaseMemAddr"/></xsl:attribute>
		    </Data>
		    <Data>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="baseMemAddr!=0 ">
			<xsl:text>0x</xsl:text>
			<xsl:call-template name="DecimaltoHex">
                  <xsl:with-param name="decimalNumber"><xsl:value-of select="baseMemAddr"/></xsl:with-param>
                </xsl:call-template>                
                </xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
	    </Row>
		</xsl:if>
		<xsl:if test="irq!='' ">
	    <Row>	
		    <Data>
			    <xsl:attribute name="value"><xsl:value-of select="$strIRQ"/></xsl:attribute>
		    </Data>
		    <Data>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="irq!=0 "><xsl:value-of select="irq"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
	    </Row>
		</xsl:if>    
		<xsl:if test="dma!='' ">
	    <Row>	
		    <Data>
			    <xsl:attribute name="value"><xsl:value-of select="$strDMA"/></xsl:attribute>
		    </Data>
		    <Data>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="dma!=0 "><xsl:value-of select="dma"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
	    </Row>
		</xsl:if>
		<xsl:if test="linkStatus!='' ">
	    <Row>	
		    <Data>
			    <xsl:attribute name="value"><xsl:value-of select="$strLinkStatus"/></xsl:attribute>
		    </Data>
		    <Data>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="linkStatus = 1"><xsl:value-of  select="$strUp"/></xsl:when>
              <xsl:when test="linkStatus = 2"><xsl:value-of  select="$strDown"/></xsl:when>
              <xsl:otherwise><xsl:value-of  select="$strUnknown"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
	    </Row>
		</xsl:if>    
		
		<Row>
			<Data>
				<xsl:attribute name="value"><xsl:value-of select="$strConnectionStatus"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:choose>
					<xsl:when test="nicStatus='1'">
						<xsl:attribute name="value"><xsl:value-of select="$strConnected"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='2'">
						<xsl:attribute name="value"><xsl:value-of select="$strDisconnected"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='3'">
						<xsl:attribute name="value"><xsl:value-of select="$strDriverNotInstalled"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='4'">
						<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='10'">
						<xsl:attribute name="value"><xsl:value-of select="$strInitializing"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='11'">
						<xsl:attribute name="value"><xsl:value-of select="$strResetting"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='12'">
						<xsl:attribute name="value"><xsl:value-of select="$strClosing"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='13'">
						<xsl:attribute name="value"><xsl:value-of select="$strAdapterNotReady"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><xsl:value-of select="$strNoValue6"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
		</Row>		
	
	<xsl:choose>
		<xsl:when test="nicCapabilities/@value !='0'">
			<Row>
				<Data>
				    <xsl:attribute name="value"><xsl:value-of select="$strTOECapable"/></xsl:attribute>
				</Data>
				<Data>	
				    <xsl:choose>
					    <xsl:when test="nicCapabilities/TOE='true'">
						    <xsl:attribute name="value"><xsl:value-of select="$gstrYes"/></xsl:attribute>
					    </xsl:when>
					    <xsl:otherwise>
						    <xsl:attribute name="value"><xsl:value-of select="$gstrNo"/></xsl:attribute>
					    </xsl:otherwise>
				    </xsl:choose>
			    </Data>
	    	</Row>
			<Row>
				<Data>
				    <xsl:attribute name="value"><xsl:value-of select="$strFCOECapable"/></xsl:attribute>
				</Data>
				<Data>
				    <xsl:choose>
					    <xsl:when test="nicCapabilities/FCoEOffload='true'">
						    <xsl:attribute name="value"><xsl:value-of select="$gstrYes"/></xsl:attribute>
					    </xsl:when>
					    <xsl:otherwise>
						    <xsl:attribute name="value"><xsl:value-of select="$gstrNo"/></xsl:attribute>
					    </xsl:otherwise>
				    </xsl:choose>
			    </Data>
			</Row>
				
			<Row>
				<Data>
				    <xsl:attribute name="value"><xsl:value-of select="$strISOECapable"/></xsl:attribute>
				</Data> 
				<Data>
				    <xsl:choose>
					    <xsl:when test="nicCapabilities/iSCSIOffload='true'">
						    <xsl:attribute name="value"><xsl:value-of select="$gstrYes"/></xsl:attribute>
					    </xsl:when>
					    <xsl:otherwise>
						    <xsl:attribute name="value"><xsl:value-of select="$gstrNo"/></xsl:attribute>
					    </xsl:otherwise>
				    </xsl:choose>
			    </Data>
			</Row>
		
		</xsl:when>
		
	<xsl:otherwise>
		<xsl:if test="nicTOECapability!='0'">
		  <Row>
			  <Data>
				  <xsl:attribute name="value"><xsl:value-of select="$strTOECapable"/></xsl:attribute>
			  </Data>
			  <Data>
				    <xsl:choose>
					    <xsl:when test="nicTOECapability='1'">
						    <xsl:attribute name="value"><xsl:value-of select="$strTOECapability0"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="nicTOECapability='2'">
						    <xsl:attribute name="value"><xsl:value-of select="$gstrYes"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="nicTOECapability='4'">
						    <xsl:attribute name="value"><xsl:value-of select="$gstrNo"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="nicTOECapability='8'">
						    <xsl:attribute name="value"><xsl:value-of select="$strTOECapability3"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="nicTOECapability='16'">
						    <xsl:attribute name="value"><xsl:value-of select="$strTOECapability4"/></xsl:attribute>
					    </xsl:when>
					    <xsl:otherwise>
						    <xsl:attribute name="value"><xsl:value-of select="$strNoValue"/></xsl:attribute>
					    </xsl:otherwise>
				    </xsl:choose>
			    </Data>
		   </Row>
		    <Row>
			    <Data>
				    <xsl:attribute name="value"><xsl:value-of select="$strTOEEnabled"/></xsl:attribute>
                </Data>
               <Data>
				    <xsl:choose>
					    <xsl:when test="isTOEEnable='true' ">
						    <xsl:attribute name="value"><xsl:value-of select="$gstrYes"/></xsl:attribute>
					    </xsl:when>
					    <xsl:otherwise>
						    <xsl:attribute name="value"><xsl:value-of select="$gstrNo"/></xsl:attribute>
					    </xsl:otherwise>
				    </xsl:choose>
			    </Data>
		    </Row>
		</xsl:if>
		
	</xsl:otherwise>
</xsl:choose>
		
		
	<xsl:if test="showNPAREP='true'">	
		<Row>
			<Data>
				<xsl:attribute name="value"><xsl:value-of select="$strNPAREPEnabled"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:choose>
					<xsl:when test="isNPAREPEnable='true' ">
						<xsl:attribute name="value"><xsl:value-of select="$gstrYes"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><xsl:value-of select="$gstrNo"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
		</Row>	
	</xsl:if>	
		<xsl:if test="DriverName!='' ">
			<Row>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strDriverName"/></xsl:attribute>
				</Data>
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="DriverName"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>    
		<xsl:if test="ImagePath!='' ">
			<Row>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strDriverImagePath"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="ImagePath"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="DriverVersion!='' ">
			<Row>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strDriverVersion"/></xsl:attribute>
				</Data>
				<Data>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="DriverVersion!='0'"><xsl:value-of select="DriverVersion"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="FirmwareVersion!='' ">
			<Row>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strFWVersion"/></xsl:attribute>
				</Data>
				<Data>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="FirmwareVersion!='0'"><xsl:value-of select="FirmwareVersion"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
				</Data>
			</Row>
		</xsl:if>   
		<xsl:if test="TeamName !=''">
			<Row>	
				<Data>
			          <xsl:attribute name="value"><xsl:value-of select="$strTeamName"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="TeamName"/></xsl:attribute>
				</Data>
			</Row> 
		</xsl:if>
	 	</TableData>	 	
</xsl:template>  


<xsl:template name="VirtualInterface">
	<TableData name="virniclist">
	<xsl:attribute name="display"><xsl:value-of select="$strTeamInterface"/></xsl:attribute>
	<SubHeader>
			<xsl:attribute name="display"><xsl:value-of select="$strTeamInterface"/><xsl:value-of select="$strColon"/><xsl:value-of select="OSAdapterDescription"/></xsl:attribute>		
	</SubHeader>
	<Header>
		<Data width="40%">
			<xsl:attribute name="display"><xsl:value-of select="$gstrAttribute"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$gstrAttribute"/></xsl:attribute>
		</Data>
		<Data width ="60%">
			<xsl:attribute name="display"><xsl:value-of select="$gstrValue"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$gstrValue"/></xsl:attribute>
		</Data>
  </Header>
	<xsl:if test="OSAdapterDescription!='' ">
	  <Row>	
		  <Data>
			  <xsl:attribute name="value"><xsl:value-of select="$strDescription"/></xsl:attribute>
			</Data>
			<Data>
			  <xsl:attribute name="value"><xsl:value-of select="OSAdapterDescription"/></xsl:attribute>
			</Data>
    </Row>
  </xsl:if>
		<xsl:if test="OSAdapterVendor!='' ">
		  <Row>	
			  <Data>
				  <xsl:attribute name="value"><xsl:value-of select="$strVendor"/></xsl:attribute>
			  </Data>
			  <Data>
				  <xsl:attribute name="value"><xsl:value-of select="OSAdapterVendor"/></xsl:attribute>
			  </Data>
		  </Row>
		</xsl:if>
		<xsl:if test="SlotName!='' ">
	    <Row>	
		    <Data>
			    <xsl:attribute name="value"><xsl:value-of select="$strSlotName"/></xsl:attribute>
		    </Data>
		    <Data>
			    <xsl:attribute name="value"><xsl:value-of select="SlotName"/></xsl:attribute>
		    </Data>
	    </Row>
		</xsl:if>
    <xsl:if test="CurrentMACAddr!='' ">
		  <Row>	
			  <Data>
				  <xsl:attribute name="value"><xsl:value-of select="$strCurrentMACAddress"/></xsl:attribute>
			  </Data>
			  <Data>
				  <xsl:attribute name="value"><xsl:value-of select="CurrentMACAddr"/></xsl:attribute>
			  </Data>
		  </Row>
		</xsl:if>
		<xsl:if test="duplex!='' ">
	    <Row>	
		    <Data>
			    <xsl:attribute name="value"><xsl:value-of select="$strDuplex"/></xsl:attribute>
		    </Data>
		    <Data>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="duplex = 1"><xsl:value-of  select="$strHalf"/></xsl:when>
              <xsl:when test="duplex = 2"><xsl:value-of  select="$strFull"/></xsl:when>
              <xsl:otherwise><xsl:value-of  select="$strUnknown"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
	    </Row>
		</xsl:if>    
		<xsl:if test="baseAddress!='' ">
	    <Row>	
		    <Data>
			    <xsl:attribute name="value"><xsl:value-of select="$strBaseIOAddr"/></xsl:attribute>
		    </Data>
		    <Data>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="baseAddress!=0 ">
			<xsl:text>0x</xsl:text>
                <xsl:call-template name="DecimaltoHex">
                  <xsl:with-param name="decimalNumber"><xsl:value-of select="baseAddress"/></xsl:with-param>
                </xsl:call-template>
              </xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
	    </Row>
		</xsl:if>
		<xsl:if test="baseMemAddr!='' ">
	    <Row>	
		    <Data>
			    <xsl:attribute name="value"><xsl:value-of select="$strBaseMemAddr"/></xsl:attribute>
		    </Data>
		    <Data>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="baseMemAddr!=0 ">
			<xsl:text>0x</xsl:text>
			<xsl:call-template name="DecimaltoHex">
                  <xsl:with-param name="decimalNumber"><xsl:value-of select="baseMemAddr"/></xsl:with-param>
                </xsl:call-template>                
                </xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
	    </Row>
		</xsl:if>
		<xsl:if test="irq!='' ">
	    <Row>	
		    <Data>
			    <xsl:attribute name="value"><xsl:value-of select="$strIRQ"/></xsl:attribute>
		    </Data>
		    <Data>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="irq!=0 "><xsl:value-of select="irq"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
	    </Row>
		</xsl:if>    
		<xsl:if test="dma!='' ">
	    <Row>	
		    <Data>
			    <xsl:attribute name="value"><xsl:value-of select="$strDMA"/></xsl:attribute>
		    </Data>
		    <Data>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="dma!=0 "><xsl:value-of select="dma"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
	    </Row>
		</xsl:if>
		<xsl:if test="linkStatus!='' ">
	    <Row>	
		    <Data>
			    <xsl:attribute name="value"><xsl:value-of select="$strLinkStatus"/></xsl:attribute>
		    </Data>
		    <Data>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="linkStatus = 1"><xsl:value-of  select="$strUp"/></xsl:when>
              <xsl:when test="linkStatus = 2"><xsl:value-of  select="$strDown"/></xsl:when>
              <xsl:otherwise><xsl:value-of  select="$strUnknown"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
		    </Data>
	    </Row>
		</xsl:if>    
		
		<Row>
			<Data>
				<xsl:attribute name="value"><xsl:value-of select="$strConnectionStatus"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:choose>
					<xsl:when test="nicStatus='1'">
						<xsl:attribute name="value"><xsl:value-of select="$strConnected"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='2'">
						<xsl:attribute name="value"><xsl:value-of select="$strDisconnected"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='3'">
						<xsl:attribute name="value"><xsl:value-of select="$strDriverNotInstalled"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='4'">
						<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='10'">
						<xsl:attribute name="value"><xsl:value-of select="$strInitializing"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='11'">
						<xsl:attribute name="value"><xsl:value-of select="$strResetting"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='12'">
						<xsl:attribute name="value"><xsl:value-of select="$strClosing"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="nicStatus='13'">
						<xsl:attribute name="value"><xsl:value-of select="$strAdapterNotReady"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><xsl:value-of select="$strNoValue6"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
		</Row>

		<xsl:if test="nicTOECapability!='0'">
		  <Row>
			  <Data>
				  <xsl:attribute name="value"><xsl:value-of select="$strTOECapable"/></xsl:attribute>
			  </Data>
			  <Data>
				    <xsl:choose>
					    <xsl:when test="nicTOECapability='1'">
						    <xsl:attribute name="value"><xsl:value-of select="$strTOECapability0"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="nicTOECapability='2'">
						    <xsl:attribute name="value"><xsl:value-of select="$strTOECapability1"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="nicTOECapability='4'">
						    <xsl:attribute name="value"><xsl:value-of select="$strTOECapability2"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="nicTOECapability='8'">
						    <xsl:attribute name="value"><xsl:value-of select="$strTOECapability3"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="nicTOECapability='16'">
						    <xsl:attribute name="value"><xsl:value-of select="$strTOECapability4"/></xsl:attribute>
					    </xsl:when>
					    <xsl:otherwise>
						    <xsl:attribute name="value"><xsl:value-of select="$strNoValue"/></xsl:attribute>
					    </xsl:otherwise>
				    </xsl:choose>
			    </Data>
		    </Row>
		    <Row>
			    <Data>
				    <xsl:attribute name="value"><xsl:value-of select="$strTOEEnabled"/></xsl:attribute>
          </Data>
          <Data>
				    <xsl:choose>
					    <xsl:when test="isTOEEnable='true' ">
						    <xsl:attribute name="value"><xsl:value-of select="$gstrYes"/></xsl:attribute>
					    </xsl:when>
					    <xsl:otherwise>
						    <xsl:attribute name="value"><xsl:value-of select="$gstrNo"/></xsl:attribute>
					    </xsl:otherwise>
				    </xsl:choose>
			    </Data>
		    </Row>
		</xsl:if>
		<xsl:if test="DriverName!='' ">
			<Row>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strDriverName"/></xsl:attribute>
				</Data>
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="DriverName"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>    
		<xsl:if test="ImagePath!='' ">
			<Row>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strDriverImagePath"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="ImagePath"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="DriverVersion!='' ">
			<Row>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strDriverVersion"/></xsl:attribute>
				</Data>
				<Data>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="DriverVersion!='0'"><xsl:value-of select="DriverVersion"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="FirmwareVersion!='' ">
			<Row>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strFWVersion"/></xsl:attribute>
				</Data>
				<Data>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="FirmwareVersion!='0'"><xsl:value-of select="FirmwareVersion"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
				</Data>
			</Row>
		</xsl:if> 
		<xsl:if test="TeamName !=''">
                    <Row>	
				<Data>
			          <xsl:attribute name="value"><xsl:value-of select="$strTeamName"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="TeamName"/></xsl:attribute>
				</Data>
			</Row>   
			</xsl:if>
		<xsl:if test="teamType!='0'">
		  <Row>
			  <Data>
				  <xsl:attribute name="value"><xsl:value-of select="$strTeamType"/></xsl:attribute>
			  </Data>
			  <Data>
				    <xsl:choose>
					    <xsl:when test="teamType='1'">
						    <xsl:attribute name="value"><xsl:value-of select="$strUnknown"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="teamType='10'">
						    <xsl:attribute name="value"><xsl:value-of select="$strSmartLoadBalancingandFailover"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="teamType='11'">
						    <xsl:attribute name="value"><xsl:value-of select="$strFECGECGenericTrunking"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="teamType='12'">
						    <xsl:attribute name="value"><xsl:value-of select="$str8023adLinkAggregationandLACP"/></xsl:attribute>
					    </xsl:when>
					    <xsl:when test="teamType='13'">
						    <xsl:attribute name="value"><xsl:value-of select="$strSmartLoadBalancing"/></xsl:attribute>
					    </xsl:when>
					   <xsl:when test="teamType='20'">
						    <xsl:attribute name="value"><xsl:value-of select="$strAdapterFaultTolerance"/></xsl:attribute>
					    </xsl:when>
 					    <xsl:when test="teamType='21' or teamType='36' ">
						    <xsl:attribute name="value"><xsl:value-of select="$strAdaptiveLoadBalancing"/></xsl:attribute>
					    </xsl:when>
 					   <xsl:when test="teamType='22'">
						    <xsl:attribute name="value"><xsl:value-of select="$strStaticLinkAggregation"/></xsl:attribute>
					    </xsl:when>
 					   <xsl:when test="teamType='23'">
						    <xsl:attribute name="value"><xsl:value-of select="$strDynamicLinkAggregation"/></xsl:attribute>
					    </xsl:when>
 					   <xsl:when test="teamType='24'">
						    <xsl:attribute name="value"><xsl:value-of select="$strSwitchFaultTolerance"/></xsl:attribute>
					    </xsl:when> 					 
					  <xsl:when test="teamType='30'">
						   <xsl:attribute name="value"><xsl:value-of select="$strLoadbalancing"/></xsl:attribute>
					    </xsl:when>
					  <xsl:when test="teamType='31'">
						   <xsl:attribute name="value"><xsl:value-of select="$strFaulttolerance"/></xsl:attribute>
					    </xsl:when>
					  <xsl:when test="teamType='32'">
						   <xsl:attribute name="value"><xsl:value-of select="$strLoadbalancingxor"/></xsl:attribute>
					    </xsl:when>
					 <xsl:when test="teamType='33'">
						   <xsl:attribute name="value"><xsl:value-of select="$strFaultTolerancebroadcast"/></xsl:attribute>
					    </xsl:when>
					 <xsl:when test="teamType='34'">
						   <xsl:attribute name="value"><xsl:value-of select="$strIEEE8023adDynamiclinkaggregation"/></xsl:attribute>
					    </xsl:when>
					 <xsl:when test="teamType='35'">
						   <xsl:attribute name="value"><xsl:value-of select="$strTransmitloadbalancing"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='40'">
						   <xsl:attribute name="value"><xsl:value-of select="$strFailover"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='41'">
						   <xsl:attribute name="value"><xsl:value-of select="$strFailback"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='42'">
						   <xsl:attribute name="value"><xsl:value-of select="$str802.3ad"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='50'">
						   <xsl:attribute name="value"><xsl:value-of select="$strFailsafe"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='51'">
						   <xsl:attribute name="value"><xsl:value-of select="$str802.3adStatic"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='52'">
						   <xsl:attribute name="value"><xsl:value-of select="$str802.3adDynamic"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='53'">
						   <xsl:attribute name="value"><xsl:value-of select="$strSwitchIndependentLoadBalancing"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='60'">
						   <xsl:attribute name="value"><xsl:value-of select="$strStaticTeamingPrimary"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='61'">
						   <xsl:attribute name="value"><xsl:value-of select="$strSwitchIndependentPrimary"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='62'">
						   <xsl:attribute name="value"><xsl:value-of select="$strLACPPrimary"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='63'">
						   <xsl:attribute name="value"><xsl:value-of select="$strStaticTeamingPrimaryHyperv"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='64'">
						   <xsl:attribute name="value"><xsl:value-of select="$strSwitchIndependentPrimaryHyperv"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='65'">
						   <xsl:attribute name="value"><xsl:value-of select="$strLACPPrimaryHyperv"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='66'">
						   <xsl:attribute name="value"><xsl:value-of select="$strStaticTeamingSecondary"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='67'">
						   <xsl:attribute name="value"><xsl:value-of select="$strSwitchIndependentSecondary"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='68'">
						   <xsl:attribute name="value"><xsl:value-of select="$strLACPSecondary"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='69'">
						   <xsl:attribute name="value"><xsl:value-of select="$strStaticTeamingSecondaryHyperv"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='70'">
						   <xsl:attribute name="value"><xsl:value-of select="$strSwitchIndependentSecondaryHyperv"/></xsl:attribute>
					    </xsl:when>	
					 <xsl:when test="teamType='71'">
						   <xsl:attribute name="value"><xsl:value-of select="$strLACPSecondaryHyperv"/></xsl:attribute>
					    </xsl:when>							
					 <xsl:when test="teamType='72'">
						<xsl:attribute name="value"><xsl:value-of select="$strStaticTeamingPrimaryDynamic"/></xsl:attribute>
					 </xsl:when>							
					 <xsl:when test="teamType='73'">
					    	<xsl:attribute name="value"><xsl:value-of select="$strLACPPrimaryDynamic"/></xsl:attribute>
					 </xsl:when>							
					 <xsl:when test="teamType='74'">
					    	<xsl:attribute name="value"><xsl:value-of select="$strSwitchIndependentPrimaryDynamic"/></xsl:attribute>
					 </xsl:when>							
					 <xsl:when test="teamType='75'">
					    	<xsl:attribute name="value"><xsl:value-of select="$strStaticTeamingSecondaryDynamic"/></xsl:attribute>
					 </xsl:when>							
					 <xsl:when test="teamType='76'">
					    	<xsl:attribute name="value"><xsl:value-of select="$strLACPSecondaryDynamic"/></xsl:attribute>
					 </xsl:when>							
					 <xsl:when test="teamType='77'">
					    	<xsl:attribute name="value"><xsl:value-of select="$strSwitchIndependentSecondaryDynamic"/></xsl:attribute>
					 </xsl:when>							
					    <xsl:otherwise>
						    <xsl:attribute name="value"><xsl:value-of select="$strNoValue"/></xsl:attribute>
					    </xsl:otherwise>
				    </xsl:choose>
			    </Data>
		    </Row>

</xsl:if>
<xsl:if test="/OMA/TeamMemberList/TeamMemberListObj">
<Row>
	<Data>
	  <xsl:attribute name="value"><xsl:value-of select="$strInterfaceMembers"/></xsl:attribute>
	</Data>
	<xsl:apply-templates select="/OMA/TeamMemberList"/>
	
</Row>
</xsl:if>

	 	</TableData>	 	
</xsl:template>  

<xsl:template name="Interface">
	<TableData name="interfacelist">
	  <xsl:attribute name="display"><xsl:value-of select="$strInterface"/></xsl:attribute>
	  <SubHeader>
			<xsl:attribute name="display"><xsl:value-of select="$strInterface"/><xsl:value-of select="$strColon"/><xsl:value-of select="IfDescription"/></xsl:attribute>		
	  </SubHeader>
	  <Header>
		  <Data width="40%">
					<xsl:attribute name="display"><xsl:value-of select="$gstrAttribute"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$gstrAttribute"/></xsl:attribute>
				</Data>
				<Data width ="60%">
					<xsl:attribute name="display"><xsl:value-of select="$gstrValue"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$gstrValue"/></xsl:attribute>
				</Data>
     </Header>
		<xsl:if test="IfDescription!='' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strDescription"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="IfDescription"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
			

		<xsl:if test="ifType!='' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strType"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value">
            <xsl:call-template name="IdentifyAdapterType">
              <xsl:with-param name="type"><xsl:value-of select="ifType"/></xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
				</Data>
			</Row>
		</xsl:if>    
		<xsl:if test="ifOperStatus!='' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strOperStatus"/></xsl:attribute>
				</Data>
				<Data>
          <xsl:attribute name="value">
            <xsl:call-template name="OperationalStatus">
              <xsl:with-param name="status"><xsl:value-of select="ifOperStatus"/></xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
				</Data>
			</Row>
		</xsl:if>    
		<xsl:if test="ifAdminStatus!='' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strAdminStatus"/></xsl:attribute>
				</Data>
				<Data>
          <xsl:attribute name="value">
            <xsl:call-template name="AdminStatus">
              <xsl:with-param name="status"><xsl:value-of select="ifAdminStatus"/></xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="mtu!='' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strMTU"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="mtu!=0 "><xsl:value-of select="mtu"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="$gstrNotAvailable"/></xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="speed!='' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strSpeed"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value">
            <xsl:call-template name="formatSpeedValue">
              <xsl:with-param name="value"><xsl:value-of select="speed"/></xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
				</Data>
			</Row>
		</xsl:if>    
		<xsl:if test="DHCPServer!='' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strDHCPServer"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="DHCPServer"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="DHCPv6Server!='' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strDHCPServer"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="DHCPv6Server"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>    
		<xsl:if test="DefaultGateway!='' ">
  		<Row>	
	  		<Data>
		  		<xsl:attribute name="value"><xsl:value-of select="$strDefaultGateway"/></xsl:attribute>
			  </Data>
			  <Data>
				  <xsl:attribute name="value"><xsl:value-of select="DefaultGateway"/></xsl:attribute>
			  </Data>
		  </Row>
		</xsl:if>
		<xsl:if test="DefaultIPv6Gateway!='' ">
  		<Row>	
	  		<Data>
		  		<xsl:attribute name="value"><xsl:value-of select="$strDefaultGateway"/></xsl:attribute>
			  </Data>
			  <Data>
				  <xsl:attribute name="value"><xsl:value-of select="DefaultIPv6Gateway"/></xsl:attribute>
			  </Data>
		  </Row>
		</xsl:if>    
  </TableData>
</xsl:template>

<xsl:template match="TeamMemberList">			

<xsl:if test="/OMA/TeamMemberList/TeamMemberListObj/numTeamMembers > '0' ">
 	  <Data>
		<ValueList>
		 <xsl:for-each select="TeamMemberListObj/teamMemberListarray/teamMemberList">					
  			<value><xsl:value-of select="IfDescription"/></value>			  						
	      </xsl:for-each>		
</ValueList>

</Data>
</xsl:if>
</xsl:template>




<xsl:template match="NICAdapterStats/NetAdptStatsObj">
  <xsl:variable name="STATS_NA" select="18446744073709551615"/>
  <xsl:call-template name="PhysicalReceiveStats"/>
  <xsl:call-template name="PhysicalTransmitStats"/>
  <xsl:call-template name="InterfaceReceiveStats"/>
  <xsl:call-template name="InterfaceTransmitStats"/>
</xsl:template>
  
<xsl:template name="PhysicalReceiveStats">
<xsl:if test="rxGoodFrames!='18446744073709551615' or rxBadFrames!='18446744073709551615' or rxAlignmentErrors!='18446744073709551615' or rxFCSErrors!='18446744073709551615' or rxInternalMACRxErrors!='18446744073709551615' or rxFrameTooLongs!='18446744073709551615' ">
  <TableData name="phyrcvstats">
	<xsl:choose>
		<xsl:when test="/OMA/NICList/VirNicObj">
	  <xsl:attribute name="display"><xsl:value-of select="$strTeamInterfaceReceiveStats"/></xsl:attribute>
	  <SubHeader>
			<xsl:attribute name="display"><xsl:value-of select="$strTeamInterfaceReceiveStats"/></xsl:attribute>
	  </SubHeader>
	</xsl:when>
<xsl:otherwise>
 <xsl:attribute name="display"><xsl:value-of select="$strPhyIfReceiveStats"/></xsl:attribute>
	  <SubHeader>
			<xsl:attribute name="display"><xsl:value-of select="$strPhyIfReceiveStats"/></xsl:attribute>
	  </SubHeader>
</xsl:otherwise>
</xsl:choose>
	  <Header>
		  <Data width="40%">
					<xsl:attribute name="display"><xsl:value-of select="$gstrAttribute"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$gstrAttribute"/></xsl:attribute>
				</Data>
				<Data width ="60%">
					<xsl:attribute name="display"><xsl:value-of select="$gstrValue"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$gstrValue"/></xsl:attribute>
				</Data>
     </Header>
		<xsl:if test="rxGoodFrames!='18446744073709551615' ">
			<Row>
				<Data>
		      <xsl:attribute name="value"><xsl:value-of select="$strGoodFrames"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="rxGoodFrames"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="rxBadFrames!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strBadFrames"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="rxBadFrames"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="rxAlignmentErrors!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strAlignmentErrors"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="rxAlignmentErrors"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="rxFCSErrors!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strFCSErrors"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="rxFCSErrors"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="rxInternalMACRxErrors!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strInternalMACRxErrors"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="rxInternalMACRxErrors"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="rxFrameTooLongs!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strFramesTooLong"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="rxFrameTooLongs"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
	 </TableData>
</xsl:if>
  </xsl:template>

<xsl:template name="PhysicalTransmitStats">
<xsl:if test="txGoodFrames!='18446744073709551615' or txBadFrames!='18446744073709551615' or txSingleCollisionFrames!='18446744073709551615' or txMultipleCollisionFrames!='18446744073709551615' or txDeferredTransmits!='18446744073709551615' or txCollisions!='18446744073709551615' or txLateCollisions!='18446744073709551615' or txExcessiveCollisions!='18446744073709551615' or txCarrierSenseErrors!= '18446744073709551615' or txInternalMACTxErrors!='18446744073709551615' ">
  <TableData name="phytxstats">
<xsl:choose>
		<xsl:when test="/OMA/NICList/VirNicObj">
	  <xsl:attribute name="display"><xsl:value-of select="$strTeamInterfaceTransmitStats"/></xsl:attribute>
	  <SubHeader>
			<xsl:attribute name="display"><xsl:value-of select="$strTeamInterfaceTransmitStats"/></xsl:attribute>
	  </SubHeader>
	</xsl:when>
<xsl:otherwise>
	  <xsl:attribute name="display"><xsl:value-of select="$strPhyIfTransmitStats"/></xsl:attribute>
	  <SubHeader>
			<xsl:attribute name="display"><xsl:value-of select="$strPhyIfTransmitStats"/></xsl:attribute>
	  </SubHeader>
</xsl:otherwise>
</xsl:choose>

	  <Header>
		  <Data width="40%">
					<xsl:attribute name="display"><xsl:value-of select="$gstrAttribute"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$gstrAttribute"/></xsl:attribute>
				</Data>
				<Data width ="60%">
					<xsl:attribute name="display"><xsl:value-of select="$gstrValue"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$gstrValue"/></xsl:attribute>
				</Data>
     </Header>

		<xsl:if test="txGoodFrames!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strGoodFrames"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="txGoodFrames"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="txBadFrames!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strBadFrames"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="txBadFrames"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="txSingleCollisionFrames!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strSingleCollisionFrames"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="txSingleCollisionFrames"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="txMultipleCollisionFrames!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strMultipleCollisionFrames"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="txMultipleCollisionFrames"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="txDeferredTransmits!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strDeferredTransmits"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="txDeferredTransmits"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="txCollisions!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strCollisions"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="txCollisions"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>    
		<xsl:if test="txLateCollisions!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strLateCollisions"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="txLateCollisions"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="txExcessiveCollisions!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strExcessiveCollisions"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="txExcessiveCollisions"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="txCarrierSenseErrors!= '18446744073709551615'">
			<Row>
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strCarrierSenseErrors"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="txCarrierSenseErrors"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="txInternalMACTxErrors!='18446744073709551615' ">
			<Row>
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strInternalMACTxErrors"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="txInternalMACTxErrors"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>    
	 </TableData>
</xsl:if>
  </xsl:template>

<xsl:template name="InterfaceReceiveStats">
<xsl:if test="rxBytes!='18446744073709551615' or rxTotalPackets!='18446744073709551615' or rxUnicastPackets!='18446744073709551615' or rxMulticastPackets!='18446744073709551615' or rxBroadcastPackets!='18446744073709551615' or rxDiscardedPackets!='18446744073709551615' or rxErrorPackets!='18446744073709551615' or rxUnknownProtocols!='18446744073709551615'">
  <TableData name="ifrcvstats">
	  <xsl:attribute name="display"><xsl:value-of select="$strIfReceiveStats"/></xsl:attribute>
	  <SubHeader>
			<xsl:attribute name="display"><xsl:value-of select="$strIfReceiveStats"/></xsl:attribute>
	  </SubHeader>
	  <Header>
		  <Data width="40%">
					<xsl:attribute name="display"><xsl:value-of select="$gstrAttribute"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$gstrAttribute"/></xsl:attribute>
				</Data>
				<Data width ="60%">
					<xsl:attribute name="display"><xsl:value-of select="$gstrValue"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$gstrValue"/></xsl:attribute>
				</Data>
     </Header>
		<xsl:if test="rxBytes!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strBytes"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="rxBytes"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="rxTotalPackets!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strTotalPackets"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="rxTotalPackets"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="rxUnicastPackets!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strUnicastPackets"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="rxUnicastPackets"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="rxMulticastPackets!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strMulticastPackets"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="rxMulticastPackets"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="rxBroadcastPackets!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strBroadcastPackets"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="rxBroadcastPackets"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>    
		<xsl:if test="rxDiscardedPackets!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strDiscardedPackets"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="rxDiscardedPackets"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="rxErrorPackets!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strErrorPackets"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="rxErrorPackets"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="rxUnknownProtocols!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strUnknownProtocols"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="rxUnknownProtocols"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
	 </TableData>
</xsl:if>
  </xsl:template>
  
<xsl:template name="InterfaceTransmitStats">
<xsl:if test="txBytes!='18446744073709551615' or txTotalPackets!='18446744073709551615' or txUnicastPackets!='18446744073709551615' or txDiscardedPackets!='18446744073709551615' or txErrorPackets!='18446744073709551615' or txQueueLength!='18446744073709551615' ">
  <TableData name="iftxstats">
	  <xsl:attribute name="display"><xsl:value-of select="$strIfTransmitStats"/></xsl:attribute>
	  <SubHeader>
			<xsl:attribute name="display"><xsl:value-of select="$strIfTransmitStats"/></xsl:attribute>
	  </SubHeader>
	  <Header>
		  <Data width="40%">
					<xsl:attribute name="display"><xsl:value-of select="$gstrAttribute"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$gstrAttribute"/></xsl:attribute>
				</Data>
				<Data width ="60%">
					<xsl:attribute name="display"><xsl:value-of select="$gstrValue"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$gstrValue"/></xsl:attribute>
				</Data>
     </Header>
		<xsl:if test="txBytes!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strBytes"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="txBytes"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="txTotalPackets!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strTotalPackets"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="txTotalPackets"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="txUnicastPackets!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strUnicastPackets"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="txUnicastPackets"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="txDiscardedPackets!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strDiscardedPackets"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="txDiscardedPackets"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="txErrorPackets!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strErrorPackets"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="txErrorPackets"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="txQueueLength!='18446744073709551615' ">
			<Row>	
				<Data>
          <xsl:attribute name="value"><xsl:value-of select="$strQueueLength"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="txQueueLength"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
	 </TableData>
</xsl:if>
  </xsl:template>
  
<xsl:template match="IPAddressList/IPUnicastAddrListObj ">
  <xsl:apply-templates select="addrListarray"/>
</xsl:template>
<xsl:template match="addrListarray">
<xsl:if test="/OMA/IPAddressList/IPUnicastAddrListObj/numIPv4Addrs>0">
  <TableData name="ipv4addr">
    <xsl:attribute name="display"><xsl:value-of select="$strIPV4"/></xsl:attribute>
			<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strIPV4"/></xsl:attribute>
			</SubHeader>
			<Header>
		  	<Data width="40%">
					<xsl:attribute name="display"><xsl:value-of select="$strIPAddress"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strIPAddress"/></xsl:attribute>
				</Data>
				<Data width ="60%">
					<xsl:attribute name="display"><xsl:value-of select="$strSubnetMask"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strSubnetMask"/></xsl:attribute>
				</Data>
      </Header>

		 <xsl:for-each select="addrList">
			<xsl:if test="ipv4Addr/IPAddress!=''">
		 	  <Row>
				  <Data>
			      <xsl:attribute name="value"><xsl:value-of select="ipv4Addr/IPAddress"/></xsl:attribute>
				  </Data>
			    <xsl:if test="ipv4Addr/SubNetMask!=''">
				    <Data>
					    <xsl:attribute name="value"><xsl:value-of select="ipv4Addr/SubNetMask"/></xsl:attribute>
				    </Data>
			    </xsl:if>
			  </Row>
			</xsl:if>
      </xsl:for-each>
		</TableData>
		</xsl:if>

		<xsl:if test="/OMA/IPAddressList/IPUnicastAddrListObj/numIPv6Addrs > 0">
      <TableData name="ipv6addr">
        <xsl:attribute name="display"><xsl:value-of select="$strIPV6"/></xsl:attribute>
			<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strIPV6"/>	</xsl:attribute>

			</SubHeader>
			<Header>
				<Data width="40%">
					<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strName"/></xsl:attribute>
				</Data>
				<Data width ="40%">
					<xsl:attribute name="display"><xsl:value-of select="$strIPAddress"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strIPAddress"/></xsl:attribute>
				</Data>
				<Data width ="20%">
					<xsl:attribute name="display"><xsl:value-of select="$strPrefix"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strPrefix"/></xsl:attribute>
				</Data>
			</Header>

			<xsl:for-each select="addrList/ipv6Addr/scope[not(.=following::addrList/ipv6Addr/scope)]">
				<xsl:choose>
					<xsl:when test=".='2'">
					<Row>
						<Data>	
							<xsl:attribute name="value"><xsl:value-of select="$strLinkLocal"/>	</xsl:attribute>
						</Data>
						<Data>
							<xsl:attribute name="value"><xsl:value-of select="../IPv6Address"/> </xsl:attribute>
						</Data>
						<Data>            
							<xsl:attribute name="value">	
								<xsl:choose>
									<xsl:when test="../prefixLen='255'"><xsl:value-of select="$gstrNotAvailable"/></xsl:when>
									<xsl:otherwise><xsl:value-of select="../prefixLen"/></xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
						</Data>
					</Row>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each >
		

		<xsl:for-each select="addrList/ipv6Addr/IPv6Address[not(.='')]">
		<xsl:sort select ="../scope!='2'" order="descending" />
		<xsl:choose>
			<xsl:when test="position() &lt; 3 and ../scope !='2'">
				<Row>
					<Data>	
						<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="position()=1">
								<xsl:value-of select="$strIPv6Address1"/> 

							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$strIPv6Address2"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>

				<Data>
					<xsl:attribute name="value"> 
						<xsl:choose>
							<xsl:when test=".=''"> 
								<xsl:value-of select="$strNoValue"/> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="."/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>
				<Data>            
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="../prefixLen='255'"><xsl:value-of select="$gstrNotAvailable"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="../prefixLen"/></xsl:otherwise>
						</xsl:choose>
						</xsl:attribute>
					</Data>
				</Row>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each >
		</TableData>

		</xsl:if>
</xsl:template>
  <xsl:template name="IdentifyAdapterType">
    <xsl:param name="type"/>
    <xsl:choose>
      <xsl:when test="$type = 1"><xsl:value-of select="$strOther"/></xsl:when>
      <xsl:when test="$type = 6"><xsl:value-of select="$strEthernet"/></xsl:when>
      <xsl:when test="$type = 9"><xsl:value-of select="$strTokenRing"/></xsl:when> 
      <xsl:when test="$type = 23"><xsl:value-of select="$strPPP"/></xsl:when> 
      <xsl:when test="$type = 24"><xsl:value-of select="$strSWLoop"/></xsl:when> 
      <xsl:when test="$type = 37"><xsl:value-of select="$strATM"/></xsl:when> 
      <xsl:when test="$type = 71"><xsl:value-of select="$strIEEE802Wireless"/></xsl:when>
      <xsl:when test="$type = 131"><xsl:value-of select="$strTunnelType"/></xsl:when> 
      <xsl:when test="$type = 144"><xsl:value-of select="$strIEEE1394"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="OperationalStatus">
    <xsl:param name="status"/>
    <xsl:choose>
      <xsl:when test="$status = 1"><xsl:value-of select="$strUp"/></xsl:when>
      <xsl:when test="$status = 2"><xsl:value-of select="$strDown"/></xsl:when>
      <xsl:when test="$status = 3"><xsl:value-of select="$strTestMode"/></xsl:when> 
      <xsl:when test="$status = 4"><xsl:value-of select="$strUnknown"/></xsl:when> 
      <xsl:when test="$status = 5"><xsl:value-of select="$strDormant"/></xsl:when> 
      <xsl:when test="$status = 6"><xsl:value-of select="$strNotPresent"/></xsl:when> 
      <xsl:when test="$status = 7"><xsl:value-of select="$strLowerLayerDown"/></xsl:when>      
      <xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="AdminStatus">
    <xsl:param name="status"/>
    <xsl:choose>
      <xsl:when test="$status = 1"><xsl:value-of select="$strUp"/></xsl:when>
      <xsl:when test="$status = 2"><xsl:value-of select="$strDown"/></xsl:when>
      <xsl:when test="$status = 3"><xsl:value-of select="$strTestMode"/></xsl:when> 
      <xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

<xsl:template name="formatSpeedValue">
    <xsl:param name="value"/>
    <xsl:choose>
      <xsl:when test="$value = '0'"><xsl:value-of select="$gstrNotAvailable"/></xsl:when>
      <xsl:otherwise>
        <xsl:variable name="formatval"><xsl:value-of select="format-number($value div 1000000,'##0.0')"/></xsl:variable>
					<xsl:variable name="univdecsep">
						<xsl:choose>
							<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = '.'">.</xsl:when>
							<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = ','">,</xsl:when>
						</xsl:choose>
					</xsl:variable>
					<xsl:variable name="localdecsep"><xsl:value-of select="$gstrDecimalFractionSeperator"/></xsl:variable>
					<xsl:value-of select="translate($formatval, $univdecsep,$localdecsep)"/><xsl:value-of select="$strMbps"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
<!-- convert decimal to Hex -->
<xsl:variable name="hexDigits" select="'0123456789ABCDEF'" />
 <xsl:template name="DecimaltoHex">
  <xsl:param name="decimalNumber" />
     <xsl:if test="$decimalNumber >= 16">
       <xsl:call-template name="DecimaltoHex">
         <xsl:with-param name="decimalNumber" select="floor($decimalNumber div 16)" />
       </xsl:call-template>
     </xsl:if>
     <xsl:value-of select="substring($hexDigits, ($decimalNumber mod 16) + 1, 1)" />
 </xsl:template>

<xsl:template match="*"/>
</xsl:stylesheet>
