<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:include href="../en/globals.xsl"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>
  
  <xsl:variable name="IsiDRAC7Present">
      <xsl:choose>
        <xsl:when test="/OMA/EMPObj/type = '16' or /OMA/EMPObj/type = '17' ">true</xsl:when>
        <xsl:otherwise>false</xsl:otherwise>
      </xsl:choose>
  </xsl:variable>

  <xsl:variable name="IsiDRAC6Present"> <!--iDRAC Ent or Exp-->
    <xsl:choose>
      <xsl:when test="/OMA/EMPObj/type = '10' or /OMA/EMPObj/type = '11' ">true</xsl:when>
      <xsl:otherwise>false</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="IsiDRACPresent"> <!--iDRAC on Blade-->
    <xsl:choose>
      <xsl:when test="/OMA/EMPObj/type = '8' ">true</xsl:when>
      <xsl:otherwise>false</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  
  

	<xsl:variable name="solEnabled">
		<xsl:choose>
			<!-- if there are any payloadAccessCapabilities nodes with SOL = 'true' -->
			<xsl:when test="/OMA/EMPUserAccessListObj/userAccessListarray/userAccessList[channelMediumType='4']/payloadAccessCapabilities[SOL='true']">true</xsl:when>
			<xsl:otherwise>false</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="dracUserPrivEnabled">
		<xsl:choose>
			<!-- if EMPRACObj object is present: -->
			<xsl:when test="/OMA/EMPRACObj">true</xsl:when>
			<xsl:otherwise>false</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="dracAdminBitmask">511</xsl:variable>
	<xsl:variable name="dracPowerUserBitmask">249</xsl:variable>
	<xsl:variable name="dracGuestBitmask">1</xsl:variable>
	<xsl:variable name="dracNoneBitmask">0</xsl:variable>
	<xsl:variable name="dracCustomBitmask">0</xsl:variable>
	
	<xsl:template match="OMA">	
	<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>

	<DataArea>

		<PageTitle><xsl:attribute name="display"><xsl:value-of select="$strEMPUsers"/></xsl:attribute></PageTitle>


			<xsl:if test="EMPObj/defaultRestoreStatus = '0'">
				<xsl:if test="EMPObj/defaultRestoreSupport = '1'">
				<xsl:choose>
					<xsl:when test = "/OMA/@cli = 'true'">
						<PromptText><xsl:value-of select ="$gstrResetToDefaultCli"/></PromptText>
					</xsl:when>
					<xsl:otherwise>
							<PromptText><xsl:value-of select="$gstrResetToDefault"/></PromptText>
					</xsl:otherwise>
				</xsl:choose>	
				</xsl:if>
			</xsl:if>
		<xsl:if test="$usrights='7' ">
			<PromptText><xsl:value-of select="$strClickonuser"/></PromptText>
		</xsl:if>

		<CustomButton>
			<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.BMCUserWebPlugin&amp;help=RemoteAccessUsers</xsl:attribute>
			</Data>
		</CustomButton>

		<xsl:apply-templates select="EMPUserListObj"/>
	</DataArea>
	</xsl:template>



	
	<xsl:template match="EMPUserListObj ">
		<TableData columnspacing="true" name="tab2" display=" ">
			<!--SubHeader><xsl:attribute name="display"><xsl:value-of select="$strListofEMP"/></xsl:attribute></SubHeader-->
			<Header>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strUserID"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strUserID"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strState"/></xsl:attribute>
				</Data>

				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strUserName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strUserName"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strLAN"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strLAN"/></xsl:attribute>
				</Data>
				<xsl:if test="/OMA/EMPSerialConfigObj">
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strSerialPort"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strSerialPort"/></xsl:attribute>
				</Data>
				</xsl:if>
				<!-- add SOL column, if enabled -->
				<xsl:if test="$solEnabled='true'">
					<Data display="{$strSerialOverLan}" value="{$strSerialOverLan}"/>
				</xsl:if>
				<!-- add DRACUserPriv column, if enabled -->
				<xsl:if test="$dracUserPrivEnabled='true' or $IsiDRAC7Present='true' or $IsiDRAC6Present='true' or $IsiDRACPresent='true' ">
				  <xsl:choose>
				    <xsl:when test="$IsiDRAC7Present='true' or $IsiDRAC6Present='true' or $IsiDRACPresent='true' ">
				      <Data display="{$striDRACUserPrivilege}" value="{$striDRACUserPrivilege}"/>
				    </xsl:when>
				    <xsl:otherwise>
				      <Data display="{$strDracUserPrivilege}" value="{$strDracUserPrivilege}"/>
				    </xsl:otherwise>
				  </xsl:choose>
				</xsl:if>
			</Header>
			
		     <xsl:apply-templates select="userListarray/userList"/>
		
		</TableData>
	</xsl:template>
	
	<xsl:template match="userList">
	<xsl:variable name="usrights"><xsl:value-of select="/OMA/OMAUserRights"/></xsl:variable>
	<xsl:variable name="userIndex"><xsl:value-of select="userID"/></xsl:variable>
		<Row>
			<Data>
				<xsl:choose>
				
					<xsl:when test="($usrights='7') and ((userSettable/NameConfigurable='true' ) or (userSettable/Deletable='true' ) or (userSettable/PwdConfigurable='true' ) and not ( $userIndex='1')  )">
						<xsl:attribute name="link">true</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="link">false</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:attribute name="value">
					<xsl:value-of select="userID"/>
				</xsl:attribute>
				<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.BMCGetUserEntry&amp;oid=<xsl:value-of select="@oid"/>&amp;help=RemoteAccessUser&amp;index=<xsl:value-of select="userID" /></xsl:attribute>
			</Data>
			<Data>
					<xsl:attribute name="value">
						<xsl:choose>
						<xsl:when test="currentState='true'">
							<xsl:value-of select="$strEnabled"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$strDisabled"/>
						</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
			</Data>


			<Data>
					<xsl:attribute name="value">
						<xsl:value-of select="UserName"/>
					</xsl:attribute>
			</Data>

			<Data>
				<xsl:attribute name="value">
					<xsl:apply-templates select="/OMA/EMPUserAccessListObj/userAccessListarray/userAccessList">
						<xsl:with-param name="userid"><xsl:value-of select="userID"/></xsl:with-param>
						<!--xsl:with-param name="channel">1</xsl:with-param-->
						<xsl:with-param name="mediatype">4</xsl:with-param>
					</xsl:apply-templates>
				</xsl:attribute>

			</Data>
			<xsl:if test="/OMA/EMPSerialConfigObj">
			<Data>
				<xsl:attribute name="value">
					<xsl:apply-templates select="/OMA/EMPUserAccessListObj/userAccessListarray/userAccessList">
						<xsl:with-param name="userid"><xsl:value-of select="userID"/></xsl:with-param>
						<!--xsl:with-param name="channel">2</xsl:with-param-->
						<xsl:with-param name="mediatype">5</xsl:with-param>
					</xsl:apply-templates>	
				</xsl:attribute>
				
			</Data>
			</xsl:if>
			<!-- add SOL, if enabled -->
			<xsl:if test="$solEnabled='true'">
				<Data>
					<xsl:attribute name="value">
						<xsl:choose>
							<!-- if this user's SOL is allowed, then see if it's enabled or not: -->
							<xsl:when test="/OMA/EMPUserAccessListObj/userAccessListarray/userAccessList[userID=$userIndex and channelMediumType='4']/payloadAccessCapabilities/SOL = 'true'">
								<xsl:choose>
									<xsl:when test="/OMA/EMPUserAccessListObj/userAccessListarray/userAccessList[userID=$userIndex and channelMediumType='4']/payloadAccessSettings/SOL = 'true'">
										<xsl:value-of select="$strEnabled"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$strDisabled"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
						</xsl:choose>
					</xsl:attribute>
				</Data>
			</xsl:if>
			<!-- add DRACUserPriv, if enabled -->
			<xsl:if test="$dracUserPrivEnabled='true' or $IsiDRAC7Present='true' or $IsiDRAC6Present='true' or $IsiDRACPresent='true' ">
				<xsl:variable name="dracPermissions">
					<xsl:call-template name="calcDracPermissionsBitflag">
						<xsl:with-param name="node" select="RACPriv"/>
					</xsl:call-template>
				</xsl:variable>
				<Data>

				<xsl:if test="$IsiDRAC7Present='true' or $IsiDRAC6Present='true' or $IsiDRACPresent='true' ">
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="$dracPermissions = $dracAdminBitmask"><xsl:value-of select="$strAdministrator"/></xsl:when>
							<xsl:when test="$dracPermissions = $dracPowerUserBitmask"><xsl:value-of select="$strOperator"/></xsl:when>
							<xsl:when test="$dracPermissions = $dracGuestBitmask"><xsl:value-of select="$strReadOnly"/></xsl:when>
							<xsl:when test="$dracPermissions = $dracNoneBitmask"><xsl:value-of select="$strNone"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$strDracCustom"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
					</xsl:if>

				<xsl:if test="$dracUserPrivEnabled='true'">
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="$dracPermissions = $dracAdminBitmask"><xsl:value-of select="$strAdministrator"/></xsl:when>
							<xsl:when test="$dracPermissions = $dracPowerUserBitmask"><xsl:value-of select="$strDracPowerUser"/></xsl:when>
							<xsl:when test="$dracPermissions = $dracGuestBitmask"><xsl:value-of select="$strDracGuest"/></xsl:when>
							<xsl:when test="$dracPermissions = $dracNoneBitmask"><xsl:value-of select="$strNone"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$strDracCustom"/></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</xsl:if>

				</Data>
			</xsl:if>
		</Row>
	</xsl:template>
	
	<xsl:template match="userAccessList ">
		<xsl:param name="userid"/>
		<!--xsl:param name="channel"/>
		<xsl:if test="($userid=userID) and ($channel=channelNumber)"-->
		<xsl:param name="mediatype"/>
		<xsl:if test="($userid=userID) and ($mediatype=channelMediumType)">

			<xsl:choose>
				<xsl:when test="userAccessLevel='2'">
					<xsl:value-of select="$strUser"/>
				</xsl:when>
				<xsl:when test="userAccessLevel='3'">
					<xsl:value-of select="$strOperator"/>
				</xsl:when>
				<xsl:when test="userAccessLevel='4'">
					<xsl:value-of select="$strAdministrator"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$strNone"/>
				</xsl:otherwise>

			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="calcDracPermissionsBitflag">
		<xsl:param name="node"/>
		<xsl:value-of select="number($node/LoginUser = 'true') * 1 +
								number($node/CardConfigAdmin = 'true') * 2 +
								number($node/UserConfigAdmin = 'true') * 4 +
								number($node/LogClearAdmin = 'true') * 8 +
								number($node/ServerResetPwrOnOffUser = 'true') * 16 +
								number($node/ConsoleRedirUser = 'true') * 32 +
								number($node/VirtualMediaUser = 'true') * 64 +
								number($node/TestAlertUser = 'true') * 128 +
								number($node/DebugCmdAdmin = 'true') * 256"/>
	</xsl:template>
</xsl:stylesheet>
