<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml"/>
	<xsl:include href="../en/globals.xsl"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>
	
  <xsl:variable name="IsiDRAC7Present">
      <xsl:choose>
        <xsl:when test="/OMA/EMPObj/type = '16' or /OMA/EMPObj/type = '17' ">true</xsl:when>
        <xsl:otherwise>false</xsl:otherwise>
      </xsl:choose>
  </xsl:variable>

  <xsl:variable name="IsiDRAC6Present"> <!--iDRAC Ent or Exp-->
    <xsl:choose>
      <xsl:when test="/OMA/EMPObj/type = '10' or /OMA/EMPObj/type = '11' ">true</xsl:when>
      <xsl:otherwise>false</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="IsiDRACPresent"> <!--iDRAC on Blade-->
    <xsl:choose>
      <xsl:when test="/OMA/EMPObj/type = '8' ">true</xsl:when>
      <xsl:otherwise>false</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>	


	<xsl:template match="OMA">	
	
	<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
		<DataArea onLoad="true">
			<!--xsl:if test="$usrights='7'"-->
			<xsl:if test="$usrights='7' ">
				<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.hip.webplugins.SetBmcSerAdvWebPlugin</xsl:attribute>
			</xsl:if>
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strSerialPortConf"/></xsl:attribute>
			<xsl:attribute name="backpagetarget">./DataArea?plugin=com.dell.hip.webplugins.BMCSerialWebPlugin&amp;help=RemoteAccessSer</xsl:attribute>


			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strSerialPortConfAdv"/></xsl:attribute>
			</PageTitle>

<xsl:if test="EMPObj/defaultRestoreStatus = '0'">
				<xsl:if test="EMPObj/defaultRestoreSupport = '1'">
				<xsl:choose>
					<xsl:when test = "/OMA/@cli = 'true'">
						<PromptText><xsl:value-of select ="$gstrResetToDefaultCli"/></PromptText>
					</xsl:when>
					<xsl:otherwise>
							<PromptText><xsl:value-of select="$gstrResetToDefault"/></PromptText>
					</xsl:otherwise>
				</xsl:choose>	
				</xsl:if>
			</xsl:if>
			<CustomButton>
				<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.BMCSerialAdvWebPlugin&amp;help=RemoteAccessSerAd</xsl:attribute>
				</Data>
			</CustomButton>


	<ListData type="custom"   columnspacing="true" name="tabSerialConfiguration">
    <xsl:attribute name="display"><xsl:value-of select="$strTerminalModeConf"/></xsl:attribute>
		<Header>
      <Data>
			<xsl:attribute name="display"><xsl:value-of select="$strTerminalModeConf"/></xsl:attribute>
      <xsl:attribute name="value"><xsl:value-of select="$strTerminalModeConf"/></xsl:attribute>
      </Data>
		</Header>
						<xsl:if test="/OMA/@cli = 'true'">
				<Header>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strAttribute"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strAttribute"/></xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strValue"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strValue"/></xsl:attribute>
					</Data>
				</Header>
				</xsl:if>
	
				<Data name="LineEditing" type="select" editable="true">
				<xsl:attribute name="display"><xsl:value-of select="$strLineEditing"/></xsl:attribute>		
		
				<Choice returnvalue="1">
					<xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeLineEditing='1'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="0">
					<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeLineEditing='0'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</Data>
    
       <Data name="DeleteControl" type="select" editable="true">
				<xsl:attribute name="display"><xsl:value-of select="$strDeleteControl"/></xsl:attribute>			
			
				<Choice returnvalue="0">
					<xsl:choose>
					<xsl:when test="$IsiDRAC7Present='true' or $IsiDRACPresent ='true' or $IsiDRAC6Present ='true'">
					<xsl:attribute name="value"><xsl:value-of select="$strIDRACoutputsadel"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
					<xsl:attribute name="value"><xsl:value-of select="$strBMCoutputsadel"/></xsl:attribute>
					</xsl:otherwise>
					</xsl:choose>					
					<xsl:if test="EMPSerialConfigObj/terminalModeDeleteControl='0'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="1">
					<xsl:choose>
					<xsl:when test="$IsiDRAC7Present='true' or $IsiDRACPresent ='true' or $IsiDRAC6Present ='true'">
					<xsl:attribute name="value"><xsl:value-of select="$strIDRACoutputsabksp"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
					<xsl:attribute name="value"><xsl:value-of select="$strBMCoutputsabksp"/></xsl:attribute>
					</xsl:otherwise>
					</xsl:choose>
					<xsl:if test="EMPSerialConfigObj/terminalModeDeleteControl='1'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</Data>
	
    <Data name="EchoControl" type="select" editable="true">
				<xsl:attribute name="display"><xsl:value-of select="$strEchoControl"/></xsl:attribute>
		
				<Choice returnvalue="1">
					<xsl:attribute name="value"><xsl:value-of select="$strEcho"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeEcho='1'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="0">
					<xsl:attribute name="value"><xsl:value-of select="$strNoEcho"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeEcho='0'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</Data>
    
    <Data name="HandshakingControl" type="select" editable="true">
				<xsl:attribute name="display"><xsl:value-of select="$strHandshakingControl"/></xsl:attribute>
			
				<Choice returnvalue="1">
					<xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeHandshake='1'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="0">
					<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeHandshake='0'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</Data>

    <Data name="NewLine" type="select" editable="true">
				<xsl:attribute name="display"><xsl:value-of select="$strNewLineSequence"/></xsl:attribute>
						
				<Choice returnvalue="0">
					<xsl:attribute name="value"><xsl:value-of select="$strNone"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeNLSeq='0'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="1">
					<xsl:attribute name="value"><xsl:value-of select="$strCRLF"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeNLSeq='1'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="2">
					<xsl:attribute name="value"><xsl:value-of select="$strNULL"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeNLSeq='2'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="3">
					<xsl:attribute name="value"><xsl:value-of select="$strCR"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeNLSeq='3'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="4">
					<xsl:attribute name="value"><xsl:value-of select="$strLFCR"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeNLSeq='4'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="5">
					<xsl:attribute name="value"><xsl:value-of select="$strLF"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeNLSeq='5'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</Data>


    <Data name="InputNewLine" type="select" editable="true">
				<xsl:attribute name="display"><xsl:value-of select="$strInputNewLine"/></xsl:attribute>
			
				<Choice returnvalue="1">
					<xsl:attribute name="value"><xsl:value-of select="$strCR"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeInputNLSeq='1'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="2">
					<xsl:attribute name="value"><xsl:value-of select="$strNULL"/></xsl:attribute>
					<xsl:if test="EMPSerialConfigObj/terminalModeInputNLSeq='2'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>

			</Data>
		
				<script language="javascript">
			var usrights = '<xsl:value-of select="/OMA/OMAUserRights"/>';

				function initializationRoutine()
				{
					
					EnableSettingsAccordingtoUserRights();
					
					
				}				

				
				function EnableSettingsAccordingtoUserRights()
				{		
					if (usrights != 7 ) 
					{
						document.getElementById("LineEditing").disabled  =true;
						document.getElementById("DeleteControl").disabled  =true;
						document.getElementById("EchoControl").disabled  =true;
						document.getElementById("HandshakingControl").disabled  =true;				
						document.getElementById("NewLine").disabled  =true; 
						document.getElementById("InputNewLine").disabled  =true; 
					}
				}
				</script>
		</ListData>	
		</DataArea>
	</xsl:template>
</xsl:stylesheet>