<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="html" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"/>
<xsl:template match="/MenuList">
	<html>
	<head>
	<title></title>
	<link rel="stylesheet" type="text/css" href="/oma/css/snb.css" />
	<script language="javascript">
	var g_nLastMenuItem = 0;
	var g_nMenuItem = 0;
	var g_nDefaultItem= 1;
	var g_sDefaultTarget = "";
	var g_sDefaultHelp = "";
	var g_sDefaultApp = "";
	var g_vMenuItemName = new Array();
	var g_sCurrentComponent = "";
	var g_sDefaultItem = '<xsl:value-of select="@snb" />';
	var g_sDefaultLSNB = '<xsl:value-of select="@lsnb" />';
	var g_iLeftTab;
	var g_iMiddleTab;
	var g_iRightTab;
	var g_iLeftTabSelected;
	var g_iLeftMiddleTabSelected;
	var g_iRightMiddleTabSelected;
	var g_iRightTabSelected;
	var g_bInitInProgress = false;
	var g_sNewLink = "";
	var g_hTimer;
	var g_hCSMA_CD;
	var g_nLSNBLoadStart;

	g_iLeftTab = new Image ();
	g_iLeftTab.src = "/oma/images/snb_left.png"
	g_iMiddleTab = new Image ();
	g_iMiddleTab.src = "/oma/images/snb_divider.png"
	g_iRightTab = new Image ();
	g_iRightTab.src = "/oma/images/snb_divider.png"
	g_iLeftTabSelected = new Image ();
	g_iLeftTabSelected.src = "/oma/images/snb_left_side_selected.png"
	g_iLeftMiddleTabSelected = new Image ();
	g_iLeftMiddleTabSelected.src = "/oma/images/snb_left_selected.png"
	g_iRightMiddleTabSelected = new Image ();
	g_iRightMiddleTabSelected.src = "/oma/images/snb_right_selected.png"
	g_iRightTabSelected = new Image ();
	g_iRightTabSelected.src = "/oma/images/snb_right_selected.png"

	function init () {
		parent.ct.snbLoad = true;
		g_bInitInProgress = true;
		select  (g_nDefaultItem, g_sDefaultTarget, g_sDefaultHelp, g_sDefaultApp);
		g_bInitInProgress = false;
		var tabSet = document.getElementById ("snb_tabs");
		tabSet.style.display = "";
	}
	function loadPage () {
		parent.ct.clearLock ();
		window.clearInterval (g_hTimer);
	}
	function csma_cd () {
		if (parent.ct.g_bLoadInProgress == false) {
			var now = new Date ();
			parent.ct.g_nLSNBLatency = now.getTime () - g_nLSNBLoadStart;
			window.clearInterval (g_hCSMA_CD);
		}
	}
	function select (nSelectedItem, sTarget, sHelp, sApp) {
		if (parent.ct.g_bLoadInProgress == false || g_bInitInProgress == true) {
			parent.da.g_bStopOldRefresh = true;
			parent.ct.setLock ();
			if (_performSelect (nSelectedItem) == true) {
			var vvid = top.gnv.getVID();
				if (parent.ct.g_bSNBGoingBack == false) {
					if (sTarget != "") {
						var sTemp = sTarget;
						if (sTemp.indexOf ("?") != -1) {
							sTemp += "&amp;";
						}
						else {
							sTemp += "?";
						}
						sTemp = sTemp + "help=" + sHelp + "app=" + sApp +  '&amp;component=' + g_sCurrentComponent + '&amp;snb=' + sSelectedItem + '&amp;lsnb=' + g_sDefaultLSNB + "&amp;vid=" + vvid;
						parent.lsnb.location.href = sTemp;
					}
					else {
						var sSelectedItem = '';
						if (g_nMenuItem > 0)
							sSelectedItem = g_vMenuItemName[nSelectedItem - 1];
							
						g_sNewLink = './LoadLSNB?component=' + g_sCurrentComponent + '&amp;snb=' + sSelectedItem + '&amp;lsnb=' + g_sDefaultLSNB + "&amp;vid=" + vvid;
						
						if(navigator.appName == "Netscape") {
							g_nLSNBLoadStart = (new Date ()).getTime ();
							parent.lsnb.location.href = g_sNewLink;
							g_hCSMA_CD = window.setInterval (csma_cd, 100);
							if (parent.ct.g_nLSNBLatency > 0)
								g_hTimer = window.setInterval (loadPage, parent.ct.g_nLSNBLatency);
						}
						else {
							parent.lsnb.location.href = g_sNewLink;
						}
					}
				}
				else {
					parent.ct.g_bSNBGoingBack = false;
					_select (parent.ct.g_sSNB);
					parent.ct.clearLock ();
				}
			}
		}
	}
	function _select (sSelectItem) {
		for (i = 0; i &lt;  g_vMenuItemName.length; i++) {
			if (g_vMenuItemName[i] == sSelectItem)
				_performSelect (i + 1);
		}
	}
	function _performSelect (nSelectedItem) {
		if (parent.ct.g_bModal == false) {
			unHighlight (g_nLastMenuItem);
			g_nLastMenuItem = nSelectedItem;

			if (g_nMenuItem > 0) {
				if (g_nLastMenuItem == 1)
					document.images["img_0"].src = g_iLeftTabSelected.src;
				else
					document.images["img_" + (g_nLastMenuItem - 1)].src = g_iLeftMiddleTabSelected.src;
				if (g_nLastMenuItem == g_nMenuItem)
					document.images["img_" + g_nLastMenuItem].src = g_iRightTabSelected.src;
				else
					document.images["img_" + g_nLastMenuItem].src = g_iRightMiddleTabSelected.src;
				
				var tditem = document.getElementById("data_" + g_nLastMenuItem);
				if (nSelectedItem == 1)				
					tditem.className = "tab-text first";
				else
					tditem.className = "tab-text";				
				document.getElementById ("anchor_" + g_nLastMenuItem).className= "tab-text tab-text-selected";
			}
			return true;
		}
		return false;
	}
	function unHighlight (nSelectedItem) {
		if (nSelectedItem == 0) return;
		if (nSelectedItem == 1)
			document.images["img_0"].src = g_iLeftTab.src;
		else
			document.images["img_" + (nSelectedItem - 1)].src = g_iMiddleTab.src;
		if (nSelectedItem == g_nMenuItem)
			document.images["img_" + nSelectedItem].src = g_iRightTab.src;
		else
			document.images["img_" + nSelectedItem].src = g_iMiddleTab.src;

		var tditem = document.getElementById("data_" + nSelectedItem);
		if (nSelectedItem == 1)
			tditem.className = "tab-image first";
		else
			tditem.className = "tab-image";	
			
		document.getElementById ("anchor_" + nSelectedItem).className = 'tab-text';
	}
	function reloadTree () {
		parent.ct.location.href='./ComponentTree'
	}
	</script>
	</head>
	<body onLoad="javascript:init()">
		<div id="snb_tabs" style="left: 0px;">
		<div class="rightside" style="right: 0px;"></div>
			<table cellpadding="0" cellspacing="0" border="0">
			<tr>
				<td>
					<img id="img_0">
						<xsl:attribute name="src">/oma/images/snb_left.png</xsl:attribute>
					</img>
				</td>
				<xsl:apply-templates />
				<td>
					<script language="javascript">
							document.write ('&lt;img id="img_' + g_nMenuItem + '" src="' + g_iRightTab.src + '"">');
					</script>
				</td>
			</tr>
			</table>
		</div>
	</body>
	</html>
</xsl:template>

<xsl:template match="Server">
</xsl:template>

<xsl:template match="Selection">
	<script language="javascript">
	g_sCurrentComponent = '<xsl:value-of select="@name" />';
	</script>
</xsl:template>

<xsl:template match="*">
	<script language="javascript">
	g_vMenuItemName[g_nMenuItem++] = '<xsl:value-of select="name()" />';
	if (g_nMenuItem == 1) {
		g_sDefaultTarget = '<xsl:value-of select="@href"/>';
		g_sDefaultHelp = '<xsl:value-of select="@help"/>';
		g_sDefaultApp = '<xsl:value-of select="@app"/>';

	}
	if ('<xsl:value-of select="@default"/>' == 'true' || '<xsl:value-of select="name()"/>' == g_sDefaultItem) {
		g_nDefaultItem = g_nMenuItem;
		g_sDefaultTarget = '<xsl:value-of select="@href"/>';
	}
	
	if (g_nMenuItem > 1) {
		document.write ('&lt;td>');
		document.write ('&lt;img id="img_' + (g_nMenuItem - 1) + '" src="' + g_iMiddleTab.src + '">');
		document.write ('&lt;/td>');
	}
	if (g_nMenuItem == 1) {
		document.write ('&lt;td id="data_' + g_nMenuItem+ '" class="tab-image first" valign="middle" align="center" style="padding-left: 14px;">');
	}else{
		document.write ('&lt;td id="data_' + g_nMenuItem+ '" class="tab-image" valign="middle" align="center">');	
	}	
	document.write ('&lt;a id="anchor_' + g_nMenuItem + '" name="anchor_' + g_nMenuItem + '" href="#" onclick="javascript:select(' + g_nMenuItem + ', \'<xsl:value-of select="@href" />\', \'<xsl:value-of select="@help" />\', \'<xsl:value-of select="@app" />\')" class="tab-text" nowrap="">');
	</script >
	<xsl:choose>
		<xsl:when test="@display"><xsl:value-of select="@display" /></xsl:when>
		<xsl:otherwise><xsl:value-of select="name()" /></xsl:otherwise>
	</xsl:choose>
	<script language="javascript">document.write ('&lt;/a>&lt;/td>');</script >
</xsl:template>

</xsl:stylesheet>
