<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="html" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"/>
<xsl:template match="/MenuList">
	<html>
	<head>
	<title></title>
	<link rel="stylesheet" type="text/css" href="/oma/css/lsnb.css" />
	<script language="javascript">
	var g_nLastItem = 1;
	var g_nMenuItem = 0;
	var g_vMenuItemName = new Array();
	var g_sDefaultItem = '<xsl:value-of select="@lsnb" />';
	var g_nDefaultItem= 1;
	var g_sDefaultTarget = "";
	var g_sDefaultHelp = "";
	var g_sDefaultApp = "";
	var g_bIE55 = false;
	var g_bInitInProgress = false;
	var g_nDataAreaLoadStart;
	var g_hCalculateLatency;
	var g_hClearLock;
	var g_bsmallfontreq = false;

	function init () {
		parent.ct.lsnbLoad = true;
		if (g_sDefaultTarget == "")
			g_sDefaultTarget = "/oma/loading.html";
		if (navigator.appName == "Microsoft Internet Explorer") {
			var sAppVersion = navigator.appVersion
			sAppVersion = sAppVersion.replace (/.*MSIE /i, "");
			sAppVersion = sAppVersion.split (';')[0];
			if (sAppVersion >= "5.5")
				g_bIE55 = true;
		}
		if (g_nMenuItem > 0) {
			g_bInitInProgress = true;
			select  (g_nDefaultItem, g_sDefaultTarget, g_sDefaultHelp,g_sDefaultApp);
			//DFCT101452 - When the text in any LSNB istem wraps, set font to 8pt
			for (i = 0; i &lt; g_nMenuItem; i++) {
				var anchor = document.getElementById("link_" + (i + 1));
				if (anchor.offsetHeight > 16) {
					g_bsmallfontreq = true;
					setsmallfont(g_nMenuItem);
					break;
				}
			}			
			g_bInitInProgress = false;
		}
	}
	
	//DFCT101452 - When the text in any LSNB istem wraps, set font to 8pt
	function setsmallfont(nMenuItem){
		for (i = 0; i &lt; g_nMenuItem; i++) {
			var anchor = document.getElementById("link_" + (i + 1));
			anchor.className = "lsnb-text";
		}
	}	
	function clearLock () {
		parent.ct.clearLock ();
		window.clearInterval (g_hClearLock);
	}
	function calculateDALatency () {
		if (parent.ct.g_bLoadInProgress == false) {
			var now = new Date ();
			parent.ct.g_nDataAreaLatency = now.getTime () - g_nDataAreaLoadStart;
			window.clearInterval (g_hCalculateLatency);
		}
	}
	function select (nItem, sTarget, sHelp, sApp) {
		if (parent.ct.g_bLoadInProgress == false || g_bInitInProgress == true) {
			parent.ct.setLock ();
			if (_performSelect (nItem) == true) {
			var vvid = top.gnv.getVID();
				if (parent.ct.g_bLSNBGoingBack == false) {
					var sTemp = sTarget;
					if (sTemp.indexOf ("?") != -1)
						sTemp += "&amp;";
					else
						sTemp += "?";
					if (g_bIE55 == false || 
					    (( typeof (parent.ct.g_sLastLink) != "undefined") &amp;&amp;
					     ( typeof (parent.snb.g_vMenuItemName) != "undefined") &amp;&amp;
					     ( typeof (parent.snb.g_nLastMenuItem) != "undefined")))
						sTemp = sTemp + "help=" + sHelp + "&amp;app=" + sApp + "&amp;ct=" + parent.ct.g_sLastLink + "&amp;snb=" + parent.snb.g_vMenuItemName[parent.snb.g_nLastMenuItem - 1] + "&amp;lsnb=" + g_vMenuItemName[nItem - 1] + "&amp;vid=" + vvid;

					if(navigator.appName == "Netscape") {
						g_nDataAreaLoadStart = (new Date ()).getTime ();
						parent.da.location.href = sTemp;
						g_hCalculateLatency = window.setInterval (calculateDALatency, 100);
						if (parent.ct.g_nDataAreaLatency > 0)
							g_hClearLock = window.setInterval (clearLock , parent.ct.g_nDataAreaLatency);
					}
					else {
						parent.da.location.href = sTemp;
					}
					
					try {
						if (sTemp.indexOf ("servlet/DataArea") == -1) {
							// [jj] A non-data area servlet call, so unlock the frameset.
							parent.ct.clearLock ();
						}
					}
					catch (e) {
					}
				}
				else {
					parent.ct.g_bLSNBGoingBack = false;
					_select (parent.ct.g_sLSNB);
					// Trigger the reload of the SNB frame.
					if (parent.ct.g_bSNBGoingBack == true) {
						parent.ct.history.back ();
					}
					else
						parent.ct.clearLock ();
				}
			}
		}
	}
	function _select (sSelectItem) {
		for (i = 0; i &lt;  g_vMenuItemName.length; i++) {
			if (g_vMenuItemName[i] == sSelectItem) {
				_performSelect (i + 1);
			}
		}
	}
	function _performSelect (nItem) {
		if (g_bIE55 == false || ( typeof (parent.ct.g_bModal) != "undefined") ) {
			if (parent.ct.g_bModal == false) {
				//DFCT101452 - When the text in any LSNB istem wraps, set font to 8pt
				if (g_bsmallfontreq == true){
					document.getElementById ("link_" + g_nLastItem).className = "lsnb-text";
					document.getElementById ("link_" + nItem).className = "lsnb-text lsnb-text-selection";
					document.getElementById ("data_" + g_nLastItem).className = "lsnb-text";
					document.getElementById ("data_" + nItem).className = "lsnb-text lsnb-text-selection";
				}
				else {
					document.getElementById ("link_" + g_nLastItem).className = "lsnb-text";
					document.getElementById ("link_" + nItem).className = "lsnb-text lsnb-text-selection";
					document.getElementById ("data_" + g_nLastItem).className = "lsnb-text";
					document.getElementById ("data_" + nItem).className = "lsnb-text lsnb-text-selection";
					
				}
				g_nLastItem= nItem;
				return true;
			}
		}
		return false;
	}
	</script>
	</head>
	<body class="lsnb" onLoad="javascript:init()">
	<div id="lsnb_menu">
		<div class="rightside"></div><div class="bottomright"></div><div class="bottomleft"></div>
		<table cellpadding="0" cellspacing="0" border="0">
		<tr>
			<td class="left-pad"><script language="javascript">document.write ('&amp;nbsp;');</script></td>
			<xsl:apply-templates />
		</tr>
		</table>
	</div>	
	</body>
	</html>
</xsl:template>

<xsl:template match="*">
	<script language="javascript">
	g_vMenuItemName[g_nMenuItem++] = '<xsl:value-of select="name()" />';
	if (g_sDefaultTarget == "") {
		g_sDefaultTarget = '<xsl:value-of select="@href"/>';
		g_sDefaultHelp = '<xsl:value-of select="@help"/>';
		g_sDefaultApp= '<xsl:value-of select="@app"/>';

	}
	if ('<xsl:value-of select="@default"/>' == 'true' || '<xsl:value-of select="name()"/>' == g_sDefaultItem) {
		g_nDefaultItem = g_nMenuItem;
		g_sDefaultTarget = '<xsl:value-of select="@href"/>';
		g_sDefaultHelp = '<xsl:value-of select="@help"/>';
		g_sDefaultApp= '<xsl:value-of select="@app"/>';

	}
	document.write ('&lt;td id="data_' + g_nMenuItem+ '" style=align="center" valign="middle" class="lsnb-text">');
	document.write ('&lt;a id="link_' + g_nMenuItem+ '" name="link_' + g_nMenuItem+ '" href="#" onclick="javascript:select(' + g_nMenuItem + ', \'<xsl:value-of select="@href" />\', \'<xsl:value-of select="@help" />\', \'<xsl:value-of select="@app"/>\')" class="lsnb-text">');
	</script >
	<xsl:choose>
		<xsl:when test="@display">
			<xsl:choose>
				<xsl:when test="@display='#'"></xsl:when>
				<xsl:otherwise><xsl:value-of select="@display" />&#160;</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise><xsl:value-of select="name()" />&#160;</xsl:otherwise>
	</xsl:choose>
	<script language="javascript">document.write ('&lt;/a>&lt;/td>');</script >
	<script language="javascript">document.write ('&lt;td class="lsnb-separator">|&lt;/td>');</script >
</xsl:template>

</xsl:stylesheet>
