<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" >
<xsl:output method="html" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" indent="yes"/>
<xsl:output method="html"/>
<xsl:template match="/OMA">
<html>
<head>
  <link href="/oma/css/common.css" rel="stylesheet" type="text/css" />
  <link href="/oma/css/button.css" rel="stylesheet" type="text/css" />
  <script language="javascript" src="/oma/js/prototype.js" type="text/javascript"></script>
  <script language="javascript" src="/oma/js/Clarity.js" type="text/javascript"></script>
  <script language="javascript">
    function unlockPage()
    {
    parent.ct.clearLock ();
    }

    <xsl:if test="Caller != '' ">
		
			function loadOrigPage()
			{
				document.location.href = '<xsl:value-of select="translate(Caller, ';', '&amp;amp;' )"/>' ;
			}
	
	</xsl:if>
	</script>
</head>
<body onload="javascript:unlockPage()">
  <center>
    <div class="table_container">
      <div class="container">
        <div class="c_container_top_right">
          <div class="c_container_top_left">
            <div class="c_container_gradient">
              <div class="alert_container_title">
                <xsl:value-of select="$strAlert"/>
              </div>
            </div>
          </div>
        </div>
        <div class="c_container_right">
          <div class="c_container_left">
            <div class="alert_container_content">
              <table>
                <tr>
                  <td class="critical"> </td>
                  <td class="alert_info">
                    <div class="crital_message">
                      <xsl:value-of select="$strTheActionPerformed"/>
                      <xsl:if test="Failure/@reason != ''">
                        <xsl:value-of select="$strBecause"/>
                      </xsl:if>
                      <xsl:value-of select="$str"/>
                    </div>
                    <xsl:if test="Failure/@reason != ''">
                      <xsl:call-template name="failure-reason" />
                      <xsl:value-of select="$str"/>
                    </xsl:if>  
                  </td>
                </tr>
              </table>
            </div>
          </div>
        </div>
        <div class="c_container_bottom_right">
          <div class="c_container_bottom_left">
            <div class="c_container_bottom"> </div>
          </div>
        </div>
      </div>
    </div>
    <div class="page_container">
          <table width="100" border="0" cellpadding="0" cellspacing="0">
            <tr>
              <td align="center" valign="middle">
                <xsl:choose>
                  <xsl:when test="Caller !=''">
                    <a class="page_button" href="javascript:loadOrigPage();">
                      <span>
                        <xsl:value-of select="$strBack"/>
                      </span>
                    </a>
                  </xsl:when>
                  <xsl:otherwise>
                    <a class="page_button" href="javascript:history.back();">
                      <span>
                        <xsl:value-of select="$strBack"/>
                      </span>
                    </a>
                  </xsl:otherwise>
                </xsl:choose>
              </td>
            </tr>
          </table>
        </div>
 </center>
</body>
</html>
</xsl:template>

<xsl:template name="failure-reason">
	<xsl:choose>
		<xsl:when test="Failure/@reason = 'UploadFileSizeExceedsLimit'"><xsl:value-of select="$strTheFileSize"/></xsl:when>
		<xsl:when test="Failure/@reason = 'NotEnoughSpaceForUpload'"><xsl:value-of select="$strNoSpaceForUpload"/></xsl:when>
	</xsl:choose>
</xsl:template>
<xsl:template match="*"/>
</xsl:stylesheet>
