<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" indent="no"/>
	<xsl:strip-space elements="*"/>

	<xsl:variable name="subCommandIndentSize">17</xsl:variable>

	<xsl:template match="/OMA">
		<xsl:call-template name="CLISubCommand">
			<xsl:with-param name="command"><xsl:value-of select="CLISubCommand"/></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="CLIMsgID">
			<xsl:with-param name="id"><xsl:value-of select="CLIMsgID"/></xsl:with-param>
			<xsl:with-param name="shownvpairs"><xsl:value-of select="CLIShowNVPairs"/></xsl:with-param>
			<xsl:with-param name="nametxt">
				<xsl:value-of select="CLIParseName"/>
			</xsl:with-param>
			<xsl:with-param name="paramtxt">
				<xsl:value-of select="CLIParamName"/>
			</xsl:with-param>
			<xsl:with-param name="parsetxt">
				<xsl:value-of select="CLIParseTxt"/>
			</xsl:with-param>
			<xsl:with-param name="parsetxt2">
				<xsl:value-of select="CLIParseTxt2"/>
			</xsl:with-param>
			<xsl:with-param name="hipstat">
				<xsl:value-of select="CustomStat"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="/shutdown">
		<xsl:call-template name="CLISubCommand">
			<xsl:with-param name="command">shutdown</xsl:with-param>
		</xsl:call-template>
		<!--XLATESTART-->Shutdown server.<!--XLATESTOP-->
		<xsl:call-template name="NewLine"/>
		<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
		<xsl:call-template name="NewLine"/>
	              <xsl:if test="HostControl/Capabilities/Reboot = 'true'">
				<xsl:text>action=reboot            </xsl:text><!--XLATESTART-->Shutdown, reboot the server.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
	              </xsl:if>
	              <xsl:if test="HostControl/Capabilities/PwrOff = 'true'">
				<xsl:text>action=poweroff          </xsl:text><!--XLATESTART-->Shutdown, poweroff the server.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
	              </xsl:if>
	              <xsl:if test="HostControl/Capabilities/PwrCycle = 'true'">
				<xsl:text>action=powercycle        </xsl:text><!--XLATESTART-->Shutdown and power cycle the server.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
	              </xsl:if>
	              <xsl:if test="HostControl/Capabilities/OSShutdown = 'true'">
				<xsl:text>osfirst=&lt;true|false&gt;     </xsl:text><!--XLATESTART-->On shutdown, shutdown the OS first. Default is true. On 13G and later systems, the parameter "osfirst=false" is deprecated. Even if you set "osfirst=false", the OS shuts down before the "action" is performed.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
	              </xsl:if>
	</xsl:template>

	<xsl:template match="/recovery">
	       <xsl:call-template name="CLISubCommand">
			<xsl:with-param name="command">recovery</xsl:with-param>
		</xsl:call-template>
				<!--XLATESTART-->Configure system recovery actions.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>action=none        </xsl:text><!--XLATESTART-->No recovery action.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:if test="WatchDog/Capabilities/Reboot = 'true'">
				    <xsl:text>action=reboot      </xsl:text><!--XLATESTART-->On recovery, reboot the server.<!--XLATESTOP-->
				    <xsl:call-template name="NewLine"/>
				</xsl:if>
				<xsl:if test="WatchDog/Capabilities/PwrOff = 'true'">
				    <xsl:text>action=poweroff    </xsl:text><!--XLATESTART-->On recovery, poweroff the server.<!--XLATESTOP-->
				    <xsl:call-template name="NewLine"/>
				</xsl:if>
				<xsl:if test="WatchDog/Capabilities/PwrCycle = 'true'">
				    <xsl:text>action=powercycle  </xsl:text><!--XLATESTART-->On recovery, power cycle the server.<!--XLATESTOP-->
				    <xsl:call-template name="NewLine"/>
				</xsl:if>
                   		<xsl:choose>
                               	<xsl:when test="WatchDog/TimerCapabilities = '1'">
				           <xsl:text>timer=&lt;number&gt;     </xsl:text><!--XLATESTART-->Set system reset timer (from 60 to 480 seconds).<!--XLATESTOP--><xsl:call-template name="NewLine"/>
                   		      </xsl:when>
                              	<xsl:when test="WatchDog/TimerCapabilities = '2'">
				           <xsl:text>timer=&lt;number&gt;     </xsl:text><!--XLATESTART-->Set system reset timer (60, 120 or 480 seconds).<!--XLATESTOP--><xsl:call-template name="NewLine"/>
                   		      </xsl:when>
                              	<xsl:when test="WatchDog/TimerCapabilities = '4'">
				           <xsl:text>timer=&lt;number&gt;     </xsl:text><!--XLATESTART-->Set system reset timer (multiple of 60 and &lt;= 480 seconds).<!--XLATESTOP--><xsl:call-template name="NewLine"/>
                   		      </xsl:when>
                               	<xsl:when test="WatchDog/TimerCapabilities = '8'">
				           <xsl:text>timer=&lt;number&gt;     </xsl:text><!--XLATESTART-->Set system reset timer (from 60 to 720 seconds).<!--XLATESTOP--><xsl:call-template name="NewLine"/>
                   		      </xsl:when>
                   		</xsl:choose>
	</xsl:template>



	<xsl:template match="/webserverusage">
		<xsl:call-template name="CLISubCommand">
			<xsl:with-param name="command">webserver</xsl:with-param>
		</xsl:call-template>
		<!--XLATESTART-->Start, stop or restart the DSM SA Connection Service.<!--XLATESTOP-->
		<xsl:call-template name="NewLine"/>
	</xsl:template>

	<xsl:template match="/webserverparams">
		<xsl:call-template name="CLISubCommand">
			<xsl:with-param name="command">webserver</xsl:with-param>
		</xsl:call-template>
		<!--XLATESTART-->Start, stop or restart the DSM SA Connection Service.<!--XLATESTOP-->
		<xsl:call-template name="NewLine"/>
		<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
		<xsl:call-template name="NewLine"/>
		<xsl:text>action=start           </xsl:text><!--XLATESTART-->Start the DSM SA Connection Service.<!--XLATESTOP-->
		<xsl:call-template name="NewLine"/>
		<xsl:text>action=stop            </xsl:text><!--XLATESTART-->Stop the DSM SA Connection Service.<!--XLATESTOP-->
		<xsl:call-template name="NewLine"/>
		<xsl:text>action=restart         </xsl:text><!--XLATESTART-->Restart the DSM SA Connection Service.<!--XLATESTOP-->
		<xsl:call-template name="NewLine"/>
	</xsl:template>

	<xsl:template name="CLIMsgID">
		<xsl:param name="id"/>
		<xsl:param name="shownvpairs"/>
		<xsl:param name="nametxt"/>
		<xsl:param name="paramtxt"/>
		<xsl:param name="parsetxt"/>
		<xsl:param name="parsetxt2"/>
		<xsl:param name="hipstat"/>
		<xsl:choose>
			<xsl:when test="$id = '1'">
				<!--XLATESTART-->Asset information.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '2'">
				<!--XLATESTART-->View alert log.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '3'">
				<!--XLATESTART-->View command log.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '4'">
				<!--XLATESTART-->View hardware (Embedded System Management) log.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '5'">
				<!--XLATESTART-->View Power On Self Test (POST) log.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '6'">
				<!--XLATESTART-->Auto recovery properties.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '7'">
				<!--XLATESTART-->Shutdown properties.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '8'">
				<!--XLATESTART-->Alert action(s) properties.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '9'">
				<!--XLATESTART-->Product and version properties.<!--XLATESTOP-->
				<xsl:if test="$shownvpairs = 'true'">
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>details=true     </xsl:text><!--XLATESTART-->Displays detailed about information.<!--XLATESTOP-->
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = '10'">
				<!--XLATESTART-->Summary of all system components.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '11'">
				<!--XLATESTART-->System component properties.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '12'">
				<!--XLATESTART-->Operating system properties.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '13'">
				<!--XLATESTART-->Thermal shutdown properties.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '14'">
				<!--XLATESTART-->Version report for all updateable components.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '15'">
				<!--XLATESTART-->View events enable/disable settings.<!--XLATESTOP-->
				<xsl:if test="$shownvpairs = 'true'">
					<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>

					<xsl:text>details=true     </xsl:text><!--XLATESTART-->Displays detailed about information.<!--XLATESTOP-->
				</xsl:if>
			</xsl:when>
			<xsl:when test="$id = '16'">
				<!--XLATESTART-->Platform event report.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '17'">
				<!--XLATESTART-->Platform event destinations.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '18'">
				<!--XLATESTART-->Server module component properties.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '19'">
				<!--XLATESTART-->System component properties.<!--XLATESTOP-->
				<xsl:call-template name="printSubcommandDeprecatedExt">
          			<xsl:with-param name="newCommand">servermodule</xsl:with-param>
          			<xsl:with-param name="standalone">false</xsl:with-param>
       			</xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = '21'">
				<!--XLATESTART-->SNMP traps are not available on this system due to operating system or hardware limitations. <!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '23'">
				<!--XLATESTART-->Displays the digital licenses of the installed hardware devices.<!--XLATESTOP-->
			</xsl:when>

			<xsl:when test="$id = '999'">
				<!--XLATETHIS-->For further help, type the command followed by -?<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1000'">
                     <xsl:call-template name="ConfigSuccess">
					<xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param>
					<xsl:with-param name="paramNam"><xsl:value-of select="$paramtxt"/></xsl:with-param>
					<xsl:with-param name="parseTxt"><xsl:value-of select="$parsetxt"/></xsl:with-param>
					<xsl:with-param name="parseTxt2"><xsl:value-of select="$parsetxt2"/></xsl:with-param>
			      </xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = '1001'">
				<!--XLATETHIS-->Error! Signed number expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
			</xsl:when>
            <xsl:when test="$id = '1002'">
                <!--XLATETHIS-->Error!. Unsigned, whole number expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
            </xsl:when>
            <xsl:when test="$id = '1003'">
                <!--XLATETHIS-->Error! true or false expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
            </xsl:when>
            <xsl:when test="$id = '1004'">
                <!--XLATETHIS-->Error! alphanumeric or symbol expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
            </xsl:when>
			<xsl:when test="$id = '1005'">
				<!--XLATETHIS-->Error! Required parameter missing: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/><xsl:text>=</xsl:text>
			      <xsl:call-template name="CLIParamFormat"><xsl:with-param name="format"><xsl:value-of select="$parsetxt2"/></xsl:with-param>
			      </xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = '1006'">
				<!--XLATETHIS-->Error! At least one optional parameter must be specified.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id = '1007'">
				<!--XLATETHIS-->Error! Command incomplete: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1008'">
			      <xsl:call-template name="CLIObjNotFound">
					<xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param>
     				<xsl:with-param name="paramNam"><xsl:value-of select="$paramtxt"/></xsl:with-param>
			      </xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = '1009'">
				<!--XLATETHIS-->Error! cannot load data accessor: <!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id = '1010'">
				<!--XLATETHIS-->Error! Index too large. Maximum index for this command is: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>

			<xsl:when test="$id = '1011'">
			      <xsl:call-template name="CLICommandFailed">
					<xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param>
     				<xsl:with-param name="paramNam"><xsl:value-of select="$paramtxt"/></xsl:with-param>
     				<xsl:with-param name="parseTxt"><xsl:value-of select="$parsetxt"/></xsl:with-param>
     				<xsl:with-param name="parseTxt2"><xsl:value-of select="$parsetxt2"/></xsl:with-param>
					<xsl:with-param name="stat"><xsl:value-of select="$hipstat"/></xsl:with-param>
				</xsl:call-template>
			</xsl:when>

			<xsl:when test="$id = '1012'">
				<!--XLATETHIS-->Error! Unrecognized command value: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1013'">
				<!--XLATESTART-->Error! Text too long: <!--XLATESTOP-->
				<xsl:value-of select="$parsetxt2"/>
				 <!--XLATESTART-->. Maximum number of characters is: <!--XLATESTOP-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1014'">
				<!--XLATETHIS-->Error! Value incorrect : <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/><xsl:text>=</xsl:text>
				<xsl:value-of select="$parsetxt2"/>
			</xsl:when>
			<xsl:when test="$id = '1015'">
				<!--XLATETHIS-->Error! Number expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1016'">
				<!--XLATETHIS-->Error! Date in form mmddyyyy expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text>
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1017'">
				<!--XLATETHIS-->Error! Percent (0-100) expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1018'">
				<!--XLATETHIS-->Error! Number with up to 1 digit after decimal point expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text>
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1019'">
				<!--XLATETHIS-->Error! Number with up to 2 digits after decimal point expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text>
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1020'">
				<!--XLATETHIS-->Error! Number with up to 3 digits after decimal point expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text>
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1021'">
				<!--XLATETHIS-->Error! Month is invalid: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1022'">
				<!--XLATETHIS-->Error! Day is invalid: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1023'">
				<!--XLATETHIS-->Error! Not a leap year: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1024'">
				<!--XLATETHIS-->Error! Alphanumeric expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1025'">
				<!--XLATETHIS-->Error! Unrecognized parameter: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1026'">
				<!--XLATETHIS-->Error! Cannot make date with this mmddyyyy on 32 bit operating system: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1027'">
				<!--XLATETHIS-->Error! Invalid IP Address, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
			</xsl:when>
      <!-- IPv6 validation errors Start-->
      <!-- Std RFC violation errors-->
      <xsl:when test="$id = '1107'">
        <!--XLATETHIS-->Error! Invalid IPv6 Address, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
      </xsl:when>
      <xsl:when test="$id = '1108'">
        <!--XLATETHIS-->Error! Empty IPv6 Address, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
      </xsl:when>
      <xsl:when test="$id = '1109'">
        <!--XLATETHIS-->Error! Failed processing IPv6 Address, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
      </xsl:when>
      <xsl:when test="$id = '1110'">
        <!--XLATETHIS-->Error! Invalid IPv4 or IPv6 Platform Event Destination Address, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
      </xsl:when>
      <!-- OMSA disallowed addresses-->
      <xsl:when test="$id = '1111'">
        <!--XLATETHIS-->Error! Non-permitted IPv6 NIC Address, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
      </xsl:when>
      <xsl:when test="$id = '1112'">
        <!--XLATETHIS-->Error! Non-permitted IPv6 Gateway Address, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
      </xsl:when>
      <xsl:when test="$id = '1113'">
        <!--XLATETHIS-->Error! Non-permitted IPv6 DNS Address, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
      </xsl:when>
      <xsl:when test="$id = '1114'">
        <!--XLATETHIS-->Error! Non-permitted IPv6 Platform Event Destination Address, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
      </xsl:when>
      <xsl:when test="$id = '1115'">
        <!--XLATETHIS-->Error! Loopback Address not permitted, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
      </xsl:when>
      <xsl:when test="$id = '1116'">
        <!--XLATETHIS-->Error! Non-permitted IPv6 Address, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
      </xsl:when>

      <!-- IPv6 validation errors End-->

      <xsl:when test="$id = '1028'">
				<!--XLATETHIS-->Error! Required parameter missing: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/><xsl:text>=</xsl:text>
				<xsl:value-of select="$parsetxt2"/>
			</xsl:when>
            <xsl:when test="$id = &apos;1029&apos;">
                <!--XLATETHIS-->Error! First char alpha folowed by alphanumeric expected, read: <!--XLATETHIS-->
                <xsl:value-of select="$parsetxt"/>
            </xsl:when>
			<xsl:when test="$id = '1030'">
				<!--XLATETHIS-->Error! Application name must contain at least one character.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id = '1033'">
			      <xsl:call-template name="CLIOneChar">
					<xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param>
     				<xsl:with-param name="paramNam"><xsl:value-of select="$paramtxt"/></xsl:with-param>
     				<xsl:with-param name="parseTxt"><xsl:value-of select="$parsetxt"/></xsl:with-param>
     				<xsl:with-param name="parseTxt2"><xsl:value-of select="$parsetxt2"/></xsl:with-param>
					<xsl:with-param name="stat"><xsl:value-of select="$hipstat"/></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = '1034'">
				<!--XLATETHIS-->Error! Year must be greater than or equal to 1970. Read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>

			<xsl:when test="$id = '1035'">
			      <xsl:call-template name="CLIPromptCanceled">
					<xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param>
     				<xsl:with-param name="paramNam"><xsl:value-of select="$paramtxt"/></xsl:with-param>
     				<xsl:with-param name="parseTxt"><xsl:value-of select="$parsetxt"/></xsl:with-param>
					<xsl:with-param name="stat"><xsl:value-of select="$hipstat"/></xsl:with-param>
				</xsl:call-template>
			</xsl:when>

			<xsl:when test="$id = '1036'">
			      <xsl:call-template name="CLIPromptInvalid">
					<xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param>
     				<xsl:with-param name="paramNam"><xsl:value-of select="$paramtxt"/></xsl:with-param>
     				<xsl:with-param name="parseTxt"><xsl:value-of select="$parsetxt"/></xsl:with-param>
					<xsl:with-param name="stat"><xsl:value-of select="$hipstat"/></xsl:with-param>
				</xsl:call-template>
			</xsl:when>

			<xsl:when test="$id = '1037'">
				<!--XLATETHIS-->Error! Whole numbers separated by colon(s) expected. Read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>

			<xsl:when test="$id = '1038'">
				<!--XLATETHIS-->Error! Whole numbers separated by colon range error. Max is: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>

			<xsl:when test="$id = '1039'">
				<!--XLATETHIS-->Error! Multiple values not unique:  <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>

			<xsl:when test="$id = '1040'">
				<!--XLATETHIS-->Error! Illegal combination of parameters.<!--XLATETHIS-->
			</xsl:when>

			<xsl:when test="$id = '1041'">
				<xsl:text>Error! Value of: (</xsl:text>
				<xsl:value-of select="$paramtxt"/>
				<xsl:text>) must be between: (</xsl:text>
				<xsl:value-of select="$parsetxt"/>
				<xsl:text>) and (</xsl:text>
				<xsl:value-of select="$parsetxt2"/>
				<xsl:text>)</xsl:text>
			</xsl:when>

			<xsl:when test="$id = '1042'">
				<xsl:text>Error! Value of: (</xsl:text>
				<xsl:value-of select="$paramtxt"/>
				<xsl:text>) must be between: (</xsl:text>
				<xsl:value-of select="$parsetxt"/>
				<xsl:text>) and (</xsl:text>
				<xsl:value-of select="$parsetxt2"/>
				<xsl:text>)</xsl:text>
			</xsl:when>

			<xsl:when test="$id = '1043'">
				<!--XLATETHIS-->Error! Invalid IP Subnet, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
			</xsl:when>

			<xsl:when test="$id = '1044'">
				<!--XLATETHIS-->Error! IP Subnet set bits must be contiguous, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text>
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>

			<xsl:when test="$id = '1045'">
				<!--XLATETHIS-->Error! Index too small. Minimum index for this command is: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1046'">
				<!--XLATETHIS-->Error! Whole numbers separated by two colon(s) expected. Read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1047'">
			    	<!--XLATETHIS-->Error!<!--XLATETHIS-->
				<xsl:if test='contains($parsetxt, "amdef1")'><!--XLATESTART--> Whole numbers<!--XLATESTOP--></xsl:if>
				<xsl:if test='substring-after($parsetxt, "amdef1+")'><!--XLATESTART--> or<!--XLATESTOP--></xsl:if>
				<xsl:if test='contains($parsetxt, "amdef2")'><!--XLATESTART--> whole numbers separated by 1 colon<!--XLATESTOP--></xsl:if>
				<xsl:if test='substring-after($parsetxt, "amdef2+")'><!--XLATESTART--> or<!--XLATESTOP--></xsl:if>
				<xsl:if test='contains($parsetxt, "amdef3")'><!--XLATESTART--> whole numbers separated by 2 colons<!--XLATESTOP--></xsl:if>
			    	<!--XLATETHIS--> expected.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id = '1049'">
				<!--XLATETHIS-->Error! Whole numbers separated by same number of colon(s) expected.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id = '1050'">
			      <xsl:call-template name="CLIPromptText">
					<xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param>
     				<xsl:with-param name="paramNam"><xsl:value-of select="$paramtxt"/></xsl:with-param>
     				<xsl:with-param name="parseTxt"><xsl:value-of select="$parsetxt"/></xsl:with-param>
					<xsl:with-param name="stat"><xsl:value-of select="$hipstat"/></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = '1053'">
				<!--XLATETHIS-->Error! Unsigned number too large. Maximum value is: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>

			<xsl:when test="$id = '1101'">
				<!--XLATETHIS-->Error! Signed number or "default" expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1102'">
				<!--XLATETHIS-->Error! unsigned number or "default" expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1103'">
				<!--XLATETHIS-->Error! true or false or "default" expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1104'">
				<!--XLATETHIS-->Error! alphanumeric or symbol or "default" expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
		    <xsl:when test="$id = '1105'">
			<!--XLATETHIS-->Error! positive number expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1106'">
				<!--XLATETHIS-->Error! Only administrator can execute alert action applications.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id = '1200'">
				<!--XLATESTART-->Error! this current probe warning threshold must be between <!--XLATESTOP-->
				<xsl:value-of select="$parsetxt"/> and <xsl:value-of select="$parsetxt2"/>
			</xsl:when>
			<xsl:when test="$id = '1201'">
				<!--XLATESTART-->Error! This fan probe warning threshold must be between <!--XLATESTOP-->
				<xsl:value-of select="$parsetxt"/> and <xsl:value-of select="$parsetxt2"/>
			</xsl:when>
			<xsl:when test="$id = '1202'">
				<!--XLATESTART-->Error! This temperature probe warning threshold must be between <!--XLATESTOP-->
<xsl:call-template name="prnTemp"><xsl:with-param name="temp"><xsl:value-of select="$parsetxt"/></xsl:with-param></xsl:call-template> and <xsl:call-template name="prnTemp"><xsl:with-param name="temp"><xsl:value-of select="$parsetxt2"/></xsl:with-param></xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = '1203'">
				<!--XLATESTART-->Error! This voltage probe warning threshold must be between <!--XLATESTOP-->
<xsl:call-template name="prnVolt"><xsl:with-param name="volt"><xsl:value-of select="$parsetxt"/></xsl:with-param></xsl:call-template> and <xsl:call-template name="prnVolt"><xsl:with-param name="volt"><xsl:value-of select="$parsetxt2"/></xsl:with-param></xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = '1301'">
				<!--XLATESTART-->Error! Recovery reset time must be between <!--XLATESTOP-->
				<xsl:value-of select="$parsetxt"/> and <xsl:value-of select="$parsetxt2"/><!--XLATESTART--> seconds.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '1302'">
				<!--XLATESTART-->Error! Recovery reset time must be 60, 120 or 480 seconds.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '1303'">
				<!--XLATESTART-->Error! Recovery reset time must be a multiple of 60 and &lt;= 480 seconds<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '1304'">
				<!--XLATESTART-->Error! SNMP new root password must match confirm password.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '1305'">
				<!--XLATESTART-->Error! Reboot unsupported on this system.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '1306'">
				<!--XLATESTART-->Error! Power Off unsupported on this system.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '1307'">
				<!--XLATESTART-->Error! Power Cycle unsupported on this system.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '1308'">
				<!--XLATESTART-->Error! Platform event action cannot be set for <!--XLATESTOP-->
				<xsl:value-of select="$paramtxt"/><!--XLATESTART-->.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '1309'">
				<!--XLATESTART-->Error! Index must be greater than 0.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '1311'">
				<!--XLATESTART-->Error! Power Reduction unsupported on this system.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '1312'">
				<!--XLATESTART-->Error! You cannot configure the System Recovery timer, if action is set to None.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '1313'">
				<!--XLATESTART-->Error! Purchase Date must be less than or equal to Current Date.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '1314'">
				<!--XLATESTART-->Error! Install Date must be greater than or equal to Purchase Date.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '1900'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">system</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set system properties.<!--XLATESTOP-->
			</xsl:when>
				<xsl:when test="$id = '1901'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">system</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set system properties.<!--XLATESTOP-->
				<xsl:call-template name="printSubcommandDeprecatedExt">
          			<xsl:with-param name="newCommand">servermodule</xsl:with-param>
          			<xsl:with-param name="standalone">false</xsl:with-param>
     			</xsl:call-template>
			</xsl:when>
      <xsl:when test="$id = '1902'">
        <xsl:call-template name="CLISubCommand">
          <xsl:with-param name="command">servermodule</xsl:with-param>
        </xsl:call-template>
        <!--XLATESTART-->Set ServerModule properties.<!--XLATESTOP-->
      </xsl:when>
			<xsl:when test="$id = '2001'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">assetinfo</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set asset information.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '2002'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">assetinfo</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set asset information.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
     			      <!--XLATESTART-->For one info value, specify one or more optional parameter(s):<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>info=acquisition   purchasecost=&lt;num&gt;  waybill=&lt;num&gt;  installdate=&lt;mmddyyyy or mmddyy&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>                   purchasedate=&lt;mmddyyyy or mmddyy&gt;  ponum=&lt;num&gt;  signauth=&lt;text&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>                   expensed=&lt;yes|no&gt;  costcenter=&lt;text&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>info=depreciation  method=&lt;text&gt;  duration=&lt;num&gt;  percent=&lt;percent&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>                   unit=&lt;months|years&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>info=warranty      duration=&lt;num&gt;  unit=&lt;days|months&gt;  enddate=&lt;mmddyyyy or mmddyy&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>                   cost=&lt;num&gt; </xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>info=extwarranty   startdate=&lt;mmddyyyy or mmddyy&gt;  enddate=&lt;mmddyyyy or mmddyy&gt;  cost=&lt;num&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>                   provider=&lt;text&gt; </xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>info=lease         multischedule=&lt;true|false&gt;  buyout=&lt;num&gt;  enddate=&lt;mmddyyyy or mmddyy&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>                   ratefactor=&lt;num&gt;  value=&lt;num&gt;  lessor=&lt;text&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>info=maintenance   startdate=&lt;mmddyyyy or mmddyy&gt;  enddate=&lt;mmddyyyy or mmddyy&gt;  provider=&lt;text&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>                   restrictions=&lt;text&gt; </xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>info=outsource     problemcomponent=&lt;text&gt;  servicefee=&lt;text&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>                   signauth=&lt;text&gt;  providerfee=&lt;text&gt;  levels=&lt;text&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>info=support       outsourced=&lt;true|false&gt;  type=&lt;network|storage&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>                   helpdesk=&lt;text&gt;  automaticfix=&lt;text&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
                          <xsl:text>info=service       renewed=&lt;true|false&gt;  type=&lt;text&gt;  vendor=&lt;text&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>info=system        location=&lt;text&gt;  primaryuser=&lt;text&gt;  primaryphone=&lt;text&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>info=owner         type=&lt;owned|leased|rented|offlease|transfer&gt;</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>                   ownername=&lt;text&gt;  insuranceco=&lt;text&gt;</xsl:text>
			</xsl:when>
			<xsl:when test="$id = '2011'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">esmlog</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Clear Embedded System Management (ESM) log.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '2012'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">esmlog</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Clear Embedded System Management (ESM) log.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>action=clear           </xsl:text><!--XLATESTART-->Clear the contents of the ESM log.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '2021'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">alertlog</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Clear alert log.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '2022'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">alertlog</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Clear alert log.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>action=clear           </xsl:text><!--XLATESTART-->Clear the contents of the Alert log.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '2031'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">cmdlog</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Clear command log.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '2032'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">cmdlog</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Clear command log.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>action=clear           </xsl:text><!--XLATESTART-->Clear the contents of the command log.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '2041'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">alertaction</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Configure alert actions.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '2042'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">alertaction</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Configure alert actions.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				 <!--XLATESTART-->Valid parameters are one of:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=powersupply         </xsl:text><!--XLATESTART-->Set power supply failure action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=powersupplywarn     </xsl:text><!--XLATESTART-->Set power supply warning action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=tempwarn            </xsl:text><!--XLATESTART-->Set temperature warning action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=tempfail            </xsl:text><!--XLATESTART-->Set temperature failure action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=fanwarn             </xsl:text><!--XLATESTART-->Set fan speed warning action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=fanfail             </xsl:text><!--XLATESTART-->Set fan speed failure action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=voltwarn            </xsl:text><!--XLATESTART-->Set voltage warning action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=voltfail            </xsl:text><!--XLATESTART-->Set voltage failure action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=intrusion           </xsl:text><!--XLATESTART-->Set chassis intrusion action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=redundegrad         </xsl:text><!--XLATESTART-->Set redundancy degraded action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=redunlost           </xsl:text><!--XLATESTART-->Set redundancy lost action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=memprefail          </xsl:text><!--XLATESTART-->Set memory pre-failure action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=memfail             </xsl:text><!--XLATESTART-->Set memory failure action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=hardwarelogwarn     </xsl:text><!--XLATESTART-->Set hardware log warning action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=hardwarelogfull     </xsl:text><!--XLATESTART-->Set hardware log full action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=processorwarn       </xsl:text><!--XLATESTART-->Set processor warning action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=processorfail       </xsl:text><!--XLATESTART-->Set processor failure action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=watchdogasr         </xsl:text><!--XLATESTART-->Set watchdog asr action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=batterywarn         </xsl:text><!--XLATESTART-->Set battery warning action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=batteryfail         </xsl:text><!--XLATESTART-->Set battery failure action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				 <xsl:text>event=systempowerwarn     </xsl:text><!--XLATESTART-->Set system power warning action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=systempowerfail     </xsl:text><!--XLATESTART-->Set system power failure action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=systempeakpower     </xsl:text><!--XLATESTART-->Set system peak power action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=removableflashmediapresent       </xsl:text><!--XLATESTART-->Set removable flash media present action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=removableflashmediaremoved       </xsl:text><!--XLATESTART-->Set removable flash media removed action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=removableflashmediafail	  </xsl:text><!--XLATESTART-->Set removable flash media failure action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="StorageLRAHelp"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->For one event, either specify clearall or other action(s):<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>alert=&lt;true|false&gt;        </xsl:text><!--XLATESTART-->Enable / disable console alert.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>broadcast=&lt;true|false&gt;    </xsl:text><!--XLATESTART-->Enable / disable broadcast message.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>clearall=&lt;true&gt;           </xsl:text><!--XLATESTART-->Clear all actions for this event.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>execappath=&lt;string&gt;       </xsl:text><!--XLATESTART-->Set absolute path for executable application.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>execapp=&lt;false&gt;           </xsl:text><!--XLATESTART-->Disable executable application.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '2051'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">recovery</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Configure system recovery actions.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '2052'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">recovery</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Configure system recovery actions.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>action=none           </xsl:text><!--XLATESTART-->No recovery action.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:if test="$paramtxt = 'true'">
				    <xsl:text>action=reboot         </xsl:text><!--XLATESTART-->On recovery, reboot the server.<!--XLATESTOP-->
				    <xsl:call-template name="NewLine"/>
				</xsl:if>
				<xsl:if test="$parsetxt = 'true'">
				    <xsl:text>action=poweroff       </xsl:text><!--XLATESTART-->On recovery, poweroff the server.<!--XLATESTOP-->
				    <xsl:call-template name="NewLine"/>
				</xsl:if>
				<xsl:if test="$parsetxt2 = 'true'">
				    <xsl:text>action=powercycle     </xsl:text><!--XLATESTART-->On recovery, power cycle the server.<!--XLATESTOP-->
				    <xsl:call-template name="NewLine"/>
				</xsl:if>
				<xsl:text>timer=&lt;number&gt;        </xsl:text><!--XLATESTART-->Set system reset timer (seconds).<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '2061'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">shutdown</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Shutdown server.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '2062'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">shutdown</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Shutdown server.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>action=reboot            </xsl:text><!--XLATESTART-->Shutdown, reboot the server.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>action=poweroff          </xsl:text><!--XLATESTART-->Shutdown, poweroff the server.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>action=powercycle        </xsl:text><!--XLATESTART-->Shutdown and power cycle the server.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>osfirst=&lt;true|false&gt;     </xsl:text><!--XLATESTART-->On shutdown, shutdown the OS first. Default is true.<!--XLATESTOP-->
			</xsl:when>
                    <xsl:when test="$id = '2071'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">thrmshutdown</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set thermal shutdown severity level.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '2072'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">thrmshutdown</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set thermal shutdown severity level.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>severity=&lt;disabled|warning|failure&gt;</xsl:text>
			</xsl:when>

			 <xsl:when test="$id = '2091'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">snmp</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set SNMP preferences.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '2092'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">snmp</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set SNMP preferences.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->setting=snmpset		    Configure SNMP set operations<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->enable=&lt;true|false&gt;	    Enable/disable SNMP set operations<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->setting=rootpw              Set SNMP root password<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Omitting the parameters below will cause prompted input:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->oldpw=&lt;oldpassword&gt;         Old SNMP root password.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->newpw=&lt;newpassword&gt;         New SNMP root password.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->confirmnewpw=&lt;newpassword&gt;  Confirm new SNMP password.<!--XLATESTOP-->
			</xsl:when>

			 <xsl:when test="$id = '2101'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">events</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Events enable or disable.<!--XLATESTOP-->
			</xsl:when>

			<xsl:when test="$id = '2110'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">preferences</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set system preferences.<!--XLATESTOP-->
			</xsl:when>

			<xsl:when test="$id = '2182'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">preferences</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Report system preferences.<!--XLATESTOP-->
			</xsl:when>

			 <xsl:when test="$id = '2120'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">useraccess</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set user access rights.<!--XLATESTOP-->

			</xsl:when>

			<xsl:when test="$id = '2121'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">useraccess</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set user access rights.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>enable=user             Enable user, power user, administrator access.</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>enable=poweruser        Enable power user, administrator access.</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>enable=admin            Enable administrator access only.</xsl:text>

			</xsl:when>

			 <xsl:when test="$id = '2130'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">cdvformat</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set custom delimiter format value.<!--XLATESTOP-->
			</xsl:when>

			<xsl:when test="$id = '2131'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">cdvformat</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set custom delimiter format values.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->delimiter=&lt;exclamation|semicolon|at|hash|dollar|caret|asterisk|tilde|question|comma|pipe&gt;<!--XLATESTOP-->
			</xsl:when>

			<xsl:when test="$id = '2140'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">platformevents</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Configure platform events.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '2141'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">platformevents</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Configure platform events.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				 <!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>alertsenable=&lt;true|false&gt; </xsl:text><!--XLATESTART-->Set platform event filter alerts enable.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->For one event, specify an action and or an alert value:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=fanfail            </xsl:text><!--XLATESTART-->Set fan failure action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=voltfail           </xsl:text><!--XLATESTART-->Set analog voltage probe failure action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=discretevolt       </xsl:text><!--XLATESTART-->Set discrete voltage probe failure action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=tempwarn           </xsl:text><!--XLATESTART-->Set temperature probe warning action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=tempfail           </xsl:text><!--XLATESTART-->Set temperature probe failure action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=intrusion          </xsl:text><!--XLATESTART-->Set chassis intrusion action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=redundegrad        </xsl:text><!--XLATESTART-->Set redundancy degraded action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=redunlost          </xsl:text><!--XLATESTART-->Set redundancy lost action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=processorwarn      </xsl:text><!--XLATESTART-->Set processor warning actions(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=processorfail      </xsl:text><!--XLATESTART-->Set processor failure actions(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=powerwarn          </xsl:text><!--XLATESTART-->Set power device warning action(s)<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=powerfail          </xsl:text><!--XLATESTART-->Set power device failure action(s)<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=hardwarelogfail    </xsl:text><!--XLATESTART-->Set hardware log failure action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=watchdogasr        </xsl:text><!--XLATESTART-->Set automatic system recovery alert enable/disable.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=batterywarn        </xsl:text><!--XLATESTART-->Set battery warning action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=batteryfail        </xsl:text><!--XLATESTART-->Set battery failure action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=processorabsent    </xsl:text><!--XLATESTART-->Set processor absent action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=powerabsent        </xsl:text><!--XLATESTART-->Set power supply absent action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=systempowerwarn    </xsl:text><!--XLATESTART-->Set system power probe warning action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=systempowerfail    </xsl:text><!--XLATESTART-->Set system power probe failure action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=removableflashmediafail   </xsl:text><!--XLATESTART-->Set removable flash media failure action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=removableflashmediapresent</xsl:text><!--XLATESTART-->Set removable flash media present action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=removableflashmediawarn  </xsl:text><!--XLATESTART-->Set removable flash media warning action(s).<!--XLATESTOP-->				
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=intdualsdcardcritical  </xsl:text><!--XLATESTART-->Set internal dual SD module card critical action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=intdualsdcardwarn      </xsl:text><!--XLATESTART-->Set internal dual SD module card warning action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=intdualsdcardabsent    </xsl:text><!--XLATESTART-->Set internal dual SD module card absent critical action(s).<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>event=intdualsdcardredunlost </xsl:text><!--XLATESTART-->Set internal dual SD module card redundancy lost action(s).<!--XLATESTOP-->			
				
				<xsl:call-template name="NewLine"/>
				<xsl:text>action=reboot            </xsl:text><!--XLATESTART-->Force server reboot.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>action=poweroff          </xsl:text><!--XLATESTART-->Force server poweroff.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>action=powercycle        </xsl:text><!--XLATESTART-->Force server powercycle.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
        			<xsl:text>action=powerreduction    </xsl:text><!--XLATESTART-->Force server power reduction.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>action=none              </xsl:text><!--XLATESTART-->No shutdown action.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>alert=enable             </xsl:text><!--XLATESTART-->Enable platform event SNMP alert.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>alert=disable            </xsl:text><!--XLATESTART-->Disable platform event SNMP alert.<!--XLATESTOP-->
			</xsl:when>

			<xsl:when test="$id = '2150'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">pedestinations</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Configure platform event destinations.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '2151' or $id = '2152' or $id = '2153' ">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">pedestinations</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Configure platform event destinations.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				 <!--XLATESTART-->Valid parameters are either:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>index=&lt;number&gt;           </xsl:text><!--XLATESTART-->Destination index<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				
				<xsl:text>destenable=&lt;true|false&gt;  </xsl:text><!--XLATESTART-->Enable alert destination<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:choose>
				<xsl:when  test="$id = '2153'">
				<xsl:text>ipaddress=&lt;ipv4|ipv6 address|fqdn&gt;   </xsl:text><!--XLATESTART-->Destination IP Address.<!--XLATESTOP-->
				</xsl:when> 
				<xsl:otherwise>
				<xsl:text>ipaddress=&lt;ipv4|ipv6 address&gt;   </xsl:text><!--XLATESTART-->Destination IP Address.<!--XLATESTOP-->
				</xsl:otherwise>
				</xsl:choose>
				<xsl:call-template name="NewLine"/>
				 <!--XLATESTART-->or:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>communitystr=&lt;text&gt;      </xsl:text><!--XLATESTART-->Community string.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:if test="$id = '2152'">
				<xsl:call-template name="NewLine"/>
				<xsl:text>Note:Modifying trap destinations using this command overrides the trap destinations configured in iDRAC.</xsl:text>
				</xsl:if >

			</xsl:when>
		
			<xsl:when test="$id = '2164'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">update</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Initiates a system update.<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$id = '2165'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">update</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Initiates a system update.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<xsl:text>updateid=update task id</xsl:text>
			</xsl:when>
          	      <xsl:when test="$id = '2160'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">dirservice</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set directory service configuration. (This command applies to windows only)<!--XLATESTOP-->

			</xsl:when>

			<xsl:when test="$id = '2161'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">dirservice</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set directory service configuration.(windows only)<!--XLATESTOP-->
                    	<!--XLATESTART--> The &lt;product&gt;oem.ini file is modified to reflect these configuration changes.(This command applies to only windows)<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
                        <xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
                        <xsl:call-template name="NewLine"/>
                        <xsl:text>prodname=&lt;text&gt;        The product in which to apply the change.(ie. omsa)</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>enable=&lt;true|false&gt;    Enable/Disable directory service authentication support.</xsl:text>
				<xsl:call-template name="NewLine"/>
				<xsl:text>adprodname=&lt;text&gt;      The name of this product as it is defined in the directory service. This name links the product with the active directory privilege data for user authentication.</xsl:text>
			</xsl:when>

			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>
		<xsl:call-template name="NewLine"/>
	</xsl:template>
	<xsl:template name="CLIParamFormat">
		<xsl:param name="format"/>
		<xsl:choose>
			<xsl:when test="$format = '1'">
			     <xsl:text>text</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '2'">
			     <xsl:text>text</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '3'">
			     <xsl:text>text (alphanumeric only)</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '4'">
			     <xsl:text>number</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '5'">
			     <xsl:text>&lt;true|false&gt;</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '6'">
			     <xsl:text>number</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '7'">
			     <xsl:text>number</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '8'">
			     <xsl:text>d.d</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '9'">
			     <xsl:text>number</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '10'">
			     <xsl:text>date</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '19'">
			     <xsl:text>percent (0-100)</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<!--XLATESTART-->value<!--XLATESTOP-->
                    </xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="/ConfigEvents">
		<xsl:call-template name="CLISubCommand">
			<xsl:with-param name="command">events</xsl:with-param>
		</xsl:call-template>
		<!--XLATESTART-->Events enable or disable.<!--XLATESTOP-->
		<xsl:call-template name="NewLine"/>
		<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
		<xsl:call-template name="NewLine"/>
			<xsl:text>type=&lt;all&gt;              Events for all types.</xsl:text>
			<xsl:call-template name="NewLine"/>
			<xsl:text>index=&lt;number&gt;          Single event index (requires specific event type).</xsl:text>
			<xsl:call-template name="NewLine"/>
			<xsl:for-each select="Events/ObjType">
				<xsl:choose>
					<xsl:when test="@type = '21'">
						<xsl:text>type=&lt;powersupplies&gt;    Events for power supplies.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '2'">
						<xsl:text>type=&lt;redundancy&gt;       Events for components with redundancy.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '22'">
						<xsl:text>type=&lt;temps&gt;            Events for temperature probes.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '23'">
						<xsl:text>type=&lt;fans&gt;             Events for fan probes.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '24'">
						<xsl:text>type=&lt;volts&gt;            Events for voltage probes.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '25'">
						<xsl:text>type=&lt;systempower&gt;      Events for system power probes.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '31'">
						<xsl:text>type=&lt;log&gt;              Events for logs.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '35'">
						<xsl:text>type=&lt;fanenclosures&gt;    Events for fan enclosures.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '37'">
						<xsl:text>type=&lt;accords&gt;          Events for AC power cords.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '225'">
						<xsl:text>type=&lt;memory&gt;           Events for memory.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '28'">
						<xsl:text>type=&lt;intrusion&gt;        Events for chassis intrusion.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '27'">
						<xsl:text>type=&lt;battery&gt;          Events for battery.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '40'">
						<xsl:text>type=&lt;systempeakpower&gt;  Events for system peak power.</xsl:text>
						<xsl:call-template name="NewLine"/>
						<xsl:text>Note: systempeakpower does not support the warning and critical severity.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '52'">
						<xsl:text>type=&lt;removableflashmedia&gt;   Events for removable flash media. </xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
			</xsl:choose>
		</xsl:for-each>
		<xsl:text>severity=&lt;info&gt;         Enable informational, warning and critical events.</xsl:text>
		<xsl:call-template name="NewLine"/>
		<xsl:text>severity=&lt;warning&gt;      Enable warning and critical events.</xsl:text>
		<xsl:call-template name="NewLine"/>
		<xsl:text>severity=&lt;critical&gt;     Enable critical events.</xsl:text>
		<xsl:call-template name="NewLine"/>
		<xsl:text>severity=&lt;none&gt;         Enable no events.</xsl:text>
		<xsl:call-template name="NewLine"/>
		<xsl:text>source=&lt;snmptraps&gt;      Event source is SNMP traps.</xsl:text>
		<xsl:call-template name="NewLine"/>
	</xsl:template>


	<xsl:template match="/ReportEvents">
		<xsl:call-template name="CLISubCommand">
			<xsl:with-param name="command">events</xsl:with-param>
		</xsl:call-template>
		<!--XLATESTART-->Events enable or disable.<!--XLATESTOP-->
		<xsl:call-template name="NewLine"/>
		<!--XLATESTART-->Specify type to report detailed event information:<!--XLATESTOP-->
		<xsl:call-template name="NewLine"/>
			<xsl:for-each select="Events/ObjType">
				<xsl:choose>
					<xsl:when test="@type = '21'">
						<xsl:text>type=&lt;powersupplies&gt;    Events for power supplies.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '2'">
						<xsl:text>type=&lt;redundancy&gt;       Events for components with redundancy.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '22'">
						<xsl:text>type=&lt;temps&gt;            Events for temperature probes.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '23'">
						<xsl:text>type=&lt;fans&gt;             Events for fan probes.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '24'">
						<xsl:text>type=&lt;volts&gt;            Events for voltage probes.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '25'">
						<xsl:text>type=&lt;systempower&gt;      Events for system power probes.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '31'">
						<xsl:text>type=&lt;log&gt;              Events for logs.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '35'">
						<xsl:text>type=&lt;fanenclosures&gt;    Events for fan enclosures.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '37'">
						<xsl:text>type=&lt;accords&gt;          Events for AC power cords.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '225'">
						<xsl:text>type=&lt;memory&gt;           Events for memory.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '28'">
						<xsl:text>type=&lt;intrusion&gt;        Events for chassis intrusion.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '27'">
						<xsl:text>type=&lt;battery&gt;          Events for battery.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '40'">
						<xsl:text>type=&lt;systempeakpower&gt;  Events for system peak power.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:when test="@type = '52'">
						<xsl:text>type=&lt;removableflashmedia&gt;   Events for removable flash media.</xsl:text>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>


	<xsl:template name="CLIObjNotFound">
		<xsl:param name="subCom"/>
		<xsl:param name="paramNam"/>
		<xsl:choose>
			<xsl:when test="$subCom = 'esmlog'">
			     <xsl:text>Error! Embedded System Management(ESM) log not found..</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'postlog'">
			     <xsl:text>Error! Power On Self Test (POST log not found..</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'alertlog'">
			     <xsl:text>Error! Alert log not found.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'events'">
			     <xsl:text>Error! Event type</xsl:text><xsl:value-of select="$paramNam"/><xsl:text> not found on this system.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'platformevents'">
			     <xsl:text>Error! Platform events are not supported on this system.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'pedestinations'">
			     <xsl:text>Error! Platform event destinations are not supported on this system.</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<!--XLATESTART-->Error! Hardware or feature not present.<!--XLATESTOP-->
                    </xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="ConfigSuccess">
		<xsl:param name="subCom"/>
		<xsl:param name="paramNam"/>
		<xsl:param name="parseTxt"/>
		<xsl:param name="parseTxt2"/>
		<xsl:choose>
			<xsl:when test="$subCom = 'alertaction'">
			     <xsl:text>Alert action(s) configured successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'alertlog'">
				 <xsl:text>Alert log cleared successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'assetinfo'">
				<xsl:text>Asset information set successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'cmdlog'">
				<xsl:text>Command log cleared successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'esmlog'">
			     <xsl:text>Embedded System Management (ESM) log cleared successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'recovery'">
			     <xsl:text>System recovery actions configured successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'shutdown'">
			     <xsl:text>System shutdown in progress.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'thrmshutdown'">
			     <xsl:text>Thermal shutdown severity level configured successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'webserver'">
			<xsl:choose>
            		<xsl:when test="$paramNam = 'start'">
			     	<xsl:text>DSM SA Connection Service started successfully.</xsl:text>
				</xsl:when>
            		<xsl:when test="$paramNam = 'stop'">
			     	<xsl:text>DSM SA Connection Service stopped successfully.</xsl:text>
				</xsl:when>
				<xsl:when test="$paramNam = 'restart'">
			     	<xsl:text>DSM SA Connection Service restarted successfully.</xsl:text>
				</xsl:when>
				<xsl:otherwise>
			     	<xsl:text>DSM SA Connection Service error.</xsl:text>
				</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$subCom = 'snmp'">
			<xsl:choose>
            		<xsl:when test="$paramNam = 'rootpw'">
			     	<xsl:text>SNMP root password set successfully.</xsl:text>
				</xsl:when>
				<xsl:otherwise>
			     	<xsl:text>SNMP preference set successfully.</xsl:text>
				</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$subCom = 'useraccess'">
			     <xsl:text>User access rights set successfully.</xsl:text>
			</xsl:when>

			<xsl:when test="$subCom = 'cdvformat'">
			     <xsl:text>CDV format delimiter set successfully.</xsl:text>
			</xsl:when>

			<xsl:when test="$subCom = 'useraccess'">
			     <xsl:text>User access rights set successfully.</xsl:text>
			</xsl:when>

                  <xsl:when test="$subCom = 'dirservice'">
			     <xsl:text>Directory service configuration set successfully.</xsl:text>
			</xsl:when>

			<xsl:when test="$subCom = 'events'">
				<xsl:choose>
	               	<xsl:when test="$parseTxt2='bytype'">
						<xsl:choose>
			            		<xsl:when test="$paramNam = 'all'">
						     	<xsl:text>Events configured successfully.</xsl:text>
							</xsl:when>
			            		<xsl:when test="$paramNam = 'powersupplies'">
						     	<xsl:text>Power supply events configured successfully.</xsl:text>
							</xsl:when>
			            		<xsl:when test="$paramNam = 'redundancy'">
						     	<xsl:text>Redundancy events configured successfully.</xsl:text>
							</xsl:when>
			            		<xsl:when test="$paramNam = 'temps'">
						     	<xsl:text>Temperature probe events configured successfully.</xsl:text>
							</xsl:when>
			            		<xsl:when test="$paramNam = 'fans'">
						     	<xsl:text>Fan probe events configured successfully.</xsl:text>
							</xsl:when>
			            		<xsl:when test="$paramNam = 'volts'">
						     	<xsl:text>Voltage probe events configured successfully.</xsl:text>
							</xsl:when>
			            		<xsl:when test="$paramNam = 'currents'">
						     	<xsl:text>Current probe events configured successfully.</xsl:text>
							</xsl:when>
			            		<xsl:when test="$paramNam = 'log'">
						     	<xsl:text>Log events configured successfully.</xsl:text>
							</xsl:when>
			            		<xsl:when test="$paramNam = 'fanenclosures'">
						     	<xsl:text>Fan enclosure events configured successfully.</xsl:text>
							</xsl:when>
			            		<xsl:when test="$paramNam = 'accords'">
						     	<xsl:text>AC Cord events configured successfully.</xsl:text>
							</xsl:when>
			            		<xsl:when test="$paramNam = 'memory'">
						     	<xsl:text>Memory events configured successfully.</xsl:text>
							</xsl:when>
			            		<xsl:when test="$paramNam = 'intrusion'">
						     	<xsl:text>Intrusion events configured successfully.</xsl:text>
							</xsl:when>
			            		<xsl:when test="$paramNam = 'battery'">
						     	<xsl:text>Battery events configured successfully.</xsl:text>
							</xsl:when>
							<xsl:otherwise>
						     	<xsl:text>Event Configured successfully.</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
	               	<xsl:when test="$parseTxt2='byoid'">
						<xsl:choose>
			            		<xsl:when test="$paramNam = 'powersupplies'">
						     	<xsl:text>Single power supply event configured successfully.</xsl:text>
							</xsl:when>
			            		<xsl:when test="$paramNam = 'redundancy'">
						     	<xsl:text>Single redundancy event configured successfully.</xsl:text>
							</xsl:when>
			            		<xsl:when test="$paramNam = 'temps'">
						     	<xsl:text>Single temperature probe events configured successfully.</xsl:text>
							</xsl:when>
			            		<xsl:when test="$paramNam = 'fans'">
						     	<xsl:text>Single fan probe event configured successfully.</xsl:text>
							</xsl:when>
			            		<xsl:when test="$paramNam = 'volts'">
						     	<xsl:text>Single voltage probe event configured successfully.</xsl:text>
							</xsl:when>
			            		<xsl:when test="$paramNam = 'currents'">
						     	<xsl:text>Single current probe event configured successfully.</xsl:text>
							</xsl:when>
			            		<xsl:when test="$paramNam = 'log'">
						     	<xsl:text>Single log event configured successfully.</xsl:text>
							</xsl:when>
			            		<xsl:when test="$paramNam = 'fanenclosures'">
						     	<xsl:text>Single enclosure event configured successfully.</xsl:text>
							</xsl:when>
			            		<xsl:when test="$paramNam = 'accords'">
						     	<xsl:text>Single AC Cord event configured successfully.</xsl:text>
							</xsl:when>
			            		<xsl:when test="$paramNam = 'memory'">
						     	<xsl:text>Single memory event configured successfully.</xsl:text>
							</xsl:when>
			            		<xsl:when test="$paramNam = 'intrusion'">
						     	<xsl:text>Single intrusion event configured successfully.</xsl:text>
							</xsl:when>
			            		<xsl:when test="$paramNam = 'battery'">
						     	<xsl:text>Single battery event configured successfully.</xsl:text>
							</xsl:when>
							<xsl:otherwise>
						     	<xsl:text>Single event Configured successfully.</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<!--XLATESTART-->Event(s) configured successfully.<!--XLATESTOP-->
					</xsl:otherwise>
			      </xsl:choose>
			</xsl:when>
			<xsl:when test="$subCom = 'platformevents'">
			     <xsl:text>Platform events configured successfully.</xsl:text>
			</xsl:when>
			<xsl:when test="$subCom = 'pedestinations'">
			     <xsl:text>Platform event destinations configured successfully.</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<!--XLATESTART-->Command successful.<!--XLATESTOP-->
                </xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="CLIPromptCanceled">
		<xsl:param name="subCom"/>
		<xsl:param name="paramNam"/>
		<xsl:param name="parseTxt"/>
		<xsl:param name="stat"/>
		<xsl:choose>
			<xsl:when test="$subCom = 'snmp'">
			     <!--XLATESTART-->Error! Password input canceled.<!--XLATESTOP-->
			</xsl:when>
			<xsl:otherwise>
			     <!--XLATESTART-->Error! Interactive input canceled.<!--XLATESTOP-->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="CLIPromptInvalid">
		<xsl:param name="subCom"/>
		<xsl:param name="paramNam"/>
		<xsl:param name="parseTxt"/>
		<xsl:param name="stat"/>
		<xsl:choose>
			<xsl:when test="$subCom = 'snmp'">
			     <!--XLATESTART-->Error! Password input invalid.<!--XLATESTOP-->
			</xsl:when>
			<xsl:otherwise>
			     <!--XLATESTART-->Error! Interactive input invalid.<!--XLATESTOP-->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="CLIPromptText">
		<xsl:param name="subCom"/>
		<xsl:param name="paramNam"/>
		<xsl:param name="parseTxt"/>
		<xsl:param name="stat"/>
		<xsl:choose>
			<xsl:when test="$subCom = 'snmp'">
				<xsl:choose>
	            		<xsl:when test="$paramNam = 'oldpw'">
			                <!--XLATESTART-->Type old password (or ESC to cancel) : <!--XLATESTOP-->
					</xsl:when>
	            		<xsl:when test="$paramNam = 'newpw'">
			                <!--XLATESTART-->Type new password (or ESC to cancel) : <!--XLATESTOP-->
					</xsl:when>
	            		<xsl:when test="$paramNam = 'confirmnewpw'">
			                <!--XLATESTART-->Type new password again to confirm (or ESC to cancel) : <!--XLATESTOP-->
					</xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
			     <!--XLATESTART-->Error! Unknown prompt text.<!--XLATESTOP-->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="CLICommandFailed">
		<xsl:param name="subCom"/>
		<xsl:param name="paramNam"/>
		<xsl:param name="parseTxt"/>
		<xsl:param name="parseTxt2"/>
		<xsl:param name="stat"/>
		<xsl:choose>
			<xsl:when test="$subCom = 'webserver'">
				<xsl:choose>
	            		<xsl:when test="$paramNam = 'start'">
	                        <xsl:choose>
							<xsl:when test="$stat = '258'">
				     			<xsl:text>Error! DSM SA Connection Service is already started.</xsl:text>
							</xsl:when>
							<xsl:when test="$stat = '-9'">
							<xsl:text>Error! DSM SA Connection Service is not installed.</xsl:text>
							</xsl:when>
							<xsl:when test="$stat = '1'">
				     			<xsl:text>Error! Command not implemented on this operating system.</xsl:text>
							</xsl:when>
							<xsl:otherwise>
				     			<xsl:text>Error! Cannot start </xsl:text><xsl:value-of select="$parseTxt"/><xsl:text>  DSM SA Connection Service.</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
	            		<xsl:when test="$paramNam = 'stop'">
	                        <xsl:choose>
							<xsl:when test="$stat = '258'">
				     			<xsl:text>Error! DSM SA Connection Service is already stopped.</xsl:text>
							</xsl:when>
							<xsl:when test="$stat = '-9'">
							<xsl:text>Error! DSM SA Connection Service is not installed.</xsl:text>
							</xsl:when>
							<xsl:when test="$stat = '1'">
				     			<xsl:text>Error! Command not implemented on this operating system.</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>Error! Cannot stop DSM SA Connection Service.</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="$paramNam = 'restart'">
	                        <xsl:choose>
							<xsl:when test="$stat = '258'">
				     			<xsl:text>Error! DSM SA Connection Service is already stopped. </xsl:text><xsl:call-template name="NewLine"/><xsl:text>Start the DSM SA Connection Service first.</xsl:text>
							</xsl:when>
							<xsl:when test="$stat = '-9'">
							<xsl:text>Error! DSM SA Connection Service is not installed.</xsl:text>
							</xsl:when>
							<xsl:when test="$stat = '1'">
				     			<xsl:text>Error! Command not implemented on this operating system.</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>Error! Cannot stop DSM SA Connection Service.</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
				     	<xsl:text>Error! Server Administrator unknown DSM SA Connection Service error.</xsl:text>
					</xsl:otherwise>
					</xsl:choose>
				</xsl:when>

			<xsl:when test="$subCom = 'snmp'">
				<xsl:choose>
				<xsl:when test="$stat = '1'">
				     			<xsl:text>Error! Command not implemented on this operating system.</xsl:text>
				</xsl:when>                     
                          <xsl:otherwise>
                          <xsl:choose>
	            		<xsl:when test="$paramNam = 'rootpw'">
	                        <xsl:choose>
							<xsl:when test="$stat = '2'">
				     			<xsl:text>Error! SNMP old root password entered does not match current value.</xsl:text>
							</xsl:when>
							<xsl:when test="$stat = '1'">
				     			<xsl:text>Error! Command not implemented.</xsl:text>
							</xsl:when>
							<xsl:otherwise>
				     			<xsl:text>Error! Attempt to set SNMP root password failed.</xsl:text>
							</xsl:otherwise>
					</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
				     	<xsl:text>Error! Attempt to set requested preference failed.</xsl:text>
					</xsl:otherwise>
					</xsl:choose>
					</xsl:otherwise>	
				
				</xsl:choose>
			</xsl:when>

			<xsl:when test="$subCom = 'events'">
				<xsl:choose>
	            		<xsl:when test="$paramNam != 'all'">
	                        <xsl:choose>
							<xsl:when test="$stat = '2'">
								<xsl:choose>
                        					<xsl:when test="$parseTxt2 ='byoid'">
										<!--XLATESTART-->Error! Cannot enable single event at lower severity than current group setting.<!--XLATESTOP-->
									</xsl:when>
									<xsl:otherwise>
				     					<xsl:text>Error! Cannot enable more events for type=</xsl:text><xsl:value-of select="$paramNam"/><xsl:text> than current type=all setting.</xsl:text>
									</xsl:otherwise>
								 </xsl:choose>
							</xsl:when>
							<xsl:when test="$stat = '1'">
				     			<xsl:text>Error! Events setting failed.</xsl:text>
							</xsl:when>
							<xsl:when test="$stat='4308'">
							<xsl:text>Error! Operation has failed because configuration is disabled for in-band access.</xsl:text>
							</xsl:when>
							<xsl:when test="$stat='212'">
							<xsl:text>Error! Operation has failed because configuration is disabled for in-band access.</xsl:text>
							</xsl:when>
							<xsl:otherwise>
				     			<xsl:text>Error! Events setting failed.</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
					<xsl:choose>
					<xsl:when test="$stat = '1'">
				     			<xsl:text>Error! Command not implemented on this operating system.</xsl:text>
					</xsl:when>   
					<xsl:when test="$stat='4308'">
							<xsl:text>Error! Operation has failed because configuration is disabled for in-band access.</xsl:text>
							</xsl:when>
							<xsl:when test="$stat='212'">
							<xsl:text>Error! Operation has failed because configuration is disabled for in-band access.</xsl:text>
							</xsl:when>
					<xsl:otherwise>
				     	<xsl:text>Error! Attempt to set events for all types failed.</xsl:text>
					</xsl:otherwise>
					</xsl:choose>	
					</xsl:otherwise>			
					</xsl:choose>
				</xsl:when>

				<xsl:when test="$subCom = 'platformevents'">
					<xsl:choose>
						<xsl:when test="$stat = '7'">
							<!-- NO_SUCH_DEVICE -->
							<xsl:text>Error! The specified event is not supported on this system.</xsl:text>
						</xsl:when>
						<xsl:when test="$stat='4308'">
						<xsl:text>Error! Operation has failed because configuration is disabled for in-band access.</xsl:text>
						</xsl:when>
						<xsl:when test="$stat='212'">
						<xsl:text>Error! Operation has failed because configuration is disabled for in-band access.</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<!-- NO_SUCH_OBJECT, etc. -->
							<xsl:text>Error! Platform events are not supported on this system.</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="$subCom = 'pedestinations'">
				<xsl:choose>
				        <xsl:when test="$stat = '8272' ">
						 <xsl:text>Error! Enter a valid FQDN, IPv4, or IPv6 address.</xsl:text>
						 </xsl:when>
						<xsl:when test="$stat = '4300' or $stat = '-1' ">
						 <xsl:text>Error! IP address type is not supported. The first four indexes accept only IPv4 addresses, while the rest accept IPv6. Enter a valid IP address for this index.</xsl:text>
						 </xsl:when>

						 <xsl:when test="$stat = '4295' ">
						 <xsl:text>Error! IP Address data length is invalid.</xsl:text>
						 </xsl:when>

						 <xsl:when test="$stat = '4098' ">
						 <xsl:text>Error! The specified IPv6 address has incorrect format.</xsl:text>
						 </xsl:when>

						 <xsl:when test="$stat = '4103' ">
						 <xsl:text>Error! IPv6 addressing is not supported on this system.</xsl:text>
						 </xsl:when>

						  <xsl:when test="$stat = '4106' ">
						 <xsl:text>Error! IPv6 stack is not loaded.</xsl:text>
						 </xsl:when>

						 <xsl:when test="$stat = '4107' ">
						 <xsl:text>Error! IPv4 stack is disabled.</xsl:text>
						 </xsl:when>
						 <xsl:when test="$stat='4308'">
						<xsl:text>Error! Operation has failed because configuration is disabled for in-band access.</xsl:text>
						</xsl:when>
						<xsl:when test="$stat='212'">
						<xsl:text>Error! Operation has failed because configuration is disabled for in-band access.</xsl:text>
						</xsl:when>

						 <xsl:otherwise>
							     <xsl:text>Error! Configuration of platform event destination is failed.</xsl:text>
						</xsl:otherwise>
				</xsl:choose>
				  </xsl:when>
     				
							<xsl:when test="$subCom = 'alertaction'">								
								<xsl:if test="$stat = '1'">
		     							<xsl:text>Error! Command not implemented on this operating system.</xsl:text>						
     								</xsl:if>
								<xsl:if test="$stat = '256'">
		     							<xsl:text>Error! The specified action is not supported on this system.</xsl:text>						
     								</xsl:if>
							</xsl:when> 							
	
			<xsl:when test="$stat='4308'">
			<xsl:text>Error! Operation has failed because configuration is disabled for in-band access.</xsl:text>
			</xsl:when>
			<xsl:when test="$stat='212'">
			<xsl:text>Error! Operation has failed because configuration is disabled for in-band access.</xsl:text>
			</xsl:when>
                        <xsl:when test="$subCom = 'dirservice'">
					<xsl:text>Error! Command failed.</xsl:text>
				</xsl:when>
     		<xsl:otherwise><!--XLATESTART-->Error! Hardware subsystem reports command failed. <!--XLATESTOP--></xsl:otherwise>
		</xsl:choose>
	</xsl:template >

	<xsl:template name="CLIOneChar">
		<xsl:param name="subCom"/>
		<xsl:param name="paramNam"/>
		<xsl:param name="parseTxt"/>
		<xsl:param name="parseTxt2"/>
		<xsl:param name="stat"/>
		<xsl:choose>
			<xsl:when test="$subCom = 'snmp'">
				<!--XLATETHIS-->Error! SNMP root password must contain at least one character.<!--XLATETHIS-->
		     </xsl:when>
			<xsl:otherwise>
				<!--XLATETHIS-->Error! Text with at least one character expected.<!--XLATETHIS-->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template >

	<xsl:template name="CLISubCommand">
		<xsl:param name="command"/>
		<xsl:if test="$command != ''">
			<xsl:value-of select="$command"/>
			<xsl:call-template name="Spaces">
				<xsl:with-param name="num"><xsl:value-of select="(17) - string-length($command)"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template name="Spaces">
		<xsl:param name="num"/>
		<xsl:choose>
			<xsl:when test="$num = '19'">
				<xsl:text>                   </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '18'">
				<xsl:text>                  </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '17'">
				<xsl:text>                 </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '16'">
				<xsl:text>                </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '15'">
				<xsl:text>               </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '14'">
				<xsl:text>              </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '13'">
				<xsl:text>             </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '12'">
				<xsl:text>            </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '11'">
				<xsl:text>           </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '10'">
				<xsl:text>          </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '9'">
				<xsl:text>         </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '8'">
				<xsl:text>        </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '7'">
				<xsl:text>       </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '6'">
				<xsl:text>      </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '5'">
				<xsl:text>     </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '4'">
				<xsl:text>    </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '3'">
				<xsl:text>   </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '2'">
				<xsl:text>  </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '1'">
				<xsl:text> </xsl:text>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="NewLine">
		<xsl:text>
</xsl:text>
	</xsl:template>

	<xsl:template name="printSubcommandDeprecated">
		<xsl:param name="newCommand"/>
		<xsl:param name="standalone">true</xsl:param>

		<xsl:variable name="numIndentSpaces"><xsl:value-of select="$subCommandIndentSize + 2"/></xsl:variable>

		<xsl:call-template name="NewLine"/>
		<xsl:if test="$standalone = 'true'">
			<xsl:call-template name="NewLine"/>
		</xsl:if>
		<xsl:if test="$standalone = 'false'">
			<xsl:call-template name="Spaces">
				<xsl:with-param name="num"><xsl:value-of select="$numIndentSpaces"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		<xsl:text>SUBCOMMAND DEPRECATION WARNING:</xsl:text>
		<xsl:call-template name="NewLine"/>
		<xsl:if test="$standalone = 'false'">
			<xsl:call-template name="Spaces">
				<xsl:with-param name="num"><xsl:value-of select="$numIndentSpaces"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		<xsl:text>This subcommand is deprecated and will be discontinued in </xsl:text>
		<xsl:if test="$standalone = 'false'">
			<xsl:call-template name="NewLine"/>
			<xsl:call-template name="Spaces">
				<xsl:with-param name="num"><xsl:value-of select="$numIndentSpaces"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		<xsl:text>a subsequent release.</xsl:text>
		<xsl:if test="$standalone = 'true'">
			<xsl:call-template name="NewLine"/>
		</xsl:if>
		<xsl:if test="$newCommand != ''">
			<xsl:if test="$standalone = 'false'">
				<xsl:call-template name="NewLine"/>
			</xsl:if>
			<xsl:if test="$standalone = 'false'">
				<xsl:call-template name="Spaces">
					<xsl:with-param name="num"><xsl:value-of select="$numIndentSpaces"/></xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:text>Use the subcommand "</xsl:text>
			<xsl:value-of select="$newCommand"/>
			<xsl:text>" instead.</xsl:text>
			<xsl:if test="$standalone = 'true'">
				<xsl:call-template name="NewLine"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<xsl:template name="printSubcommandDeprecatedExt">
			<xsl:param name="newCommand"/>
			<xsl:param name="standalone">true</xsl:param>

			<xsl:variable name="numIndentSpaces"><xsl:value-of select="$subCommandIndentSize + 2"/></xsl:variable>

			<xsl:call-template name="printSubcommandDeprecated">
				<xsl:with-param name="newCommand"><xsl:value-of select="$newCommand"/></xsl:with-param>
				<xsl:with-param name="standalone"><xsl:value-of select="$standalone"/></xsl:with-param>
			</xsl:call-template>
			<xsl:call-template name="NewLine"/>
			<xsl:call-template name="Spaces">
				<xsl:with-param name="num"><xsl:value-of select="$numIndentSpaces"/></xsl:with-param>
			</xsl:call-template>
			<xsl:text>This is applicable on blade servers only.</xsl:text>
			<xsl:if test="$standalone = 'true'">
				<xsl:call-template name="NewLine"/>
			</xsl:if>
	</xsl:template>

	<xsl:template name="StorageLRAHelp">
		<xsl:call-template name="NewLine"/>
		<!--XLATESTART-->Following events are applicable if Storage Management is installed<!--XLATESTOP-->
	    <xsl:call-template name="NewLine"/>
		<xsl:text>event=storagesyswarn                </xsl:text><!--XLATESTART-->Set Storage System warning action(s).<!--XLATESTOP-->
        <xsl:call-template name="NewLine"/>
        <xsl:text>event=storagesysfail                </xsl:text><!--XLATESTART-->Set Storage System failure action(s).<!--XLATESTOP-->
        <xsl:call-template name="NewLine"/>
        <xsl:text>event=storagectrlwarn               </xsl:text><!--XLATESTART-->Set Storage Controller warning action(s).<!--XLATESTOP-->
        <xsl:call-template name="NewLine"/>
        <xsl:text>event=storagectrlfail               </xsl:text><!--XLATESTART-->Set Storage Controller failure action(s).<!--XLATESTOP-->
        <xsl:call-template name="NewLine"/>
        <xsl:text>event=pdiskwarn                     </xsl:text><!--XLATESTART-->Set Physical Disk warning action(s).<!--XLATESTOP-->
        <xsl:call-template name="NewLine"/>
        <xsl:text>event=pdiskfail                     </xsl:text><!--XLATESTART-->Set Physical Disk failure action(s).<!--XLATESTOP-->
        <xsl:call-template name="NewLine"/>
        <xsl:text>event=vdiskwarn                     </xsl:text><!--XLATESTART-->Set Virtual Disk warning  action(s).<!--XLATESTOP-->
        <xsl:call-template name="NewLine"/>
        <xsl:text>event=vdiskfail                     </xsl:text><!--XLATESTART-->Set Virtual Disk failure action(s).<!--XLATESTOP-->
        <xsl:call-template name="NewLine"/>
        <xsl:text>event=enclosurewarn                 </xsl:text><!--XLATESTART-->Set Enclosure warning action(s).<!--XLATESTOP-->
        <xsl:call-template name="NewLine"/>
        <xsl:text>event=enclosurefail                 </xsl:text><!--XLATESTART-->Set Enclosure failure action(s).<!--XLATESTOP-->
        <xsl:call-template name="NewLine"/>
        <xsl:text>event=storagectrlbatterywarn        </xsl:text><!--XLATESTART-->Set Storage Controller Battery warning action(s).<!--XLATESTOP-->
        <xsl:call-template name="NewLine"/>
        <xsl:text>event=storagectrlbatteryfail        </xsl:text><!--XLATESTART-->Set Storage Controller Battery failure action(s).<!--XLATESTOP-->
        <xsl:call-template name="NewLine"/>
	</xsl:template>

</xsl:stylesheet>
