<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml" />
	<xsl:strip-space elements="*"/>
	<xsl:variable name="IsBlade">
	  <xsl:choose>
	     <xsl:when test="/OMA/ChassisList/Chassis/ChassisInfo/ChassisProps1/ChassType='25'">true</xsl:when>
	     <xsl:otherwise>false</xsl:otherwise>
	 </xsl:choose>
    </xsl:variable>
	<xsl:variable name="IsCLICmdNew">
	   <xsl:choose>
	      <xsl:when test="/OMA/OMACMDNEW='0'">false</xsl:when>
	      <xsl:otherwise>true</xsl:otherwise>
	   </xsl:choose>
	</xsl:variable>

	<xsl:template match="/OMA">
		<xsl:choose>
			<xsl:when test="SMStatus != '0'">
				<DataArea>
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strError"/><xsl:call-template name="smstatus"><xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</PageTitle>
				</DataArea>
			</xsl:when>
			<xsl:otherwise>
				<DataArea>
					<PageTitle>
						<xsl:choose>
							  <xsl:when test="$IsBlade='true' and $IsCLICmdNew='true'">
								<xsl:attribute name="display"><xsl:value-of select="$strXMainSystemInformationX"/></xsl:attribute>
							  </xsl:when>
							  <xsl:otherwise>
								<xsl:attribute name="display"><xsl:value-of select="$strXChassisInformationX"/></xsl:attribute>
							  </xsl:otherwise>
						 </xsl:choose>
			    </PageTitle>
						<xsl:choose>
							<xsl:when test="ChassisList/@count = '1'">
								<ListData>
									<Data>
										<xsl:attribute name="display"><xsl:value-of select="$strIndex"/></xsl:attribute>
										<xsl:attribute name="value"><xsl:value-of select="ChassisList/Chassis/@index"/></xsl:attribute>
									</Data>
                  <xsl:if test ="$IsBlade!='true' or $IsCLICmdNew!='true'">
									<Data>
										<xsl:attribute name="display"><xsl:value-of select="$strChassisName"/></xsl:attribute>
										<xsl:attribute name="value"><xsl:value-of select="ChassisList/Chassis/@display"/></xsl:attribute>
									</Data>
									</xsl:if>
									<xsl:apply-templates select="ChassisList/Chassis/ChassisInfo"/>
								</ListData>
							</xsl:when>
							<xsl:otherwise>
								<SummaryData>
									<xsl:for-each select="ChassisList/Chassis">
										<Section>
                      <xsl:choose>
                        <xsl:when test="$IsBlade='true' or $IsCLICmdNew='true'">
                          <xsl:attribute name="display"><xsl:value-of select="$strMainSystem"/></xsl:attribute>
    											<xsl:attribute name="name"><xsl:value-of select="$strMainSystem"/></xsl:attribute>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:attribute name="display"><xsl:value-of select="@display"/></xsl:attribute>
											    <xsl:attribute name="name"><xsl:value-of select="@display"/></xsl:attribute>
                        </xsl:otherwise>
                      </xsl:choose>
											<ListData>
												<Data>
													<xsl:attribute name="display"><xsl:value-of select="$strIndex1"/></xsl:attribute>
													<xsl:attribute name="value"><xsl:value-of select="@index"/></xsl:attribute>
												</Data>
												<xsl:if test ="$IsBlade!='true' or $IsCLICmdNew!='true'">
												<Data>
													<xsl:attribute name="display"><xsl:value-of select="$strChassisName1"/></xsl:attribute>
													<xsl:attribute name="value"><xsl:value-of select="@display"/></xsl:attribute>
												</Data>
												</xsl:if>
												<xsl:apply-templates select="ChassisInfo"/>
											</ListData>
										</Section>
									</xsl:for-each>
								</SummaryData>
							</xsl:otherwise>
						</xsl:choose>
				</DataArea>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="ChassisInfo">
		<xsl:if test="SystemInfo/SystemName">
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strHostName"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="SystemInfo/SystemName"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="FirmwareList">
			<xsl:for-each select="FirmwareList/Firmware">
				<Data>					
					<xsl:attribute name="display"><xsl:value-of select="FWText"/><xsl:value-of select="$strVersion"/></xsl:attribute>					
					<xsl:attribute name="value"><xsl:value-of select="FWVersion"/></xsl:attribute>
				</Data>
			</xsl:for-each>
		</xsl:if>
		<xsl:if test="ChassisProps1/ChassModel">
		<Data>
		  <xsl:choose>
			<xsl:when test="$IsBlade='true' and $IsCLICmdNew='true'">
			  	<xsl:attribute name="display"><xsl:value-of select="$strModel"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
			  	<xsl:attribute name="display"><xsl:value-of select="$strChassisModel"/></xsl:attribute>
			</xsl:otherwise>
			</xsl:choose>
			  <xsl:attribute name="value"><xsl:value-of select="ChassisProps1/ChassModel"/></xsl:attribute>
			</Data>
		</xsl:if>
		
		<!--SystemRevision starts from '1' and 255 represents systemrevision is not applicable to that server-->

		<xsl:if test="ChassisProps1/SystemRevision !='0' and ChassisProps1/SystemRevision !='255' ">
			<xsl:if test="ChassisProps1/SystemRevisionName">
			<Data>
			  	<xsl:attribute name="display"><xsl:value-of select="$strSystemRevisionName"/></xsl:attribute>			
				<xsl:attribute name="value"><xsl:value-of select="ChassisProps1/SystemRevisionName"/></xsl:attribute>		
			
			</Data>
			</xsl:if>
		</xsl:if>

		<xsl:if test="ChassisProps1/ChassLockPresent">
		 <xsl:if test="$IsCLICmdNew='false'">
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strChassisLock"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="ChassisProps1/ChassLockPresent = 'true'">
						<xsl:attribute name="value"><xsl:value-of select="$strPresent"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><xsl:value-of select="$strNotPresent"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
		  </xsl:if>
		</xsl:if>

		<xsl:variable name="isShredder">
		     <xsl:choose>
         			<xsl:when test="ChassisProps1/ChassType = '25' ">
					<xsl:choose>
                  			<xsl:when test="(count(/OMA/ChassisList/Chassis/ChassisInfo/BaseBoardList/BaseBoard[BaseBoardType='3'] ) ) > 0">
							<xsl:value-of select="'true'"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'false'"/>
						</xsl:otherwise>
               		</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'false'"/>
				</xsl:otherwise>
      		</xsl:choose>
		</xsl:variable>

		<xsl:call-template name="DispChasSrvcTag">
			<xsl:with-param name="shredderFlag">
				<xsl:value-of select="$isShredder"/>
			</xsl:with-param>
		</xsl:call-template>

		<xsl:call-template name="DispChasAssetTag">
			<xsl:with-param name="shredderFlag">
				<xsl:value-of select="$isShredder"/>
			</xsl:with-param>
		</xsl:call-template>

		<xsl:call-template name="DispChasLocation">
			<xsl:with-param name="shredderFlag">
				<xsl:value-of select="$isShredder"/>
			</xsl:with-param>
		</xsl:call-template>

		<!-- ChassType 25 is a Shredder orYellowstone  -->
		<xsl:if test="ChassisProps1/ChassType = '25' ">
			<xsl:call-template name="Yellowstone">
				<!--xsl:with-param name="shredderFlag">
					<xsl:value-of select="$isShredder">
				</xsl:with-param-->
			</xsl:call-template>
		</xsl:if>

		<xsl:if test="ChassisProps2/IdentifySupport">
			<xsl:if test="ChassisProps2 /IdentifySupport = 'true'">
				<Data>
					<xsl:choose>
					  <xsl:when test ="$IsBlade='true' and $IsCLICmdNew='true'">
					  	<xsl:attribute name="display"><xsl:value-of select="$strFlashIdentify"/></xsl:attribute>
					  </xsl:when>
					  <xsl:otherwise>
					  	 <xsl:attribute name="display"><xsl:value-of select="$strFlashChassisIdentify"/></xsl:attribute>
					  </xsl:otherwise>
					</xsl:choose>
					<xsl:attribute name="value">

						<xsl:choose>
				              <xsl:when test="ChassisProps2/ ChassIdentifyState = '0'"><xsl:value-of select="$strOff"/>
				              </xsl:when>
				              <xsl:when test="ChassisProps2/ ChassIdentifyState = '1'"><xsl:value-of select="$strFlashing"/>
				              </xsl:when>
				              <xsl:otherwise><xsl:value-of select="$strUndefined"/>
				              </xsl:otherwise>
			               </xsl:choose>
	 				</xsl:attribute>
				</Data>
				<Data>
					<xsl:choose>
						 <xsl:when test ="$IsBlade='true' and $IsCLICmdNew='true'">
						  <xsl:attribute name="display"><xsl:value-of select="$strFlashIdentify1"/></xsl:attribute>
						  </xsl:when>
						<xsl:otherwise>
						  <xsl:attribute name="display"><xsl:value-of select="$strFlashChassisIdentify1"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:attribute name="value"><xsl:value-of select="ChassisProps2 /ChassIdentifyTimeout " /></xsl:attribute>
				</Data>
			</xsl:if>
		</xsl:if>
		<xsl:if test="ChassisProps2/HdLedSupport = 'true'">
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strClearHardDrive"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strSupported"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="ChassisProps2/FaultLEDControl != '0'">
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strFaultLEDFlash"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="ChassisProps2/FaultLEDControl = '8'">
						<xsl:attribute name="value"><xsl:value-of select="$strWarning"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="ChassisProps2/FaultLEDControl = '16'">
						<xsl:attribute name="value"><xsl:value-of select="$strCritical"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><xsl:value-of select="$strUndefined1"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
		</xsl:if>

	</xsl:template>

	<xsl:template name="DispChasSrvcTag">
		<xsl:param name="shredderFlag"/>

		<!--check for shredder-->
		<xsl:choose>
			<!--Shredder-->
			<xsl:when test="$shredderFlag='true'">
        <xsl:if test="$IsCLICmdNew='false'">
          <Data name="ServiceTag">
            <xsl:attribute name="display">
              <xsl:value-of select="$strChassisServiceTag"/></xsl:attribute>
            <xsl:for-each select="/OMA/ChassisList/Chassis/ChassisInfo/BaseBoardList/BaseBoard">
              <xsl:if test="BaseBoardType = '13'">
                <xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
              </xsl:if>
            </xsl:for-each>
          </Data>
		  <Data name="ExpressServiceCode">
            <xsl:attribute name="display">
              <xsl:value-of select="$strExpressServiceCode"/></xsl:attribute>
            <xsl:for-each select="/OMA/ChassisList/Chassis/ChassisInfo/BaseBoardList/BaseBoard">
              <xsl:if test="BaseBoardType = '13'">
                <xsl:attribute name="value"><xsl:value-of select="ExpressServiceCode"/></xsl:attribute>
              </xsl:if>
            </xsl:for-each>
          </Data>
        </xsl:if>
				<Data name="BladeServiceTag">
					<xsl:choose>
						<xsl:when test="$IsBlade='true' and $IsCLICmdNew='true'">
							<xsl:attribute name="display"><xsl:value-of select="$strServiceTag"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="display"><xsl:value-of select="$strServerModuleService"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:attribute name="value">
						<xsl:value-of select="/OMA/ChassisList/Chassis/ChassisInfo/ChassisProps2/ServiceTag"/>
					</xsl:attribute>
				</Data>
				<Data name="BladeExpressServiceCode">
					<xsl:attribute name="display"><xsl:value-of select="$strExpressServiceCode"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:value-of select="/OMA/ChassisList/Chassis/ChassisInfo/ChassisProps2/ExpressServiceCode"/>
					</xsl:attribute>
				</Data>


			</xsl:when>
			<xsl:otherwise>
				<!--not shredder -->
				<Data name="ServiceTag">
					<xsl:attribute name="display"><xsl:value-of select="$strChassisServiceTag"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:value-of select="ChassisProps2/ServiceTag"/>
					</xsl:attribute>
				</Data>
				<Data name="ExpressServiceCode">
					<xsl:attribute name="display"><xsl:value-of select="$strExpressServiceCode"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:value-of select="ChassisProps2/ExpressServiceCode"/>
					</xsl:attribute>
				</Data>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="DispChasAssetTag">
		<xsl:param name="shredderFlag"/>
		<!--check for shredder-->
		<xsl:choose>
			<xsl:when test="$shredderFlag='true'">
				<xsl:for-each select="/OMA/ChassisList/Chassis/ChassisInfo/BaseBoardList/BaseBoard">
					<xsl:if test="BaseBoardType = '13'">
						<Data name="BladeAssetTag">
							<xsl:choose>
								<xsl:when test="$IsBlade='true' and $IsCLICmdNew='true'">
									<xsl:attribute name="display"><xsl:value-of select="$strAssetTag"/></xsl:attribute>
                  </xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="display"><xsl:value-of select="$strServerModuleAsset"/></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
							<xsl:attribute name="value">
								<xsl:value-of select="/OMA/ChassisList/Chassis/ChassisInfo/ChassisProps2/AssetTag"/>
							</xsl:attribute>
						</Data>
  					</xsl:if>
  				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<!--not shredder -->
				<Data name="AssetTag">
					<xsl:attribute name="display">
						<xsl:value-of select="$strChassisAssetTag"/>
					</xsl:attribute>
					<xsl:attribute name="value">
						<xsl:value-of select="ChassisProps2/AssetTag"/>
					</xsl:attribute>
				</Data>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="DispChasLocation">
		<xsl:param name="shredderFlag"/>
		<!--check for shredder-->
		<xsl:choose>
			<xsl:when test="$shredderFlag">
				<xsl:if test ="$IsCLICmdNew='false'">
				<xsl:for-each select="/OMA/ChassisList/Chassis/ChassisInfo/BaseBoardList/BaseBoard">
					<xsl:if test="BaseBoardType = '3'">
						<Data name="BladeLocation" type="ustring">
							<xsl:attribute name="display"><xsl:value-of select="$strServerModuleLocation"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="BoardLocation"/></xsl:attribute>
						</Data>
  					</xsl:if>
  				</xsl:for-each>
  				</xsl:if>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<!--xsl:template match="/OMA/ChassisList/Chassis/ChassisInfo/BaseBoardList">
		<xsl:for-each select="BaseBoard">
			<xsl:if test="BaseBoardType = '13'">
				<Data name="BladeServiceTag">
					<xsl:attribute name="display"><xsl:value-of select="$strServerModuleService"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
				</Data>
				<Data name="AssetTag">
						<xsl:attribute name="display"><xsl:value-of select="$strServerModuleAsset"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="/OMA/ChassisList/Chassis/ChassisInfo/ChassisProps2/AssetTag"/></xsl:attribute>

				</Data>
			</xsl:if>
			<xsl:if test="BaseBoardType='3'">
				<Data name="BladeLocation" type="ustring">
					<xsl:attribute name="display"><xsl:value-of select="$strServerModuleLocation"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="BoardLocation"/></xsl:attribute>
				</Data>
			</xsl:if>
		</xsl:for-each>
	</xsl:template-->

	<xsl:template name="Yellowstone">
	     <!--Shredder-->
		<!--xsl:for-each select="/OMA/ChassisList/Chassis/ChassisInfo/BaseBoardList/BaseBoard[BaseBoardType='3']">
				<Data name="BladeServiceTag">
					<xsl:attribute name="display"><xsl:value-of select="$strServerModuleService"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
				</Data>
				<Data name="AssetTag">
						<xsl:attribute name="display"><xsl:value-of select="$strServerModuleAsset"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="/OMA/ChassisList/Chassis/ChassisInfo/ChassisProps2/AssetTag"/></xsl:attribute>

				</Data>
				<Data name="BladeLocation" type="ustring">
					<xsl:attribute name="display"><xsl:value-of select="$strServerModuleLocation"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="BoardLocation"/></xsl:attribute>
				</Data>
		</xsl:for-each-->

		<!--Yellowstone-->
		<xsl:for-each select="/OMA/ChassisList/Chassis/ChassisInfo/BaseBoardList/BaseBoard[BaseBoardType='11']">
			<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strPMMAssetTag"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="AssetTag"/></xsl:attribute>
			</Data>
			<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strPMMserviceTag"/></xsl:attribute>
 				     <xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
			</Data>
			<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strPMMLocation"/></xsl:attribute>
				     <xsl:attribute name="value"><xsl:value-of select="BoardLocation"/></xsl:attribute>
			</Data>
		</xsl:for-each>

		<xsl:for-each select="/OMA/ChassisList/Chassis/ChassisInfo/BaseBoardList/BaseBoard[BaseBoardType='12']">
			<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strIOMAssetTag"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="AssetTag"/></xsl:attribute>
			</Data>
			<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strIOMserviceTag"/></xsl:attribute>
 				     <xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
			</Data>
			<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strIOMLocation"/></xsl:attribute>
				     <xsl:attribute name="value"><xsl:value-of select="BoardLocation"/></xsl:attribute>
			</Data>
		</xsl:for-each>

		<xsl:for-each select="/OMA/ChassisList/Chassis/ChassisInfo/BaseBoardList/BaseBoard[BaseBoardType='2']">
		     <xsl:choose>
	            	<xsl:when test="position() = 1">
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strDSM0AssetTag"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="AssetTag"/></xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strDSM0serviceTag"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strDSM0Location"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="BoardLocation"/></xsl:attribute>
					</Data>
				</xsl:when>
	            	<xsl:when test="position() = 2">
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strDSM1AssetTag"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="AssetTag"/></xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strDSM1serviceTag"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strDSM1Location"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="BoardLocation"/></xsl:attribute>
					</Data>
				</xsl:when>
	            	<xsl:when test="position() = 3">
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strDSM2AssetTag"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="AssetTag"/></xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strDSM2serviceTag"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="ServiceTag"/></xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strDSM2Location"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="BoardLocation"/></xsl:attribute>
					</Data>
				</xsl:when>
	         	</xsl:choose>
		</xsl:for-each>
	</xsl:template>



	<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:param name="mssg"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><xsl:value-of select="$strCommandUnsuccessful"/></xsl:when>
			<xsl:when test="$status = '0'"><xsl:value-of select="$strCommandSuccessful"/></xsl:when>
			<xsl:when test="$status = '1'"><xsl:value-of select="$strCommandNotImplemented"/></xsl:when>
			<xsl:when test="$status = '2'"><xsl:value-of select="$strBadCommand"/></xsl:when>
			<xsl:when test="$status = '3'"><xsl:value-of select="$strCommandTimeout"/></xsl:when>
			<xsl:when test="$status = '4'"><xsl:value-of select="$strCommandCancelled"/></xsl:when>
			<xsl:when test="$status = '5'"><xsl:value-of select="$strCommandAborted"/></xsl:when>
			<xsl:when test="$status = '6'"><xsl:value-of select="$strCommandPending"/></xsl:when>
			<xsl:when test="$status = '7'"><xsl:value-of select="$strNoSuchDevice"/></xsl:when>
			<xsl:when test="$status = '8'"><xsl:value-of select="$strDeviceBusy"/></xsl:when>
			<xsl:when test="$status = '9'"><xsl:value-of select="$strBadDevice"/></xsl:when>
			<xsl:when test="$status = '10'"><xsl:value-of select="$strSpuriousInterrupt"/></xsl:when>
			<xsl:when test="$status = '11'"><xsl:value-of select="$strResourceLocked"/></xsl:when>
			<xsl:when test="$status = '12'"><xsl:value-of select="$strInvalidIndex"/></xsl:when>
			<xsl:when test="$status = '13'"><xsl:value-of select="$strSMBError"/></xsl:when>
			<xsl:when test="$status = '14'"><xsl:value-of select="$strDataRequestedIs"/></xsl:when>
			<xsl:when test="$status = '15'"><xsl:value-of select="$strDataRequestedIs1"/></xsl:when>
			<xsl:when test="$status = '16'"><xsl:value-of select="$strDataRequestedIs2"/></xsl:when>
			<xsl:when test="$status = '17'"><xsl:value-of select="$strDeviceNotYet"/></xsl:when>
			<xsl:when test="$status = '18'"><xsl:value-of select="$strDeviceDoesNot"/></xsl:when>
			<xsl:when test="$status = '19'"><xsl:value-of select="$strDeviceOutOf"/></xsl:when>
			<xsl:when test="$status = '20'"><xsl:value-of select="$strDeviceAlreadyExists"/></xsl:when>
			<xsl:when test="$status = '256'"><xsl:value-of select="$strObjectNotFound"/></xsl:when>
			<xsl:when test="$status = '257'"><xsl:value-of select="$strObjectMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '258'"><xsl:value-of select="$strObjectAlreadyExists"/></xsl:when>
			<xsl:when test="$status = '260'"><xsl:value-of select="$strINIFileNot"/></xsl:when>
			<xsl:when test="$status = '261'"><xsl:value-of select="$strINIMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '262'"><xsl:value-of select="$strINISectionDoes"/></xsl:when>
			<xsl:when test="$status = '263'"><xsl:value-of select="$strINIKeyDoes"/></xsl:when>
			<xsl:when test="$status = '264'"><xsl:value-of select="$strINIValueMalformed"/></xsl:when>
			<xsl:when test="$status = '270'"><xsl:value-of select="$strInsufficientAccessRights"/></xsl:when>
			<xsl:when test="$status = '271'"><xsl:value-of select="$strInvalidParameterName"/><xsl:value-of select="$mssg"/></xsl:when>
			<xsl:when test="$status = '272'"><xsl:value-of select="$strOutOfMemory"/></xsl:when>
			<xsl:when test="$status = '280'"><xsl:value-of select="$strXMLFileNot"/></xsl:when>
			<xsl:when test="$status = '281'"><xsl:value-of select="$strXMLMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '282'"><xsl:value-of select="$strXMLNodeDoes"/></xsl:when>
			<xsl:when test="$status = '283'"><xsl:value-of select="$strXMLValueMalformed"/></xsl:when>
			<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>