<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <xsl:import href="Util.xsl"/>
  <xsl:variable name="varUnit">
    <xsl:choose>
      <xsl:when test="/OMA/@cli = 'true'"><xsl:value-of select="/OMA/UnitType"/></xsl:when>
      <xsl:otherwise>all</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  
  <xsl:template match="OMA">
  <DataArea ignoreJumpBar="true">
  <xsl:choose>
      <xsl:when test="SMStatus != '0'">
	      <script language="javascript">			 		
			var value = <xsl:value-of select="SMStatus"/>;
			document.location.href=top.gnv.appendVID('./DataArea?plugin=com.dell.oma.webplugins.FailureWebPlugin&amp;SMStatus=' + value+'&amp;caller='+document.location.href);
	      </script>      
	</xsl:when>
	<xsl:otherwise>
	<xsl:choose>
	 <xsl:when test="/OMA/@cli='true' and /OMA/SMStatus != '0'">
	  <TableData>
                <Header>
                  <Data>
                    <xsl:attribute name="display"><xsl:value-of select="$gstrError"/></xsl:attribute>
                    <xsl:attribute name="value"><xsl:value-of select="$gstrError"/></xsl:attribute>
                  </Data>
                </Header>
                <Row>
                  <Data>
                    <xsl:attribute name="display"><xsl:value-of select="$gstr"/></xsl:attribute>
                    <xsl:attribute name="value">
                      <xsl:call-template name="smstatus">
                        <xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
                      </xsl:call-template>
                    </xsl:attribute>
                  </Data>
                </Row>
              </TableData>
	</xsl:when>
	</xsl:choose>
	</xsl:otherwise>
    </xsl:choose>
    <xsl:choose>
      <!-- Power Monitoring not available -->
      <xsl:when test="count(/OMA/PowerConsumptionDataObj) &lt; 1">
          <CustomButton>
            <Data>
              <xsl:attribute name="display"><xsl:value-of select="$gstrRefresh"/></xsl:attribute>
              <xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.ListPowerMonitoringStatsWebPlugin&amp;help=PowerMonitoringstats</xsl:attribute>
            </Data>
          </CustomButton>
          <PromptText><xsl:value-of select="$gstrPowerMonitoringNAMessage"/></PromptText>
      </xsl:when>
      <xsl:otherwise>
        <PageTitle>
          <xsl:attribute name="display"><xsl:value-of select="$strPowerTrackStats"/></xsl:attribute>
        </PageTitle>       
          <!-- Power Monitoring available and success condition -->
              <script language="javascript">

                function resetreadings(countertype)
                {
                if (confirm("<xsl:value-of select="$strResetWarnMsg"/>"))
                {
                document.getElementById("dataarea").action=top.gnv.appendVID("./DataArea?plugin=com.dell.hip.webplugins.ListPowerMonitoringStatsWebPlugin&amp;resetreading=true&amp;countertypevalue=" + countertype);
                document.getElementById("dataarea").submit();
                }
                }

              </script>
              <CustomButton>
                <Data>
                  <xsl:attribute name="display"><xsl:value-of select="$gstrRefresh"/></xsl:attribute>
                  <xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.ListPowerMonitoringStatsWebPlugin&amp;help=PowerMonitoringstats</xsl:attribute>
                </Data>
              </CustomButton>
              <xsl:apply-templates select="PowerConsumptionDataObj"/>
      </xsl:otherwise>
    </xsl:choose>
  </DataArea>
  </xsl:template>

  <xsl:template match="PowerConsumptionDataObj">
    <xsl:call-template name="CumulativePower"/>
    <xsl:call-template name="PeakPower"/>
  </xsl:template>

  <xsl:template name="CumulativePower">
    <TableData columnspacing="true" name="cumlpower" >
      <Header>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strStatistic"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strStatistic"/></xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strMeasureStartTime"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strMeasureStartTime"/></xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strMeasureFinishTime"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strMeasureFinishTime"/></xsl:attribute>
        </Data>
        <Data align="center">
          <xsl:attribute name="display"><xsl:value-of select="$gstrReading"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$gstrReading"/></xsl:attribute>
        </Data>
        <xsl:if test="(/OMA/OMAUserRights = '7')">
          <Data align="center">
            <xsl:attribute name="display"><xsl:value-of select="$strResetReading"/></xsl:attribute>
            <xsl:attribute name="value"><xsl:value-of select="$strResetReading"/></xsl:attribute>
          </Data>
        </xsl:if>
      </Header>
      <Row height="15px">
        <Data height="15">
          <xsl:attribute name="value"><xsl:value-of select="$strEnergyConsumption"/></xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="value"><xsl:value-of select="/OMA/cwStartTimeDisplay"/></xsl:attribute>
          <xsl:attribute name="align">left</xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="value"><xsl:value-of select="/OMA/cwFinishTimeDisplay"/></xsl:attribute>
          <xsl:attribute name="align">left</xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="value">
            <xsl:call-template name="formatKiloWattValue">
              <xsl:with-param name="value"><xsl:value-of select="cumulativeWatts"/></xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
          <xsl:attribute name="align">center</xsl:attribute>
        </Data>
        <xsl:if test="(/OMA/OMAUserRights = '7')">
          <Data id="resetreadid" type="button">
            <xsl:attribute name="value"><xsl:value-of select="$strReset"/></xsl:attribute>
            <xsl:attribute name="tablebutton">true</xsl:attribute>
            <xsl:attribute name="href">javascript:resetreadings(1)</xsl:attribute>
            <xsl:attribute name="formSubmit">true</xsl:attribute>
            <xsl:attribute name="align">center</xsl:attribute>
          </Data>
        </xsl:if>
      </Row>
    </TableData>
  </xsl:template>
  
  <xsl:template name="PeakPower">
    <TableData columnspacing="true" name="peakpower">
      <Header>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strStatistic"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strStatistic"/></xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strMeasureStartTime"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strMeasureStartTime"/></xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strPeakTime"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strPeakTime"/></xsl:attribute>
        </Data>
        <Data align="center">
          <xsl:attribute name="display"><xsl:value-of select="$strPeakReading"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strPeakReading"/></xsl:attribute>
        </Data>
        <xsl:if test="(/OMA/OMAUserRights = '7')">
          <Data align="center">
            <xsl:attribute name="display"><xsl:value-of select="$strResetReading"/></xsl:attribute>
            <xsl:attribute name="value"><xsl:value-of select="$strResetReading"/></xsl:attribute>
          </Data>
        </xsl:if>
      </Header>
      <Row>
        <Data>
          <xsl:attribute name="value"><xsl:value-of select="$strSystemPeakPower"/></xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="value"><xsl:value-of select="/OMA/pwStartTimeDisplay"/></xsl:attribute>
          <xsl:attribute name="align">left</xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="value"><xsl:value-of select="/OMA/pwReadingTimeDisplay"/></xsl:attribute>
          <xsl:attribute name="align">left</xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="value">
            <xsl:call-template name="formatWattValue">
                <xsl:with-param name="value"><xsl:value-of select="peakWatts"/></xsl:with-param>
                <xsl:with-param name="unit"><xsl:value-of select="$varUnit"/></xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
          <xsl:attribute name="align">center</xsl:attribute>
        </Data>
        <xsl:if test="(/OMA/OMAUserRights = '7')">
          <Data id="resetreadid" rowspan="2" type="button">
            <xsl:attribute name="value"><xsl:value-of select="$strReset"/></xsl:attribute>
            <xsl:attribute name="tablebutton">true</xsl:attribute>
            <xsl:attribute name="href">javascript:resetreadings(2)</xsl:attribute>
            <xsl:attribute name="formSubmit">true</xsl:attribute>
            <xsl:attribute name="align">center</xsl:attribute>
          </Data>
        </xsl:if>
      </Row>
      <xsl:variable name="peakamp"><xsl:value-of select="peakAmps"/></xsl:variable>
      <xsl:if test="$peakamp != ''">
      <Row>
        <Data>
          <xsl:attribute name="value" ><xsl:value-of select="$strSystemPeakAmperage"/></xsl:attribute>
        </Data>
        <Data> 
          <xsl:attribute name="value"><xsl:value-of select="/OMA/paStartTimeDisplay"/></xsl:attribute>
          <xsl:attribute name="align">left</xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="value"><xsl:value-of select="/OMA/paReadingTimeDisplay"/></xsl:attribute>
          <xsl:attribute name="align">left</xsl:attribute>
        </Data>
        <Data>
          <xsl:attribute name="value">
            <xsl:call-template name="formatDeciAmpsValue">
              <xsl:with-param name="value"><xsl:value-of select="peakAmps"/></xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
          <xsl:attribute name="align">center</xsl:attribute>
        </Data>
      </Row>
      </xsl:if>
    </TableData>
  </xsl:template>  

   <xsl:template name="smstatus">
    <xsl:param name="status"/>
    <xsl:param name="mssg"/>
    <xsl:choose>
      <xsl:when test="$status = '-1'"><xsl:value-of select="$gstrCommandUnsuccessful"/></xsl:when>
      <xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>

