<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:variable name="allowEdits">
		<xsl:choose>
			<xsl:when test="/OMA/OMAUserRights &lt; '7' or /OMA/@cli = 'true'">false</xsl:when>
			<xsl:otherwise>true</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="controlsNotAvailable">
		<xsl:choose>
			<xsl:when test="(
								not(/OMA/ChassisProps/ChassisInfo/ChassisProps2) or
								(/OMA/ChassisProps/ChassisInfo/ChassisProps2/PowerButtonControl = '0' and
									/OMA/ChassisProps/ChassisInfo/ChassisProps2/NMIButtonControl = '0')
							) and not(/OMA/LCDProps/LCDObj)">true</xsl:when>
			<xsl:otherwise>false</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="LCDLine">
		<xsl:choose>
			<xsl:when test="not(/OMA/LCDProps/LCDLineObj)">false</xsl:when>
			<xsl:otherwise>true</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:template match="/OMA">
		<DataArea onLoad="true" exportdata="false" validate="true">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' and $controlsNotAvailable = 'true'">
					<PageTitle display="{$strErrorNoFront}"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="(/OMA/OMAUserRights = '7')">
						<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.hip.webplugins.SetPwrButtonWebPlugin</xsl:attribute>
					</xsl:if>
					<PageTitle display="{$strFrontPanelInfo}"/>
					<CustomButton>
						<Data display="{$strRefresh}">
							<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.PwrButtonWebPlugin&amp;poid=<xsl:value-of select="/OMA/ChassisProps/Chassis/@oid"/>&amp;help=pwrbutton&amp;app=hip&amp;ct=MainChassis&amp;snb=Properties&amp;lsnb=PowerButton</xsl:attribute>
						</Data>
					</CustomButton>
		
					<script language="javascript">
					
						function initializationRoutine()
       						 {	
								 <xsl:if test="(/OMA/OMAUserRights = '7') and ($LCDLine='true')">  
			 						var maxLines = '<xsl:value-of select="LCDProps/LCDObj/maxLines"/>';
																
									for (var ii = 0; ii &lt; maxLines; ++ii) 
									{
										disableLCDSettings(ii);

									}
									
								 </xsl:if>
								 <xsl:if test="(LCDProps/LCDObj/lcdConfig) ">  

								document.getElementById("lcdConfig").disabled=true;

								    <xsl:if test="(/OMA/OMAUserRights = '7') ">  

									document.getElementById("lcdConfig").disabled=false;
									
								    </xsl:if>
										
							</xsl:if>

							}

												
						function validate() {
							
							var value=0;							
							<xsl:if test="/OMA/LCDProps/LCDObj/lcdKVMStatus ='255' ">	
								 value = -1;
							</xsl:if>

							var KVMState = document.createElement("input");
							KVMState.setAttribute("type","hidden");
							KVMState.setAttribute("id","KVM");
							KVMState.setAttribute("value",value);
							KVMState.setAttribute("name","KVM");
							document.getElementById("dataarea").appendChild(KVMState);
							
							var returnVal = true;
							
							if (typeof(ValidateLcdLines) == "function") {
								returnVal = ValidateLcdLines();
							}

							return returnVal;
						}
					</script>
		
					<xsl:choose>
						<xsl:when test="$controlsNotAvailable = 'true'">
							<!-- no information available: -->
							<PromptText><xsl:value-of select="$strNoInfoAvailable"/></PromptText>
						</xsl:when>
						<xsl:otherwise>
							<!-- draw Buttons table -->
							<xsl:apply-templates select="ChassisProps/ChassisInfo/ChassisProps2"/>
							<!-- draw LCD info -->
							<xsl:if test="$LCDLine='true'">
							<xsl:apply-templates select="LCDProps"/>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</DataArea>
	</xsl:template>

	<xsl:template match="ChassisProps2">
		<xsl:choose>
			<xsl:when test="PowerButtonControl = '0' and NMIButtonControl = '0'"/>
			<xsl:when test="$allowEdits = 'true'">
				<TableData name="buttonsTbl" display="{$strFrontPanelButtons}">
					<SubHeader display="{$strFrontPanelButtons}"/>
					<!-- draw row for power button -->
					<xsl:if test="PowerButtonControl != '0'">
						<Row>
							<Data name="oid" type="hidden" returnvalue="{@oid}"/>
							<Data name="pwrbtnctrl" display="{$strPowerButton}" value="{$strPowerButton}"/>
							<Data name="PowerButtonControl" returnvalue="1" type="radio" value="{$strEnabled}">
								<xsl:if test="PowerButtonControl = '1'">
									<xsl:attribute name="state">1</xsl:attribute>
								</xsl:if>
							</Data>
							<Data name="PowerButtonControl" returnvalue="2" type="radio" value="{$strDisabled}">
								<xsl:if test="PowerButtonControl = '2'">
									<xsl:attribute name="state">1</xsl:attribute>
								</xsl:if>
							</Data>
						</Row>
					</xsl:if>
					<!-- draw row for NMI button -->
					<xsl:if test="NMIButtonControl != '0'">
						<Row>
							<Data name="oid" type="hidden" returnvalue="{@oid}"/>
							<Data type="ustring" name="nmibtnctrl" display="{$strNMIButton}" value="{$strNMIButton}"/>
							<Data name="NMIButtonControl" returnvalue="1" type="radio" value="{$strEnabled}">
								<xsl:if test="NMIButtonControl = '1'">
									<xsl:attribute name="state">1</xsl:attribute>
								</xsl:if>
							</Data>
							<Data name="NMIButtonControl" returnvalue="2" type="radio" value="{$strDisabled}">
								<xsl:if test="NMIButtonControl = '2'">
									<xsl:attribute name="state">1</xsl:attribute>
								</xsl:if>
							</Data>
						</Row>
					</xsl:if>
				</TableData>
			</xsl:when>
			<xsl:otherwise>
				<ListData type='custom'>
					<SubHeader display="{$strFrontPanelButtons}"/>
					<!-- draw row for power button -->
					<xsl:if test="PowerButtonControl != '0'">
						<Data display="{$strPowerButton}" width="65%">
							<xsl:if test="PowerButtonControl = 1"><xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute></xsl:if>
							<xsl:if test="PowerButtonControl = 2"><xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute></xsl:if>
						</Data>
					</xsl:if>
					<!-- draw row for NMI button -->
					<xsl:if test="NMIButtonControl != '0'">
						<Data display="{$strNMIButton}" width="65%">
							<xsl:if test="NMIButtonControl = 1"><xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute></xsl:if>
							<xsl:if test="NMIButtonControl = 2"><xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute></xsl:if>
						</Data>
					</xsl:if>
				</ListData>
				<xsl:if test="/OMA/LCDProps/LCDObj/lcdAccessState !='255' and /OMA/LCDProps/LCDObj/maxLines &gt; '0'">	
				<ListData type='custom'>
					
					<SubHeader display="{$strSecurityAccess}"/>					
						<Data display="{$strSecurityAccess}" width="65%">
							<xsl:if test="/OMA/LCDProps/LCDObj/lcdAccessState='0'"><xsl:attribute name="value"><xsl:value-of select="$strViewModify"/></xsl:attribute></xsl:if>
							<xsl:if test="/OMA/LCDProps/LCDObj/lcdAccessState='1'"><xsl:attribute name="value"><xsl:value-of select="$strView"/></xsl:attribute></xsl:if>
							<xsl:if test="/OMA/LCDProps/LCDObj/lcdAccessState='2'"><xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute></xsl:if>						
						</Data>
				</ListData>
				</xsl:if>					
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="LCDProps">
		<xsl:variable name="lcdConfigCustomVal" select="'0'"/>
		<xsl:variable name="lcdConfigDefaultVal" select="'1'"/>
		<xsl:variable name="lcdConfigNoneVal" select="'2'"/>
		
		<xsl:variable name="lcdConfigiDracIPv4Address" select="'4'"/>
		<xsl:variable name="lcdConfigiDracMacAddress" select="'8'"/>
		<xsl:variable name="lcdConfigServiceTag" select="'32'"/>
		<xsl:variable name="lcdConfigSystemName" select="'16'"/>
		<xsl:variable name="lcdConfigiDracIPv6Address" select="'64'"/>
		<xsl:variable name="lcdConfigAmbientTemperature" select="'128'"/>
		<xsl:variable name="lcdConfigSystemPower" select="'256'"/>
		<xsl:variable name="lcdConfigAssetTag" select="'512'"/>
	
		<xsl:choose>
			<xsl:when test="not(LCDObj) or LCDObj/maxLines &lt; 1"/>
			<xsl:when test="$allowEdits = 'true'">
				<xsl:variable name="lcdCharsetAscii" select="'0'"/>
				<xsl:variable name="lcdSelect" select="'LcdLineoption_'"/>
				<xsl:variable name="lcdEditBoxName" select="'LcdLineEdit_'"/>
				<xsl:variable name="lcdMaxlinesHdnName" select="'LcdMaxLines'"/>
				<xsl:variable name="lcdCharsetHdnName" select="'LcdOldCharSet'"/>
				<script language="javascript">
				
<!-- Called by Initialization routine to disable the editbox if the selected LCD option is other than Custom -->


function disableLCDSettings(index)
{

var editbox = document.getElementById("<xsl:value-of select="$lcdEditBoxName"/>" + index);
var lcdoption = document.getElementById("<xsl:value-of select="$lcdSelect"/>" + index);

if(lcdoption.value != 0 )    
	editbox.style.visibility='hidden';
else
	editbox.style.visibility='visible';


}
	
<!-- Enable the editbox if the selected LCD option is Custom -->
function ChangeEditBoxVisibility(option, x)
        { 
	  	var boxid= "<xsl:value-of select="$lcdEditBoxName"/>" +x;
		var editbox = document.getElementById(boxid);

      		 if(option.value==0)
			{ 
			editbox.style.visibility='visible';
			editbox.disabled=false;
			editbox.focus();
			editbox.select();

			}

		else
			editbox.style.visibility='hidden';
        }

   
	function ValidateLcdLines() 
	{
			
		var editbox, tempObj, maxLines = 0 ,editboxText , charSet=0,returnVal = true,lcdoption, char1, errorsText = "", badEditbox = null; 
   	
		tempObj = document.getElementById("<xsl:value-of select="$lcdMaxlinesHdnName"/>");
	
		if (tempObj != null)
		 {
			maxLines = tempObj.value;
		}
	
		tempObj = document.getElementById("<xsl:value-of select="$lcdCharsetHdnName"/>");
	
		if (tempObj != null)
		{
			charSet = tempObj.value;
		}
	
	for (var ii = 0; ii &lt; maxLines; ++ii) 
	{	
		lcdoption = document.getElementById("<xsl:value-of select="$lcdSelect"/>" + ii);
		editbox = document.getElementById("<xsl:value-of select="$lcdEditBoxName"/>" + ii);
	
		if (lcdoption != null &amp;&amp; editbox != null)
		{
			if (lcdoption.value == 0) {
       		 
			editboxText = editbox.value;
				switch (charSet) 
				 {
       					case "<xsl:value-of select="$lcdCharsetAscii"/>":
					                   // make sure text in editbox is ASCII:
							   for (var jj = 0; jj &lt; editboxText.length; ++jj) 
							   {
							   char1 = editboxText.charCodeAt(jj);
							   if (char1 &lt; 0x20 /* space */ || char1 &gt; 0x7e) 
							      {
								if (errorsText.length &gt; 0) 
								   {
									errorsText += "\n";
								   }
								  errorsText += "<xsl:value-of select="$strJScriptErr1Part1"/> " + (ii + 1) + " <xsl:value-of select="$strJScriptErr1Part2"/>";
								  returnVal = false;
								  if (badEditbox == null) 
								    {
									badEditbox = editbox;
								    }
								   break;
							       }

							     }
										
							     break;
					 default:
							returnVal = false;
				  }//end of switch

		    }//end of if

		} //end of If
	}//end of For


	if (returnVal == false &amp;&amp; errorsText.length &gt; 0) 
	{
        	errorsText += "\n\n<xsl:value-of select="$strJScriptErr1Part3"/>";
		alert(errorsText);
		if (badEditbox != null) 
		{
		badEditbox.focus();
		badEditbox.select();
		}
	}

	return returnVal;

    }//End of Func
</script>

				<xsl:call-template name="FPSecurityAccess"/>
				<TableData name="lcdTbl" display="{$strFrontPanelLCD}">
					<SubHeader display="{$strFrontPanelLCD}"/>
					<xsl:for-each select="LCDLineObj">
						<xsl:sort select="index" data-type="number"/>
						<xsl:variable name="lcdid">
							<xsl:choose>
								<xsl:when test="index"><xsl:value-of select="index"/></xsl:when>
								<xsl:otherwise><xsl:value-of select="position() - 1"/></xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<Row>
						<Data  width="36%" display="{$strLcdLine} {position()}" value="{$strLcdLine} {position()}"/>

						<Data name="{$lcdSelect}{$lcdid}"  id="{$lcdSelect}{$lcdid}"  type="select" editable="true"  event="onChange" handler="javascript:ChangeEditBoxVisibility(this, {$lcdid})">
		 			
		<Choice returnvalue="{$lcdConfigNoneVal}" >
			<xsl:attribute name="value"><xsl:value-of select="$strLcdConfigNone"/></xsl:attribute>
			<xsl:if test="state = $lcdConfigNoneVal">
					<xsl:attribute name="default">true</xsl:attribute>
			</xsl:if>
		</Choice>

		<Choice returnvalue="{$lcdConfigDefaultVal}">
			<xsl:attribute name="value"><xsl:value-of select="$strLcdConfigDefault"/></xsl:attribute>
			<xsl:if test="state = $lcdConfigDefaultVal">
				<xsl:attribute name="default">true</xsl:attribute>
			</xsl:if>
		</Choice>
		
		<xsl:if test="capabilities/serviceTag='true'">
		<Choice returnvalue="{$lcdConfigServiceTag}">
				<xsl:attribute name="value"><xsl:value-of select="$strLcdConfigServiceTag"/></xsl:attribute>
				<xsl:if test="state = $lcdConfigServiceTag">
					<xsl:attribute name="default">true</xsl:attribute>
				</xsl:if>
		</Choice>
		</xsl:if>

		<xsl:if test="capabilities/systemName='true'">
		<Choice returnvalue="{$lcdConfigSystemName}">
					<xsl:attribute name="value"><xsl:value-of select="$strLcdConfigSystemName"/></xsl:attribute>
				<xsl:if test="state = $lcdConfigSystemName">
					<xsl:attribute name="default">true</xsl:attribute>
				</xsl:if>
		
		</Choice>
		</xsl:if>

		<xsl:if test="capabilities/systemPower='true'">
		<Choice returnvalue="{$lcdConfigSystemPower}">
					<xsl:attribute name="value"><xsl:value-of select="$strLcdConfigSystemPower"/></xsl:attribute>
					<xsl:if test="state = $lcdConfigSystemPower">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				
		</Choice>
		</xsl:if>

		<xsl:if test="capabilities/assetTag='true'">
		<Choice returnvalue="{$lcdConfigAssetTag}">
					<xsl:attribute name="value"><xsl:value-of select="$strLcdConfigAssetTag"/></xsl:attribute>
					<xsl:if test="state = $lcdConfigAssetTag">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				
		</Choice>
		</xsl:if>

		<xsl:if test="capabilities/ambientTemperature='true'">
		<Choice returnvalue="{$lcdConfigAmbientTemperature}">
				

				<xsl:attribute name="value"><xsl:value-of select="$strLcdConfigAmbientTemperature"/></xsl:attribute>
					<xsl:if test="state = $lcdConfigAmbientTemperature">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				
		</Choice>
		</xsl:if>
		
		<xsl:if test="capabilities/iDracMacAddress='true'">
		<Choice returnvalue="{$lcdConfigiDracMacAddress}">
				
					<xsl:attribute name="value"><xsl:value-of select="$strLcdConfigiDRACMACAddress"/></xsl:attribute>
					<xsl:if test="state = $lcdConfigiDracMacAddress">
							<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				
		</Choice>
		</xsl:if>

		<xsl:if test="capabilities/iDracIPv4Address='true'">
		<Choice returnvalue="{$lcdConfigiDracIPv4Address}">
				
					<xsl:attribute name="value"><xsl:value-of select="$strLcdConfigiDRACIPv4Address"/></xsl:attribute>
					<xsl:if test="state = $lcdConfigiDracIPv4Address">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				
		</Choice>
		</xsl:if>

		<xsl:if test="capabilities/iDracIPv6Address='true'">
		<Choice returnvalue="{$lcdConfigiDracIPv6Address}">
				
					<xsl:attribute name="value"><xsl:value-of select="$strLcdConfigiDRACIPv6Address"/></xsl:attribute>
					<xsl:if test="state = $lcdConfigiDracIPv6Address">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				
		</Choice>
		</xsl:if>

		<Choice returnvalue="{$lcdConfigCustomVal}">
				<xsl:attribute name="value"><xsl:value-of select="$strLcdConfigCustom"/></xsl:attribute>
				<xsl:if test="state = $lcdConfigCustomVal">
					<xsl:attribute name="default">true</xsl:attribute>
		
				</xsl:if>
		</Choice>

		</Data>
								
	 
  
	       <Data name="{$lcdEditBoxName}{$lcdid}" type="editbox" >
			<xsl:attribute name="size">20</xsl:attribute>
			<xsl:attribute name="id"><xsl:value-of select="$lcdEditBoxName"/><xsl:value-of select="$lcdid"/></xsl:attribute>
			 <xsl:attribute name="maxlength"><xsl:value-of select="maxLineSize"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="LCDstring"/></xsl:attribute>
			<xsl:attribute name="state">
			<xsl:choose>
			<xsl:when test="state != $lcdConfigCustomVal">2</xsl:when>
			<xsl:otherwise>1</xsl:otherwise>
			</xsl:choose>
			</xsl:attribute>
		</Data>	
			
	</Row>
</xsl:for-each>
				</TableData>
				<HiddenTable>
					<Data id="{$lcdMaxlinesHdnName}" name="{$lcdMaxlinesHdnName}" returnvalue="{LCDObj/maxLines}"/>
					<Data id="{$lcdCharsetHdnName}" name="{$lcdCharsetHdnName}" returnvalue="{LCDObj/charSet}"/>
					<xsl:for-each select="LCDLineObj">
						<xsl:sort select="index" data-type="number"/>
						<xsl:variable name="lcdid">
							<xsl:choose>
								<xsl:when test="index"><xsl:value-of select="index"/></xsl:when>
								<xsl:otherwise><xsl:value-of select="position() - 1"/></xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<Data id="LcdLineOldState_{$lcdid}" name="LcdLineOldState_{$lcdid}" returnvalue="{state}"/>
						<Data id="LcdLineOldString_{$lcdid}" name="LcdLineOldString_{$lcdid}" returnvalue="{LCDstring}"/>
					</xsl:for-each>
				</HiddenTable>
			</xsl:when>
			<xsl:otherwise>	<!-- list info only -->
				<ListData type='custom'>
					<SubHeader display="{$strFrontPanelLCD}"/>
					<xsl:for-each select="LCDLineObj">
						<xsl:sort select="index" data-type="number"/>
						<Data display="{$strLcdLine} {position()}"  width="65%">
							<xsl:attribute name="value">
								<xsl:choose>
									<xsl:when test="state = $lcdConfigCustomVal">
										<xsl:value-of select="LCDstring"/>
									</xsl:when>
									<xsl:when test="state = $lcdConfigDefaultVal">
										<xsl:value-of select="$strLcdConfigDefaultSettings"/>
									</xsl:when>
									<xsl:when test="state = $lcdConfigNoneVal">
										<xsl:value-of select="$strLcdConfigNone"/>
									</xsl:when>
									<xsl:when test="state = $lcdConfigServiceTag">
										<xsl:value-of select="$strLcdConfigServiceTag"/>
									</xsl:when>

																	
									<xsl:when test="state = $lcdConfigSystemName">
										<xsl:value-of select="$strLcdConfigSystemName"/>
									</xsl:when>

									<xsl:when test="state = $lcdConfigSystemPower">
										<xsl:value-of select="$strLcdConfigSystemPower"/>
									</xsl:when>

									<xsl:when test="state = $lcdConfigAssetTag">
										<xsl:value-of select="$strLcdConfigAssetTag"/>
									</xsl:when>

									<xsl:when test="state = $lcdConfigAmbientTemperature">
										<xsl:value-of select="$strLcdConfigAmbientTemperature"/>
									</xsl:when>

									<xsl:when test="state = $lcdConfigiDracIPv4Address">
										<xsl:value-of select="$strLcdConfigiDRACIPv4Address"/>
									</xsl:when>

									<xsl:when test="state = $lcdConfigiDracIPv6Address">
										<xsl:value-of select="$strLcdConfigiDRACIPv6Address"/>
									</xsl:when>

									<xsl:when test="state = $lcdConfigiDracMacAddress">
										<xsl:value-of select="$strLcdConfigiDRACMACAddress"/>
									</xsl:when>

									
								</xsl:choose>
							</xsl:attribute>
						</Data>
					</xsl:for-each>
				</ListData>
			</xsl:otherwise>
		</xsl:choose>
<xsl:call-template name="IndicateRemoteSession"/>
	</xsl:template>

<!-- This template is used to display the table to Indicate remote kvm session  based on disney object lcdConfig-->

<xsl:template name="IndicateRemoteSession">
<xsl:if test="LCDObj/lcdKVMStatus != '255'">
	<xsl:choose>
		<xsl:when test="$allowEdits = 'true'">
			
			<TableData name="KVMTable" display="{$strIndicateRemoteSession}">
				<SubHeader display="{$strIndicateRemoteSession}"/>
			<!--PromptText><xsl:value-of select="$strPromptRemoteIndication"/></PromptText-->
			
		 	 <Row>
				<Data ignoreonweb="true">
					<xsl:if test="LCDObj/lcdKVMStatus = 1">
						<xsl:attribute name="value"><xsl:value-of select="$strActive"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="LCDObj/lcdKVMStatus = 0">
						<xsl:attribute name="value"><xsl:value-of select="$strInActive"/></xsl:attribute>
					</xsl:if>
				</Data>
				<Data ignoreoncli="true" width="42%"><xsl:attribute name="value"><xsl:value-of select="$strRemoteUserSession"/></xsl:attribute></Data>			
				<Data ignoreoncli="true" display="{$strRemoteUserSession}" type="checkbox" name="lcdConfig"  editable="true" returnvalue="1">
					<xsl:if test="LCDObj/lcdKVMStatus = 0"><xsl:attribute name="state">0</xsl:attribute></xsl:if>
					<xsl:if test="LCDObj/lcdKVMStatus = 1"><xsl:attribute name="state">1</xsl:attribute></xsl:if>
				</Data>
			</Row>	
			</TableData>
	</xsl:when>
	<xsl:otherwise> <!-- list data only -->
		<xsl:if test="/OMA/LCDProps/LCDObj/lcdKVMStatus !='255' ">	
				<ListData type='custom'>
					<SubHeader display="{$strRemoteUserSession}"/>					
					<Data display="{$strRemoteUserSession}" width="65%">
						<xsl:if test="LCDObj/lcdKVMStatus = 0"><xsl:attribute name="value"><xsl:value-of select="$strInActive"/></xsl:attribute></xsl:if>
						<xsl:if test="LCDObj/lcdKVMStatus = 1"><xsl:attribute name="value"><xsl:value-of select="$strActive"/></xsl:attribute></xsl:if>
					</Data>	
				</ListData>
		</xsl:if>					
	</xsl:otherwise>
	</xsl:choose>
</xsl:if>

</xsl:template>

<!-- The following template displays Front Panel Security Access Table-->

<xsl:template name="FPSecurityAccess">
	<xsl:if test="LCDObj/lcdAccessState !='255' ">
		<TableData name="AccessRights" display="{$strSecurityAccess}">
			<SubHeader display="{$strSecurityAccess}"/>
			<Row>
			       <Data name="lcdAccess" type="radio" >
					<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
					<xsl:attribute name="returnvalue">2</xsl:attribute>
					<xsl:if test="LCDObj/lcdAccessState=2">
						<xsl:attribute name="state">1</xsl:attribute>
					</xsl:if>
				</Data>	
			</Row>

			<Row>
			       <Data name="lcdAccess" type="radio" >
					<xsl:attribute name="value"><xsl:value-of select="$strView"/></xsl:attribute>
					<xsl:attribute name="returnvalue">1</xsl:attribute>
					<xsl:if test="LCDObj/lcdAccessState=1">
						<xsl:attribute name="state">1</xsl:attribute>
					</xsl:if>
				</Data>	
			</Row>


			<Row>
			       <Data name="lcdAccess" type="radio" >
					<xsl:attribute name="value"><xsl:value-of select="$strViewModify"/></xsl:attribute>
					<xsl:attribute name="returnvalue">0</xsl:attribute>
					<xsl:if test="LCDObj/lcdAccessState=0">
						<xsl:attribute name="state">1</xsl:attribute>
					</xsl:if>
				</Data>	
			</Row>
		</TableData>
	</xsl:if>
</xsl:template>
</xsl:stylesheet>
