<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/OMA">
		<DataArea>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strOperatingSystemInformation"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.OSInfoWebPlugin&amp;help=OSInfo</xsl:attribute>
				</Data>
			</CustomButton>
			<ListData  type="custom">
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strHostName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="SystemInfo/SystemName"/></xsl:attribute>
				</Data>
				<xsl:apply-templates select="OSInfo"/>
				<xsl:apply-templates select="SystemInfo"/>
			</ListData>
		</DataArea>
	</xsl:template>
	
	<xsl:template match="OSInfo">
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strOperatingSystem"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="OSName"/></xsl:attribute>
		</Data>
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strOperatingSystemVersion"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="OSVersion"/></xsl:attribute>
		</Data>
	</xsl:template>
	<xsl:template match="SystemInfo">
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strSystemTime"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="SystemTime"/></xsl:attribute>
		</Data>				
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strSystemBootupTime"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="SystemBootupTime"/></xsl:attribute>
		</Data>				
	</xsl:template>
	<xsl:template match="*"/>
</xsl:stylesheet>
