<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>
<xsl:output method="xml" indent="no"/>
<xsl:template match="/OMA">
	<xsl:choose>
		<xsl:when test="SMStatus != '0'">
			<DataArea printable="false">
				<TableData>
					<Header>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strError1"/></xsl:attribute>
						</Data>
					</Header>
					<Row>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strNICObjectNot"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strNICObjectNot1"/></xsl:attribute>
						</Data>
					</Row>
				</TableData>
			</DataArea>
		</xsl:when>
		<xsl:otherwise>
			<DataArea>
				<PageTitle>
					<xsl:attribute name="display"><xsl:value-of select="$strNetworkCardsInformation"/></xsl:attribute>
				</PageTitle>
				<CustomButton>
					<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
						<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.NICListWebPlugin&amp;help=NIC&amp;</xsl:attribute>
					</Data>
				</CustomButton>
				<!--xsl:call-template name="MainHeading"/-->
				<xsl:if test="/OMA/DevNicObj">
					<xsl:call-template name="NICList"/>
				</xsl:if>
				<xsl:if test="/OMA/VirNicObj">
				<xsl:call-template name="TeamList"/>
				</xsl:if>
			</DataArea>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="MainHeading">
	<ListData type="custom">
		<Data width="300">
			<xsl:attribute name="display"><xsl:value-of select="$strTotalNumberOf"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="ObjCount"/></xsl:attribute>
		</Data>
	</ListData>
</xsl:template>
<xsl:template name="NICList">
	<TableData columnspacing="true" name="NIC">
		<xsl:attribute name="display"><xsl:value-of select="$strPhysicalNICInterface"/></xsl:attribute>
		<SubHeader value="PHYNIC">
                   <xsl:attribute name="display"><xsl:value-of select="$strPhysicalNICInterface"/></xsl:attribute>
	       </SubHeader>
		<PromptText><xsl:value-of select="$strClickTheIP"/></PromptText>
		<Header>
			<Data ignoreonweb="true">
				<xsl:attribute name="display"><xsl:value-of select="$strIndex"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strIndex1"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strInterfaceDesc"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strInterfaceDesc"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strVendor"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strVendor1"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strDescription"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strDescription1"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strConnectionStatus"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strConnectionStatus"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strSlot"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strSlot"/></xsl:attribute>
			</Data>      
		</Header>
		<xsl:for-each select="DevNicObj">
		<xsl:call-template name="NetWorkAdpatorObj"/>		
		</xsl:for-each>
	</TableData>
</xsl:template>
<xsl:template name="TeamList">
	<TableData columnspacing="true" name="Team">
	<xsl:attribute name="display"><xsl:value-of select="$strTeamInterface"/></xsl:attribute>
		<SubHeader value="NICTeam">
                   <xsl:attribute name="display"><xsl:value-of select="$strTeamInterface"/></xsl:attribute>
	       </SubHeader>
		<PromptText><xsl:value-of select="$strClickTheTeamInterface"/></PromptText>
		<Header>
			<Data ignoreonweb="true">
				<xsl:attribute name="display"><xsl:value-of select="$strIndex"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strIndex1"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strInterfaceDesc"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strInterfaceDesc"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strVendor"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strVendor1"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strDescription"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strDescription1"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strRedundancyStatus"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strRedundancyStatus"/></xsl:attribute>
			</Data>
					
		</Header>
		<xsl:for-each select="VirNicObj">
		<xsl:call-template name="VirtualNetWorkAdpatorObj"/>		
		</xsl:for-each>
	</TableData>
</xsl:template>
<xsl:template name="NetWorkAdpatorObj">
	<Row>
		<Data ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="@instance"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="@instance"/></xsl:attribute>
		</Data>
		<Data>
		  <xsl:attribute name="display"><xsl:value-of select="IfDescription"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="IfDescription"/></xsl:attribute>
			<xsl:attribute name="link">true</xsl:attribute>
			<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.NICCardWebPlugin&amp;help=NICInfo&amp;ons=<xsl:value-of select="@ons"/></xsl:attribute>
		</Data>
		<Data name="Vendor" type="ustring"><xsl:attribute name="display"><xsl:value-of select="$strVendor2"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="OSAdapterVendor"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="OSAdapterVendor"/></xsl:attribute>
		</Data>
		<Data name="Description" type="ustring"><xsl:attribute name="display"><xsl:value-of select="$strDescription2"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="OSAdapterDescription"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="OSAdapterDescription"/></xsl:attribute>
		</Data>
		<Data name="Connection Status" type="ustring"><xsl:attribute name="display"><xsl:value-of select="$strConnectionStatus2"/></xsl:attribute>
			<xsl:choose>
				<xsl:when test="nicStatus='0'">
					<xsl:attribute name="display"><xsl:value-of select="$strNotObtained"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strNotObtained"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="nicStatus='1'">
					<xsl:attribute name="display"><xsl:value-of select="$strConnected"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strConnected1"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="nicStatus='2'">
					<xsl:attribute name="display"><xsl:value-of select="$strDisconnected"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strDisconnected1"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="nicStatus='3'">
					<xsl:attribute name="display"><xsl:value-of select="$strDriverNotInstalled"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strDriverNotInstalled1"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="nicStatus='4'">
					<xsl:attribute name="display"><xsl:value-of select="$strDisabled"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strDisabled1"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="nicStatus='10'">
					<xsl:attribute name="display"><xsl:value-of select="$strInitializing"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strInitializing1"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="nicStatus='11'">
					<xsl:attribute name="display"><xsl:value-of select="$strResetting"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strResetting1"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="nicStatus='12'">
					<xsl:attribute name="display"><xsl:value-of select="$strClosing"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strClosing1"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="nicStatus='13'">
					<xsl:attribute name="display"><xsl:value-of select="$strAdapterNotReady"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strAdapterNotReady1"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="display"><xsl:value-of select="$strNoValue2"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strNoValue3"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</Data>
		<Data>
		  <xsl:attribute name="display"><xsl:value-of select="SlotName"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="SlotName"/></xsl:attribute>
		</Data>    
	</Row>
</xsl:template>

<xsl:template name="VirtualNetWorkAdpatorObj">
	<Row>
		<Data ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="@instance"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="@instance"/></xsl:attribute>
		</Data>
		<Data>
		  <xsl:attribute name="display"><xsl:value-of select="IfDescription"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="IfDescription"/></xsl:attribute>
			<xsl:attribute name="link">true</xsl:attribute>
			<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.NICCardWebPlugin&amp;help=NICInfo&amp;ons=<xsl:value-of select="@ons"/></xsl:attribute>
		</Data>
		<Data name="Vendor" type="ustring"><xsl:attribute name="display"><xsl:value-of select="$strVendor2"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="OSAdapterVendor"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="OSAdapterVendor"/></xsl:attribute>
		</Data>
		<Data name="Description" type="ustring"><xsl:attribute name="display"><xsl:value-of select="$strDescription2"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="OSAdapterDescription"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="OSAdapterDescription"/></xsl:attribute>
		</Data>
		<Data name="Redundancy Status" type="ustring"><xsl:attribute name="display"><xsl:value-of select="$strRedundancyStatus"/></xsl:attribute>
			
				<xsl:choose>
					<xsl:when test="teamRedundancyStatus='0'">
					<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="teamRedundancyStatus='1'">
						<xsl:attribute name="value"><xsl:value-of select="$strUnknown"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="teamRedundancyStatus='2'">
						<xsl:attribute name="value"><xsl:value-of select="$strFull"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="teamRedundancyStatus='3'">
						<xsl:attribute name="value"><xsl:value-of select="$strDegraded"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="teamRedundancyStatus='4'">
						<xsl:attribute name="value"><xsl:value-of select="$strLost"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="teamRedundancyStatus='5'">
						<xsl:attribute name="value"><xsl:value-of select="$strFailed"/></xsl:attribute>
					</xsl:when>					
					<xsl:otherwise>
						<xsl:attribute name="value"><xsl:value-of select="$strNoValue3"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>

		</Data>
				
	</Row>
</xsl:template>


<xsl:template match="*"/>
</xsl:stylesheet>
